/* HiringPanel.h
Copyright (c) 2014 by Michael Zahniser

Endless Sky is free software: you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or (at your option) any later version.

Endless Sky is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details.
*/

#ifndef HIRING_PANEL_H_
#define HIRING_PANEL_H_

#include "Panel.h"

class PlayerInfo;



// This panel is drawn as an overlay on top of the PlanetPanel. It shows your
// current crew and passengers and allows you to hire extra crew if you are
// hunting other ships to capture.
class HiringPanel : public Panel {
public:
	HiringPanel(PlayerInfo &player);
	
	virtual void Step() override;
	virtual void Draw() const override;
	
	
protected:
	// Only override the ones you need; the default action is to return false.
	virtual bool KeyDown(SDL_Keycode key, Uint16 mod, const Command &command) override;
	virtual bool Click(int x, int y) override;
	
	
private:
	PlayerInfo &player;
	
	mutable int maxHire;
	mutable int maxFire;
};



#endif
