/*
 * GkDebconf -- Help to configure packages with debconf
 * Copyleft (C) 2003 Agney Lopes Roth Ferraz <agney@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <gtk/gtk.h>

#include "../config.h"
#include "defines.h"

#include "files.h"
#include "interface.h"

/*
 * A pointer to the main window.
 */
GtkWidget *main_window;

/* Migrate existing GConf settings.  */
static gchar *
migrate_gconf_settings (const gchar *name)
{
  gboolean needed = TRUE;
  GError *error = NULL;
  GKeyFile *kf;
  gchar **list;
  gchar *msg = NULL;
  gsize i, n;

  kf = g_key_file_new ();

  if (!g_key_file_load_from_data_dirs (kf, "gsettings-data-convert",
                                       NULL, G_KEY_FILE_NONE, NULL))
    {
      g_key_file_free (kf);
      return NULL;
    }

  list = g_key_file_get_string_list (kf, "State", "converted", &n, NULL);

  if (list)
    {
      for (i = 0; i < n; i++)
        if (!g_strcmp0 (list[i], name))
          {
            needed = FALSE;
            break;
          }

      g_strfreev (list);
    }

  g_key_file_free (kf);

  if (needed)
    {
      g_spawn_command_line_sync ("gsettings-data-convert",
                                 NULL, NULL, NULL, &error);
      if (error)
        {
          msg = g_strdup_printf (_("Could not migrate old GConf settings: %s\n"
                                   "Please make sure that GConf is installed "
                                   "and the gsettings-data-convert tool is in "
                                   "your PATH.\nAlternatively, ignore this "
                                   "message and convert your old settings "
                                   "manually."), error->message);
          g_error_free (error);
        }
      else
        {
          msg = g_strdup (_("Old GConf settings were migrated successfully."));

          /* Allow some time for the GSettings backend to record the
             changes, otherwise the default values from the new schema
             might be set.  */
          sleep (1);
        }
    }

  return msg;
}

/**
 * main:
 * @argc: Array with parameters given to gkdebconf
 * @argv: number of parameters given to gkdebconf
 *
 * This function is the first called funcion when gkdebconf starts.
 * Returns: 1 if exit normally, another number otherwise
 */

int
main (int argc, char **argv)
{
  GtkWidget *splashwin;
  gchar *gconf_migration_msg = NULL;

  /*
   * Gettext stuff
   */
  bindtextdomain (PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);

  gtk_set_locale();

  gtk_init (&argc, &argv);

  gconf_migration_msg = migrate_gconf_settings ("gkdebconf.convert");

  /*
   * shows a splash screen
   */
  splashwin = gk_splash ();
  gtk_widget_show_now (splashwin);

  while (gtk_events_pending())
    gtk_main_iteration();

  /*
   * creates main window check the gtk signal bindings done in this
   * function to know what functions are calledto detect the packages
   * that are configurable    and sort them
   */

  main_window = create_main_window();

  if (gconf_migration_msg)
    {
      GtkWidget *dlg;

      dlg = gtk_message_dialog_new (GTK_WINDOW (main_window),
                                    GTK_DIALOG_DESTROY_WITH_PARENT,
                                    GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE,
                                    "%s", gconf_migration_msg);
      g_free (gconf_migration_msg);
      gtk_dialog_run (GTK_DIALOG (dlg));
      gtk_widget_destroy (dlg);
    }

  /*
   * destroy splash and show main
   */
  gtk_widget_destroy (splashwin);
  gtk_widget_show (main_window);

  /*
   *	let's use the program
   */
  gtk_main();
  return 0;
}
