# InVesalius

InVesalius generates 3D medical imaging reconstructions based on a sequence of 2D DICOM files acquired with CT or MRI equipments.  InVesalius is internationalized (currently available in English, Portuguese, French, German, Spanish, Catalan, Romanian, Korean, Italian and Czech), multi-platform (GNU Linux, Windows and MacOS) and provides several tools:
  * DICOM-support including: (a) ACR-NEMA version 1 and 2; (b) DICOM version 3.0 (including various encodings of JPEG -lossless and lossy-, RLE)
  * Support to Analyze files
  * Support to BMP, PNG, JPEG and TIF files
  * Image manipulation facilities (zoom, pan, rotation, brightness/contrast, etc)
  * Segmentation based on 2D slices
  * Pre-defined threshold ranges according to tissue of interest
  * Segmentation based on watershed
  * Edition tools (similar to Paint Brush) based on 2D slices
  * Linear and angular measurement tool
  * Volume reorientation tool
  * 3D surface creation
  * 3D surface volume measurement
  * 3D surface connectivity tools
  * 3D surface exportation (including: binary and ASCII STL, PLY, OBJ, VRML, Inventor)
  * High-quality volume rendering projection
  * Pre-defined volume rendering presets
  * Volume rendering crop plane
  * Picture exportation (including: BMP, TIFF, JPG, PostScript, POV-Ray)

### Development

* [Running InVesalius 3 in Linux](https://github.com/invesalius/invesalius3/wiki/Running-InVesalius-3-in-Linux)
* [Running InVesalius 3 in Mac](https://github.com/invesalius/invesalius3/wiki/Running-InVesalius-3-in-Mac)
* [Running InVesalius 3 in Windows](https://github.com/invesalius/invesalius3/wiki/Running-InVesalius-3-in-Windows)
