--[[
Copyright (c) 2006-2018 LOVE Development Team

This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
--]]

-- Make sure love exists.
local love = require("love")

function love.nogame()

	R = {}

	R.bg = {[1]={}, [2]={}}

	-- cloud_1.png
	R.bg[1].cloud_1_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAALEAAABUCAYAAADNoNb0AAAGqElEQVR4nO3de6wcVR0H8M\
	+lL20bX1iItFANVEEkpai1tWBJg6JEkxrwCWrAlEpMNdHYaDSpJjU+Eo0mmqBi+odKUuID\
	Y4xExFdjhJJqRYKCYkzUP6RCedWalkv949wmze3O3t3ZmXNm7/19kv3j7u7M+e293zs7c2\
	bOmYljx44JYZydUrqAEEYVIQ5jL0Icxl6EOIy9+aULaMiZeA0uwCq8GMuwBEtPeN9BPIR/\
	4s+4F3fiHjydsd7QoIkx7Z04BRvxNrweK0dc30H8DN/Hj/HEiOsLGY1biE/HNlyHF7TUxp\
	PYja9gf0ttlLQEF2IFnotn4L/4Dx6QvqGeKlZdDeMS4rPwCbwbizK2ext2YG/GNttwrvSt\
	dSXO1/9Y6BD24LtTj8dar25EXQ/xYmyfejyzYB278WH8q2ANdazDJ3F5zeUP4UZ8XjqW6K\
	Quh/hifNvo+7tNeQIfwdfR2V/alOfgS3hPQ+t7FB/D13Tws3cxxPPxKXxUN7sAfyjtkz9S\
	upAKG3ALzmhh3T/Cu3RsF6NrIX629Ad4XelCZvB3XIE/Fa5juqtwMxa02MYf8QYd2rXqUo\
	hXSt1b55cuZECPYzN+UbqQKW/CrfJ8e92PS3AgQ1sz6kqIz8EvsbxwHcM6jDfi5zWXn8Bq\
	6ZtntfQPvFz6RlogdX09Jp2c2T/1uA1/m7ae1fitvAe/e7BJB7rjuhDiFdIv5IWF66jrMF\
	6L3wyxzEpslQ686uy73oNv4Sb8D/vw0hrrGdVnpQO+okqHeLEU4ItKFtGAR7FeOlHQz1nY\
	iWukrfConpQC/eoG1lXHJF6OPxRqH+VDfDPeUbKABt2PtdK+8nTzpO65HdIZstnkdoUPxE\
	uG+P3Sqd3Z5BbpzNiJzph6fkP+crJZh7tKNV6qH/ZF+Fyhttv0VrzzhJ8vkP64sznAcH3J\
	xktsiSeko/lLczecycPSpaDHD1ifVbacLB6XLn09UqLxElviq8zeAMOpUq/B7eZGgEmfc2\
	2pxnOHeAE+k7nNEt6M00oXkdm6Ug3nDvG1ODtzmyGP80o1nDPEE/hgxvZCXm1ccDSQnCG+\
	VJmzSiGPpTO/pR05Q7w1Y1shvybOQNaSK8SLpMv3wuy1QRo5fknuhnOFeJO50900l70Kv8\
	YXpFPtWeQKcWyF55YPSYNMswQ5V4iLdYSHYjbjyzkaynHaeaE0yHJh2w2FTroCP2mzgRxb\
	4vNEgOeyL2o5ZzlCvCJDG6G7ztXy9cY5QnxmhjZCt72lzZW3NSvm86XJT14mXQwT5rbLpQ\
	G1d0pzvjWqyQO75bhaGtmwRsEzOKHT7sIPsEtDU2M1EeKX4ON4u3Yn7Qizy1F8B5/GX0dZ\
	0SghXipNN/UBs2ey7pDfUak/eYc0z8bQ6oZ4rfRfdE6dhUPo4UFpV3TfsAvW6Z24Rho7Fg\
	EOTTpbmoDm6mEXHDbEN0gzz8TJi9CGRdJ0vtuGWWiY3Ykt0ty8IeSwRRpwO6NBQ7wJP5Xx\
	8row5z2Nywww6+ggIV6G+6QTGCHk9JA0AU3f/uRB9olvFAEOZZyGr870ppm2xJtwR1MVhV\
	DTZfrkcKYQ341XNF1RCEO6W5+BFf12JzaKAIdueKWUx576hfiG5msJobb3Vb1QtTuxWDoi\
	XNJWRSEM6ZDUU3Z4+gtVW+KNIsChW5ZIHQ0n6RfiELrm4l5PVoX4whYLCaGuNb2erArxqh\
	YLCaGunrmsCvHpLRYSQl09c1nVO1H8Do0hVDhp7GYX72IfwlCqQnxSX1wIHdAzl1UhPthi\
	ISHU1TOXVSF+oMVCQqirZy6rQnxfi4WEUFfPXFaFeE+LhYRQV89cVnWxLcO/xVRUoTuOSf\
	3EB6a/ULUlPiBGdIRuuUOPANO/n3hXO7WEUEtlHvsNT1ooTfQW8wuH0v4hzTh1pNeL/bbE\
	R7CzjYpCGNJOFQFm5oGi87AXFzVcVAiD+p00SHSy6g0zXTsxieul6TdDyO2olL/KADPYBU\
	D7sL2JikIY0nYDTPU66FxsE/gG3jtiUSEM6pvSpIIzBnSYWTHnYTeurF9XCAP5njThdt/d\
	iOOGuZ54cmrFA023GUJNNxkiwAx/UfyktInfpk+XRwg1HJFytcUQAWa0G8+skWbMjJuPh1\
	HtxVbsr7PwKMOTfo/1uE66aUgIw3pQys96NQNMczdjnI/NuFa6j2/cEixUeUq668Au3Dr1\
	80iavKPocc+TZhDaKN0WdxVOFdNizUWH8DD+gnvxq6nHI0020kaIQ8gqhuyHsRchDmMvQh\
	zGXoQ4jL3/A4htWI/rxYLaAAAAAElFTkSuQmCC\
	")
	-- cloud_1@2x.png
	R.bg[2].cloud_1_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAAWIAAACoCAYAAADaWOQcAAAOEElEQVR4nO3debQfZX3H8f\
	cl4SZkITkmshmwIYgBTVgLZRMwBiwuOaCCqCig4illq2KL2x+etmqtWFcqirGlLlXcDngE\
	BbHUKEKhKkILFRO2YpEkEiGQQLjpH98bEvAmmZnfzDyzvF/n3HNzYGaeLwn5/J77zLMMrV\
	+/HklSOtukLkCS+s4glqTEDGJJSswglqTEDGJJSswglqTEDGJJSswglqTEDGJJSmx86gK0\
	WeOA3YF5wB+Nfu0G7Ag8a/RrMrDdM+77PfDk6PeVwP3A/45+3QPcNvr1aMX1S8poyCXOjb\
	EHcCjwJ8DBwAuACRW1tR5YCvwS+DGwBLgJWFdRe5K2wCBOZwrwUuBY4Biit5vSaiKQrwa+\
	CSxLW47UHwZxvSYDxwOvIcJ3YtpytugXRCB/FbgjcS1SpxnE9TgEeDNwIjA1cS1FLAE+B3\
	wdx5al0hnE1RkGTgLOA/ZPXEtZVgGLgY8RL/7UfNsSL3xfCMwlXvruRLzsnUT8fwrwCPAQ\
	8FvgbuBO4h3Cz4CHa624hwzi8m0HnAG8A9g1cS1VeQL4IvBh4PbEtegPvRBYBLyEePH7zJ\
	k1eYwQgXwt8F3gOuLPXyUyiMszHngb8F6ix9EH64GvAO8B7kpbSu/NAk4F3kTMwKnKCuAy\
	4BLg5grb6RWDuBzHA38HPC91IYmsBT4BfID48Vb1ORA4H3g1Mfe8TjcAFwLfIHrOKsggHs\
	wc4FPENDTBcuCdwD8lrqMP9iY++BalLoRYIPQu4IrUhbSVQVzMOOAC4H1Ut+iiza4mhmmc\
	i1y+qcBfA2dRfw94a64BzgR+lbqQtjGI85tL9PgOTlxH060G3g18khhL1uAWAl8AnpO6kC\
	1YS7wn+SgOV2RmEOfzFiJYmrwQo2m+Q7xAWpm6kBYbD3yImInTFj8EXgf8X+pC2sAgzmYK\
	8Fng5NSFtNR9xO/dktSFtNAMYiHNUYnrKOI3xIvsG1IX0nQG8dbNBi4n5maquCeBc4FPpy\
	6kReYA3xv93laPAacQMyu0Ge5HvGUvInYlM4QHN46YYfIJmveSqYnmET9BtDmEIRaTfA14\
	Q+pCmswe8eadSKwe2zZ1IR10JbH826WzY9sDuB6YmbqQEo0AbwS+lLqQJjKIx3Yu8A/AUO\
	pCOuwm4DjgwdSFNMxziDHVJs+MKGoEeAWxVFqbMIj/0AXAB1MX0RO3Ai+mOWE8AZgP7Ac8\
	n+iZ7kycijIN2J6NH85riPHPB4mZAfcC/wP8N7FRzp0F2p9EDEfsV/i/oPlWA4cR26xqlE\
	H8dIZw/VKG8TjgCGJ+7gLgAMo7Pmw58BPgKuKF29IM93wFeG1J7TfZMmJptlMaRxnEG50D\
	fDx1ET11K3Ak9fzFHAIOJ+Y2L6K+cdifA/9KjJHeN8a/fwux53NffIPYH0MYxBucAlyauo\
	ieu4HoGVe18fwU4HTgbKrdnWxrRog9GT5FLAmGmCJ5KzE00Sen4b4kgEEM8SPplTg7ogmu\
	IBYAPFniM6cTm/OfR4zzNsl/snHfiAWJa0nhd8BewAOpC0mt70E8l5gmND11IXrKRylnKe\
	8w0ft9H80LYG30BeInlV7rcxBPA/6D/u4h3GSvJQ4tLepo4DPAnuWUowqtJ16S/ix1ISn1\
	dWXdEDE2ZQg302JiGlleG/YEuRZDuC2GgPenLiK1vvaIzwf+PnUR2qKlwL5kX323P9GLTv\
	kiTsXtA9ySuohU+tgj3hf429RFaKt2J06LzuI0YqzfEG6vNm3xWbq+9YgnEm+q90pdiDJb\
	ROx+N5ZtiJ9s3l5fOarIGmIVYy/PPOxbj/j9GMJt83lghzH++TDwZQzhrphIP1YVjqlPQb\
	wvPf/xp6VmEhswbWqY2Cz9pPrLUYV6++fZl6GJbYiVWwemLkSFHQVcx8YQfkXSalSFEeKD\
	93epC6lbX3rEp2IIt92nidWPF2MId9U2xAZMvdOHHvFU4njvHVMXooHdhB+oXXcR8Oepi6\
	hbH3rE78AQ7gpDuPsOSV1ACl3vEc8kNuh2rwGpHR4HJgPrUhdSp673iM/HEJbaZJhYzNMr\
	XQ7iacCZqYuQlJtB3CFnEC/qJLVLFw9O3aKuBvF44ugjSe0zI3UBdetqEL8cmJW6CEmF9O\
	3IqM4G8RmpC5BU2MTUBdSti0G8K/DS1EVIKmxN6gLq1sUgPpHY9V9SOw2nLqBuXQzik1MX\
	IGkg7yI26erNniJdW1k3mzhiR1I3/DuxHuC21IVUqWs94penLkBSqV5EnKrzTjo85Ni1ID\
	4udQGSSjcMfBj4Fh2d2taloYmJxIbSvZv6IvXIjcAxwKrUhZSpSz3iAzGEpa47CPg+sH3q\
	QsrUpSA+InUBkmpxEHFc1rjUhZSlS0F8eOoCJNVmIfA3qYsoS5fGiO8Hdk5dhKTarAeOBH\
	6UupBBdSWIdwAeSF2EpNrdDswHnkhdyCC6MjQxP3UBkpKYSwcOgOhKEO+ZugBJyVxAy/en\
	6EoQz0ldgKRkdgJOSl3EILoSxL0740rS05yWuoBBdCWInS0h9dtRxEv7VupKEO+YugBJSQ\
	0Bx6Yuoqi2B/EUYsaEQSzp0NQFFNWmecSTgMOI3+w/BvbBA0IlbfQwcBXwU+B6YvvMtUkr\
	yqjpQbwL8CpgEbGEeULaciS1yBoimL8FfAdYmbaczWtiEA8T4Xs6sIAObwYtqTbriF3bLg\
	KuBEbSlvN0TQri6cDZxCqZnRLXIqm7lhGB/BngkcS1AM0I4inA+cB5wLTEtUjqjxXEDm4X\
	A4+lLCRlEA8Rww8foMXz/yS13n3Ae4B/IXZ0q12qIJ4LLAYOSdG4JI3hOuCtwK/qbrjuec\
	RDwNuBn2MIS2qWI4FfAGdR8ySBOnvEM4iu/5/W1aAkFXQF8CbiQOLK1RXE84FvA7PraEyS\
	SvBr4JXAf1XdUB1DE8cASzCEJbXLHGKF3oKqG6o6iE8mVrRMrbgdSarC9sQCkBOqbKTKIH\
	498EVg2wrbkKSqbQtcRmRaJaoaIz4e+Drt391NkjZYR2y/cHnZD64iiI8ArqHlZ0hJ0hge\
	AxYCPy7zoWUH8RzgRuBZZT5UkhpkBXAgcFdZDyxz6GAysd2cISypy2YQwxPblfXAMoP4k8\
	C8Ep8nSU01j8i8UpQ1NPFq4q2iJPXJCcRIwEDKCOJnEytPZg76IElqmeXAXqPfCytjaOJC\
	DGFJ/TQT+MigDxm0R3wYsXxZkvrsYGLGWCGD9IiHiN6wJPXdhwa5eZAgXkR8CkhS3x0NHF\
	v05kGGJm4G9i96syR1zM3EQo/civaIF2IIS9KmDgAOLXJj0SA+q+B9ktRl5xS5qcjQxCzg\
	Hmo+00mSWmAd8Fzg/jw3FekRn4IhLEljGU8ciJFLkSDO3Ygk9chr8t6Qd2hiDnBn3kYkqW\
	d2A+7NenHeHvHLcl4vSX30yjwX5w3il+S8XpL66Mg8F+cZmhgCVgLT81YkST3zG2CXrBfn\
	6RHviSEsSVnsDMzOenGeIN4vfy2S1FuZlzvnCeK9CxQiSX21Z9YL8wTx8woUIkl9tXvWC/\
	ME8XMLFCJJfbVH1gvzBPGOBQqRpL6alfXCPEE8o0AhktRXk7NemCeIpxUoRJL6alLWC/Ms\
	6BjolFFJ6qFMO1UOcmadJKkEBrEkJZYniJ+orApJ6p7Hs16YJ4hXFChEkvoqc2bmCeLlBQ\
	qRpL7KnJl5gjjzbvOSJO7JemGeIF5aoBBJ6qu7sl6YJ4jvyF+HJPXW7VkvzBPEtxQoRJL6\
	KnNm5llZNxV4COceS9LWjBAnGj2c5eI8ofow9oolKYtbyBjCkL93e13O6yWpj/4tz8V5g/\
	jKnNdLUh9dlefiPGPEABOBB4Dt89wkST3ye2AHYG3WG/L2iNcAl+e8R5L65HJyhDAUmwHx\
	5QL3SFJf5M7IvEMTEOG9DNgt742S1HH3ALOJ6WuZFekRjwCfLXCfJHXdxeQMYSjWI4Y4SP\
	RuchyOJ0kdt5oYKViZ98aiq+RWAJcUvFeSuugSCoQwFO8RQ0zPWIq9YklaTYwNP1jk5kH2\
	jfgtcOEA90tSV3yEgiEMg/WIASYR22POGuQhktRi9wJzgUeLPmDQndQeBc4e8BmS1GbnME\
	AIQzlbWn4buKyE50hS21xGZOBABh2a2GAGse3bLmU8TJJa4H5gPiWccF/WJu8rgDdQYCKz\
	JLXQCJF5A4cwlHvaxg+BC0p8niQ11V8RmVeKsoYmnnoe8M/AKWU+VJIa5FLgVKC08Cw7iA\
	GGge8CC8p+sCQl9gPgOODxMh9aRRBDrLa7FjioiodLUgI3Akcz4FS1sVR1IvNq4Bjghoqe\
	L0l1+imRaaWHMFQXxACrgBcD11TYhiRV7RpiqHVVVQ1UGcQQnx4vAxZX3I4kVWExkWGV9I\
	Q3qDqIIQa13wz8BbCuhvYkaVDrgPOI7Cr1xdxYqnpZtzmHA1/CY5YkNdfdxGKNJXU1WEeP\
	eFNLiCWBl9bcriRlcSmwDzWGMNTfI97UQuAfgTmpCpCkUb8G/gy4OkXjdfeIN3U1sDfwl1\
	T4NlKStmAVkUF7kyiEIW2PeFPTiYHxc0d/LUlVegj4OPCx0V8n1ZQg3mAKcDpwJvD8xLVI\
	6p47gIuIaWmPJK7lKU0L4k0dAbweOAF4duJaJLXXg8A3iRlbP0pcy5iaHMQbjAMOAY4lVu\
	odAExIWpGkJlsL3Ezsd/M94HrgyaQVbUUbgviZJhBT4OYBLyCOsN4V2AGYSRxoKqnbHgWW\
	E6fJ3wssA24DfkmcFrQ2XWn5tTGIJalTUk5fkyRhEEtScgaxJCVmEEtSYgaxJCVmEEtSYg\
	axJCVmEEtSYgaxJCX2/5ixqodpMZm+AAAAAElFTkSuQmCC\
	")
	-- cloud_2.png
	R.bg[1].cloud_2_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAALEAAABUCAYAAADNoNb0AAAF0klEQVR4nO3dW4hVVRzH8e\
	8cc2w0M6uZhjE1m0lNsbLsOj5FXgoyKlMLSqMxYx6znsughzDMh56sibALFSEUpFQiFUVk\
	SdJDNF2s7DZYUGNTDU7j9PA/kWSkc87/v9dl/z/gy6hr/w/nx5q1115r7YaRkRGcS1kldA\
	HO1ctD7JLnIXbJ8xC75J0QuoCSOxdYDMwHzgfagFOARuAw0A/sB3qB94FdwN7q37mqBp+d\
	KFwLcBdwK9BRw///FngaeAzYp1hXsjzExWkGNgB3ID1tvYaRMG8AvlRoL1keYnsNQDfwID\
	DJoP0/qm0/BPxp0H70PMS2TgWeBK4t4FrvAKuQ4UapeIjtzABeB9oLvOYPwFLgowKvGZyH\
	2MZsYCcwJcC1DwJXIbMZpeAhPloTcAky5XUeMBM4o/rzCcCvwG/Ad8BXSK+3G/gQGKr+2/\
	eA6QXXfaSfgE7g04A1FMZDLE4GlgPLkHnbphraOAi8ikybzdcrrWa9wAJgIHQh1soe4g5g\
	PXAbMD5wLRa2AqtDF2GtrCFuAR4AuoAxgWuxthi5wcxWGUO8GngEmBy6kIL0AnORhyNZKt\
	MCoInAC8i8bVkCDDALuCl0EZbK0hOfBWxHFtyU0V7iuNk0UYaeeB7yNKusAQa4AJkyzFLu\
	Ie5Ali+2hS4kAitCF2Al5xA3I3flp4cuJBJLQhdgJYcx8XhkUn8O8ph3IrJovBN58ubEYW\
	QVXXYPP1Ld2dEI3IhMl10JjA1bThIqyEzFntCFaEttOFEB1iI7Gp5FfkV6gI/fzNAFWEip\
	J25HdjJcFrqQhDWHLsBCKiFeBLyILNRxtTspdAEWUhhOLANewQOsIYXve9Ri/1BXID2wj3\
	t1tFPbMtOoxRziZmAbHmBNa5Cb4rXE/d2PSswf5FFkl4TT1QpsAd4CpgWuRUWsDzs6gbdD\
	F1ECPwPXA2+GLqQesfbE94UuoCQmA68hN8/JirEnPoeSbHCMyCHkwdEbgeuoSYw98fLQBZ\
	RQIzILlOQYOcYQZ7vaKnKnAc8gx24lJbYQV4CLQxdRYguBO0MXMVqxjYmnUMKzxCLTB5yN\
	HFTYBIxDDoyJdqNpLGsnpgFXV/+4sFqBz5DNBOOO+Pnv1Z9/jMwx7wQ+L7y6/xCyJz4RuB\
	lYB1waqghXl93A48BTwGCoIkKEuIIcNH0/vvctF33IYd9bCPAqhqJDPBs598F73jx9gLzG\
	4ZMiL1rk7MRK5EN6gPO1APmObynyokWFeD3wHHI0qsvbBGS++Z6iLlhEiO8GHi7gOi4uG5\
	HOy5z1mHgF8LzlBVz0VmGcAcsQz0LGR1nu63LHbQC4EJljNmE1nKgAT+ABdpKBrRiuybAK\
	8Rpkf5xzIMcs3G7VuMVwohF5HDlVu2GXtG+QAx4PaTds0ROvxAPsjjYVyYY6ixCvM2jT5a\
	HLolHt4UQbspQyuYXVrjBnIu8AVKPdEy/FA+z+3yLtBrVDfLlyey4/C7Ub1A7xPOX2XH7m\
	aDeoHeIZyu25/HRoN6h9YzdMfJtPXVyGkGcJarRDHNWuUxct1Zt/7zVd8rRD/Ityey4/6h\
	nRDvF+5fZcftQzoh1iPwjQHYt6RrRD/K5yey4/6hnRDvEu5fZcftQzYrGe+AvkLC/n/m0f\
	8vIbVRZTbD0Gbbo8mGTDoiduAb5Gzlpz7m+DwHTggHbDFj3xAWCzQbsubZsxCDDYbdmfhB\
	wB6gcGOoDvkdVr/RaNWz127ge6jdp26enGKMBgu3biJWCTYfsuDZuQLJixPsZqDPJq26Tf\
	k+Zq9jJwA8avSrBexTaMbNPeYXwdF58dyHdv/q6PIpZiDgLX4fPHZdKDfOeFvAKhqPXEQ8\
	iZA13IAXMuTwP88z0PFXXRohfF9wBzkXGyy8s25Lst/DduyLcnXQTciwz8x4YqwtVlCAnv\
	RmBPqCJieBljMzJ+ugY5t6I1bDnuGPqQ5ZTbkamzH8OWE0eInauLbxR1yfMQu+R5iF3yPM\
	QueX8BzokhiMHuRk0AAAAASUVORK5CYII=\
	")
	-- cloud_2@2x.png
	R.bg[2].cloud_2_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAAWIAAACoCAYAAADaWOQcAAAMXUlEQVR4nO3de6zf8x3H8e\
	fR9kQxpZ2WCkqrOlKrul9Kmds2m5lths0lw1oWhMzcZtnMNrK4zUzS2NjFzDW2mWxzN5Ni\
	ZshQrbmUMkxrSteq7o+PE1XV8/ud8/v93p/P9/t8JJKmOel55cjvdd6/z+/z/Xy6lixZgi\
	QpzkrRASSp7ixiSQpmEUtSMItYkoJZxJIUzCKWpGAWsSQFs4glKZhFLEnBBkYHkDIwANgU\
	2BLYGBgHrAuMANYEhizz9QuAV4AXgWeBp4B/Ag8B/wDe7ERoVUeXjzirprYA9gL2ALYDVm\
	nRv7sIeAC4DbgJ+CvwVov+bVWURaw6GQ8cDHwe2KhD3/Nl4FrgV8BfAF9weh+LWFU3EPgi\
	cDSwfXCWGcDFwKXA68FZlBGLWFXVDRwBnARsEJxlWXOBC4Dz3/mzas4iVtV0kSbgs4ANg7\
	P0Zh7wHeAiYGFwFgWyiFUlm5Le+u8SHaRJM4CpwK3RQRTDfcSqggHAKcCDlFfCAGOBW4Bp\
	wGrBWRTAiVilWw+4EtghOkiLzAIOBO6LDqLOcSJWyT5G2rNblRIGGE3a5nZEdBB1jkWsUk\
	0B/gR8ODpIG3STlikuJC27qOJcmlBpuoAzgdOig3TI9aRdIO6qqDCLWCXpIu2KmBIdpMNu\
	BvYF3ogOovZwaUIluZD6lTDA7qTJuDs6iNrDiVh9MZD0sMQmpA+X1gGGA2uTDs8ZyLvbsN\
	4gnVY2l3Ri2RxgNvAEMJN0elkjzgC+3Zr4xbqOdE7G29FB1FoWsRqxPrAbsC2wFTCB1h2h\
	+ipp/+904C7SjoHXlvmaQ4HLWvT9SncucGJ0CLWWRazlGQBMBj5DOipy4w5+77eA24HfA7\
	8lTdp34tvypR2Ov5gqxSLW0iYAR5Le/q4VnKXHImBQdIjMLCCdJPdgdBC1hkWsbuAg0jGR\
	WwdnUeMeAybibSCV4K6J+loNOIH0SO3PsIRLMw44OzqEWsOJuH4GAkcB3yTtclC5lgA7Av\
	dEB1H/WMT1sjfwI2BMdBC1zMOk+/cWRwdR37k0UQ8jgatJl1lawtUyHg8IKp4TcfUdSHos\
	eI3oIGqbF0iXofrBXaGciKvrQ8CvgSuwhKtubeBr0SHUd07E1bQZ6XHYsdFB1DEvkC5J9Z\
	S2AjkRV89+pMeFLeF6WRs4ODqE+sYirpbjgWuAVaODKMTU6ADqG4u4GrqAc4Dz8P9pnW0N\
	fDQ6hJrni7Z8PYelfz06iLJwYHQANc8P68r3E+p5WLqW7ynSWdEqiBNx2c7EEtZ7jQI2jw\
	6h5ljE5ToWOD06hLK0d3QANcciLtPepA/mpOXZNTqAmuMacd66SVvRhpAOA38dWJe0T3hI\
	YC7lbR4wFO+2K4ZFnId1gUmkO+HGkK4mGk3r7oVT/YwDHo8Oocb4Qo+zHWmr0SdJpSu10n\
	gs4mJYxJ21BvBV0sHsGwVnUbVtGh1AjbOIO2M4cBKphFcLzqJ6cC9xQSzi9uomHU/4LWD1\
	4Cyql/WiA6hxFnH7bAX8gvShidRpI6IDqHHuI269AcCppAsdLWFFGRYdQI1zIm6tNYHfAH\
	tEB1HtrRIdQI2ziFtnFPBHPJBdUpMs4tYYA9xOejBDkpriGnH/WcLKkTc6F8Qi7p9hpOUI\
	S1i5+V90ADXOIu67gcDV+ISc8rQOcD7uJy6CRdx3P8TjBpWvbuA4YBZwCb5ry5qnr/XNnq\
	QlCakU84GzSAPEouAsWoZF3LzVgUfwLZ/K9DBwKPD36CB6l0sTzfsBlrDKNZ50scCJpBvA\
	lQEn4uaMI03DA6KDSC1wHXAIadlCgZyIm/M9LGFVx2eBu4CR0UHqzom4cVsAD0SHkNrgSW\
	AvYGZ0kLpyIm7csdEBpDbZiPR06JjgHLXlRNyYYcBsYOXoIFIbPQXsAMwJzlE7TsSNOQhL\
	WNU3CvgDsGpwjtqxiBuzf3QAqUMmAJfj1raOsoh7NxyYFB1C6qD9geOjQ9SJRdy73fHnpP\
	o5mzQdqwMsmN7tEB1ACjCItEQxKDpIHVjEvds2OoAUZHPSo9BqM7evrdhA0k0HXimlunoT\
	GI1b2trKiXjFRmIJq94GA6dGh6g6J+IVmwTcGR1CCraI9NTdM0v9XRcwhLTn+C3S1Uyvv/\
	NnNclp74OtB3w6OoSUgUGkk9peBtYnPfgx+AO+di7wHOkpvRnAQ8B9wKPA223OWSwn4ncN\
	IRXvx4Gd8MxhqZXmAncANwG/A56PjZOXuhdxN+kowINJ1x91x8aRamEJcDdwGXAlnodc2y\
	IeAUx557+1g7NIdfZfYBpwAe9dg66VuhXxMOAU4Bg8xEfKySLgp6QLTp8NztJxdSnibtLG\
	9G+Q1oIl5WkB6fHqc4A3grN0TB2KeBvSb9rNooNIati/gKOAm6ODdEKVH+joJv1WvQdLWC\
	rNhsCfgYuowTJiVSfiUcC1wMTgHJL672FgP2BWdJB2qeJEvAtwP5awVBXjSa/p3aODtEvV\
	ivgA0tuZYdFBJLXUGqRrnA6PDtIOVSriqaTN4Z6fKlXTINIH70dHB2m1qhTxVODi6BCSOu\
	LHpNd8ZVThw7oDgCuozi8VSY35MvDL6BCtUHoRTwJuweUIqY4Wkc6IuT04R7+VXMQbkI7X\
	Wys6iKQw/yHtkHo6Okh/lPp2fhBwFZawVHdDSc8MFH1yYqlFfCbp0WVJ2hL4bnSI/ihxaW\
	IicC8wIDqIpGwsIX1mdHd0kL4orYgHkkp4i+ggkrLzKDABWBgdpFmlLU0chyUsafk+QuqI\
	4pQ0Ea8BzMTHlyV9sNeA0aSLTotR0kR8ApawpBVbHTgpOkSzSpmIh5H2Ca4aHURS9haQbm\
	EvZiouZSI+EktYUmNWprCDgUqYiAeQDoTeIDqIpGK8SJqKF0UHaUQJE/E+WMKSmjMC+FR0\
	iEaVUMRfig4gqUjFdEfuSxODgZdwfVhS8xYCw4F50UF6k/tEvCeWsKS+6Qb2iA7RiNyLeJ\
	/oAJKK9onoAI3IvYh3ig4gqWiTowM0Iuc14qHAK9EhJBVvJDAnOsSK5DwRbxcdQFIlbBkd\
	oDc5F/Fm0QEkVcLm0QF6k3MRj44OIKkSxkYH6I1FLKnqRkUH6E3ORexjzZJaYWR0gN7kXM\
	RDogNIqoTszzHPuYgHRweQVAlDowP0Jud9xNkGk1ScrugAK5LzRCxJtZBzEb8VHUBSJWTf\
	JTkX8fzoAJIqIfsuybmIsz9DVFIRXosO0Juci9gDfyS1QvZdknMRPxkdQFIlzIoO0Juciz\
	j7H56kImTfJTkX8czoAJIqIfsuybmI/xYdQFIlZN8lOT9ZN4C0c8LLQyX11XzSuTWLo4Os\
	SM4T8WJgenQISUWbTuYlDHkXMcBt0QEkFa2IDsm9iG+IDiCpaEV0SM5rxD0eAzaJDiGpOI\
	8D46JDNCL3iRjg2ugAkopUTHeUMBGPBp4g8/NEJWVlCbAxBTzMAWVMxLOAG6NDSCrKjRRS\
	wlBGEQNcFB1AUlGK6owSliYgLUs8AEyIDiIpew8CEynourVSJuIlwMnRISQV4WQKKmEoZy\
	LucRswOTqEpGzdDuwaHaJZpRXxROBe0jkUkrS0xcA2pGXMopSyNNHjAeC86BCSsnQuBZYw\
	lDcRAwwGHgLGRAeRlI2ZwObAm9FB+qK0iRjSD/owCjhRSVJHLCZ1QpElDGUWMcDdwOnRIS\
	Rl4TRSJxSrxKWJHl3AVcDnooNICnMN8AUK2662rJKLGGAV0pa2baKDSOq4e0lb1d6IDtJf\
	pRcxwFrAXXhUplQnjwOTgJeig7RCqWvES3sJ2J2CDviQ1C+zSK/5SpQwVKOIAWYDOwOPRA\
	eR1FaPkCbh2dFBWqkqRQzwPKmM74gOIqkt7iC9xudEB2m1KhUxwKvAnsC06CCSWmoa6bX9\
	anSQdqjCh3Uf5DDSmaSrBueQ1HfzgWOAy6ODtFOVixhgLOk36c7RQSQ17U7gSGBGdJB2q9\
	rSxLJmkI7NPAqYFxtFUoPmkV6zk6lBCUP1J+KljQBOAY4GBgVnkfR+i4CLge8DLwZn6ag6\
	FXGP9YEzgEOwkKUcLAR+DpwJPBOcJUQdi7jHcOArwBRSOUvqrGeAS4BLgX8HZwlV5yLusR\
	KwG7AfsC+wbmwcqdKeA24ArgduBd6OjZMHi/i9uoCtgB2B7YHtcFqW+uNpYDpwD+moyvsp\
	/KS0drCIJSlY1bevSVL2LGJJCmYRS1Iwi1iSglnEkhTMIpakYBaxJAWziCUpmEUsScH+D0\
	EmR28m6dqwAAAAAElFTkSuQmCC\
	")
	-- cloud_3.png
	R.bg[1].cloud_3_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAALEAAABUCAYAAADNoNb0AAAFhklEQVR4nO3dWYxfUxwH8E\
	+rElGh1tSe1NJUiMTEFtEmJR5ILEG8iC1p8SAhggdeRCW1e6JCiCdLBKkSsST2pfYtDCFE\
	SSNFhDZ9YOrhZGTKjLbTmfn9zr3n89zMfPs/3zn/c+89995pGzZs0DQ1mx4doGm2VitxU7\
	1W4qZ6rcRN9WZEB6jMLjgWR2EODsD+mImdRvy7dfgVq/AtPsOHeAM/T13cfpjWzk5s0gDO\
	xik4dAJ+3qdYgcfxzgT8vN5rJR7dzrgIlyqz7WQZxL24X5m5m3FoJd7Y7rgWi7D9FP7etV\
	iGm/HTFP7eTmglLrbDNbhKWd9G+R1LcTvWB+aoSisx83EfDooOMsKg8m3wanSQGvT5FNsM\
	3IaX5SowzFVyLdHOIG1SX2fi2XgUx0cH2Qyv4EysiQ6SVR9LPBcvYu/oIFvga5yML6ODZN\
	S3Eg/gWewWHWQc1mAhPokOkk2fSnwYXsOO0UG2whrlQPTz6CCZ9KXE++N1dS0hxrJKufS9\
	KjpIFn04OzETz+hGgWEfPKmc2270o8TLcEh0iAk2gLuiQ2TR9eXEhcq+hK46G49Fh4jW5R\
	LPVg6AZkUHmUS/YJ6e77fo8nLiTt0uMGV/89LoENG6OhMfgzejQ0yhp5Vz39PxI97FU/go\
	MtRU6WqJX8KC6BAJvKLszFsZHWQydXE5MV8r8LD5yjfSddFBJlMXS3xZdIBkpuMG3BEdZL\
	J0bTkxG99r2xfHcgEejA4x0bo2E5+nFfj/3KnOzU//q2slPi06QHKzdHC51aXlxO5YrXt/\
	mBPtG5N7B/eU69KAn6Bb/5/JMkfZRNQZXRr0I6MDVGROdICJ1KUSHx0doCILbPzYrarVvi\
	aehXNxDo7DtNg4VRlSbhR4CI8om4mqVGuJ91ae1HO+qX1ST1etwwO4STnPXpXaSrydcgn1\
	Su3OhsmwXnn60A0qegJRTSUewMM4MDpIDwwqF46q2DhUy4HdJcpGllbgqTFXuTN8cXSQzV\
	FDiZfgbmwbHaRntsU9uDE6yKZkX04sVZ5W2cS6BVdHhxhL5hJfrsPbByt0hbKBKJ2sJV6I\
	59Wx3OmLIeXS/kvBOf4jY4l3xcfYKzpI8x+rlWd4pHo1Q8aZbqlW4Kxm49boEP+WbSY+Em\
	9rl4+zOwIfRIcYlm0mvk4rcA2WRAcYKdNMfIjy0sKmDvPwRXQIcs3Ei6IDNFvk4ugAw7LM\
	xNPwA/aMDtJsth+VO0TCC5RlJh7QClybvZRxC5elxO2JPXWaHx2APCVu98fV6ajoAOQp8c\
	HRAZpxSfESyywl3jc6QDMu+0UHIM/ZiSHtIkeNhrBNdIgsM3ErcJ1S9CdFiKbZGllK/Ft0\
	gGZcUoxblhKvjg7QjEuKcctS4q+iAzTjkmLcspS4F2/56aAU45alxK9FB2jGJcW4ZTlPPB\
	NrtEdT1WS98uqEtdFBsszEa7E8OkSzRZZLUGDylJgOvtWn49KMV5blBOWq3efKc8Ca3AaV\
	25NSlCfTTLxBshsQmzEtkaTA5JqJKbPxO5LcMdCM6j1l/3ea4mSaiSkfzGL8GR2kGdWfyv\
	ikKTD5Sgzv4/roEM2orlfGJ5Vsy4lh0/EETo0O0vxjOc5Q9hCnkrXEsANelOQ+rp5bqTwR\
	84/oIKPJuJwY9gdOUsl7IzpspTIOKQtM7hJT9quegBXRQXpqhfL5p9g3PJbsJabMAKcrBx\
	V/BWfpi7+Uz/t0iWfgYZnXxKM5BstweHSQDvtIeVvVW9FBNlcNM/FIbykXQhbju+AsXfOd\
	8rkOqKjA1DcTjzQDZ+FCnKi+P8gMhvCC8krcx1R6kanmEo+0h3IEvUCZSeZq73wezTpl88\
	57eBnP4afQRBOgKyVueqx9BTfVayVuqtdK3FSvlbip3t9rOy6aUG6iAgAAAABJRU5ErkJg\
	gg==\
	")
	-- cloud_3@2x.png
	R.bg[2].cloud_3_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAAWIAAACoCAYAAADaWOQcAAALhklEQVR4nO3daaxdVRnG8f\
	8tpUUopdQKSEtb5qkBQSwEiUBDUagyiBIpiVZAQcBqkDAlihJAgZKIUEIIKE4Eq0yCTEJB\
	YtFiDEhoGVqGho7QkDKUoUDrh3Xh9HLnc88579p7/39Jk/bTfdqc/fS96661dtu6deuQJM\
	UZFB1AkqrOIpakYBaxJAWziCUpmEUsScEsYkkKZhFLUjCLWJKCWcSSFGxwdABVyghgF2BX\
	YBywDTAGGAWMBDYHNqXjgLAWeANYA7wFrACWAUuBxcBLwDzgKeDtVvwlpEZr84izmmRjYH\
	9g3/ZfewOjm/j11gLPAU8CjwIPAf8F3mvi15QawiJWo7SRyvYrwCHARGDD0ERpQn4EmA3c\
	TpqcpexYxBqINtLUOxU4Ctg6Nk6vFgC3ALcB/w7OIn3EIlY9tgFOBL4NjA3OUq+ngeuA3w\
	Irg7Oo4ixi9cchwA+AwynPjpv3SBPyL0nLGFLLWcTqzSDgWOAcYM/gLM32MPBz4F7AB0Mt\
	YxGrOx8W8E9I282q5HHgx8Cd0UFUDRaxunIQcDlpF0SVzQbOBB6LDqJys4i1vrHAFaQdEE\
	rWAb8HzgaWB2dRSZXlBy4amMGkye8pLOGPawO+SdqDPK39z1JDORFrF9LEt090kIL4O3Ay\
	8EJ0EJWHE3F1tZG2oj2OJdwfk4EngOOjg6g8nIiraSTpIMOXo4MU3PXAdNJlRFLdLOLq2R\
	u4leKeiMvNfOAY0kk9qS4uTVTLccA/sYQbaTdgLjAlOoiKyyKujvOBG4FPRAcpoeHAX4HT\
	o4OomFyaKL8NgGuAk6KDVMQM4Cw8Iq1+sIjLbQgwCzgyOkjFXE/a4vZBdBAVg0VcXkOAv5\
	Aualfr3Ug6CGIZq1euEZeTJRxvKvA70tKQ1COLuHw2IJ2Us4TjTQWuwmPR6oVFXD4zSddX\
	Kg+nAD+LDqG8uUZcLmcBl0SHUJe+Q3o1k9SJRVwex5DWhZWn94BJpAM1UgcWcTl8eLprWH\
	QQ9Wg56Yj5suggyotrxMU3nPTyS0s4f1sBt5B2tUgfsYiL7xpgx+gQ6rP9gMuiQygvLk0U\
	2zTgN9EhVJfJwP3RIZQHi7i4xgJPAptGB1FdlgATgFXRQRTPpYliaiNthbKEi2s0ac+3ZB\
	EX1Amkb21VbFOBL0WHUDyXJopnJPAs8MnoIGqIhaQlinejgyiOE3HxXIwlXCY7AGdGh1As\
	J+JimUB6g7CXyJTL26SL+7cCtgQ2Ad4H3iAd/ngGeAx4NSqgmssiLpY78d1oVbWO9J/wbc\
	AfgQWxcdRIFnFxHAg8FB1C2bgHuBCYEx1EA2cRF8cDpEtjpPX9GfghsDQ6iOpnERfDfsC/\
	okMoW6tIWxpvjQ6i+rhrohjOjQ6grI0gXSb00+AcqpMTcf62I+01daeE+uJq4LToEOofJ+\
	L8fR9LWH13KnBBdAj1jxNx3oaS9pFuHh1EhfN1fGNLYTgR5+0oLGHV53pgXHQI9Y1FnLdp\
	0QFUWMOBK6JDqG9cmsjXSGAFMDg6iArtYDwIlD0n4nwdjSWsgTs/OoB6ZxHn65joACqFg0\
	hv+VbGLOI8bUT6llJqhG9FB1DPLOI8HUgqY6kRvLEvcxZxnnwNkhppd9Jdx8qURZynA6ID\
	qHT2iA6g7lnE+dkY+Gx0CJXOLtEB1D2LOD974bY1Nd6o6ADqnkWcn72iA6iUhkcHUPcs4v\
	x8JjqASmky6U0eE/A2v+x4xDkPQ4FDgWNJJ+o2iY2jklsJ3AfMIr377t3YOLKIY32OdH/s\
	V/FbR8VYRbou8wZ8EWkYi7j1BgPHkd6isG9wFml9/wFmkF679H5wlkqxiFtnEHA86RKW7Y\
	OzSD1ZBFwM/BoLuSUs4taYAlwG7BodROqHhcAZwB3RQcrOIm6urYFf4U1qKra7ge+RJmU1\
	gdvXmudk4GksYRXfYcA8Uhm79a0JnIgbbzPS+8IsYJXRXaRrNVdGBykTi7ixJgJ/AsYH55\
	CaaTHwNWBudJCycGmicY4HHsYSVvmNAf5B+syrASzixjgX+APphJxUBUNJn/nzooOUgUsT\
	A/cL4OzoEFKgS4BzokMUmUU8MFcA06NDSBm4mnRaVHVwaaJ+F2EJSx86lfRMqA5OxPU5Db\
	gqOoSUodOBmdEhisYi7r/DgDvxuwmpK2uBI4C/RQcpEou4f3Yg3VA1IjqIlLFVpCteF0YH\
	KQqnur7bELgJS1jqzQjgZtzO2WcWcd9dgG9XlvpqD+DS6BBF4dJE3xwIzMb/uKT+mgQ8GB\
	0idxZx74YATwA7RweRCuh5YHfgneggOXPC690ZWMJSvbbDY9C9ciLu2RjgGWDj6CBSgb0D\
	7AS8FB0kV07EPbsQS1gaqI3w1F2PnIi7NxZ4jvTWZUkDs5a0xOfe4i44EXfvPCxhqVEG4V\
	pxt5yIu7Y18CLpEIekxlhD+rnLK9FBcuNE3LVpWMJSow0BTowOkSMn4s4Gkdaxto0OIpXQ\
	ItKWtrXRQXLiRNzZJCxhqVnGAZOjQ+TGIu7suOgAUskdHR0gNy5NdDQIWAZsER1EKrHlwG\
	hcnviIE3FHE7GEpWbbCtg/OkROLOKOpkQHkCri0OgAObGIOzogOoBUEU7E63GNuGYD0ite\
	hkUHkSrgTdKbPD6IDpIDJ+KaXbGEpVYZRrqnWFjE69snOoBUMXtGB8iFRVyzXXQAqWK2jw\
	6QC4u4Znx0AKliHH7aWcQ146MDSBVjEbeziGvGRAeQKmZ0dIBcWMQ1m0YHkCpmZHSAXFjE\
	NRtFB5AqZnh0gFx4oKPGfwip9dqiA+TAiViSglnEkhTMIq7xzLvUWj5z7SzimlejA0gV4z\
	PXziKu8UMhtZbPXDuLuGZJdACpYnzm2lnENYuiA0gV4zPXziKueS46gFQxPnPtLOKaedEB\
	pIrxmWtnEdc8Hh1AqhifuXYece5oBbBFdAipAl4GtowOkQsn4o7mRAeQKuKR6AA5sYg7ei\
	A6gFQR90cHyIlF3NG90QGkivBZW49F3NFC/Emu1GzzSM+a2lnEnd0cHUAqOZ+xj3HXRGc7\
	As9Gh5BKbCdgQXSInDgRd7YAd09IzTIHS7gTi7hrM6MDSCXls9UFlya6NgR4Efh0cA6pTJ\
	YB44E1wTmy40TctTXAjOgQUsnMwBLukhNx94aRbofyyLM0cC8D2wNvRgfJkRNx994ELowO\
	IZXERVjC3XIi7tkQ4EnSljZJ9VkATMBliW45EfdsDTA9OoRUcNOxhHtkEffuHmBWdAipoG\
	aRniH1wKWJvvkUMB8YFR1EKpCVwG7AK9FBcudE3DevACdEh5AK5gQs4T6xiPvuDuDK6BBS\
	QVxJembUBy5N9M8QYDbw+eggUsbmAJPwB3R9ZhH335bAXGBcdBApQ4uA/YDl0UGKxKWJ/l\
	sBHA68Fh1EysxrpGfDEu4ni7g+84EvAqujg0iZWE16JuZHBykii7h+c4EjgLeig0jB3iI9\
	C3OjgxSVa8QDty9wHzA8OogU4HXgUCzhAXEiHri5wP7A4uggUostJn32LeEBsogbYx4wEX\
	g0OojUIo+SPvO+9bwBLOLGWQZ8Abg2OojUZNeSPuvLooOUhWvEzfEN4Bpgs+ggUgO9BpwC\
	3BQdpGws4uYZTZocDo8OIjXAXcB3gSXRQcrIpYnmWQJMAY4FlgZnkeq1lPQZnoIl3DROxK\
	2xCfAj4Kz230u5Ww1cClyOB5eaziJurVHAmcDpWMjK02rgKtIbl1cGZ6kMizjGZsBJwGnA\
	tsFZJIAXgJnAdXiPSstZxLHagIOBacCReDpPrfU6cDtwA/AgYBkEsYjzMZR0h+thpCOjO8\
	fGUUk9QzqSfzfpbu13Y+MILOKcbUG6gH4vYE9SMW9Lupxe6s0a4HngWeB/wGOkC9tfjgyl\
	rlnEkhTMfcSSFMwilqRgFrEkBbOIJSmYRSxJwSxiSQpmEUtSMItYkoJZxJIU7P83pECPnM\
	xUCgAAAABJRU5ErkJggg==\
	")
	-- cloud_4.png
	R.bg[1].cloud_4_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAALEAAABUCAYAAADNoNb0AAAFz0lEQVR4nO3dW4hfxR0H8M\
	+mGhuNxqLWe0niNUaNEol3tJrY4L312tYbIlpB0BcVvDy1YIgoKqioEGKfKlgo2IcGqigY\
	xIiYxtYoahSLNWhDi7fqJnH7MCsmMSy7c+bc9v/7wJ9AsjPze/juyfzPmZkzNDIyIoQ+m9\
	J2ASFUFSEOvRchDr0XIQ69FyEOvbdD2wWESnbFcTgeczALM7Hb6GcII/h09PMx1uJt/B0v\
	YEPTRZc2FLfYeucwXIjzcYJq/5uOYA2exR/wSuXqWhAh7odpuAzX4eQax3kTT+Ix/KfGcY\
	qKEHfbNNyA27FPg+N+gYfxAD5qcNwsEeIydsGhOAgHYgamYzM+k+aj//LdfHR4HH1ejvuw\
	Xw31jteX+C3uN76aWxEhzvMDnC7NS0/BvNG/G4/NeB0r8BesxMYt/n0mluGnZUot4i38Bs\
	+3XMd2RYgn5hDchF9hz0J9foLleBwL8Kh0Z6FrRrAUd2FTy7VsJUI8Pkfid9KVd6jlWtr2\
	Ai7Gv9su5FsR4rHtgXtxjQjvlt7FYrzTdiEMVoh3kr7tT8VX0petsVwkfUPfu+a6+uoj/E\
	ya37dqMoZ4R5w0+lmAg6W7BtO2+blN+CfW4VW8jOek20v34uaG6u2z9ThVy1fkyRLiIZyJ\
	q3GedIsrx2Z8iJ8UqmsQvCc9Ofy4rQL6HuIdcCVuw+Et1zLIVuIMLd1L7vMqtsXSfGyZCH\
	DbTsaStgbv45X4R3gIV7RdSPieRfhr04P2LcTH4mnMbruQsF3rMFe6+9OYPk0nzpXmXhHg\
	7pqNO5setC9X4l9Lj2ZjEX/3DUuP5z9oasA+XInPEQHuk6m4tckBu34lnoeXfP9BRei2r6\
	SpRSNrkbt8JZ6BP4oA99EPcWNTg3U5xA9Ij4tDP12poUVTXQ3xQmnlWOivmTitiYG6GOIp\
	0naY0H8XNTFIF0N8OY5qu4hQxMImBuni3YnXcEzbRYRi9pc2ydama1fiE0WAJ5tT6h6gay\
	GORT2Tz5y6B+hSiIfw87aLCMUdVvcAXQrxXOzbdhGhuIPrHqBLIT6p7QJCLfaqe4A2FtUc\
	IE3250jP13eTHjHHvrbJade6B2gqxLOkTZy/lM4sC4Njet0D1H2feC7uxqXi8JFBdrh0nl\
	st6poT7yKd6Pg36VzdCPBg+4d0lsfOdXRex5X4SDyFI0p3HHrvDVwy+mcxpUO8SFoDXPtk\
	PvTWp9L0ckWpDkuG+Gz8STpGKoSxbMQv8OcSnZUK8QnSOWaxCyOM1/+kg8pXVe2oRIj3xG\
	pptVIIE/GhdJbIJ1U6KXF34gkR4JBnfyk/lVS9Ep+LZ6oWEQbe+SrkqEqIp0hvpax9qV2Y\
	9NZKt2a/yWlcZTpxgQhwKGOO9JbULFVCfH2FtiFsK/ucitzpxI+l0126tJQz9Ns30nryCZ\
	84nxvChRXahrA9U3BWbsMcjRyKEQbOqTmNckMci3tCHeblNMoNcSxsD3WYmdMo94vdsFjo\
	E+ox4bXnuSHu3LFBYdKYcIhzpxMR4lCHrFzlhvi/me1CGEtWrnJD3NhLRcJAycpVbojXZr\
	YLYSxZucoN8crMdiGMJStXuSF+LrNdCGPJylVuiN+QXg4eQimvy9zKX2URz/IKbUPY1vLc\
	hlV2dkzH+9gjt4MQRm2QHjl/ntO4ypX4cyyt0D6Eby2VGWCqbxSdKm3Xj21KIdda6T0tw7\
	kdVF3YPiy9NHFjxX7CYNoo5Sc7wJTZnbEKtxToJwyeWxQ4AajUFqNHsKRQX2EwLJFyU1nJ\
	fXJ34J6C/YXJ6x4pL0XUcT7xDXgQO5XuOPTe17gZj5XstK7XHRyDJ3F0HZ2HXlojvbdlde\
	mO69p2vxrzpd+69TWNEfphvZSD+WoIMM28oHwarsK1WFD3YKEzVmEZfi+dRVybJkK8pVk4\
	09bvsdtdO+/TC2VsknZkrJMeXLyIZ/FeUwU0HeIQioujqELvRYhD70WIQ+9FiEPvRYhD7/\
	0fHvIyRu6OJTkAAAAASUVORK5CYII=\
	")
	-- cloud_4@2x.png
	R.bg[2].cloud_4_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAAWIAAACoCAYAAADaWOQcAAAMOklEQVR4nO3de+zXVR3H8e\
	dP7oKCCoLITUEylJuXykQltQJvXbzNQZnlJS0vMFeuZWpO29yylO4zMZelkq2823Rqma6G\
	U1DLNPCSBojmBVkR6K8/zu9niL/r93Len8/3+3xsTOZl56VzLw7ncy4tra2tSJLibBUdQJ\
	KanUUsScEsYkkKZhFLUjCLWJKCWcSSFMwilqRgFrEkBbOIJSmYRSxJwSxiSQrWNzqApHcM\
	BHYDJrf9cTwwGtgJ2K7txzCgzxb/3FvAm8A6YC3wCrAKeLbtx0rgsbY/rwJq8dIfKcRWwB\
	7AAcCHgBnAFN5bsrW0ClgO/Al4EHgIeKOO46mHLGIpn52BOcBc4GDSDDfS28BS4C7gDuDP\
	pNm1MrOIpfoaAxwPHAt8MDhLd9YCvwaWAPeSiloZWMRS7fUHjgZOAg4FWmLjVOQFYDFwNW\
	mdWXVkEUu1Mxo4AzgVGBGcpVZaScsW3wHuDs7SsCxiqXqTgK8CJwL9grPU03LgW8CNuGxR\
	UxaxVLnxwEXAfOq726Fo/gp8E7iBNGNWlSxilclg3jvjfBPYlDnHMOAbwJc7yNNMlgILgA\
	eig5SdRawi2QWYCryPdKBhHDAWGE7a6tVZ6W0kHVZYS9or+3fSIYangEeBf9QoXwtwMnBp\
	WyYlNwILgRejg5SVRawo/YEPALOBWW0/r9e+2pdJs7f7gfvaft7bWfQU4CfA/jVN1jjWkd\
	bJf4zrx71mESunocAngKOAjwNDgnK8QdoJ8FvgduD1Lv7ePsC5pDXR/vWPVnoPkD5arowO\
	UiYWseqtL3AE8FngcIpXZhtIhfwz4He8e6Y8DvgFzoJ7ax1wFnBNcI7SsIhVLzsCXwJOIV\
	1aUwYvAt8nLUHMIh1oiD6GXGbXAacB66ODFJ1FrFobB3yN9NvTgcFZKvVfijdzL6vHgU8D\
	T0cHKTKLWLUymrSl6/M095YuvdfrpCPf90QHKSqLWNXamvQx6yukfb5SRzYCpwM/jQ5SRB\
	axqjEH+AFp/6/UExeSTiNqMxaxKjEM+B4wLzqISuly0u+iLJ82FnHj6U/60j+ItFbbn/TV\
	eh3wH6r/gn0IcC1pTViq1I9IN9VZQPhmXVkNBfYG9gR2Jx0HHku6hLy7ddpW4J/8/z2z50\
	jvmT1M11+2+wDnt/3w0VlV64ukicGC6CBF4Iy4HLYHPgp8BDiIVL718CqpkO8HbgWWkYp7\
	O+CXpNNwUi1dAnw9OkQ0i7i4RpGe1zmGdLggYha6inQE+EDSrFuqh9NJSxVNyyIulvbjwK\
	eSZp8uAagZvE26f+S26CBRLOJiGEo6CnwWaa1XajbrSTfw/SU6SASLONZQ0seKc9p+LjWz\
	p0ll/Fp0kNws4hh9SV+NL8ALxqXN3UK6KrWpisk1yPxmkV6NWIQlLG3pSNKtfU3FGXE+Q4\
	DLSF+IJXVuA7AvaX97U7CI89iPdMH4hOAcUlksI5XxxuggObg0UV8twHnAH7CEpd6YTrrR\
	ryk4I66fIaQ7GT4VHUQqqQ3ADODJ6CD15oy4PsYAf8QSlqoxALgiOkQOFnHt7Qk8BEyLDi\
	I1gI+RtrM1NJcmamsv4C7clibV0gpgCuktwYbkjLh2ZgD3YglLtTaR9BZiw3JGXBt7APdh\
	CUv18iLpBsB/RwepB2fE1RsN3IElLNXTzqSLsRqSM+LqDCbtjpgeHURqAs8Bk4BN0UFqzR\
	lx5VqAq7GEpVzGA8dFh6gHi7hyC2jQ/ymkAjs7OkA9uDRRmX1JSxL9ooNITWgm6QbDhuGM\
	uPe2Bq7DEpainBodoNYs4t67FB/SlCLNAwZGh6gli7h39gHOjA4hNbltgcOjQ9SSRdxzWw\
	E/xP9mUhEcGx2gliyVnptPmhFLincEMCg6RK1YxD0zCLgkOoSkdwwGZkeHqBWLuGdOI90x\
	LKk45kYHqBX3EXdvAPAsMCo4h6R3exqYHB2iFpwRd28elrBURLsBI6ND1IJF3L0F0QEkdW\
	pWdIBasIi7tj/p6SNJxfTh6AC1YBF37eToAJK6tFd0gFrwY13nBgFrgG2ig0jq1L+AHaJD\
	VMsZcecOwxKWim57GmBrqUXcuU9GB5DUI6XfwmYRd6wPDbRZXGpwu0QHqJZF3LGZNMC6k9\
	QkLOIGNTs6gKQeGxsdoFoWcccOiA4gqcdGRAeolkXcMa+7lMqj9MuIfaMDBBkOTCDdITEC\
	GLrZX2sFRgdkklQZi7gERgEHAfuRTuFM493FK6ncSt9jpf8X6MRU4DjgSGB6cBZJ9TUsOk\
	C1GqmItwVOJN0PMS04iyT1WCMU8U7AucApeCRZUgmVedfEMODbwEpgIZaw1Ky2AS4ChkQH\
	qVQZb19rIS0/XEra/SBJAKuA84Bro4P0VtmKeCKwGA9cSOrcnaQHf5+PDtJTZVqaOBFYhi\
	UsqWtzgMeAY6KD9FQZingAcBVwDTA4NoqkktgWWAIsAvoFZ+lW0ZcmhgO/Ib0dJ0mVuJs0\
	O349OkhnilzEY4B7gUnRQSSV3hOkJYsXooN0pKhFPIlUwqV/AkVSYawgXXFbuDIuYhGPAe\
	4Hdo0OIqnhrABmAaujg2yuaB/rhgJ3YQlLqo+JwO0U7ABYkYq4D3ATMCU6iKSGNhO4kdQ5\
	hVCkIr4MOCQ6hKSmMAe4IDpEu6KsER8J3BwdQlLTmUs6iReqCEU8Engc742QlN8aYA/glc\
	gQRViaWIQlLCnGSODK6BDRM+K5pC+YkhTpUOCeqMEji7gfaUliclQASWrzOGk3xaaIwSOX\
	Jr6AJSypGPYkdVKIqBlxf9LLGjtHDC5JHXiedOAj+6w4akb8GSxhScUyDpgfMXDUjPgJPE\
	EnqXiWATNyDxoxIz4AS1hSMU0H9ss9aEQRfy5gTEnqqewf7XIvTQwAXiI9YyJJRfQq6aDH\
	xlwD5p4RH4wlLKnYtiPzBWS5i3hu5vEkqRJzcg6Wu4gPzTyeJFVids7Bcq4R7wC8nGswSa\
	pCKzCCTLey5ZwR75NxLEmqRgsZ9xPnLOJpGceSpGpl66ycRfz+jGNJUrWm5hooZxFPyDiW\
	JFVrTK6Bchaxl/xIKpOxuQbKWcQ7ZBxLkqo1MtdAObevhb9SKkm9sAEYmGMgi1iSOteSY5\
	AivOIsSU3NIpakYDmLeEPGsSSpWtk6K2cRZzmzLUk1kq2zchbxmoxjSVK1snVWziJ+PuNY\
	klStbJ2Vs4ifyTiWJFUrW2flLOLlGceSpGpl66ycRfxoxrEkqVrZOivnybq+wGvA4FwDSl\
	KF1gPDgE05Bss5I94EPJhxPEmq1INkKmHIf7LuzszjSVIlsnZV7iK+LfN4klSJrF2Vu4j/\
	hrsnJBXbclJXZRNx6c/PA8aUpJ7K3lE5d0202xF4AeiXe2BJ6sZG0lt1L+UcNGJG/BKwJG\
	BcSerOEjKXMMTMiAFmAI9EDCxJXZhJwOGzqIvhHwVuCRpbkjpyC0EngKNmxJB+5XmYTG9C\
	SVIXWoG9CfqdeuRTSY8AiwPHl6R2iwlcLo2cEQOMBJ4knemWpAivAbsT+HhF9OOha4CFwR\
	kkNbeFBL8gFD0jhrRGfDNwRHQQSU3nVuAo0hpxmCIUMcAIYBmwU3QQSU1jFTAdWBsdJHpp\
	ot1a4GjSqRZJqreNpM4JL2EoThEDPAScER1CUlM4g9Q5hVCkIga4Crg4OoSkhnYxqWsKoy\
	hrxFu6EjgzOoSkhrMIOCs6xJaKNiNudzZwRXQISQ3lClK3FE5Ri7gVOAe4MDiHpMZwIalT\
	CrkEUNSlic3NJ63nDIgOIql0NgAnU/AHKcpQxAD7AL8CxkcHkVQazwHHAEujg3SnqEsTW1\
	pKusP4+uggkkrhelJnFL6EoTxFDOlijhNIv8KtDs4iqZhWkzriBFJnlEKZirjdTaSbki7H\
	k3iSko2kTtid1BGlUpY14s5MBM4nfdDrE5xFUn5vkT7EXQysCM5SsbIXcbtdSFtTTgK2Cc\
	4iqf7WkS5z/y7wTHCWqjVKEbcbDBwPzANmU86lF0kdexu4D7gOuAFYH5qmhhqtiDe3I3AY\
	MBc4EBgVG0dSBVYDvwfuAG4n4Kn7HBq5iLe0K+nB0qnAZGAC6amm4cC2cbGkpvcG8DLplY\
	xngaeAx0hvyK2Mi5VPMxWxJBWSa6iSFMwilqRgFrEkBbOIJSmYRSxJwSxiSQpmEUtSMItY\
	koJZxJIUzCKWpGAWsSQF+x/RmkrWbHB7LQAAAABJRU5ErkJggg==\
	")

	R.chain = {[1]={}, [2]={}}

	-- a.png
	R.chain[1].a_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAABwAAAAcCAYAAAByDd+UAAADj0lEQVRIic2WTWwUZRjHf/\
	OxM/vRtSnttgsYSttN2yUBWqQKWC1BE6iGBj3IAcHoRcWLiRxMTCTiyejRqCeNPejBkxSQ\
	Fg6GxEjSkLYgEmDXrwjFOmtry352Zl4Pg4WZnd2uhhD+yVze93me3zPvx/O8khCCeyn5nt\
	LuZ2ALcAg4BRiAuPUZwGngDSBeSyBpmT2MAkeAVxAiaF6exkzNYGduIiwb+YEQakcz6rrV\
	SLpaAj4C3gYW/g9wHfC1KJmJwvEpSscuYs/k/YPUa2hPdxMa2oQU0dPAbuDSfwEmgTPW9b\
	mm7AdjWFdnKyXlkry6jsihJ1ATcQMYAH6sBRgFJqxrsx0Lbx1FZAo1wZYChlXq3n0KtXNl\
	CngImHcl5eNzROQXO7Lvj1aEac8kqR9+HmVjc9mcyJlk3zuFPZdLAO94573AOHCwMDKBlf\
	7bF6asjxF5oR+5IULw2V5fG3smT/7LswCv4pzwisB9omhqxZGypV9S+KVtoMhg2Wib1iK3\
	1/vaLY6lsTNZHdhfDTi4eP43xFzRN4jatwo1EcdM3SA/MgmANpDwtRWmTWk8DbCzGrDHvH\
	LDNwBAcGgDAIWjUyx+ewUA/bEukCVfe+tnA8C17l5go/1XztdZSTQQ6GlFLBRQHlxBYGs7\
	tjGPHIui9rb4+thGFqDxzjG1zMq0fJ21XUkApGiQ0HN97rn+BOY5n5Ux7bIhLzAjx+oavU\
	Zycwh9oBtRNMl9egbsW3c3FCByoB/t0U7yw+OIWffeS3UaQKYacEJZ0/SkFxjc34cUDFAY\
	vUDpxFV3xokW9Me70Aa7KH5x3jWntDUBTLqS98Qe03pbkQLKbafOFejbk4iFAsWvJvGqeO\
	yCA24vLwLa5rUA39w55i1tLcCv2Q9P66XRtGMQVtH3bsT8YRpz/HpZUAAl2Yg9fdN1ndTN\
	K4keHioBrcDSBnv/8A/g49DeR5CiAcApVYXPzlWEAViXMi6YpMqED2wBp125TpNfLT0sx6\
	Kp8OvbK96v5RR8eQtKW3Mapze65AecB/ZoD7cbkTd3IIXLb04lSYpM6LWtBHetN3B6Ylkj\
	rtaAk8CI9ftsR+7z7zDPXqsKUzbECL+4DTURTwF7gIu+SdX4xDho/fKnVvo+jfmTgcjkQI\
	DUFEZZ04DW14bavaoIfIKzjPOVAi4H/FdxYB8wCPRwu1xlgCngJDCMc+iqqlbgXdN9+y69\
	a/oHeH87HFWBERQAAAAASUVORK5CYII=\
	")
	-- a@2x.png
	R.chain[2].a_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAAH3ElEQVRoge2aXWwVxxXHf7\
	O7d++XDcQOBgzYOMHUNg00JHyHD4coLYSEVn1paJq0iCZqm1YofUirfqjNQ6u+oJY0ahu5\
	fWgDEZEipfBQERRaaMCQNnGggCDU2MSNqQMmYPD1/dqdPqz3foB39861rYaIv3SlmdkzZ8\
	5/78zsmXNGSCn5JEP7fxsw3rhF8GbHLYI3O4xx0jsBaAVWAXcBjcBkIDb8PAv0AN3A20A7\
	8AZwZcwtkVKO1U+TUn5eSrlLSpmR6khJKXdLKTcM6xoTu8QYfAcF8BXge0Czx1vEHkgikx\
	mng66hTYqB4blC3gOeA3YAozJwtARbgBeB5YWNcihN5mgPmWM9WP++iN19BTmULR5Y1xAz\
	K9DnTCbUPA1z0R2ICdHr9bcDm4GT5Ro4GoKbgeeBiNtg9V4mubuDzP4u5NWMmiG6hrFsBp\
	H18zBaphc+SgJbgN+VY2Q5BAWwDXjabZADQyS2t5PZ04m07HLsKIKxuJbY48vQ66oLm7cB\
	zwCWkrGKBHXgj8BGtyH9zy4Szx9AXkqq6Ak2zNAIP3EP0Q13gxBu8w7gMRTWpSrBXwHfcS\
	tDO4+QfOldlf7KCK2sI/70GkTUdJt+DXy71P4qBJ8CfguAlAy2HSC965SCqeVDn19D5Q8e\
	KiT5daCtlL6lEmzB+SBHABIvt5PacawMU8uHsbiWymfXQUgHZ+O5FzgR1K8UV03gvK0IQP\
	rgmbLJmQ9/ioltj1L5i/Vo9ROU+maP9JLY3u5WIzi7qvDu4aAUghuBpQD2h1dJ/OZNJcNc\
	hFbUEX9yNdqUCRgt04ltWqqsI/XqCTId59zqchwHwxdBBDXgx24lsf0Q8kpa2TBtWpz4N1\
	qL2kILZqHPvV1ZV6LtYM4jAr5PAIcggg8DcwCy750ns69b2SCA6KaliMrIDe2R9Xcp67Lf\
	v0pqb27pNQGP+MkHEdzsFpK7jyobA2AsmY655M4Rn5mL70SrucE9C0Rq93HI5hyKTX6yfg\
	QnAg8C2B8NkjnwvrIhCEH00UVFTXb/YL4S0gm1zlZWa58fJN3R7VbX4hzPRoQfwTWACZA+\
	3Am2us8aum8mxh01ubp17iLXtu4pkgmvalLWC5A+1OkWDZyz54jwI5jb5jJHe8oyIvLI/K\
	J64qXDWMcuYHVdyLXpM6vQm6uv7xqI7Du9kPd7V3nJ+RG8xy1YJy/4iI0MveV2jKbavEFn\
	PyR7+AMAUn8/XSRrrlCfpvJSEut8LgDguVv5EZwFzpqRH6WUDQivbSmqJ//ckStnDnQVvn\
	3M5Y0IXT08ZPX0u8VGLxk/rTMB7AvqYRJRHcFclh/T7h8kW7BJ2X0JMsf/kzeiKo6+cJry\
	OHb/Nbc42UvGL+hkAMi00vELAPOBRoSZV61Vx5m482uQKjjVX/ePmSsac1O4VMjB3MyKec\
	kEzgs5pOa5CF0j8tkbl4QwDURlJP+LmUXPzYUNiHhIaaxS4EcwASAqwkoKjdX1aJMrlQ0R\
	UZPQfXWKnXLmZ71E/KboBaBeq7jRxfKEJpwTeAHS73Q7U1PLO/7CNCCko8VN9Ib8dzL8QA\
	vpPZ2UCq0qNzM9v2N+BM8A9drUSQhdKynWElo9C70hv96tnksM/uR18DhzCl1jwu83olXH\
	HWOaatGbqrFO9Y8ofz20mpwD0+0p49P/XwAibKA1TAwcTEQNol9aXNSW3NXhSQ5AWjapN4\
	rPrJEN8wLHAkAThV7S255iPir2uwX901MDxwt/+W70afkXYfVeJrP3bGC/9N7TkMnv1Oby\
	xpIOw/qcqsL9od1Lzo/g3xhevObCWf6DNVcTfegzRW1DO98qaVrb/02Q2l8Q2xGC0L0zAv\
	uFFta7xTROXmNE+BG8AvwFIDR3Btq0uKegMb+2KAyf/sdZMvu6Ao10kXztGDI9vBFKSbYz\
	YA0Kgblyjlt7HZ+kTdB38A8A6Brm50ZOOwBk3uzC6hsAwOobYOjFgwFqi2GfG+Dqc7sZ2n\
	mEgR+9hvVun698aGUd+tTccvCNrgVF1TScyFWTTKS58s2Xkf0jB3iFriFmVCA/uIbMjj66\
	7QkhqNy6AWP2FHCSNM2A54BB/6AN/BxAxEyiTyzyFJSWjX1uYHzJAeba2S45cDJQvgOW4s\
	L/CTgIEF7dhLFkeoD4+EGbXkHssWVutR0nlO/fpwS9EieqnUQI4t+6H63We8MZL4iwTnxL\
	qxu8SuLEiwLDDKUewk4wnA/QJsWo+OE6RJWCCzdaaILYd1cXHqC3UGLOUOWU2Qa8AE6Yof\
	Kn69CmeJ5SxgzC0Ig/24q5NHfq34ZCrlA1u6ThrMmNAHbfANe27sU6eVFFR+mD1USJPbOG\
	0Nzcut8BPI5CjrCcBKgObMVNo2UsEq8cIf3qSWRG/XDshdD9DcS+uhztttx6f2F4TKVtej\
	Qp7KeAXzKclLF6LzO08y2y+8+NKstrLJhK5IsLCM2b6TYlcdZ/Semy6zEWlxDaKAgxWn0D\
	pP96kvShLuyugZKUaDVRjMV1hFubMBqLHPtDwJOUkCbzwlhdI9mIk6SZU/jA7r9G9tR5rN\
	7L2BevOlM4lUVUhBGVEfQZt2E0TEavvyEJcxr4Gc56H52BY3wRaMPwZZ5UGReBMtK5RPSF\
	j9tFoJEwESf0vxQngDwLJwzpRhASOCGRM8Bx4ACwj3G4yjVeBD82+MTfNrxF8GbHLYI3O/\
	4HzN2+0cWu1vEAAAAASUVORK5CYII=\
	")
	-- e.png
	R.chain[1].e_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAABwAAAAcCAYAAAByDd+UAAADrElEQVRIic2WW2hcVRSGv3\
	OZk8wtJjhpUk1bk6a1sZhqsVJFLFpQIxIRivhQBd+kogQvCIooFJ8K9cHQF5+kbz6UqkGJ\
	BEVF0ZRaBkxtNZOml9w6k06ayXQm55y9tw+niXPOmWlSLaU/zMu/11r/WmfP3v/WlFLcTO\
	g3Ve1WFmwF3gaGgCygrv6yV7k3gZbVFNJW2MMk8CHwGq6MOKcmEeM5ZG4BJSV6QxSzoxlz\
	axtanWkDh4D3gYX/IrgV+EItuhvLX6exB0aQF0vVizTWYfXcTbR3O1qibgx4BvjzegS7gB\
	/F1OVU8cAg4u98raZ80O9MEH9rN2Znaw7YBZxcjWACSIuJfEfhvS9Rs+VViS0XjJkk9j+N\
	uXltBrgfKKwk+LEqOX2Fd48gRud83Zv3tqKkgpKDKjvI6QXk+UIwH705SvLgHvTG2EG8P1\
	RNwRbgfOnzY5Hy4d99RRoO7cFYd3uouMwXKX7yHe6xSR9v9Wwivu9xG9gATC83E8jfq0pO\
	ZPGrkVBhZbsA2L9lWBwawR7OICby6E1xtKQVine+zSBnixbwYiVvBuJ6nJELqLnFsGDJ8Q\
	R/+Avnp3PLvBYxUI4IxwuJPZyhvqf7SeBArQm3uaenQsk+WAZa9N8+q4ktQYznALZVcsEJ\
	Uyp/pWqyVu+FJvqegD5QJRsxNYecnKN8NI04fSmUI7NFgFQlF7raanWsyt4eipl55GwRLW\
	JidqzBemQzRteaqjkIGaKCE+b05mQqFAWognceywMnsI+eQjN0tHUJtNvqkX/kquppcQvA\
	txicMG20NVVNdkdnAKjbtQUtZqKERI7PI9IXUVUmATDaUwDpSi444WDkvg27NVNHuf4izv\
	cZ1LPbMTtbaOh/Hvv4GWS2AK5EnL2Ee3yaIKwddwF8U8kFD34rcLbYP2TZg5lwx/ekiL/y\
	KEZ7c2B8Sf65T32U+cBakh/02sB6YKbWhNNAf/SFnW84v5xDFRzfojiZY/71IxibmtDXN6\
	KnEmgREzFz2RenmTqxl3aCZ1czvrUqd2kSOGEPj20sfjQE8vrfPNFXH6L+qe4xvDPo88Zq\
	jl8Aeq0HO3Lxdx5DiwU/Qm1ohr4klsPzxJARX8uAu4ABcSHfceWzn3F/nbimmNHdTOzlhz\
	E7WzNAL1W8cCVB8LxxP7BPnMla9vAY7mgWlS+BK9BakhhtjVg72jG33GED/XhPkrBnrVJw\
	CS3AXqAHb1+WLocc3jkbBA5TYUP/V/CG4ZZ9l94w/AMIA3oLRCGsQwAAAABJRU5ErkJggg\
	==\
	")
	-- e@2x.png
	R.chain[2].e_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAAH2klEQVRoge2ae4xVRx3HPz\
	PnnPvYe/cur12WLQu7FBrYllJgC6VgTZfGKqBNaku0sSYkbRq1GEhMmviI1uh/YjVg1JTE\
	pDWgRIlajAGxKLUFAWlB3UIXlvdjW3bZ133fc8Y/zj2Xvbt7zz3n7qKl4ZtsMr85v5n5fe\
	/szPzm9xuhlOKjDPn/NuBm4zbBWx23Cd7q0G9SvzHgEWA5sAC4E5gKhPPfM8BF4BxwBDgI\
	7AX6x90SpdR4/elKqceUUq8ppbLKP9L5tp9WSsnxskuMwzkogbXA97BnalRYfUlUKguA0C\
	Wypgr0kiukA/g28CtgTAaOlWAL8DLw4NBKlcyQPX6B7LELmKeuYZ3qRWXN4oE1iWiMos2Z\
	gtHSgNHajJxQNbz/fwDrgHcrNXAsBJ8BtgBBp8K83Etq1ztk93WiBrP+epMCY3kjwdXzMe\
	6ePvRLCtgA/LwSIyshKIDNwFecCqsvSXLbAbK7T6NMqxI7iqAvaaDq6QfQmmqHVm8GNgLm\
	6K1KGOuToAa8AjzlVGQOd5L4yRuo7pSffsobZmgEn15I+DMLQSus1W3AF/CxLv0S3Aw87w\
	jJHYdIvfq2n/a+YTw0g8jzKxHhgFO1BVjvtb0fgs8BPwNAKeJb95P5wwkfplYO7d46qr+5\
	eijJZ4GtXtp6JTgPOAqEABLbD5DedrwCUyuHfv80qr++xjla0sAioL1cOy+umgB+QZ5c5s\
	2O/zk5gNzhKyRefdMRg9jHU1n7vbhqnweWAlgfDJD46d/dtYUg+EQLxvxGMDSwLFQyCzkL\
	lclh9SexugdR3XHMM9exLgx4MMFGemc7xsIZGPfNBPvsXYvtDJQ2p8y/qAROArMBBl/aTf\
	b1s65GGCsaib6wyrPR1vU4uRNXSO34J+ap3rL6cnqU2A/XIsIGwCns5ZNzI+CGNeTJ5d67\
	UpYcgLF0VlmdIgMmRggsm01kw0pP+tbFQdJ7/+OIs4HVrv2X6e9Zp5Da5W3dWT2DnvSGQ0\
	RCnnXTv/8X5AoOxTNuum5rsAb4BIDVHSe3/7ynwVV/skhO/ek46d8eA0MiqoOImhBySgTt\
	jonod01Fb65DKUVy5xFP/QNYXQkyR88QWHInwKPY17NRr1puBFcCAbC9Fc8u2PAlbVpYXY\
	m8MHJ2hSZBF6i0Lw+MzIFOh6CBfffcOZqe27/oMqeQfdvb7FUCZVq+yQHkjlyCGz/6g6X0\
	3AgudgrmyWueB87vbgWojH/jvUD1pjGv9jnifaX03AjOBLB64v4caVHcpZwQRps7GdkUQ1\
	SNb4TEPFf44UtetN1GnA5gdXs/iAEIaEVisK2FYFtLQVYDKcwP+rEu92Je7sW82od1qR/z\
	RDdY/q5uVk/cKU4tpeNGMAAUwgxeIQzN/Xt1CL06BLPqiuozhzuJf/fPvsZS8bRTDJfSKe\
	vLqaQ/gsNDE15hLJhRUbtycJvBJBAWVQEXlZFQqUyRnDtzDfN0FyISRE6sQk6uRtZWj2iX\
	eavD1zgAyML8ZEqpuBHsAppkzYhAkCtUf/GGZL3fR+LHxQ66COvIGTFkfTWyNorVnyK376\
	yvcQDkxIJtF0vpuBE8DTTJuhhCk54Peutq8aY0LK4CgErmME/2YJ7s8dRnKci6mFM8V1LH\
	pf0xABHUkbNqPA9qvtc99ABGmxpDW1Dn0qJCCIF+Y6Mq6ee5ESzcLrV76j2Pq/rtmOhQRL\
	78MLIh4rkPL9DmTkJECxHLg6X03AjuBbIAgdYmX4On/1Icp9UaJhDb9CShdYvRWqaUPUq8\
	wGid6RQzeVtHhdsa7Ad2A2uMu6cjGyJYl+Mu6jeQ3X+ezEOdBJbcuBuKaJDw462EH2+FnI\
	XVl0ANJCF/4TZ74qR+dwzzna7yAwhB4GN3OdIeXJI25c5BO3KlSQKPzis/sAOlSGzaR+bo\
	2dG/6xI5OYrWVIvWXIfWXEdgcTPR9d4uvcaKRrRphX3hZTfdcgT/iB0WIPTJ+ci6kg7DCK\
	hEjvh39jC4eS/mBW+75ZA15aIkCH12kSN1ALtc1T2EDT8HbAdI//VdEpv2lzdiFGhzJqLf\
	Ow2tuRatvgY5IYKoCoAuEeEAajBNYvvBsrHWwKo5RL7U5ohPObaVgheCEniD/J1r4Pu7yB\
	285IXTuEM2RIj94AlEdQjszNMyyoTxvcRFLezYTBogun4l8o7oGE31DxHUiGxsc8ilsNNq\
	nmbHC9rJ5yRELEz0G59CTPIeJBozpKBq48fR5zY4NRvwmDP08whhK3biA61xEtUvrvK16V\
	QKoUsiLzxMYPkcp2ozPnKFfrNLAvgl+fSZ9f4Ag5v2YLZ7D2n4gawLE/naI+jzCjO3Dfgi\
	PnKElSRANeAlnBRW1iTxm0NkdvwblRt78tOB0dZM1boVQ9PaW4Cv4jNnP5YU9nPAj8gnZc\
	zLvSR/fYjc386NKcurL6on9ORijHsKaew09vr3lC4bjrE+QpiHnXla6lRYXf2kX28ne/g8\
	Zsd1T53I+ir0+xsJts1Fn13k2L+FvYOXTZOVwng8IxHYzsCLwJyhH6xrg+Q6rmJeuo7VPQ\
	hZE5XKISIBRCxkR7eba9FmTAYhhjY9BXwL2IF9TFWOcXwIJPOPeF7LP+rxi0y+7WPKflT0\
	oXkINBqcp1wPAK3YMdbp5CN12PGeLuyowTHsu+dNecp1swh+aPCRf214m+CtjtsEb3X8F5\
	Lt7GKi5gIEAAAAAElFTkSuQmCC\
	")
	-- g.png
	R.chain[1].g_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAABwAAAAcCAYAAAByDd+UAAADvElEQVRIidWWTUxcVRTHf/\
	d9DcwM00FomYYAQ9uhbdIUUWNrmtqA2pguqk3UBYp148LEdKELv5aaNHFRTWpMTGy0lcYY\
	MW60Ma0BGrW18hUhEW0tjICKM1CgwLxh3rx3XQzFecMwUGOaepK3+Z/zzu+ee+479wkpJb\
	fSlFtKu52BYeA1oAOYAOTiMwF0Aq8uxqxqYpUehoCjQIs0LdXqH8EeiuNMJUCA8BmoNeUY\
	DTWIQLENtAIvAX/9G+A+4FNnOrHebOvCOvcrMpHOn0RT0JpqKX7iXtSKwATwGHD+ZoAPAm\
	es/lF9/lg7cjK50qLcyfw63uf3YuyJWMDDQPtagGGgz+qNBudfP4dMO2uCZZv3hfvxNG6f\
	BhqAaLYv36E57sRmg/PHOpbBhK6i3lmB/tAm9MYwwq/nBZrHvyM9FAsC7+T6ciu8G+iee+\
	ssVvuwK1Dfvxlv830oZb4lLdF6gYVPBvJC1foNBN44dCNn7w1dy4l72pmYw+qIukTjQATf\
	c00A2NE4Vv8Y0nawOq/mhQHYP8ZIXxlHi4QOFwI2prqHIatq4dfxtuwBYKFzEPPtb5H22v\
	qa6h5Gi4SasrXcHm61RyZdglpfgfB7kEkL8/3v1wwDcP6YAajL1nIrNOT8gktQSooAsMcm\
	kTMplNoA2tYNGaeuogR9iBIPWDbpn8exvhlZeldeXwAwCgFTwudxBUjTAkCoKgC+I41oW0\
	L5SzoI0z0n/hkQmgKQKgS8rIbW7cgW7MEY2A5qVRlKpR/z4y607SFEkY6cT1H06F0Ij0bi\
	9AWcawnXNFI2BgB+yc6X28N2vaHGJTgxk9Slq6Ap+F58AGd0huTJXsz3LpFs7SN9+c/Mwo\
	Ynsc66T61eXwWZgb9ihSfVqjuOqDvXY/fHl0TzxEW0SAgtEmLdu82kozFwJMJXhFpZijNj\
	Yv8UdyVSKv0YDWGAU4Uq7AW+9D61GxThqnL25c9Z6BwEKdG2hNDqNqJWlmL/PsXc0TPIWc\
	uVqPjwLtCUL5CyJ1vPN0trgV7zs+5g8sOeXB/Cq6HUlSGKNJzxWZzfZl3fLYBxcBu+Z/fl\
	naUr3RZNwFdmW5eePNW3LGEhMx7Zhu+ZvRaacgD4etmCV7kP26yB0XLzg4vYV6YKgpTqEo\
	pbdmHs3hwHHseR57PbshYgQAXwJlI+aQ2MqakfhrCHryGvJ8FyEOVe1OpSjHvC6DurbTTl\
	I+AVYHylhKsBM9spRBhoBvYDO4CyRe8kMEBm604jZRSxvKqbA/7Hdtv+Jv5/gX8Djf96T7\
	NLXZQAAAAASUVORK5CYII=\
	")
	-- g@2x.png
	R.chain[2].g_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAAIJ0lEQVRoge2aWZBU1RnHf+\
	feXuf2DMyAs7AYlgEGnLBETQVBEkFMjKIVLYwlSbRSZVW0ECV5yYsVH5JKkVS5lSmtSpFo\
	MDFWEhcCWAYTDMNmRjZFBhhHBodtmBmYpffue08ebndPd9F36Z4hAYv/073nfuec//+e7T\
	vfOUJKyRcZyv+bwKXGVYFXOq4KvNLhuUTl1gJLgcXAHKARGA8EM9/TwCngBHAQ2A38Ezg3\
	2kTEKC4TQWAV8H1gSRn5DWAn8ArwJyA2GqRGQ2AF8ATwY2BcMQPj3BDGQAQZTYIiEKqCqA\
	mhjguBVy2WpRd4FniaEQodqcDvZIhcm5+of95H8oPPSB86jX6sDxlOFa/co6DMqsHTVIv3\
	xml4mxpALZgWTgKrgbfLJViuwCDwHPBwLiVtkNjdTmLTIfTDvWWRUSaG8N0+m8Cy6xAhf/\
	6n9cBjlNGa5Qi8BtgEfDWbkDpwgtjLu9E7BkotqzipcQEC9y8gsLw5v0X/A9wFdJdUVokC\
	64EdwHQAGUsRfWUHyc3HSinDNTzX16M9uhSltjKb1AHcRAmzbSkCxwItQDOA0RchvO4d9L\
	Y+94zLgBgfIPTT2/DMasgmHQIWAYNu8rtd6AXwB7LieoYYevLtSy4OQPbGCT+5hdTHXdmk\
	ZuDVDCdHuBX4OLACQA7GCP9iM0bXUKlcy4aMpYn8civ68Z5s0gpgjZu8brroZKAN0JCS8K\
	/eIbWjyynPJYEyuZKqdfcgKgMAEczW7LTL48ZVWwdoAPH3PilJnKjy4VnQgGdmHUqNhtD8\
	yHgKYyBKclt7ycuJ0TVEdMMutEeXkuH0FPCQLQeHFmwEjgCqMRBjcPXryP6EIxGlQcO/cj\
	7+xTMRQV9xsucjDDz4qmNZxVD56xV4miYASExf94glF4ey1gAqQGLLQVfivEunUPXMSgLL\
	my3FgenFlIvYa625YoAf2dna1aIC9wPIeIrE5jbHin23zyC09psIzW9rJyMJIutbHMuzQn\
	rfWfTjuaXwe9gMNbsxuATTayG1txM5kLStVJ1Vg/bw1y9K17vOE9+4n/TBM8hzMQh5IJJG\
	pg0HGfaIbzuCNrUWTAf/JmB7MTs7gTm2ydbjjhUGH1p40c4gsf0osedakEl9ONHhR7lFur\
	ULfph7vRULgXZdNOdr6p/Yu39qYzXe5kmFBNpOE3t6e6G4UYRxMozenXNmFljZ2QlsBDD6\
	oxhno7aVeeY1XJQW/f0upD6ybugE/URumZltZWMncAqA0ePs8qnT6wre0x3d/xM3zujJeV\
	P1VjZ2Y9AL5o7BCUpl4ayZbjvrmCcfosKDqA4gKrzIeBp5IW65Sc6HDMezj5qVjaMnI2Mu\
	JgWlsCMYvcOtLrwq/lXz8cyoRcZSyGgS4VURVUGUmhBKdcXFy4qU6Kf7ib2xl9Q/Opzrt4\
	GdwAigiVDAsZC8P5kpdXg29d0zh+C9N5TGSgjUidWEHllK/54u5KDFTx7+sZbNbTcGzwIo\
	Yyoc+ehnCnfy6qTq4ecJYx3zW0IAqvWuSLkmlH3stLSxKb4NQK0fgyge+cohfaxwGfHOvT\
	aXJ/FuG3pnDxSZUeVgDFJ5y4iUJFs/Qz/eg9EbJvraHuQFa/dQrR+TffzUysauix4A7sSj\
	oDTVoH/cY2mof3gGORTPbmNQajS832ok+fej6Id7GXzsDTNcWOVDaF5kNGV6Roak6qX7UC\
	dmWlwIUh+dJPKWs1sofCqq6cmAGa8pCrsW3Jp98M6baFuZTOokthWSqli1EHXGcFfFkMj+\
	BMapsNkqhrmLSe5sLyQ0vhI3UOfXIfy59vm3lZ2dwF3AeQDfopmOFcb/9hEyPNydhOan8q\
	kVeJdPA2E9joy+cMG7HLJ3KrLwLZqefezBjBUVhV0XTQMbgMfVSdV4FtSR3m/tssnzcaIv\
	t6CtvjWXJqqChNYsR7/3Aum20xgXombL+VRE0IcyTsM7tyBmTHrfKUdxotqP72uN2dc/Z7\
	iWLBDgJcw9oQisvJ7w/i22xsl3O1BqxxC878aCdHVi9fA4s0Hi/Tb09guOdv475iAqfAA6\
	8LydrdOu8whmK+L98mQ8Cyc5mEN8wz7Cz281Z8gSkDpwgtiLuxztlAkagbvmZ1//gs0MCu\
	6CTlMwY5Ga0T3I4Nq/Ioec3ShR7cd/5xz835idH7i9CHr3IPGN+0luOpqbeOyg/ew2fDdM\
	BYgCTYBtkMht4PcJ4BmA5AcdRH7+nps8mRoEalMN6rRxKLWVCJ8HqRsYPUPo7b3oR/pcCQ\
	Pwr7yOih8szr6uxTz4sa/epUCBecKzAiD25l7iv/vQFanRgveWKYTWLAczlrMJ85zCkXwp\
	ofsxmOcSzQCxt/YRX99qn2OU4L1lCtrqZQifB8zhsgRwno0o/fClDvMUdjpAouUYsRdakF\
	HLWXpkEAL/d5upeGBhdi3tAG4GzrguoozjszpgI5mQhn66n8iL76MfKOlUyxHKpBAVj9yc\
	v062AndgLuyuMZID0BfIhn2kJLmzndjrezE6XR36WBOqCeC/u5nAt+ciAt5s8m8xJzp3bk\
	5+eSM8wr4b+A1gOqtSktzXSXL7MdJ7TrrvuorA85V6fIum41s0ExHMCfscU9ib5RIcjUsI\
	QeAnGSK5SwgylkI/fo5UezfGmQGMvggkdZAS/B5EpR+1YSzq1PF4ZzXkdiIZ9GFeQHiWMl\
	otH6N9jeQB4EHMA8pyYvPbMT2nP3IZXSMphlpgGbAQmAd8CbMbZ33fGOZVkU+Bw5jLz7+4\
	zC8CXZb4wt9VuyrwSsdVgVc6rgq80vFfbDnjk7U4d3EAAAAASUVORK5CYII=\
	")
	-- m.png
	R.chain[1].m_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAABwAAAAcCAYAAAByDd+UAAADkUlEQVRIic2WXWwUVRTHf3\
	dmdva7RLst21Zql1ZsqxBoKvKRCOqDAhF50wRNNCFR8UGMEh+MEjE+GI36pM8SP2J8MAoG\
	LYkPJoQSTFpNCrHtVjSUQrtrW7a70935uD5srZ2d6W4lhPBP5mHOuff+zr33zDkjpJTcTC\
	k3lXYrA1cDh4FTQAaQC09mwfYKkFzJQqLGHdYBbwEvIGXQ+n0Ca3QSJzuHtB2UujBaeyNa\
	dwsiqJWAj4E3gdz1ALuBb2XJ6pj//ldKJ4ZwJg3/RVbp6Hs6Ce/tQUSDaeAx4ML/AXYBP9\
	uXZxL59/uwR6aXC8olpSVG9NWH0TqSGWAHcH4lwDgwYI9Pt+de/w6ZnV8RbHHBiEbs7d1o\
	65pGgR4qjtcvaY5Kw2zPv/ejC6Y0RQk+cS+iTq8KlAWL/LuncGYKHcDRSn8lMAkcnD8+gJ\
	2edTnCB7YReWo74QNbyjvRFGLv7CZyeKcH6kwaGF/2AzxPOcOXBe6XRUsvHncfvdIcRd+8\
	FoDgzk7U7gSBPesIbFhD8IG7UVrjHqjZl8aZNULA09WAu8zf/kLOFF1GbX35E5NzRRCCyD\
	NbCe/tWfQHetd4gNJyMM+NATxSDbjRGr7imaysXgWA8c0vOJM5tK5mlMY40igtBHSHZw6A\
	NXIVYFM1YL3zd8EzUYQDADiZOQpfnFm0G1+dBdshcE8LQvPmn5PJA9RXA4Jl+0YLgKpg/n\
	QRc/BP7IlZSieHsYavIMI6am+Td7zleExaxXtWaYjVe0YtSKgKSMncGz8s2kpnx9C6mtHv\
	T2H1j7vHx3SA7FJb5Q4H1NaEByQL5bsiVBkfmGcugpTo2+9C3B5y+dRUAmCwGrBP33QnIq\
	BWEMvVSCg+93Q5T+n0CCKsE3rSlR/ovW0AJ6sBj4l4qBh4qM29i8FxzKFLWMNTHiCA8dk5\
	7Al3odB6m1DbGkrA50vtfrX0Q2cqd+jaS18jc6YvoJaEphD/4HHUVONHwMtLfX619IjSEB\
	+NHNoBirguYOi5LaipxjTl3uiSH/AasE/f3J6JvvYgIuJNlOUkVIXwi1sJPbo+Q7knehpx\
	tQbcBZywL02vLXx62pPylVI3NBB5dhtaR3IU2AcM+QZV4xcjTrnFHLT/mNJL/WmssQwyWw\
	ApEYkoautt6Pel0Dqbi8AnwBHKp+SrWsB/lQT2A7uAjfxXrrLAANAHHAOu1lpopcAbplv2\
	v/SG6R/27zmuL3E50QAAAABJRU5ErkJggg==\
	")
	-- m@2x.png
	R.chain[2].m_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAAH/klEQVRoge2aaXBVZxnHf+\
	855557c29CAkIMWUGaNCRsJh22KGVRRqCVOnXGkUGxiqPW4mD9UJ2Oy/jFGT/gSNvROti6\
	QRWXD8VlFKUlU0ixVqQ0gCxDIAKlkJClufu9rx/OPTd3ydmyaOnwn7kz533P8z7LPed53u\
	c8zyuklLyTofy/FZhq3DHwdscdA293aFPEtxxYDdwLLAQagVlAMHM/CfQCPcCrwFHgEDA4\
	6ZpIKSfrp0gpH5BSPi+lTEjviEkpD0gpN2d4TYpeYhL2QQF8Avga0GzxL5IeiiKjCWOBqq\
	BUBEGz9JCzwLeBfcCEFJyoga3A00BH7qSMxEmc6CXxWi+p8zdJ9wwiI8l8waqCqCtFbZqF\
	b/5s9KXvQUwrKeTfBWwHTo1XwYkYuB14AgiYE6mrA0QPHCdx+CJyOOFNEVVBW1lL4L5FaC\
	01ubeiwE6MP9IzxmOgAHYDj5gTcihCeG8XiT9fQKbS49EjD9qyaoLbOlDrZuRO7wYeBVKe\
	lPVooAr8DNhiTsT/cZHwE53I/qgXPs6KaQr+be2UbH4vCGFO7wO24sEvvRr4feBL5iDyq2\
	NEf/EvL+s9w7eqntAj6xAlujn1JLDD7XovBn4O+CEAUjKyp5P482c8qDp+qIsrKXt8U66R\
	nwX2uFnr1sAWjA05ABB+rovYvtfGoer4oS2rpuyxjeBTwQg87biIrm5SNYHxbwUA4kfO/c\
	+NA0geu0p4b5c5DAA/yuhmCzcGbgFWAKTfHCb8g5ccF+ibmqjY/xDlz2xBa6tyIcIdYr/t\
	JnH8kjnswEgwbOFkoAJ8wxyE9x5FDsbtF8yZRugzqxAlOsqsMkI71iGCxSmv1lZF2XfvJ/\
	T4B1BqSp30zCK850g2IwK+6mSDk4H3A00AybPXSBzqcVQg8OAS008MATNL8X9scR6NKPMR\
	+vIH0eZXoy+fR3DHvY58TaQvDxM72G0O5wMftqN3MnC7eRE9cMJRuKjwo69sLJoP3LcEpX\
	b0Kfk/utjIRTPwtdaiVIcc+ZuIHXgdktmE4tN2tHYGlgPrAdK3Rkh0XnYU7FtWi9CLX0eh\
	awQ+fo8hsLKEwMZFRTTa0jpH/ibS10aIH+8xhxuAaVa0dgauA3SA+MsXIO28nWjNsy3v+V\
	fdjdoyE31TKyLgK7rvW1LvyD8X8aMXsmKBNVZ0dgauMC8SJ3pdCVUb3pWvRNf5vHFw23IC\
	6xeMudbXUovI8V0nJP95FUbzXksntjOw3bxInbrhSqhaPT17nX5zmMizL+dGPLSWGkSpf8\
	y1osSHunCWKzkAsj9K6o1sAWChFZ2dgXMA0n0jyFsxR4FCVxGhUeVTbwyQvjZC9I/WwSl5\
	+mreWGu1fsXHQupyn3lZHNkysDOwDiB9w12ZREzPfzIybOyXsd+dJD0QLqJPD4QJ/6Qrb8\
	63sNaVrCyPvhHz0vLR2xmoAci4y8+vgvKDjBgGysE4kf1/LyKPvXiG1Om+POO1xipEaXEA\
	soIcyX6iBa1oHFM1U1HPUEdZx/9wluSF6zlMJfG//hukJHHyP6PzmoLW5u01dYKdgWHAMi\
	gUoWAbEX4t7174ycOkevuRkTjhvV2kLw0BkDyRv7/62hvcyQMQWfWTViR2ddEbQINSGrAh\
	GYUMF9RgCkJ+6vwthh7+ddG6xCtXjHCfeeL60nlE9KOuXEOZkX0zLfcxuyd4DkCpqkCo3g\
	vgY2U0Y0H2R0mcujK6rtSP9j53WY1SmU1geixpbNafBONVU+aWOwqTQ/lPUOjuN+1459m8\
	cWCD5bY2CkWgzas0R69aktmw6DQv1AUuvukKKgNespLES5eQw6NFK625Gq3dXqbaNCN33+\
	2yorMz8AUyzqvfM8eVojKW4+t+3ZqwcN1bCaIHX8+bCz7UYesavqXZYBQH/mZFZ2fgIPAn\
	AN+CWpTZLj5nYjmvqUe/jf/+VN5TVBtm4ttokaAIgf7+JnP0F2yaNk5aPGtIU9A/NHbbIR\
	fJi6M5a/pKvyN9LtI3IoR/eSxfuYqx/1TfqnrUqmxceMaOr1NVTcGoXN0tw3EGH34O2Wdd\
	4BUVfvT1jSAE8YPnvBeDFUFgWxu+JfWkem4S+fEx5FBBoiEEZbs2o931bjCaNPMBy3K6m7\
	LhJ4GfAsReOE14V6cD+dRC39hI6AtrzeFWYK8dvRtH+TlwBMC/uhlteY0D+dRBqSkluHWl\
	OezCKOXbr3HBV2JUtaMIQeiLa90FnEmG8KuEdq5BlAXAKPxux0WPwm2o6ybTD1AqgpR+fS\
	NihrsUblKgCIJfWY3WXG3O7MRlz9BLLN8DPAWg1s2g7FsbUCqLGpaTDqEphB5bg77iLnNq\
	Nx56hV67SwqGT24BSF0fYmTXQVKnbnrh4V5YZQnBR9fha836/T6MoOe6RzieBqgK7MJsoy\
	VShPcfI/6bbmRy4s1PE761cwl+qgNletbfn8rI9CRkIi3szwPfI9OUSV25RWT/KyQPX5pQ\
	l1drqyLwYBu+RdkviiiG/7tqlxVioocQWjKCsyXG1PUhYoe6SXT1kL445IqJUlmCtqwe/5\
	pmtMa8JPsIRgTvHnulMybrGMkW4JsUVLfSfW+RPHON1NUB0jeHkYkUxJKIUj+iLIBaOx1t\
	7izUhpmFPM8A38Hw94kpOMkHgT6SOcwTG8dBoIQ0DhE98HY7CDQWyjFK/yswCshzMMqQ5m\
	d+GKMkcg7jw/ow8CJTcJRrqgx82+Adf9rwjoG3O+4YeLvjv1Ru0JflEZTtAAAAAElFTkSu\
	QmCC\
	")
	-- n.png
	R.chain[1].n_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAABwAAAAcCAYAAAByDd+UAAADbElEQVRIidWWTWxUVRSAv/\
	v+Zt60dChQWlNpB1NqF9aimFajMjVRsSWwUEJcYI0LNNG4MJjoojHG+LdgZ3TXGDEmRuOC\
	aDCAfxijEWP4SRcCBQpF+bHTTpmZN9P3d13M1On0dV4HYgie5OW9d+495zvn3fvOuUJKyY\
	0U5YbSbmbgWmAYOASkAFm6UiXdMJCoxZFYYg2bgXeBp2SmoNpHzuGOXUam8+D6iOUmamIV\
	Rk8bSnODBPYArwKXrgeYBD7301ZT/rPDOPvHkLZXxYtAf2AN5pO9qG0rJ4EngB+vBfgo8K\
	UzesHI7f4WmSpUC6rSma4SfbaP6GPds8BW4EAtwARw1Dl2Pp57fT/S9WuCzRdzZy/RrXfN\
	AOuB8flji22a9/1UNp7b/V1NMKEqKKvNCl1+5Dec0Qtx4AMWJLQQeA8wmP/0V2R6tuzU1G\
	h473Fiu5KIOr3CIPLMBuIjQ6idK8pKX5If+Rk8fwAhNoQBh/zpHM7BM5VZrIiiJpqI9HdR\
	/+YgYmW0PGZoxXtTrMLGG5vGOT4B8HQY8CHn2HmkV/1Tah0t1A9vQjQYAMi8XQRG9MBc+/\
	dxgP4wYKc3nqoKc//4C+foObSOFupeeRihq0irBIxqgfn+RBqgMwxoyGzwF5AFt/igKeTe\
	+Qb3xEX0O9dgvrQRXK8EDGYoczZAJAw4i2kEU7vqFJ3GokjLJfv2Abw/p4k82ElkoCc4f0\
	4iKoAdBjyptjYGI3U8ZN5BxErrNlUg+9bX+GkLtbmhqCs4ATu1dTnAyTDgD3pP26LBSstG\
	qS/vTn8iQ/aNr/DTVvF9ygrYaN23AnwfBvxIvSWOdm9rwNhPXUU6boXOOzVN5rW9WHt+wj\
	tSWa+V1SZG321QLOj/ymKlbZ939u+BzK69SKdcrMUyHWFq+FfygWAWk9jLSSLJrn3Sl5uF\
	IqpmCPC8urZpJvpcX4VSZpyaYcbgOiLJrhnghfmwasBxYHt0U7dtvng/Qr22Q4Gx5Xbqdv\
	bbwHYWFG4I74cbgS/csUurrA9/wTt+JRSktC3D3NGLcV/HJLANXx5iQXZLAQFaKHb8IffE\
	RWEfPoN3ehJ/0gJfIhpN1PZG9LvbMda3e2jKxxQ7/uVqDpcCzkkC2AE8AtwBzLWGKWAUOA\
	h8gpRnEcGsrgf4n8lNe0z8/wL/AWkORFUNbGW+AAAAAElFTkSuQmCC\
	")
	-- n@2x.png
	R.chain[2].n_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAAHaElEQVRoge2aa2wU1xXHf/\
	PY99rgEAdDjTEBHEgbwisENSmPUJSYCslRqZK2n5qoqlRF1Cpp0yp8qPoBNaUNTZXHJ0RV\
	KSlIlULV1ORVSExFAzVJREJqXjHQ2BQ3xsbe987M7Yfx7M7indnZ9W5TR/5/unPvufee/9\
	w75557zkhCCD7PkD9rBWqNaYJTHdMEpzrUGo17C3A/sAZYBiwAGoHgeHsWGAD+BbwPnADe\
	AP5dbUWkKh4TdcBDwKPA3YBUZn8BvAPsA14C4tVQqhoEo8BjwI+Amya0ZnX0KyMYw3FEKj\
	s+q4TcEEZurEeeGS425gjwK+A3TJLoZAl2AM8CX7BXamevkDnRh/bBFYyz1xCa4TiAPCeC\
	cvst+FbNx7+yFSkSsDf3Y768g5UqWCnBIPAc8EiuRjNId/eSfuVD9HPDlSkT9eHbtJDQ1h\
	XIs+vtTfuA7wOpssesgGAj8BqwwqrIvneJxN5jGJdGyx2ruFJ+BX/HUkLb7kIK+a3qHmAL\
	8J+yxiqTYDPwV6ANQKSyJPYdJdN1rpwxPEOeX0+kcyPqoiar6gzwVeATr2OUQ3AG0I1p9j\
	FGEsR2daH/c8i7xhVACiiEO9fhv7fNqjoNfBnwtF28HvQSpuk2yQ3FGNv5p5qTAxBpnfju\
	t0i/3WtVfRHYj8djyCvBTsz9j4ilif3i1ap9b55gCBJPd5M52WfVtAPbvXT1skVbgF4gBB\
	Db8zrZw33uPWoEKeqjbs/XUZpmAKSBJcBFtz5eVvApxsmlj56pCTkprKKumI10c9BVTsSy\
	xJ87AuaiBIBdJccusYJtmKsniUSG0e0HMK4mXAf0dywlsP42tPODpH7/D8RY1l2BsErdM9\
	tQmmYgMhpjOw+W/LbDO9YT2LDEelyCaV2LotQK/oDxjzn1+oclycktdUQeXYe6aDbBB+6g\
	7pcPIrfWu/dprre2HJJfRb1zbgmVILX/JOS9o8dcx3dp8wEPA6AZZF45XXJiuTFS8Kw0N1\
	C/60GUZY2OfURWK3iWQgEHyTyM/hiZntyn8m1cbkVuBNcz7jxnP/qk5Oo5QaoLUrdzK+rq\
	OcUF4oVbWAr5PI2b6T5rFRuAdU5ybgRznTLHJ2dYpJCP6I/bUVc1TWgTsRsIBr0R1HoG8r\
	cT2OAk50ZwjVXQzwx6mnQC9PwtQgr5iD7+AMrtNxeIiIRWKBf24wUiqaFfzLmlq5zk3Aje\
	CoBmYJwf8TTpjUgefNeuBFI0QPSn7cgtdYXKJjJ5GY8rCKD1fWoV25xk3AjOB9MtE7rzfc\
	4OkbjhSNAMxn7Whd6fvz7JM8NEn9yCNCt/5hl2ggHvURRjKGYVHU2vG0E/gBEv4wqWKbSI\
	+BTEUIrYz/+C8WlOGZS5M4n+ZDNSeJxMIp1rK4egGMvpVjQsAFWOqonEjSbf3G7GQJzYri\
	5ELE9EXTKX8A83ICkyZjimAnjYWW4EEwBSwPs3IUYzBc/28IN+bpjYr1+DrJ6r89+9kOB3\
	11AppGhu/IyTjBvBAcApKFQUIp61exhIkUKLqPVcIfbC4YK64NfuRGkptKxeIc3I6XbJSc\
	aN4FlTyQDynIiLWCGMeH4byuGJXkn2jY9JvHissFLJqyFsK1wKytyZVvFjJxk3gidzA7V5\
	f8PCRlCKFr8dpPd/QOrQKYf+jrttAtS2nONwwknGjeBbVsG3fJ7nSUUib3WlIitoIfnCO/\
	Zbeg7GdW8uobJ0FnJDbmd1O8m5EewGhgF8qxcg+RRPE9tXwNUrEYLknqOkuwtvOsbVMU/z\
	+NYusIrXgLed5NwIasCLYBoadWOrp4ntR0Epx1noBsmnu0kdOoVIa+h9g2SOlI7QSQGFwH\
	1Lrcf9mLmOoih1Dj5rFUIdK8fPLHdk37+cL5/uLykvdIPk839nZNteRre/jNEfK9nH195m\
	WXcBPOMmW8ptOAP8AfimMu8mfFsWk/mz4+UZgMyr59H7riE1hNDfrXqyCKkhQPgbd1mPBx\
	i39o7yHoJOrZhhi4CIpxnd8UdPb7lWiDyx0YqRJjHDFZfd5L24aheBJ8A8EyM7NiGFapVW\
	dId/6232APCTlCAH3n3R3wKHANTFTYQ714FcbvpvclDvaSbySO4O3oWZWiuJckL39cAxzM\
	gymeMXSDx1pCzPo1L4vtJCpHMzkl8FOIUZbbjupe+kki9a7wDx3W9iDCbL07gMBB66g/DD\
	a0GVwTQom6hR8sVCI+YWWQ1gXE+S+N3fyL7p6A5WBLk5Svh79+JbPt+qeg8z71/T9JmFIP\
	A88B2rQvuon+SBHrRJHg1SQ4BAx5cIti+z5wb/pwlQOyaksLULV0kf7kU7ftlzqFHyKygr\
	m/Dfswj/2oX2uMxnlsK2I4KZfXocyN1fEAL98hDahUH0gWGMoQSkx2/8qoxUF0SZXY/SOg\
	t1cZN9tcD0L3djvrxJHbrV/I0kAnwLM29f6W8kx4G9mB6KN6+7BKpJ0I4mYDNmbHU5MA8z\
	8mXtvRSmsejDNPsnMPP+FQZgnVErgv83+Nz/qzZNcKpjmuBUxzTBqY7/AmDdgoJ+h2mjAA\
	AAAElFTkSuQmCC\
	")
	-- o.png
	R.chain[1].o_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAABwAAAAcCAYAAAByDd+UAAAAGXRFWHRTb2Z0d2FyZQBBZG\
	9iZSBJbWFnZVJlYWR5ccllPAAAA2ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBh\
	Y2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4On\
	htcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBD\
	b3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj\
	4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJk\
	Zi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG\
	1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJo\
	dHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxucz\
	p4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9j\
	dW1lbnRJRD0ieG1wLmRpZDpGOUVDQjg4NEE5RERFNzExOUU5NkI4RDIzMkM1MTczMSIgeG\
	1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpDN0U5RDc3NkRFQzQxMUU3QkU4MzgyOUU5QkI3\
	QkI5NCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpDN0U5RDc3NURFQzQxMUU3QkU4Mz\
	gyOUU5QkI3QkI5NCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChX\
	aW5kb3dzKSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaW\
	lkOkZFRUNCODg0QTlEREU3MTE5RTk2QjhEMjMyQzUxNzMxIiBzdFJlZjpkb2N1bWVudElE\
	PSJ4bXAuZGlkOkY5RUNCODg0QTlEREU3MTE5RTk2QjhEMjMyQzUxNzMxIi8+IDwvcmRmOk\
	Rlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJy\
	Ij8+P2blLQAAA3ZJREFUeNrsVltIFFEY/saZ2dlL2paWdlVRuthNdk0LsqS0HurBLlIkkb\
	30VI8F0UP0EBEU0QV66imCKHrpBqUZUYR0sVKLpbyVlenmhXRdd2Znpv+MYu2ONbMF0UM/\
	fJwzZ8453/n/8/3nHE7XdfxNS8Jftn+W0Ec4RWgkRAj6aNkw2u63S8hZ7GEW4SxhvT4kQ3\
	nxDuqHPmiDw+BEHvysyRAXzUZSqof1vUHYS2j/XcLVhKtaT8gbvlQH5V4b9Ig6Tow4iKsy\
	4dpWBH66t59aKgg1iRKuIlSTR2LoxD3o/RHrULkFuPcWw7FijkKfZYT7dgnTCU1Kw/u00K\
	Hb0KNaQqJw7yuBtHJukKqLCZ/tiOYYhTEtdLw2YTJm4dMPoHb0TqHqUTseMpE0h87V8vKt\
	t+bOHhFCwXTwWalI8rqhvP4E5W4boMVGSVg2A8kHN7ANz40XkRA353atf4hX7rSYyBzrcu\
	CuKgY3QRprk0oXQF7ajKFjtM/q92hE6z4yNfP8zEmV9HnkVyFdq9S3m0IprpwNz57SMbJo\
	4BPClx9D7foKx/JcODbnmRYoP2llRWl8e7yHC6PN3abBzo0+oxw8XQ2tcwBaoMdYlPygBS\
	nHK+Aq90O+HoAejo6NUVuYbrDISjSp+sCwiVDITYfWF4JS3Qq1KTgWAa39KyL3A+CSneDz\
	M2LGaF9CxnyWKh0vufVhBZzAG0keb2prcGSijOS4QfbO0p6kyW5Tp2hLt+GFuCbb9I8pdo\
	Q5loFLdhjzWRE2svMx3oZvvDRKz25K6k154NKc4CZJkEgszrKFI3xvgrELmellRZOVaGrE\
	guySMOpiPXzYgXBmHZ2Xy+DeVWzgR4vUvIIaiHVG9LGURrWtxB84fI2PPu00hy8/HdLaPA\
	g5U8FJItSPvaTUN5BvU97+MA+fMxEpJ7eq4DjLxGc/L7gqC6sGn1+PSWYjbC+6MESwMueO\
	InKFuzjeVTXeWXpAyM0ISlV+/I45yufD4c/+QtX9dm98dsJXuMp9irNySWJk6+fAs3MFu5\
	62ELoSvYDZsXRFrm/3hs8/gvZ+4OfvlKkuCmMhpJJ57ALeTKj9kyfGGUS1DfKzNij19MTo\
	6IcekinPJPDTUiAWZEHMzyQRCTep7x6rJwYYoQ34CacIDYSIPmKsbBxt99mcx9LD/w/hhO\
	2bAAMAGcakBZrrNusAAAAASUVORK5CYII=\
	")
	-- o@2x.png
	R.chain[2].o_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAAH90lEQVRoge2abXAV1RnHf/\
	ty3/NKEhJeApeEgLEqUSRNeBGKIjO2aFvHStXWji3TdjqljF/amVpbO5WxnSlDazuj0mod\
	2xlKYaTDDFYEq4DyYkcGSwjUxIaEAAkQyMvNzb27e7cfNnvvDZI9uzfJWBz+n/acfZ5z/v\
	+7557znOccyTRNPs2QP2kCE43rAq91XBd4rUOdoDYXAiuAOqAWqAAiw+81oA1oAQ4DbwN7\
	AWMCuCCN4zJxA/Ad4GvAJI++54HNwG+xhI8bxkNgFHgKS5h0NQOzL04qrlkdqjLypAhIVz\
	U1gC3AD4GOsRKDsQmUgLXA02SGH5gm2vFOtCOn0Ju7SbVewoxpIx19CvKsQpS5ZfjqZuCr\
	m4HkH/FviQFPAL8BxvQFchVYAPwZWGVXmHGNxJ4mEq8dJ9Xe741EUQD/yhqC99RZXzeDHc\
	DXgcu5kITcBE4G9gA32RXJdz8k/scDpLrjufKwyIRVAg/WEVpVBz7Frj6GNWGdy6lNjwLL\
	gXeAagBzMEns+X+ivdmWS9+jQvlMKZF1d6FUFNpVrUAj1mTkCV4EhoC3gHqA1Pl+Bta/ht\
	FyyWuf7ogVBch7YiXq3Cl21WFgGeBpmHhZ6J/FFndhgP6f7ZgwcQDm5QQDT+5Ebz5jV9Vj\
	TTqe4FbgvcA3Acx4koFf/sPzRJILzEGdgfW7MDrTP+Qa4Ete2nAjMAT83i7ENr2NceKilz\
	7GBPNygtiG3ZhD6aVmIxB26+9G4OPAdIDkgRa0Nz7yTHKsMP7TQ3zrYbs4A1jn1lckMGQ3\
	ZiZ04i8fyolgurNoAer8CpQbS5FUb3F+ctvx7KH6+DA3IUTB9kNAKUBidxOpzgFPpJS5k/\
	A1RFHnVKBMK0YuyUu/S10eZGjnUZJ/O4app4RtmXqK+LZ/kbd2BUAJ8DDwB5GfaJnYCyzB\
	SNG7drPriUWpKSb0jUZ8t1QKbfXmMwz84nXMvqTQVlJkCjatRi7Lt7ktFfk4jZPJwCIAre\
	m0a3G+5VHyn/myK3EAau1U8n6yEikk3rmZRorEvpN28Y5hjo5wEnin/T556L9ipoDaOJ28\
	tSuuDJwzMK4+FNUbphJ8bIGrPrSDbdnF5SJ7J4GN9oP+wRkHMwtSxEfku8tAyWoy679ltJ\
	2nd91fubTqeS7d+wKDL+8f4R9ceTPKXPE20jjRg9mXDmYWi+ydxsU8GN7LtfUJO/avrEEu\
	zuwEUl199K/fiTKtELk8n+SeFsxLCeulaZLY2gSqTPjhhVadJBF8cD6xn7/h3JFporV04b\
	8tCnCjiJfTF5wJZE/NjvA3VI8oDzy7h9RHvWj72klsbcqIy0JiyzH0lq5MG7fPQi4Xr+Gp\
	02lOs0W2TgKnARgX3C0NyoyS9LPR0YNxtFvslDIZ2n4kU5YkfIuiYreeNKdSka2TQGv4Jj\
	QHk2FeiowUCaTLxln3Qbj+TgdmPLNEqDXlQh8zlrYXLvbCcMKMiwWaRgqy1lMp6Bf6pH31\
	FEZHJrbNHgmjO7nfwzoJjANIeQEHkwyM7sw6qVZNRlI8hGLZkUzAJ7bPtK2LTJ1YXACQ8o\
	PiDgHjw0xGQcoLoH4u6soPWUKZ7i3LKBenJ6JOoa3DuxYAZUqRq06T740MBsJfbUAqEf84\
	vmVRpILMX8nsGxT6yGUF9uMpoa3Du+MASnmhqzBK39eBcbY30/DkfPKf+jxyZf6oPsrsIs\
	KPLhrZTvNZYV9qVZn9eFRk6yTQCjVUGeUWYciHqRkMvjQyOlFmllKw4QGC36pHubkMKawi\
	BRSU2hKCj91O/jP3X5kmJLnXObEtFfhRKtMT0QERL6dP86b94JtXiX5IHK7pB04T33yQ0O\
	qGDKGgj9B9txK671ahf2LPcYyTPc6EPzsdrL1kCit96QinL9iNtSXBv7AG5Kum2j+Gob8c\
	Jfbi3pEzowtoH7QTf0H4QfA3VNmP7w5zdIRoLn8FQC6J4Fs6U9i5jeSrzfT9aBva+21CW3\
	MwSXzzQWJPvo456Dzry9Py8M+fZRf/5IaLaMMbwjoEKdFbu+hft91NmyNJzSzAt6ASpWoy\
	SmkeBFTMgSGMc33oJ86iH+jAHBAHEwCh7y8iePdNABeBSlzkSEXTYxzYADytVpfju7sabV\
	erKzI2Uqf6SJxqApo8+V0JpbqQ4PL05mEjLhPAbsKNjUA7QPiRRldr27hDlgh/+w57cukE\
	fu3a1YXNIMOZNbk4Qnjt0tHO9iYMwYfmodZOtYvfw0P63m3A+CqwCcB/W5TQmnpPBMcC3/\
	Iooa+k+3sR+LsXfy+HL2Gsw5cFAPEt7zH0yvte+vIM35IZRNalczw5Hb54PT4rw4oeqgGG\
	dh1j6LmDmNr43x/wf7GWyKOL7f9dK1aGr8vZ6+PI5QB0CrCL4QNQveUcg797C6O119nLLa\
	FJQcJrGvEvnmNXHQPuIgdxkPsRdhFWEPAFADSD+M6jJLb/G/PCUC7tIQUUfPfMIXT/AuTC\
	9O5iB/AIIM56jdbuGC8h/ADrEkIYhs/p959E29+KfqTL1c5bmV2Mb0kVgWW12YF3DPgx1r\
	WST+QSQjYqgV8BDwDpg3Wzfwjt5FmM9oukuvut/2lCR4r4kYvCKJWTUGsqkMsLstsysUbG\
	T7EuC40Z43kRaDbWtZLVWJORF/RgCXsOODFehGB8BdpQgSVYByP1WMKjgJ1siWHdmGgGjg\
	C7sXYGwvxKLpgIgf9X+NTfNrwu8FrHdYHXOv4HXDGZ3/Dil9AAAAAASUVORK5CYII=\
	")
	-- square.png
	R.chain[1].square_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAABwAAAAcCAYAAAByDd+UAAACHklEQVRIie2VzWsTQRjGn9\
	l2t7GktmmLJiD1YPw4+HHwIIqi9FCw0D9AsRRF/Ac82LNQ/wJPQi+CV48WROqhgrZGglJJ\
	CYKGQm1Mk7j5aHdms/N4sFg/ss2uloKlA3MYeN/nN8+8vO8IktjOZWwrbRe4I4DtoTM8CX\
	pr6wdCWLFQ6eEcagm0dRwWwkhBleaFFRuga4eSAMlAW7t1kLxEuWKr9DXKl6epv77Lk0xq\
	WQysEwymKiA5quuLrkoN05lJ0JlJfIcW58okT1CuBNJq/aRuFcLsus1q9mFj/kq7XktvvE\
	5jCWrheg9Ksy9g9Z2hLLSUEy1GmwBwD+XUuFy4BXjLzaOMKMwjk6tG/4UROsvTIhL3FfR3\
	6DkAcFcXpsdl5qo/DAB0DW72RqfOP50SkfggZcnfga9DzwHcSkGmh/rhffGH/aJmwTr5zE\
	Yk3iPMaNMQf4f0gMi+UevYZANGbwBaG8yBCYiu5B1o5X+nzWpIVYawYsO03z92M2MdbCw1\
	DzT2wDx03zP2Xx7jau6R6Dz4d0AAoGtDmN3nWclMNTI3o9r9+BusF+bRB3Wj79wInc/PRS\
	SxqV7APrRB8pSuZItq9uKPPlSvzlKX3+ZJHtdOYesa/6fmT+rap0U1N0j1eoi68iFD8oCW\
	5a2dNBvjrQaSCV3LvdG13BOSe7WqhtJoWcM/SqBsQLvr9TMhrO5Q+aGB/7p2/o+/C/z/gd\
	8AcTpAf+9BGPQAAAAASUVORK5CYII=\
	")
	-- square@2x.png
	R.chain[2].square_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAADpElEQVRoge2Zb2hVZRzHP+\
	c558w796c5YbG1miaVu9tKeucLEyosK7GwIChEhjGKIRYGUYkyohgRMkYGG4kU6asiYrKi\
	ImS+KMIgWLoWrJW4zMlWY+rN8+fbiy0ha5b3nHPlyPnAgQv3PN/n9+Gee5/n+V1LEtcy5m\
	oXkDSZYNrJBNNOJph2MsG0kwmmnUww7ZRScB0wDJycf10aJCV92ZK6JSk8e0L+T/slKZD0\
	tBQmPn/SE1RJGpCkcGZUF75ao8JQvbyRrnlHvagwSLQGK8ED743AAHC7po/ifd+B/ImLb9\
	pL23Fu2wXG7UbhC1jJfFuSEmwDBoEbwskv8H7ogHD2HzfZtZtxVu4Gk9sLdAKxF5OE4Frg\
	I6A6nPgA78ftIH/Bm+2aTTj518Hk9gNbgSDOYuJ+Lh4DPgWqg/E+vLHOy8oBBL+9jz/cCf\
	7sFuAgUBZnQXF+gtuAPRCaYLQb/3TvFQ02Vetw83vAXTIIPAqci6OouAS7gJ2EBfyRlwmm\
	DhQVYhavwW19C8pqDwMbgd+jFhZV0ALeAJ7Fm8Y/voNgZjBSQab8TtyWfZCr+xp4EJiMVG\
	BEwR5gmwqn8L97hvD8l1GyLmJyd+Dk+7EWNw4DdxNBMopgJ9Cr2TH841sJ/xgpNudfMYua\
	cfL7sCqajgL3UOTjGkVwRjPHqrxjm/+2gMeJcZfjtLyLVXnzIeChojIizP+5Vd6AKW+LEH\
	F5Qu9nNPMtwKpiM6IIPoVbM+a09GJXb4gQswCmHPeWPkzDIx7wRNExEUo4A9yHU3nSae3B\
	rtkUIeoSTC2LVh7AXL/+PHNr4uFio+JYB5cBnxF6K/yRnQRT70QKM+5ynOZ+rOr8FHNr4Z\
	EoeXEt9A3AJ4Reqz/6CsGZ/qJCTK4Np7kPq6JpHFgPRP5pjnOrtgQ4BOHqYPQ1/NNvXtFg\
	U7EWt7kHcnXfAA8Av8ZRVJyb7WngXjCD9q0v4dTv+N8D7es24rb1Q65uELiLmOQg/tPEOe\
	Bh4KC94jmcxl3/OcBe2o7T0gNO5dvABuBsnAUlcYy+ADwJ7LWXdeDc9OqCNzr1z+M0d4Ep\
	243C2M+CQOI9mS5JCk+8p8JQowpD9fNXw1/NJ09Se5LNp8S7WpK2S1Iw8eGc5JEmBb8MSN\
	KspPuTnr8Ugkh6XFIhOPWxgskhSRqXtKoUcyfZVbuU1cy1JIaBLczthBKnlIJXhey/ibST\
	CaadTDDtZIJpJxNMO5lg2skE0841L/gnbItHb7ZckqQAAAAASUVORK5CYII=\
	")

	R.duckloon = {[1]={}, [2]={}}

	-- blink.png
	R.duckloon[1].blink_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAAJEAAADNCAYAAAC4lJKvAAAAGXRFWHRTb2Z0d2FyZQBBZG\
	9iZSBJbWFnZVJlYWR5ccllPAAAA2ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBh\
	Y2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4On\
	htcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBD\
	b3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj\
	4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJk\
	Zi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG\
	1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJo\
	dHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxucz\
	p4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9j\
	dW1lbnRJRD0ieG1wLmRpZDo1ODIzMDc0RkJCRDdFNzExOUU5NkI4RDIzMkM1MTczMSIgeG\
	1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpFQkYxOThGRURFQzQxMUU3QjlGN0EyMThCNjhD\
	MkE2QSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpFQkYxOThGRERFQzQxMUU3QjlGN0\
	EyMThCNjhDMkE2QSIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChX\
	aW5kb3dzKSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaW\
	lkOjVCMjMwNzRGQkJEN0U3MTE5RTk2QjhEMjMyQzUxNzMxIiBzdFJlZjpkb2N1bWVudElE\
	PSJ4bXAuZGlkOjU4MjMwNzRGQkJEN0U3MTE5RTk2QjhEMjMyQzUxNzMxIi8+IDwvcmRmOk\
	Rlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJy\
	Ij8+hrRElgAAMoZJREFUeNrsnQm8JEWd5/+RmVX1zr6gm26u5gYFBG0ZGhGlQR0PHBlHh9\
	VVx1HBe11ZZ1V2QHfF2xkddZxZ1HGd8QQFQVFnON6oyH2j3Ec3DXQ3fb/3ut+rqsyM/ceV\
	GRGZWZVVlVWvXnfl55Mvs/JlVWVmfOv//8c/fhFBKKUwWAZLJ4szeASDZQDRYBlANFgGEA\
	2WwTKAaLAUsLDamb0Olrlb6g++5G9x3YnruH68tvY9y3E9oh95GVii/gLoXNx8CtcFuC7X\
	ADoSN/fg+tyBOxssjQA6FDdf0Q5VJUBDuLkc12W4/nEA0WBptHwJ1xG5H+C6Qe5/DNfjJF\
	RrDRe35Vtn4fqtAUSDhVmhM3Dzeu3QutIxv62jFVqJ+x+Vxx4uH/LPgQbQu3FzFa6bBhAN\
	FrZ8xnr9kNx+Edchuf+ABtBrcPMNXIkEaQDRXm6FXombk63D96IVej5u36gde0ACxGpo35\
	NltxHX2wYQDZZPphy7FddPWMceQICYVfoprovksV+U931XONc34O2tJRfeupAVxJFA6EFA\
	nINw/wAAugT3F/FCIsTD/y2KfmeE+LhOy/0d6Ei24nY7rmy7Ho8+ybfEeco55ql6Tiv0sh\
	QrBLR0APue19kQ4Xoxrs/Tjl3ZD89yr4AouHmcBairCaFYYOR44PmWcH8OCGVhBf6YiSNC\
	DCr3edIVX5NQGmzcUocBFP8PtMRsdDz0wwcPfBhf34+f80c87XZwyK3O4WufTbm0j6Qc2w\
	juwv9qMw+jJ7Iq/vnasRlcr+uH50vSMtSEPZD5DM1NY/vjnb0cC5/90tm6PL43BYDaKEtD\
	JUhsvwQw/Bz8VwX33ej0GBSsbYc1uZ3CY1MSRBKfRxxty76GPIF/bsLttXjs2mB2BbN49y\
	YffvkqWjniVbhXio85T8DoC9jeoboVQld2dq+fbRove4wlQnAOl4HoG3BdxS1MZEX0h0Bi\
	kPhGO0dZIQaEtw8W43IBkVPGrccKGPc9DhlhoKmVHQtn8e2TeCFbcd0M4GPNO0AvF86Izw\
	8RACc8FELnzbjFj53ZSYPhZCGVVgwZALGlspJd5OHWqVf2y7Of1xAFNy7AX3P4JuThHfjy\
	hckSaQEk7qqoAIktUzcCLDgdn9BizpT4CPx/iKtDgUpXRtiW7TrDCMYCgDIaC6ckOGDwIV\
	S0/hQGQI9h1ep+fD/CFXpAg6GFKY4B3zNqxkjOCAP6MPvOcL26X8phXrqz4PeLT8Qr/zA+\
	y3NwrQhX0vAuUyuiqa6NUOVCABgUDCRWkMwSMTi4eyvL/RLfJ5G10qwTka8d63W4E2j1cQ\
	h3PQx09kG8fC0G9xYC9Q4wL5K5VXfUvvQb0ZWdOhfPft67s+CGpa/EUmDNAC8VrkfLVNAG\
	IDW0SDJATrNIAbqn6VsAxk7l1odbJPY/6fFErMPeWhIfT4SVMgyG/h722kEDNHwacnkGvv\
	QRpD8C3XUr0N33AnWXmNddWpoGEPRDgnHeQRT8btkreT6FYu2KOFoNqnOQYl+VAVId3c/u\
	ewBGTpCAKJeWdG/E/p8BkzqP/dOX1s4DMrIKCPNgGFOFs48gTHciW1uExSsfkPVI+gqivn\
	ZnwW9WIDT073D3VAGALBAiCz/aysLla+uujUTHaLZrY7Wj8krpnjzLVXnCneFvkqhjelyk\
	3JkjgnNKWOyMK6lo7g/3nSEOD519DCt/j+JvppaW4Vpb3ve8Q+eqTFJ56UeIgv884EC8si\
	/gJb8pLnhVk8oBEgmb/XRaB4lBMfZi5GSJBZJnxULo2uxjHKT0GIkyeKDMISIO+z6ssSFk\
	1Bnj7jSY/QPQ2vo4zoZ7Apfc9EVw3M+QxbdMDSCy4Zk4kJXi+7EAP40gjMcVkT4BycWCHT\
	+N18QMkJQlIp4GUskCSQuu9eDbgEp9RoWDBGRMWC4G08w9vJbnhVfgZ29kF7sRQfofCNIP\
	BhDJxb/+4GNw811Cwj+JClAHpl9AKq9A17bKzBElYMkAKYLNBqls1uCMfQbUCN+G9Q3gTJ\
	2Pt7mOJS+Fm3Xcq3D/fWThzU/vtRD51x2GVaTw/biL7iscFt8fallk2iZIoXVegSCNHAtQ\
	OVQDwwbFdm86GK7m3jzNzTUACdS+VIXMXgEwcwnbUSDtRJDejyB9f6+DyL/28CV4Bf+Gu6\
	+OCzuECCSiIKFmbWfOQcLt+CkYHy2KYbDdmxX/EEcDJvp/A6sE2mvQ36vyTZsBpj+HD/F2\
	BRKzTt/GC/8QWXDTrr0CIv+aI0/CS7oMr2BlEooCQCKB8Vntg6Q9C6K1szkYso2v1mId5a\
	rcFtxbybJayipVJERa3AQqVvJMC1XF2v7uL4v7Y+XmkPtxfT0Zv+mhXkE0J3oi/5qj34ab\
	G/CuV/L8DZUFRR3jsih1JDfqHGIm/o33yCYMkO+hrnmLtMmtqtZ8KxlpgKuaRNhx1vA68z\
	DuI6ysKh76olGWbVkWWq3sGBUr5f+PX4v3aedGx6raOWq/Lvfr8THA/cprARZ8B2//YNE4\
	HNLn4noTnTrljD0yT1T/9+fgR9OL8W4viKwGaJYmxSIRw03ZFolaAXivLRKI/FFpH2EhWF\
	XdUc0irhb3eIbFIkatLC0uKiXjI26dvGQND+R3MG3/9KfxFzqhLJLPA+7xm765x7iz+q+P\
	xcCA4k+GvpkoELoCkh7D9AAkF4NdlnF2SomWfojiIDeGBARQxEhI2jklGyK96m+7NS8Gib\
	3e/S/o4r4jLl/A9HEE6XPzHqL6r49jXWEuxUt4jQIgFSS9VjafQKrsDzB8NCPKio00iwR6\
	I60GkgFOHqtkg6UH4nJbuw5hQqvk+BIk5/Nk/MaPdQuirred1X91/AiW6S+wUNbE0gvhvk\
	XbJ401PLzNKpTtXDR+jYVJKQNJtY/FnxPv6OfrjaqKKVeCpL4LGjeP8GuARIxkgKTa8Kob\
	sOyW4Vcs0prjSlLAVpZtbmVLUiIvNzpfb7qh1jHQ/gfpW6Ldb/lM3I4iSBeCEM7Rj9KpF0\
	FRIPU0sK7/8gQBEMCaKHjWgmSqgmWaEgCnBNtUD5ztYDtxvvWaaufw73LMNtLUJUz5JVrB\
	Nj8HX888KoNeX6xc+RjEwTbU5P9qRtDN2sd4G1kUcPtxQG0E4nUt0NaCa2r/XwbcJXSxo1\
	8SShkGuwDp4/MqsK5ffSKz4b/CbzgjdilWy3Y3XFta1d/4vFC7jhAK1SINHSoy2lEc5JkJ\
	SBYjgZ3l9qJqPEnLaCcacu0mkrJ5DCwX59+LAfeHpWtj+SRyHlqkbxbpzrpiiepXP589Vt\
	Y36gyz2k1SqtU9tkiROF/9r4lFSqn6JywSlUBWn5bWoxpbJGUlQlWd17aR5RLHqLJguvWJ\
	3iPfF6ZZH81KgZ4CwNU7Hi3Sp8R9CIv0T2iRzux/d0ZZv3LyxvT8DbEKl2iFQtJzOylgtA\
	0S1UEixYJEZ7HcWBOWhCGCRG5DHRpfwmbmiCjVoFEuTXdVtJ7MNRlrCkil1WglPypiNBq6\
	CNJlCNIRfQtR7ecveC8+3POjws0FkhMXCs0DEmkfJOgGSCQGqYZBdjCrgeRng0R9ExKZZK\
	RRzFQXEEQJyWpqEtOMj+rpMVLlFehq/1KBtBi3P0GQhvoOotrPV70YH+g/mOC0AxJ0DyTa\
	DZCsGlv9GZm51iGpm/u2q4sgE/vZFqmatD6hlfFW4OgwsdfD78Ya5CoJEj0B1y/1VWBdve\
	qFTMt5Bwac+6mfJSF6BplmZJRpIgBOT0ZawTYxq8QtB9tdVUfiduQYoTvi/c60YJonG724\
	PUwPso3kpBZsJ7LX5WRnAEjJLYGVpGSvWR+5qXfi/k4pJyFnkQU35e450rXAunrlSS7+Sp\
	kMYT+qWRhK27NIqYG2YVmIZUGgeIvUVjubylExa7RZWoJAC5CVRfLj17oViYJoX1qfeuza\
	DHdVNd2YslJh1QzKwXJv7DUTuo38LzwvFLpvioH25CkL5t6dUXIB8B4YepCcEyRoBSSSAZ\
	JTPEi0Q5D87RoggZY78i14fAuwunA9oV5rw9WGLbRAiuKlWuPAW9XYymfheSyPRQ/CL/jC\
	nLqz6s9OxtCf3sBTwsR0H0RzVQ1dm50Taura7HY2zQ2BLmqDuVVHlpeLLDbPD3myCUTXHK\
	W5s1Iyv5QpcPMs2W05qU1Ka7RlK4N38lzcbmbXRdG1nUQW3nxHz91Z9YqTK/icvy2cuOVu\
	8lqktMA5r0Wyvs+QkCSy1O1YJOjMIvk7Y0vDrUug1dQ012ZYmLqZRzKCZssi2XkkaklIwm\
	qyVhe5Niyy4ffK3FFA0CJ9ne5cTXrvzii5CNgIGxTS45Y8INGiQHIyQCIdgNShFincrbks\
	XwOpnkg0xnDV0mMl5d7SdElGKiClGcSIo+pxLql0EhqqVQqk1QjSG3rqzqqXn/Jc/PZ7uL\
	0kWTWwFlyb7Wbadm19JrMtLREujdfSPE0W4phuzZDU2u7MS+0YQKKampfSc6SU7sbsY8EG\
	dGsfEPfmeA/hhx5HFt/i98qdfVXWG+WvPS1w1hK6nVqkrOaRPBapXXUkOOn5qlYsUjAjcz\
	a+mcFWFin0TRcX1lKSkb5mdeJzqZFjqsVNJomgu5bRWItbdwVapNOlKtI/Grdv6Yk7q/70\
	RX+BD+zMhItIBYkUA1Kjdra2QSIpycWCZbbc/ahYKNAy2L4AKaqJBSngyDY4XnXXYyc/cm\
	dUh8dwh9UUl5bh4obPwfPlwF5h+DG67U+crkJU/cmpHj6oz2dZi2Yg6YXVS5Ayq/7qcww4\
	CgRJ5omYHsoESIuVIguj67XrJliJzLSV3QYbHDtvlKXbxi0bYbCyRuSOKD0at2d32RIRNh\
	bQ4cmakQ1M+nFqteQXDlI7Lf+pIEFxIIUi6Ug5FNIaGW1rCh71vzThvwVSqINU47U2UwWg\
	C/9rGe5NO2foLPkjZN9Dz+8aRLOXnTaMhXFRsrDaBYkUD1K7EhLIavnXgEqABDlAAg0CBZ\
	IEh4vW6hpIVc3lVS1wUixSmNKjxGjMradLUdJAcvbF2GiVzGL7p9LNq07ojiWi9K/w4R5A\
	Uwu7BZAgCyTIAAl6A1IudaQOUl51JBXASEuUcG0aZMpqRbEQ1QNwPVaqm+kBzQLRRIOvHZ\
	wr12dZpsrLleaInf++wiGa/fFprG76EdBbrNsFiWaBRJK/cJrVuj5PZLb83CC2PBKQKNjm\
	1sjX2tmCWFrL93WLFJhta0YzhwmOaZGq8fmh3aam7ZeOwttdoUD6L/TZE4aLtUSEYI2MDT\
	4pVPaUdhmkRFV8PqsjwaqdCaBoGGrxUaCBZMVLyiJFtTQNKOqnJCdt12ZJSEIpDQkt3TZ+\
	Pq28RFqicAFuzy4WIgofiHpZFAESNAGppZb/HoPUqhZJ6Hdiy0MDDSS172sWJjBzRQogJf\
	zX1ZE0Q68Uqo4AvglSaKkjQ1MRScqr5PNngIdvLQyi2R+9lE3WdhqkxC1tg0S7AVK/ymxl\
	1psXjOnWYpC03BEv1FCr4mtuLiGzrafkh+weJRpkYHfT1oPuKhu9FsA7RlmjM+mG4xYWZY\
	nemyy09Gx0kSD1rToSmmiRqBW7gQIiDSTNtQG1ckeBVmuzkpV6e1toS0usWIdX/7WUANTS\
	uyMp91Z+Hl4P79dfxp3XNoOjaefF2R+eXsJ7e5PoHKd36JOd5UD0QjQ79lGtA6Lc6j0W45\
	6LifP0z2HtNMQ+P/oc2ZERtM/XOjCyLDWJ2sAyOkdqcZf4rozOkYnOlNY1NByElJqDrFPt\
	+bFWI/011Y6pUWfDkpCQQA2Sv16r/Sbq8AjJDpEIBXW05kHVbhjSxHmkfLx4xZ5JyOcY+V\
	5HEOGC9T7YJwLIePYmHFFZ2yABSZzbC5Di83TPooFkx+/dBgm0Z6hGkWUNslQUqvgYKvU+\
	NhwgQRKD7d/xgAcPrsPng9fpOA5U8aNcl8tdoR6I/VKZwqpjAzjmMA0Y/j1UfI9tDKLG7j\
	KSsRIvbx0bFffl9KnnuOTAB4L2IaLw5ujBGIWtBY1EB4mCIQJQ3WqI1b2mSJAgTALLJCSq\
	o6N+nn0fYP4oxFcUCBJYojj1f+5DXQkSRLCLj6lrIPnSQsju2HjeH55w4bPf8dBAEfA8Bg\
	zwredRcL0QSmzrBuCVCDzwmAMXvseHypBptQRIAOaQyto5LC6qr2X3uBCfymrc+X1bEM38\
	YE0JP+4sEpuYFkDSodFB0ugvCiRIc1ONQCLRrz++p7jQza/QzW8bIEXn2SA5Mh5SFsmLb4\
	n/W1kdZTFq0rUBPLkhgLrvY+HRlAA+tqpUPudqNYBKOdRAofIHI8feTrg1xvDhQHeFQrIC\
	5GWNIHKaWKEX49+F1G5ApWbV2gycqdm4mrhHkt6kkCPYbqjXLkQdSTLUkc3a5lpRR1LNva\
	lAm2qBs0pGhlJCEmoBtZCQrD52FsZH6uD7Aa7mtl6vgV/3EbI6uMSHU0+chQUjVvelKHCX\
	ArdEgy1uXTYzVkU1yp7WSUx0VvTrwD/EGDUs3SI99qwPX/v3nbBjd5hR1RXLsoUufOjVY3\
	DgPq45okXis3NaJD0WatUiqUAzep+ySI4QtSloSTsWyQrqDYskhW4KPDZqibKQVHNtVBWT\
	cG1Lxil898LtsHWn6LvP5hYZGfb4uJDE9WB4yNW6JMmtclnK4mgjlESXaVgl9raDkeOH2L\
	mrw3VHe87Kh/x2IPrTqFAdfWiV9MJmD/JzV+6AGx+ZzZcEx/ULb12Y8jltgGQXatsgOcZE\
	eRFItgs0rrFdkPTrVSD5Ahp12SE1VKH889ncNfj/ZYvl9XBQQqlOlOdEt0BjVWcoz41qfv\
	FcJEaMpIJ5NllN7UH2YhRfsxkf72wJopnvr2GzlRwLiYpYFkjiYUxX809JurtGG9TkdCPT\
	ByBB2rhI+jU2AAmCZJpBb6CNar7yux0dJCq/oi6Ki6edfNHxUF1ASGLpr17N5/6/lBgXKZ\
	6wBozXpkXC1V0u3S6/9lVZEDkN4qGXGCbDAild8uDAB/90ERyy1IPxIafheuQKD97z8nHI\
	p47sZ5ktKWAQUhUjyQQRtx6+kZQULf/1pITEaEMLjCaPqHNAFA8FGb1INIEbaz+TMRNhsx\
	5RUHHbqnZiolPj2knSOmRZpBcdMQJX/82QUW3Vq/jEFudHLiIll5SaW7LVkS1apEYjtTWx\
	SPHPNWWktpRrM3NZ9khtTnLAUj2XxOSqTmCGfOBYFklanZDFPvVk7Blq98ItEpV90bISjW\
	C5t5KYWivcwU4+vh2Inm+Y6xZAEr+00KzCp1X/82a1reM8yI++twsgpQbOOYb809MNRhjQ\
	Akh6Likkcfd+w7X5mitTH+dqU2RpxariIFBD/tVkrxFIur/Ikyn3xrb7oOHbxk46tnWIKE\
	JEwMpSp8UrVk1er+HQXoGk/lUQSCx2qocQrCcQbMLjPlqAIbQDWJN0V4TgjOcFSR87sh2Q\
	HFHFdohlkSRIKtsdahP52ZP2GTFRnPFOTEmqJvwLrS2zROIjF4aPrGQTMm/MBdHMv61h88\
	QvMdxZZK5NkFjanSSaFlRysYsgAU2016UmCaPPNoP0LJDCnVg8jwbgr6MiHtbd0xPAIXAW\
	U/BWOuAeHPCB9YsfhFQHiRjz+kUZZyqbLghYbW1ZFkkHzKrKG+fobpJtF6ip2tmLo3JDhN\
	9xlJm6t+eB7wOQIFljM8BKgJQ2MyOJlKv+egRnbQDh1qZ6Vwi3E5jdRsC520HrxIAKcQ2A\
	jIbZOaREdZ6YnR0T12bnkmTjLMhMd9TW5scxjQ6UkzLqbGJWyNCo5hvuTZ3LZjiKa2iH4J\
	/f5nVnh5m/DrsanhMkOyYgDcDoGki6m0U3NYM1nSqeM4NV96kQwi3otjYHkdVZPwnw+A4C\
	xy+jsCRjHLHfPElgN8axZxxCobKVQG2rC7U70UKNocvbF+OmcfxxDOM6hPvD6AqHQ+4OST\
	k0g3UaapUKJwMkqtXmfGnFHKuJhJrw8FSBa111LSW4LpvVfOXSqN6mVoktESGHtBITHWVW\
	j9sEyXAlKUAYsU0bIEF6MlKBBAhM8KwP4TYf6CQCM80mB25saZ6ZIrBjFmDTNEGI0s9lre\
	Q++ygZ4kQWCt8TTrvZydUSQrYYrdaRdfCOqLYwj20Ya82tZKQAyREWiaa4JKoCaxUw68G1\
	1j4XWTEJrlNWFy1ukovi4IBWIDrQYIQUAZKWUCsKpIysdrjZB//hWXRNPrS6HIcWaN9pgI\
	Mb6PlOX0k5ixW3tc+mdQzUn3X5Gk45UH7+TAsg0ditEDMZGbu2epytjrRIGlgsEGcAKUvE\
	/69qbdXYCoVWFpGNtEbZ4BR0eSsQ7Rt9ip2fUa87BUmXhAAUJmqr370bgier0O4yis/18M\
	VNlHxO51MR+A+UEKJqizNrS5B4M5QCKT6XDQxLHCX+l4TzHJKWCuCpg7ocM0kBxhKNJakm\
	0BqIlTVjEIW72DPfrxWI9jfcmJ44pDlAghwgdUEdSXeGHQHUy4VZJVrF+604rYMUFb4vYh\
	9e1VcgUTFBn6565BbHN+OhqIpP4ip+qLkxbs1qsmzK6oe/T26I8PwlomZP2gNJlXdukIgG\
	UgfqSA/mzeIsDcQA+EbFox2QAu0z1GNSojZqWSSQ7qxk1eKoVc0vma+jJiS6oBVLNBwl7/\
	TCs0FKJBg7AAnS1JEkAVkjkMiwB85+ZQg31foXHqy5eUf5UDq6nt480lAd2cgiaS3/zKI7\
	9WTxGq330rowK0X0aj6x4Crpz7sliMaiOMXRcj4KpNR8EbHm7tDKG3KAVJDMtnTiONRvn8\
	Sguj7nwPDxpBZgjWwhy3aH4O4X4L42nmRb6sg0kIgJEmuiCUMZaOs1My0BqWpodvNJWk4p\
	anymQ/khomwQz7jFmxBqggTNQMpoZ2sLJHsKTUiR2WrHPTbBzkIIN85CsBZraNv9HP3l28\
	bEeJKloxCWpVTkhMZCAZExCGlRMtuUXFKoSUhkkldU/aWojeigAKQ+FNsC6TESzZ7bq1Hb\
	GcQggQUSNMhgdxEkO++kx1T6cdx3VgyBsz/WKnys8k/5QHdh7FBj40tjAB5QcXU1rKpv8v\
	mxRFoMABqPiK65KAw3h1ZTPkS0mYkuSh0JVlNKah49tkjgpuSQ9JZ/VfS+5rIopIr2w1os\
	U6HtyGN5VZLEXaL0HhINm0KagJRDZpsPpJQA3M5Ss3hyMT6kJZ7MUJhjR1I/BP/RGvhP1C\
	OYcsc3iwjGNvgVB+nWsIE6MupdUpTMNuWXr4Jt/ZmHJHZtuqKResleHnobmkpU0iCp6szh\
	ziwhWhdAaiKzbbmdrV11pOdA6ZgKwlCB4Nk6BFsCkd3ejefUtDYlD9+HEYEzRsBZQrjojz\
	e+RoOQzpXMNgMkovcgcbRkZEk0/tqZ7agZpG5qjXgNvKbcWUsa61n8TK4sI7IAI9lD9Gvr\
	Fkj2g2wDpNSaXNp3a5+Jr93lJVw9zVpA+mi2+mDpfSOztZOSBOKuSJTnkmKQXM21OZqLU0\
	lKGgfk3CL5ykPszC2PxY/YoccFJLppAlTJQyNXkjIUTNoIrfaxJjLbODsOkNkVKa3Pf0OZ\
	7dwPQtp0yD9IURm0NeQfjYe04fuBADnUBtwCbSwk3jWoFo8ZoAYkVatIM2zPDRFYEKWDBD\
	lBIu2DRDsAqU8HIW197MiiQAqjvm40tPq58YGvAjkSiDYIKehabG66trUEETWqdWkgOd0H\
	CToAaTAIqQVSYIIUwaWBxAX7ygoF1gxJ3EWuzw8RFeo1qkRljUCCFJAotAxSskew9QvsOk\
	h5BiGF1kDqm0FIaTzQljZOEo91ox4lftybJOp9qyxYTf3KnmzBEpGnlGCbEpINEmjdjXWQ\
	CMkGKSNuooTMDUjQyiCkTp8NQtrqFO1+3H1bwhSDFMYuTIEUgaUsGLQCETwl2lBELUHcYw\
	pIdiHkAYm2CJJtylNASncfe8MgpE6bg5BqfdwMkAI5yn8t7tMWzGr3GK5rxZ09aST9WJ5B\
	1ZZSQSLdA8kozHSQujp2ZGptc75P0a6N2maAFMY1NdBH9I86sLVkiR6Jez46GkgkHSRigQ\
	TdBIkUC1JXxo7s40FIdZCM0UlUL1vdIslqPoAC6ZHWIIr8ruor1QAksEAiTUAinYBEINm9\
	ejAIaecg0WSMFHXR5t+1znnhjsncEI2+83qWmRT9i0LV5SUDJNoMJEiCRAsCaTAIqZXALM\
	IiKZCoNjApb/e7L7MNscFXPCS+KNCC6hSQSDOQSPsgQasg0a6B1O7M2lENNlHzTBtwok2Q\
	aFEg6SkAzY3x94dtQXS3+AxfnKZASouRNJD0XrO5QEokGJN5kdwgRTU2rZoOOTLaPQApfY\
	p2e4rRuQYpjECiquE19gztQwRBPXZdRMKkzK8BkrgYQpzWQDJcGMmo3gO0P+RfWt7Jrm0V\
	CBJAC0P+QcYU7Xq+qkCQmsl+tPxRBFI0yEU7EFF6l4iJpFlTlihKPsavaQRYiyBBI5BSmk\
	eKGDvSAIkUD1K7Y0daaYJ4XKSUxGe7IOWeo41GKQA5szbrL/RAO5bofvyEqgKJEDeGxwDJ\
	aR8kmCOQjELZmwchbQJSNHgEudk5eTJoGaLRd02wpt07+dMKahwGotxZBBJpAlKzGAnaBw\
	k6ACmRjc463iZIUBRIkAFSz6dov7nR6c3m9hBjF9dno3jIBMlpDBIb2ashSKR9kGgjkKAF\
	kEiTADzZ8NrxkH+5QXLSQbJdYPdBurF9iCjcxDd+DJEJEmkMEqSDBF0HyekcpMyxI/sApN\
	5P0X5LJ5boxihrzWtpsfURILk5QepUHdkBSKQbIEExIPXlIKQJkB52V09tbRui0XMnNvKk\
	I5XWiIMh+36rmCgXSATmTGa7B6ojzSx1t2W2MNFMYJJnvrPr+N/abjllEkQgEQVOAiQSB9\
	9NQYL+ldm2rI4ke6I68trOIaKCRFrfLWCJQHJMkMAxE5LqZq3G2p6rIyFbQjIvZLadqCNT\
	UwKNQEpN9RZiia7nOlnWouvXxFsc3fJIkBzHAsmNf51FqyNpzgZbI7bpF3Uk9LHMNtE8co\
	97yvTWjiEaPW+CKfxv54VUm5YAKWg0kMACCTQ3V7Q6st9ktnvuFO3X5TAyueeA/SX/Ozsp\
	MtccJNcEyZEgKdcWpQDcuVdHpsUEPZfZknSQ7PvoL3XktUVC9Av+nSy45orZBiApaHSQmo\
	naei6zJQOZbXNRG+sF/ZsiIWKzy2zinYhqUzIOSgOJdAZSz2S2BOaHzHZO1ZHXuy+anikM\
	IoyLWNryav59MzsEPDpIxI3jIQ6SY4IETUBqRx0ZuUbYg2W2ujoyD0iFqiOvzmlgclsitl\
	whINouvlgHKVq1NjUdJOIM1JH9LrNNtrMVDxFe1DW4meQak+pknDNS8ESvM0DqpjqyEUh7\
	pDpSv4+uyGz/4J66fV3hEI29e6KKF8VraXT3Vs2NMWvkxfDkAUmpIzNAalkdWaTMNlMdmX\
	fEkT1CHXl1Cx6qJXfGlp9w6e3ubaYlYiCxsZOjHJJrqh8NkAqW2TZssIVE29u8kNl2oo40\
	QHLaBenKbkLECJ2kgS+tUSkGiUk+dJCiFn83KvBYHVmgzHagjkyCZNxLyzLbDXj8lq5BhC\
	6NNeVfyvbDqU1Y3tIa8VVMo0QSsRIx9vtKHdlAwdiaOpI0OA7zTR35M/e0Z8NuWiJ2Ad8X\
	cdEWMZ2lskYKpKjG5liyEaf/1JFQlDoyIwDvRGY7d+rIn7aKROsQsUnT2IAPbJbCqY34va\
	4Fkqz6O57p0ogzz9SRe7jMNl0duR1f/7brEI29hycev88TeZPPcOtjguRZILlNQHLbAonO\
	F5DmlzrySvelG+q9sERs+Z5waTsAmOJRghTV2CKQHAsk2zL1WmYL7YO0dwxCenk7MLQFEV\
	qj+3FzGw+wtz8pa2WeqK1FMMljusWJameQQ2bbT+pIsjcMQroDz/mPnkEkH/w/C4jWxRZH\
	geS4CZiIboW6oY5MA6lQdSSBPXwQ0svd05+u9hYigB/hF+9kHRvDnU8DuKUIpChfFLkyV4\
	LkmpntotSRWTLbwtWRvQJpTtSRl7ULQtsQjb13YjduvstnAdj2WGxxWHzklEyQFEwKJD2z\
	nQskAl2R2Wa1/MMcgQTN1JFdG4R0M177tT2HSC7/l1/L9Fag1SlujZqCZGiR5lhmS1sEyW\
	7e2HMGIb3cO+NJf04gQmvEAmyufgs3P4IQlTWQXAskE6Z5IbOFvUYd+aNOOOjUErFFBNhb\
	HwcIfAEJB6kkQFL5Iq3a3xikuVZHQgsgwZ4wCOl6nkCeY4hYmvwpNvxMuPkhLN9ybHEYSA\
	gUjYCRgBEnqY6EbqsjWxmENC9I2Q2v80hm+z3vzMfDOYUIXRrLcP4D2w82/lEkEJ3YrXHX\
	xkCKameuBMlNl9k2UkdCJ+pIMCUkTUVtLYI0f9WR/9opA0VYIrZcwiQiLHsdbsWamutpIJ\
	VMkFSAnQZSM3Vkz2W2Nkt5QSJ9OwipleC8zXv5Iw/2BURojSYlSBA8c7cMsCUwGki8eUQH\
	yXH7S2YLKfvWsdwg9anM1oqP/rWI8i/KErGLYi6tznqD8Cy2V+EwESs+EiCpYLuUT2bbbX\
	UkbdTO1iZI/T8IaQ3P+1FfQTT2vgk2M9EPeU3tqTtiSBhIKj4intwvSZBcq5lkjtSRJAOe\
	roDUN4OQ/tR7xUNb+ssSieXzrH9jOPmMaJj1yhISaYV4HORF8FDHK0gdWfAgpL0EyajV9V\
	Rme0lRhV4oRGiNWPLxUnbx/trfi/Y0BpJbliCpGKlsgZShjtQbcg2QnC7KbEnrIEEHIM3N\
	IKQPqyRxP1oitvwffn+TGyHcttYCqZwEic2S3AikXstss+BpBNL8U0deUnrlH2nfQhRZI1\
	z8x38nA2zpynSQOCwyXiJuf8ls+w2kYgchxYCafLfIMu+GJWI3Iq3RBgi3PMZBEtaoxKv+\
	HB4eL7lRDql1dWS3BiGF7oHUH4OQ/rj0qvu29D1E4++fuB9v5AfcGj1yvbQwyq1VBEgswI\
	4Cb68NdWS3BiENuwdSf6gjv1J0eXcFIrl8Em8koFMbIdhwLwJT0YJr3GcAES0ZqYnaGqsj\
	XUsdWeAgpKGRGewvkIoZhPR3pVffc+e8gQit0aO4+Ra7Ef+h/xDWhMdHFQMkIgHKBEkTtH\
	VfZksz285aBalPZbZf6UZZd9MSsYv+BP6ZCmcmRZDNEo86SAwUAyRvbmW2fFYdaA2kvA22\
	dmzT+0FI17bax74vIBp///Wb8EY+y/brGBtRvyrb1URsFMVEHBxVe/PmTh0Z2m1dOUCifQ\
	ZStoTkq6Wz7grmoSXiV48mlKxj0zrU778aLc+QsEYSoCiHxEDiMdLcqSPFhHHQfZDs5o3u\
	y2zZMMLf7FYRdx2i8Q9MzODdXMBuMFh/G9CpDbI9DUEqDWlNImXh2ohXgDqyzUFILXK6Bl\
	I31ZHpMtuvll975/S8hUguP8S7uZXdbO3uy7QW/pIASTXSKpCUOtItmepIx7PUkUXKbNOB\
	6D5IJB0kKEyLNMVcWTcLtycQoTVit/ghNqlouPUJCNbdIuBhri0BUskEqVWZbbuDkEKHIE\
	FBIKltcVO0f6PyZ7fvmPcQSZDY7H3fZiVSv+8KMcWDDpIMuIkbZ7bbktm2OwgpcRpalqYg\
	5ay99Vhmy8aT+nK3y7ZnEMnl47hupbNTUL/nJwIYFlirYFsF2Px4ZQ7UkdBdkHqvjvx65X\
	W3bdqjIEJrxNps/qdonL0Bgs2PIDxDAiQthxTlinqpjiRK1NZHIHU2COlO3H6uF+Xaa0vE\
	lu8Am7kIl9ot/8IfEAcpiotk+xprtM2ljkwBKW0QUpUnikByUkByk2XfCkjQS5AgA6Qoff\
	B3lbNv2bpHQiSD7HfjOkunN0Ptrh/LVn4JEtvXQYoSkmVTHdlIZtvuIKTMiqWVfV6QaC9B\
	aqiO3Iyvv9yrMp0LS8RAYu1qF3G39vB1ogs2hwfdlQFSyQSpyzJbHuBrbU/zBqSkOvLTld\
	ffPL1HQySXvwc+ZTqF6g3/CHxSvtJILGDjIA1FrxvKbItSR7IYzCi8jIpWt0CCfCDR6TrQ\
	KR9oQNNqbPiLhH/qZUESmvIUCCE9+fKpr685Ejf34DrsHfZiqJz2QXwwWPWv7wZax9opa2\
	sL8IEFYp+ytACbFZudE9bEawYf22fHQx9vKAAa1uVxX2z5MZ9v+cza0TZeqTxOd22KySDx\
	syGJnXifpHiXrHOhybmEULuEoi2drIH/h21Ad8sBPFwC7sox8I4Y1897TeUvbvxl91qxaF\
	9ZIubW2K/mI6q25q+9MYqHlFtTjbN0ehLoM08A3bG1DXVk/kFIiTuctAa6EaFpViRH4rFD\
	LRLdFUD9js0xQGxBSxQ8PgX+gzsVhb/qJkBZiwdzvzDT+ypcz6rdeAm4y44BMrIkGv0u3L\
	YRqpd/BcL1cW9fss9yKJ3+5+AsO4DHwtSPf8xR+YTWTySkQhkQ2iVJtDSgA5S5VD5pslaI\
	8lceOQ9qvC1uR6UpVibl3MS+dS7lvVOoAVLw4DYOTdoSPLkLnP1HfGdh6b/PRQE6c02QrK\
	29A9eNtD4Ds9d9TlTDS8Po0gKY/X8XGgDxZ7p1I9SuuATCpx4rQGYLZrzEG4W9/OKzHlgk\
	FgOF2xsPpxis3/37yhtueHivhEiCtBk3b2H2Ity2DqpokZgr8393GdCdm9PfhLFO/ZpL0Q\
	r5bcpss9WRpDxm13ZMUHoEktqGm3Y1Dmwrrk/K5Jy5Kr++gEiCxGY+/hSPjx66Bqv+10L9\
	tsYzJtHZXeDfNlG8OrIyHlupdkGCzkFSVf9w22xjiJYOfXL0gns37fUQyQfHuhqxyfmgOv\
	G1bCukm/EHbhWxQpHqSPbeyoKUQm4BpKJktqzSOF3LLsAlQ4+OfeK+T89lsfUVROMfnMC6\
	NrwJd9fB7tl8b6pVIXz68bjxNlIENBmEtImojQwtjF1dL0DK6iOwq575P1J2Q7Kw/LK5Lr\
	f+skQCpK340P4M6kEt73tYgF24zJa9b3hJRuE3yWoXCVItWxbt7Df8mdEL7l43gCgdpHtp\
	zf98boieXd8VmS2PjVibXmrQmwMk6BwkOps+MrCz7/CDoxfde2E/lFdfQsSWBZ++6yJYNP\
	rrXKHUzi3FqiO1QUid0aXWNKEtgFSEOjJMaVEY9mpkydBL+qWs+hYiDtIX73sVjA83zX3Q\
	qe0CgKLUkXqjLcueD+/ToBpeIEh5gm4HLeTSkbeO/s0dm/ulnDzo84UsGTuRBiEG2tWlDU\
	EKKBe1qdyynr0mEJqjDoM2H0woDA8E8icVaplv9XpokWzP253x5SlZbf2F3k5Kk4Yt61y+\
	X3JNhpaOXDp24d2X9lMZOf0O0fjf3jID40PPhaFyY2kDa2iNZLYVS2Zb7lhmS0b3kxKTrJ\
	imOxaJjJbj/UVDj49dfN85/VZGfQ8Rd2sX37WFLBo5HobLM5kWi5S6K7NlnzW2H6SLwQoE\
	yXoPGcXvHULYR0q7yFj5pH4sn3kBEbdIn7pzLVk8djyMlNPbACqjHcpsmw9CSkr4HaP7Nq\
	llFS9qcw5dtIXsO/LisU/cvW0AUacg/e/bHyNLFz4XRioJkMjowp6oI1l8ZGSzuw/SpLNs\
	9IyxC++6u1/LZV5BJGOkJ8nyRUfD2NDO6GAJLczQAgFPt9SRWkMuGV2GnzXcHkjQEkgsbX\
	/28Fsm7uvnMpl3EHGQPn7T02TpgiOx+i96M5QJzP7qIqC1GWF9ECQOlA6SErhlDUKqxo7M\
	I7Nl5yzYX1i2VkGiuUGq4//PGX7rxES/l8e8hIiDdMHNmxGkQ7Dmtp6MD/PJaWZ+dj6EO9\
	ZLkIZjkHhNbajYQUjx/86CA7RBtDoHSdtnk+68YfhtE1fNh7KYtxBJizSND/4w2Gecz3JE\
	d22BmV98HPzHfiNGHUmR2RY6CCl+ljO+P6SKptsASWqR5hVAPB6dS6F+kcvU19e8FcQkNb\
	yxy1u5GsovOlcUuD8rBtjiq9wP61L4XxXjAlBfCv/ronMAF/n74rUU+0N0zI+E/VzcP7ND\
	CPxTn7DxtJOHTQE/qzCcPfJXE9f263NO5WVPgUiCtAo3P8H1EH4fI4uhvPpd4C4/VsDDep\
	AwcYACCQGibLZICRKVAGWCpHqMRCDFvUfo9EagszubgETNHiLm/zfgetbI2yfu7OdnvMdD\
	JEFaBGKC479Ux9xD0Co9/xyp257lEDGY8oJEmJUKmoHkQ7h9rYC0dZBuxxevQ4Ce6ffnu1\
	dApMH0dhBjNi8UaYAhKD3nleAdeaaAwQZJubIIpJoARYEUKsukuTUJEweJHQ9mIdz2RHq/\
	smyQWG+XD4/89UR1PjzXvQoiCdIKEIX0OnljQIYXgnf0K8A7+CRe8AKiWgxSUJPg1KN9Dk\
	oWSBImBRKdfApodTKjldUAaQvuv2f0ryd+Op+e6V4HkQbTa0B02z5KFC4FUhkD75BTwD3o\
	haKphLm5KNiuCYvEOrRFIDGAAg2kpFWivAftFoyPNqgHmQXSj/Hvfxt9x/XPzrdnuddCJE\
	FimcH3Ahtoi5Dlql5NHALOvkdh8P0ccJYcJsYoUl21uWuL3RoHCbdEdctWx1lMJEEKtz8h\
	AuyoC73xLP+A6/mj77z+mvn6HPdqiDSYWHvFeXiTH8JHcqhRzo4DzoIVQBYdBGR0KRfrs8\
	QlB0m6tVSQ6jMIDlbzp7CGVptKui7C5xe7GNfvI0DhfH5+A4hMmFjr6qvwsZyHL1+Nt+wl\
	694gkpTlUXR5FZGsZAI39szQUhE+qMSsACwZ9zBlHLM438D156Pvmgj3hOc2gCgLqH9cw7\
	p1/DneNoudTsfCX9wwKCb6szLOYKr6G3C9Cs+5bPTciaf2tGc1gCjHMv2NNawp6DiE4AW4\
	PR7XI3A9GV/vJ7qkyfGBnXAr9T02LM7j+LjYYAG3sXzP6HkTu/fk5zOAqM1l1yVr7iIlOJ\
	GwJrahKjjDu3Dduh2GduzvnjI9uzc9i74bn2iexE5MgfY87WenXBpzeW8cPKEBRHmWkxPP\
	iUQx8tsGj2cAUZ5lVYZhZ3/OCO/aZ8UAosGSH6JomLTIrbHnd84AosGSDyJR15jRANouay\
	FnDyAaLNlB9dd4dvtQVUnD9WNaA+qbESZWMzuVbjhudADRYMlaDtP2/54AvVy6MxZZs6kl\
	PgQs002cYwcQDZasRfVUfALXzw69+T9ZBvoxBGmd+9INNXf1rkvQn/0Y12V780PyBpw0XG\
	Yw5tmFbustI2+fkPEQb9Yoa+ecx/o4DiAaLFkLa8o4aPTcie3aMdYPLBrWxTlh86T2cq9c\
	Ups9BstgGcREg2UA0WAZQDRYBhANlsHS2vL/BRgAoPt28wv5YoIAAAAASUVORK5CYII=\
	")
	-- blink@2x.png
	R.duckloon[2].blink_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAASIAAAGaCAYAAACrJ06uAAAgAElEQVR4nOy9ebgtx1XY+6\
	veZ7izZku2hCQs2Vi2CDaW55HEDA/C4ITwEfIygJmS90gg+RiSEHDyMhBI+PICL/BIXh4v\
	jEmwGY0J4IlBHmIDxpPAA5Y8SbakK+le3XvPOXv3en90VfeqVdW9e8/7nLvX9917urqqa1\
	VXd/32qlVDOxFhIxvZyEZWKcWqC7CRjWxkIxsQbWQjG1m5bEC0kY1sZOWyAdFGNrKRlcsG\
	RBvZyEZWLhsQbWQjG1m5bEC0kY1sZOWyAdFGNrKRlcsGRBvZyEZWLhsQbWQjG1m5bK26AB\
	vZyDrL8E9elj2/9TlvWXJJjrb0BpFzbpHl2MhG1k4O7nlpOPwG4AeA+4FnAmVbe9j/6LdG\
	4Z1bf3xxBTwE0nct68Yi2shGMqIg9H3AP/XH1wF3An9s0xsA/Q3g84B/sLgSHi3Z+Ig2sh\
	EjCkJ/kwZCQa7uuNQBPwb8f8AN8y/Z0ZUNiDayESUKQk8F/kMmyQl7QllDPwCEwD3zLttR\
	lg2INrKRVLaAnyUDHeAxHVAQ+grgu1TU+xZSsiMqGx/RRjbiRVlD3w48uyXZ2cy5JwL/jz\
	n3J1269h/8T8m5nWu/sbuAR1g2INrIRmL5LODVHfGfCAfKGvpR4FqVZgT8aVsGCkJngG/x\
	6X944pIeIdl0zTayESJr6N8CJ1uSPQo8AhGEvgz4Sybdh4CDXAYKQs8F3gP8IBuDYAOijW\
	xEyQuAv9IR/2cA20/7nRDepbKGrNwD6RwiBaEvBN4M3OzDvzxFWY+UbEC0kctelDX0b8Yk\
	fT9E1tDfBW5tS6dFQeilVOA57sN/yhh/0uUgGxBt5LIWBaGvBF44JvkH1PG1wD9uSRcN3S\
	sIfS7wqzQQAvgVuLwd1bAB0UY2AtVExFf3SPc+KeoR/e8FrmhJV1tECkLXUkHojEl72XfL\
	YAOijVzGoqyhr6FaQzZO3kVxEqrh+m/pSGcnM24BrwFuMecfAt7aQ++Rlw2INnK5i6O9i6\
	XlQXHH7qM4BfD9wLGWdB8DzkNkDf1zKt+QlV+jGrq/7GUDoo1c7vKVVL6bcfIOimNQHL+Z\
	ajV+m1TW0Km7QvjLgO9uSfvLsPEPwWb+wkaUlO+80h8JlaFA9VfveOFcE+8gjgzxqDiT1p\
	l0OIo775/fTfQU1S37Jz0veRfuGFQr6rc70r2fwelw/ESqBbA52QN+q6fuIy8bEF1GUr7j\
	NBFgkOYQQASc2wJ3NchVUFyJ40rgKuBKnLsSOFYBRa5UBvUpwOHcOZ/fJXCXfObncDKC4h\
	EcDwFnce5h4GFwZ0H2yvfekAEUEdSKp31yvpVRyV8APr9n2neydfUTgW8ek+4e3C5Ud/T/\
	Ate0pHsDvgu3kQ2IjqSUb6+4kIgATnageBpwG7ibcXIT1cS6m3HuZqrtK4rq+hKksKDyxw\
	5cSdS7D/GVnqYM4iLjqMlHAHcBx/3AfTh3H3BfdOy4F+FCec+NxFaYA+connrvxPWjrKFJ\
	9gt6F/D3aPcNBfkAxXGAbwO+uCPdZtheieu7g9pmh8b1ldHbTpszgnMMoHg6yDOAp1Nt6P\
	V0HLcDgwggTr0DzroNhZpLdRpttfj4XNh23aJum84n12WL0t8Lxftw8n4o3ge8D1d8AOR8\
	fa3q+hW3fZQu8SC6k2qJRR/5uBx7+h3Ax2kfsg/yBE7ddSXwbuL5QlZuBD551EG02aHxCE\
	sKHqDyRzwPeAG454E8B8oTFRTUy1AbKsqaEdfASEoDowktIx1OLCNtMRFbRrXVpPOu09+C\
	K29Bii9t8i7BFffi+J/AO8C9FccfIFwoP/zZjU7nKJ784fpuprSGfg/4JsZD6Cyn7noIeC\
	3dEHonsJC+5mGVDYgOgYzeekqFJDTCG4Evolq39CKadUtVKnE4JzTAmQVGPq2GEdvGohGQ\
	IQ1U5g6jKk8pVN7lLVDcguOrEQHcCMd7wL0NeDvOvRnko+VHbvP5OcqDi0h5/EnAX+tV+d\
	X9/T7wnT0Svo9q2ceLx6TbjJYZ2YBoTSWGD1CtCH85uC/CySugfPq42RcTwyi6WMPIVcdn\
	vhAGV1bHrvDnt/zxAAr/lwLkwJ8XkH3/bw/Kvepv+Fc+BuWjMHqkuqYPjIKVFiyj0HUUBs\
	AzceUzofhWf92HcPwWuN/G8Sbc8CwVLLpGvuKq2Ln5FAb0WSlOfAL4Fz2y/NW+ui8X2fiI\
	1kgy8LkaeCXVNhOvAHbqmNqvM34qmIvSmuddP9bg17HxKv/iBJz5AihOghsoGA2qfwwqYG\
	SPK3g5QtqiAVjIS/aR0aNQnq/ANPo0DD8Nw09BeUH5jIr0/l2w1rTPKMQFH1RR4twfjC5d\
	fyd+LL6HPCrHnv5h+oyunbjzHopjTxuT6l78QtnLwSLa+IgOiWTg8wQq8Hw18DLanlHdlW\
	qxaHTSSSwj3UWD2DIqL8C534MzL6faAUM8QHxaR9V1yh4DIlXPSoJiaeIQcDu4bT9opwHl\
	CigvIsNPw/CBCkwH98HwY1QTk7Vl5Lt4oLpwYS5TWcjw1F2KvuNlcPoeKt9bt2xdTQ8Iwa\
	ZblpUNiFYko7v92kcRcHKMCj7fAHwBfWe8rwJGo0fh/Nvg1AupezdqSlIMlq2aNxQCbIGM\
	EB/n9DWoPCygECiO43aeDDu3KwtM4OA+5OCjsP9R2P8QlGc7YSSj3DbUHfU2uK5tk7RG3B\
	bsju+5edl0yzKyAdESZXS3nrksAHeB+wZEvg43dkQmL1PDyFgFYk4lMFLxBw/AhT+Ck88C\
	8a9QBCM/hC/DBhglUAxBBj7tEHFbOG26O/Fg3mqc3DKIy+lE6Slg+8m4ndvglO8ClueQvX\
	tg/72w9z4PpqpupNxBpLdrCNw2FMeePjbdzk1VmcfLo8Bb+hfg8pENiJYgo9+/hsppK+Dk\
	NLivB74J5M4qRRiOnlLBVDCy5AmnWkbS7KjZ3p/B4BQce0oeRhCDBWJjLILRyJ9sIIUb+G\
	tDnuo4gt6wgZUDitO4E8+DEy+s8hh+Ctl7L+y/H7nwqe56tHW1dRWMq9DBKdi+tjOJktfT\
	soXs5S4bEC1QRr/nZ/cL4NytIN8GfCNwJu2PrAJGlhxMBqML760c2Ds3+a6P7VINqrxkGM\
	PIodIOETeILSO99CQBjyirKqT13b762q0mfusG3NZNcOpLKa7cRi79CXLxj5AL74by8Y5a\
	ctUIYac42L1lTJpINrOpW2QzarYAGf3udf5IwMmLge/A8VVAAaUZmaq7aV5mgBGko0ldSe\
	tZ0Jl3QI86Rfn68/UUom04/RLYuopmJKxoHM0UzeiZ2/J5qvh6BG2Ai0bgdB5t5woq6Og8\
	1SgdBWF6gbBLNegYyghy6cPIhXdWUBqZrwQNrkC2b+yuwO0nTOIbGlJ9svqRywlEm1GzFc\
	jod5/gjwTgS3Du1eCeV1kSNI1bNIxWbRllnNehOH0sIzmonNdnXgbuOOlIWPDzhG13rDUD\
	Yd5QZRnZQmzV8bXvSEvomkW+I201DWle81LlNcAdeyru2OfANX8dufRB5PzvIxfeWY3QDa\
	7qrDvcNuyMAVUsb8F/AWQjqWwsojlIAyAAvgR4NUg15FtXW0kSXgPLqHOOEfS3jLauhdMv\
	oJpx3WYZBQvIWDVRmgGutlq2lDWlLKJg6dT5O9otowHCNnA8jscRW05hMuYIufBHlHsfQf\
	Y+mq8TgGOfDVttC+uz8veAf385WUOwsYiWIqPfuaE6qJzQHkBhzklYtoBqzOtnGXUO64fi\
	9LGMhg9WPqMTnxs7j62jGbzFoiwd49epVWhHdH1dyFeNyMmWT7tl9ITjHXCj2PkdpiPU+f\
	k4BriTz2dw6iUwOkv5+LsoL7wLyotNOQYnJ4UQeP/QRvKyAdEUMnrLE6uD6uV9HrgfRtwL\
	qwabkcsFRnt/BoMrKr9JFkD62ICBIbrbJj6h09ckzvCQV+ieBRiJKjc4LiGMgJ20S1hVQA\
	U1GVXn3E51X4OrKK74IoozfwG5+B7K829FDj4FO739QkH+GOSjs5m4R1s2IJpARm95EqoB\
	3AruXyLyV5sXuiCGkWpFs8CIFsD1kWXD6OJ7YHAGtq5sARANDKL5Qqab6q0fwXcfZcvEby\
	moDFKg1boqeDkpK1AxQNwO1eTKbSK4hVnickA9yidU3cUTz2Jw4tnIwScoDz5WAam3lK8r\
	eBsD9x7k4efirn7HBNdeHrLxEfWQ0ZuDU1LAcQbkHwLfTr1JlsQ/dollpH+9IQJLL5/RjP\
	4iINk3qC3ZLD6j0N0pjsPpl0KxS+QHqv1EwT/kMr6f/IhZ9f6lI22xTyjjO9JhG0+BuG2q\
	GeJbNH4mhytKcNvATuVjcluV/mK3qoTRo5SX3k+5f1++npRs8Uufcu7+b8cV/x0RwbnLBk\
	a9+bIBUbeM3nwT/kVzwF/Hyb8BrktevmSx6GUOo63r4NRziYbYW4f2LSw0tBrntouG7S2A\
	WhzaNcBUfA20rUYPWz7eA8eBdnhXf08g7gRhSxGHQ8pzlJc+QLn3Z+QsV8fjbPFf8H3Eu3\
	HF/w7yh1XY4a56+9jncZhlA6IZZfSmm5qA4ynAj4P8+RQUSjYw8sf+/LHb4djTFAxykCky\
	sHBoAEVzjbIwUnONcvOO8LCLzum87XV2h4Atlc8uuOOIqywjVxELKc9TXnw35f69UTUV8j\
	4G/I6vLweOElf8OM59LyJnjzqMNiCaQYZvvBkQnJMd4LuA78WxW8VKBhRKZoZRGOZfEIwW\
	tX1IlDcNjE7eBdvXq4beNqxvAdLW9SpwETwCZMx0gAQuZlJlBK9cemsxhWsDJLcUkAo/Gb\
	NAhmcZXfyD2oe0Jb+Kk/toti7xvjRXfBrn/h7Iz3tA4a48ekDagGgKGb7xVlSjf7Fz/ASU\
	d9QJ6irYwKiKRMXZvPGNbwdOvxiKY+SgEgMkzAdSllLk82nSuqzFY2GXO2etpRyMUl9SbC\
	mpcrHlraTgD3NAQXnwScoLb2dr/wfBjdT9RjAC534Dx7dQfTQAnMNd8baxz+WwyAZEE0oF\
	IQCOQfnPgb9PfdsWFGH4d9kwKuPjwwKjravg5PNarCF7rCcnWod2PGnRJdaTvV7nnztnum\
	LZbl2bL0l1H2uAeSDVEyZLuPgL8PhPAOeqPIpQhxGMzuH4Bzj3n2pn9hGB0QZEPWX4hif7\
	IwEnzwZ+Bvgc3eiXDiPtL4rykfiadYVRbpfH3SfD8c/xiSeBUc4yCk5nBSTrfwqzshPLKA\
	cv2wVsg1LH+SjNNhWUfD2Uj8LjPwZ7v+bvJQsjcPwGzn0jIp84KjDagKiHNBCiAL4LV/4f\
	RHOrNjCKks4EowGcfHa1FKS3ZaQbfGb0KxreD3AJXSZXAcFp8GVgEi37MP6htrhkFM525Z\
	SOOs7BwXvg/A9AeW8XjB7GuVch/FJwcLsr3jr22ayrbEA0Roa/fRt+/s+TqKyglwMZULTA\
	SPuLwIDCyAZG/vRxOP1Cqu6LtVYsjDRo1DkGUGgg5GAUrJTgO7JQM1Bq7YplumnYa82OAr\
	kRN+3LQuDCf4GLP+nfAwWjIgAUcO7/BvcdIBcPM4w2IGqR4W89hbohO74Q+BmcXBclikAR\
	N/oNjGaE0fZ1cPLz0Y7d1IGtjy1ELIxiK8Q5k19uPlHOd9TqpNY+oQCdHMjaunDBMho0+T\
	CA0Ufg/D+D0YeoYVR4IDUwei+4vwTyQZzDnTl8MNqAKCMVhAAoQP4JTr6P0GI6QbFGMFqD\
	FfugYZRR2DXHiAKOP9VvKGa7XNoyCo1fwSczepZaM4MWGGXg0JZXDSet03evsP4mD9Qw8x\
	p1bLt21rJiBBf+M1z6qeq4tuh8JVYwOo9zXw/yC+GcO314gLQBkZHhb30OvmFfBfwU8GXJ\
	MPzCYSRpuz30MMpYRTAGRltw+rkwOE0DI29tFL7xUkAR5u2ELkuuyxT7igLYXIsvKev3aY\
	WR0ZndjC1AJwBVzzXKwND6mihg+B44/31Q3t8GI3DuB3H8I4TRYYLRBkRKKggB8HQofwW4\
	rYldYxgl3TIVPuwwGpzxS0ACLBSM7Bq0OpyDkcvApDqO5hplragAlZw1ptPb4XttEeWuyX\
	XTbJzyLTEAuQCP/yvYfyON89pXYgOj1+P4OoRHDguMNiDyMvxNDyHHlwE/B5xO1wStGEbZ\
	7UMuAxjt3lptvq+H6SMYGR9P4scJx7oLF7pVwTLSaXMOam0tpd28PIyMj8j6kmrLyMLLWF\
	GJE7yAS/8NHv9RcAcxjAoXKvtPcHwpwkcOA4wuexAd/I87CA3DOfn7wA/hdIuYD4xcKygu\
	HxhNvy7NVUtAtq6kcVz7hqthFPlicjDKWUa6uzTA5XxK+ro2CyfnfO6aU1T7kiys1N/Ib6\
	TKEYA1fD+c+0cgD7TB6EEcX4lw97rDqC9fxv/cHUI5+B/hU1Ru4Bw/Cu7fAkX3bg2O+qN8\
	EB+H+Oi4Cjf17KtSTPo6n0x+EUNyjyLk0aajMOVsytXEZ7LtK3Xe3fshSZQuQz4xedTpBS\
	6+D8oDqi+1ltVfOfDH4sMjYNSEKan2ovZxMqzykpFP68+XZX1OGKm0IT5cV/r8bZ4jpXsE\
	DFV5huo6lUZy58s4PeqeUOVnWJ3fugOu+EkYfJ7X5+sqvGwi1yK8AcdfRkDOvaDz+RwGOX\
	IW0cFvPANvbZwA+Xngy521SqyFEUmHZeSsxbEMy8g6r3M6DrlltPNZqouW8wdpy0c7qG3X\
	TMdry6TxEzlr1WgfUuIbarGMshaRtbC6HNpat7YAjWUkAhd+CPZ+CTXhsXnZnCtxfCvCf8\
	Q53Om7O5/PKuSy7Jod/Mad+AZwFfBrOHmh6p75VD1gZGFwFGDUto1tX1kojFz11djBlQpG\
	tgsWul4WRgMigGVhpKDiiqqHnnMwuwwMIv9QV9etzb/U0sVrPZfp2l38Wbj4Iw2EYhjhtx\
	T5F+sIo8sORBWEALgJ5PVAdcJpUPSFkbGK6nz0sbE4QtQGRtPBqDhRLQEptn2chpG2Nqx1\
	ohuth05hHcs6n+qv6wJLDkaJ0zp3bdeKfW2FtfilsnONfHj/LfD49wP7bTD614h8z7rB6L\
	LyER28/nPD+/7ZwJvB1VSq/BHBn2P8Ndb3UovxF9X5pHna62fyGUX6MmWq40xUX5/RLP4i\
	yPjNWpJN4zMqL8D+fZW/CL/0ofYHad+P9hl5v1F97NOXwyYtI5OPxD6jyCekjoNfR/tzJP\
	im7LXhOMTZ63RY+bNsPpi8UWl2XganfxQ46e8B7TMCke/GuR9ABDn3wl7PaZ3k0IPo4PWf\
	64/c7cDvUs8RyoNjrWGU6BsHo8KE/blWGM3ovK7LON6ymgpGex+rgFQexOCpG7xyaJfa6a\
	yhkYPRMIaFVOfFOpQTB3VwnIs5pwETIKhhlAPWkMhxHYHK/I1gpBzfW3fCmZ8Ad00GRhxq\
	GB1qEB38em0J3Q68GXHm05sLgJGWXjAKJzJlyoUPA4yAucDI5iMClz5M1fCDVdICI8TDxj\
	fc0o86RRbQMLWatPUkI8SOckUWSrCgDkhgIjq9HpGTDNAyaaPRM32vLelCeHArnP6PUNxo\
	YFQffzfO/avDBqNDC6KDX/88/MtdQQgqCHUNu88DRlkrqQtGOVBYwC0CRjafOcKo57A+jI\
	FRXQaVz/BROPgMeRiN4nMIlKqhlh44NSw0YMwQuspHZIgkXa2ctRQgoy2sTDprNXVNC4iG\
	9w106nPhvA8ProfTP9YFo+/Bue85TDA6lM7qg9c9EyrnrodQeWPs6M3dU97ZPLUDO+vM7n\
	Jgq/yc1medyzZPHR7nwLY6gjM7X67VLJLNOLDrMvh83A6c+jyqDca8Ezia8OgdufUKfEe0\
	NUjhHdg5h3ZuFb6aGOmimdLKyZ1dZGuG8HOLYbOLZHU+ekV/EZctcWKbKQnlw3Dub0P5Ce\
	PAro+/GZGVDu0f2VGzCkIA3IST3wNuqYKmUa0ERjb9BkZR0klgtPtE2LmFZmhebXIWjTop\
	OOmtQQoz6hR9SUQ3eIedpe2S0bq2UbLMaFcEqADQth0iLYTs3KMcjMyIXvkQnPs7bTAqce\
	6rEfnFVcHoSIJIQeg64G6Q2+NGNA5G7VbMkYSRvYdDtZdRASfvrIb19er72iJyGWvEGVBY\
	yKgGnMAotlZcznJqhZLWMyC1kCxkrGWUsa7sMH5yrMpXfgYe+yaQB3MwuoRzr0Dk91cBoy\
	M3fH/wumeFw9PAbwC3gzPvsvF9dC7TCPHz9hnZ9B0+o0jfOKd4l44Wn1Eyeqfv0fi11s5n\
	VMLefTRD9sr/Eg3va0ewGJ+NcRyLd2jXPqPYca39PBJNC7DOZu3zCXrbHNRqKkDiCFfHud\
	GzoCc5Nr4kdy2c/g/AFSg/UTg+hsgv4dxnw/r6jA4FiA5+7Vn+JXU74F4LfH4Te4hhZEfS\
	WucY9dFxBGE0fKRyXtcjTGokLIFRSdTQo/N2qN8CqCSGgngYlUq3cZTXI3K5kTbtaNZltp\
	AxI3DRKJq6FnusgezzK54Ip38YOE4GRteC/Dq4M+sKo0MBIi8O4T8Dr0gb6jxg5A9bYTAr\
	jLQOld8GRplIdbz3MT8apkbPksaroWOHwRU4QoMuDdCyw+xheF81djFQiRa6WpBo68VaVB\
	osOUhlro1gVJKOqI1g8FQ4+S9BtkhgVPI0kJ+u+myzPOTFyNqDaP9XP983XPdq4K91zseZ\
	CUbaalEN1eaZ6OwLo7jRTw8jG54SRi3lWg2MMgrF51FegOHDBkahsRrwJDCy1pEGiO3G6b\
	z1bgBqaD+yYMp8XslUATtPqWsyY9vKfX2t6gbq+FC+rbvgxN/39ZdYRl8O8k8R1m7F/lo7\
	q/d/9dn4Gv3rwH9xkXM3pMo4pKd1YJsh+MiBbfNMdPZ1YFsdKj97T5tdHqsyFCfg+NOALT\
	8070iH2PVoWnAkq7hkXZpyJNu0eh9q42B20boz62y2zvECCKN9XZ/FDmH7Zdoxa9ESB7Zy\
	Yl/8Mdj7Of8MlQPbOcHxZQivx7HwvYwO/ahZBSEAng/yZmDXJQ3VhFHhucLI6vN5Jjo3MI\
	rLM0cY7dwC29fSDM0HGJlRMjscr6HUCSMNIQ2wHIxUHglILAxzw/mDuNwJnCykzGLatrlG\
	9ZYivh7OfxcM35GD0UM4nonw8UXD6FCPmikI3Qj8ItWHxdWyCetMnmM3zcyUFh1eUDctyq\
	93N61PV7/F6a7Da7CxGoR6zjivoSrDwaeofStlzhcUuim+6yKmu1V3q8JomBmFSrpwyjke\
	Zm/7fETsdaZr1TbrmgPiLp3pYo1zWEddRO3E1jrCfQmcfDW4J8XdtKqyr0H4ORyDdXEXrS\
	WIPHB2gdcCN1RnnY7jKMFos8ujlhYYlfswfFDBRQyMtM8owEaBQI+WlWbkK/In6catHOFl\
	7MiWyP+TgY6FlBifkXWU1+dzO0PmnN762ozDnRLccTj1z0C2FIz8wxR5McI/BEEeW72/aO\
	1AtPcrdwEg4v5P4Llx7OpglNeXkzEwIt/oNzCCsYtk9z9N3PglbpSlsYzsmrN6XVqwqnKN\
	3J4P1yuA1JaREDmYs9aMAUeSV2YkLBnN05ZabosRYznpexrcBif+DvWWs7XzGhB5Nbi7kN\
	XDaK1AtPfLz/EvvPtbwLdI0ohhVTDqP8coU4bO7UOWBaMQ16bjEMBI9uHgLHHjRFkGxvLJ\
	DeuXqpHWILOw0FAL/wJ04rwby0iI5gYlo3QGdjWs1LVRt81YdEn3ywLL7HOkAbn7Sth+KX\
	XXtIHRAJGfxLnddLuI5cragGjvl5/jj9wzEP6vcD4PoxAXjtYQRhPtZaS7gSbPucFI62/T\
	0QNGs8g8YDR8SDXkYPWobloNI91Va/YgiuYi5SY86qH8AKPEmokhIdbKscPxkZVkAaO7eN\
	pS6lixn3TJ7EZudq7REE5+F7jrczB6BiL/EEAefX7fJzl3WRsQ+cZwHPhv4E7oRpXCKNdw\
	p4BRpH/eMHJpnsvY5XFiGNnwGBjN+sM56y6P5UUYPaYslIzPSMMkxCXdntJcm7NmNIysZa\
	ThNvJzjXTXLtOlywIqByXT1YrAlQGUhU4018jrcsfh1D+u3okURv8YeCasDkZrAaK9X/Ku\
	IOHfAf5bQPEL2w9G4USapg7b0erouiMCo0hfzwmPkY4uGM3YRQNm3uVx+LCyUBR0IrjopS\
	ABRhoUpssWddPCOQ0jdS63zIMSEQ8kCzxr6USWVdcEx0yXMecLSupiGJe//kzRM+DYKz2A\
	IhhtAT8JbE/6KOclKwdRDSHcV4L75q4u03gY5X65u2CUaVTLgFGibxyMwolMmXLhw7DL4y\
	wwGp0H2YsskqrRiWrwqvHWDVhbRtqXpOItjEKjjnxLBhyJE9t2rwK0NMA0oHJOarOJW1JW\
	uyDWWnM6L1XW498AxQ05GH0e8HcRWYlVtHIQebkB+E/VobVajiCMslZSF4xyoLCAWwSMbD\
	5zhhEwNYyGjxANu2trRSQfF/xJOT9NmwM7wCtxgLfBLMAo5GtGtTRcNBjrfDQoc+vQNHRz\
	a9xMWAOKEbANJ7/TX4+F0ffj3PWrcFyvFER7v/g8/zK7HweubWIWASMrY2CUSx+V53KAUe\
	gWLghGs6zYHz2mLAw9WlTSDSNtRRmLqs2BXZqwBV9u7pDvqkXpaxgFGGbWoSVw0zqG7Wlz\
	FlE0CqeOt+6E3a/w5UHD6DQi/xpAHnnedM90SlnZEo+9X6xv9Gtx/Fx1mOmLRG0gjncdSz\
	WidWng88ncq925sENfUsajvrGaDa/bLo87N0BxiuijjPpjhYXzeTqSb6NF68oKcy4sz3DE\
	G5r5fHLbxkbLQuKNzlyyxWyhyrIV58WAZmvcrVRPtKQjtxQkU267Fs0NQC7Bo18PctZfC+\
	prsi9EeCsO3JVvn+qRBjksSzyuA36kn9XCHCyjTGuJ8hg3rG/zXIRlZNOPs4yCvgVZRroM\
	rTpWZBmNztFYOsE/FH75SyhFxRmfjR55skP7ucmHWd+Qtpq0NRZbIWKtqHg+InsAACAASU\
	RBVNq6EaU/WE2ZbltkjVnHtvE9keny5SZDumOVvwjvq4stox/BUcyn691PVgKivdc+PzSi\
	f0/okrWBYkyjmghGufxq3UH6wMjGH2EYJaN3+h5XDKPR474RBtCUxDAa0Ux4tN00f100+m\
	VhFI4PzLlhelw7tHX3rfkbddMicCjfUTQaZgGYW5dmRuASOOlJkpkZ4LuvqPYwsjBCno3w\
	V0GQs8vpoi0dRHuvDVPJ3VchfO3kVksa7g2jXs5rmGjCYx2/QhhF+jrAeeRgVEJ5ntofpO\
	ERWRhiQJKD0cj80+mDhaHzUwCyI1j1/kSxs1ja/EwRjIwVk/MZtc7Qtr4kbRmZtOHeTvxt\
	1e48jMoSkH8Kbnu2B9pfVtQ1c6fBz56eymrhcMFI55nonARG9p4mnWM0mY5DAaPReaoGFq\
	4JDT3AIDT0AKNc98bAKDnWMAqOZtWtikbENFSsHv8NtZaRtsaqU9ZPdt2a6aq1TobMOLSj\
	uUYjGDwFdl7hz2nLiNtAXoWAnDVLPhcgSwVRYw3xveCeVEdMBQrWFEa2LJk8E519YRQ3+s\
	0ujyCjPV8wBQLdVUu6WgEkI5pV+NYCsl0gBbcuGNmRq6ibFltdon1U0Uiezrdt+F6BpHWo\
	395Hzmfk/x3/OmDHwKgE4ftxHF+GUbRci6i6oacC31GdaOmWTQQjE1w1jDgMMMrV4xQwGr\
	cubSkwKpHRflOwGgrax6MsH+2YRsEogoHE19WOZd3oA4xsd1DF1QtaFRwUkMT6f7rmKLUN\
	7eemAdTdszJT/gyoiqth90tpfEQu3NMNCN8Ggjy8WKtoaSDae43/ckC1vYeaSj4rjNJGtV\
	IYiQWFvT+VZ6JzjWGky7xuMCovIvXnpgNEQndLW0S2m9YGo2GcJnFQl8QObOXs1k7iKC8N\
	owY2YsESdR81XIxVk3OKR5aP7uLp8lsLy58/9leAXQMjQMrvAnd80ZMclwKivV94UYDMlw\
	Nf0t2QVXhBMIrCS4OR1efzTHSuGEaJ2HKvIYxkDygrGOUsn6hRh3MZGOlrOcjASHexDHAi\
	UGlYGBiVqWUjykpqn9SYg5GFl7F8oi5Y6M5py02BtDgBx/6SLzMNzIVrkPJVIMhDd83wIL\
	tliV0ztwv8uzo4d1D0b1RHcZfHJL9pYXQYN1YrlXWCghEaJMHHk4FR3WjDtT4uWD2lhlHZ\
	5BsByPt1onzscg1dFm35hG5ah+WTzD3S3auMFSQWUOH+dTfQ5HP8y6k+fZbA6DuBrUX6ih\
	YOor1feFE4/NuIe3IU2daQpwZFHF6njdWS+M6HOgZG5Bv95bvLY9OopV7aEWCk4RG6YRpG\
	Gl62SxYabkm64ZpOpxp3Yg1lwBONspluWpvfJwKN7g4af1Li2NbX6blE9roS2IFjylfkWQ\
	5yM8LXgiAPLsYqWpZFdIpqz5MxjUqFjyCMJt7lsQ1GCeCWBaMQ16ZjhTAqvcNaSl8HAQrh\
	OFhMBioRUHQ3KgejYFENM9eOmjySbprtzoVrTTdLSqQ085MimGW6acnImb43MzfJjqIlc4\
	9KOPYlVeelhlEZYPQ9LPDjjAsF0d4vvNgfue9AL2pNHLirgFGIm1bHkmAUFXbVMLLPLaej\
	B4xmkTYYyQFN16zNMvJ/KYm+zCEqLvEPqUYeYKRHn6wvKuqmZWAUQdBaS1XXS0r1uWs90d\
	Gu3o+cz3ppR2n+WitJ+ZJst86drGZcV10ydQ88A+SLF9U9WyiI/AjVNcA/6G5UsHwYaf/N\
	tDpM9S0CRl2zyrMw8lHrDKMua6uPZGGkrBMPg/ZumgdWtBVsgFHwpRzE6aX0sPNWlmgYaG\
	uqA0ahwdefvM5ZPk3XS+ryHDT3Z0fFbPerThOgZH1NQ6PHWktDOP4Xqb6PJr6Kaxj9HRDk\
	M/XnvuYmCwPRpf/+EgBE+G7gimyisTDScSp+nWBkG9XcYeTSPDthZJeCqHOTwCjS1wdGNj\
	wORswmSZ3orlIDnaoxSxNvgRUslNo6gbj7otPr7pQCg56IGDV+UfG6CxfidPfQdMNqGIVz\
	B0qP9v/YY+1Dst00ZX1FekZxGd2VsPPC5kE1ltFfBHfrIobyF+wjck8Evi1p5Fo6YZR7ca\
	eAkVbXC0YtOtt0JNcdARhNuxQk0tEFoxn9RXUZg1WkYREfdzqwIxgFOKg0WRgdNNdn/UDm\
	b+twu4ZIG4zMBx0jf5HtmmmrSncdrc4h7RaRz/fY/+KvwUMToHRI+a0gyKefNePDi2UhIL\
	r0314cWsC3gzsGpBaHlkXDaNqlIL11ZBrVMmCU6BsHo3AiU6Zc+DDACKhhFC1+DccBRj5d\
	Ahrt39GWTguMggNcDhRANDh0N20U55GMcNlum7K4TJcrhlEan7eCQldMQ8n6mWyZ/N+tW2\
	Bwew5Gr6Ke+Tg/WaRFdAUi31odhkYXojoaFPSEkQ2vIYwSmTOMslZSF4xyoLCAWwSMbD5z\
	hFGdr2rYiXPaw6hsB1VkueRgVGpnuIFG4pQO12qrx4StNZKct4DSlpECiZ5bFPxJka4A2F\
	GcNmsJGUgd+8KqKmMYXQvl18y7ezZ3EF36ry8JIPlW4ExT4El/fW2aDqtpqTCy0gGjjqkD\
	Tfw6wMjmM28Y2RX7VsccYFSv77J+IgUfRMFoFMcFeESjSmWcbz20rnREXSLdLdLX6u5Rbk\
	hdQacNUp3dtKE5F7qO+npjPeWWeVhLbvd54E7lYPQ3QJAHPm+GhxbLgiwit0vVLauCCkYx\
	SPvAqCX9VKBIdcxll8euRrUyGGkZByPrLzJlzOpYMxhReEU5GKnjGkbBarAw0n4W7TPyjT\
	OBke7uKJhFDmxrKeluWsbHpOETzVsKMFJfCkl8UyNTJjN8n8y61oCyFpKD3ZcF+GgY/QVw\
	N83TKporiC7915eGw7+BcEN1OCuMunwtY8L6mnnByJYh0h2kD4xs/LxhZNOvGEa6DNE9zh\
	FGJSSWUeRUbrOMwsUBJOH4wJfXWFalHjkTYivEpw3AkhHx5vu225aDUYBezifUQERE56st\
	rjbLyFhDSfdM5+XzOebbdGi0FYwcIn9thieVyAIsIudw7jsB9VKtCYw68lz59iGrhlGkrw\
	Oc08LI3sPcYeQqJQLRbOjMKFoAStWm2rppIb2ew6Phpa0Jlbaem4QCVgBcpttmYaStomip\
	SM6SGVUjgnW+ev6Q9gdpayuUSXcRM2vVQnmK65CBX5lVW0QlwN9EBLn/z03zsBJZRNfsFQ\
	hPwbU03GXAKJdfVJZ8npc1jJLnZPQn5ezSsSoY+S5X6HmFBqUtF9Ntyzuw27ppupsXGr7N\
	c5iZDqCh0tI9qrtiBkhtaUXDSFtUxuHcajXpblsMt9inNILdF3ngOQ2jO3Du2fPqns0NRJ\
	d+/mXh5alGygRWBqPeoEjzXA8Y2bK0+3wanZPAyN7TUYCRt4gmglGumxYu1N0obfWYbp7t\
	/tUw0nqV1WOHzXMObA2tNnCZbly+m6Ytn66Jl/qf1lHl53bvAhnkYPR1Ez6kVpmzReSeBH\
	xFHYwaYJ3GXrOBUYc1t767PJKpxylh1FKuiWFUgyDAQwyMrNXTgClxYGvQlNqKCEALaUJD\
	VzAKjbm00NBg0xDQ3bRQVuXXSSwjbTV1WUYhr9x6s5Cn9ivp/JTV5I7Bzp+jdlg3MHolIs\
	in7pzgIeVlLiC69PMvC4evQtxWFOnsywhVo9Fv2DrAyARXCSOxoFhXGOXqsQNGuswaRq1z\
	jEI8YyRYQ8RQqC0YqLtKHXONqo3VyjivYNWUusG2wUhbQbkuXg5G/m+pABH5n0RBJQZPbt\
	i/+Yaa6RbaWdXWGrNziWzc7vNASgSnYfTZOPf58+iezcciqsoxAL65ChswHAoYpY1q/XZ5\
	DAGTZ6JzTWGUdMtUeGYYSfxPzHEEIw2c2EqqLhuadP6f3ZMogpHZ0TGAIAsjY9lEfiljRY\
	3rptmlHOhvqNlumraErH8oYyEpGLmdp4HbhjKB0SvHPZk+Mr+umbgvBW5SYRVHC4w4tDCa\
	epHszDCy+nyeic7pYBTlNwuMElkwjGrwhExzMPJdoCyMmuMGRqh0CkbJUHz4exBDp4bRyJ\
	zXcNLdMXU+GqpvgVTUjYvBImFZSCeM9L/M8hANI7Zh5xm+SiIY/WVEkE88o+PhjJeZQXTp\
	516Of2H+1/wLr17ABEYhbkEw0uEZYJTKEYAR+UYvGgyRjglhtPRdHg14sjCCZsKhglHi3w\
	nhocknQCHEhUZOcz7ax1pZRJHloq0jD8dkuYi+LgejNktJAyrASOseEnfHMtuKRNaY8hVt\
	P1PVYw2jO8B9zqzds3lZRKcITuquJQeLglFf+EwJo3Xa5TGJ73z+HTBK8jzMMFKWUG35dM\
	BId5ta5hqlK/YtjEKjFgUUDaNRnK+1ZLQfpx7ut5DRMJJYb2K9WNg1Ph/RS1dqQLb4nRJo\
	NYByO3eADJp6bGD0ZbNhqNr9aB7ySuBYHRIHTrdk598laWBkwFM/aAWqOOjT5HTUgMvl6Q\
	/bwjq9iHrn47CIw7l8dTflnFRHUT3wELb1FjlhmzpsymL1FVQNhXweVod+LnXaoCPck88z\
	qceQz5h7lAKcLVOtJi63Dkup6sKpC3R8LjNJyxDpUnUgJbhQZx5wrqzzFwqc83AJYzB1mg\
	DdIbiBP/b3GupVqPKv/47q8wfD6h/FgAt74MQhTri4LzigRNjbFygqTu0PBeccwxJGowJX\
	CMePCbd9lrCzU0a3XsPWiaqOAQ6JH5e+JqlCAdmi6coCbhd2bof9P1H5lIgrvhiRHy4//n\
	SKm96ff9ZjZCYQXfrZl4fCf10SKUWmUUECo+QFDy2gCq83jJrr1xpG2R+GLhjZe5o3jPQ9\
	mXJPAqMEupPAKCQdByPnX6uhh5H4+6Epb3RLRZMvAmxFULr7jx3//bePcf/DA5xzFMWAoi\
	goCodzhT/24aJg4ONd4aLjwsedOun4W18x4sYbJLr16J2IYDSKH5fzD1of19cMQQZx+u1n\
	wP4HfP0HGJcvxRXHEbnIlDKPrtkTgFdkY5KRngAYFDhobrJp8VG4s/uZ1ZFLZ3WYMCos7e\
	HDueWsS/Ps7KbZ2dfqXHKPpgy5MgPL2+VR1D9Iu2mliStVGuUDUsfNLo/BgR38RLabZhzY\
	9TVVuj/+oOOHf3qXjz0gjEZV968sR4xGIx8uKcvwT5CyZOTjpZT6uBxVaUbliHPnS37m1w\
	uk/i6b9kOZLpf2Gdn1Z9nROvt3iNt+qqre+sfkGFK+tOWB9JKZQOTVfjXSYVnNHUYZ0HTC\
	KPfiTgEjra4XjFp0tulIrjsCMJp29nWkowtGY5zXWRihGqq3GqIZ1QFOpTo2MKpBQwuMlA\
	MbISyA/ZW3bDEqG+CMRh44UTiFUSllDaBROariRmUdfvgR4eP3C6mvR/unmrj4G2qh3NZX\
	lNvBsYTi6uqfBGuwhtFMG+tPDaKLP/sFXr97Jao8lXS98CH+kMFo2tnXvXVkGtUyYJToGw\
	ejcCJTplx4LWAkJJaRPpeFkbaeNIyM81insw7sUqUph3zsAWkAY60fsRDy1o+CUVmWjWXk\
	gRTCFy4FK80O8Ye/seUjiWPcjpJpQGkolVBbRRGMvgiE8r6ntT2MTpneIqoa22ngpZI0gF\
	z6JcAoLZ860acrcBnCqGuU01wfTXiMdFjALQJGNp9JYOT/jptrVI8+tcFIbTlrwRXNEVKN\
	WS2qvepMWUElA59s18xbQqNRmcCo1N02Ea6/etiUKYKRXrCru49hrlFmKkC0Yl/n48PbT2\
	0g1MDoGeCu6YZAu8zmIxK+ENipDtcARskLb9N0WE1LhZGVMTDKpY/KcznAyC6StTomhZGx\
	jOpfdj1sri2d5ji/y2PIp1RxAUZV/MufdZFSYhiV5YjSw6Tqmo0iGIXwSHXFNIxKKXn2Hf\
	tceUpbNQFGdisQ23301pFe2lHHhe1PQj6NBeW2b6UeTIhh9OJpu2dTgejiz3xBOPxyrVgC\
	WPoWZgYYNXIYYZSz5joaVcc8piZ+ETDS0gdG9rplwKiIj/vCKDfXSMOohpYBkl6X5icNts\
	NIL5Qd8cXP3+OrXnoJ8TAKXa9SSsrRKIJPZQmNECEKOxF2t0fsbA25/uoRX/KCfb7mC/eI\
	ABTNQxrFZdHdR91Vq2dQ650BDlSaANchuB0YXO/rM4LRS/o3/lic9JwR6dT8Hg+iAvgkUJ\
	WojnbU8xXatZowNC+FD+shReCPPrrHH967x4V9iS+rJZdnGn/FiYIXPm2XJz9hkNHfEtZ5\
	RO0sTpPOM1Jl7asjyqPs1Gd1VPFiyhLXY3bI29k8tE6bvglX96Ti9T1F+dg8x+mw9VSqYx\
	3W99hRb7Gy+G89VcT/c85HOeoh6jqNDlfHrghxg+h8lU8Ib0XhR84N+NhnBuC2cM5xfNcx\
	KBy4ghPHBzhX4FzBiePVOecKjh8LeW41+gpX5Y2DYlCdo1DpwvGg+odP7wr/b6DKPvC6qr\
	9VXv446HT+Wgrk8dfDxbtVfRXgeDvwfIDi1g9WT6YnX2aZR3QXAULQWDOu+lV2dg6HlmRe\
	C40lhDRh/yv1fb/wMK95x+MzFDWWwsF3fuUZ/ubLThj9kg/XYs6Z+xg/z8jmmdEhqHobN8\
	fIyFTzjLy1F80r0vdo5wA111f3pPLT9Rbl011v4+cZZeYYUap81LsTyphMeESlcc3f3Fwj\
	Qr4jYKD0lti5RlJ66Duo5tyUPl9vqblgjWzV4StPw5VnfP51w/f3FOYw1edLD4zC5xnmM4\
	2gLMAdUC1GHVVldoOqHPVEy4G/D18vTpUFafLy1mB9q1GVDqt6YEj9Bdgtv6xU/BWuBCnu\
	wnEC4UKu5rtkFh/RFyVn1Hsn47po2S6UCTvHm95/ca4Qgsp/+EO//Bj3fmbUnOzbhRrThV\
	n5XkYL6abZ9B3dtEhfh1k8bTfN3kN0j6bL1vr+6W4ZZEfL6mvDUowQH/wozbGErkmysZp4\
	/5DuGoU47Y/JdP/sMpDaeSzEXSuh7kJFw+3qOFpiEsqi8tJr2rwTuz6XfLbab5a2fQvND5\
	D/oaMcIDynu+HnZWIQKf/Qy5NI/cM3FYzMyyTwlnsuTVrEXlIK/O4H9hJ9WTBYSaC5jjCy\
	ZbHXzAoje0+TTnicTMf8YRQyCvCxcAojXsEysmmUAzsHoxoutMBIOboTGFmYhL9CPIqlYW\
	SH3X35yhH1bpFt69Iy50SPnCV7FY3AHa/mE6Uwmmr72Gktoi3gBa2xc4TR45es/2B+0vib\
	WmDUGxSsIYy01aIaqs0z0dkXRvFzmh5GNjwljFrK1Q9G/m9uRK0MaXIwCsCxMFJD5vU8oi\
	ZdY3HpSYfauRyuVU5nDaMANvvlkGgPbb0JvgdSFjzKgW3mH4meE5Xscz2CwY3mnRQQnj2m\
	wrMyLYjuAk7Ep1q6WjPC6M6bdqcs4nj53Ju3VWgeMDLBVcMo0reuMMrV4xQw6loKMncYlX\
	F8BCMTr4/tXkZh5C1ajqEsrRykIhgJ8bC7+qctK70PUZsVlCzzqP5JeUC9r5GF0dYN/taU\
	sSDybATKDz+5q8ITmRxE1TN72QRpZ4LRX37uSW6+Zl6bBDTy/Kfs8vzbj5mzs8Iovcf13H\
	KWNM9E5xrDSJd5YTAK53IwQjV4BQ0PgIpluV0efd5q/VkDIw0hA5PIUlIznWsYHaj0eoM0\
	MfnmYGT1NvOFdDewWaMWpisM/RC+WBg9FTjdVdM5maiFX/xp7x8SXpK+S47OJ+2YYjTNce\
	rYgJ/+367nx377Mf74vj2GIxXflk+HHNt2vPhpu7zqC075IhudyYiND0vQZ+/TEY+82DCd\
	o2lRuLeOcaNp+h6cTyeqLBh9Ps+pR9Pqgqjr7UhXuMeQz7h7zImtp8xompR0rthvHU0L6Z\
	QOnQVA6aAIMFL78oSRsjp/h0iBq0e4RD2HAMQQV1ajXwUNbNStNu+fH91yRVy2UvzQ/UGV\
	RscjTbjODxMfzktT/3X+qq5liLBFs3p/gNu6rvpxC89TSvx8hmcBv9NWyzmZxtQogJfEL7\
	H+pbMmQRw9DYyuObXF937VVUqFhVF4eDpTiYO2XG3bYmTvY3YYpVLlUQ2BT6NjfWHU3NOM\
	MMruZbREGOWeYyuMIB3ed8Tbh5SqjFAPsYOHkfoBBA8Cvw1HPQWgNJAq/NC9Gpqv20iYMu\
	DDbktBR8+jMxCKYKTPDRHUvkYMYHAljM5WiVwNo2ciMhGIpvER3QacAVXYSDJP2L5rU3bT\
	6ryWueWsjAnr9FafbrMds6OTJSu9dUzfTcvry4mjs5sW5dnomHrFvr3HpW85qzMKYBB/7P\
	9Zn1HociHoLli6Yt/DSE8BqGc+q25a3UXyOmo/k88ndKtKdW09Gmcc1hLSeV22W2ZX6Ws/\
	UbIDZOim+bwZ+e6Z/yEID13KO8ZUcCLTgOhZUSj6RQ2yZBhpnWbocCIYjW2oRwdG/ecYZc\
	qQgGkVMApxbTrmAaPwjwyMNFRyMCoVjEKjVjCyo1316JqFkfEZ2SkApR7Gt05lBbrSQEWn\
	036hHJD0QlhfhvqDjoOrfRWVqp64Y9Ih/MlAVOX9rPR8ewPLXF9Hzw1GyQsem+W9YSSZ+K\
	XAyBR7HWFkYbByGNnnltPRA0ZjRcEnmWsEzcS/XBo/8lQ31FEcX0MGsg7sZF+hAAIzrF/q\
	kTNlMSVzj8o4rragjKVk976uATWM8hApYXCVqQtA5BkA5Qdv6VG/lUzuIxKelbWAsj4RR0\
	IabUGF6KxVFdI7Ut+HzyjAKEymcirT2lFRhRu/RaZcWkcNOKszp8OEW+sjDi9sy1nt3+np\
	M5ppy9mRozwrlI9Uxwyo5rldIbhTTdrF+Yz0PZly63CXz6hrT+3mxjP1o+oEieslSaP2vw\
	Yqv48Q+avEkXVgh3uJbtfXl/UZ1WkKiLaELcz1xHF1XlT1Hfgsqp78+1LBa7vRW1xB5Bur\
	0l4LXA083FGpkfQG0cWf+oJw+My4ohVVxjpovajrBb9Iti+MtCU0E4z66JBMOqvDhGtZAY\
	xso5o7jCorpXxIGH5UGH0MZB+Tf/XX7UBxnWPwJGFwYwnHZ4BR9KPRB0aY8DgYmeuyMg5G\
	I2rHM/jnoiyuCEZCsy4tlE05sPEO6tJDIgJIAJhyTkcwCukVjDDXZ2E0au7LFyu6TsNWDq\
	oyAgzO+HsZNfdSLYC9E+k/cjapRfREwkLXUOjoAeZgNKZBO98olw6jTLk6YZR74aeAkYrv\
	ByNTX2NhRFyH84LRCIYfFYYfEspHM8/TiOzD6BOO0Scc/M+C4hphcLOwfWuJO94Co1wZc/\
	fQd5FsVB9dMBo3koZKq+vH1GUEI+cbpaMe3ZKyqud6dMzCyPl7U1AQTwZH9ZwDpOp60DDS\
	kBGahbc0Za6rS5Kqq48TGKm6t3lRVDAaPRLfC8Xt0H/kbFIQ3RmFsuDIgecow8jWxThQxI\
	1qohX7vXRkGtUMMJKLFXyGHymN9TOZlA85yoccB39YMLhe2LoVBjeXuG11T4IBxSGAkc4G\
	qNZhKRjV76aHEgVSOlyhu2lhqN815Qwr4mtLKVhNI1P0ApyfQ1RbNhYyQrPKXnxeWyouA6\
	kAo8gi823Jdt2Kq2D0sHomBUh567ia1NIfRFX9PzU9X6QPL3nx4VDBKClfF4wmBQVJ/SwF\
	Rol0w2j0aWH4oZLRJ8vO6plGRg84Rg9swTth68aSrVvLqvtWLANGNp8ZYaTrPeTbCiMIpk\
	YCI8SDxp9zGkbeUiJYTbro4vUGy8jXSVSFBVGXr95OZGCgZQCWWFgKUBpGxekGtg2Mbp3k\
	xZnMIhJuSx6SBkGUdoEwSq6dDkat5Upe+KBj3WBkpQNG456HOOSCMLp3xPC+EXJ+zvTxmk\
	qBQSjTCIb3FQzvK2CrgtLg5hGDG0rc7qJgFLqFFkbheBEwMpfkYMSAxlcUYOQLEawmKapM\
	olcxjBSWGRgJzXfVQrlC2Dq0Vb4iTd3UgFLxTmIYFSfV/QXLb1EWUSW3dTaCZcGoFRQ+0B\
	NGInr2dR8YtdxHK4yszBtGubrsaFSZeyofFkYPDCnvLynP5kePHroIH3vMsTOA268SdgbZ\
	ZJ3ywOPwrvsdByO48TQ8+wYz830Iw3sLhvdWFnZxlTC4fkRxnVBcWVKcLGv/6EwwCvUyNx\
	gpnQmMghVSkL4bVYOVsvAw8tDQMBKnLI/Q83BN2UTpDtfUMArnQhnCBm/6o4kWRr6A2hIK\
	AMJ5uKo2FbpuxYmmXdVQc7ciIH96E+6pHx9Xkf1AdOmn/nw4vD2uzMQ8AtswZoVRm6wERv\
	ZexsGoBRTzglGuzLVuf3jJIRdHyJ4gF0vkoiAXBDlfUj5WNpv3tchje3D3x101tQV48ILj\
	pTdPbi2959MVhAA+cQ5uOgM3nGxJLFA+7Cgf3oIPNKfdruCOgTsmzb/jUp0/LrjjJRwTih\
	OlN7syMKrrxsJIvTv4+F4w0tfQ5F/nq7pXNg0ApbeMoN4BMTiuKaqFrZFPJgy3Bz2iIBOs\
	qQPqIfboBgriETIhcmiL/aufs9Zj0waLSMPI3YiTbYSDPjU4iUXkgCfrcuXng80ZRhOtS8\
	MAh/WFUYeO3jBS9yQXR5QPjyjPlcj5Ejk3ojwvMMrU8QTywOPUEAI4ewn2RrA7oVU0NMbW\
	wRgA5kT2HLIHPDqeDu6Y4E4JxdUjBjcM2fqsIWwtGkbmuUQwGsT5RDBqDKEGRkLt+K1hFC\
	wV7QfymdRQCF21A+r9qeuuHur6UVTkCjQKB1GcqpMafiqNO66uCzAqCyieBHJvn9qbBEQ3\
	AfG+GbWT08oqYdRiKa0KRm33aV7ESWHEnjC6/4DyM0PKh0fIgjaQO70Th3cHsNNnQrKR26\
	4S3v9gdcMnd+CGU3MoXIfIJYdccpQPFgz/dJv9HWH7c/fZfsZ+04iXAiM6YCTouUYxjAZN\
	gw8wChvVC1V5Cz1crvWFxuOhlsBIqvwjGHkHtgzixbf1a6f2vnYDqm5aSFNQWWAH6r4cSH\
	k9MHcQXpfnWQAAIABJREFU3ZiecmmD0nErhVHIBFYKI6tPp7f31ANG5YMHDD+8R/lAL4t3\
	ZrnhFDz1arj3sQpCf+4JdleDfvKUq+GGU8KlIVx9XDmslySy79h/1y7l2YLdl1xieZZRaC\
	M5GDnsXKOqVyY+/UDp1cP4VdrKYRyG/n0aF+4j3JOFkbd8ZOT1Co0D24fLrdgC6wOj4hiM\
	9mkc7ALOXdflXdEyCYiekJwJn0hpg0SI07JKGNl8M3BYVxiVDw4ZfuAi5dlhSwUsTu64Vr\
	jj2tnzOb2TWljLluFHthncNGTrs8NOicQwqmWOMAr5tcGofke8A1sKqq02/FYjtV5HvXYu\
	hKOlIAE6KPOqVAAqiIfuw5SA4MAeNOUoJZ7Q6MSX089HioAmwHHgMfXDDoh7UrZdZ2QSI/\
	uG1hg9t0FL3Rjt+Sy18nlLEz3zZvzJ9iEhYwujjnJldbSkFxWWTHyt35zS4ZFw8AcX2L/7\
	3EogdBRl+IFAw+BPoQmPWyTb8xe+SRh+mAKUAox8w9bp1Or96lClibaALWnfPmQYp0Ood3\
	CMFsaO1HFJutBVWlbsHzTX6IW6xY66lXBQXrcIEF2XnHGmkU8Eo5yKBcPIlmVtYdSED951\
	ntHH99jI/GT04ECNFq4LjAJwLIxGdTiCS7RVbemNuRYY1avsczAaGbDYrWnDNSOV10GTJg\
	DN7fj04ZYF4IlJj6hF+oGoyitjEWUsjt4wagPKGNt3YTBi7WBUPjRcmi/oshIBuaiBsmgY\
	KcsngVFo6CptBKMADMjDKGcZSQyjOk8LowAWszma3jQtB6PwEYBQtnII7lhzDw2Mru5bS7\
	1A5OvN+IjsgwqHC4JRzIgFwEg52ZSiucFIh3vCSB6bYox7I5PJUmAUMlZQ0DCKulEWRh4u\
	ErrlGkamm4W0dNNU2gCjaNdGHa/gpjfq1zCq4aTz1/M5ahid6VtHvbtmAtemmV4OMLLBOc\
	GnB4zcdi/P6EYmlOJ0iTuhiV/HpOG5w8j/rWEE7d9Mq/5KgFYEIw0ODaNgGSmARd9U8zAK\
	PqAIMjkYWTAF8CiLTEqidWv1PXKmbwVN4iO6qoY4GK9/5rgLRomsCYy0TolvtDeMJBM/JY\
	zcNdtsZL7idoXdl15qRp2CrBRG2jKyMKpgkMIoAMNYRqJgVENjlIGR/0x1/bFGDRzbXdM+\
	o2AlactoRD0AH8Poir61MgmItsPt141tHIzqtFZyv/TTw6hdT4jLgSEDowQUq4WR2y0onr\
	ji8e4jJFu3jjj+5ZcorinV2TnBaCKxMHK0wyik8/6i2v8TumC6m2b/omDUZhkFn09wWgf/\
	EDR7X2sHtgaTspR0+20aSm8QTTKPqP5ommAYJNFBc5xMItSi06tzXXOFtKg8xfk5Rlk9Ib\
	3jMO7yuPX0kxw8dIDsZ/LZyFhxp4TtJw/Zum2IOxWezbhFsiqqDod5RLZL0HLdWAkXSMOc\
	QsEn18jqVzWkye3y6MtYZ++o9zKqP0nkaL535uceUXigFKo6CppPFAVQScXdYJE4fy2DSk\
	9YnFs1lDN9R836gai6qWh5R7UoNa6nThhlpS+MxjVoWM2Ws5lyTbyxWjeM3LEBW885w8E7\
	HoODDYzGiTshDK4tKa4vGTxxRHGmpc5WtrFaVAil1/mZ0n4SY6RXlU/8ux7tf61ghCNeS+\
	aI9zLy+2Lr7WnrCY1F5lXVMPI6vbponyMc9STi+rZELULrlkk2RjsW98BcvAShD4yyD6kF\
	Rr3O0dy0C3A8ejAqrtxm50VXcPCH55FHN5MaAdwOuNNCcYVQnBGKK4Xiar8CP5m572Vtdn\
	mMCqX05mAkRHtf+0vyMHJNGWoY6b2M8MdhZjUKPmrnx+RVdQ2MCFuBeGsobG2r3Rn1shaO\
	55psTibpmp1JG7jzehcAo8tql8fMvVjL6OQWOy+6gtF9lxh98CKypxvQEZQdGFwD7gR+uw\
	+qfydL3CnBbYe6V/UQ6k0woNDwmQeMbD7zgJHSL0K9vAPXWDpmX6MGRkKzbMR01bAwEmO1\
	QL12TXIw8nlTgvMr+ut5TwfgthvI1bejYNRTJt0GJNvAF2YZHWYYLWKXR+cY3HKMwc3HKD\
	+1x+iT+5QPHsy81cdyJH4Q8fhBHLd1s7D7PGl8wA5y9VbVfQ4Ui4aRXSRrdUwDI3WP4v9z\
	yjICmn2KmuQVjIR4DZuHUVlW2++CgpGr4h3GqvGwi25HaFbph72M1J5JFFSjb37zft3gah\
	j1ezcn/64ZQV+okNAgx8EoJF8jGLXe02Qwai3XImBElWdx4y7FjbtVcc4NKR8bIudHyIUS\
	LpbIgcCB/zsX46kLJGn8tCp27hS27zDZJe9AA4Z2GNnrlgEjvXB2FhgFIGgYtVvQ7TByfl\
	Gs7sLVF1Hv4Oi2iFfsB91+hX3Oga1h5IaqbAZGPWU6EAWlRSBeHxipB7tsGLXeQxsofKAn\
	jFa65awDd2aLwRXxTmXR9iEjQUqpLKf6R7WKP7j3gOGH9+cEq+mlOAO7z4HiGn9iLCjGwS\
	g8pwXBSJdhIZaRhVGRRDdh3/YKSFf3l1A6tZLe+4aKABxH/WHHaMV+uB3rwA5WUtgzSdVD\
	Xba+v/6NTDJqZs6ZhrrOMJpo+xCWACN7L+NglLvPbh3Rcxg43MDBdhMfYLRzxy5bn7XNwX\
	v3GH16+Y5wdxy273BsPxn1moR7X2MY1e+ChZF6d0IZ5wKj0BWKo3UZK46EsoYvgziSXR7Z\
	qiY8RhurGQd2vShXVYEIFN5KksJsYRvmKxXqGba0z4xMMmq2j6OZXZesvD9qMLJ5rSGMkn\
	J2wMjoqIpdhYtTBbsvOE758IiDD+0zun/Y9/2ZWoqrHdu3O7Y+yzVdh1DGecEo5JfAyMhh\
	gVHyNVmlqoZR+DKIB44oiJUlFGrIvcRsrKZv1RF/lshbQuXI54G/3uup718DUx7te6eTdM\
	0uIuzoynSuanxVg++AUXMFhwdGjro/Xee1Qhhl7zNTd1PCCIHi6gG7zz2O7JWMPjVkdP+I\
	8qERMpydSm4bimscgyc4tm4qqrVedbkz8JgIRvaeLCgsjHq8V+sIIwfJZ4paYSS07n8dtp\
	ytYURzLwj1JEVBwUh9VjpijaMa2h+psJ7Y2O8uJ/cRmV/hLhjVDyUq0CGHkc03A4d13eUx\
	p8PCCAdut2Dr1m22bt0GgfKxsBl/WX0BZE+QfUlme7sBsF19997tOtxJR3Ha4U67amKhL2\
	P9Ndmo3LPAKG7008MIU49TwihK35RrcTAS7FyjGEZq50UczQRHbdn4gzqOJm2Ake6ORZMa\
	S6rN+oPyGkYX+t7hJCBqathApQ1GguCyMIqvrw47YLROW84mLyMhY/RI4uphRBSe5ssg1a\
	8jFFcUcEXBAFtvplElz0OFVR1Gn7ZeKxjl6nEKGHUtBZl5aN9lYOTIzTVqYCTqvkN5fRct\
	fLkjgpFQ73NdL9vwkxb1541qGDma1f+FLudjfUfOivFJ6ip4JDpZxhXt9AQm3SBDoZqkxE\
	8hMq+yHGkaoz2fpVbmHBFHLo8tZ9N7lA4dMpWOIg533kNch1FZbJ6JTpuP1lnEaZN7Cg3D\
	lKnOZ9w9Wh25a6yOwpTTvD8Tr9iPCkPdhap3b9SwKaNwNfdwpK4N8R449Xavkm4fEu1lBN\
	Ei2XrLEbUqH4h+SETO9r2rXiDyt/BIejJ+mKuBUa60Y35uZoWRLUvUGA8vjKLw0mBk9fk8\
	E53TwSjKbxYYJWLLvWwYBesuwCgoF/8O9oVRSbqxGjQw8un09iB6xT5SwUiG6n5rGKXMaJ\
	HeIAIeSerNsQYwantpxkBrITAKcQuCkQ7PAKNUqjzE5nkEYNTc04wwSqwinUebjmXDSFtG\
	mbDeyyjZjN9YRgFA9cZqpcpX73UdtgIJ3zSLYHS27w1OAiJjZglVn1Qr7wOjKCnxg9nAKB\
	tuA8OUMEqtoiaPVcAory8nY2CUvEuXG4yC4hRGdR3I0KRR1o7+KofQwIhh3B2rz6s9t8t9\
	VawaRgsB0SPhNitlfhiwBUboxBGMNKRIr+kLo0TWBEZap3HUTQSjvpbQEYCR2HfHNuq2PK\
	yOBHDLglGIa9OxRBjlLKEERvbLIMH6CTDS4XB9ZmM1u1GafsGr+32g731NDCJ/6+lLbmDk\
	7K6H84ZRDjDLhJF+mTSMkhc8vtHeMJJM/FJgZIq9jjBKVnuvGkaZH9+F7/KoRcGotlj6wA\
	haYSTqvIVR7cQO+ZRQhvVmEYzu73sH/e6+yvtsfEqoAKShwWQw0tfFB6SNNFew+cKoXU+I\
	y4HiqMHIqbhpdXSAwl4/NYwmtYx81DrDqMvaGisaRmRg1IymNVvOtsFIdbtyMNLb0daWmJ\
	5HVN/wx/NtNJX+dy58Kj2lYeQVTgIj/VC6YJQbLUsvjM/1NXV1o0waQC79ImDUR0cundVh\
	wqjwsmFk72/uMHITwqi5fiYYRfr6wMiGx8GIGUT89WGWs4YR6G+oSejWRDAyDuwERgo8Oi\
	0Csm+evwB8cq7ziCpxH08rt/SnJoRRk+dkMGq9p74wGtOg3apglLPWumCUe3GngJFW1wtG\
	LTqzOjJ+j7WEUTiRKVMu3DlaZ9JLrLMfjGbxF2k9LV8FUdZRCiNjPUUwCg7sEGcto1GTpi\
	6HJMZLm/QEkQO4L/3VE3Bho40JYOTih7BQGPU6x3rCKCnfOBjZ8DirZVIYdQAwq2NFMEr0\
	dcEoBwqb5yJgZPOZM4zw3awIRuF8c24sjMKoWd1tg3qHxujji2G72BpGB8Cn+5Z2kk7pJ6\
	s/6kWrt4wMp6aFEYuDUcfoUJq2iV4LGCUvvE3TYTUtFUZWxsAolz4qz4ww6hrlNNevDkZq\
	KUR0zZxgpJ3XrZZRBkY6Xfi8NELzaSEFo9qxbT+LXoLwUe+M6iWTgOhR4Hx16Px9hPUt/s\
	UJca0wogVG9sVDPcc1h1Fy7XQwai3XoYBRS/22wWjc81gYjLT0gZG9blkwUmWcO4yC8hYY\
	RfOEwgRH1f2Kvgjrr9dziOrylx8GwX3+w72K2gtEJ77+DeHw45FCv7i1P4yq8GwwCqfWBE\
	atoJgMRpNNeLSF6AOjzDXLgFEt6wAjm34cjIK+BcFIl2GZMGoZ3o9hRHxdGY6VA7t2cB+g\
	e0e+/B+epJiTjJoB3BedK0uvMwcjUhipBjo9jHTckmHUJiuBUYclNRUo0jwnglEuv1p3kD\
	4wsvFHGEb2HqJ7XCCMYD4wCotk6+UdEYw+MkkRJ5u4IAZEUlJvgJTAKADIVuohhlHXy9Bq\
	taw5jMbkudIV+3X8CmEU6esA55GAkR5NC8Ahvq6G0bAJ145uNIw+0tquMjLpDKp74pcoeM\
	/nAKM6HaQvnpbDBKMMnFYJo1x+UVnyeV7WMEqeU+b9661jXWCkVuy3zDVqLCMLI+PArgGm\
	9ZQAH5ykrJOC6IOEMmmlzs0Oo7od2hfNRcE4cFhgZF7AVcGoNyjSPNcDRrYs9ppZYWTv6a\
	jCCBoYNd2y2DoSAyMTH607G9n7HiL86STFmtwiqm8o/A1fh1wMjKq6mAOM1mljtagBtund\
	wKjLmotgZPNMdPaFUfycpoeRDU8Jo5ZyzRdGXnHLXKPYZ6RmUgcYyUFzXVO3H4TSjul3yq\
	Qg+jMqe6wpb6m+ez0pjESlYxoYQXJys8tjPv3UMDLBVcLI1OH6wihXjx0w0mXWMEoc5MuC\
	UZtl5Ij2MUI8b0qb7z0IFM/pvS/axCA6ACJvuJSjGC6TwMiRPNy13+VxXjCyZVlbGKX3uH\
	67PIaAyTPRuaYwSrplKrwSGIVCWBgFo0No5hOF0bUIRu+dtCi9QXTyVW8Mh/dEEaXfInIm\
	GMUPc613eUwuWwSMOLQwWvb2IU1ZrD6fZ6JzOhhF+c0Co0TWFEa54X0RYhhJc10Mow+MbT\
	tGJrWIIDisg5TDBjhLg1GUlPimlwCjmBELgFGIWxCMdHgGGKWyjjDKlLELRsm7ZO9pRhit\
	3S6P5GEECYyqoIWRtoTAw+jdkxZoGhDFZldNSkhgBN5a8nEKRhGwJoaRPo89iI8PI4y0Tr\
	NcZyIY9YXPlDBap10ek3jbqBOdLTBK8lwWjEJcm45lwijAhwyMjCWEHbrnEpR/Mqn6aUD0\
	h8mZ0YHKSsEo/M3ASEJa6IQRsFgYJbIGMEpe8PhGe8NIMvFLgZEp9pJgdLi3nM287yuDkR\
	4dw8AID6OSavV98vzfg9STj3rLNCB6P7AfnalH6rpgRDeM6uuIHubctpzVeUTS8qs+JYza\
	9YS4XKM6ajByKm5aHUuAUVd3NgsjH7XuMJpFsjAKVpDpptULY6P7/EOA4rnnJlI7TakPgP\
	fpE1IOSbpcCYwK88AMjBa95Wzr5mw2vTrXF+q6USYNIJc+B4pZYdRHRy6d1WHCqPAqYBSV\
	dd4wchPCyM6+VucmgVGkrw+MbHgMjGaxisDkLc1fM9dI9DfQGv1/NI3KiUCkRs5iZaODqv\
	HU/qEOGEWSg5GrozphpPJY7pazYxq0WxWMMuXqhFHuxZ0CRlpdLxi16GzTkVx3BGDUOVpn\
	0ospcy8YzdhFq8sY/D85GAXLSFtQDnKumx4yuUVU1X6srPQ7uGVhRAuM4viJYeTih7DZ5b\
	GlXIuGkWlUl+cujzptpky58GGHkbKOFIyG4BZvETUFlIzDeh9HkYGRqagERg0g1hZGHaND\
	adomem1glJRvHIxs+DKEUdfAgrl+dbs85vKZM4yALIyM+Hr+I5Hy0th3MCPTerbejd0G0n\
	/XqBVG2ofUBiOYEUZc1jBqLVfywts0Of063KJj7jCyMgZGufRReS4HGNlFslbHPEfSaqXk\
	MhVx7wAonvfYxGqmBdE54E8ju3S0XzcYF0DSCiMaGDmS+PEwogVG9sVDPZMMNNYJRsm1k8\
	No8l0e1w1G4+p33EiazXNRMNLSB0b2umXAqIiP5w6jbIbvmMYagilAdPIb3xQO767K5PuJ\
	wz1wRQ0Ppy2PBEbaKumCEeRh5IE3NYwMEJcJozZpBcWiYdSSfiqrJdUxFxjZBrZyGNn042\
	AU9C0IRroMS7OMsvL2abOfZdLBW+sjkaprVo5iGDmf/dQwsjAjTschhFHfLpq+dqEwagdF\
	HkY97n0WGOXyq3UH6QMjG7+OMMqVs0tHC4zsPUT3uDQYPQqT7UGkZUpnNQC/H58TZHSpOl\
	40jFDpUDCq00H64unLDxOMMnBaJYxy+UVlyee58r2MVg2jSF/m/eutY21hdHfuZF+Z3iIS\
	7gHiDUcO9ppGsgoY1e3Qvmhd0DgsMDIv4Kpg1BsUaZ7rASNbFnvNrDCy9zTphMfJdKwRjH\
	4PYPD8yWZUqxJNLSXC2/QJGV5EA6QbRqi0i4WRQFN50TM+5DBKjtOGuIFRe6Ne343VyNTj\
	lDBqKdcCYPR7M+Q2HYhOfpNxWAcZ7vua1zBqYBPDSFF7FhgZp+5Cd3mM8lSyKhhlweSI6b\
	MOMDLBVcMo0reuMMrV4xQwap1jFOKZXhoYHQDvmCGnWVfI8db4RgQZ7REDxP/1YElg5JgN\
	Ro7k4a5ml8cVwUiXZW1hlN7jZpdHVaZ5wUiXebkwehdSXpohl5lB9DZgFN3IwUUFlaZrVn\
	XTYHEwih/m2m85q6I3uzzGeazXxmrzg1GU3ywwSsSWe+kw+l2Y3j/kSzCTnAf+Z1UYf+bA\
	+4m0igyMoq4b9vxhhVHbSzMGWguBUYhbEIx0eAYYpXJ0YXSEd3l849gf3DEyNYiUn+gN9U\
	kBObhYHTuddQqjeikINDCqAhkYuSyMojRTwSjOZgOjNh2Z9FODIg4fjl0eczIGRsm7dGRh\
	NGJGR7XXPINUhX5jfE5geKlqFPOCUXjoBkYS4urr8zBSZTUw0pAivaYvjBJZExhpnZstZ7\
	P5N3FBn3l3bKNuy8PqyA4sLANGIa5Nx9xh9E6qntFMMmvXDIS7gb3o1P7j1EP3EYwUYHIw\
	ioqk0/q/QjeM6uuIHuZh2+VxYhjpl0nDKHnB4xtd710eddy0OpYAIwuDlcMo8+M7DYz6y5\
	sBBi+YjUWzgwguIfEsa9l/nAY2GkbGyrEwsl2uBEaFeWAGRtEMayaDkb4uPmiOkwZOmsae\
	mxJG7XpCXA4Uy4aRLee8YeRU3LQ6OkBhr58aRl31loORj1pnGPW3it44Psl4mQlEJ7+59h\
	O9KSr4wSXqD6/lYGSPExhZYBkY1dIGI9dE94WRfih9YJSVSWCUEd0okwaQS78IGPXRYfLL\
	6sikCeFlw8je39xh5CaEkZ5Uac5NAqNIXx8Y2XAXjHp10Q6Yg3/Ia5uL/HYcFNi/UEEmvL\
	wLg1ETPxWMVB4L3eUxoy8rihFrs7HaMmCk1fWCUYvOrI5Mo1oGjBJ942AUTmTKlAt3jtaZ\
	9BLrnBOM3gpc6EzRU+YFoncC56Jftv3zCj4KIm0wqkjUASNaYBTHTwwjFz+EzZazHeVKdG\
	TSTwUKkka12eWxJc+FwMjm0xtGvwmz+4dMqWaSIaGv6Aste+eIu2UNbLIwqtO0wchUVAIj\
	9aJGaSaFEYuDUcfoUJq2iV4LGCUvvE2T06/DmTwXAiMrY2CUSx+V53KAUegWTgyj38yenU\
	JmBpHyE/1afVKodmzUm6XVoPETFLVjWsPIBRi5PIwih3QGRvWER1Q4ByNaYGRfPNRzXHMY\
	JddOB6PWch0KGLXUbxuMxj2PhcFISx8Y2euWBSNVxvjdOwv8AXOSeVlEAK+PQlJZRS6AJo\
	GRhkoORhPs8qhnZicwgjyMPPBmgpHKfx1g1AqKyWB0JHd57GpUK4GRTT8ORkHfgmCky9AP\
	Rm+g+e70zDJPEH0CeHd05tJj4AoPFDcGRuRhtNnlMQ+jNlkJjNpBkYdRj3ufBUa5/GrdQf\
	rAyMYfYRjZe4juMQuj30Tm4x9SWmeTbPcMkL3zIGUFowCgVhgFSCwJRqh0HEIY9fUX6Wt1\
	eB1hNCbPlW8fsmoYRfo6wLkcGMU9oBllnhYRwK/HQamc1r7r1R9GCkqrgJEuQw5G0bX6by\
	hDvnJWCyNz36uGUS6/qCz5PC8PGNl7mnSO0WQ6poDRu8F9PFU6vcwbRG8HHtYnxHfP8jAK\
	N5cZJesFI1TaOcKobof2RXNRMA5sYJQNt8GoNyjSPNcDRrYs9ppZYBQ/p5XDKC3X68AxeO\
	F8umU5TbPKCOO0lotnYwsoglEDmW4YNefXc5fHCWFkpgvU95AmzF8/bxglx2lD3MCoS596\
	/jbPROeyYWTDU8AoHdZ/Xeu7OaXMDUTKTxR3z8qhmtwYoJCBkZ6smMAonIcsjByzwcgxBx\
	hBcrINRpEfSp9fEYx0WfRLvlYbq5GEVwojU4frC6NcPXbASJc5D6OHwE39/bI2mbdFBPA6\
	YF+fkAtnPXCUBWRhFP3VUImvWTyMqK9f+10e5wUjW5aoMa4TjNJ73Gw5q8o0CYwSsfXUCq\
	PXI4xa38kpZREgehS9WRogFx+mAUlPGCloTAQjbUWFuKO6y2Ny2bxhFOLWG0ap+OebNNS+\
	OmaFkdXn80x0TgejKL9pYTT9xmrePxR/SWxWmSuITn7zm8LDf00UMdxDDi6QhRHkYZQ4lP\
	MwivxIepb10mAUJTVlXgKMYkYcPhjp8JQwWqeN1ZL4TmiOgVHyLtl7WjqMRlD8j7E/ilPI\
	IiwiRPglzNfX5MJDUAxIYOQGVQINGQ2jue3yiO+6+bjI4hoPo+p6VLoqbm67PK4rjLTOzS\
	6P2fybuKDPvDu2USc6W2CUAG5ZMApxiY7fRzh7aEAEPCRS7dwWRC48VB1EoGlgVK8tS9JY\
	GCnALGKXxxYYzW2Xxy4YJbIGMEpe8PhGN7s8zglGUWFXDaPMj2+l43UAgxc9lN7CjDJ3EJ\
	36ljeFw9dGL+nBRbOXdRuMFESyMDJgad3lsQ1GxXgY1dcxGYzUpebAHENvwMwAo3Y9IS7X\
	qI4ajJyKm1aHaSaLgFFXdzYLIx+1XBjNfdi+znkhuVbyi5jHKY8/CG7QD0bREH4LjMLxum\
	w5K+a6+KA5Tho4aRp7bqyDliTPw7HLIyZO6zBhVHjZMOram9pePxWM3IQwaq5f0i6P9yK8\
	7zCC6JPAW/ULKo9/2kPDwEjDpsjASMjD6LDv8tgqfWE0pkG7VcEoU65OGOV+faeAkVbXC0\
	YtOtt0JNcdARj1n339KwCDF3+GRchCQKS6Z6+BppJk/wIchC98KBhpIJGBUd8tZysSdcCI\
	FhjF8RPDKILKZpfH1nItGkbTzr7uraNI63AZMEr0jYNROJEpUy7cD0avbS/U7LJIiwjg5/\
	HVUcPo/AMKQAZGAUhCHkYKNuu9y+MCYTTL7Gt9Lpt+CTBKyjcORjZ8GcKoa2DBXL+gXR4/\
	A9VnpRcliwbRJ6EZPROB8twD1bwhF4CSgVGwgMJeRlPv8tgCo+i6DIzqOUY6zaQw4rKGUW\
	u5khfepsnp1+EWHXOHkZUxMMqlj8pzqGH0qzD/2dRaFgaiU9/yplABP6fPy8ElZO8xD6NB\
	Y93kYOQBM/0ujzDRlrOOJH48jGiBkX3xmsuzD3SdYJRcaxpqDxhNvsvjusFoXP2OG9a3eS\
	4KRlr6wMhe1wtGr0Fg8JJPsyhZtEUEwmswa8/Kx+6nXt4RWUSLgNEEW862zr7GXI+CkQfe\
	1DAyQFwmjNpkHCgWBqOW9FNZLamOucAoyqMPjGz8vGFk04+DUdDXG0aPIcUbFmkNwTJABA\
	///+2debgkVX33P6e6+/ZdB4ZdEBKjkmhMRF9fozFvEtyNmLhGn/d1iUYNqHk1r0viLho1\
	Jr6vGgVccOXVKEZxARVRAQUFBAYQGJZhGbaZYYbZ7r1z7+3uqpM/aulTVedUV/Va3fd8n2\
	eeW3XOqVNLV33md5b6FpLz1QRvcbv/MHQDoyjCMcEIPYxSXkZFYZSEGfFyjCGM8jbR1G3V\
	9b7DyAwKPYxynHsvMNLVF+07VCcY6Y5nhDCK7S8DLu2884C1sQbR/MnR6NnXYj+W20Au70\
	IGoNHCCPQwir2hr4ORCgwYOIw6bFBCAAAgAElEQVRQyqHASD2GiYGRBk6jhJGuvtix6Osc\
	uZfRKGGU+p009198H36z7E+3p/P7qGFERADfBRbVBG//vYAwR0aO8g5aJozCH1XTMZ0LRi\
	hl+wij6DlM3mhZ0LAw0q6bYJQbFOk6ywGj5LEkt+kVRslzKgyjVaQ4P5k4CA0LRCvA2eoP\
	JZd2gNcC4QQPtzDASAGOFkZtyHQHI3UawOBhJKH9w8d+9zGHUWo5/SBaGJnBUVJjtfOBJe\
	M91EcNHERK8+xLQPsCSIlc3B5FOzIAixlGiY5qHYyi0S8TjNrp5bSchVRiFoyEZuNRwSgF\
	irBiGSszehglVkcNo9j+SgejbwFU/mwbg9awIiKAS4EtQHQBvL13I5xKCkZABxiJaD3tZa\
	QAIwWjMB20MBL0BiNB6scdjcvjiGCkHktpYZQ+R+vyqBxTG0YtEp8HG6SGCSIJfEVdk6t7\
	kY2lFIxE6FGEEgXpvIyMMAqBpkIlvs1gYRT/n6X0lrNKdk8wSh5L7GEcTxitY5fHnyLFHo\
	akoYBIaZ6dhXppJXh77gKEHkZRs6kDjEAPo1Qfjh5GsabberScjTNiADAKb/ABwUhd7wFG\
	aU0ujHK8JPtNGE6zTDmKIUlyJ8QN07w9dyXgoIGR2mQbpcujCH50DYxiZbqCUbwaC6MO+1\
	DLdw2K+HqZXB5T+ZnQ7ACj1L3UEUYt4BztfTIgDQ1EUVQkOTOW4Tbw9t3nv+SamMiYglEI\
	HAOM2i6PA4RR+KMnYCTDvGh7PYyCa6CU8/Mmx+VRqUsHRkjAKLmaEz6pOjusq+XHBEYjdH\
	k8Hxn/UOqgNdyIyNe3gJjXpLfnTsKmV24YxUCjg1GyTBJGCWglYQT0ZDkbbUcMRn2znFXr\
	iMnwIHUJI/N+wrysh4r2+aUe4viJltvlUc3rdh9DgFGWeZsWRkFWGkbfAEHlz+9N72NAGg\
	WI1pB8WU2QS/cjGysGGAk9jBJD+WkYKRDRwigR5SRhlGxypWDkJG7CBIxUoBWFkbpdfKG9\
	nHrASZdJpnUBI5m5n6hQYttRwEjNU/dhqK8wjHQPbhcwih3rIGBUJDJqb6/AaI3ABG2YGi\
	qI5k+JOq0/n7yxvQe2BIBJwiiEjsiGUQw2Y+jyqMJIvXnywEirIjDSSH0oUw+ArvwgYFRg\
	H8n9xfahKROu9wwjwz5N+0ht128YiV5hdJ6UYh9D1igiIoAbgUvUH8Xbc2dwJRwtjGQAEa\
	HCxOTyKMQAXR5NMIrndwWjSCVzeWRUMNIc1zBgpO4u74TH3PtwRgOj1P6MMPomCCon3mPe\
	fgAaOoiUqOizQPtittbw9t8DjkM0ZK+FkZMNIxVImS6PBhhFzb0sGNEBRnQHo1iEUzKXR0\
	oEo9TxdYJRcr1T1DKBMNJGSSkYLTOCZlm09xHpmxD0zAcX09t5iw8WJ+yU7hFGkg4wIhtG\
	mGCUuPFTMFJu1FiZojDCwkh3XKmHKlmmw/51dQ4ERkl1gJGufOx4Bg6jc0Ec6HRUg9AoQb\
	QKfCFak/jWICt70zCKmmQmGKGHUdgcE71azgo9jGId0hoYBfmdYYQBRskbr725FhplglFq\
	2+5gZDyusYCR4fqaYNTp9xgYjCJ9AwTVJ9+lOY7BaiQgUppnp6P+FBK8Xbf484RUGAWQEU\
	oElPYyIg6aZHSUCSMVKjoYFXB5zLScBT2MAuB1DaMEEMsAo06gyAmjiXR5TDaJRg4jB2A/\
	8APNzoeiUUZEAHeQOHnvgdvBbRhg5LQfVi2MEqAxwSiKcEwwQg+jKK0DjNaDyyPK+Zg0Eh\
	iZQaGHUY5z7wVGuvqifYfKA6Nkft9h9D2kWMve8eA0MhApUdGnYhmei7drSxD9CD2MQtM0\
	RDaMQA+jaNkEI2XbqI4BwgilHAqMonJEeaWEUd7+osS20XoZYdShzpHbh/QfRl8FQfXJdz\
	IKjToiAvgxcJua4O3YDIQvwgYXXAejACJGGEUuj73ASAXakGEUPYcZMIptq/4Nj0FTNFku\
	1NBgpIHTKGGkqy92LPo6JwhGO4ALGKHKACIPOE1NkI3l4K38ig+c8N2yLBipgFlPlrOxe3\
	NQMDJoUmCUGxTpOssBo+SxJLfpCKOvInEZoUYKIqV59gVgSc1zt18fQCQBo7C5loSRGJbl\
	bDu9nC6PBWGUmC4QnUNe9RtGqeX0g2hhlLU/5fdP1pnaZ7TdWSCoPuV2RqUyREQA+4DPqw\
	ly6X7k8s40jIQCCR2MlDlAXbk8xvJ0MArTQQsjQW8wEvQBRpBKNMEo1imupo8IRuqxqA9u\
	qYzVSK2PFEaJ+UAFXR6vQ3INI9bIQaRERZ/Ab6ZFcrdd59+YWhjF5w1NnstjeBW6gZF60/\
	YCI01Zk/oFo+SxxB7GMsEofY7ls5xN7i+oM16HHw099TZGqZGDSNEdwDlqgrf7DmTjgBKZ\
	6GDU7vfJdHnsFkZqFAQUglEMYnQBozZw/Kxhw6gDUDI0VsZqqX0Y6ssBo7SC3zfV75V3Hw\
	OFkUcwWjZqlQJESlT08ViGlHjbrvPhEY2gGWAUAKZUlrOo6cOAUaxo4piHAKNkhDBuMFLX\
	u4RRmYzVUvnp3+ICYDhesB1UChApugS4Uk1wd9wIbisBI5EJI3W4vpSWsxA03YK8WMTVGU\
	b+9ijl/Ly+uTwmYSQoB4yigyEBo+Rqn+AzATDqMKz/FYDq027VHO9wVRoQzZ9yYXiRPhrL\
	8Fp+X5FTVWCkQEQDo4lxeTTAqG8uj1kw0q2PGkaphzh+otblsRCMFsH5Tnqfo1FpQBRJ8p\
	8kJji6910L0kvBKAkcM4xG7fJogpHTGUbRdhSDkbJpYiGxjAEShhu0Sxh13LZT/81EwEgo\
	ed3uI/HIdg+jbyE5YEFklotMREWtVbzt1wNCD6PYsH4PLo8mGMWG8DUwSi5rYaQCSwOjqE\
	wCRmp0VQRGma+CKMupB5x0maS6gNF4uDySyFP3kVhHWR82jLK8qZPbm2H0ZYDq026mDCoV\
	iOZfF3VafxnJDjXPvedqBQiOAUYhWPQwars85rScTXoZRc2pbmCUjJ4SMIpJByMRZWXCSK\
	ljcJazuv0ZNHIYaY4/E0bJPHUfpjo1MFJ3lwtGhn2a9pHarhCMbgNxMSVSqUCkaAX4eOwm\
	XlvE23mzMsu6A4z6YTmLBkbCad+8WTAKmlMT4fKYFzomrUcYdTv7Ovc+nF5g9AUpkcb/ZE\
	ag0oFIiYo+DexXL7a79XKiyYshjBQAxWDUL8tZiR5GCmy0MFJG6Ebr8jhAGBUBVBlhlDq+\
	TjBKro8ljFzgiyCoPv0myqLSgUjRXuAMILrYcmUP7v03+WBQR9AUyKRgNDYujwYYRXOM1D\
	JFYcS6hlFbiXXtu25ZMCoKivQ+SmA5ex5SlGLukKpSgkiJij6BbykbXWx3668CyCRgFL2J\
	7+hhVBaXx0wY0YaRIJXfGUYYYBRGB51gpBxDWWCU2rY4jIq7PBaFUVL9hpEumlPTnMz9Jc\
	qfCYLaMzbrDnxkKiWIFG0DPqMmyAO78XbeTNT/k4RR0GQTQWez0eXRCKMEaAYBIzDASI1K\
	smAEehgF0VfXMEoAcZgwMpbtAIqBwchQvggoBg2jWB15YMR9jNAONkulBZESFX2ERFTUuu\
	NSYiNjWhhVOsMIeoNRFOGYYIQeRlFatzBKwox4OcYQRnmbaLr9DARGZlAUglFGncO3nBWf\
	g9H6DplUWhApikdFEuTyzvanh0KIZMEoHNIfmeWsWscAYYRSDgVG6jFMDIw0cBoljHT1xY\
	5FX+cQ7UNc4HMgqD3zhvRxjlilBpESFf0b0IwyJLRu/3m6fyjWN6TAKK/lrAqY9eTyGJMG\
	RsE118rCSL8/tXw5YPR9JPdSUpUaRKGkfwG/EEtb2om3/QaoVIl1XgunDZskjErj8miCkT\
	oNYPAwktB+KGL39pjDKLWcfnDXIYzOAKg983rKqNKDKIyKpORDqFER0LrtYsDRwChshgk9\
	jIQCiQyXRzOMEh3VOhhFo18mGLXTy2k5C9rELgFTpGzPMEqBIkgrlZcRqfUBwug24ALDD1\
	wKlR5Eiu6SktPVBHlgN+69V2OGUbUDjOKvhPTVclaNarQwCtNBCyNBbzASpG7Y7o3VEioS\
	AY0KRmr/WGlhlD7HAbk8noYs9EsMXWMBooXXt0fQpGRZzXO3XBQsdYBRCKR1ZznbBo6fVR\
	RGEi0RBgWj2GY9wCg2Wpg4hjGFUZcvyR4A54sgqD3rN5RVYwEiRduAT6k3jlxbxL3nymAE\
	LASDBkZhh7UQ9GQ5G8JjWC6PsfQRwMiL2YjHNQgYJR/KvsMofIgHBCN1vQcYpdU1jM5Csj\
	edXy6NDYiUqOhfgX3q7+ZuuQjpuQFcqm046GA0KS6PQtCLy2N+y9kMEKllO6VlpXcoN1Yw\
	6i5qSa330eXxkwC1v7hWU195NDYgUrQb+Biyff1lYxn39l+AU1Vg1O6U1sNIgchAXR4HCC\
	P0MJJhXrS9Hkb+xUMp5+dFD74k8bAaNG4wAvQwSq72KRIaHYx+BpRv0pBGYwUiJSr6v8AD\
	Koxad/wC2VhOwyjoIxJhtGJyeewWRonRMz2M6ACjBLSSMAK0MAr/SrJhFG1HDEYdXR69Ap\
	NwhwCjjtt26r/JMccotpqsI7kPqckfCowSh23exydAUHt2uaMhGDMQKVoC3g8Qwcht0rrl\
	ggA0Ghg5lc4wiv6ZYDRqy1m1jAojJ3ETJmCkAq0IjPJEQ6oGDCPr8pjePgNGtwLn6g+sfB\
	o7ELWjIvFpwP9GbgAj9+5fI5fuDyCSASOEHkb9spyNwWYMXR4jGHm5WmYdNfYw0oBmGC6P\
	hWEU2+cnkJ06+MqjsQORLwHIBoh3REkSpJQ0N5+ndFhX9DAKO5mH4fIYTBsYjMujCUbx/K\
	5g5F9Qf6kIjHqFTo561xWM1N3lf0l2N9I3P6s9e+Rfk86lsQTRwut/RnDRzwbx6yhDgrtj\
	M94DtytD9mFko4FRaVweDTCKmntZMKIDjOgSRlmduB1UBEZd1lsaGKWOrxOMkusdYNTdqy\
	CfBg5kH2y5NJYgUiSBtyR/8Ob15/gQiaATREjRO2gJGOV1eewWRmEENE6Ws176CbcwSmyf\
	rF+3jxSMMiIldZvuYdQE8SmA2kmbGBeNLYj8qAiAnwPnqj+Gt28b7tbLoo7rNoyq2TBSRs\
	7G13I2rCPZxAseqKhuE4zwYSQ97QM+ljBKbdsdjNoqNYzOkpJtHaO3kmlsQQQxGL0NaKkX\
	v3nDueA20jByAhghsmFUdstZMMBIzQvgpoUR6GGUeAjHCUbGsh1AkRNGg3V51KkwjCS+ZQ\
	61k642VVpKjTWIIkm5GTjNXwketsYBmpt/6N9gKoxEsFypEj3oRpfHHJazYIBRAjQmGMX6\
	iHQwQg+jKK0DjLp2eVQGXMYFRnmbaNG2g4ZRRiSlhZEOqNl1JmB0DlCeT3MU0NiDKIqKpD\
	wVeMBf8X+c1m0XI5d3tR90HYzGxuVxSDAKr18O0kwGjBLrZYRRhzoVGH0EBFPPGa9oCCYA\
	RIr2IOW726sCpEfz2m9Bpab0/zh6GA3N5bEXGKlAGyCMCsBh/GGkgdMoYaSrL3Ys+jqlFB\
	dKyRXpDcdDEwGihTdcGC5+DikVCzqBu+NG3HuvacMommMktDBquzwaYBTOQTLBSDg5YKQ0\
	17QwCqGgGSXLBSOUst3ASBaDw3qCEe310RurxcoE0dBVjKMmAkSKWsAbk/9NN685G9xWHE\
	bRO2hZMHLIhFHYXBuZ5Ww7vb8uj4FywkGaypo0hLIDs5wtlZdRVPZyJOczxpoYEClR0c+A\
	c2Jh9Mpemjee54NCByOEAUZhn5DQw0gokBiEy2MsTwejMN0/z74Zq6kaJoz6HHGtI5fH9w\
	HU//JKxlUTAyKIweiNwAEVRq1bLsDbv0MPI6fqw8i6PFoYjZ/L4zXAjxhzTRSIFN1N9HZ+\
	OB9G0rjq/xNNVtTBSH3lY5QujyYYiTg0CsGomz4jVeMGo9hm/YZRCIoBwUhd7wyjU5GC+l\
	+NbzQEEwgiJSr6f4D/ge/gDvF23krrzl/50AlBoINRbpdHA4wCwBhhJHLACLJhFEkPo1g/\
	UtHPFJme23GCkUyujhGMUqN1hvoQ1yD5LhOgiQORoibwhmgtuEOa15yNbBwIoFPtAKM2WC\
	bWchZIuzxm3BYWRop0MEqu9ikS0sPoVIpd5dJqIkGU6Lj+WpQhJXJtiebV/6FAp9qGSBaM\
	xKgtZ5NlksBQAKODEaCFUfhXokRTfjnjHW5hpAGFjK0PweXx18B3QVB/7q8Zd00kiCAGo7\
	cA+6IMKWltvQx322/iMKqozTGDy6PIYTkb/TPBqOQujwKifiz6BKMiGgKMOm47Hpaz76GL\
	y1tWTSyIFG0D3hpLkZLGFV/2PZmTMHLiQCqty6MJRsnlFIySwNLACGKRVM8wKvq4DBhGE2\
	A5eymSH/nR0NhOpo5pokGkREVnAhereXJ5F41rzo71D8VgNDSXRwOMks0wZ8iWs4l+oqHD\
	KO++stIzypXCy6jTPpL7a6e9C6D+3MszDn68NNEgUiSB1wJramLr5h/j7doS6yNKwSgEjA\
	lG4ZC/CUahy2MmjBSYmCxn0cBIOO2bNwtGPokyYEQaRqKqvYjGq5sjzVrOJrbPs480jM5H\
	clHGEY+lJh5ESlR0C+HcolBSsnbpGX4TrVLrCKOo/6i0lrPoYaSM0OV1eRROtVifz6hh1G\
	W9pYFR6vi0MJJI/gkE9edNTjQE6wBEEIPRvwGxD4DLxftpbvp6AJ9a9IDrYNQ3y9koCjLB\
	CD2MwghIDMHl0akRwS+hdQmj1LbdwaitxHo+l8ev4s+knjitCxApagKvAmJfDmxuPh93x+\
	Y2jJxa9IALLYwmxOXRCKPgvMLtNVp3MBq9y2MTxLsB6s+/zHCQ46t1AyIlKroS+Eg812+i\
	Sa8Vg5Fw2v04WsvZsrg89gIj0MMobIZC+gGJrloBjROMjGVHAaNo/TTgTtN/DOMukfdrnk\
	JMxgVY/NSJAHXgCuAP1bzq8U+h/qSTwW0hvRa4TfCaSM8Nll2QHngt8FykbPnLbgtkmOf6\
	5T3XTwuXcf0vp0bpXrCNv50MP+8sXYT0/DQZlpF+3dFf5R+yXRbZLoMEwm0k0ZMhvfbfIF\
	1GaWG5IH1tPzRX2hdI6O8V7Z1hul006YVurQL1Fnpmhboos7dNXofUOm3wKN07/rqI1uPn\
	nVnnHoR8GLC7/vxfZRxY+ZSXL+smIkpoDXgFvn9RpNYtP6W19ddQqaYio5jL41hbzqp1BJ\
	FRFC3FIyNRmYpftSKRUYGopJSRUd7Oa+068chIgtzXxLvnAO7WJbztK8hlt0hk9H4ku3Oc\
	xdhq3UVEEEVFAO8D3qvmiekFZp77MUR9IYhUDJGR12pHQMnIKIyKgvxUZBQtS31kFEQ7Qo\
	121Mgo3FaNkFKRUTviSUdG4TIZkZGfLpd3pC9gr5GRLioyVmDQOERGgHv3Et6di8g1N5Un\
	FmpUfmeBylHTSmqqzluARwHN+gt+2enoSycbEWVI6S/6ZyDmrSlXF1n7+SfjM6wr1XRklN\
	ty1iEVGUXLSoRURpdHIYLRs4R6jYxMI3H9iIz6WLanyMiVtDbtwr15rxZCAHKxSeva3TR/\
	s1f5oGWqzjcjaeY+/jHVugSRohbwcmBVTXTvu5bmDd+HSi0YJQuhooFRaVweM2AksmAkyI\
	KRqM4YYFJSGBVpuuWotysYSUnrml14D6zqt0nIu+8Azev2KvuJ6vwJwcdDxzEaKqJ12TQL\
	pTTRXkf0XbRAlSozf/lRnI3HgdtUmmh+8yvVTAv+ebvuxbvnFuS+XUi3iZieQxx5LM6RD2\
	430cJOa7WZFmt+aZpp0kPKdod2upkWdmDLaD3WTIv91TXTwjog1kzzXOTSdn9Z2+wpaTOt\
	SNMtR71Fmmnulr24WxcL7MhX5fgNVB8yH662QD4auLH+wksL11UW5ebLegYRRDASwPeAk9\
	Q856BjmHnex/xIpwOM3Nuvpfmzr+Hdu0W7H7GwkerjTqTyyMe1QWCEUXtUTAsjpQ+nKxhJ\
	FUC06zLASC7vAjd4O2Y9wUgkVzvDSC41aV6xvVgEFsoR1P7kCJyZCsBHQb4VYD2AaL03zU\
	JJ/ImOsZ5Zb9+9rF1yWtDkqikjaX7zSwQjaM2LvsHaWe83QghALu6heeG3aXzrM8iVZaU5\
	NEDLWaAfLo+iNtPh6k1oM00mVzs309zb9nUHIQBP4t6xhJTcB7wfxFhDqIjWPYiUjuudwC\
	uT+a0tF9Pa/EM9jJwqrYvPpnnx2bn3523fSuObpyEX9zI2Lo+12QhK/e6DyUobNxjJ5Sbe\
	rhV9Zk559x1ArnnvcHetFW/bjbHWPYggBqMfAv+ezF+77Ey83Xf4D6gCI/euzTR+elbh/c\
	mlfTS+/0Vks9Geb6RGNwkY9c/lsUsYOQ6iNqecgO6s9A+o8XmfQBh59y3lrNAsMVfb07x4\
	+1e8XWvUX3hJz/WNiyyIAikwehuJIX3cJms/+Re/PygYkhdOlca5pyv9LMUk9+6ideE57Z\
	G0Qi6PBhiJJGh0MKIDjBLQCmE0NZ84Ad1ZrR8Y6dK8HQdyVmaQI3AOmXqJOGhKelt7h9o4\
	yYIorTXgRcBeNdHbv421iz8WzSlyb9+Ed/dNPe3I3XId7h03pWGk9AtlWc7iDNFytjIF1X\
	r8BIYNoyIaMIySL8nK/Q1kQz9fKK+cI2Z+IlfdHzsbp9jwudt7qmvcZEGkSImK7sDvvI6p\
	dccvaW76JlSqNK/4QV/22br0XDAaqyl9PSkYVfyHQfRoOSvRwyi5LEBMH5Q+gWHCqNtO4D\
	wH0SOMvD355gyZJGara87BU88T01Xm3nldT3WNoyyIElJgdA7w8WR+48qv4N51Fe4NP+/L\
	/uTeXbi3XosZRsoomQ5G0exuRw+jGJAEvbg8iup0OiqC8sKoHx3rHbYPYSR7AZEA58iZN3\
	iLzSUxXelcfgJlQaRRor8obv4iJWvnfQC5vC+5Wddyr70ksgxBAVAZXR7F9MH6k5gEGHVZ\
	r0TgLTYKbByXc+TsJrnqnimmHGbffHXX9YyzLIiy1QReDOxSE+W+vfrSXcrbvhX2PaBEQG\
	3IdO/yaIBRGAEZYeRkwsgYFcG6hZFcc6HpFdiwLTFbbTqHzzxDzFSZe8e1XdUxCbIgMkiJ\
	iu4C/hrF1VGu9f8dRHfLdWhdHk0wilwes2BENoxEd5azYmaj+UTWI4yWu4yGBDhHzb3R27\
	u2U8xpXi5eR7IgypACowuBN0cZPY6O6OTeuVnv8ij8JlmZLGdFdQYxNac9D8AMo7xFTRkl\
	hZE80OpcSCPniNmr5ErzDFGrMPu/x/9rrb3IgqiDIhhJPgF8GYBW/0Hk3XcHtFp6GA3Lcj\
	bWYa2DEW0YzRwST09K+3AXhFHOwqOGkVwtDiIxW206h04/Q9SrzL19U+HtJ00WRDmkwOhk\
	4Erc7voDMiU9vB13R4AovcujU0XUNcP5sXPSpRWAUZGoZJQwMvgNGSXAOWLuDd7+xgNiNv\
	39uPUoC6JiWkXyfCTdxeId5O28J9E/5OhhpLyjpoVRABGpAiblZUQPMAo6y2c2+u/dZWkQ\
	MDLAYVQwks1iIHKOmL1UrjQ/K6oVZv/hykLbTqosiHJq4e/9qEju3H83G2ZehZPRLOlScv\
	eO7lweTTASTg4YiQ4wCuFjgNHsoTlOTJc2GBj1/CpI0f1BoT5DMV9bFhvqT6NeYe6dtkkW\
	yoKogBb+/kJwPVhtnMUh8//S7/q93feT7fKYAaMRWc6K2qzv791JQ4JRX95LK1rWzVlJRe\
	AcOvN8udxcEXXbJFNlQVRQGz64CaaqsNp8O4fMn9vPuuXSHkZvOSswwkhjLQtBVOTkeLDG\
	CUYFoiWZs8/QOWLuK95S88ei5jD3tqs6b7COZEHUhTZ8+FofRq73HDbM9PbmqyK5f7ffCR\
	xGH1oYVdsg0MIoPm9Ia6wGtKObJIwcM4zUv7G39KuIucNznqQubcxhlMO9VGyc3ipXW68Q\
	UxXm3jWRX43uSRZEXWrDR66Deg2xcf6xzNV3dd4ih1oN//NCTjUYAWtPVkzBKOywHrXLY+\
	TiOKd/KTavxhhGopINIjFdbYr5qScyVWH+/evvhdY8siDqQWJmCrnaWBEHz/0B07UezWh8\
	yUaD0P1RxD5b5OhhlNPl0Qgj0QFGQQSVx3JWzB4GyY8yak/SlD6mMKpVDAUAIRCHzLxcrr\
	a2iamMcutcFkQ9aOFdlyOqFeRKYzsLM49jqtrzux9ybSUCURxGlQ4wUoAzMstZgTN/VK6m\
	ysBGvUYAIzFj7h9zDp/9qjzQ/LqoVZh/j22SmWRB1KMW3nclVBxotjZz0OwzqDi9zXb03A\
	AeGTASIhNG7flHcRj1z3I2WUaBUWXKj4zyaJjvpWVW0n29AGJOHwWKg6dvlo3WS8VUhflT\
	1+8LrXlkQdQHbfjQNVCrwlrzQjbOvQTHKfTWQkxuK+ikDptjGhiFH3WMZljHYZTfclZ0aT\
	nbjoB0MBL1g/IN6cPwYVREOesVB6XdCMRsbVnMVv+IWoX5D/6m6J7XnSyI+qQNH7rGH0lr\
	tL7JofOnUOny0noSEQ7fO3EgpWDkBK98hEP+Xbg8hh3e/XZ5FLOH5+svguHCqPv/Ioz1io\
	U6qP0/NccTB9WfLBvuPlGzj1ge2avUR2348LVQr0Gj9Rlx2IZTqHYRGQWwicEoAlJFD6Ow\
	X6dnl0cDjJLNMJPLo7ounKC/KOctVlYY5enLEuAcGbgROALn8Lm/k2vuFaJWYf5UO0qWRx\
	ZEfdaGD12DmJ5CNpqfFkccdDLVgiMllZoSASVgpBqn6WAUDvmbYBS6PGbCyMmGUfgvj+Vs\
	ZQoxf2T+cx9jGDnHLPgQOnL+E3KldaaYrtqh+gKyIBqAFv75an9ov9H6rDh648nUKrlve2\
	d6oSOMRBghZcFIAdAoLWdFbc63DMmrMYWRqFepPOKwfzAnD7YAAAzZSURBVJee9yYxXbWd\
	0wVlQTQgLZx6FWK2jlxtfkYcc+hrmKrmu+3nNhB9TTYaIasijDBy9DDqm+UsehgpzbFOLo\
	9i5hBE8rtoWRpPGH1ebKi/0Tlslvn3WwgVlQXRALXw7it8GK00Pi+OOeRvma51vO3FwuFQ\
	qbZh5NSIRre0MKoGUY7QwyiyBRmty6OYOyJ/5zWYYZS3qCljMDC6AMkpolZh7k2XF6jMKp\
	QF0YC18M7LELNTyNXGF8XRh7yQ6ZpxnpGYnkPMLPjwScBIOO1+nBSMwuabModoZC6PJhg5\
	FZyFo4nmKuVRr++lFai3BxhdAbwA/0MLVl3KgmgIWnjHZYiZOnK18W3x4EOfxeyU1sBGVi\
	Ry/7Z234wGRn6TLQROOISvwEhpkmW6PJpgFPkUDcBytlLD2XB0sYs3iJdkDeldwGgzcBKw\
	CDDzsgsLVGClyoJoSFp4+6+CZtraj8WDNj6ZuXr6f9C6w8p334y348Z2R7Rw9DCKTNMMMH\
	IqnWE0CsvZ6jRi4UF9mOXcBxjpiuYvexeSpyPZCRZCvcqCaIha+Mdf+kP7q82fi6MPeSJz\
	9TU1X8zWkWtLrPzgXbRuOj8AS60zjKLheD2M1BG0wVjOpucbZbk8iql5xNxhxUKQIdmHZK\
	a3dS/wFOAesBDqh4TMeTNE/QdWPWvxX5+EPLCGmKo+VO7cfzVLqxsAxCMfHHuTu/q7T6P+\
	xyf7D7LbRHotkK7/GojXRHouuE3//TSv5f+TEimDZTco77l+Wen6NiNBGp4LBHmeC9Lz4S\
	CDstILtvNAegjpARIpgzqk9PM8F5DK9l60LpVlHzwS8Jfl0v3I1b3t6CqPdEWF/h7W1qrd\
	3pCkP6x7gT8HtgDMvNxCKEu5+WJBNBotfugJyNUmYqp6qNy1fzOOOFz8Tnryn3P48Uw/9e\
	2ImYPaMHKbAQAMMPJaSGQGjHxgmWHkKkBKw0jKoIvLCCMFOkkYIYO8AEb77kE2D4wLjCyE\
	CiovX2zTbERaeMdliKkqcmnlAWqV3xJHHfwNXTlv5y2sfOcfcHdshkotMceoEm+mqW/s98\
	XlMdFMEwmXR6PlbNiHlGymKc21cA7ThqOLDevD0JppiTf2LYQGKBsRjVj73/oomK3DbB0x\
	V/8n4IPo/oMQDrUTXsjUCS8Cz2tHRmEEJD19ZOS5gGeOjDy3HR1pIyMv+qeNjJTopnhkFO\
	S7Tbx9W4P0AhpeZHQ7gmdgIVRYtmk2Zlr81Inh4rOArwEH68pVjvw96n/2JsTMxmIw8lpt\
	uOhgFALJBKMAMEYYqXDRwShozplgJJvLyH33mvpl9DKV7S+MrgeeDmwTwkKoqCyIxlAKjB\
	4GfAf4fV05MTXL1JNOoXrc49MwUsGihVEbLHoYKcDRwEgqEZIWRmH/kQFGMuoj0sBodR9y\
	aXvv/UVIc59P3jr8tEuBZwP7AGZfYSFUVBZEYyoFRvPAl/Bn7WpVfciTmPqjV0JtJg0jN4\
	iATDAKR9gMMIqA0y2MklFSCkZBMywJo+X7kSt7ygCjbyN4GXAALIS6lQXRGEuBkQDegt9v\
	pP22s6gvMPX4V1D57SfqYeTFgZSCkef6N4sJRkpTTA8jHzp9hdG+u/szktY9jD4MvBP8KV\
	QWQt3LgmjMpcAI4HHA14GHmspXHvwYph7/SsT0Bj2MFCANAkYC6XeidwOjaH6RjI7R23On\
	fyzDhVEDwauBs8KE2b+xEOpFFkQTokRT7XTgZaayYmqG2qP+iurxT/UTisIo7Ncxwig+vy\
	gFozCiMcEoOVqWhJH0fEJID7m2hNx/T3BiQ4HRvcCLgF8hLID6JQuiCVIiOvqfwKcBvTu9\
	EIj5w5k64UVUjnmMHkYhYEwwCof8TTDyPD/fCKNgqN4EoxBI+NMGUjAK8uTiNuTqvui8cq\
	s4jC4AXgrcDzD7SguhfsmCaAKlAOkY4AzgOdqCwW/lHHE8Uyf8Nc5Bx2hhJNX+Ix2M1KF7\
	HYxkGEF1CaMwAjLByGvi7b693ZfUfxh5wAcEfABwwUKo37IgmlAloqOXAJ8E0h8SU36vyr\
	GPpfbIkxDzhxtg1GqDRQcjZeRMC6MAMmYYuUGQUxxGcvl+5IEHtOfVUdkwuht4OXBRWNRC\
	qP+yIJpwKUA6DPg48L9iBWK/lwQhqDz4sdSOfxpi4Sg9jNwWah/RUGEUzr5Owshr4D2wBf\
	O5dZAeRl9C8EZgP8CcBdDAZEG0DpSIjp6CHx09IkpJwshPpHLUI6g+9E9xDn2YMmqmvLGf\
	BaOg/8gMIy8YgTPBKAGaHDDydt/qT01Q1R2MtgOvBfn9MN1CaLCyIFpHUoBUBd4AvAfYCB\
	hgFLyrunAU1d96As4xJyCcWto+JOyM1sIoGPI3wcgLZlh3C6NoWeI9cCu4Meum9knkk4vg\
	dODdBLOk5171s7zbWvUgC6J1pkR0tBF/Qt7rgeksGAFQqVE56vepHP1oxCEPIfI8UppkRh\
	iF76iZYBQAxQijCFgGGHktvJ2b/fLaVzE63peXAa8DNoXbWwgNTxZE61QJIB2LD6RXIYQy\
	M1sDo3B9ag7nqEfiHPZwnIOP9ctG76V5ZhhFc5AMMJKeP+nRCCMZj5Dw5yPJPVt987ToAD\
	Unrb83bwPei/8CsQSY+1sLoGHLgmidKwGk44B/RIhXAdN+khlGfiJQreMcfBzOIb/tm97P\
	bIxHPkZjNdkzjOTaInL/3cjGsv7YUmlR4nb84fgzgUaYaCE0GlkQWQEpIB2FEK8DTgZ5uJ\
	phhJGq6jTOhgch5g7z/00fhJiaQ28fkgGjKOJRYNRa89++X9sPK3v9d810x2A6NtiKEB8H\
	PkvwoipYAI1aFkRWMcWAJMQ08BKQrwWe2E7WbNjpZxcOoj4PtTlEfRaqdYRTU8z4UaKeFt\
	JtgNsArwmtBrRWkM0Vv5PcuI/MtKuAjwL/CbTCk7AAKocsiKy0WjztycFS9Lv/AfAK/FdH\
	HtQVjDqVNWxf6JaKl90HfB3BF4HYp1XnXm2H48skCyKrjlo8LdZsq+B7Mj9fCJ4HPChWeP\
	QwWkFwAfAf+KZxq2G9Fj7llQWRVW4lgAQCIeAxwDPxbVKfANRHAKO7gR8B3wd+gg+jSHOv\
	sQAquyyIrLrS4ultKCm/eB3fE+mPETwGeCy+nW32h+yLwWg/cBPwq+DfpQQfMFQ191oLn3\
	GSBZFVX7R0+onpRP9WmMKH0cOBBwNPwOGloEY40v8eiZAgPETFRVQbeM2p78q1+ibgPuAW\
	4GZgu+4Ws+AZb1kQWQ1MS2ekmnIIh7dRER8RjkT4n0pDVF1EtQW1Bk61iaitIqrLUFv7dn\
	PXoS/wlubwljdE1cz/nYXOpMmCyGooWjrjxPCT9t+jIp6TAlGtBdUQRAcQ1RWorbWorBwL\
	bK88cWnUp2A1QNkvvVoNTx4CeFIqXYA6g7udRhV4NYB3ud5o0mp9yYLIqh96BHBIdhEvuf\
	wa4Qh7/1kBFkRW/dH/0KaqYXm6ZX8c/rwlKysLIqu+6PH5i8aaaq9ACLxNh/b7eKzGTBZE\
	Vl1r8VMnhkHPE7LKieS36EX09wXUavODODar8ZIFkVVv8lgAfi+VbjKuj2sOOKnvx2Q1dr\
	IgsupVjyF5Hwn1bzIaUtcdgBfhCLybjxnU8VmNgSyIrHrVCbE1o3+QVCDkqel/wXTdNs/W\
	uSyIrHrVCeasPJPZnGn8F2ut1rEsiKx6lQlEmwi+nhqX/CrJzmucZxXzGbGaNFkQWXWlxU\
	+eGAY8v2so8g7gSk0/0enAZ+JNNZ5BpYbc/oeDOVir0suCyKoXHQPMatJ/Cd6PEOISTd5O\
	4E3AdUAYCB0r5heOG9AxWo2BLIisetHDDenvDKKdi2LRkJ+2HU+sAi8G/E90+DD6b4M6SK\
	vyy4LIqhfpxty/L10uCuByCfF22R7pTi2CAMe5CXi9TyEHwLbL1rEsiKx6UfLdjDXg/wCI\
	ioRKcy9hE8zn0Y3ICpU/2e3bylRrXwa+4kNLHDGsg7YqnyyIrHpR/I17wXulxxaA6Rf9In\
	y14yLFyuqmcMH57/v9Tw75n8W+GcFSsc96WE2SLIisepGHEH7rSvAz4KMgmP0bxWlRoHZY\
	X5eqYWpqCXgxgq8P+FitSiwLIqtedGPw9xLg+XgyPm/ID3AuVrqJYl89dB69E6pVqE9fK1\
	dXN9mpROtX1VEfgNVY6xx8Z8bLpYcrHJh7VfwLq6LS3AlsBlzZmrpeVBuxfOfhW4d1rFYl\
	lo2IrLqXwAX5S+nhItPfGas/9/Kwn+gChHwT0qH6lNtHcqhW5VZu83wrq27UOu+x4ATfta\
	+4VJ9+w2gPyKqUsiCysrIauWzTzMrKauSyILKyshq5LIisrKxGLgsiKyurkcuCyMrKauSy\
	ILKyshq5LIisrKxGLgsiKyurkeu/ABHELVe8zEuIAAAAAElFTkSuQmCC\
	")
	-- normal.png
	R.duckloon[1].normal_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAAJEAAADNCAYAAAC4lJKvAAAgAElEQVR4nO2debwlR3WYv9\
	N3e+vMaEbLaB0JARISMouMRywCJIyNQTHEISEQb8EsxiRxTBwbnIBJMI632NgxJpFXYvDC\
	ajAy2CARVgkQi8SmXRqN0Db7vJm33O6ukz+qqru6b/d999533zLSO7/fTHdXV1dXV33vnF\
	NVp/uKqrIpm7ISida7Apty4ssmRJuyYtmEaFNWLJsQbcqKpbneFdiUXJJbn9OT1rzgM8R7\
	XldIa+1611pVaSCphEhE1roej3qJb3m23/2vwH8GzgLmAoB2AjPAHevZP1Wj+U1ztgEkAO\
	jVwNuALcBOjaZ8+uOAm4CL1rxyA8imOds4ch7wjuB4CWkDTAAfAk4Fvu1Pdvf/SeHi9smv\
	Wv0a1simJlpnCbTQ7wBe9aTAA0QzAG8EnggsAfdAAaCrgCJN6yCbEG0MuRL4seB4j0ZbYh\
	pbdgG/7NJuA1LaZ/g8rwU+Cjy0ZrWskU2I1lECLfTrpVO3Yv2h38aaM4Dv0pjFQfQi4I8A\
	wYK0rrIJ0frLC4DdpbSbaW5/CvAvgzQLETwWeA+27x4EvrIWlewnj0rH2nx5q9tT8MNlyf\
	6zaf4425bOieT/CI5d3ujC+/rWIdBCb604/WXgV0tp36V9xgTwQWCbS/sYYPreaA3kEQ9R\
	esOs27PzGyKAGpBoG8jjQM9GorOBM0G323S2gTQR3RYo6wSRY3ZXDgMHgEPAAUT2AvcCex\
	G5DzQ2t54dgGZvHJ1/T7l6P0ivFkJbZx4DXlxK/i7wa8D3BWkfgfUdmcEjEKL0+hksMJIp\
	FmAXyGUiuhvkEuAiMGdABCqAAYnsNer21ZdhsCAZ0MhC4c8RTLxl6SZBotuA74B8G7gRkS\
	+jPGzuPA8kQnUSk8SgrV+seIQHaWz9N6U0w/STTwXeEKQtANeuqLHGJI8IiCw4ocgZiD4f\
	oh/E/rXvBFAVRBwASg5IGSSaMPkEiDogjRzGDJQlMF23nQOdc/AJqDbBXATRRWBeChEYhU\
	juBrke4VMSLX2KePs24Id7HkbaXwZeXkyL9iDNqwn/LOCfsCCtu5ywEKVf3IIlQb3iOR/r\
	iL4UuBQNtUgutSBBroUw0NwBrZ0WoqgN0gRpQ9QEaSHSAv8vaoJZRM1RSA9Aug+ShyDdC2\
	bBlm84j8ich4leQWSQxsIRTSd7nktbp08ArUJiZ5cBzi9l3RCmDE5AiNIvnIQFR0HYBvpy\
	hFcC39+TeRiQNAJRCxLA3Bdhy3OheZJ1XSPsfY1CpKj3sTzE0STS2ALt8yBqAS0LX3oAje\
	+D+E7ofgfMQ2CaaDqxlR4RiKaLPlI0Bc0djyk/GXDNUA23inLCQJR+/hRyeMyTEX4BeBlE\
	HatBai4cGaQlOHa9BSmaciC1yEFy5QDiwMo0o1FbHwM0tiPN02Dq6VZrmSPo0l3I8dvQxV\
	tA47xSzS0ARbg6u6D36a4HHh6i+VZVNjxE6edOtTuqIPIC0DdC9JwiOBGjg+Qc5CqQ0qNw\
	7Esw80wLicGecxYPcbemZYsXD1N2h+I1KERbYfJyoqkrQRN08dvo8S+j8zejje3FerdOgc\
	Z01RN9FDaGKYMNDFH6mdPJNY++AOStqO62Iyc/glo5SLmtqgEpfgjmb4KpJ+XaxmileZPy\
	ufzmQb4ISGyyNJGpS5Hp3WAWMYu3o/NfQ5P91hdrn1nXPOs+Sx2KVMWHrGe8Svr/ziQzC8\
	JuRP8n8EwLAD4dO5ry28CU0AckcHmLIEmW5tpCsMfijyOYfiq0d1mTJk3nUHvnumn9H5qI\
	Twv9ImkFTnkblQlgAqSTO+fSgWgCpIEu3onp3oFqt+IBzD0R3z1P5H6i6B7kpC8N18ArlE\
	peNgpE6afPcnsKwlmI/haoHepmnTkgSFm+GhkFpKgFM8+C5vYSSM0ABPtPymlR20JUAM8e\
	q3SANkgHiSKQSZAJNJqB9Cjp4rfQ7t6snhE3pQ25/reJGr+O6hwiawrShoUoue4cQBHRCH\
	g9wtsR46aafaduAJAaMzB7OUSTRZC8JpJmAFKrBFIOTv6vXYLKl9EBmQCZsZorPUq6cBMa\
	30fTfBiJHgSRB4ka/wn0r/zMuGy9YaT2H0Y2HETJtY8h6PQLgXeLmB+wlaAIDGwMkNqnw/\
	SlFOaIemCpASmDrQxSYPKkVdrvgEyBdDDxA0RzbwCzByKxZjZqfJRIfg7V760FSBsKouRT\
	5+MgEMS8HvgtMJP2/sbXLu+8oUEypXw1MgpIUxdD57wAjDIoZfMWgtEIzFszMHN9QMLvu6\
	iQxQ/DwtXAogfpCJG8HuW9fp1Otlw/SDcMLRsGouSTj8N2vm5H9C+BF+adbVwdPBQepKCe\
	6w5SBLNPh+a2HIayeSv5PxIFwGTn+2glgmPCa93W7INjvwHJjR4kiORPEfl50OOIILPjB2\
	lDQJR88gJc5z4N9P2I7uqFYgwgSVooa3SQgraQKM8bzcLsZYGv401VYwjz1ippLa+VOliI\
	Ar8J7ysFQNGCpY/C/O/Z5xOBSL5DJD+G6q2rAdK6QhT/4xPwMIjwk2D+GGhngAwNkocmvG\
	aNQWrvgqkLLTjk62pFP6lo3qQKnB64gtGc11ghVBlITkule+DYm0Hv9SAdIpKXonrduEFa\
	t1eG4k9c7FbKRQR5O8q7XcsAYs+p6yj1VQq2GuTLySnO5xXS3DXaKJalyzyuX80Pk7QU8u\
	HX1lSgey/E+0EToAsmAQ22Gtt/ppsdq3bBxPk5dREBJsivXZuu7jqzBMT5cSFPDI1zYOuf\
	QfMKOzlr9CSM/iMir0YVnXt6/+deoay6Joo/8URcJ7QR/XPQV4jXKF5rAP00khT8nRqN1D\
	OSC65ZTY3UmIDp3YFPVNZIgYnz/k0UaCRKmimqcKwLQ/+yWWti55nc8fyfwdKf2+pbrfQm\
	lN+wGumL/Z97AFlzcxZ//BJcJ08B7wN9kQegEqRwVBYeb3SQOmfA5AVAg6Jv1LYOr7TtuQ\
	yQAKQCOFWjtSqgymbNO+Ju270W5t8OUeJAin4T1TeOA6QqXlZt7Sz+hye5tSyZQvkYoldk\
	5sbFdtm1TyWL4dHIdq6K7UR/TISqQbL1srycfCfMHy6quiw0HEj+Xv76GlHpOV9Y+QeyNb\
	ylB6B1KjRc6LNf8VfF+kpuWwgpcdXN8gfzW37hNir9oRT2S1sJnrf9PJBpmH8zNnBOf5lI\
	QPWNOveMsWikUFbFJ4qvebL3TSxAcEXm8wS+jXofx/sxkPstFT6Shv5O2UfqyV861iAPUV\
	BOP+nVVj0+EsYeL9zhfJXE/jNdIHX+jvOZtNdXUu06P8n7Oz5P6CtV+EGhz1Q43wViaO2G\
	6d8B7VjYjf4yIm+yPtIzlnvwoWTs5iy+5ilkPhB8HNErc5MS3is3SWM1bVVD/0J5JqiHCc\
	qpkQqzBiXT5ueQJs6zM9qZHxQuizgfiYrRmxuhSdWMds9CbnmJpF1Mo2Tikpvh2C840xZB\
	JK9B9Y9HNW1rMzqzWkKw70ZdWRwtle3DOmikLKban1tGI1WM2KCkkRSbZ+l7Tnss5RrJaw\
	njR2XBNtNcNk29Bgu1T3aNu85UaZ9ASxFoKbrQvASm32afw2qkdyHyvHFqpLFC1P37p9oO\
	Vn4HxL14Vx52hx2YH2th+L4cSDI6SNl1Pv8YQdJF6H4PSIIhe5JvTQhN4mALh/VdVANovE\
	nT0vC+AFL5XwVIrctg4pdBFdQ0MPp+RB47LpDG5lh3//5SbEvK61R5g5B5zuSetHOMcY5z\
	ySFWFfeuoDch/Zxtq1prne2e/L4u4w1q64mO7D4AzZPt0D8Io80kc5gBWmAkd6CNIQ9w83\
	mDbUh6lTNe+EsojVw7PwTmTui+DzAnodEHELkM1cWaJx5YxqKJlj76/U4zyLNAft+meg1U\
	nhys00i2KqrhJGI/jeRNYVDmIBqpkH9cGqk0YovvdxOOoUaKi/tlU5dpKz8pWaeRyg51OH\
	kZpFEydcQw+VpoXOo0kj4J1d8B0KMrm4xcsWO99JGn4Wg/E/iqiJ7mWtM5wJprB8LjsrOd\
	O8DVk5EUnW0p/gUO7WwX8o87OjKyyyHRpNV44VIITbsfBfuFsJJwjsk52+XV/fKKf6Xz3S\
	KfhHSTk7RB52DuZ4Aj2HASuQrVawZd+V8dx9pqgAYq7wVO00DDaKYd3JbwuF4jVTraBHk1\
	1DjepwrKHIdG6vvMvRpJszS3jfc5TZCSO8heIyX5cahFMic6cdrHa6TykofXRkuBtoqtjx\
	U65ZScb7ogMzD1X6zpNAqq70JkCyv4KP6KIFr6u924DvsV4DlFJxkGAgmGAEmoBsmbQpd3\
	HCCNvM7mQEoOBYCkuakiKcGTlACLgThYh7MgaRk2UwIpmz8KR3cV//yIrX0VmBSMno3qb6\
	GgRy7r/8w1MrI5W/qwe8dOuAz080AjNxvqyslNVV/TVp4TWta0aWDS/HWanc+D2oKyRzVt\
	K4lFau+0s9hRE2u6SnNHUmXOSnFJfQPc/PmagLaeWKTgnyZw9NWg+yBqKJE8DdWvLhcdOV\
	5zZsvqoPypNeIUtQQDaiSgx3EeVCOV7pdrpKpZ6lE0Upivrh36aKTkSK5piO1ffjbkD0xb\
	QcMEc0Nlc1fWSOV5pILTvRRMIZSnEmKgAZOvw84dpYLRP0RERjFrI0G09KGn4zryLcBFxZ\
	HlkCCVO3VkkIohJBqWNzJIKwwhMfOByUrIQSqN0LL5oxp4TGDetIuakskyzt/J4KuYW8oA\
	c/vE0HoaNC/1IF2G0ZeioId6vnbTV1bgE8lFwC/1dBAE1mqDgBT6Ulkd1wIk7Fu0anKQtF\
	sBUjijXTM5qUVI8vU2H5PkHemqmexAOxWG/V2Y/Bn7bGpA9W1Ac1htNDRESx98hofkD9y4\
	0XUk9DrOZNsVg1S3PDIISFWOdlC3viAFZY0EUrqAnbMJ4NBAI/n5pMJckgcnKR37kZvNq4\
	U5Jr800q1wusv/Asgap0PruZZ4k1yA6o+jih78gf7PGshQEC194Jm+Q/4FKs+zqeFoKTgO\
	IRkHSP3W2UYGKYA9kxJIK42O1C6a+UJ+6yciU/KRWFoBjluDM0sl3ynJzJmG8BTMYTBaCy\
	MHqkzc5MvARA4k80ZEomG00QjmTJqo/GbeYFAJTvm4orPWEqTaob8vpwDHGEFy80TqTVoG\
	UOArZRomDSCJKYDVMzNdmt2mDE553qjkdIcaKdoGnSvs3JHqBRjzklWBaPH9l/vOeyVwfu\
	/IqAxMdXqujdzl4wap6vrlVv4rQWJ8IBk76aia5tqIUON4ePy5QNuY0AwGIJkQpC7aEwUQ\
	aJ1KkEp5Jq5yf4QJqL4BNei+S/s/Y7FFBhC7PjSpylt6O2tUkLzjXXHNqCCNGkLSM6T3x+\
	TbHpB6WqkoWR08BB4kBw5p4DynrpP9eR9OEjrUZZBCoLx58yavrJXKo7cSSNHJ0LrUzWIn\
	zwR5UvZSwjIyEESLf3u5awz9KZAztbKzhwCJOpCoAYni8WqBVDViK5RHCaRlFmwBfOQjXg\
	ulvaYtgMxrrcwX0tABD32lcKmkqIGypZKCRiqN8sxSr2bqPB8XcwSa/Bxq0IeftNwDDqOJ\
	pAHyi4Qr1qOCVDH0Lxz3zDtVddZ6giRZWYOt/Ke55nGAZM42aQBImoPk85pQIwU+U88yRx\
	GcokZayvNnUwEVc0qtx4Oc7kH61wiTg/hGg0Mk8i9QzreNrj0AjB2knqF4ecHWn1sHkIaO\
	jiTXNIEpU+M0EkkOSLjOlmmnpXxrSkBpQtyNuf2elJtvSXng4dy8aUFbhe+xdbGOuAfJA7\
	aEdp7tNJHZgtGBHOxl184W/+Y5uPWmzyJcboPLXMuIFNbHXInFbbheJvX5yuWIlPKX17gq\
	77uG8drZdT6/BuWUJAvvELul4Y4bQIREjTzdv2IkEVlIiM8b+VeP8vW167/V4WOfmyRJWz\
	SaTVrNJmftbPBjzxd2nGRjtrNwksiFh1TFcfv1NnMMPfRLSGRAoo8DLwSQ079lW2DktTOV\
	i4DLixOINZpjUI3UZ3kkO670qcoaqaqc0NzQRyOtVZitA0xNj1mzGimYP8o0jMtbNnPB9M\
	D1Nxv+8u+FueMJcRyTJDFxHLP3gYS/+Ds4ftxqpYKPRDgZWXa6lyCahuaFXhs9D9i6nDbq\
	C9HiXz/XN8rrejuNrMFWC6R657wOpCgvJ3vufiB5UxiUOShIA0dHChag1IFRBikwbSi9yy\
	N+1FacrEyTmPf9o5CmCUmcECdxvk0SjhyN+eyNJjNnGs4tEU5QhjPebtv+PtQoGG2j5p8t\
	B9EAMdbSQnm5jVeWQF2rayxr1oov9tm8BuX/fWuJL92xxFKiXHRWkxddOsl0B7L4axXysr\
	VQjo2htj7Y8PHaEZKZl8h1pD2X3TOwPUPHa4d16BuvrXke/9Kkbz9pFo81SDPYe5qWNXF0\
	83woex6IOHjE0GgkhT4Ozc0tdzf4kcvdX7tR+3fgLb031RWfT5b2JfZIFTG8WOE9et8TkL\
	O+W0lIf4hsQz4f2JEBVGj7sFMl72uEg8dSXv9nB7hpT7dQ5Ds/cYx3vuoknnhOc9VByvOF\
	zxSABIVzqw4SQRsSAYn1ddR2qi1GrX/i/0CBPFC/i//Y/uJCgziOUdXCv9w6KIcOt9x9A2\
	BEUaP2Pr4Ps3t5n68NzV2Q7EHR54tIQ1X9e+g9UmvOFv7qCl/2K/JWDlW8+5eZAN/pNssv\
	vudgD0AA+44afvbqQxw6rvm1PWUzWCxS1hnB9YFp21hhtq6T1L0wqam9mR/mF0ZsMbkPFZ\
	q2fNQ21bFmK0n81v7z5iyJE+YXY+LuUrBcEkQBZGnhSwDBsL95oasfW1W1b8hjvU9kG7Gl\
	yFX1nV0N0jfu6XLD7Uu1RR88ZvjA9Qv0gDEqSKOGkGTPWuz0yonPUUHSOpC0BFLuK1mQAo\
	c6XBZxr2ZvmYqtP5SkbmuBSpM0AymOY47OOSgL78FZx1oL/lDR2ZbW+X4tDZQf7OcXLWfO\
	noWwVZGiC1EwPz7NmRtVbrq3VwOV5Zt74txcKCs3bVT5O9b8qB/Khx+PyDqf0rPY86qRDb\
	P1YBQ+FDGMaQvzuWOgYDK9aaOR5VHTQKIYtFW8zpm2LVNLJEma+UDhVrWVHR87nrJjq2Zu\
	oX0hxR8rKoFpc+aOSKFxKtCxcEXR5ahi9lxQ2ZfLOdZXZf2EIOGwow9Ic/PLr7mkWZv6cq\
	iBdECQws5aEUgOyB6QymUOClLJqbcPmG8KoKZ4/yj3x2NQ302Jvci0aEbKRCtmoetCurS8\
	tfdIYmc+/YuU3pEOXojMqhn6ThHQPAfiW8FwGVHUtCu8vVJpzhbee4Xf/eG8U0PzEnR2uH\
	Wdkgywbucd8OpyetMeedGRioXLb/1+Yvedn6RZFKSfK0qy48ec2S2YtDhOCluTJpy+w/tE\
	Xcor/2FoifbEI3WheaYzZ2YaY76vzqRV+0Q273bg4kJaX5DyhlxYqrefXqY6Nb5GYbhUvM\
	e6glTlaBfq2AekoKzeEBIHkPeJTAVIanKQMPhoyJc8a57U+0RxQpqmDiC7ffolC0x1/PJG\
	EAHQ8w6cW28rBMN1obEzh1vNpXWr+v0c62dn+5mZYTCQSqerpBmFf9kBBJUjMHILsFKQWM\
	XoyDqQlo1FCpxtb3oIwkV6QLIhJLsvXuTlz58niROSNCVNLEBJHPO4s5Z4xQ/Nk4XmZtEB\
	XtPUBLiZJdRNdkpju6u/AdVaiPr5RM/MHV7ve1AAKV/vgtBHaDeWp2jLZNDJoa8RzDv1HJ\
	fnfOp8pLK/Et6j5xb9fCTvxwRead2X2irqVpzLKn+pLfSRXDnhXJKJIErz+ygoEUKMfZfM\
	FvNTLzzG7otj/vHLE9y/v81JWxN2P9HwnKdC1Gjmk5a0nK/TzvuyZ6IR/Mcm7FxSC6KtYA\
	4D5pK6vqyGyFb8KcF+0Mlhu1WD9NRzJ/hTjtbdE4BLH9MOOjvs5BCYapCU8L6rAFKl4zzA\
	J//CUWKhLYcACchGdkbcaMpXS91ukuc3cOEuuHBXQv5yZJNsEtMo2Y/90bYaR1qZU138So\
	nL5kZvahSiHZAeBKKLAfSOc5HH3lPoyx6IFt9zpS/sKdmcWR+QCqMqABWefeEU33dOh5vv\
	rZ4ruvisNldePEWxs1YCkj81JpA0QmNDuldIH1JIImRCiXY0aJxuiGYHBSlTISOCFNm5mk\
	gK7Z2BVACFXiDwGoieGe/i9yOVbGhvSttoq6/SVoSdKA+W+7NXE9kang1sL5izTF0XQVIR\
	pKTKI4R3/vSp/Me/3MdX7y5+/ubJu9r83k+dTBSWNQpIFIf+9jjMWi7bZ+sPkjkiJHekJH\
	sUChP9AncDNIhOUpq7IhrnpESzedWKPV0Fkm+65T5CGoIkwfxOfk7Vze/4MrO1tkYOR9i9\
	BcBCc0YpT5DXANEWshEk0eNBB4DI3uPx+UMV9GneoMuAtH2qybtfu5Mv37XIzXsXMQpPPq\
	fFDzx2onfOZxSQ3LxNL0juuAek8tqWew4FUkj2piT3pJgD4V9ytZhDwuJBIfpGRLRDae4y\
	NHelyLSfiS6bwhJYSlb/3Nku1y3U+G6EJE2bX1PytTY3d0QJqAIwZWj8OZNrHJ83A8jllS\
	mnQSPAnAt8ttwedY71Y4p/HaWODtPwp3pBEoHd50+w+7ETtsLebFQ5z6sGkm8fC5IupOiS\
	ogsGnTOY/YZ0X5ppnb1H4a7DwiWnKtsnqhvnM/cK8zFcea7SOSB0DzTofq1BNKNEJxtkVp\
	FJRSYMMhkhkwaZUKQdmi8Pta9kFeQOgGw052a1JcqbwS/ahvCoko8IvThTVnCu3Y8aeC3m\
	TZrXeEYh6uSaSOTcjL9A6iB6fNbwmYwAUsGUVABR8G1GACnIXwUSCynpwwnmYIIeNZhjBt\
	L+mub+OeHwIjx0TNg+UZ03Tu2EaupcHC/mmGCOlTsvaMGWEp1kaD4upvnYpQrtWAUSWJPn\
	QJMEtJk3vYCayGqkDCSKQEXOD1IHUOZcex8p1GIO3OxXM1r2ITUFw5lVz1UH0Vm2gLyihA\
	kjgSS5JhoXSDXLI2ZfQnLbIuZA5Sx9X3niqcrJx+Ccil+t9/LcXUqq0KnnpVI0FtKHG6QP\
	NzBzEe2nLAwBkuZmpQCSBqYttseZf9QqrplJwwLkNZFpkX+ofSnXQiavCgDSAZ0H1Z1Vz1\
	UH0clZKeX5GX+8UpBcXrf+0aNJRgUp/sY8ac2ocBCZbsH5J/XP04xW/sXU5Lst2k9ZIhuF\
	DQOSCkQepDyvXbQ12KgAR7hpFtfKBDvRGLknMFiNpC1sfJPm9/HaTDpgjoPIaVVLHz1t4f\
	rnjDwl1CAUTVMdSAwAUtYoblsTHTkMSHrErAigtRSNBV0SpFO18g99QQLXwYn1faQRgKT2\
	B/o0yG9aNm/oD2VDfMmH+Nl5V750bV5p+z/8HVXPUvkHpcp2O7LP1M9wIPn+Hhgkd10pOr\
	JoOktOdRVIq/ZLJeOX6JTUfgBfoXflP8s1AEhpUAaumWLry6hS1Eg4c9bKzVbh90N8Wqt4\
	nC0h6ZaqZ6lr9sls8i7svDJI2TONAaQADjv0D8vKIesHkkw2iU5rYx5aPp5pvSSaVZqPT2\
	hdELsU/wx9QKr47HGvRsqdbVWx/lG5ezNfyWkcdVrKj8p8fQpwtYI6Vn8gtG6ycQZ8Zcg7\
	0YNUOV8UglQoyzrOy4FUgiIHKbimAJIvvwhS68mzxDcexRyIWW+RNsgWJdqqRDsMjdNSoq\
	0OCIGB47V7ZrW9eJCkCBIRakwxqE09KN4XciM0X044gw3FOaVs8VkrJz3qJhsbOE2Qz7kE\
	IIUPUAlSuaMdkCOBVFJ7Hhx/ULB01qS1dm/FPLhIes8i5lBS1JpjlYDyJrQer0SnqJ0Tmj\
	EWosJHSKv8vXGApG7B1oGELccO/V1Qm4Sg+OtKUtZAoY+kpX4NpN6LyHjxfkoIkm+VNQap\
	PO/kCy+nixKdPkF0RgcSxcwl6PEUugZiRVP7swfaVdKHEog1q05RehIqJdoBE5cpMuOuGX\
	t0pH/OOpDAzj47jUQjb/NsDilf+bcgNckiJf1cUTbBGBbrXqTMBkG9UmfO3L5ki39FkMKM\
	I4BU0CwrASm4b0+6K7sJ0Ukt2G4ftfxZZE0MyR1dkrvjDKZBJdomtC6A5tnBo1aEkOQguY\
	qNLcy2LJo722GbG8lNW+YTqQUrKl0PwVqdOie8GLZbln6hIMH+KoBUGYsUXDMQSDV/2RX3\
	rJrZVlWkGdG6sEPrgg7pwzHp/tTObs8rdHPgaAoyAdGMEG0XGjuxi6/iW12CZugDks9XE4\
	s1NpAkIXsRUqJgMrIFkvbObKPYZRDnS2agKTZwTV2hA5gz1+aLKBNgf0FHsw4lb4BVA6nc\
	kCOAVDmSq7p3UKYojZ0tGjubOQiQd1agwbIJuewva7CgtvytXMmbrQf2PiDRL4Sk1Isq2M\
	nDpiunEYDUCExbFJg4P0mpZA55BPj4fNUjVXeLqhIVDudH7qeYnEZSO24PTIlk+cJrwsIq\
	01xnFm/sjrMwW98p4v8S3AhTSvlLddDgOp+u4Ta89wb7dmRBgrIVhvvknzM96vweF5+tRi\
	l8Lyn7mVFD/q6bIfsgqf9npxkOVWmiuloUIKoGiQFBChtnSJACUzo0SGUoKkAK67pWIGkI\
	RR1IY/sIaQiSwb8QoPZLaORvkMRYkJzp8h8hJYzFFsAcrPKJemtgMx1WyDqtGqRghnS1QG\
	IFIFVBUUp/dHyE1IPk3hTxIGVwBSBpYjVS9uX/8BeSFFT2Dq6JXAik4u19H5Cy9goaonCf\
	wUDqqZtKseFWHSS77Q8SxePlQNowHyF1vpuPC3Kft7EfgPBvlOTvs2UgZRrMrQCo3juYJr\
	KVvs9WVFGRepCA7OW+EKTgfKER+vhN2nMNawMSdSBRAVLEmoHUk7+sEcM6RMW61Yp/n839\
	UxOAZMhMmAcpA8trMO6tWvaoMGcCcB+II9LN6lSBVO6EQUAqmJABQHLn+k8xGR4AABnLSU\
	RBVIFUWf6gIGkdSBVatQxS+BzrAlI0HEgqWK3jJg97QEqtGcO/i5ZC6mPkBdTsqSq2zpzd\
	a7dqO00i94w5REWQZPVAKnRmNUgr+ghpkO/R8RHSACQtayRDNlLzGsl/+s+Wf29V4XUe2e\
	22kfx8hAdJqkGSEkjZA60GSDJekEr5xvPtyDUEKbsu7JcBQcKD430kb9K8RnLDfPAg3V50\
	SXztq+V2e6G/uNEfpCBNszkk8jxlKKTUOGHDuPvWgxR2DoUO3lggkYOEywt9QFqrj5ASlB\
	eCpPT4SNlHSAVgD2oq30itg+gIuJfUnF9UC5IuB5J74BAKr0nCxgkbxuVZFqSsIcnybX6E\
	dKUayYPkYMqcbvkmCnLpoZ5ieiCaeuW1fvdWe6OU3KmuAEmWAylo3GFBYliQbMbVAKly6D\
	8wSBWdWfnBiRFBKuRfCUi5s50vdfgIBPPNqpGZu2OtfMOWkdhsHqQqHykAKYdjQJAKD0Oe\
	Lzg/MEjOPwKC560AKMtb2vaUPT6QCvmy5whAKjzLeoFkMpDUL7xmefhm3eU1ozMFBxFpnJ\
	sucTB59VsAyVZGsljfAUEqmLCiFnKVd5sBQAoc7bwjStcUAICxg1R4jryzN9ZHSCtEhXD+\
	KAMp+8jFsBDZJ/g6kHvnXhNlk4/5sWaAMRxImVSBVOpoWQlIpfKztFDjjQmkE+YjpBWSge\
	R8JDWuzuY4SPVHrOmP53dQte/fmASRRg5PAaRodJAK/s8aguTL6wEJ1hWknmcJfCpft57R\
	2TAghflqJASJzMe8wX7HWiov6VdiDHwNVUi7IA6MAkj+QetAkmVA6rO/HEg9Dw4Dg5TlL9\
	23J71c9oAgwZhAys8XQRpVI5VGh3WSgZTJDQDR7upvTlWWNv2qT/uG/AIA8SLeHyqCFPUH\
	iWgZkCpAGRSksv/UdwTWD6SaDunxm/Jzj7yPkFZIEaQv9svavyTlegBNcoiKIHlgakByty\
	iDxKqDVG7IEUCqdJzzvI/Mj5CWJAfpS/2yLVMKX7Tq07hRWq59xP8e10AgrTQ6cgUgjT06\
	kmz7yPwIaUlUbkP1QL8sy0H0IHAr6rQRQvYDbt4nGggk+6DrEmbrNeAoIFX5OwVYQnmkht\
	nyaYDGZXO1GWqvnn515hfZKezuPPYnk8hAEg9OD0gOpnB+qRYk//zLgSRrD1K/EZjblhed\
	H4HRkZ+qO+FlOU0EaknUeN7CkoEUFUHK5o28v2SL19JibS9I3uwQ5PEP7GUwkHr+AsMRzp\
	qBxHhBWkl0ZOWUQHDN8tGRitNE/WR5iOA6FMWkkHTtJVGoeRxIkTNjQbqv/NijI2tAOjGi\
	I8nruBYgFfKX7w/L/ET7TUBffyioZV85CNyIgnaPOYA8NAFIlEDy/pPbt89YAVK5EwYFqS\
	eN9QOpYsRWOA7r44fZlX7LKoBUNWItlBc+Zw9I1wI0nn6sXNmC9IVo+jWZJvsHABaP2pnr\
	yP9ycgBS5EDypi2bAghX/mFdoiODc/1Aqix/bCCFdQxAKj/HeoCUzSH5cxlIn6psx5IMoo\
	kAPgag3XlQ+oPkoQlBWi6obc3DbKUSpEdtmG12Xdgv0SLKZxhABoXoa8BDoGh3zpqvSpBk\
	ZSCtWZht0DkbOsyWHCRcXugD0lijI6+DaIEBZFCIDHANgC4ctvCEIIkHyZmzKCqCxDIguY\
	oPFR0JPPLDbKPgukFA8m0XlDkoSL0LttegEY1n9PeHghrVy/RrPu1HGh8G0IVD9sYhSNk/\
	D1JUBEmW0UiPkujInusKx4OA5B9gFUAq5I9A5RoGlEE1Eap8EjiKGnTpKIRayA/poz4gha\
	Zt3NGR/UDy0wiPqOjI8Dkq5p1WDtK30GhP+Y+xTgaGCFhStaM0nT8QmLEGIs0cnkFA8tGR\
	NSANHR1ZBQdB/mFAqhz6h2XVATBGkArPkXf2GkZHXoMKjWf2BuVXyUAQzbw2G+p/QBV0/m\
	BRE0UN++3kbA4pAAkpgSRFkCiDxHAgZRLsl0c7kINU/mseCqTgmgIAMFaQVhIdWQDJm0KX\
	d3CQPjKoFgprMahcAxzVNHHaqJWDRFQEKVvx97PbEkRHemAC0DajI/P6rhSkwrOEINF7r0\
	IdI4AHQPqGfpRlOIiUReB9AGbuISRy2ihqYD/zHxVHbOECbSGEJBjJrWd0ZC1IwHIgZfl9\
	Wl16b9kbPDry71Cp+gJ7rQwMUWbSlPcC6Px+VA3itZEHKRuxOS1UHqFtpOjIHs2yEpD6pf\
	eWvYGjIz+ICo3LH2ZQGdacAXwWtZ8YMXMPotIogeSG/lGzaNICiE6M6MhhQar5y+7xm9gY\
	IFX5R3AIlc8ypIwCkQHei4IevR+iZgmkZgmkUCtVgTRodGQRpLWJjhwDSJUjMLLtBouO/A\
	gQD2PKwjsOJDM/m43S3gOg84chWcxAykZsGUhRCaSyZlrrMNuatEFAGnuYrYwHJAfAmKIj\
	P4QKjec8wDAyiiYC5TvAVwDMoXvdqKxpR2sZTC4t1DjZ6AyK/pJUgORg2hDRkfn9RgKpyn\
	EugRTWda1AKg39D6PyT+XaDCJDQ5RpI+V/A5hDe3KN40HKRmc5TBJqodWIjqwCqdBBg4HU\
	OyNcuu5EjI6su74I0odQWRrWlIV3GUX+BuUIaRdz5HvQaGUgZfNFmSlrOJCCSchxRkfWhd\
	mOPTpyrUCy2zWOjny/qtB47vcYVlYC0TzwbhTMwTtzjRM10ahVBMnD5EEKZ7YHAsk1zrjD\
	bHvSsJ1ZZWbWAiSqQAqhCcuMxgnSPlU+NYoWCkofTmZelznY/wdAjx1Al+ag0VoepEIsko\
	cmAIkSSEgRJKgGqdzog4BUMCEDgOTO9QOpsvxBQaoY+heOe+adooo6jgTSh9Bo+F9ddrIS\
	TQTwHbDRb2bf7dBoByA1SiAVYTohwmzLIJW1QgVIJ2h05N+A0LzyXkaRkSEKtJF1sA/cBW\
	liIWm0IGpZkPx8UTDs7w+SsL7RkYEsCxLjBanPrHZ2XGkKyyCF5SwL0l7gs6OasqDEFckH\
	gfswCWbfrUjUzjVO1EIaLQuSH6k1WpnGqQbJaaGxR0fWgFQZixRIX5AqgKrTHOsKEjlIuL\
	zgQXoPWvtzRQPJOCCKgd8HSB/8NohYkJxZI2pakLLRWcOB1OgFabnoyH4gLRsd6aUEktck\
	sDKQsk6DEyw68v+iQvN5d1U/+wCyIogCk3Y1cJRkEXPgTmg0A5BaRZC8g10F0nLRkWseZl\
	uUwUGSVQVpjNGRXwFuWYkpc3ccgyhHsSCR3v8N52A7YAKQiJpFkKJGcbveYbZU7JfSBgaJ\
	ECSK5/ppllUGqeQfWS30/NsrHnhwWTFEmTZSfh+IdeGwncVudqDRLsxkizNxmkVCtgog1Y\
	bZIqxqdGTNxGOPDANS5RxS6ZoCAIwfpHKdIASpi/I3K9VCwZ3GIveh/DWAue+rOSSNdgYP\
	0nT7LQdSowiSrFN0pNTAsyogSfGaLM1fX7q2ouwxRUd+UFX2Vzzh0DIWiGZ+LvONfhNFzd\
	H77cJss+0gcVqo0bIgOXg08vsrjY70IEWjg1SnhVYbpKy8MkisNkhXoxHNH7q14gGHk3Fq\
	IrCTj+9DIbnnC3Y9rdm2PlLUQhreR2qXQKqJjgwXcgsglaMjvTbpB9JyPpLfL3Vkeb+Utq\
	GjI8tOdZ7/NuAz4zBlMEaIAm303wHVow9iDt5TAqndC5I0+oO01mG2dfD0A6lytpgRQCp3\
	fuk4rMegIGklSFejUvVEI8m4NRGqThsByV2fcw62M2UhSFHD7duh/oYKs91oIFU6zowKUh\
	eVdwO0XvDtigcaXsYKkddGql4bPYDZfyc0O04btaDRtPA025nWyUZtQ0VH5tpnvNGRTlYD\
	pLFHR1bde1mQ/haV/eMyZbAKmsjJd1T5K4Dk9uuchvFmrWNBkmbgePsYpGGiI4WimZMBQb\
	Iapx6kYAVg3CB5DTgKSLVDeamoT1+Q3gFC60dqf6pjaBk7RLOvz3yjt6qS6tyDpA/cjDQ7\
	gXPdgWYbJJiMDILa+kdHBtoKsuOxfITUQM+EzkYBqe+ckN0O8BHSz6HytYqar0hWSxMB3A\
	H8iSokt/6T1SbNDjQ6BZDEAVQLUhDQtvphtjW+5ggg9ZwrA7E+YbbvQKH1wpuqn3NEWRWI\
	cm0kvwrMmYWj1slutIsgRa0SSM31DbNV0zuz7GU5eEp5N1Z0JAD3MOQ79oPKKmoiAdWHQP\
	4HQHz7dWiy5NbVrG+U+USNlgMpDyNZl+hIY1t7KJD65F0XkGpW/lXlD1RJa2q7Ilk1iGZf\
	f53dUX0HyB7SmPg710BzwmojB1A2h9Ro2bWzdYyOtD8Y56td82DjACm7ph4kK2MD6QDwxy\
	C0rvp6TWVHl9X0ibwsoPorIKR7v4LOPeDW0zrQmgiWRNrWtEkzM2ujR0c6kIaNjiyRs2og\
	lWejK0Aac5jtH6jK8t/NG1FWFaLZf5eN1P4a1S+j0P3G+4MV/pYFyS/SepB8dKQHyUdHRg\
	FgYw+zpRKI1QcpuLcUgRhTLNKcqvwBQPufjX1gBqyNJgL7iD+PqpoDd5Pu+ZKFpzlRAVKr\
	CNKwYbYyYpgtKwSpX5pLHyrMtme6YGSQ/gjl8Go41F5WHaJAG90A/CmqxN/8sP2JhxAk53\
	BLI5/ZHinMtjAh6bTPINGREjTFKCANOHpb4zDbReD3QOj86I31lVqhrIkmCkB6E3BAF+eI\
	b/qABabZzp1t72A32s7krXV0ZCCrAZLXLoOCFPhpI0ZH/iEqD9XUemyyVubMy37glwCSuz\
	5Puu92pDlhQQrmkLK5orWMjnRLJxsKpMqhv0vzeevmi5QjIL8B0HnxV2oqPR5ZM4gCbfTn\
	wHUA3S/9GahakDK/yK2vNTsDRkdWgBRGR0aBdiqAVJrV1nxScmSQytf0FFZMW+Uw2/+Jcm\
	A1fSEva62JwD7ia4FFPbaP7tf/1q3yO5CanSJI2YRk4HgvF2bLiGG20ixUsudgOZDq4FkV\
	kEpwZGkCsA/l91Ch85KhvuE5kqwpRIE2ugN4C0By27X2FexmB2m0kAJIrSJIqxxmK1Er6L\
	wTCKTe6Mi3A6s2L1SWNddEAUi/C3wBlKXPvxNMCq2pPICt2UEaE9lx3zDbcUVHNju2ZnUg\
	VSSOFaRCej1IeixG5xI0tUCV8t8OvAuEzo/dUFX7sUtz+SyrJinwb4Gb9PiBye4Nf0Ln8n\
	+PbxYFUJPvQ6HHBFA1QNvup6Ci+Jh8dwEY5/KYhBok8ntELQuZqu0UF0GadVXQZ7X7LHO+\
	T15VQcKoVV8Ht9WjMcm3DqLz7gMeDaGxa4bmY2fDfP8RpbsGrlAm6+EThdroduAXwY7Wkn\
	u+mPlD3qz5xVk9dhS9/2708IERoiMH/wipNCbzilZppArNouX0Pnl79stl1cQi6fGU+Kv7\
	coAAUiW9a47kliM4Mj+Oyj9YLXR9xU1WR0Qr9LHI2mA894dXgH36jwJXSWuSyZf8LjK1HY\
	0XIF3CPHQPSx96B2bvLXn9duyk9dx/TnTqmWC6aNIFE4NJ0NRuMbFVTyZ1xwmosRpJU/fP\
	OK3jjxWNF9D5UvSoFDVgcSffl3J6n7w9++WySnH0ydcfwhxaqrjASuuyU5Joa+ti0Ns6L/\
	1Cbb6VShUv66KJSqLAK4EHNV5g8drfsMPw1iQapyz+xZsLAAHogQfpfvhqzH13svIwW4r+\
	UmvC5h1Qc4T7q6WR9FjcFyCAdO/8F9IHFm5biyF9WdYVosCs7QN+HDDm4B6Wvng1NDskn3\
	s/emRf9cUmJf7k+9AkYbQw2/roSGnP2LRwck9LSeWDVQDJb81Dx6vbwNeu00ikLS8zh7t0\
	Xvr5vnlXQ9ZdE2UgKdcCbwNIbv0kyW2fIv5K/99t08XjJF/59PijIzuzuZYaFaTKCg+wH6\
	T5ob85uNi3HeSUibfq8eQhaay9FoJ19olCmftfVwBECJ8Ank+i6LfvXf7CdoeJn3mr/XNI\
	Y9TEkHbB+UZqEsTE1hcK/SPnG6n3m0jBGGzvGXThELp4OL9P1iRa9IF6zuf7tc1Y5RfV5V\
	Ul/uy9tWRG2yfuUOFxMtlg5lfH9wZHnWxUnygUg/JyYA/z/f/6MukuYb53V754m0UELPMR\
	0mWC2mRia27qYDSNVKeSqrRQTV49Hteek3bDyNb2D0p7bQCqkw0D0ey/z/yjAyg/Spx2B7\
	3W3Hfn+MNsoyYyub14oxCkclL5YFwgdevDoqPTJn9dj8d7ZKJRm2ctZMNABDlIenT+Zu0m\
	vznodebhvaxGmK10ZqE5UbxZ1uEDgOSTVgCSLlZ/GTg6efIWXUzfLJ0G07/yjZobrI1sKI\
	jAgTTfhfmlt7Bt+hODXKNH9o83OjL4CGk0fUqvczMoSMstj/RcWJFmKnzWyWZXtk88m4km\
	02+5uabgtZMNBxHAlrd/HZoNUP0RZidvWy6/zh2yAIwrOjJctG10kMkdFTf12zGCtNyIDS\
	AS5JSpn9C57j6ZXM9Vq1w2JEQAW377m9BpIdtnnsxUp2ayKBdNdeDoyGE/QioT25DWVJ+b\
	ryJIraK/E50y9T491n0frQbT//mrfdtkrWRjoFwjMtlG55cWmJ24CKN3s9idqc1sUmhOFx\
	Zs6/YBu8Th0w0QGfsufoT7poPL7Y5l+jT06F47NZCVQbCwWrFgGx4Eiao1w/+KvDLdzttj\
	28RdupS+TDoNZt68vn5QKBtWEwHM/tcvQSQQp/tl29QlTLYX6vKKtFY3zLbRQmZOo2dCp6\
	A5xqCRStfIdAuZaCJTreMy034a7QYzv7Z+w/kq2dAQAWz5ta8j7SYap/fISTOXMNWuXgPo\
	TK8wzLYUHSm90ZHSmkamT+699zhBqvCLovO27ZeTp56l3fSgtNd3OF8lGx4igNm3fQ3ptN\
	AkvVNO2XoRU50ekGR665pER8rENqSzpbeSqwfS0ejU6StlS+cbMtFk5lc3jhnzckJABDD7\
	3260PlI3uVd2bruAmYkj2clWG5nYYuFZrejIYCFXpk9FmpO9lRwEpIrEPiAtAi9B+Wa0Y5\
	KZN4//PfpxyAkDEVgfSSbb6GL3e3LKlscxO3kAgLaw+PG3oN0Fq31aUxaoECQf4Fb3EVL/\
	7chBwmyjJrLlDKvZyrIcSDXD+AqQYpSXoXwaYPLHP92TYaPICQURwOybrrembSnZJ6dsOZ\
	fZib0yO0n64LdZ+Ls3YA7vdSBN5iA1WgWQxvIR0qhFtOXMfLU/lBFBCvZj4KXYYD0mf2Lj\
	AgQnIEQAs79yAzLRQo/MH0N5DDtmfx9Aj+9n4WNvIrnzM/arIxVhtmP9CGmzQzR7BpVL8C\
	OApPa/IkA/ubEBgg0UCjKKHP2Fi2DrFEy1kanOT2B/pGYCoLnrMtrPeLXt8GTRfmArWcr3\
	TWzDatMl+10ATfIw29SHjrgwW+PCZ4MwElWDD6vVhcPo8Zq3lYcLsz0OvAT4lMjGBKiSlx\
	MZIi8uVhvgUuADwLkAMnUS7cteRWPnxRaeeNHGGnmQ0iU0TTKQ1AFUC5KPz85A8nHaKXrs\
	QXTxSHUFB4tFegC4CvgaAlM/tfEAgkcwRFAAaRv2B47/lU9onHsZ7ae8zMVtL0JiYRoUJF\
	H/AkA/kBLMoXsspFXSH6QbEV4M3A8w9dMbEyB4hEMEBZAAfhp4B7AVgNYErSe8gObjnmdh\
	KIPkTVkGUteC4kGqio50MGXRkeki5uDd9VGK1SC9C/gFYAnZ2ADBowAiLwFMp2M76cUAiC\
	CTW2le8EM0z3kamNRB1M1BcqG1o4bZ6tH70KWj9bGxOUj7EX4W+KBPmvq3GxsgeBRBBD1a\
	6UXY17YfbztXkc4MzXOfTuPs77dLJfFi4Gx3rUbSJAApRk0agNSrlVRT9Ph+9NgD9q71IP\
	0t8B9AH0Zg+gSAx8ujCiIvAUwt4HXAmxDZ6cfVEgnRyY+nsfMJRNsfAyLW//EgmdysYWI0\
	jRFNc5DS2PpEDiRz6G7rYGcB+IW2/BbwBuCT/vz0K69b/UYYozwqIYIerTQJvAaRnwc9D4\
	J+jiKiLacj285Gpk9BJrYijbYFKXiztgekeAFdPIzOPYh25/I75SDdBvwa8F5coMn0z5xY\
	8Hh51ELkpQRThMiPgL4GeKGIi60qP3qjhbSnodWxk5UY25BpFzFdNFm0gIXiXp9H+CTwR8\
	DfA8bTeqICBJsQZVKAyT7qduCfi/Ai4LkIJ1VeWPGOWKmpEuDzwEcR3g/cF+adftWJ4/vU\
	ySZEFTL3zoJ2QoQIeCLCU4FLgMcCuxFOs6+kKaAQmQOaNG8C7hLhFuxvzN8IzOeFwfSrT3\
	xwQtmEaBk59kdFoBT8x9W+Li2eLG2IJpaIJo8TTR44xMThM7r37VpMD55a0EjTr3lkgRPK\
	JkRDijN7W6I2h6RFJG2IJheJJuaJpg5A5/BPAn/ZePqafdlu3eVEeI16I8puyu0k2a8z/i\
	SRYL5e8UrRo0g2IVpeLq1OVoArpd0+fS0rsxFlE6LlJYdIIH8NQ8G238vWvkobSzYhqpG5\
	/3WF58VCZN1E+8qSBeiQ3ZeX0G6jDzxxzeu4UWQTov4yCZzn9o8DbwwWUF+B6CLwTNm+Y7\
	p+6f6RL5sQ9ZfHBPu/K+iHnHoy2J+W+HmEJhJdvC612yCyoV+j3gDi31S8G/gfGsULAneC\
	RiaZ6EbT3atBrgQ59VGsiDYhWkYWEDmO6I9rwkLUMCB8HmgTTyGtYwCvIUIof3/6USSbEP\
	WXrwBnm4RDUROkZQA+jf3arZWZ2aM6N4fMzq5TFddfKmesNwWO/eGVhZigmZ+7lu5HLkOa\
	NoZaml2aP/yt9avgBpJNiDZlxbI5OtuUFcsmRJuyYtmEaFNWLP8frUcjd38kwVYAAAAASU\
	VORK5CYII=\
	")
	-- normal@2x.png
	R.duckloon[2].normal_png = love.data.decode("data", "base64", "\
	iVBORw0KGgoAAAANSUhEUgAAASIAAAGaCAYAAACrJ06uAAAgAElEQVR4nOy9ebgtx1XY+6\
	ve+5xzZ83WiCRbtmwNBGPJFjaeADMEYoiJkwckIY/JEF5IIHwBkhAwCUkg08tLeIGQvDwS\
	EiCMBmwMOJ4YPOERD5IH2ZIs25KQdCXdq3vvOWd3r/zRVd2rVlf37j2dvc+5e33fvaerq7\
	qG7q7fXmvV0E5EWMta1rKWZUq27AqsZS1rWcsaRGtZy1qWLmsQrWUta1m6rEG0lrWsZemy\
	BtFa1rKWpcsaRGtZy1qWLmsQrWUta1m6rEG0lrWsZemyBtFa1rKWpcsaRGtZy1qWLsNlV2\
	Ata1llGX30Jcnzw2e+dY9rcrClN4icc4usx1rWsnKye9eLw+G3Aj8BPAA8Gyja+sPOPd8V\
	hTev/5nFVXAfSN+1rGuNaC1rSYiC0I8AP+aPLwNuBf7UpjcA+mbgC4DvX1wND5asfURrWY\
	sRBaG/QQ2hIBd3XOqAnwb+K3DF/Gt2cGUNorWsRYmC0I3Af0gkOWJPKG3oJ4AQuGvedTvI\
	sgbRWtbSlCHwCySgAzyhAwpCXwv8gIr68EJqdkBl7SNay1q8KG3oe4HbWpKdTJy7Evj/zL\
	mPdpW18/B/bpzbvPTbuyt4gGUNorWsJZbPA17dEf+ZcKC0oZ8CLlVpcuBjbRkoCJ0AvtOn\
	/zcT1/QAydo0W8taiLShfw0cbUn2OPAYRBD6GuDrTbpPALupDBSEngd8EPgXrBWCNYjWsh\
	Ylzwf+ckf8pwA2nvUHIbxFqQ1ZuQuac4gUhL4ceAtwrQ//5hR1PVCyBtFazntR2tC/GpP0\
	IxBpQ38buL4tnRYFoRdTguewD3+MMf6k80HWIFrLeS0KQl8HvGBM8jvV8aXAP2xJFw3dKw\
	h9PvDb1BAC+C04vx3VsAbRWtYC5UTEV/dI92HJqhH9HwYuaElXaUQKQpdSQuiESXvem2Ww\
	BtFazmNR2tBfoVxDNk7eQ3YUyuH67+xIZyczDoFfA64z5x8B3t6j3AMvaxCt5XwXR7uJpe\
	VhcYfuIzsG8KPAoZZ0nwZOQ6QN/Tilb8jKaymH7s97WYNoLee7fB2l72acvIvsEGSHr6Vc\
	jd8mpTZ07PYQ/hrgB1vS/ias/UOwnr+wFiXFuy/0R0KpKFD+1TteOFfHO4gjQzwqzqR1Jh\
	2O7NYH5teInqLMsn/U85L34A5BuaJ+oyPdRxgcD8dXUi6ATck28IaeZR94WYPoPJLiXceJ\
	AIPUhwAi4NwQ3MUgF0F2IY4LgYuAC3HuQuBQCRS5UCnUxwCHc6d8fufAnfOZn8JJDtljOB\
	4BTuLco8Cj4E6CbBcfuiIBKCKoZc/67HxvRilfBjynZ9p3M7z4SuBVY9LdhduCskX/P3BJ\
	S7o34k24taxBdCCleGfJhYYI4GQTsmcBN4C7FifXUE6suxbnrqXcviIrry9AMgsqf+zAFU\
	TWfYgvy6nrIC5Sjup8BHBncDwA3Idz9wH3RceOexHOFHddTayFOXCO7MZ7J74/ShuaZL+g\
	9wB/h3bfUJA7yQ4DfA/wlR3p1sP2SlzfHdTWOzSuruTvOG7OCM4xgOxmkFuAmyk39LoZx9\
	OBQQQQp94BZ92GQsWlKo3WWnx8KmxNt8hs0/mkTLYo/b2QfRgnH4Hsw8CHcdmdIKera5Xp\
	l91wD13iQXQr5RKLPnK/HLr5JuB+2ofsgzyFY7dfCHyAeL6QlauBzx50EK13aDzA0gQPUP\
	oj7gCeD+4OkOdCcaSEgnoZKkVFaTPiahhJYWA0oWakww3NSGtMxJpRpTXpvKv01+GK65Ds\
	q+u8C3DZvTj+BHgXuLfjeC/CmeLup9ZlOkf2tLur1kypDf0R8B2Mh9BJjt3+CPDrdEPo3c\
	BCbM39KmsQ7QPJ335MhSR0wquBr6Bct/TF1OuWylTicE6ogTMLjHxaDSM2jEYjICNqqMwd\
	RmWekqm8i+sguw7HKxEBXI7jg+DeAbwT594Cck/xyRt8fo5i9yxSHL4K+Ku9bn7Zvj8G/l\
	6PhB+mXPbxwjHp1qNlRtYgWlGJ4QOUK8JfCu4rcPIyKG4eN/tiYhhFF2sYufL4xJfD4MLy\
	2GX+/NAfDyDzf8lAdv15Adnx/7ah2C7/hn/FE1A8Dvlj5TV9YBS0tKAZBdNRGADPxhXPhu\
	y7/HWfwPEGcP8Lx5txo5OUsOga+Ypvxea1xzCgT0p25DPAP+2R5W/3Lft8kbWPaIUkAZ+L\
	gVdQbjPxMmCziqn8OuOngrkorXne1WMNfh0br/LPjsCJL4HsKLiBgtGg/MegBEbyuISXI6\
	TNaoCFvGQHyR+H4nQJpvwhGD0Eo89BcUb5jLJm+13Q1rTPKMQFH1RW4Nx783OX34ofi+8h\
	j8uhm++mz+jakVvvIjv0rDGp7sUvlD0fNKK1j2ifSAI+T6EEzyuBl9D2jCpTqkWj0Ukn0Y\
	y0iQaxZlScgVN/BCdeSrkDhniA+LSO0nRKHgMipWUloWCp4xBwm7gNP2inAeUyKM4io4dg\
	9GAJpt37YPRpyonJWjPyJh4oEy7MZSoyGR27XdF3vAyO30Xpe+uW4cX0gBCszbKkrEG0JM\
	nf5tc+ioCTQ5Tw+VbgS+g7430ZMMofh9PvgGMvoLJu1JSkGCzDijdkAgxBcsTHOX0NKg8L\
	KASyw7jNp8Hm05UGJrB7H7J7D+zcAzufgOJkJ4wkT21D3XHfBpe1bZJWixvC1njLzcvaLE\
	vIGkR7KPnb9MxlAbgd3Lci8k24sSMyaZkaRkYrEHOqASMVv/sgnHk/HP1CEP8KRTDyQ/gy\
	qoFRANkIZODTjhA3xGnV3YkH87B2cssgrqcTVU4GG0/Dbd4Ax7wJWJxCtu+CnQ/B9oc9mM\
	p7I8UmIr1dQ+A2IDt089h0m9eUdR4vjwNv7V+B80fWINoDyf/4EkqnrYCT4+C+BfgOkFvL\
	FGE4esoCpoKRJU841TKSZkfNtj8Fg2Nw6BlpGEEMFoiVsQhGuT9ZQwo38NeGPNVxBL1RDS\
	sHZMdxR+6AIy8o8xh9Dtn+EOx8BDnzue77aO/V8CIYd0MHx2Dj0s4kSl5Pyxay57usQbRA\
	yf/Iz+4XwLnrQb4H+HbgRNMeWQaMLDmYDEZnPlQ6sDev8aaPNakGZV4yimHkUGlHiBvEmp\
	FeetIAjyitKqT1Zl917bCOH16BG14Dx76a7MIN5NxHkbPvR858AIonO+6SK0cIO8XB1nVj\
	0kSynk3dIutRswVI/oeX+SMBJy8Evg/HXwQyKMzIVGWmeZkBRtAcTepKWs2CTrwDetQpyt\
	efr6YQbcDxF8HwIuqRsKx2NJPVo2du6PNU8dUI2gAXjcDpPNrOZZTQ0XmqUToywvQCYYty\
	0DHUEeTc3ciZd5dQys1XggYXIBtXd9/AjadM4hsaUX6y+rHzCUTrUbMlSP6HT/FHAvBVOP\
	dqcHeUmgR15xYNo2VrRgnndahOH81Idkvn9YmXgDtMcyQs+HnCtjtWm4Ewb6jUjGwlhlV8\
	5TvSEkyzyHektaYR9WteqLwGuEM34g49Ey7568i5jyOn/xg58+5yhG5wUee9w23A5hhQxf\
	JW/BdA1tKUtUY0B6kBBMBXAa8GKYd8q9tW0AivgGbUOccI+mtGw0vh+PMpZ1y3aUZBAzJa\
	TZRmgKu0lqHSppRGFDSdKn9Hu2Y0QNgADsfxOGLNKUzGzJEz76fY/iSyfU/6ngAceioM2x\
	bWJ+XvAP/ufNKGYK0R7Ynkf3BFeVA6oT2AwpyTsGwB1ZlXTzPqHNYP1emjGY0eLn1GRz4/\
	dh5bRzN4jUVpOsavUxWhHdHVdSFfNSInQ592aMoJx5vg8tj5HaYjVPn5OAa4o1/E4NiLID\
	9J8eR7KM68B4qzdT0GRyeFEHj/0FrSsgbRFJK/9cryoHx57wD3bxD3grLDJuR8gdH2p2Bw\
	Qek3SQJIHxswMEKbbeITOn1Nwxke8grmWYCRqHqD4xxCDmw2TcLyBpRQk7w85zbLdg0uIr\
	vgK8hOfBly9oMUp9+O7H4ONnv7hYL8Kcg9s6m4B1vWIJpA8rdeheoA14P7Z4h8Y/1CZ8Qw\
	Ur1oFhjRArg+stcwOvtBGJyA4YUtAKKGQTRfyJipXvsRvPkoQxM/VFAZNIFWlVXCy0lRgo\
	oB4jYpJ1duEMEtzBKXXapRPqE0F498IYMjtyG7n6HY/XQJpN5SvC7jHQzcB5FHn4e7+F0T\
	XHt+yNpH1EPytwSnpIDjBMjfB76XapMsiX/sGpqR/vWGCCy9fEYz+ouAxr5Bbclm8RkFcy\
	c7DMdfDNkWkR+o8hMF/5BL+H7SI2bl+9ccaYt9QgnfkQ7beDLEbVDOEB9S+5kcLivAbQCb\
	pY/JDcvys63yJuSPU5z7CMXOfen7pGTIaz7n3APfi8t+BRHBufMGRr35sgZRt+RvuQb/oj\
	ngr+PkXwGXNV6+xmLR8xxGw8vg2POIhthbh/YtLDS0aue2i4btLYBaHNoVwFR8BbRhXQ5D\
	H++B40A7vMu/RxB3hLCliMMhxSmKc3dSbH+KlObqeJIh/w1vI74Nl/0tkPeVYYe76J1jn8\
	d+ljWIZpT8zdfUAcczgJ8B+dImKJSsYeSP/flDT4dDz1IwSEEmS8DCoQEUzTVKwkjNNUrN\
	O8LDLjqn87bX2R0ChiqfLXCHEVdqRq4kFlKcpjj7AYqde6PblMmHGfAH/n45cBS47Gdw7o\
	cROXnQYbQG0QwyetO1gOCcbAI/APwwjq0yVhKgUDIzjMIw/4JgtKjtQ6K8qWF09HbYuFx1\
	9LZhfQuQNtMrw0XwCJAx0wEacDGTKiN4pdJbjSlcGyA5VEDK/GTMDBmdJD/73sqHNJTfxs\
	l91FuXeF+ayx7Cub8D8kseULgLDx6Q1iCaQkZvuh7V6V/oHD8LxU1VguoWrGFURqLibN74\
	zrcJx18I2SFSUIkBEuYDKU0p8vnUaV1S47GwS52z2lIKRk1fUqwpqXox9FpS8Ic5IKPY/S\
	zFmXcy3PkX4HLV3ghG4Nzv4vhOyo8GgHO4C94x9rnsF1mDaEIpIQTAISh+HPi7VM22oAjD\
	v3sNoyI+3i8wGl4ER+9o0YbssZ6caB3a8aRF19Ce7PU6/9Q5Y4olzbo2X5IyHyuAeSBVEy\
	YLOPur8OTPAqfKPLJwDyMYncLx/Tj3nytn9gGB0RpEPWX0xqf5IwEntwH/A3im7vR7DiPt\
	L4rykfiaVYVRapfHrafB4Wf6xJPAKKUZBaezApL1P4VZ2Q3NKAUvawK2QanjfJRmgxJK/j\
	4Uj8OTPw3br/VtScIIHL+Lc9+OyGcOCozWIOohNYTIgB/AFf+EaG7VGkZR0plgNICjt5VL\
	QXprRrrDJ0a/ouH9AJdgMrkSCE6DLwGTaNmH8Q+1xTVG4awpp8qo4hzsfhBO/wQU93bB6F\
	Gc+zaE1wQHt7vg7WOfzarKGkRjZPS/bsDP/7mKUgt6KZAARQuMtL8IDCiMrGHkTx+G4y+g\
	NF+stmJhpEGjzjGATAMhBaOgpQTfkYWagVKrKZYw07DXmh0FUiNu2peFwJn/Bmd/zr8HCk\
	ZZACjg3H8E930gZ/czjNYgapHRG55B1ZEdXw78D5xcFiWKQBF3+jWMZoTRxmVw9Dlox27T\
	ga2PLUQsjGItxDmTX2o+Ucp31Oqk1j6hAJ0UyNpMuKAZDep8GED+STj9jyH/BBWMMg+kGk\
	YfAvf1IB/HOdyJ/QejNYgSUkIIgAzkH+HkRwg9phMUKwSjFVixDxpGiQK75hiRweEb/YZi\
	1uTSmlHo/Ao+idGzpjYzaIFRAg5teVVw0mV68wrrb/JADTOvUcfWtLOaFTmc+S9w7ufL40\
	qj8zexhNFpnPsWkF8N59zx/QOkNYiMjN7wTHzHvgj4eeBrGsPwC4eRNPvtvodRQiuCMTAa\
	wvHnweA4NYy8tpH5zksGWZi3E0yWlMkU+4oC2FyLLynp92mFkSkzuRlbgE4Aqp5rlICh9T\
	WRweiDcPpHoHigDUbg3L/A8Q8Q8v0EozWIlJQQAuBmKH4LuKGOXWEYNcwyFd7vMBqc8EtA\
	AiwUjOwatCqcgpFLwKQ8juYaJbWoAJWUNqbT2+F7rRGlrkmZaTZO+ZYYgJyBJ/857LyJ2n\
	ntb2INo9fj+CaEx/YLjNYg8jL6fQ8hx9cAvwgcb64JWjKMktuHnAcw2rq+3HxfD9NHMDI+\
	noYfJxxrEy6YVUEz0mlTDmqtLTXNvDSMjI/I+pIqzcjCy2hRDSd4Bud+GZ78KXC7MYwyF2\
	72R3F8NcIn9wOMznsQ7f7eTYSO4Zz8XeBf4nSPmA+MXCsozh8YTb8uzZVLQIYXUjuufcfV\
	MIp8MSkYpTQjbS4NcCmfkr6uTcNJOZ+75hRVviQLK/U38hupegRgjT4Cp/4ByINtMHoYx9\
	chvG3VYdSXL+N/7vah7P5e+BSVGzjHT4H710DWvVuDo/ooH8THIT46LsP1ffa3Ukz6Kp9E\
	fhFDUo8i5NFWRmbqWderjk9k21eqvLv3Q5IoXYJ8YvKo0guc/TAUu5Rfai3Kv7Lrj8WHcy\
	CvwxSUe1H7OBmVeUnu0/rzRVGdE3KVNsSH6wqfv80zV2XnwEjVZ6SuU2kkdb6I06PahKo/\
	o/L88Ca44Odg8AW+PH+vwssmcinCG3H8JQTk1PM7n89+kAOnEe3+7i14beMIyC8BL3dWK7\
	EaRiQdmpGzGsdeaEbWeZ0qY59rRpufp0y0lD9Iaz7aQW1NMx2vNZPaT+SsVqN9SA3fUItm\
	lNSIrIbV5dDWZWsN0GhGInDmX8L2a1ATHuuXzbkCx3ch/Cecwx1/W+fzWYacl6bZ7u/eiu\
	8AFwGvxckLlHnmU/WAkYXBQYBR2za2fWWhMHLlV2MHFyoYWRMsmF4WRgMigCVhpKDistJC\
	TzmYXQIGkX+oy3Rr8y+1mHit5xKm3dlfgLP/voZQDCP8liL/dBVhdN6BqIQQANeAvB4oTz\
	gNir4wMlpRlY8+NhpHiFrDaDoYZUfKJSDZho/TMNLahtVOdKf10MmsY1nnU/51XWBJwajh\
	tE5d27ViX2thLX6p5FwjH955Kzz5o8BOG4x+EpEfWjUYnVc+ot3Xf354358KvAVcRaXSHx\
	H8OcZfY30vlRh/UZVPM097/Uw+o6i8RJ2qOBPV12c0i78IEn6zlmTT+IyKM7BzX+kvwi99\
	qPxB2vejfUbeb1Qd+/TFqE5LbvKR2GcU+YTUcfDraH+OBN+UvTYchzh7nQ4rf5bNB5M3Ks\
	3mS+D4TwFHfRvQPiMQ+UGc+wlEkFMv6PWcVkn2PYh2X//5/sg9HfhDqjlCaXCsNIwa5Y2D\
	UWbC/lwrjGZ0Xld1HK9ZTQWj7U+XQCp2Y/BUHV45tAvtdNbQSMFoFMNCyvNiHcoNB3VwnI\
	s5pwETIKhhlALWiMhxHYHK/I1gpBzfw1vhxM+CuyQBI/Y1jPY1iHZ/p9KEng68BXHm05sL\
	gJGWXjAKJxJ1SoX3A4yAucDI5iMC5+6m7PhBK2mBEeJh4ztu4UedIg1o1NSatPYkOWJHuS\
	INJWhQuzRgIjq9HpGTBNASaaPRM93WlnQhPLgejv8nyK42MKqOfxDn/vl+g9G+BdHu73wB\
	/uUuIQQlhLqG3ecBo6SW1AWjFCgs4BYBI5vPHGHUc1gfxsCoqoPKZ/Q47P4ZaRjl8TkECt\
	VRCw+cChYaMGYIXeUjMkIaplZKWwqQ0RpWIp3VmrqmBUTD+wY61blw3ocHl8Pxn+6C0Q/h\
	3A/tJxjtS2f17uueDaVz10OouDp29KbalHY2T+3ATjqzuxzYKj+ny7POZZunDo9zYNsygj\
	M7Xa/lLJJNOLCrOvh83CYc+wLKDca8Ezia8OgdudUKfEe0NUjmHdgph3ZqFb6aGOmimdLK\
	yZ1cZGuG8FOLYZOLZHU+ekV/Ftet4cQ2UxKKR+HU34TiM8aBXR2/CpGlDu0f2FGzEkIAXI\
	OTPwKuK4OmUy0FRjb9GkZR0klgtHUlbF5HPTSvNjmLRp0UnPTWIJkZdYq+JKI7vMPO0naN\
	0bq2UbLEaFcEqADQth0iLYTs3KMUjMyIXvEInPruNhgVOPdKRH5jWTA6kCBSELoMeBvI0+\
	NONA5G7VrMgYSRbcO+2ssog6O3lsP6evV9pRG5hDbiDCgsZFQHbsAo1lZcSnNqhZIuZ0BT\
	Q7KQsZpRQruyw/iNY1W/4s/gie8AeTgFo3M49zJE/ngZMDpww/e7r/vCcHgc+F3g6eDMu2\
	x8H53LNEL8vH1GNn2Hzygqb5xTvKuMFp9RY/ROt9H4tVbOZ1TA9n3UQ/bK/xIN72tHsBif\
	jXEci3doVz6j2HGt/TwSTQuwzmbt8wnltjmo1VSAhiNcHadGz0I5jWPjS3KXwvH/AFyA8h\
	OF40OIvAbnngqr6zPaFyDafe0X+pfUbYL7deA5dew+hpEdSWudY9SnjAMIo9FjpfO6GmFS\
	I2ENGBVEHT06b4f6LYAKYiiIh1GhyjaO8mpELjXSph3Nus4WMmYELhpFU9dijzWQfX7ZlX\
	D83wCHScDoUpDfAXdiVWG0L0DkxSH8F+BlzY46Dxj5w1YYzAojXYbKbw2jRKQ63v60Hw1T\
	o2eNzquhY4fBFThChy4M0JLD7GF4X3V2MVCJFrpakGjtxWpUGiwpSCWujWBU0BxRy2FwIx\
	z9ZyBDGjAqeBbIfy9ttlke8mJk5UG089vP8R3XvRr4q53zcWaCkdZaVEe1eTbK7AujuNNP\
	DyMbnhJGLfVaDowSBYrPozgDo0cNjEJnNeBpwMhqRxog1ozTeevdANTQfqTBFOm8GlMF7D\
	ylrsmMbSv39bXKDNTxoX7D2+HI3/X3r6EZvRzkxxBWbsX+Sjurd377Nvwd/evAf3ORczek\
	Sjikp3VgmyH4yIFt82yU2deBbctQ+dk2rXd5LOuQHYHDzwKGfmje0Rxi16NpwZGs4hrr0p\
	Qj2abV+1AbB7OL1p1ZZ7N1jmdAGO3r+ix2CNsv045Zi9ZwYCsn9tmfhu1f9M9QObCdExxf\
	g/B6HAvfy2jfj5qVEALgi0DeAmy5Rkc1YVR4rjCy5fk8G2WuYRTXZ44w2rwONi6lHpoPMD\
	KjZHY4XkOpE0YaQhpgKRipPBogsTBMDecP4no34GQhZRbTts01qrYU8ffh9A/A6F0pGD2C\
	49kI9y8aRvt61ExB6GrgNyg/LK6WTVhn8hzNNDNTWnR4QWZalF9vM62Pqd/idNfhFdhYDc\
	J9TjivoazD7ueofCtFyhcUzBRvuogxtyqzKoyGmVGohgmnnONh9rbPR8ReZ0yrtlnX7BKb\
	dMbEGuewjkxE7cTWZYR2CRx9NbirYjOtvNmXIPwijsGquItWEkQeOFvArwNXlGedjuMgwW\
	i9y6OWFhgVOzB6WMFFDIy0zyjARoFAj5YVZuQr8ifpzq0c4UXsyJbI/5OAjoWUGJ+RdZRX\
	51M7Q6ac3vrahMOdAtxhOPaPQYYKRv5hirwQ4e+DIE8s31+0ciDa/q3bARBx/w/wvDh2eT\
	BKl5eSMTAi3enXMIKxi2R3HiLu/BJ3ysJoRnbNWbUuLWhVqU5uz4frFUAqzUiIHMxJbcaA\
	o5FXYiSsMZqnNbXUFiNGc9JtGtwAR76basvZynkNiLwa3O3I8mG0UiDa/s3n+hfe/Z/Ad0\
	qjE8OyYNR/jlGiDp3bh+wVjEJcWxn7AEayA7sniTsnSjMwmk9qWL9QnbQCmYWFhlr4F6AT\
	511rRkI0N6gxSmdgV8FKXRuZbUaja5hfFlhmnyMNyK1XwMaLqUzTGkYDRH4O57aa20Xsra\
	wMiLZ/87n+yN2C8P+G82kYhbhwtIIwmmgvI20GmjznBiNdflsZPWA0i8wDRqNHVEcOWo8y\
	0yoYaVOt3oMomouUmvCoh/IDjBraTAwJsVqOHY6PtCQLGG3iaU2pY8V+wySzG7nZuUYjOP\
	oD4C5PwegWRP4+gDz+RX2f5NxlZUDkO8Nh4JfBHdGdqgmjVMedAkZR+fOGkWvmuRe7PE4M\
	IxseA6NZfzhn3eWxOAv5E0pDSfiMNExCXMPsKcy1KW1Gw8hqRhpuuZ9rpE27hEmXBFQKSs\
	bUisCVAJSFTjTXyJflDsOxf1i+E00Y/UPg2bA8GK0EiLZf411Bwr8F/LeA4he2H4zCiWaa\
	KmxHq6PrDgiMovJ6TniMyuiC0YwmGjDzLo+jR5WGoqATwUUvBQkw0qAwJltkpoVzGkbqXG\
	qZBwUiHkgWeFbTiTSrrgmOCZMx5Qtq3ItRXP/qM0W3wKFXeABFMBoCPwdsTPoo5yVLB1EF\
	IdzXgXtVl8k0HkapX+4uGCU61V7AqFHeOBiFE4k6pcL7YZfHWWCUnwbZjjSSstOJ6vCq81\
	YdWGtG2pek4i2MQqeOfEsGHA0ntjWvArQ0wDSgUk5qs4lbo652QazV5nReqq6HvxWyK1Iw\
	+gLgbyOyFK1o6SDycgXwn8tDq7UcQBgltaQuGKVAYQG3CBjZfOYMI2BqGI0eIxp219qKSD\
	ou+JNSfpo2B3aAV8MB3gazAKOQrxnV0nDRYKzy0aBMrUPT0E2tcTNhDShyYAOO/j1/PRZG\
	P4pzly/Dcb1UEG3/xh3+ZXY/A1xaxywCRlbGwCiVPqrP+QCjYBYuCEazrNjPn1Aahh4tKu\
	iGkdaijEbV5sAuTNiCLzV3yJtqUfoKRgGGiXVoDbjpMkbtaVMaUTQKp46Ht8LW1/r6oGF0\
	HJGfBJDH7pjumU4pS1visf0bVUO/AccvlocJWyTqA3G861iqEa1LA59Poq1258KO8hp1PO\
	gbq9nwqu3yuHkFZMeIPsqoP1aYOZ+no/FttGhdWWbOheUZjnhDM59PatvYaFlIvNGZa2wx\
	m6m6DOO8GFBvjTtslhMt6UgtBUnU265FcwOQc/D4t4Cc9NeC+prsCxDejgN34TuneqRB9s\
	sSj8uAf99Pa2EOmlGit0R5jBvWt3kuQjOy6cdpRqG8BWlGug6tZSxJM8pPUWs6wT8UfvkL\
	KETFGZ+NHnmyQ/upyYdJ35DWmrQ2FmshYrWoSrsRVX7QmhJmW6SNWce28dsNmioAACAASU\
	RBVD2RMPlSkyHdodJfhPfVxZrRv8eRzcf07idLAdH2r39R6ET/jmCStYFiTKeaCEap/Kqy\
	g/SBkY0/wDBqjN7pNi4ZRvmTvhMG0BTEMMqpJzxaM81fF41+WRiF411zbtQ8rhza2nyr/0\
	ZmWgQO5TuKRsMsAFPr0swIXANOepJkYgb41svKPYwsjJDbEL4RBDm5NybanoNo+9fDVHL3\
	FxG+YXKtpRnuDaNezmuYaMJjFb9EGEXldYDzwMGogOI0lT9IwyPSMMSAJAWj3PzT6YOGof\
	NTALIjWNX+RLGzWNr8TBGMjBaT8hm1ztC2viStGZm0oW1H/qbqdx5GRQHIj4HbmO2B9pcl\
	mWbuOPjZ01NpLewvGOk8G2VOAiPbpknnGE1Wxr6AUX6asoOFa0JHDzAIHT3AKGXeGBg1jj\
	WMgqNZmVXRiJiGii3Hf0OtZaSt1uqU9pNct2ZMtdbJkAmHdjTXKIfBM2DzZf6c1oy4AeTb\
	EJCTZsnnAmRPQVRrQ/wwuKuqiKlAwYrCyNYlkWejzL4wijv9epdHkHzbV0yBQJtqDVMrgC\
	SnXoVvNSBrAim4dcHIjlxFZlqsdYn2UUUjeTrftuF7BZLWoX7bjpTPyP87/E3ApoFRAcKP\
	4ji8F0rR3mpEZYNuBL6vPNFilk0EIxNcNozYDzBK3ccpYDRuXdqewKhA8p26YhUUtI9HaT\
	7aMY2CUQQDia+rHMu60wcYWXNQxVULWhUcFJDE+n+65ii1De2npgFU5lmRqH8CVNnFsPXV\
	1D4iF9p0BcL3gCCPLlYr2jMQbf+a/3JAub2Hmko+K4yanWqpMBILCts+lWejzBWGka7zqs\
	GoOItUn5sOEAnmltaIrJnWBqNRnKbhoC6IHdjK2a2dxFFeGkY1bMSCJTIfNVyMVpNyikea\
	jzbxdP2thuXPH/rLwJaBESDFD4A7vOhJjnsCou1f/eIAmZcDX9XdkVV4QTCKwnsGI1uez7\
	NR5pJh1BBb7xWEkWwDRQmjlOYTdepwLgEjfS27CRhpE8sAJwKVhoWBUdHUbERpSe2TGlMw\
	svAymk9kggVzTmtuCqTZETj09b7O1DAXLkGKbwNBHrl9hgfZLXtomrkt4N9WwbmDon+nOo\
	i7PDbymxZG+3FjtUJpJygYoUESfDwJGFWdNlzr44LWU2gYFXW+EYC8XyfKxy7X0HXRmk8w\
	0zo0n8bcI21eJbQgsYAK7ddmoMnn8MspP33WgNHfA4aL9BUtHETbv/rF4fBvIu5pUWRbR5\
	4aFHF4lTZWa8R3PtQxMCLd6c/fXR7rTi3V0o4AIw2PYIZpGGl4WZMsdNyC5oZrOp3q3A1t\
	KAGeaJTNmGltfp8INNocNP6khmNbX6fnEtnrCmATDilfkWc5yLUI3wCCPLwYrWivNKJjlH\
	uejOlUKnwAYTTxLo9tMGoAbq9gFOLaylgijArvsJbC34MAhXAcNCYDlQgo2oxKwShoVKPE\
	tXmdR8NMs+ZcuNaYWVIghZmfFMEsYaY1Rs5028zcJDuK1ph7VMChryqNlwpGRYDRD7HAjz\
	MuFETbv/pCf+S+D72oteHAXQaMQty0ZewRjKLKLhtG9rmlyugBo1mkDUayS22atWlG/i8F\
	0Zc5RMU1/EOqkwcY6dEn64uKzLQEjCIIWm2pNL2kUJ+71hMd7er9yPmsl3YU5q/VkpQvyZ\
	p17mg547o0yVQbuAXkKxdlni0URH6E6hLg+7s7Few9jLT/ZtoyzO1bBIy6ZpUnYeSjVhlG\
	XdpWH0nCSGknHgbtZpoHVrQVbIBR8KXsxuml8LDzWpZoGGhtqgNGocNXn7xOaT616SVVfX\
	br9tlRMWt+VWkClKyvaWTKsdrSCA7/Bcrvo4m/xRWMvhsE+bPqc19zk4WB6NyvvAgAEX4Q\
	uCCZaCyMdJyKXyUY2U41dxi5Zp6dMLJLQdS5SWAUldcHRjY8DkbMJo17ok2lGjplZ5Y63g\
	IraCiVdgKx+aLTa3NKgUFPRIw6v6h4bcKFOG0eGjOsglE4t6vK0f4fe6x9SNZMU9pXVE4e\
	19FdCJsvqB9UrRn9BXDXL2Iof8E+Incl8D2NTq6lE0apF3cKGOniesGopcy2MhrXHQAYTb\
	sUJCqjC0Yz+ouqOgatSMMiPu50YEcwCnBQaZIw2q2vT/qBzN/W4XYNkTYYmQ86Rv4ia5pp\
	rUqbjrbMEe0akc/30J/31+ChCVA4pPguEOShL5zx4cWyEBCd++UXhh7wveAOAU2NQ8uiYT\
	TtUpDeZSQ61V7AqFHeOBiFE4k6pcL7AUZABaNo8Ws4DjDy6Rqg0f4drem0wCg4wGVXAUSD\
	Q5tpeZxHY4TLmm1K4zImVwyjZnxaCwqmmIaS9TPZOvm/w+tg8PQUjL6Naubj/GSRGtEFiH\
	xXeRg6XYjq6FDQE0Y2vIIwasicYZTUkrpglAKFBdwiYGTzmSOMqnxVx244pz2MinZQRZpL\
	CkaFdoYbaDSc0uFarfWYsNVGGuctoLRmpECi5xYFf1JUVgBsHqdNakIGUoe+vLyVMYwuhe\
	KvzNs8mzuIzv3PFwWQfBdwoq7wpL++Nk2H1rSnMLLSAaOOqQN1/CrAyOYzbxjZFfu2jDnA\
	qFrfZf1ECj6IglEexwV4RKNKRZxvNbSuyohMIm0W6Wu1eZQaUlfQaYNUp5k2MueC6aivN9\
	pTapmH1eS27gB3LAWjbwZBHvyCGR5aLAvSiNwWpVlWBhWMYpD2gVFL+qlA0SxjLrs8dnWq\
	pcFIyzgYWX+RqWOyjBWDEZkvKAUjdVzBKGgNFkbaz6J9Rr5zNmCkzR0Fs8iBbTUlbaYlfE\
	waPtG8pQAj9aWQhm8qN3Uyw/eNWdcaUFZDcrD1kgAfDaMvA3fNPLWiuYLo3P98cTj8ZoQr\
	ysNZYdTlaxkT1tfMC0a2DlHZQfrAyMbPG0Y2/ZJhpOsQtXGOMCqgoRlFTuU2zShcHEASjn\
	d9fY1mVeiRMyHWQnzaACzJiTfft2ZbCkYBeimfUA0REZ2v1rjaNCOjDTXMM52Xz+eQ79Oh\
	05Ywcoj81RmeVEPmunm+B5HD8VFEnlFeGGIlZFSF4yxNPRobvrc6h3wZHeGeefbejN+2Sa\
	eP2lQY67KjDVW8mLrYMotEmbrtNk+bvg5Hm/E3npMpv1HPrjLss7BlhLAuQ+dp7lsfcUNw\
	G2UhFd/ChvTONzYc+79k5SFZ+c+mqTblH6pzIXO/Ib2zeQ4hy3zZUG/a76+NNt+P8/mzkw\
	Pu/NSQhx4dsjPKGAwyrrws49qr4LqrHM7pMrMqL1flm1FvvD9Q9R7W6fUHA6rN+bO6Hirf\
	cCyP/RNc/snyeTn/Y+KyOxG5GedwV/xp62Ppy5dhr1STycsQnlHOBvcqncP/539B/MMU0T\
	Dy8UHExS+8Dev0gs+zJb7KI9QlnaeIMzCq8yirHdpg2qTTi4ZRVv6CVOztaEMVX1a0rost\
	MyOGkdf2Qr6N+5YZUNTXl23y4cZzCvmk7uO4MuyzsWWEsC6D+hp733qLugcALlf54esY8i\
	7rIIXDZcHkCO1QGrRzpXbghl4bCNAJZpfvzFWeIyiGXvnLqEbZnNQapMNfm4GDBx92/OZb\
	N/j4p4dkLiPzbBgM4CN3g8syLr0o48vuEG66wWti6gdKJFOPbkQJlZBkUNbJDVWbBGQIbg\
	QyUHUKceaRbH0x8uTdOBzlj0QGUtyEy25D5D2TPqWUzM00O/dLLwkNLUfKKjig3uM9MtNs\
	eTp9QymZ0kzrXcYES0FM/HrL2Wax7RJ6kv9X9dXga1FmlPbvJB3YwdxSJpmoPOywvzb/EE\
	oY6XKVCWaGzf/kQ46f/Lkhd34SirwgL3LyIkeKgtyHizzn4ZMFv/oGx+veClI0zbi0maZG\
	wjonXup/2ndU5ue2bgcZlNqNOGpfUfFNEz6kVpmzs9pdBXxtFYw6YJXGXrOGUYcPanV3eS\
	RxH6eEUUu9JoZRBYIADzEwMr4eBaaGA1uDpgi+Fw20kCZ0dOuLypWPRzuipQq/7y74ud8a\
	sLsrJYDynCIvKIoaQEVeUEhBkefkecF774TXvsUZeJRAiR3YyleUXG8WgKP9Sjo/5ex2h2\
	Dzz1E5rGsYvQIR5HO3TvCQ0jIXEJ37pZeEw29DXGzuOfsyQmXC1IlWAEYmuEwYiQXFqsIo\
	dR87YKTrrGHUtRSk9/ysYJYpKFQaDFQO7I65RuXGakWcV9BqCt1h22CktSCrMcUwevRx4b\
	/85pC8KCoA5UVOURQlfAKAfDiAKc8L3neX8IG7hEgrqjSjXNUxNVrm5x5FEy+NFpSK27oD\
	pEBwGkZPxbnnzGP0bD4aUVmPAfCqMmzAsC9g1OxUq7fLYwiYPBtlriiMGmaZCs8MI4n/iT\
	mOYKSBE2tJ5WUjk87/s3sSRTAyOzoGECRhlPMbbx5wbluQogaOFFKZZhpAeZ5XcUFLeuM7\
	HaOR0XAqzciciyY1KvOwoRkZDUnByG0+C9wGFA0YvWLck+kj8zPNxH01cI0KqzhaYMS+hd\
	FMK/ZngpEtz+fZKHM6GEX5zQKjhiwYRhV4QqYpGHnTKwmj+riGESqdglFjKD783Y2hU8Eo\
	j86f3Rbe/qcZuddwLIyCaRYAVEgRw6goeOJUwV2fCgBtgkXCspBOGOl/ieUhGkZswOYt/p\
	ZEMPpLiCCfuaXj4YyXmUF07hdfin9h/lr6hVcvYANGIW52GD25LXz8cyPu+syIz57MZwBF\
	/061r2FEutNPvUjWtnHPd3k04EnCCOoJhwpGLXONYs2o1prKPLRjmPp8tI+10ohUx/7Efb\
	C7KxQeKnleRKZZgJEGkIVRXuTcfZ8xv+zsbAKMtIaU2BAt5VfSc4sCjDaere5jBaObwD1z\
	VvNsXsP3xwhO6uSwO1QNCMP6/lQ17F4N60MJo/FD+9sj4dfecYbfef9ZPnDPDnlRJ7ngSM\
	aX3rrFN7/0KM+8aqjKT+QXzESXDjeH9es86mqHdvQtY4KhfX0PbXxVXko8HFJD+408q4qo\
	Nk06tG/a2BjWT9U7MbQvhboXdb1KSQ3tq7rYy3S0vgeSo+cTlXnWx0JWPnOBcl5NyKeo86\
	mGxfPyOlf4NvthcTeo6xrui8CnPjMkz3MGgwFFkSNS7p00YEBOXh0XFOXtySnDWQE5ZB7y\
	Dz7ifDskugVRwx2IDHGVJqiH6wf1tRAfV9cPCVMC3OZNiAzA5YSdD8RlOCm+RnAfZQaZl2\
	n2CuBQFepa/2Q1I1BxcWfv0oze/6ldXv4TD/Hjv/447/1kDCGAx88U/Ma7zvL1//JhfvI1\
	p9gNU0qm1IzWuzya/GbSjEJcWxnTaEYS/7XakdWMrGkWaT1lnFSaTptm1GamaRNHa1xleG\
	fHm195TlEI4s2yXI2SVccmrP1HTz5pNS5jcikHdD2iFvuTWk02+xkkycFtwebT41tdakZf\
	iQjF/Te3P+sxMhOIzv3CS0OlvqkRmXRYJmDUeMHjn7QUjN784XP8jf/wMPc/mjNOROC/vu\
	VJXvUzJ9lRZn9Ups5/Ihhpk8m2o28ZewCjLt9aEkY+amEw0uW3ldEDRg2ZBEbh7zgYhXSj\
	Ol1jrpF2Sqt87YJYD6ONYeHh46GiYFSNmiWc1tahffqM1FMExoIl9/OAUjCy4LLD+sq827\
	ilvj/hVkvxYtxs3z6bh0b0FOBlyZjGSM/sMPrEA7t8/88/ym4+WaPf+fEdXv3LTzA5KPYI\
	RlrmDiM3IYzq62eCUVReHxjZ8BgYJV8BDR8SMCpMnAFLYq5RDCPqNNEQfUIzqq6JYXTs8G\
	7ppJbST1Q5rTWMinJEzY6a6blGp874zfYjn5R2jI/TjHJiX5f1D9m/I9zGjer2VjA6hBQv\
	bnkgvWQmEPliX4l0+JrmDKMf+ZXHOLc7XYNf866zvP1jO0wFIyXrXR5NndpgNO3s66iMLh\
	iNcV4nYYTqqMFMy02aeBStAaMKNLTASDmwEYi+zJFz4dGidlJHppkGUQ2jNtOsyItSK9Ka\
	WWPEqwkWsWZjNOtaOakb1xaQXVz+k8LCaKaN9acG0dlf+BJfvnsFqj6ldL3wIX5yGL3j49\
	u8/56daasMwM++4bQpo6XODVBMCqPUL3dXGYlOtRcwapQ3DkbhRKJOqfBKwMiYZQ3zDJow\
	MmabqM34o+1DVLqqU3sTqFBpitrMOX40b2o/YiGU1z6kjrlGp54MWpevk9VsKkDFmo9YM6\
	wxSqYBpaFUQKUVRTD6ChCK+57V9jA6ZXqNqOxsx4EXS6MDpNLPDqPf/cCZqasb5E8+scMT\
	TxrP9vkMo66BBXN9NOExKsMCbhEwsvlMAiP/d9xco8o30gYj5cC24NJzjXRnjnaFLPM/fi\
	RvwCdpmnlNqGuu0ROng5mYk4aR3uRNm49hrpGBkZ5T1Mgn+IlurCFUw+gWcJd0Q6BdZvMR\
	CV8ObJaHi4fRB+6dTRuC8r1476d2Vfm6PuZcCM8dRlbGwCiVPqrP+QAju0jWljEpjIxmVP\
	2yh44awCIqXB6nd3kM+RQqLsBIwyznouO1k7rws6VFxJtmeQSjcXONTp9R9WjASG8NmzIf\
	vXYUrS0LceETRiGfWoNyG9dTTXmIYfTCac2zqUB09n98STh8uS5YAlj6VmZCGP3ZE+NHyf\
	rIQyGfpcEoZR51dKqkObUXMNLSB0b2ur2AURYf94VRakRNw6iClgFStEg2jCy1wUgvlK3B\
	dGhjxCCrh+/DolYNn1ITKifmRmHltJZCStMMAyDtsFaTG2MY1WAsYeTTVJvtF1QfrYyWgo\
	zAbcLgcn8/Ixi9qH/nj2UWjSgD/jxAE0Yd0ngZoS+MdkfMRbK2Gd5RmVb2AEa2gy0dRjb9\
	OBiF8hYEI12HWTUjmABGKTi1bTnbAqNojlHB8cMlwCr4iDe/jM9o3Fyjc9sF9YciA0C0Ca\
	YW6jZgpEbWgmZkh/+tVhXMtI3r1f2qYPRCRCjueUbbA2iVWUB0O3B5FQovovMw6mui6WvH\
	wOj0tvHtTCnDgTE9ptJamA1GqfyqsoP0gZGNP8Awsm2I2rgIGOX1uS4YVdqC0qBEpxvFYS\
	m45IJ63yELoxg+3XONjh/xoCi0CSUkHdiiwag1ox4wiv7mMLymvn81jG4HjkyjFM0Coq9o\
	nAkVmBpGJmxgNONylkqOHzKdtCpjUq2lGV76XkbLhlFUXgc4lw6j8I8EjAp1bQpGSsOpFs\
	laB7ZPU6Q1o+uvHCU1ocKnqecWdc81uu7yEZUJFQ23q2M94qUnKgZg6ZnZ3oldw2hk8vSb\
	pW1cRz2FoYLRAOG53R0/LRODSPmHXtqIdMwIo4Sm4mF0bmdOFGrIOPiM01pYURjZurT7fO\
	oyJ4GRbdOkEx4nK2P+MAoZKU0oglMY8UppRtrMKo8bMKpMM5IwuuPmcx4yTRjlRQ2crrlG\
	x47kXH150LbssLuvX5FT7RZpZ18ntwEpj0VrP429inJwh8v5RE0Y3TaNxjCtRjQEnt8aO2\
	8YAbuj+YFoazjuhZ8UFKwgjLTWojqqzbNRZl8Yxc9pehjZ8JQwaqlXPxj5v6kRtSKkScEo\
	AMfCSA2ZV/OI9MhZwXNvHnHlJbseQApGeYsplphr9NLbtskiU1A7x71ppoGUBI/1JdXOad\
	FzovSOjcHUG1xt3kkB4bYxNzwp04KotAUjaTG15gEj3MRLOrpkc5gocy4wMsFlwygqb1Vh\
	lLqPU8CoaynI3GFUxPERjEy8PlZ7GWUU/K1XnvFD8bUm1Oa0tnONnnLRiD//gm3iYXf1rw\
	KIdWS3aEGNZR7lPyl2qfY1sjAaXuGbpny3IrchUNz9tK4b3pDJQVQ+s5dMkHYuMDo7pxGz\
	zjJnhlGzjau55SzNPBtlrjCMdJ0XBqNwLgUjVIcPnb4GQMmy1C6PPm8Po9ueucO3/IWz3v\
	mct5pqdq7R4a2c7/3GM2wOAuR2qeGjN0gLMAp1S8FIx2sYxZMZ6zVqYbrCyA/hi4XRjcDx\
	rjudkolAdPa/f4l/CLyoETnuu2ezwmh+ChHHD+uRnuXCKArvGYxS93R+MIrymwVGDbH1Xj\
	CMrHZkYVRBywCpMtP0fJ0UjIRv/PKzfPcrzzAYSDyXyIyghblGl1884tXf8SRXX+b9QEWo\
	yy4NzSZaxJqCkfUdWc1ITcqUEfXqfb997PAyf7/9fSth5IAv7LrLKZlmY7QMeBGCesb65b\
	K9MI4WcTiRpLugTO9IbayWjeHcJLI5MJ3Oltlohw9XbUnER22y4ZSUeYiw5xurlRu9Ycrz\
	eVLEeQj0+2ZaVRHVJp+fbVOVz5g27tnGalp0vRLPsXCQBRgNTF0KKthV30fzm6cFSFV1hH\
	JjtQF/8UXneM6NI37hDYf4g/dtle4kMsTlDLIBRVFwwTHHy1+0w8tflLO15fy9cWVeRU75\
	ocQR5ffK8IAcqlsmVN82c0L1PTNCWKJma2umPjdCGOAI92QAgwshP1kmcs63MXs2In/Qdo\
	dTMg2IbgBOgKpgJIuB0WXHh2wM5uMruuLCQQvwesBnShgdyF0ebRnnJYyy+BIFI8Hfg+ij\
	h0V9HyQr83Bw7eUjfuivPcn/9cqz3HXPBvc+OGR7Z8iFx+GpVwvPul7IMgcM63tXhOL9M0\
	LDKKvLFYFsQD2xMVO3XaJbGoUhAShBGOIYleHB5ZA/4ttSweimtjvbJtOAKFa7fLtimT+M\
	hlnGc284xNs+dnaKKtdy09UbHN0KdJhSEzoAMOr/JdlEHXQZDcDtFYyqYhYIo5b6UBZVfo\
	I5lK3rErShzMMo3CsFI/x9k4xqy1kyjh8qeO7NOzz35lGZb/VJ6PDPb0NLBi4vpxhkw7rt\
	OAOjEnR1fUU9KinThcpX9VT3IAKUz5MRIoMSRoOLqTXAzN8nd9OkQ/iTOavLvJv237jlB/\
	H1VfSkPqOv/PwjLQn7y8tvM3k0HLi23k7FdYR1emkP79stZ63zuOE/0mXqMkyejTaaOug8\
	ojaNG0lLldHDZzRWpP7XmGsE9cS/VBo/8iQQL5INaYP/BaIN1KJFtdpPE5zTatidAgo9ci\
	Z1nYIGZEbC6nyFaDg+mlGdmhQ5ivIQKWBwkbkXgMgtAMXHr+txf/s/iVgk5YhqA8p4GDXO\
	NdLXeXztc45xzcXT7/d/+QUD/o/nH2vWa+kwcipu2jI6QGGvnxpGJs/cUTwMo0/A6C7H6O\
	OO/H6HnIrTrjSMuvbUbmRuQeO1i9QykSicglHs3NYO7BpGAWYGRtUQur4+N3nFc4KaMNLX\
	qImK1aeylcM7ApT+flsO2QXUkxqrW3UpcHGPG1tJ71599ue/JBw+OzKzYnurQ9VVoq4XHC\
	4yDVLpSxV+c+j4yW+4jL/xHx9gNKGvKHPwT7/hYg5vthQSmRtQfV2kte6TmlBxuGmm1ddP\
	baZZE2buZloJhuIRYXSPkH8aJNqZpX4X3CZklzkGVwmDqws4PIOZFlHcmmm6TaoKUXiMmd\
	b17jUyS7yr4ih9PcoBLOLNmBAOXwYJABooc6bwZhSUkyG9CVdktflXVV38NcofRBGbUJXJ\
	lzd/7CPTLJz3Zl5oV+V7UtdFptsu1ddABid8W/K6LaUP6laE3g7rSTWiKwkLXe0zDYFG32\
	3r+PoS+2ucSl+mefZ1W/zff+0yNgZ9iFfKcOD45994Cc9/xlZT40iUUdfF/pKauk+jGeni\
	emlGLWW2ldG4bk6aUQ6ju4Vzvyece6MwuttCyBS7A/lnHDt/knH2NUPO/f6AnTsz5KzKs6\
	tNXW3Y010eo4Lrv3aukUDtDA4d1g7bd+1lpLQZrHZTD6HX+YW0WjMy5pTWhFJ7WTe0LHWu\
	oRmpNFZbGpzw97ZQ7UZ97mO8TGrn3BqFkr8kKU1ijHbhyo7QVzP60puP8N+/+wr+0a88ws\
	ce6N4s7alPGfLjf/linv3UrarQhsaRKKOuX/RzVB+3/vqO01piLWW8ZpQqs6uMhBN2Bs1I\
	zgqjTwijTxad4BknxSOO4hHH7vsyBpcLw+thcG2B21BtEozWojUh04axmpHS5nppRuOc16\
	i0SjPS2UDZOSvNSGtQ3kFNhhQOl4W6Deq46ll4bSa0QyjbEpzPUdUzcLuUmlHQbMTcEqF0\
	hiv4haH8oOlEt11qzSjSyDyAI21JILsI8kfVM8lAiuvH3Ukt/UFU3v8bm+ez5sNrvPgwbx\
	jdes0Wv/a9V/Gmj5zhte87zZ/et81DT5QbSV1+wYDnPm2LL731MC+79QiDTKjpU9ajE0aN\
	+nXBaFJQNO/PnsCoId0wyh8SRp8oyD9bdN6eaSR/0JE/OIR3w/DqguH1RWm+ZXsBI5vPjD\
	DS9z3k2wojCHZPA0aIB40/5zSMXNlWCn+sqy6+3GCm+XsS3UI/2lZNIQgjdQMDLQOwxgib\
	ApSGUXa8hm0No+sneXEm04iEG5patH6QOu0CYeQlc/CyW47wsluP+Exabmr1MsQwaq1X44\
	UP7Vw1GFnpgNG45yEOOSPk9+aM7suR03Omjy+pEKis6hxG92WM7stgWEJpcG3O4IoCt7Uo\
	GAUflYVROF4EjMwlKRgRvgqrYeQrEbSmaq6Oqm7wQ0mRgJFQDrnreoWw8iFVmpE/FqnvTd\
	WXVHw0hwnIjqr2Bc1vURpRKTd0doK9glErKHyg+hXReTRh1Oez1o36pdrRCiMr84ZR6l52\
	dKpEm4pHhfzBEcUDBcXJgpQ8chY+/YRjcwBPv0jYHCSTdcqDT8J7HnDs5nD1cbjtCn3vgR\
	GM7s0Y3Vtq2NlFwuDynOwyIbuwIDtaVP7RmWAU7svcYKTKbMAoaCEZzXej7LBSZB5GHhoa\
	RuKU5hEsD1fXTVTZ4ZoKRuFcqMPAlx0+h00CRr6C0aenRZWb13FBM3IC2ZG6X1VQc9cjIB\
	+7Bnfj/eNuZD8Qnfv5Lw2HT49vZkM9AtsxZoVRmywFRrYt42DUAop5wShV56psf3jOIWdz\
	ZFuQswVyVpAzgpwuKJ4o6mVTLfLENrztfleOJgMPn3G8+NrJtaUPPuSqz35/5hRccwKuON\
	qSWKB4lz+sGQAAIABJREFU1FE8OoQ769NuS3CHwB2S+t9hKc8fFtzhAg4J2ZHCq10JGFX3\
	xsJIvTv4+F4w0tdQ51/lq8wrmwaAwmtGUJpPAUaurENRGJ9MFsNAREEmaFO7wAbVxMpK/K\
	TIaoRMqBz/SrmL8taVrsqxaYNGpGHkrsbJBsJunzs4iUbkgKfpeqXH3OYMo4mWgmCAw+rC\
	qKOM3jBSbZKzOcWjOcWpAjldIKdyitMCMy6JefBJKggBnDwH2zlsTagVjYyytTsGgCmRbY\
	dsA4+Pp4M7JLhjQnZxzuCKEcPPG8Fw0TAyzyWC0SDOJ4JRrQjVMBIqx28Fo6CpaD+Qz6SC\
	QjDVdqlmQlemHur6PKpyCRqFgyhO3ZMKfiqNO6yuCzAqMsiuArm3z92bBETXAIeiM5WT08\
	oyYdSiKS0LRm3tNC/ipDBiW8gf2KX4sxHFozlyLm1WzSrHN+Pw1gA2J58Gyw0XCR95uGzw\
	0U244tgcKtchcs4h5xzFwxmjj22wsylsfP4OG7fs1J14T2BEB4wEPdcohtGg7vABRs7VeY\
	qDTM1DQpcXOo+HWgNGUuYfwcg7sGXg19HFzSnt4jBi59etRfDbgKD81DC6HJg7iK5unnLN\
	DqXjlgqjkAksFUa2PJ3etqkHjIqHdxndvU3xYC+Nd2a54hjceDHc+0QJoT/3FOPb6SnPuB\
	iuOCacG8HFh5XDeo9Edhw779miOJmx9aJz7J1mFPpICkaOet2Zo3RgUz5z52HRWLGvzTY8\
	jJzRlBy1KWph5DUfyX25Qu3A9uFiGGtgfWCUHYJ8h9rBLuDcZV3eFS2TgOgpjTPO1R089Z\
	BCnJZlwsjmm4DDqsKoeHjE6M6zFCcXsUNct9x0qXDTpbPnc3yzqWHttYw+ucHgmhHDp4Z9\
	nYlhVMkcYRTya4NR9Y54B7ZklFtt+K1GohX7TlXPlbOvM4ihg1KvwkREr31FQ/dhSkBwYA\
	/qehSifFMBjB5aYW1dBTQBDgNPqB92QNxVyX6dkEmU7CtaY/TcBi1VZ7Tnk9RK5y119Mxb\
	zja+ZxYytjDqqFeyjJb0osKSiK/KN6d0OBd233uGnbedWgqEDqKM7gw0tDO8u2Zfh/i+pU\
	j8N2jjBBj5jq3TVefCxmoqjdoBMp4xXRB/1noUp0OodnBMrkUL6exCV6Ha5zqala3WmumF\
	utmmako4KC5bBIgua5xxppNPBKNUEQuGka3LysKoDu++5zT5/dusZX6SPzxQo4WrAqMAHA\
	ujvApHcImWjxRemWuBUbUUJAWj3IDFwMgu/xANNrWro9v06UOTBeDK5lqltPQDUZlXQiNK\
	aBy9YdQGlDG678JgxMrBqHhktGe+oPNKBOSsBsqiYaQ0nwaMQkdXaSMYBWBAGkYpzUhiGF\
	V5WhgFsOh1Z2YtWQpG4SMAoW7FCNyhug01jHqvwO8FIn/fjI/IPqhwuCAYxYxYAIyUk00V\
	NDcY6XBPGMkTU4xxr2Uy2RMYhYwVFDSMIjPKwsjDRYJZrmFkzCykxUxTaQOMCrVXUbTgVs\
	FNcuLPVxdxfaP89XyOCkYn+t6j3qaZwKXNTM8HGNngnODTA0Zuo5dndC0TSna8wB3RxK9i\
	muG5w8j/rWAE7d9MK/9KgFYEIw0ODaOgGSmARd9U8zAKPqDGHkUWRhZMATxKI5OCaN1a1U\
	ZO9L1Bk/iILqogDsbrnzjuglFDVgRGukyJG9obRpKInxJG7pIN1jJfcVvC1ovP1aNOQZYK\
	I60ZWRiVMGjCKADDaEaiYFRBI0/AyH+mOnyFNgKONde0zyhoSVozyqkG4GMYXdD3rkwCoo\
	3Q/KqzjYNRldZK6pd+ehi1lxPiUmBIwKgBiuXCyG1lZFcuebz7AMnw+pzDLz9Hdkmhzs4J\
	RhOJhZGjHUYhnfcXVf6fYIJpM83+RcGoTTMKPp/gtA7+Iag/qJja5dH7kirtSfXfuqP0Bt\
	Ek84iqj6YJhkESHdTHjUmEWnR6da5rrpAWlac4P8coWU5I72juM+QDITxmwiPo7UP6lpEg\
	ZKMME67EMbz5KLuP7CI7E/3srsWLOyZsPG3E8IYR7lh4NuMWyaqoKhzmEVmToOW6sRIukJ\
	o5mYJPqpNVr2pIk9rl0dexyt5R7WWEXRALOD/3iMwDJVO3I6PeiD+ASkruBo3Eb/pf+ogK\
	qsW5ZUc50XfUrB+IykZFyzvKRanxfeqEUVL6wmhch4ZJtpytr50VRol6TbyxWjeM3KEBw+\
	eeYPddT8DuGkbjxB0RBpcWZJcXDK7MyU603LOlbawWVUKV6/xMaT+JMSpX1U/8ux7qbmGE\
	I15L5oj3MvJfDKnABfWExizxqmoY+TJ9cdE+RziqScRVs0QtQuuWSTZGOxRbYC5egtAHRs\
	mH1AKjXueoG+0CHA8ejLILN9j84gvYfd9p5PH1pEYAtwnuuJBdIGQnhOxCIbvYr8BvzNz3\
	sjK7PEaVUuWmYCREe1/7S9IwcnUdKhjpvYzwx2FmNQo+aufHxqvqahgRtgLx2pD4crQ7o1\
	rWwuFUl03JJKbZiWYHd77cBcBoD3Z5rK9dAIwa9RsHI9MWqxkdHbL5xReQ33eO/ONnkW3d\
	gQ6gbMLgEnBH8Nt9UP47WuCOCW4j3Ht1H8J9EwwoNHzmASObzzxgpMoXoVregas1HbOvUQ\
	0joV42Ykw1LIzEaC1QrV2TFIx83hTg/Ir+at7TLrgNGnuIR9uB9JNJtwFJdvCFaUb7GUaL\
	2OXROQbXHWJw7SGKz22Tf3aH4uHdmbf62BuJH0Q8fhDHDa8Vtu6Q2gfsIHXfynufAsWiYW\
	QXydoypoGRaqP4/5zSjIB6n6I6eQkjIV7D5mFUFFTfaq9g5Mp4h9FqPOyi5gj1Kv2wl5Ha\
	M4mMcvTNf0lEd7gKRv3ezek+EhZ13NAhx8EoJF8hGLW2aTIYtdZrETCizDO7eovs6q2yOq\
	dGFE+MkNM5cqaAswWyK7Dr/85FeeoCSTN+2iI2bxU2bjLZNd6BGgztMLLX7QWM9MLZWWAU\
	gKBh1K5Bt8PI+UWx2oSrLqLawdGFz1iHNoWyw2eqEw5sDSM3UnUzMOop03+tUPCbndc6Xj\
	eM1IPdaxi1tqENFD7QE0ZL3XLWgTsxZHBBvFNZtH1ILkghpeZU/aiW8bv37jK6e2dOsJpe\
	shOw9VzILvEnxoJiHIzCc1oQjHQdFqIZWRhljeg67PteBs3V/QUUTq2k976hLADHUX3yOl\
	qxH5pjHdhBSwp7Jqn7UNWt769/LZOMmplzpqOuMowm2j6EPYCRbcs4GKXa2V1G9BwGDjdw\
	sFHHBxht3rTF8PM22P3QNvlDe+8Id4dh4ybHxtNQr0lo+wrDqHoXLIzUuxPqOBcYBVMojt\
	Z1LDkS6hq+DOJo7PLIsJzwGG2sZhzY1aJcdQtEIPNakmRmC9swXylTz7ClfyZkklGzHRz1\
	7LrGyvuDBiOb1wrCqFHPDhiZMspql+HsWMbW8w9TPJqz+4kd8gdGfd+fqSW72LHxdMfw81\
	xtOoQ6zgtGIb8GjIzsFxg1viariqpgFL4M4oEjCmJFAZkaci8wG6vppjrizxJ5TajIfR74\
	6305Vfs1MOXxvi2dxDQ7i7Cpb6ZzZecrO3wHjOor2D8wclT2dJXXEmGUbGfi3k0JIwSyiw\
	dsPe8wsl2Qf25E/kBO8UiOjGanktuA7BLH4CmO4TVZudarqncCHhPByLbJgsLCqMd7tYow\
	ctD4TFErjITW/a/DlrMVjKjbglBNUhQUjNRnpSPWOMqh/VyF9cTGfq2c3EdkfoW7YFQ9lK\
	hC+xxGNt8EHFZ1l8dUGRZGOHBbGcPrNxhevwECxRNhM/6i/ALItiA70pjt7QbARvnde7fl\
	cEcd2XGHO+7KiYW+jtXXZKN6zwKjuNNPDyPMfZwSRlH6ul6Lg5Fg5xrFMFI7L+KoJzhqzc\
	YfVHHUaQOMtDkWTWosKDfrD4VXMDrTt4WTgKi+wwYqbTASBJeEUXx9edgBo1XacrbxMhIy\
	Ro8kLh9GROFpvgxS/jpCdkEGF2QMsPfNdKrG81BhdQ+jT1uvFIxS93EKGHUtBZl5aN8lYO\
	RIzTWqYSSq3aG+3kQLX+6IYCRU+1xXyzb8pEX9eaMKRo569X+m6/lE35GzbHyS6hY8Fp0s\
	4hvt9AQm3SFDpeqkxE8hUq+SHKk7oz2fpFbiHBFHzo8tZ5ttlI4yZKoysjjc2Yb4HkZ1sX\
	k2yrT56DKzOG2jTaFjmDpV+Yxroy0jdY0tIzP1NO/PxCv2o8pQmVDV7o0aNkUULuce5ura\
	EO+BU233Ks3tQ6K9jCBaJFttOaJW5QPRD4nIyb6t6gUi34THmifjh7kcGKVqO+bnZlYY2b\
	pEnXH/wigK7xmMbHk+z0aZ08Eoym8WGDXE1nuvYRS0uwCjULj4d7AvjAqaG6tBDSOfTm8P\
	olfsIyWMZKTaW8GoyYwW6Q0i4LHGfXOsAIzaXpox0FoIjELcgmCkwzPAqCllHmLzPAAwqt\
	s0I4waWpHOo62MvYaR1owSYb2XUWMzfqMZBQBVG6sVKl+913XYCiR80yyC0cm+DZwEREbN\
	EkqbVBfeB0ZRUuIHs4ZRMtwGhilh1NSK6jyWAaN0eSkZA6PGu3S+wSgU3IRRdQ9kZNIobU\
	d/lUOoYcQoNseq82rP7WJHVauC0UJA9FhoZlmYHwZsgRE6cQQjDSma1/SFUUNWBEa6TOOo\
	mwhGfTWhAwAjse+O7dRtedgyGoDbKxiFuLYy9hBGKU2oASP7ZZCg/QQY6XC4PrGxmt0oTb\
	/gZXsf7NuuiUHkm958yQ2MnN31cN4wSgFmL2GkXyYNo8YLHje0N4wkEb8nMDLVXkUYNVZ7\
	LxtGiR/fhe/yqEXBqNJY+sAIWmEk6ryFUeXEDvkUUIT1ZhGMHujbgn6tL/M+GZ8SSgBpaD\
	AZjPR18QHNTpqq2Hxh1F5OiEuB4qDByKm4acvoAIW9fmoYTaoZ+ahVhlGXtjVWNIxIwKge\
	Tau3nG2DkTK7UjDS29FWmpieR1Q1+P50H21K/5YLn2ue0jDyBU4CI/1QumCUGi1rXhif66\
	vq6k7Z6ACp9IuAUZ8yUulsGSaMCu81jGz75g4jNyGM6utnglFUXh8Y2fA4GDGDiL8+zHLW\
	MAL9DTUJZk0EI+PAbsBIgUenRUB2zPMXgM/OdR5RKe7+5s0t/KkJYVTnORmMWtvUF0ZjOr\
	RbFoxS2loXjFIv7hQw0sX1glFLmckyEn6PlYRROJGoUyrcOVpn0ktcZj8YzeIv0uW0fBVE\
	aUdNGBntKYJRcGCHOKsZ5XWaqh7SUF7apCeIHMB9zV89ARc22pgARi5+CAuFUa9zrCaMGv\
	UbByMbHqe1TAqjDgAmy1gSjBrldcEoBQqb5yJgZPOZM4zwZlYEo3C+PjcWRmHUrDLboNqh\
	Mfr4YtgutoLRLvBQ39pOYpR+tvyjXrRqy8hwaloYsTgYdYwONdPW0SsBo8YLb9N0aE17Ci\
	MrY2CUSh/VZ0YYdY1ymuuXByO1FCK6Zk4w0s7rVs0oASOdLnxeGqH+tJCCUeXYtp9FL0C4\
	xzujeskkIHocOF0eOt+OsL7FvzghrhVGtMDIvnio57jiMGpcOx2MWuu1L2DUcn/bYDTueS\
	wMRlr6wMhet1cwUnWcO4xC4S0wiuYJhQmOyvyKvgjrr9dziKr6F3eD4J7zaK+q9gLRkW95\
	Yzi8PyrQL27tD6MyPBuMwqkVgVErKCaD0WQTHm0l+sAocc1ewKiSVYCRTT8ORqG8BcFI12\
	EvYdQyvB/DiPi6IhwrB3bl4N5FW0e+/ndPUs1JRs0A7ovOFYUvMwUjmjBSHXR6GOm4PYZR\
	mywFRh2a1FSgaOY5EYxS+VVlB+kDIxt/gGFk2xC1cYEwgvnAKCySrZZ3RDD65CRVnGzigh\
	gQSUG1AVIDRgFA9qbuYxh1vQytWsuKw2hMnktdsV/FLxFGUXkd4DwQMNKjaQE4xNdVMBrV\
	4crRjYbRJ1v7VUImnUF1V/wSBe/5HGBUpYPmi6dlP8EoAadlwiiVX1SXdJ7nNYwazynx/v\
	UuY1VgpFbst8w1qjUjCyPjwK4ApsspAD4+SV0nBdHHCXXShTo3O4yqfmhfNBcF48B+gZF5\
	AZcFo96gaOa5GjCydbHXzAoj26aDCiOoYVSbZbF2JAZGJj5ad5bbdo8QPjZJtSbXiKoGhb\
	/h65CLgVF5L+YAo1XaWC3qgG3lrmHUpc1FMLJ5NsrsC6P4OU0PIxueEkYt9ZovjHzBLXON\
	Yp+RmkkdYCS79XX1vf04FHZMv1MmBdGnKPWxur6F+u71pDASlY5pYASNk+tdHtPpp4aRCS\
	4TRuYeri6MUvexA0a6zhpGDQf5XsGoTTNyRPsYIZ43hc33LgSy5/beF21iEO0CkTdcijyG\
	yyQwcjQe7srv8jgvGNm6rCyMmm1cvV0eQ8Dk2ShzRWHUMMtUeCkwCpWwMApKh1DPJwqjax\
	GMPjRpVXqD6Oi3vSkc3hVFFH6LyJlgFD/Mld7lsXHZImDEvoXRXm8fUtfFlufzbJQ5HYyi\
	/GaBUUNWFEap4X0RYhhJfV0MozvH9h0jk2pEEBzWQYpRDZw9g1GUlLjRewCjmBELgFGIWx\
	CMdHgGGDVlFWGUqGMXjBrvkm3TjDBauV0eScMIGjAqgxZGWhMCD6MPTFqhaUAUq10VKaEB\
	I/Dako9TMIqANTGM9HnsQXy8H2GkyzTLdSaCUV/4TAmjVdrlsRFvO3WjzBYYNfLcKxiFuL\
	Yy9hJGAT4kYGQ0IezQPeeg+OikxU8Dovc1zuS7KisFo/A3ASMJaaETRsBiYdSQFYBR4wWP\
	G9obRpKI3xMYmWrvEYz295azifd9aTDSo2MYGOFhVFCuvm88/w8i1eSj3jINiD4C7ERnqp\
	G6LhjRDaPqOqKHObctZ3UekbT8qk8Jo/ZyQlyqUx00GDkVN20ZewCjLnM2CSMfteowmkWS\
	MApakDHTqoWxUTvfB5A979RExU5T613gw/qEFCMaJlcDRpl5YAZGi95ytnVzNptenesLdd\
	0pGx0glT4Fillh1KeMVDpbhgmjwsuAUVTXecPITQgjO/tanZsERlF5fWBkw2NgNItWBCZv\
	qf+auUaiv4FWl//+aYqcCERq5CwuLN8tO0/lH+qAUSQpGLkqqhNGKo+93XJ2TId2y4JRol\
	6dMEq9uFPASBfXC0YtZbaV0bjuAMCoc7TOpBdT514wmtFEq+oY/D8pGAXNSGtQDlKumx4y\
	uUZU3v24sMLv4JaEES0wiuMnhpGLH8J6l8eWei0aRqZTnZ+7POq0iTqlwvsdRko7UjAagV\
	u8RlRXUBIO6x0cWQJG5kY1YFQDYmVh1DE61ExbR68MjBr1GwcjGz4PYdQ1sGCuX94uj6l8\
	5gwjIAkjI/4+v1+kODf2HUzItJ6tD2C3gfTfNWqFkfYhtcEIZoQR5zWMWuvVeOFtmlT5Ot\
	xSxtxhZGUMjFLpo/qcDzCyi2RtGfMcSasKJZWpiHsXQHbHExMXMy2ITgEfi/TSfKfqMC6A\
	pBVG1DByNOLHw4gWGNkXD/VMEtBYJRg1rp0cRpPv8rhqMBp3f8eNpNk8FwUjLX1gZK/bCx\
	hl8fHcYZTM8F3TaEMwBYiOfvubw+Hbyjp5O3G0DS6r4OG05tGAkdZKumAEaRh54E0NIwPE\
	vYRRm7SCYtEwakk/ldbSLGMuMLIdbOkwsunHwSiUtyAY6TrsmWaUlHdOm/0skw7eXh2JlK\
	ZZkccwcj77qWFkYUacjn0Io74mmr52oTBqB0UaRj3aPguMUvlVZQfpAyMbv4owStWzq4wW\
	GNk2RG3cMxg9DpPtQaRlSmc1AH8cnxMkP1ceLxpGqHQoGFXpoPni6cv3E4wScFomjFL5RX\
	VJ57n0vYyWDaOovMT717uMlYXR21In+8r0GpFwFxBvOLK7XXeSZcCo6of2ReuCxn6BkXkB\
	lwWj3qBo5rkaMLJ1sdfMCiPbpkknPE5WxgrB6I8ABl802YxqVaOppUB4hz4ho7NogHTDCJ\
	V2sTASqG9e9Iz3OYwax82OuIZRe6de3Y3VSNzHKWHUUq8FwOiPZshtOhAd/Q7jsA4y2vF3\
	XsOohk0MI0XtWWBknLoL3eUxylPJsmCUBJMjps8qwMgElw2jqLxVhVHqPk4Bo9Y5RiGe6a\
	WG0S7wrhlymnWFHG+PGyJIvk0MEP/Xg6UBI8dsMHI0Hu5ydnlcEox0XVYWRs02rnd5VHWa\
	F4x0nfcWRu9BinMz5DIziN4B5FFDds8qqNSmWWmmweJgFD/Mld9yVkWvd3mM81itjdXmB6\
	Mov1lg1BBb7z2H0R/C9P4hX4OZ5DTwJ2Vl/Jld7yfSRSRgFJlu2PP7FUZtL80YaC0ERiFu\
	QTDS4Rlg1JSDC6MDvMvjm8b+4I6RqUGk/ERvrE4KyO7Z8tjprJswqpaCQA2jMpCAkUvCKE\
	ozFYzibNYwaisjkX5qUMTh/bHLY0rGwKjxLh1YGOXM6Kj2Jc8gZaXfFJ8TGJ0rO8W8YBQe\
	uoGRhLjq+jSMVF0NjDSkaF7TF0YNWREY6TLXW84m86/jQnnm3bGdui0PW0ZyYGEvYBTi2s\
	qYO4zeTWkZzSSzmmYgvA3Yjk7tPEk1dB/BSAEmBaOoSjqt/yt0w6i6juhh7rddHieGkX6Z\
	NIwaL3jc0NXe5VHHTVvGHsDIwmDpMEr8+E4Do/7yFoDB82dj0ewggnNIPMtadp6kho2Gkd\
	FyLIysydWAUWYemIFRNMOayWCkr4sP6uNGB6eZxp6bEkbt5YS4FCj2Gka2nvOGkVNx05bR\
	AQp7/dQw6rpvKRj5qFWGUX+t6E3jk4yXmUB09FWVn+jNUcV3z1F9eC0FI3vcgJEFloFRJW\
	0wcnV0Xxjph9IHRkmZBEYJ0Z2y0QFS6RcBoz5lmPySZSTShPBew8i2b+4wchPCSE+qNOcm\
	gVFUXh8Y2XAXjHqZaLvMwT/kS5uL/K84KLBzpoRMeHkXBqM6fioYqTwWustjorykKEaszM\
	ZqewEjXVwvGLWUmSwj0an2AkaN8sbBKJxI1CkV7hytM+klLnNOMHo7cKYzRU+ZF4jeDZyK\
	ftl2Tiv4KIi0wagkUQeMaIFRHD8xjFz8ENZbznbUq1FGIv1UoKDRqda7PLbkuRAY2Xx6w+\
	j3YXb/kKnVTDIi2Iq+0rJ9itgsq2GThFGVpg1G5kY1YKRe1CjNpDBicTDqGB1qpq2jVwJG\
	jRfepkmVr8OJPBcCIytjYJRKH9XnfIBRMAsnhtHvJ89OITODSPmJXludFModG/VmaRVo/A\
	RF7ZjWMHIBRi4No8ghnYBRNeERFU7BiBYY2RcP9RxXHEaNa6eDUWu99gWMWu5vG4zGPY+F\
	wUhLHxjZ6/YKRqqO8bt3Engvc5J5aUQAr49CUmpFLoCmASMNlRSMJtjlUc/MbsAI0jDywJ\
	sJRir/VYBRKygmg9GB3OWxq1MtBUY2/TgYhfIWBCNdh34weiP1d6dnlnmC6DPAB6Iz554A\
	l3mguDEwIg2j9S6PaRi1yVJg1A6KNIx6tH0WGKXyq8oO0gdGNv4Aw8i2IWpjEka/j8zHP6\
	RKnU2S5hkg26dBihJGAUCtMAqQ2CMYodKxD2HU11+kr9XhVYTRmDyXvn3IsmEUldcBzr2B\
	UWwBzSjz1IgAficOSum09qZXfxgpKC0DRroOKRhF1+q/oQ7pm7NcGJl2LxtGqfyiuqTzPD\
	9gZNs06RyjycqYAkYfAHd/s9DpZd4geifwqD4h3jxLwyg0LjFK1gtGqLRzhFHVD+2L5qJg\
	HFjDKBlug1FvUDTzXA0Y2brYa2aBUfyclg6jZr1eB47BC+ZjlqVKmlVyjNNazp6MNaAIRj\
	VkumFUn1/NXR4nhJGZLlC1oZkwff28YdQ4bnbENYy6ylPP3+bZKHOvYWTDU8CoOaz/utZ3\
	c0qZG4iUnyg2z4qRmtwYoJCAkZ6s2IBROA9JGDlmg5FjDjCCxsk2GEV+KH1+STDSddEv+U\
	ptrEYjvFQYmXu4ujBK3ccOGOk6p2H0CLipv1/WJvPWiABeB+zoE3LmpAeO0oAsjKK/Girx\
	NYuHEdX1K7/L47xgZOsSdcZVglGzjestZ1WdJoFRQ+x9aoXR6xHy1ndySlkEiB5Hb5YGyN\
	lHqUHSE0YKGhPBSGtRIe6g7vLYuGzeMApxqw2jpvjn2+iofcuYFUa2PJ9no8zpYBTlNy2M\
	pt9YzfuH4i+JzSpzBdHRV705PPxfiyJG28juGZIwgjSMGg7lNIwiP5KeZb1nMIqSmjrvAY\
	xiRuw/GOnwlDBapY3VGvGd0BwDo8a7ZNu05zDKIfu9sT+KU8giNCL+d3tnHjbJVdf7z6nu\
	fvd3kslOArggKLgFLhdB3AKyKSir8tyrIKgQFi94UZRNBRVFuRcQkrAEEHJBCIYASZQQIA\
	kmZCE7JJOEyTLZZiazz/u+8y7dVef+UUufOnVOdVWv1f2e7/PM81adtaq66jO/c6rqW1Ly\
	FbSvr8kj+8CrkYGRqIUFVMioMOqbyyPR0C3KS0VcnWEU1kcpF+b1zeWxqjBS+3Quj8b223\
	lxf9q5o1/UmT4tMMoAblgwivMyfVyJ5MDYgAjYJ2Xo3BZLHtkXLqRA04ZR8m5ZpowOIwUw\
	g3B5tMCoby6PeTDKqAIwypzg6R11Lo99glFqY0cNI8N/vmEfFwHUnr4vuws9qu8gWnjtpf\
	Hil1MnaXNV87K2wUiBiBFGGlisLo82GHmdYZTUoxyMlKragrYMhQHTA4zs/cR5potq0mAk\
	lLxu+9Auk0HAKG84a4RRlDVcGPX9tn3S8kBaDXU+2s8pV/aCqBWDUeoWvgVG8XJVLGelVi\
	+90F7OXOBky+hpHSdoybQ5Hi6PaHlqH9o6yvqwYZTnTa3X7wpGoiSM2vWH5PK4A8mt4wii\
	h4Cr1BNUrjwcQUODkQobzwAjiRlG4+7yaFVRGHW4oMWoYGTYrlwYmf737QJGaneFYGTp09\
	ZHpt4EwKj409dfA6j90h4GoYG78FvEAAAgAElEQVSASBmenQftgyQ3jkAz/sKHAiMVSBhg\
	VNRyNiRRDoywwCidXxpGKag4l0frdg0aRt0+fV24Dy97DIcBo0x/nWAUJxi2ybReDEZftm\
	9U7xpkRATwBaLDkcBoebcCIA1GMZAkZhgpsKm2y+MAYdTL09dqmrH8EGCU2b5OMNLXNyGM\
	8m4saPUH5PK4B8LPSg9KgwbRQ9C+eyYlBEu7w+eGRAwUA4ziCCj2Mura5dECo1Q9A4ySZ4\
	zUMmVhxKaGkXW7Mie8XsbUv7pu6aPvMNLVAUam8qntGWsYXQD9f5pa1cBAtPDaS+MD8G9q\
	umyuIdcPRzCqtaMbE4wiwHTv8gilLGcFmfzOMMICI/3Ea1c3/qBVglGmrnahFoBReZfHqs\
	Go0/HtdFtfb3NQMFJVBEZ6vUIwOg8JtV9+mEFp0BERSM5De/csOLyL5PWOVEQ0CBiVsJy1\
	Pn2NVh8FRhHwuoaRBsRhwsimTqAYGIws5buKWrJ99AVGqTaKwEjP7zeM9PKdYBT3VxhGh5\
	HetwYZDcEwQAT7kVysJgRLu8KLoRsYJRGODUaYYZTxMioLIx1mpMsxhjAqOkRT66rrfYeR\
	HRRmGBXY915gZGov6TtWJxiZtmeEMEr1lwOXdt5FwPpYg2jh9OTu2edTP5a/gVzZi4xAY4\
	QRmGGUekPfBCMVGDBwGKGUQ4GRug0TAyMDnEYJI1N7qW0xtzlyL6NRwijzOxnOv3Qf4bDs\
	V3Zl8/uoYUREAF8FltSE4PCDgLBHRp7yDloujOIf1TAxXQhGKGX7CKPkOtRPtDxoOBgZ12\
	0wKgyKbJvVgJG+LXqdXmGk71NpGK0hxcV64iA0LBCtAueqP5Rc3g1BC4QXXdzCAiMFOEYY\
	tSHTHYzUxwAGDyMJ7R8+9buPOYwyy9kL0cHIDo6KGqtdDCxbz6E+auAgUoZn/wq0D4CUyK\
	VdSbQjI7DYYaRNVJtglNz9ssGonV5Ny1nIJObBSBgqjwpGGVDEDctUmdHDSFsdNYxS/VUO\
	RucB1H51J4PWsCIigCuB7UByAIKD9yO8WgZGQAcYiWQ962WkACMDozgdjDAS9AYjQebHHY\
	3L44hgpG5LZWGU3Ufn8qhsUxtGLbTPgw1SwwSRBD6rrsm1g8iN5QyMROxRhBIFmbyMrDCK\
	gaZCJV1nsDBK/89SectZJbsnGOnbkroYxxNGm9jl8VtIcYAhaSggUoZn56AeWgnBgfsAYY\
	ZRMmzqACMwwygzh2OGUWrothktZ9OMGACM4hN8QDBS13uAUVaTC6MCL8l+CYYzLFO2YkiS\
	3Atpw7TgwH0aHAwwUodso3R5FNGPboBRqkxXMEo342DUoQ+1fNegSK9XyeUxk58LzQ4wyp\
	xLHWHUAs43nicD0tBAlERFkrNTGf4GwaGHwpdctQcZMzCKgWOBUdvlcYAwin90DUYyzkvq\
	m2EUHQOlXJg3OS6PSlsmMIIGI321IHwybXZYV8uPCYxG6PJ4MTL9odRBa7gRUajzgJTXZH\
	DgXuKhV2EYpUBjgpFeRoeRBi0dRkBPlrNJPVIw6pvlrNpGSpYLqUsY2fuJ8/IuKtr7l7mI\
	0ztabZdHNa/bPoYAozzzNiOMoqwsjL4IgtqvPZjtY0AaBYjWkXxGTZDLDyM3Vi0wEmYYab\
	fyszBSIGKEkRbl6DDSh1wZGHnaSajBSAVaWRip9dIL7eXMBU62jJ7WBYxkbj9JIa3uKGCk\
	5ql9WNorDSPThdsFjFLbOggYlYmM2vUVGK0TmaANU0MF0cLrkknrT+ondrBvewQYHUYxdE\
	Q+jFKwGUOXRxVG6slTBEZGlYGRQepFmbkATOUHAaMSfej9pfowlInXe4aRpU9bH5l6/YaR\
	6BVGF0kpDjFkjSIiArgNuEL9UYID90ZHwjPCSEYQESpMbC6PQgzQ5dEGo3R+VzBKVDGXR0\
	YFI8N2DQNGandFH3gs3Ic3Ghhl+rPC6EsgqJ32gL3+ADR0EClR0ceB9sFsrRMcfgA8j+SW\
	vRFGXj6MVCDlujxaYJQM9/JgRAcY0R2MUhFOxVweqRCMMtvXCUb6eqeoZQJhZIySMjBaYQ\
	TDsqT3EelLEM3MRwcz2HNnCBYvnpTuEUaSDjAiH0bYYKSd+BkYKSdqqkxZGOFgZNquzEWl\
	l+nQv6nNgcBIVwcYmcqntmfgMLoQxJFOWzUIjRJEa8CnkjVJaA2yejALo2RIZoMRZhjFwz\
	HRq+WsMMMoNSFtgFGU3xlGWGCkn3jt6kZoVAlGmbrdwci6XWMBI8vxtcGo0+8xMBgl+iII\
	6s+4z7Adg9VIQKQMz85E/SkkBHvvDJ8TUmEUQUYoEVDWy4g0aPToKBdGKlRMMCrh8phrOQ\
	tmGEXA6xpGGhCrAKNOoCgIo4l0edSHRCOHkQdwGPgPQ+dD0SgjIoB70HY+2Hc3+BsWGHnt\
	i9UIIw00NhglEY4NRphhlKR1gNFmcHlE2R+bRgIjOyjMMCqw773AyNRe0nesIjDS8/sOo6\
	8hxXp+x4PTyECkREUfSWUEPsHe7VH0I8wwik3TEPkwAjOMkmUbjJS6SRsDhBFKORQYJeVI\
	8ioJo6LzRVrdZL2KMOrQ5sjtQ/oPo8+BoP6MexmFRh0RAXwDuEtNCHZvA+IXYaMDboJRBB\
	ErjBKXx15gpAJtyDBKrsMcGKXqqn/jbTAU1cvFGhqMDHAaJYxM7aW2xdzmBMFoN3AJI1QV\
	QBQAZ6gJcmMleiu/FgInfrcsD0YqYDaT5Wzq3BwUjCyaFBgVBkW2zWrASN8WvU5HGH0Oic\
	8INVIQKcOzTwHLap6/6wcRRDQYxcM1HUZiWJaz7fRqujyWhJH2uECyD0XVbxhllrMXooNR\
	Xn/K76+3mekzqXcOCOrPvJtRqQoREcAh4JNqglx+GLmyJwsjoUDCBCPlGaCuXB5TeSYYxe\
	lghJGgNxgJ+gAjyCTaYJSaFFfTRwQjdVvUC7dSxmpk1kcKI+15oJIuj7cguYkRa+QgUqKi\
	DxEO0xL5O28JT0wjjNLPDU2ey2N8FLqBkXrS9gIjQ1mb+gUjfVtSF2OVYJTdx+pZzur9RW\
	2m2wijoV+/i1Fq5CBSdA9wvpoQ7L8HuXFEiUxMMGrP++S6PHYLIzUKAkrBKAUxuoBRGzhh\
	1rBh1AEoORorY7VMH5b2CsAoq+j3zcx7Fe1joDAKiO6WjVqVAJESFX0wlSElwc5bQngkd9\
	AsMIoAUynLWdT0YcAoVVTb5iHASI8Qxg1G6nqXMKqSsVomP/tbXAIMxwu2gyoBIkVXANep\
	Cf7u28BvaTASuTBSb9dX0nIWoqFblJeKuDrDKKyPUi7M65vLow4jQTVglGwMGoz01T7BZw\
	Jg1OG2/mcB6s/6oWF7h6vKgGjhdZfGB+n9qYygFc4VeXUFRgpEDDCaGJdHC4z65vKYByPT\
	+qhhlLmI0zvqXB5LwWgJvK9k+xyNKgOiRJJ/R3vA0X/oZpBBBkY6cOwwGrXLow1GXmcYJf\
	UoByOlqragLWOBhOUE7RJGHet2mr+ZCBgJJa/bPrRLtnsYnYfkiAORXT5Si4paawS7fgAI\
	M4xSt/V7cHm0wSh1C98AI33ZCCMVWAYYJWU0GKnRVRkY5b4KoixnLnCyZXR1AaPxcHlEy1\
	P70NZR1ocNozxvar2+HUafAag/6w6qoEqBaOH1yaT1Z5DsVvP8B25QgOBZYBSDxQyjtstj\
	QctZ3csoGU51AyM9etJglJIJRiLJyoWR0sbgLGdN/Vk0chgZtj8XRnqe2oetTQOM1O4Kwc\
	jSp62PTL1SMLoLxOVUSJUCkaJV4IOpk3h9iWDPHcpT1h1g1A/LWQwwEl775M2DUTScmgiX\
	x6LQsWkzwqjbp68L9+H1AqNPSYm0/iczAlUOREpU9FHgsHqw/R3XkDy8GMNIAVAKRv2ynJ\
	WYYaTAxggj5Q7daF0eBwijMoCqIowy29cJRvr6WMLIBz4Ngvqzb6cqqhyIFB0EzgKSgy1X\
	D+A/fHsIBvUOmgKZDIzGxuXRAqPkGSO1TFkYsalh1Ja2bnzXLQ9GZUGR7aMClrMXIUUlnh\
	1SVUkQKVHRhwgtZZOD7e+4KoKMBqPkTXzPDKOquDzmwog2jASZ/M4wwgKjODroBCNlG6oC\
	o0zd8jAq7/JYFka6+g0jUzSnpnm5/WnlzwZB4znbTBs+MlUSRIp2Ah9TE+SR/QR77iCZ/9\
	FhFA3ZRDTZbHV5tMJIA80gYAQWGKlRSR6MwAyjKPrqGkYaEIcJI2vZDqAYGIws5cuAYtAw\
	SrVRBEY8xAjtYPNUWRApUdH70KKi1j1XkrozZoRRrTOMoDcYJRGODUaYYZSkdQsjHWakyz\
	GGMCo6RDP1MxAY2UFRCkY5bQ7fclZ8AkbrO2RTZUGkKB0VSZAre9qfHoohkgej+Jb+yCxn\
	1TYGCCOUcigwUrdhYmBkgNMoYWRqL7Ut5jaHaB/iA58AQeO5t2a3c8SqNIiUqOifgWaSIa\
	F193ey80OpuSEFRkUtZ1XAbCaXx5QMMIqOuVEORub+1PLVgNEFSB6koqo0iGLJ8AB+KpW2\
	vIdg161Qq5OavBZeGzY6jCrj8miDkfoYwOBhJKF9UaTO7TGHUWY5e+FuQhidBdB47g+ooi\
	oPojgqkpL3okZFQOuuywHPAKN4GCbMMBIKJHJcHu0w0iaqTTBK7n7ZYNROr6blLBgTuwRM\
	mbI9wygDiiitUl5GZNYHCKO7gEssP3AlVHkQKbpPSs5UE+SR/fgP3oAdRvUOMEq/EtJXy1\
	k1qjHCKE4HI4wEvcFIkDlhuzdW01QmAhoVjNT5scrCKLuPA3J5PANZ6pcYusYCRItvaN9B\
	k5IVNc/fflm01AFGMZA2neVsGzhhVlkYSYxEGBSMUtV6gFHqbqG2DWMKoy5fkj0C3qdB0H\
	je96mqxgJEinYCH1FPHLm+hP/AddEdsBgMBhjFE9ZC0JPlbAyPYbk8ptJHAKMgZSOe1iBg\
	pF+UfYdRfBEPCEbqeg8wyqprGJ2D5GA2v1oaGxApUdE/AYfU383ffhky8CO41NtwMMFoUl\
	wehaAXl8filrM5IFLLdkrLS+9Qbqxg1F3Uklnvo8vjhwEav3Gzob3qaGxApGg/8AFk+/jL\
	jRX8u/8LvLoCo/aktBlGCkQG6vI4QBhhhpGM85L6ZhiFBw+lXJiXXPgS7WK1aNxgBJhhpK\
	/2KRIaHYy+DVTvoSGDxgpESlT0f4B9Koxa9/wXcmMlC6NojkjE0YrN5bFbGGl3z8wwogOM\
	NGjpMAKMMIr/SvJhlNQjBaOOLo9BiYdwhwCjjnU7zd8UeMYotaq3ofchDflDgZG22fY+Pg\
	SCxm9WOxqCMQORomXgPQAJjPwmrTsviUBjgJFX6wyj5J8NRqO2nFXLqDDytJNQg5EKtDIw\
	KhINqRowjJzLY7Z+Dox+CFxo3rDqaexA1I6KxEeB8Bu5EYz8+7+HXH44gkgOjBBmGPXLcj\
	YFmzF0eUxgFBQamXXU2MPIAJphuDyWhlGqzw8hO03wVUdjB6JQApAbIN6eJEmQUtLcdpEy\
	YV0zwyieZB6Gy2P02MBgXB5tMErndwWj8ICGS2Vg1Ct0CrS7qWCkdlf8Jdn9yND8rPGbI/\
	+adCGNJYgW3/BtooN+LojvJRkS/N3bCPbdrdyyjyMbA4wq4/JogVEy3MuDER1gRJcwypvE\
	7aAyMOqy3crAKLN9nWCkr3eAUXevgnwUOJK/sdXSWIJIkQT+TP/Bmz84P4RIAp0oQkreQd\
	NgVNTlsVsYxRHQOFnOBtkr3MFIq6+3b+ojA6OcSEmt0z2MmiA+AtB4/o2Mi8YWRGFUBMB3\
	gAvVHyM4tBN/x9XJxHUbRvV8GCl3zsbXcjZuQx/iRRdU0rYNRoQwkoHxAh9LGGXqdgejti\
	oNo3OkZGfH6K1iGlsQQQpGbwVa6sFv3noh+BtZGHkRjBD5MKq65SxYYKTmRXAzwgjMMNIu\
	wnGCkbVsB1AUhNFgXR5NKg0jSWiZQ+P5N9garaTGGkSJpNwGnBGuRBfbxhGa2/4zPMFUGI\
	louVYnudCtLo8FLGfBAiMNNDYYpeaITDDCDKMkrQOMunZ5VG64jAuMig7RkrqDhlFOJGWE\
	kQmo+W1qMDofqM6nOUpo7EGUREVSvhvYF66EP07rrsuRK3vbF7oJRmPj8jgkGMXHrwBpJg\
	NG2noVYdShTQVG7wPB1AvGKxqCCQCRogNI+a72qgAZ0Lz5PKg1lPkfzwyjobk89gIjFWgD\
	hFEJOIw/jAxwGiWMTO2ltsXcppTiUim5NltxPDQRIFp846Xx4ieQUrGgE/i7b8N/8KY2jJ\
	JnjIQRRm2XRwuM4meQbDASXgEYKcM1I4xiKBjukhWCEUrZbmAky8FhM8GI9vrojdVSZaJo\
	6HrGURMBIkUt4E36f9PNm84Fv5WGUfIOWh6MPHJhFA/XRmY5207vr8tjpIJwkLayNg2h7M\
	AsZyvlZZSUvQbJxYyxJgZESlT0beD8VBi9epDmbReFoDDBCGGBUTwnJMwwEgokBuHymMoz\
	wShOD/ezb8ZqqoYJoz5HXJvI5fFvAKZ/6zrGVRMDIkjB6E3AERVGrTsvITi82wwjrx7CyL\
	k8OhiNn8vjTcDXGXNNFIgU3U/ydn78PIxk4/r/R/KwoglG6isfo3R5tMFIpKFRCkbdzBmp\
	GjcYpar1G0YxKAYEI3W9M4zejRRM//b4RkMwgSBSoqL/C4Qf+I7OkGDPD2nde1UInRgEJh\
	gVdnm0wCgCjBVGogCMIB9GicwwSs0jlf1Mke26HScYSX11jGCUuVtnaQ9xE5KvMgGaOBAp\
	agJvTNaiM6R507nIjSMRdOodYNQGy8RazgJZl8ec08LBSJEJRvpqnyIhM4zeTbmjXFlNJI\
	i0ievPJxlSIteXad7wbwp06m2I5MFIjNpyVi+jA0MBjAlGgBFG8V+JEk2F5axnuIORARQy\
	tT4El8fvAV8FwfQLv8e4ayJBBCkY/RlwKMmQktaOq/F3fj8No5o6HLO4PIoClrPJPxuMKu\
	7yKCCZx6JPMCqjIcCoY93xsJz9K7o4vFXVxIJI0U7gz1MpUrJx7WdCT2YdRl4aSJV1ebTB\
	SF/OwEgHlgFGkIqkeoZR2ctlwDCaAMvZK5F8PYyGxvZh6pQmGkRKVHQ2cLmaJ1f2snHTua\
	n5oRSMhubyaIGRPgzzhmw5q80TDR1GRfvKS88pVwkvo0596P21094JMP3Ca3I2frw00SBS\
	JIHXAOtqYuuObxDs3Z6aI8rAKAaMDUbxLX8bjGKXx1wYKTCxWc5igJHw2idvHoxCEuXAiC\
	yMRN14EK1Ht0Cas5zV6hfpIwuji5FclrPFY6mJB5ESFd1J/GxRLClZv/KscIhWa3SEUTJ/\
	VFnLWcwwUu7QFXV5FF693JzPqGHUZbuVgVFm+4wwkkj+EgTTL5qcaAg2AYggBaN/BlIfAJ\
	dLD9O88QsRfBrJBW6CUd8sZ5MoyAYjzDCKIyAxBJdHr0ECP02bEkaZut3BqC1tvZjL4+cI\
	n6SeOG0KEClqAq8GUl8ObG67GH/3tjaMvEZygQsjjCbE5dEKo2i/4voGbToYjd7lsQniXQ\
	DTL77aspHjq00DIiUqug54Xzo3HKLJoJWCkfDa8zhGy9mquDz2AiMwwygehkL2AkmOWgmN\
	E4ysZUcBo2T9DOBe238M4y5R9GueQkzGAVj6yGkA08C1wM+pefXHPZPpp58OfgsZtMBvQt\
	BEBn607IMMIGhB4CNlK1z2WyDjPD8sH/hhWryMH345NUkPojphPRl/3ln6CBmEaTIuI8O2\
	k7/KP2S7LLJdBgnEdSTJlSGD9t8oXSZpcbkoff0wNFfbB0iYzxXjmWE7XQzppU6tEu2Wum\
	aFuijz6+rHIbNOGzzK9E64LpL19H7ntnkAIX8C2D/94qtyNqx6KsqXTRMRaVoHXknoX5So\
	dee3aO34HtTqmcgo5fI41pazahtRZJRES+nISNSm0ketTGRUIiqpZGRUdPLauE46MpIgDz\
	UJHjiCv2OZYNcqcsUvExm9B8n+Ansxttp0EREkURHA3wB/reaJmUVmX/gBxPRiFKlYIqOg\
	1Y6A9Mgojoqi/ExklCxLc2QURTtCjXbUyCiuq0ZImcioHfFkI6N4mZzIKEyXK7uzB7DXyM\
	gUFVkbsGgcIiPAv3+Z4N4l5LqfyROLDWo/vkjtpBklNdPmncDPAM3pl3y309ZXTi4iypEy\
	X/R3QMpbU64tsf6dD6efsK7Vs5FRYctZj0xklCwrEVIVXR6FiO6eaeo1MrLdietHZNTHsj\
	1FRr6kdeNe/DsOGiEEIJeatG7eT/P7B5UPWmbafAuSZuHtH1NtShApagGvANbURP+hm2ne\
	egHUGtFdshgqBhhVxuUxB0YiD0aCPBiJ+qwFJhWFUZmhW4F2u4KRlLRu2kuwb81cR1Pw0B\
	GatxxU+kna/CbRx0PHMRoqo005NIulDNFeT/JdtEi1OrO/9X68rY8Gv6kM0cLhV2aYFv0L\
	9j5I8MCdyEN7kX4TMTOPOPFReCc+sj1Eiyet1WFaavhlGKbJACnbE9rZYVo8gS2T9dQwLf\
	XXNEyL24DUMC3wkcu7wmXjsKeiw7QyQ7cC7ZYZpvnbD+LvWCrRUaja47ZQ/7GFeLUF8ueB\
	26ZfemXptqqiwnzZzCCCBEYC+BrwfDXPO+oUZl/0gTDS6QAj/+6baX778wQPbjf2Ixa3Un\
	/yadSe8OQ2CKwwat8VM8JImcPpCkZSBRDttiwwkit7wY/ejtlMMBL6amcYyeUmzWt3lYvA\
	YnmCxi+dgDdbA3g/yD8H2Awg2uxDs1iS8EHH1MxscOhB1q84IxpyNZQ7aeHwS0R30JqXfZ\
	H1c95jhRCAXDpA89Ivs3Hex5CrK8pwaICWs0A/XB5FY7bD0ZvQYZrUVzsP0/y7DnUHIYBA\
	4t+zjJQ8BLwHxFhDqIw2PYiUies9wKv0/Nb2y2lt+08zjLw6rcvPpXn5uYX7C3btYONLZy\
	CXDjI2Lo+NuQRK/Z6DyUsbNxjJlSbB3lVzZkEFDx1Brgdv9/eulx/bjbE2PYggBaP/BP5F\
	z1+/+myC/feEF6gCI/++bWx865zS/cnlQ2xc8Glkc6P9vJEa3Wgw6p/LY5cw8jxEY17ZAd\
	NemS9Q6/U+gTAKHlou2KBdYr5xoHn5rs8Ge9eZfukVPbc3LnIgiqTA6K1ot/Txm6x/8x/D\
	+aDolrzw6mxceKYyz1JO8uBeWpee376TVsrl0QIjoYPGBCM6wEiDVgyjqQVtB0x7tXlgZE\
	oLdh8p2JhFnsA7Zurl4qgpGezoHWrjJAeirNaBlwEH1cTg8E7WL/9A8kyRf/eNBPff3lNH\
	/vZb8O+5PQsjZV4oz3IWb4iWs7UpqE+nd2DYMCqjAcNIf0lWHt5AbpifFyoq74TZb8o1/x\
	ve1im2fOLuntoaNzkQKVKionsIJ69Tat3zXZo3fglqdZrX/kdf+mxdeSFYjdWUuZ4MjGrh\
	xSB6tJyVmGGkLwsQM0dld2CYMOp2ErjIRvQIo+BAsWeGbBJz9XXv6KkXiZk68++4pae2xl\
	EORJoUGJ0PfFDP37jus/j3XY9/63f60p88uBf/hzdjh5Fyl8wEo+Tpbs8MoxSQBL24PIr6\
	TDYqgurCqB8T6x3qxzCSvYBIgHfi7BuDpeaymKl1Lj+BciAySJsvSpu/SMn6RX+LXDmkV+\
	ta/s1XJJYhKACqosujmDnavBOTAKMu25UIgqWNEpXT8k6cu1Gu+WeLKY+5t9zQdTvjLAei\
	fDWB3wX2qony0EFz6S4V7NoBh/YpEVAbMt27PFpgFEdAVhh5uTCyRkWwaWEk131oBiUqti\
	Xm6k3v+NnniNk682+/uas2JkEORBYpUdF9wO+guDrK9f6/g+hvvwWjy6MNRonLYx6MyIeR\
	6M5yVsxute/IZoTRSpfRkADvpPk3BQfX94h5w8vFm0gORDlSYHQp8JYko8e7Iyb5924zuz\
	yKcEhWJctZUZ9FTM0b9wOww6hoUVtGRWEkj7Q6FzLIO2HuernaPEs0asz9r/H/WmsvciDq\
	oARGkg8BnwGg1X8QBQ/dA62WGUbDspxNTVibYEQbRrPHpNN1GS/ukjAqWHjUMJJr5UEk5u\
	pN79iZ54jpOvNvu7F0/UmTA1EBKTA6HbgOv7v5gFzJgGD3/QkgKu/y6NUR04bb+al9MqWV\
	gFGZqGSUMLL4DVklwDth/o3B4Y19Yi77/bjNKAeiclpD8mIk3cXiHRTseUCbH/LMMFLeUT\
	PCKIKIVAGT8TKiBxhFk+WzW8P37vI0CBhZ4DAqGMlmORB5J8xdKVebHxf1GnN/el2pupMq\
	B6KCWvyTMCqSew7fz5bZV+PlDEu6lNy/uzuXRxuMhFcARqIDjGL4WGA0d2yBHTOlDQZGPb\
	8KUrY/KDVnKBYaK2LL9LOYrjH/Djcki+VAVEKLf3Ip+AGsbZzDMQv/2O/2g/0Pk+/ymAOj\
	EVnOisZc6O/dSUOCUV/eSytb1i/YSE3gHTv7YrnSXBXTbkimyoGopLb8/Y0wVYe15ts4Zu\
	HCfrYtlw8westZgRVGBmtZiKIir8CFNU4wKhEtyYJzht4J858NlpvfEA2P+bde37nCJpID\
	URfa8g83hzDygxewZba3N18VycP7w0ngOPowwqjeBoERRunnhozGakA7utFh5NlhpP5Nva\
	VfR8wfX3AnTWljDqMC7qVi68wOudZ6pZiqMf/OifxqdE9yIOpSW953C0w3EFsXnsT89N7O\
	NQqotRF+XsirR3fA2g8rZmAUT1iP2uUxcXGcN78UW1RjDCNRyweRmKk3xcLU05iqsfCezf\
	dCaxE5EPUgMTuFXNtYFUfP/ywzjR7NaELJjQ1i90eR+myRZ4ZRQZdHK4xEBxhFEVQRy1kx\
	dxzoH2U07qQtfUxh1KhZCgBCII6ZfYVca+0UUznlNrkciHrQ4juvQdRryNWNXSzOPpmpes\
	/vfsj11QREaRjVOsBIAc7ILGcF3sJJhYYqA7vrNQIYiakrR90AAA7aSURBVFn7/Jh3/Nzn\
	5JHmF0SjxsJfuSGZTQ5EPWrxb66DmgfN1jaOmnsONa+3px0DP4JHDoyEyIVR+/mjNIz6Zz\
	mrl1FgVJsKI6MiGuZ7abmNdN8ugJg3R4Hi6Jk75Ebr98RUjYV3b94XWovIgagP2vLem6BR\
	h/XmpWydfzmeV+qthZT8VjRJHQ/HDDCKP+qYPGGdhlFxy1nRpeVsOwIywUhMH1Xslj4MH0\
	ZlVLBdcVTWjUDMNVbEXP0XaNRY+Pvvl+1508mBqE/a8t6bwjtpG60vcezC66h1eWgDiYhv\
	33tpIGVg5EWvfMS3/LtweYwnvPvt8ijmji82XwTDhVH3/0VY2xWL06DO/zS8QBw1/Qy54R\
	8SDXeJFZE7Sn3Uln+4GaYbsNH6mDhuy+uodxEZRbBJwSgBUs0Mo3hep2eXRwuM9GGYzeVR\
	XRdeNF9U8BSrKoyKzGUJ8E6M3Ag8gXf8/Gvlun+taNRYeLe7S1ZEDkR91pb33oSYmUJuND\
	8qTjjqdOol75TUGkoEpMFINU4zwSi+5W+DUezymAsjLx9G8b8ilrO1KcTCicX3fYxh5J2y\
	GELoxIUPydXW2WKm7m7Vl5AD0QC0+Hc3hLf2N1ofFydvPZ1GrfBp780sdoSRiCOkPBgpAB\
	ql5axozIeWIUU1pjAS03Vqjz/uX2QQvFnM1N3kdEk5EA1Ii+++HjE3jVxrfkyccuwfM1Uv\
	dtrPbyH5mmxyh6yOsMLIM8Oob5azmGGkDMc6uTyK2WMQ+nfR8jSeMPqk2DL9Ju+4ORbe4y\
	BUVg5EA9Tiu64NYbS68UlxyjF/yEyj42kvFo+HWr0NI69BcnfLCKN6FOUIM4wSW5DRujyK\
	+ROKT16DHUZFi9oyBgOjS5C8TjRqzL/5mhKNOcVyIBqwFt9xNWJuCrm28Wlx8jEvZaZhfc\
	5IzMwjZhdD+GgwEl57HicDo3j4pjxDNDKXRxuMvBre4skkzyoVUa/vpZVotwcYXQu8hPBD\
	C05dyoFoCFp8+9WI2Wnk2saXxSOPfR5zU0YDG1mTyMM723MzBhiFQ7YYOPEtfAVGypAs1+\
	XRBqPEp2gAlrO1Bt6Wk8sdvEG8JGtJ7wJG24DnA0sAs79/aYkGnFQ5EA1Ji2+7KhqmrX9D\
	PGLrM5ifzv4POu2x+tW3EOy+rT0RLTwzjBLTNAuMvFpnGI3CcrY+g1h8RB+ecu4DjExFi5\
	e9D8mzkewBB6Fe5UA0RC3+xXfDW/trze+Ik495GvPT62q+mJtGri+z+h/vpHX7xRFYGp1h\
	lNyON8NIvYM2GMvZ7PNGeS6PYmoBMX9cuRBkSPYhueltPQg8E3gAHIT6ISELngzJ/IFTz1\
	r6p6cjj6wjpuqPkXsO38Dy2hYA8YRHpt7krv/ks5j+xdPDC9lvIoMWSD98DSRoIgMf/Gb4\
	flrQCv9JiZTRsh+VD/ywrPRDm5EojcAHorzABxmEcJBRWRlE9QKQAUIGgETKqA0pw7zAB6\
	RSP0jWpbIcgkcC4bJcfhi5drAdXRWRqagwn8PGVo31LUnmzXoQ+DVgO8DsKxyE8lSYLw5E\
	o9HSe5+KXGsipurHyr2Ht+GJ48WPZx/+845/HDO//jbE7FFtGPnNCAAWGAUtJDIHRiGw7D\
	DyFSBlYSRlNMVlhZECHR1GyCgvgtGhB5DNI+MCIwehkirKFzc0G5EW3341YqqOXF7dR6P2\
	I+Kko79oKhfsuZPVr/wp/u5tUGtozxjV0sM09Y39vrg8asM0obk8Wi1n4zkkfZimDNfiZ5\
	i2nFzutj4MbZimvbHvIDRAuYhoxDr85z8Dc9MwN42Yn/5L4O8x/QchPBqnvpSpU18GQdCO\
	jOIISAbmyCjwgcAeGQV+OzoyRkZB8s8YGSnRTfnIKMr3mwSHdkTpJTS8yOhuBM/BQai03N\
	BszLT0kdPixecBnweONpWrnfhTTP/qmxGzW8vBKGi14WKCUQwkG4wiwFhhpMLFBKNoOGeD\
	kWyuIA89aJuXMctWtr8w+gHwbGCnEA5CZeVANIZSYPQTwFeAnzaVE1NzTD39ddQf/ZQsjF\
	SwGGHUBosZRgpwDDCSSoRkhFE8f2SBkUzmiAwwWjuEXN7V+3wR0j7nU7SNMO1K4DeBQwBz\
	r3QQKisHojGVAqMF4F8Jn9o1qv5jT2fqF14FjdksjPwoArLBKL7DZoFRApxuYaRHSRkYRc\
	MwHUYrDyNXD1QBRl9G8PvAEXAQ6lYORGMsBUYC+DPCeSPjt53F9CJTT3kltR99mhlGQRpI\
	GRgFfniy2GCkDMXMMAqh01cYHbq/P3fSuofRPwDvgPARKgeh7uVANOZSYATwZOALwGNs5W\
	uPfCJTT3kVYmaLGUYKkAYBI4EMJ9G7gVHyfJFMtjE4cG+4LcOF0QaCPwLOiRPm/sBBqBc5\
	EE2ItKHamcDv28qKqVkaP/Pb1B/362FCWRjF8zpWGKWfL8rAKI5obDDS75bpMJJBSAgZIN\
	eXkYcfiHZsKDB6EHgZcBXCAahfciCaIGnR0f8APgqY3emFQCwcz9SpL6N2yhPNMIoBY4NR\
	fMvfBqMgCPOtMIpu1dtgFAOJ8LGBDIyiPLm0E7l2KNmvwioPo0uA3wMeBph7lYNQv+RANI\
	FSgHQKcBbwAmPB6LfyTngcU6f+Dt5RpxhhJNX5IxOM1Fv3JhjJOILqEkZxBGSDUdAk2H93\
	ey6p/zAKgL8V8LeADw5C/ZYD0YRKi45eDnwYyH5ITPm9ao96Eo0nPB+xcLwFRq02WEwwUu\
	6cGWEUQcYOIz8KcsrDSK48jDyyz7hfHZUPo/uBVwCXxUUdhPovB6IJlwKk44APAv8zVSD1\
	e0kQgtojn0Tjcc9CLJ5khpHfQp0jGiqM4qevdRgFGwT7tmPftw4yw+hfEbwJOAww7wA0MD\
	kQbQJp0dEzCaOjxycpOozCRGonPZ76Y34F79ifUO6aKW/s58Eomj+ywyiI7sDZYKSBpgCM\
	gv0/DB9NUNUdjHYBrwF5QZzuIDRYORBtIilAqgNvBP4K2ApYYBS9q7p4EvUfeSreKacivE\
	bWPiSejDbCKLrlb4NRED1h3S2MkmVJsO+H4Kesm9o7UUw+gjOBdxE9JT3/6m8XrevUgxyI\
	Npm06Ggr4QN5bwBm8mAEQK1B7aSfpnbyzyOO+TESzyNlSGaFUfyOmg1GEVCsMEqAZYFR0C\
	LYsy0sb3wVo+N5eTXweuDGuL6D0PDkQLRJpQHpUYRAejVCKE9mG2AUr0/N4530BLzjHot3\
	9KPCssl7aYEdRskzSBYYySB86NEKI5mOkAifR5IHdoTmackGGnbafG7eBfw14QvEEmD+Dx\
	2Ahi0Hok0uDUiPBv4CIV4NzIRJdhiFiUB9Gu/oR+Md86Oh6f3s1nTkYzVWkz3DSK4vIQ/f\
	j9xYMW9bJi1J3EV4O/5sYCNOdBAajRyInIAMkE5CiNcDp4M8Xs2wwkhVfQZvyyMQ88eF/2\
	aOQkzNY7YPyYFREvEoMGqth2/frx+G1YPhu2ambbBtG+xAiA8CHyd6URUcgEYtByKnlFJA\
	EmIGeDnI1wBPaycbKnb62YWHmF6Axjxieg7q0wivoZjxo0Q9LaS/Af4GBE1obUBrFdlcDS\
	fJrX3kpl0PvB/4d6AV74QDUDXkQORk1NIZz4iWkt/9Z4FXEr468oiuYNSprKV+qVMqXfYQ\
	8AUEnwZSn1ad/yN3O75KciBy6qilM1LDthqhJ/OLheBFwCNShUcPo1UElwD/Rmgatxa36+\
	BTXTkQORWWBiQQCAFPBJ5LaJP6VGB6BDC6H/g6cAHwTUIYJZr/YwegqsuByKkrLZ3ZhpLy\
	i08TeiL9IoInAk8itLPN/5B9ORgdBm4Hror+XUn0AUNV869x8BknORA59UXLZ56WTQxPhS\
	lCGD0WeCTwVDx+D9QIR4bfIxESRICo+Yj6BkFz6qtyffpG4CHgTuAOYJfpFHPgGW85EDkN\
	TMtnZYZyCI+3UhPvE55EhJ9KQ9R9RL0FjQ28ehPRWEPUV6Cx/uXm3mNfEizPE6xsSZpZeK\
	2DzqTJgchpKFo+67T4k/ZfoyZekAFRowX1GERHEPVVaKy3qK0+CthVe9ryqHfBaYByX3p1\
	Gp4CBPD0TLoA9Qnudhp14I8AgmvMRpNOm0sORE790OOBY/KLBPryHwtPuPPPCXAgcuqPft\
	mYqobl2ZH9owmfW3JyciBy6oueUrxoaqj2SoQguPHYfm+P05jJgcipay195LQ46HlqXjmh\
	f4teJH9fQqOxMIhtcxovORA59aaAReCnMuk24/q05oHn932bnMZODkROveqJ6OeRUP/q0Z\
	C67gG8DE8Q3HHKoLbPaQzkQOTUq05NrVn9g6QCoUBN/w1mpt3wbJPLgcipV51qzyryMJs3\
	Q/hirdMmlgORU6+ygehGoq+npiU/hz55jfe8cj4jTpMmByKnrrT04dPigOcnLUXeDlxnmC\
	c6E/hYeqjGc6g1kLt+bjAb61R5ORA59aJTgDlD+nch+DpCXGHI2wO8GbgFiAOhR4mFxUcP\
	aBudxkAORE696LGW9HdE0c5lqWgoTNtFINaA3wXCT3SEMPpvg9pIp+rLgcipF5nuuV8gfS\
	6L4HIF6XHZAelPLYEAz7sdeENIIQ/Ajcs2sRyInHqR/m7GOvC/AURNQq15kHgIFvLoNmSN\
	2i/tD21l6o3PAJ8NoSVOGNZGO1VPDkROvSj9xr3gr2XAdoCZl/1X/GrHZYqV1e3xgvffD4\
	efHAo/i30HguVyn/VwmiQ5EDn1ogAhwtGV4NvA+0Ew9weK06JAnbC+JdPC1NQy8LsIvjDg\
	bXWqsByInHrRbdHfK4AXE8j0c0NhgHO5Mk2U+uqh9/N7oF6H6Zmb5draje5Ros2r+qg3wG\
	msdT6hM+M1MsAXHsy/Ov2FVVFr7gG2Ab5sTf1A1DdS+d5jdwxrW50qLBcROXUvgQ/yuzLA\
	R2a/Mzb9wmvieaJLEPLNSI/6M+8eyaY6VVuFzfOdnLpR66IngRd9177mU3/2raPdIKdKyo\
	HIyclp5HJDMycnp5HLgcjJyWnkciBycnIauRyInJycRi4HIicnp5HLgcjJyWnkciBycnIa\
	uRyInJycRq7/D3Tgxzs5ujSKAAAAAElFTkSuQmCC\
	")

	-- 30log.lua begins
	local function require_30log()
	local assert, pairs, type, tostring, setmetatable = assert, pairs, type, tostring, setmetatable
	local baseMt, _instances, _classes, _class = {}, setmetatable({},{__mode='k'}), setmetatable({},{__mode='k'})
	local function assert_class(class, method) assert(_classes[class], ('Wrong method call. Expected class:%s.'):format(method)) end
	local function deep_copy(t, dest, aType) t = t or {}; local r = dest or {}
	  for k,v in pairs(t) do
		if aType and type(v)==aType then r[k] = v elseif not aType then
		  if type(v) == 'table' and k ~= "__index" then r[k] = deep_copy(v) else r[k] = v end
		end
	  end; return r
	end
	local function instantiate(self,...)
	  assert_class(self, 'new(...) or class(...)'); local instance = {class = self}; _instances[instance] = tostring(instance); setmetatable(instance,self)
	  if self.init then if type(self.init) == 'table' then deep_copy(self.init, instance) else self.init(instance, ...) end; end; return instance
	end
	local function extend(self, name, extra_params)
	  assert_class(self, 'extend(...)'); local heir = {}; _classes[heir] = tostring(heir); deep_copy(extra_params, deep_copy(self, heir));
	  heir.name, heir.__index, heir.super = extra_params and extra_params.name or name, heir, self; return setmetatable(heir,self)
	end
	baseMt = { __call = function (self,...) return self:new(...) end, __tostring = function(self,...)
	  if _instances[self] then return ("instance of '%s' (%s)"):format(rawget(self.class,'name') or '?', _instances[self]) end
	  return _classes[self] and ("class '%s' (%s)"):format(rawget(self,'name') or '?',_classes[self]) or self
	end}; _classes[baseMt] = tostring(baseMt); setmetatable(baseMt, {__tostring = baseMt.__tostring})
	local class = {isClass = function(class, ofsuper) local isclass = not not _classes[class]; if ofsuper then return isclass and (class.super == ofsuper) end; return isclass end, isInstance = function(instance, ofclass) 
		local isinstance = not not _instances[instance]; if ofclass then return isinstance and (instance.class == ofclass) end; return isinstance end}; _class = function(name, attr)
	  local c = deep_copy(attr); c.mixins=setmetatable({},{__mode='k'}); _classes[c] = tostring(c); c.name, c.__tostring, c.__call = name or c.name, baseMt.__tostring, baseMt.__call
	  c.include = function(self,mixin) assert_class(self, 'include(mixin)'); self.mixins[mixin] = true; return deep_copy(mixin, self, 'function') end
	  c.new, c.extend, c.__index, c.includes = instantiate, extend, c, function(self,mixin) assert_class(self,'includes(mixin)') return not not (self.mixins[mixin] or (self.super and self.super:includes(mixin))) end
	  c.extends = function(self, class) assert_class(self, 'extends(class)') local super = self; repeat super = super.super until (super == class or super == nil); return class and (super == class) end
		return setmetatable(c, baseMt) end; class._DESCRIPTION = '30 lines library for object orientation in Lua'; class._VERSION = '30log v1.0.0'; class._URL = 'http://github.com/Yonaba/30log'; class._LICENSE = 'MIT LICENSE <http://www.opensource.org/licenses/mit-license.php>'
	return setmetatable(class,{__call = function(_,...) return _class(...) end })
	end
	-- 30log.lua ends

	local class = require_30log()

	local g_t = 0 -- The current elapsed time.
	local g_step = 0 -- The current physics step.
	local STEP = 1/20 -- 20Hz physics.

	-- Debug things.
	local DEBUG = false
	local LOCAL = true
	local g_frame_count = 0
	local g_step_count = 0

	-- A State maintains two x,y,angle states for some
	-- body, and interpolates between those states.
	local State = class("State")

	function State:init(body)
		self.t0 = 0
		self.x0 = body:getX()
		self.y0 = body:getY()
		self.r0 = body:getAngle()

		self.t1 = self.t0
		self.x1 = self.x0
		self.y1 = self.y0
		self.r1 = self.r0
	end

	-- Calculate the next state for Body, at time t.
	function State:save(body, t)
		self.t0 = self.t1
		self.x0 = self.x1
		self.y0 = self.y1
		self.r0 = self.r1

		self.t1 = t
		self.x1 = body:getX()
		self.y1 = body:getY()
		self.r1 = body:getAngle()
	end

	function State:get(t)
		t = math.min(t, self.t1)
		t = math.max(t, self.t0)

		local p = (t - self.t0) / (self.t1 - self.t0)

		local x = self.x0 + p * (self.x1 - self.x0)
		local y = self.y0 + p * (self.y1 - self.y0)
		local r = self.r0 + p * (self.r1 - self.r0)

		return x, y, r
	end

	-- Simple class for figuring out whether the eyes
	-- of the Duckloon should be closed.
	local Blink = class("Blink")

	function Blink:init()
		-- When this hits zero, we open the eyes.
		self.closed_t = 0

		-- When this hits zero, we close the eyes.
		self.next_blink_t = 5
	end

	function Blink:update(dt)
		self.next_blink_t = math.max(0, self.next_blink_t - dt)
		self.closed_t = math.max(0, self.closed_t - dt)

		if self.next_blink_t == 0 then
			self.next_blink_t = 5 + math.random(0, 3)
			self.closed_t = 0.1
		end
	end

	function Blink:is_closed()
		return self.closed_t > 0
	end

	-- Duckloon (TM)
	local Duckloon = class("Duckloon")

	function Duckloon:init(world, x, y)
		self.body = love.physics.newBody(world, x, y, "dynamic")
		self.body:setLinearDamping(0.8)
		self.body:setAngularDamping(0.8)
		self.shape = love.physics.newPolygonShape(-55, -60, 0, 90, 55, -60)
		self.fixture = love.physics.newFixture(self.body, self.shape, 1)
		self.fixture:setRestitution(0.5)
		self.img_normal = img_duckloon_normal
		self.img_blink = img_duckloon_blink
		self.img = self.img_normal
		self.blink = Blink()
		self.pin = love.physics.newMouseJoint(self.body, x, y - 80)
		self.state = State(self.body)
	end

	function Duckloon:step()
		self.state:save(self.body, g_step)

		if math.floor(g_step % 5) == 0 then
			self.body:applyForce(math.random(30, 50), 0)
		end
	end

	function Duckloon:update(dt)
		self.blink:update(dt)
	end

	function Duckloon:draw()
		local x, y, r = self.state:get(g_t)

		love.graphics.setColor(1, 1, 1)

		local img = self.img_normal
		if self.blink:is_closed() then
			img = self.img_blink
		end

		love.graphics.draw(img, x, y, r, 1, 1, img:getWidth() / 2, img:getHeight() / 2)

		if DEBUG then
			love.graphics.setColor(0.8, 0.3, 0.1)
			love.graphics.polygon("fill", self.body:getWorldPoints(self.shape:getPoints()))

			love.graphics.setColor(0, 1, 0)
			local ax, ay = self:attachment_point()
			love.graphics.circle("fill", ax, ay, 3)
		end
	end

	-- This is where to attach the Chain.
	function Duckloon:attachment_point()
		return self.body:getWorldPoint(4, 90)
	end

	-- The chain is built from a string containing "# nogame",
	-- which represents what should be "drawn" along the chain.
	local Chain = class("Chain")

	function Chain:init(world, x, y, str, duckloon)
		self.links = {}
		self.str = str

		local DRAW_INFO = {
			n = { r = 11, img = img_n },
			o = { r = 11, img = img_o },
			g = { r = 11, img = img_g },
			a = { r = 11, img = img_a },
			m = { r = 11, img = img_m },
			e = { r = 11, img = img_e },
			[" "] = { r = 4, img = nil },
			["#"] = { r = 7, img = img_square }
		}

		for i=1,#str do

			local prev = nil

			if i >=2 then
				prev = self.links[i - 1]
			end

			local byte = str:byte(i)
			local link = {}

			link.x = x
			link.y = y

			link.info = DRAW_INFO[string.char(byte)]
			link.radius = link.info.r

			if prev ~= nil then
				link.y = prev.y + prev.radius + link.radius
			end

			link.body = love.physics.newBody(world, link.x, link.y, "dynamic")
			link.body:setLinearDamping(0.5)
			link.body:setAngularDamping(0.5)
			link.shape = love.physics.newCircleShape(link.radius)
			link.fixture = love.physics.newFixture(link.body, link.shape, 0.1 / i)
			link.state = State(link.body)

			-- Note: every link must also be attached to the Duckloon. Otherwise the
			--       chain easily goes haywire on higher speeds.

			if prev ~= nil then
				link.joint = love.physics.newRevoluteJoint(link.body, prev.body, link.x, link.y - link.radius / 2)
				link.join2 = love.physics.newRopeJoint(link.body, duckloon.body, link.x, link.y, x, y, link.y - y)
			else
				link.joint = love.physics.newRevoluteJoint(link.body, duckloon.body, link.x, link.y)
			end

			table.insert(self.links, link)
		end

	end

	function Chain:step()
		for i, link in ipairs(self.links) do
			link.state:save(link.body, g_step)
		end
	end

	function Chain:update(dt)
	end

	function Chain:draw()
		local rope = {}

		for i, link in ipairs(self.links) do
			local x, y = link.state:get(g_t)
			table.insert(rope, x)
			table.insert(rope, y)
		end

		love.graphics.setLineWidth(3)
		love.graphics.setColor(1, 1, 1, 0.7)
		love.graphics.line(rope)

		for i, link in ipairs(self.links) do
			if link.info.img ~= nil then
				local x, y, r = link.state:get(g_t)
				local ox, oy = link.info.img:getWidth() / 2, link.info.img:getHeight() / 2
				love.graphics.setColor(1, 1, 1)
				love.graphics.draw(link.info.img, x, y, r, 1, 1, ox, oy)
			end
		end

		if DEBUG then
			for i, link in ipairs(self.links) do
				love.graphics.setColor(1, 0, 1)
				local x, y = link.body:getPosition()
				love.graphics.circle("fill", x, y, link.shape:getRadius())
			end
		end
	end

	-- Draws clouds in a repeating pattern of 1,2,3,4, but with
	-- an offset on each track.
	local CloudTrack = class("CloudTrack")

	-- x,y: Top-left corner of cloud track.
	function CloudTrack:init(x, y, offset, speed, img)
		self.x = x
		self.y = y
		self.initial_offset = offset
		self.h_spacing = 50
		self.img = img
		self.w = self.h_spacing + self.img:getWidth()
		self.speed = speed -- px/s
		self.count = love.graphics.getWidth() / self.w + 2
		self.initial_img = math.random(1, 4)
	end

	function CloudTrack:update(dt)
	end

	function CloudTrack:draw()
		local abs_offset = (self.initial_offset + (self.speed * g_t))
		local offset = abs_offset % self.w
		love.graphics.setColor(1, 1, 1, 0.3)
		for i=1, self.count do
			local x = self.x + (i - 1) * (self.img:getWidth() + self.h_spacing) + offset - self.w
			local y = self.y
			local img_no =  math.floor(abs_offset / self.w)
			love.graphics.draw(cloud_images[1 + (self.initial_img + i - img_no) % 4], x, y, -0.05)
		end
	end

	local Clouds = class("Clouds")

	function Clouds:init()
		local layer_height = 100

		self.tracks = {}
		local max = (love.graphics.getHeight() / layer_height) + 1
		for i=1, max do
			table.insert(self.tracks, CloudTrack(0, 20 + (i - 1) * layer_height, img_cloud_1:getWidth() / 2 * i, 40, img_cloud_1))
		end
	end

	function Clouds:draw()
		for i,track in ipairs(self.tracks) do
			track:draw()
		end
	end

	-- Called on resize.
	function create_world()
		local wx, wy = love.graphics.getDimensions()
		world = love.physics.newWorld(0, 9.81*64)
		duckloon = Duckloon(world, wx / 2, wy / 2 - 100)
		local ax, ay = duckloon:attachment_point()
		chain = Chain(world, ax, ay, "  n o # g a m e # ", duckloon)
		clouds = Clouds()

		g_objs = {
			chain,
			duckloon
		}
	end

	function love.load()
		love.graphics.setBackgroundColor(43/255, 165/255, 223/255)
		love.physics.setMeter(64)

		local dpiscale = love.window.getDPIScale() > 1 and 2 or 1
		local settings = {dpiscale = dpiscale}

		R.chain.n = R.chain[dpiscale].n_png
		R.chain.o = R.chain[dpiscale].o_png
		R.chain.g = R.chain[dpiscale].g_png
		R.chain.a = R.chain[dpiscale].a_png
		R.chain.m = R.chain[dpiscale].m_png
		R.chain.e = R.chain[dpiscale].e_png
		R.chain.square = R.chain[dpiscale].square_png
		R.duckloon.blink = R.duckloon[dpiscale].blink_png
		R.duckloon.normal = R.duckloon[dpiscale].normal_png
		R.bg.cloud_1 = R.bg[dpiscale].cloud_1_png
		R.bg.cloud_2 = R.bg[dpiscale].cloud_2_png
		R.bg.cloud_3 = R.bg[dpiscale].cloud_3_png
		R.bg.cloud_4 = R.bg[dpiscale].cloud_4_png

		img_duckloon_normal = love.graphics.newImage(R.duckloon.normal, settings)
		img_duckloon_blink = love.graphics.newImage(R.duckloon.blink, settings)

		img_n = love.graphics.newImage(R.chain.n, settings)
		img_o = love.graphics.newImage(R.chain.o, settings)
		img_g = love.graphics.newImage(R.chain.g, settings)
		img_a = love.graphics.newImage(R.chain.a, settings)
		img_m = love.graphics.newImage(R.chain.m, settings)
		img_e = love.graphics.newImage(R.chain.e, settings)
		img_square = love.graphics.newImage(R.chain.square, settings)

		img_cloud_1 = love.graphics.newImage(R.bg.cloud_1, settings)
		img_cloud_2 = love.graphics.newImage(R.bg.cloud_2, settings)
		img_cloud_3 = love.graphics.newImage(R.bg.cloud_3, settings)
		img_cloud_4 = love.graphics.newImage(R.bg.cloud_4, settings)

		cloud_images = {
			img_cloud_1,
			img_cloud_2,
			img_cloud_3,
			img_cloud_4,
		}

		create_world()
	end

	function love.update(dt)
		g_t = g_t + dt

		while g_t > g_step do
			world:update(STEP)
			g_step = g_step + STEP
			for i,v in ipairs(g_objs) do
				v:step()
			end
			g_step_count = g_step_count + 1
		end

		for i in ipairs(g_objs) do
			g_objs[i]:update(dt)
		end
	end

	function love.draw()
		clouds:draw()

		for i in ipairs(g_objs) do
			g_objs[i]:draw()
		end

		if DEBUG then
			love.graphics.setColor(0, 0, 0, 0.5)
			love.graphics.print("FPS: " .. love.timer.getFPS(), 50, 50)
			love.graphics.print("Time: " .. g_t, 50, 65)
			love.graphics.print("g_step: " .. g_step, 50, 80)
			love.graphics.print("Frame: " .. g_frame_count, 50, 95)
			love.graphics.print("Step: " .. g_step_count, 50, 110)
		end

		g_frame_count = g_frame_count + 1
	end

	function love.mousepressed(x, y, b, istouch, clicks)
		-- Double-tap the screen (when using a touch screen) to exit.
		if istouch and clicks == 2 then
			if love.window.showMessageBox("Exit No-Game Screen", "", {"OK", "Cancel"}) == 1 then
				love.event.quit()
			end
		end
	end

	function love.keypressed(key)
		if key == "escape" then
			love.event.quit()
		end
	end

	function love.resize()
		create_world()
	end

	function love.conf(t)
		t.title = "L\195\150VE " .. love._version .. " (" .. love._version_codename .. ")"
		t.gammacorrect = true
		t.modules.audio = false
		t.modules.sound = false
		t.modules.joystick = false
		t.window.resizable = true
		t.window.highdpi = true

		if love._os == "iOS" then
			t.window.borderless = true
		end
	end
end

return love.nogame
