// 
//  Lynkeos
//  $Id: MySizeLock.h,v 1.1 2004/08/31 20:43:53 j-etienne Exp $
//
//  Created by Jean-Etienne LAMIAUD on Mon Aug 16 2004.
//  Copyright (c) 2004. Jean-Etienne LAMIAUD
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef __MYSIZELOCK_H
#define __MYSIZELOCK_H

#import <Foundation/Foundation.h>

#ifdef GNUSTEP
#import "LynkeosCommon.h"
#else
#endif

// This class enforces the use of images of a unique size when using dark 
// frames or flat field

@interface MySizeLock : NSObject 
{
@private
   BOOL              _locked;
   NSMutableArray    *_sizeList;
}

// Accessors
- (BOOL) locked ;
- (MyIntegerSize) size ;

// Actions
- (BOOL) lockSize ;
- (void) unlockSize ;
- (BOOL) addSize :(MyIntegerSize)size ;
- (void) removeSize :(MyIntegerSize)size ;

// Constructor
+ (id) sizeLock ;

@end

#endif
