/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

//as seen at http://www.microsoft.com/typography/otspec/name.htm

#ifndef INCLUDED_I18NLANGTAG_APPLELANGID_H
#define INCLUDED_I18NLANGTAG_APPLELANGID_H

#include <i18nlangtag/languagetag.hxx>

enum class AppleLanguageId : unsigned short
{
    ENGLISH =0,
    FRENCH =1,
    GERMAN =2,
    ITALIAN =3,
    DUTCH =4,
    SWEDISH =5,
    SPANISH =6,
    DANISH =7,
    PORTUGUESE =8,
    NORWEGIAN =9,
    HEBREW =10,
    JAPANESE =11,
    ARABIC =12,
    FINNISH =13,
    GREEK =14,
    ICELANDIC =15,
    MALTESE =16,
    TURKISH =17,
    CROATIAN =18,
    CHINESE_TRADITIONAL =19,
    URDU =20,
    HINDI =21,
    THAI =22,
    KOREAN =23,
    LITHUANIAN =24,
    POLISH =25,
    HUNGARIAN =26,
    ESTONIAN =27,
    LATVIAN =28,
    SAMI =29,
    FAROESE =30,
    FARSI =31,
    RUSSIAN =32,
    CHINESE_SIMPLIFIED =33,
    FLEMISH =34,
    IRISH_GAELIC =35,
    ALBANIAN =36,
    ROMANIAN =37,
    CZECH =38,
    SLOVAK =39,
    SLOVENIAN =40,
    YIDDISH =41,
    SERBIAN =42,
    MACEDONIAN =43,
    BULGARIAN =44,
    UKRAINIAN =45,
    BYELORUSSIAN =46,
    UZBEK =47,
    KAZAKH =48,
    AZERI_CYRILLIC =49,
    AZERI_ARABIC =50,
    ARMENIAN =51,
    GEORGIAN =52,
    MOLDAVIAN =53,
    KIRGHIZ =54,
    TAJIKI =55,
    TURKMEN =56,
    MONGOLIAN_MONGOLIAN =57,
    MONGOLIAN_CYRILLIC =58,
    PASHTO =59,
    KURDISH =60,
    KASHMIRI =61,
    SINDHI =62,
    TIBETAN =63,
    NEPALI =64,
    SANSKRIT =65,
    MARATHI =66,
    BENGALI =67,
    ASSAMESE =68,
    GUJARATI =69,
    PUNJABI =70,
    ORIYA =71,
    MALAYALAM =72,
    KANNADA =73,
    TAMIL =74,
    TELUGU =75,
    SINHALESE =76,
    BURMESE =77,
    KHMER =78,
    LAO =79,
    VIETNAMESE =80,
    INDONESIAN =81,
    TAGALONG =82,
    MALAY_LATIN =83,
    MALAY_ARABIC =84,
    AMHARIC =85,
    TIGRINYA =86,
    GALLA =87,
    SOMALI =88,
    SWAHILI =89,
    KINYARWANDA =90,
    RUNDI =91,
    NYANJA =92,
    MALAGASY =93,
    ESPERANTO =94,
    WELSH =128,
    BASQUE =129,
    CATALAN =130,
    LATIN =131,
    QUENCHUA =132,
    GUARANI =133,
    AYMARA =134,
    TATAR =135,
    UIGHUR =136,
    DZONGKHA =137,
    JAVANESE_LATIN =138,
    SUNDANESE_LATIN =139,
    GALICIAN =140,
    AFRIKAANS =141,
    BRETON =142,
    INUKTITUT =143,
    SCOTTISH_GAELIC =144,
    MANX_GAELIC =145,
    IRISH_GAELIC_WITH_DOT_ABOVE =146,
    TONGAN =147,
    GREEK_POLYTONIC =148,
    GREENLANDIC =149,
    AZERI_LATIN =150,
};

/** Init LanguageTag with Apple LanguageId */
I18NLANGTAG_DLLPUBLIC LanguageTag makeLanguageTagFromAppleLanguageId(AppleLanguageId nLanguage);


#endif /* INCLUDED_I18NLANGTAG_APPLELANGID_H */

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
