include(GNUInstallDirs)


# FIXME(arunprasadr): Why do we need this?
set(WK_PLATFORM_JAVA 1)
set(WebCore_OUTPUT_NAME "jfxwebkit")
# set(PROJECT_VERSION_MAJOR 2) #//XXX: change VERSION?
# set(PROJECT_VERSION_MINOR 9)
# set(PROJECT_VERSION_MICRO 4)
# set(PROJECT_VERSION ${PROJECT_VERSION_MAJOR}.${PROJECT_VERSION_MINOR}.${PROJECT_VERSION_MICRO})
set(WEBKITJAVA_API_VERSION 4.0)

set(ICU_UNICODE TRUE)
SET_AND_EXPOSE_TO_BUILD(USE_IMAGEIO TRUE)
SET_AND_EXPOSE_TO_BUILD(USE_TEXTURE_MAPPER TRUE)
if (ICU_UNICODE)
    SET_AND_EXPOSE_TO_BUILD(USE_ICU_UNICODE TRUE)
else ()
    SET_AND_EXPOSE_TO_BUILD(USE_JAVA_UNICODE TRUE)
endif ()

# These are shared variables, but we special case their definition so that we can use the
# CMAKE_INSTALL_* variables that are populated by the GNUInstallDirs macro.
set(LIB_INSTALL_DIR "${CMAKE_INSTALL_FULL_LIBDIR}" CACHE PATH "Absolute path to library installation directory")
set(EXEC_INSTALL_DIR "${CMAKE_INSTALL_FULL_BINDIR}" CACHE PATH "Absolute path to executable installation directory")

file(TO_CMAKE_PATH $ENV{WEBKIT_OUTPUTDIR}/import/include IMPORT_INCLUDE_DIR)
file(TO_CMAKE_PATH $ENV{WEBKIT_OUTPUTDIR}/import/lib IMPORT_LIBRARIES_DIR)
if (WIN32)
    #### ICU ####
    set(ICU_FOUND TRUE)
    set(ICU_I18N_FOUND TRUE)
    set(ICU_INCLUDE_DIRS ${IMPORT_INCLUDE_DIR}/icu)
    if (CMAKE_BUILD_TYPE STREQUAL "Release")
        set(ICU_LIBRARIES ${IMPORT_LIBRARIES_DIR}/sicuuc.lib ${IMPORT_LIBRARIES_DIR}/icudt.lib)
        set(ICU_I18N_LIBRARIES ${IMPORT_LIBRARIES_DIR}/sicuin.lib)
    else ()
        set(ICU_LIBRARIES ${IMPORT_LIBRARIES_DIR}/sicuucd.lib ${IMPORT_LIBRARIES_DIR}/icudt.lib)
        set(ICU_I18N_LIBRARIES ${IMPORT_LIBRARIES_DIR}/sicuind.lib)
    endif ()
    #### ICU-END ####

    set(LIBXML2_INCLUDE_DIR ${IMPORT_INCLUDE_DIR})
    set(LIBXML2_LIBRARIES ${IMPORT_LIBRARIES_DIR}/libxml2_a.lib)

    #### Sqlite3 ####
    set(SQLITE_FOUND TRUE)
    set(SQLITE_INCLUDE_DIR ${IMPORT_INCLUDE_DIR})
    set(SQLITE_LIBRARIES ${IMPORT_LIBRARIES_DIR}/sqlite3.lib)
    #### Sqlite3-END ####

    set(LIBXSLT_INCLUDE_DIR ${IMPORT_INCLUDE_DIR})
    set(LIBXSLT_LIBRARIES ${IMPORT_LIBRARIES_DIR}/libxslt_a.lib)
elseif (APPLE)
    # set(USE_CF 1)
    add_definitions(-DUSE_CF=1)
    add_definitions(-DJSC_OBJC_API_ENABLED=0)
    
    #### Sqlite3 ####
    set(SQLITE_FOUND TRUE)
    set(SQLITE_INCLUDE_DIR ${IMPORT_INCLUDE_DIR})
    set(SQLITE_LIBRARIES ${IMPORT_LIBRARIES_DIR}/libsqlite3.a)
    #### Sqlite3-END ####
    find_package(LibXml2 2.8.0 REQUIRED)
    find_package(LibXslt 1.1.7 REQUIRED)
    set(CMAKE_SKIP_RPATH TRUE)
elseif (UNIX)
    #### ICU ####
    set(ICU_FOUND TRUE)
    set(ICU_I18N_FOUND TRUE)
    set(ICU_INCLUDE_DIRS ${IMPORT_INCLUDE_DIR})
    set(ICU_LIBRARIES ${IMPORT_LIBRARIES_DIR}/libicuuc.a ${IMPORT_LIBRARIES_DIR}/libicudata.a)
    set(ICU_I18N_LIBRARIES ${IMPORT_LIBRARIES_DIR}/libicui18n.a)
    #### ICU-END ####

    #### Sqlite3 ####
    set(SQLITE_FOUND TRUE)
    set(SQLITE_INCLUDE_DIR ${IMPORT_INCLUDE_DIR})
    set(SQLITE_LIBRARIES ${IMPORT_LIBRARIES_DIR}/libsqlite3.a)
    #### Sqlite3-END ####

    find_package(LibXml2 2.7.0 REQUIRED)
    find_package(LibXslt 1.1.7 REQUIRED)
    set(CMAKE_SKIP_RPATH TRUE)
else ()
    message(FATAL_ERROR "Set thirdparty lib, inc paths")
endif ()

find_package(JNI REQUIRED)
find_package(Threads REQUIRED)

if (WIN32)
    # Set output dir to lib directory
    set(CMAKE_RUNTIME_OUTPUT_DIRECTORY ${CMAKE_BINARY_DIR}/lib)
    # Workaround for MSBuild. It always creates Release|Debug folder
    # according to the build type on each target.
    install(PROGRAMS ${CMAKE_BINARY_DIR}/lib/${CMAKE_BUILD_TYPE}/${WebCore_OUTPUT_NAME}.dll DESTINATION ${CMAKE_BINARY_DIR}/lib OPTIONAL)
    # Copied from OptionsWindows.cmake
    add_definitions(-D_HAS_EXCEPTIONS=0 -DNOMINMAX -DUNICODE -DU_STATIC_IMPLEMENTATION)
    add_definitions(
        /wd4018 /wd4068 /wd4099 /wd4100 /wd4127 /wd4138 /wd4146 /wd4180 /wd4189 /wd4201 /wd4244 /wd4251 /wd4267 /wd4275 /wd4288
        /wd4291 /wd4305 /wd4309 /wd4344 /wd4355 /wd4389 /wd4396 /wd4481 /wd4503 /wd4505 /wd4510 /wd4512 /wd4530 /wd4610 /wd4702
        /wd4706 /wd4800 /wd4819 /wd4951 /wd4952 /wd4996 /wd6011 /wd6031 /wd6211 /wd6246 /wd6255 /wd6387
    )
    # https://lists.webkit.org/pipermail/webkit-dev/2016-April/028135.html
    add_definitions(/vmg)
    if (NOT ${CMAKE_GENERATOR} MATCHES "Ninja")
        add_definitions(/MP)
    endif ()
    if (NOT ${CMAKE_CXX_FLAGS} STREQUAL "")
        string(REGEX REPLACE "/EH[a-z]+" "" CMAKE_CXX_FLAGS ${CMAKE_CXX_FLAGS}) # Disable C++ exceptions
        string(REGEX REPLACE "/GR" "" CMAKE_CXX_FLAGS ${CMAKE_CXX_FLAGS}) # Disable RTTI
    endif ()
elseif(APPLE)
else()
    set(CMAKE_SHARED_LINKER_FLAGS "-Wl,--export-dynamic -static-libstdc++")
endif()

WEBKIT_OPTION_BEGIN()

# Set the default value for ENABLE_GLES2 automatically.
# We are not enabling or disabling automatically a feature here, because
# the feature is by default always on (ENABLE_OPENGL=ON).
# What we select here automatically is if we use OPENGL (ENABLE_GLES2=OFF)
# or OPENGLES2 (ENABLE_GLES2=ON) for building the feature.
# set(ENABLE_GLES2_DEFAULT OFF)

# WEBKIT_OPTION_DEPEND(ENABLE_3D_TRANSFORMS ENABLE_OPENGL)
# WEBKIT_OPTION_DEPEND(ENABLE_ACCELERATED_2D_CANVAS ENABLE_OPENGL)
# WEBKIT_OPTION_DEPEND(ENABLE_GLES2 ENABLE_OPENGL)
# WEBKIT_OPTION_DEPEND(ENABLE_NETSCAPE_PLUGIN_API ENABLE_X11_TARGET)
# WEBKIT_OPTION_DEPEND(ENABLE_PLUGIN_PROCESS_GTK2 ENABLE_X11_TARGET)
# WEBKIT_OPTION_DEPEND(ENABLE_THREADED_COMPOSITOR ENABLE_OPENGL)
# WEBKIT_OPTION_DEPEND(ENABLE_WEBGL ENABLE_OPENGL)
# WEBKIT_OPTION_DEPEND(USE_REDIRECTED_XCOMPOSITE_WINDOW ENABLE_OPENGL)
# WEBKIT_OPTION_DEPEND(USE_REDIRECTED_XCOMPOSITE_WINDOW ENABLE_X11_TARGET)
# WEBKIT_OPTION_DEPEND(USE_GSTREAMER_GL ENABLE_OPENGL)
# WEBKIT_OPTION_DEPEND(USE_GSTREAMER_GL ENABLE_VIDEO)
# WEBKIT_OPTION_DEPEND(USE_GSTREAMER_MPEGTS ENABLE_VIDEO)

# SET_AND_EXPOSE_TO_BUILD(ENABLE_DEVELOPER_MODE ${DEVELOPER_MODE})
# if (DEVELOPER_MODE)
#     WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MINIBROWSER PUBLIC ON)
#     WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_API_TESTS PRIVATE ON)
# else ()
#     WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MINIBROWSER PUBLIC OFF)
#     WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_API_TESTS PRIVATE OFF)
#     set(WebKit2_VERSION_SCRIPT "-Wl,--version-script,${CMAKE_MODULE_PATH}/gtksymbols.filter")
# endif ()

# if (CMAKE_SYSTEM_NAME MATCHES "Linux")
#     WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MEMORY_SAMPLER PUBLIC ON)
# else ()
#     WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MEMORY_SAMPLER PUBLIC OFF)
# endif ()

# # Normally we do not set the value of options automatically. However, CairoGL is special. Currently
# # most major distros compile Cario with --enable-gl, but Debian and derivitives are a major
# # exception. You very probably want accelerated 2D canvas if Cario has been compiled with CarioGL,
# # and very probably do not want to recompile Cario otherwise. So we expect some major distros will
# # enable this feature, and others will not, and that is just fine for the time being. Once Debian
# # enables CairoGL, then it will be time to force this ON by default. Note that if GLX is installed,
# # EGL is not, and ENABLE_X11_TARGET is OFF, this guess is wrong and the user must override it. We
# # can't check ENABLE_X11_TARGET at this point because we don't know whether it's enabled until
# # WEBKIT_OPTION_END has been called, and at that point it's too late to change default values.
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_ACCELERATED_2D_CANVAS PUBLIC ${CAIROGL_FOUND})

# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CREDENTIAL_STORAGE PUBLIC ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(WEBKIT_OPTION_DEFAULT_PORT_VALUE OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CSS_COMPOSITING PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_DRAG_SUPPORT PUBLIC ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_GEOLOCATION PUBLIC ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_ICONDATABASE PUBLIC OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_JIT PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_DFG_JIT PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_SPELLCHECK PUBLIC ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_TOUCH_EVENTS PUBLIC OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_VIDEO PUBLIC ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_WEB_AUDIO PUBLIC ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(USE_SYSTEM_MALLOC PUBLIC OFF)

WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_3D_TRANSFORMS PRIVATE ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_ACCESSIBILITY PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_ACCESSIBILITY PRIVATE OFF) #//XXX: ON
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_ATTACHMENT_ELEMENT PRIVATE OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_BATTERY_STATUS PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CANVAS_PATH PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CSS3_TEXT PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CSS_DEVICE_ADAPTATION PRIVATE OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CSS_GRID_LAYOUT PRIVATE OFF) #recheck actual value
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CSS_IMAGE_SET PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CSS_REGIONS PRIVATE ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CSS_SELECTORS_LEVEL4 PRIVATE ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_CUSTOM_SCHEME_HANDLER PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_DATABASE_PROCESS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_DATALIST_ELEMENT PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_DOWNLOAD_ATTRIBUTE PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_ENCRYPTED_MEDIA PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_ENCRYPTED_MEDIA_V2 PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_FILTERS_LEVEL_2 PRIVATE OFF) #//XXX: ON?
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_FTPDIR PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_FULLSCREEN_API PRIVATE ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_GAMEPAD PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_GAMEPAD_DEPRECATED PRIVATE OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_INDEXED_DATABASE PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_INDEXED_DATABASE_IN_WORKERS PRIVATE OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_INPUT_TYPE_COLOR PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_LEGACY_WEB_AUDIO PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_LINK_PREFETCH PRIVATE ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MEDIA_CAPTURE PRIVATE OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MEDIA_CONTROLS_SCRIPT PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_MHTML PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_NAVIGATOR_CONTENT_UTILS PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_NAVIGATOR_HWCONCURRENCY PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_NETSCAPE_PLUGIN_API PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_NOTIFICATIONS PRIVATE ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_PICTURE_SIZES PRIVATE ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_PUBLIC_SUFFIX_LIST PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_QUOTA PRIVATE OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_RESOLUTION_MEDIA_QUERY PRIVATE ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_REQUEST_ANIMATION_FRAME PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_SECCOMP_FILTERS PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_SMOOTH_SCROLLING PRIVATE ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_SUBTLE_CRYPTO PRIVATE OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_TEMPLATE_ELEMENT PRIVATE OFF)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_USERSELECT_ALL PRIVATE ON)
# WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_USER_MESSAGE_HANDLERS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_VIBRATION PRIVATE OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_VIDEO PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_VIDEO_TRACK PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_VIEW_MODE_CSS_MEDIA PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_WEB_TIMING PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_WEBGL PRIVATE OFF)

WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_INPUT_TYPE_DATE PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_INPUT_TYPE_DATETIMELOCAL PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_INPUT_TYPE_DATETIME_INCOMPLETE PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_INPUT_TYPE_MONTH PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_INPUT_TYPE_TIME PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_INPUT_TYPE_WEEK PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_LEGACY_NOTIFICATIONS PRIVATE ON)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_SVG_OTF_CONVERTER PRIVATE OFF)



# Finalize the value for all options. Do not attempt to use an option before
# this point, and do not attempt to change any option after this point.
WEBKIT_OPTION_END()


set(ENABLE_WEBKIT OFF)
set(ENABLE_WEBKIT2 OFF)
add_definitions(-DBUILDING_JAVA__=1)
add_definitions(-DDATA_DIR="${CMAKE_INSTALL_DATADIR}")
# add_definitions(-DUSE_CROSS_PLATFORM_CONTEXT_MENUS=1)

set(FORWARDING_HEADERS_DIR ${DERIVED_SOURCES_DIR}/ForwardingHeaders)


set(WTF_LIBRARY_TYPE STATIC)
# set(JavaScriptCore_LIBRARY_TYPE OBJECT)
# set(WebCore_LIBRARY_TYPE OBJECT)
# set(WTF_LIBRARY_TYPE STATIC)


if (CMAKE_MAJOR_VERSION LESS 3)
    # Before CMake 3 it was necessary to use a build script instead of using cmake --build directly
    # to preserve colors and pretty-printing.

    build_command(COMMAND_LINE_TO_BUILD)
    # build_command unconditionally adds -i (ignore errors) for make, and there's
    # no reasonable way to turn that off, so we just replace it with -k, which has
    # the same effect, except that the return code will indicate that an error occurred.
    # See: http://www.cmake.org/cmake/help/v3.0/command/build_command.html
    string(REPLACE " -i" " -k" COMMAND_LINE_TO_BUILD ${COMMAND_LINE_TO_BUILD})
    file(WRITE
        ${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/build.sh
        "#!/bin/sh\n"
        "${COMMAND_LINE_TO_BUILD} $@"
    )
    file(COPY ${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/build.sh
        DESTINATION ${CMAKE_BINARY_DIR}
        FILE_PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE
    )
endif ()
