#
#    Copyright 2012, 2013, 2014 Thomas Schöps
#    Copyright 2012-2016 Kai Pastor
#    
#    This file is part of OpenOrienteering.
# 
#    OpenOrienteering is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    OpenOrienteering is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with OpenOrienteering.  If not, see <http://www.gnu.org/licenses/>.

TEMPLATE = subdirs
CONFIG  += c++11
CONFIG  -= debug_and_release

include("oo-mapper-version.pri")


# Prerequisites configuration
#
# addPrerequisite(target, subdir)                Adds the given subdir as
#                                                prerequisite to the target.
# addPrerequisite(target, prerequisite, subdir)  Adds the given prerequisite
#                                                name and subdir to the target.
#
# Prerequisite directories must create a <prerequisite>.pri file in their output dir.

PREREQUISITES_PRI = \
  "$$LITERAL_HASH Generated by $$_PRO_FILE_"

defineTest(addPrerequisite) {
	!contains(SUBDIRS, $$2) {
		target = $$2
		subdir = $$3
		isEmpty(subdir): subdir = $$2
		
		SUBDIRS += $$target
		export(SUBDIRS)
		
		$${target}.subdir = $$subdir
		export($${target}.subdir)
		
		PREREQUISITES_PRI += "include($$OUT_PWD/$${subdir}/$${target}.pri)"
		export(PREREQUISITES_PRI)

		empty =
		write_file($$OUT_PWD/$${subdir}/$${target}.pri, empty, append)

		$${1}.depends += $$target
		export($${1}.depends)
		
		return(true)
	}
}

addPrerequisite(src, libocd, src/libocad)
addPrerequisite(src, clipper, 3rd-party/clipper)
addPrerequisite(src, qbezier, 3rd-party/qbezier)
!android:addPrerequisite(src, qtsingleapplication, 3rd-party/qtsingleapplication)
!linux:addPrerequisite(src, proj, 3rd-party/proj)
android:addPrerequisite(src, proj, 3rd-party/proj)
CONFIG(gdal) {
	addPrerequisite(src, gdal, 3rd-party/gdal)
	!linux:gdal.depends += proj
	android:gdal.depends += proj
}
addPrerequisite(src, licensing, doc/licensing)
!android:addPrerequisite(src, printsupport, src/printsupport)
# Doxygen: Separate test and prerequisite, or Qt Creator gets confused.
DOXYGEN = $$system(doxygen -v 2>/dev/null)
isEmpty(DOXYGEN): addPrerequisite(manual, doxygen, 3rd-party/doxygen)

write_file($$OUT_PWD/prerequisites.pri, PREREQUISITES_PRI)


# CMake toolchain file for prerequisites compilation 

CMAKE_TOOLCHAIN = \
	"$$LITERAL_HASH Generated by $$_PRO_FILE_" \
   	"set(Mapper_VERSION_MAJOR $$Mapper_VERSION_MAJOR)" \
   	"set(Mapper_VERSION_MINOR $$Mapper_VERSION_MINOR)" \
   	"set(Mapper_VERSION_PATCH $$Mapper_VERSION_PATCH)" \
	"set(Mapper_VERSION_DISPLAY \"$${Mapper_VERSION_MAJOR}.$${Mapper_VERSION_MINOR}.$${Mapper_VERSION_PATCH}\")" \
	"find_program(CMAKE_C_COMPILER \"$$QMAKE_CC\")" \
	"find_program(CMAKE_CXX_COMPILER \"$$QMAKE_CXX\")" \
	"include_directories($$QMAKE_INCDIR)" \
	"link_directories($$QMAKE_LIBDIR)" \
	"set(CMAKE_USER_MAKE_RULES_OVERRIDE \"$$OUT_PWD/override.cmake\")"

CMAKE_OVERRIDE = \
	"$$LITERAL_HASH Generated by $$_PRO_FILE_" \
	"set(CMAKE_C_FLAGS_INIT          \"$$QMAKE_CFLAGS\")" \
	"set(CMAKE_CXX_FLAGS_INIT        \"$$QMAKE_CXXFLAGS\")" \
	"set(CMAKE_EXE_LINKER_FLAGS_INIT \"$$QMAKE_LFLAGS $$QMAKE_LFLAGS_APP\")"

CONFIG(debug, release|debug) {
	CMAKE_TOOLCHAIN += \
	  "set(Mapper_VERSION_DISPLAY \"Debug \${Mapper_VERSION_DISPLAY}\")"
	CMAKE_OVERRIDE += \
	  "set(CMAKE_C_FLAGS_INIT   \"\${CMAKE_C_FLAGS_INIT} $$QMAKE_CFLAGS_DEBUG $$QMAKE_CFLAGS_WARN_ON\")" \
	  "set(CMAKE_CXX_FLAGS_INIT \"\${CMAKE_CXX_FLAGS_INIT} $$QMAKE_CXXFLAGS_DEBUG $$QMAKE_CFLAGS_WARN_ON\")"
} else:CONFIG(release) {
	CMAKE_OVERRIDE += \
	  "set(CMAKE_C_FLAGS_INIT   \"\${CMAKE_C_FLAGS_INIT} $$QMAKE_CFLAGS_RELEASE $$QMAKE_CFLAGS_WARN_OFF\")" \
	  "set(CMAKE_CXX_FLAGS_INIT \"\${CMAKE_CXX_FLAGS_INIT} $$QMAKE_CXXFLAGS_RELEASE $$QMAKE_CFLAGS_WARN_OFF\")"
}

win32:gcc: CMAKE_TOOLCHAIN += \
	"set(CMAKE_SYSTEM_NAME Windows)" \
	"execute_process(COMMAND \"$$QMAKE_CC\" -dumpmachine OUTPUT_VARIABLE GNU_SYSTEM_NAME OUTPUT_STRIP_TRAILING_WHITESPACE)" \
	"string(REGEX REPLACE \"gcc$\" windres CMAKE_RC_COMPILER \"$$QMAKE_CC\")" \
	"set(MINGW 1)"

osx: CMAKE_OVERRIDE += \
	"set(CMAKE_C_FLAGS_INIT   \"\${CMAKE_C_FLAGS_INIT} -mmacosx-version-min=$$QMAKE_MACOSX_DEPLOYMENT_TARGET\")" \
	"set(CMAKE_CXX_FLAGS_INIT \"\${CMAKE_CXX_FLAGS_INIT} -mmacosx-version-min=$$QMAKE_MACOSX_DEPLOYMENT_TARGET -std=c++11 -stdlib=libc++\")"  \
	"set(CMAKE_EXE_LINKER_FLAGS_INIT \"\${CMAKE_EXE_LINKER_FLAGS_INIT} -mmacosx-version-min=$$QMAKE_MACOSX_DEPLOYMENT_TARGET\")"


android: CMAKE_TOOLCHAIN += \
	"set(ANDROID 1)" \
	"set(CMAKE_SYSTEM_NAME Linux)" \
	"set(GNU_SYSTEM_NAME $$NDK_TOOLS_PREFIX)" \
	"set(NDK_TOOLCHAIN_PATH $$NDK_TOOLCHAIN_PATH)"

contains(SUBDIRS, doxygen): CMAKE_TOOLCHAIN += \
	"list(APPEND CMAKE_PREFIX_PATH \"$$OUT_PWD/3rd-party/doxygen/doxygen/doxygen-project-prefix\")"

write_file($$OUT_PWD/toolchain.cmake, CMAKE_TOOLCHAIN)
write_file($$OUT_PWD/override.cmake,  CMAKE_OVERRIDE)


# Mapper build

SUBDIRS  += \
  manual \
  examples \
  symbol_sets \
  translations \
  src

manual.subdir = doc/manual
symbol_sets.subdir = "symbol sets"

OTHER_FILES += \
  COPYING \
  INSTALL
