set(MPI_FOUND FALSE)

if(ENABLE_SGI_MPT)
    set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} -lmpi")
    set(CMAKE_C_FLAGS       "${CMAKE_C_FLAGS}       -lmpi")
    set(CMAKE_CXX_FLAGS     "${CMAKE_CXX_FLAGS}     -lmpi -lmpi++")
    set(MPI_FOUND TRUE)
endif()

if(ENABLE_MPI)
    if(ENABLE_CRAY_WRAPPERS)
        message("-- Use CRAY wrappers; this disables MPI detection")
        set(MPI_FOUND TRUE)
    else()
        find_package(MPI REQUIRED)
	set(CMAKE_C_FLAGS       "${CMAKE_C_FLAGS}       ${MPI_C_COMPILE_FLAGS}")
	set(CMAKE_CXX_FLAGS     "${CMAKE_CXX_FLAGS}     ${MPI_CXX_COMPILE_FLAGS}")
	set(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} ${MPI_Fortran_COMPILE_FLAGS}")
        include_directories("${MPI_INCLUDE_PATH}")
	add_definitions(-DHAVE_MPI)
    endif()
endif()
