/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "engines/advancedDetector.h"

#include "base/plugins.h"
#include "testbed/testbed.h"

static const PlainGameDescriptor testbed_setting[] = {
	{ "testbed", "Testbed: The Backend Testing Framework" },
	{ 0, 0 }
};

static const DebugChannelDef debugFlagList[] = {
	{Testbed::kTestbedLogOutput, "LOG", "Log of test results generated by testbed"},
	{Testbed::kTestbedEngineDebug, "Debug", "Engine-specific debug statements"},
	DEBUG_CHANNEL_END
};

static const ADGameDescription testbedDescriptions[] = {
	{
		"testbed",
		"",
		AD_ENTRY1("TESTBED", 0),	// Game-data file for detection
		Common::EN_ANY,
		Common::kPlatformDOS,
		ADGF_NO_FLAGS,
		GUIO1(GUIO_NOLAUNCHLOAD)
	},
	AD_TABLE_END_MARKER
};

class TestbedMetaEngineDetection : public AdvancedMetaEngineDetection {
public:
	TestbedMetaEngineDetection() : AdvancedMetaEngineDetection(testbedDescriptions, sizeof(ADGameDescription), testbed_setting) {
		_md5Bytes = 512;
	}

	const char *getName() const override {
		return "testbed";
	}

	const char *getEngineName() const override {
		return "TestBed: The Backend Testing Framework";
	}

	const char *getOriginalCopyright() const override {
		return "Copyright (C) ScummVM";
	}

	const DebugChannelDef *getDebugChannels() const override {
		return debugFlagList;
	}
};

REGISTER_PLUGIN_STATIC(TESTBED_DETECTION, PLUGIN_TYPE_ENGINE_DETECTION, TestbedMetaEngineDetection);
