#include "DBThreadPool.hh"
//#include "DBThreadWorker.hh"
#include "ace/Method_Object.h"
#include <fstream>

class TestMO: public ACE_Method_Object {

public:

  TestMO (int number) { cerr << "Constructed TestMO: " << _number << endl;  _number = number; } ;
  ~TestMO() { cerr << "Destroyed TestMO: " << _number << endl; };
  int call () { cerr << "Hey, we're TestMO: " << _number << endl; return 0; };

private:

  int _number;

};




int main() {

  //DBThreadWorker* worker = new DBThreadWorker("Yep!",4);
  DBThreadPool pool;

  ACE_LOG_MSG->enable_debug_messages();    
  ACE_OS::sleep(ACE_Time_Value(2));
  
  for (int i=0;i<10000000;i++) {

    
    for (int j=0;j<10;j++)
      pool.growThreadsByOne();
    
    pool.checkmem("MEM: GrowThreads");
    ACE_OS::sleep(ACE_Time_Value(1));
	  
    for (int j=0; j<10; j++) {
      pool.submit(new TestMO(j));
      pool.checkmem("MEM: Submitted TestMO()");
    }

    ACE_OS::sleep(ACE_Time_Value(1));
    for (int j=0;j<10;j++)
      pool.shrinkThreadsByOne();
    
    pool.checkmem("MEM: Shrink Threads");
    ACE_OS::sleep(ACE_Time_Value(0.25));
	 
	

  }





}
