dnl acinclude.m4 - autoconf macros for Dynamic DNS Tools
dnl
dnl Copyright (C) 2000, 2001 Remi Lefebvre and Luca Filipozzi
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

dnl MY_LIB_PATH(LIBRARY, PATH [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(MY_LIB_PATH,
[
  my_LDFLAGS="$LDFLAGS"
  my_library_name=[$1]
  my_search_path=[$2]
  my_result_path=""
  AC_MSG_CHECKING([for $my_library_name library in $my_search_path])
  for my_dir in $my_search_path; do
    test -z "$my_dir" && ac_dir=.
    if test -f $my_dir/lib$my_library_name.a; then
      my_result_path=$my_dir
      break
    fi
    if test -f $my_dir/lib$my_library_name.so; then
      my_result_path=$my_dir
      break
    fi
  done
  if ! test -z "$my_result_path"; then
    AC_MSG_RESULT([yes])
    LDFLAGS="-L$my_result_path $my_LDFLAGS"
    ifelse([$3], , , [$3])
  else
    AC_MSG_RESULT([no])
    ifelse([$4], , , [$4])
  fi
])

dnl MY_HEADER_PATH(HEADER, PATH [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
AC_DEFUN(MY_HEADER_PATH,
[
  my_CPPFLAGS="$CPPFLAGS"
  my_header=[$1]
  my_search_path=[$2]
  my_result_path=""
  AC_MSG_CHECKING([for $my_header header in $my_search_path])
  for my_dir in $my_search_path; do
    test -z "$my_dir" && ac_dir=.
    if test -f $my_dir/$my_header; then
      my_result_path=$my_dir
      break
    fi
  done
  if ! test -z "$my_result_path"; then
    AC_MSG_RESULT([yes])
    CPPFLAGS="-I$my_result_path $my_CPPFLAGS"
    ifelse([$3], , , [$3])
  else
    AC_MSG_RESULT([no])
    ifelse([$4], , , [$4])
  fi
])

dnl MY_CHECK_TYPE(TYPE, DEFAULT, HEADER)
AC_DEFUN(MY_CHECK_TYPE,
[AC_REQUIRE([AC_HEADER_STDC])dnl
AC_MSG_CHECKING(for $1 in $3)
AC_CACHE_VAL(ac_cv_type_$1,
[AC_EGREP_CPP(dnl
changequote(<<,>>)dnl
<<(^|[^a-zA-Z_0-9])$1[^a-zA-Z_0-9]>>dnl
changequote([,]), [#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
#include <$3>
], ac_cv_type_$1=yes, ac_cv_type_$1=no)])dnl
AC_MSG_RESULT($ac_cv_type_$1)
if test $ac_cv_type_$1 = no; then
  AC_DEFINE($1, $2)
fi
])

