/* -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * DbAdmin.h
 *   Class for database interaction from the CGI and the admin tool.
 *
 * $Id: DbAdmin.h,v 1.12 2002/03/30 22:21:17 benoit Exp $
 *
 * Copyright (c) 2000-2001 Remi Lefebvre <remi@ddts.org>
 * Copyright (c) 2000 Benoit Joly <benoit@dhis.net>
 *
 * Licensed under the GPLv2
 */

#ifndef DBADMIN_H
#define DBADMIN_H

#include <opt.h>
#include <openssl/md5.h>
#include <arpa/inet.h> // for string to ip conversion

// general defines
#include "global.h"

#include "Exception.h"
#include "Logger.h"

#include "DdtManager.h"
#include "Validate.h"

#define CONF_FILE "cgi.conf"

class DbAdmin
{
public:

    // default constructor
    DbAdmin(Logger *, char *, char *, char *, char *, char *, char *);

    // destructor
    ~DbAdmin();

    /* These are for the CGI exclusively */
    
    // verify password
    int checkPasswd(int id, char *aPass, char *aPassMd5);

    // hash password and verify confirmation
    int hashPassword(const char *Pass, const char *PassConfirm, 
                     char *PassMd5);

    /**************************************/

    /* These are for the admn tool exclusively */

    // dump information concerning given uid
    int dumpInfo(int id);

    /*****************************************/

    /* The rest is for both */
    
    // add an account
    bool addAccount(userAccount *newAccount, const char *baseDomain);

    // update an account
    bool updateAccount(userAccount *newAccount, const char *baseDomain);

    // remove an account
    int removeAccount(int id);

    // records operations
    int addDnsRecord(int id, const char *dname, DnsRecordType type, 
                     const char *data, const char *baseDomain);

    int delDnsRecord(int id, const char *dname, DnsRecordType type,
                     const char *data);

    // fetch account information
    bool getAcctInfo(int id, userAccount *account);


    
private:
    Logger *log;
    Db *db;
    Dns *dns;
    DdtManager *manager;
    Validate *check;

//    regex_t *reg;
};


#endif // DBADMIN_H
