#ifndef __USERACCOUNT_H__
#define __USERACCOUNT_H__

/**
 * Structure to hold user account informations. This has the same
 * format as the database table.
 */
typedef struct userAccount
{
    /// ID of the account
    int  userAccountId;
    /// md5 hash of the admin password
    char adminPassword[32+1];
    /// md5 hash of the update password
    char updatePassword[32+1];
    /// contact name
    char contactName[64+1];
    /// contact email
    char contactEmail[64+1];
    /// computer architecture of host
    char arch[16+1];
    /// operating system used on host
    char os[16+1];
    /// host has statically assigned IP address
    int  hostStatus;
    /// fqdn of the account
    char fqdn[MAX_FQDN_LENGTH];
    /// current IP address
    char ipAddress[MAX_ADDR_LENGTH];
} UserAccount;

#endif
