

/**
 * The reserved key words for column names.
 */
static gchar *reserved_field[] = {

	/* Not postgres reserved, but sql92, sql93 reserved, 
	 * wich if used as function names are translated to 
	 * the funcion length */
	"CHAR_LENGTH",
	"CHARACTER_LENGTH",
	
	/* Not postgres reserved, but if used as column 
	 * names are translated */
	"BOOLEAN",
	"DOUBLE",
	"FLOAT",
	"INT",
	"INTEGER",
	"INTERVAL",
	"REAL",
	"SMALLINT",
	
	/* Not reserved (6.4) but night me reserved in the future */
	"ALLOCATE",
	"ARE",
	"ASSERTION",
	"AT",
	"AUTHORIZATION",
	"AVG" ,
	"BIT",
	"BIT_LENGTH",
	"CASCADED" ,
	"CASE" ,
	"CATALOG",
	"COALESCE",
	"COLLATION",
	"CONNECT",
	"CONNECTION",
	"CONSTRAINTS",
	"CONTINUE",
	"CONVERT",
	"CORRESPONDING",
	"COUNT",
	"DATE",
	"DEALLOCATE",
	"DEC",
	"DESCRIBE",
	"DESCRIPTOR",
	"DIAGNOSTICS",
	"DISCONNECT",
	"DOMAIN" ,
	"ELSE",
	"END-EXEC",
	"ESCAPE",
	"EXCEPT",
	"EXCEPTION",
	"EXEC",
	"EXTERNAL", 
	"FIRST",
	"FOUND",
	"GET",
	"GLOBAL",
	"GO",
	"GOTO", 
	"IDENTITY",
	"IMMEDIATE",
	"INDICATOR",
	"INITIALLY",
	"INPUT",
	"INTERSECT", 
	"ISOLATION",
	"LAST",
	"LEVEL",
	"LOWER",
	"MAX",
	"MIN",
	"MODULE", 
	"NULLIF",
	"OCTET_LENGTH",
	"OPEN",
	"OUTPUT",
	"OVERLAPS", 
	"PREPARE",
	"PRESERVE", 
	"RESTRICT",
	"ROWS",
	"SCHEMA",
	"SECTION",
	"SESSION",
	"SESSION_USER",
	"SIZE",
	"SOME" ,
	"SQL",
	"SQLCODE",
	"SQLERROR",
	"SQLSTATE",
	"SUM",
	"SYSTEM_USER",
	"TEMPORARY",
	"THEN",
	"TRANSLATE",
	"TRANSLATION",  
 	"UNKNOWN",
	"UPPER",
	"USAGE",
	"VALUE",
	"WHEN",
	"WHENEVER",
	"WRITE",
	NULL
};

	


/**
 * The reserved key words for identifiers
 */
static gchar *reserved_id[] = {
	
	/* PostgreSQL rserved word, valid as columns names, 
	 * but not as identifiers */
	"ABORT",
	"ANALYZE", 
	"BINARY", 
	"CLUSTER", 
	"CONSTRAINT", 
	"COPY",
	"DO",
	"EXPLAIN", 
	"EXTEND",
	"LISTEN",
	"LOAD",
	"LOCK",
	"MOVE",
	"NEW",
	"NONE",
	"NOTIFY",
	"RESET",
	"SETOF",
	"SHOW",
	"UNLISTEN",
	"UNTIL",
	"VACUUM",
	"VERBOSE",
	"CROSS",
	"CURRENT", 
	"FALSE",
	"FOREIGN", 
	"GROUP",
	"ORDER",
	"POSITION",
	"PRECISION", 
	"TABLE",
	"TRANSACTION",
	"TRUE",
	
	/* PostgreSQL, sql92 , sql93 reserved words, valid as column names,
	 * but not as identifiers */
	
	"ADD", 
	"ALL",
	"ALTER", 
	"AND",
	"ANY", 
	"AS", 
	"ASC", 
	"BEGIN", 
	"BETWEEN", 
	"BOTH" ,
	"BY" ,
	"CASCADE", 
	"CAST" ,
	"CHAR" ,
	"CHARACTER",
	"CHECK",
	"CLOSE",
	"COLLATE",
	"COLUMN",
	"COMMIT",
	"CONSTRAINT",
	"CREATE",
	"CURRENT_DATE",
	"CURRENT_TIME" ,
	"CURRENT_TIMESTAMP",
	"CURRENT_USER",
	"CURSOR",
	"DECIMAL",
	"DECLARE",
	"DEFAULT",
	"DELETE",
	"DESC",
	"DISTINCT",
	"DROP",
	"END",
	"EXECUTE",
	"EXISTS",
	"EXTRACT",
	"FETCH",
	"FLOAT",
	"FOR",
	"FROM",
	"FULL",
	"GRANT", 
	"HAVING",
	"IN",
	"INNER",
	"INSERT",
	"INTERVAL",
	"INTO",
	"IS",
	"JOIN", 
	"LEADING",
	"LEFT",
	"LIKE",
	"LOCAL",
	"NAME",
	"NAMES",
	"NATIONAL",
	"NATURAL",
	"NCHAR",
	"NO",
	"NOT",
	"NULL",
	"NUMERIC",
	"ON",
	"OR",
 	"OUTER",
	"PARTIAL",
	"PRIMARY",
	"PRIVILEGES",
	"PROCEDURE",
	"PUBLIC",
	"REFERENCES",
	"REVOKE" ,
 	"RIGHT",
	"ROLLBACK",
	"SELECT",
	"SET",
	"SUBSTRING",
	"TO",
	"TRAILING",
	"TRIM",
	"UNION",
	"UNIQUE",
	"UPDATE",
	"USER",
	"USING",
	"VALUES",
	"VARCHAR",
	"VARYING",
	"VIEW",
	"WHERE",
	"WITH",
	"WORK",
	
	/* Not postgres reserved, but sql92, sql93 reserved, 
	 * wich if used as function names are translated to 
	 * the funcion length */
	"CHAR_LENGTH",
	"CHARACTER_LENGTH",
	
	/* Not postgres reserved, but if used as column 
	 * names are translated */
	"BOOLEAN",
	"DOUBLE",
	"FLOAT",
	"INT",
	"INTEGER",
	"INTERVAL",
	"REAL",
	"SMALLINT",
	
	/* Not reserved (6.4) but night me reserved in the future */
	"ALLOCATE",
	"ARE",
	"ASSERTION",
	"AT",
	"AUTHORIZATION",
	"AVG" ,
	"BIT",
	"BIT_LENGTH",
	"CASCADED" ,
	"CASE" ,
	"CATALOG",
	"COALESCE",
	"COLLATION",
	"CONNECT",
	"CONNECTION",
	"CONSTRAINTS",
	"CONTINUE",
	"CONVERT",
	"CORRESPONDING",
	"COUNT",
	"DATE",
	"DEALLOCATE",
	"DEC",
	"DESCRIBE",
	"DESCRIPTOR",
	"DIAGNOSTICS",
	"DISCONNECT",
	"DOMAIN" ,
	"ELSE",
	"END-EXEC",
	"ESCAPE",
	"EXCEPT",
	"EXCEPTION",
	"EXEC",
	"EXTERNAL", 
	"FIRST",
	"FOUND",
	"GET",
	"GLOBAL",
	"GO",
	"GOTO", 
	"IDENTITY",
	"IMMEDIATE",
	"INDICATOR",
	"INITIALLY",
	"INPUT",
	"INTERSECT", 
	"ISOLATION",
	"LAST",
	"LEVEL",
	"LOWER",
	"MAX",
	"MIN",
	"MODULE", 
	"NULLIF",
	"OCTET_LENGTH",
	"OPEN",
	"OUTPUT",
	"OVERLAPS", 
	"PREPARE",
	"PRESERVE", 
	"RESTRICT",
	"ROWS",
	"SCHEMA",
	"SECTION",
	"SESSION",
	"SESSION_USER",
	"SIZE",
	"SOME" ,
	"SQL",
	"SQLCODE",
	"SQLERROR",
	"SQLSTATE",
	"SUM",
	"SYSTEM_USER",
	"TEMPORARY",
	"THEN",
	"TRANSLATE",
	"TRANSLATION",  
 	"UNKNOWN",
	"UPPER",
	"USAGE",
	"VALUE",
	"WHEN",
	"WHENEVER",
	"WRITE",
	NULL
};

	
