/* This file is Copyright 1993 by Clifford A. Adams */
/* sgcmd.c
 *
 * group scan command interpreter
 */

#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "final.h"		/* assert() */
#include "init.h"
#include "cache.h"
#include "bits.h"
#include "ngdata.h"		/* abs1st[] */
#include "rcln.h"		/* ngmax[] */
#include "rcstuff.h"		/* toread[] */
#include "ng.h"			/* setdflt() */
#include "scan.h"
#include "scmd.h"
#include "sdisp.h"
#include "smisc.h"	/* needed? */
#include "sorder.h"
#include "spage.h"
#include "sgroup.h"
#include "sgdata.h"
#include "sgfile.h"
#include "sgmisc.h"
#include "svirt.h"		/* virtual group scan mode */
#include "term.h"
#include "trn.h"		/* ng */
#include "util.h"
#include "sconfig.h"		/* configuration menu */
#include "INTERN.h"
#include "sgcmd.h"

void
sg_go_bot()
{
    s_ref_all = TRUE;
    s_goxy(0,LINES-s_bot_lines);	/* go to bottom bar */
    erase_eol();			/* erase to end of line */
    s_goxy(0,LINES-s_bot_lines);	/* go (back?) to bottom bar */
    fflush(stdout);			/* do it *now* */
}

/* Fill page, edit file, or go up one context as a last resort.
 * (One only needs to go up once, since files and lists are always
 *  eligible.  The proof is trivial, and left to the reader.)
 */
void
sg_fill_edit_or_up()
{
    if (s_fillpage()<=0) {	/* nothing eligible on page */
	printf("Nothing eligible in the file.\n") FLUSH;
	printf("Type the 'E' key for the editing menu,\n");
	printf("or type any other key to return.\n") FLUSH;
	getcmd(buf);
	if ((*buf == 'e') || (*buf == 'E')) {
	    s_go_bot();
	    sg_ext_menu();
	    s_ref_all = TRUE;
	    s_refill = TRUE;
	}
	if ((sg_num_contexts>1) && (s_fillpage()<=0)) {
	    /* if we cannot fill a page, go back up */
	    sg_old_context();	/* go back up */
	}
    }
}

/* interprets command in TRN-global buf */
int
sg_docmd()
{
    long a;		/* entry pointed to */
    int i;		/* for misc. purposes */
    long grp;		/* misc group number */
    bool flag;		/* misc */
    char ch;		/* misc */

    a = page_ents[s_ptr_page_line].entnum;
    switch(*buf) {
	case 'Q':	/* quit from group scan to old newsgroup level */
	    sg_loop = FALSE;
	    sg_go_bot();
	    return(SG_RETURN);
	case '\n':
	case ' ':	/* enter group/context by default */
	    if (group_default) {
		dfltcmd = group_default;
	    } else {
		dfltcmd = "+";
#ifdef SCAN
/*		dfltcmd = ";";	/* uncomment here for article-scan default */
#endif
	    }
	    setdef(buf,dfltcmd);
	    /* FALL THROUGH */
	case '+':	/* read group by command */
	case ';':
	case '=':
	case 'y':
/* AIEEEEE!  A goto must be lurking somewhere! */
sg_do_group:
	    sg_go_bot();
	    s_refill = TRUE;
	    s_ref_all = TRUE;
	    switch (sg_ents[a].type) {
		case 1:		/* normal newsgroup */
		    ch = *buf;		/* save the command character */
		    sg_toread(sg_ents[a].groupnum,FALSE);
		    grp = sg_groups[sg_ents[a].groupnum].rcnum;
		    if ((grp<0) || (grp>nextrcline)) {
			/* ick.  try not to crash... */
			s_beep();
			sg_go_bot();
			printf("This group no longer exists.\n") FLUSH;
			printf("Possibly an internal error.\n");
			printf("Press any key to continue\n");
			(void)get_anything();
			eat_typeahead();
			return(0);
		    }
		    if (toread[grp] < TR_UNSUB) {
			s_beep();
			return(0);
		    }
		    if (toread[grp] == TR_UNSUB) {
			printf("Resubscribe to %s?\n",
				sg_groups[sg_ents[a].groupnum].name) FLUSH;
			(void)getcmd(buf);
			if ((*buf!='y') && (*buf!='Y') && (*buf!=' ')) {
			    s_ref_all = TRUE;	/* refill and refresh all */
			    return(0);
			}
			sg_subscribe(sg_ents[a].groupnum);
			/* later ask about reading now? */
		    }
		    if ((toread[grp] == 0) && (ngmax[grp]<abs1st[grp])) {
			s_beep();
			return(0);
		    }
		    /* for thread selector, use set-unread if none unread */
		    if ((toread[grp] == 0) && (ch == '+'))
			ch = 'U';
		    /* if typed 'y', go to first article */
		    if (ch == 'y')
			ch = '^';
		    /* for moment, all names are same as group names */
		    sg_go_ng(sg_groups[grp].name);
		    sg_lastent_read = a;
		    printf("Going to newsgroup %s\n",
			sg_groups[grp].name) FLUSH;
		    /* don't remember why lastchar should be set */
		    lastchar = buf[0] = ch;
		    buf[1] = '\0';
		    s_save_context();
		    xmouse_off();
		    i = do_newsgroup(savestr(buf));
		    xmouse_on();
		    eat_typeahead();
		    sg_force_read = FALSE;	/* reset it */
		    /* return to the group scan-context */
		    s_change_context(sg_contexts[sg_num_contexts-1].cnum);
		    /* go to next/previous group if requested */
		    a = 0;
		    switch (i) {
		        /* case codes modified from scmd.c */
			case NG_SELPRIOR:
			    if (s_ptr_page_line>0) { /* more on page... */
				s_ptr_page_line -=1;
				a = page_ents[s_ptr_page_line].entnum;
			    } else {
				if (!s_prev_elig(page_ents[0].entnum)) {
				    a = 0;
				} else {
				    s_go_prev_page();
				    /* go to page bot. */
				    s_ptr_page_line = s_bot_ent;
				    a = page_ents[s_ptr_page_line].entnum;
				}
			    }
			    break;
			case NG_SELNEXT:
			    if (s_ptr_page_line<(s_bot_ent)) {
				/* more on page... */
				s_ptr_page_line +=1;
				a = page_ents[s_ptr_page_line].entnum;
			    } else {
				if(!s_next_elig(page_ents[s_bot_ent].entnum)){
				    a = 0;
				} else {
				    /* will jump to top too... */
				    s_go_next_page();
				    a = page_ents[s_ptr_page_line].entnum;
				}
			    }
			    break;
		    }
		    if (a) {	/* moving to next/prior group */
			*buf = ch;
			goto sg_do_group;
		    }
		    return(0);		    
		case 2:		/* file */
		    flag = sg_use_file(sg_ents[a].restrict,sg_ents[a].name);
		    if (!flag) {
			printf("Could not open file.\n") FLUSH;
			eat_typeahead();
			(void)get_anything();
			return(0);
		    }
		    sg_fill_edit_or_up();
		    return(0);	/* carry on... */
		case 3:		/* restriction list */
		    sg_use_restrict(sg_ents[a].restrict,
				     sg_ents[a].name);
		    if (s_fillpage()<=0) {
			/* if we cannot fill a page, go back up */
			s_beep();		/* alert the user */
			printf("Nothing eligible in list.\n") FLUSH;
			printf("Press any key to continue\n");
			(void)get_anything();
			eat_typeahead();
			sg_old_context();	/* go back up */
			s_ref_all = TRUE;	/* refill and refresh all */
		    }
		    return(0);	/* carry on... */
		case 4:		/* virtual newsgroup */
		    sg_go_bot();
		    s_save_context();
		    (void)sv_main(sg_ents[a].restrict,sg_ents[a].name);
		    /* return to the group scan-context */
		    s_change_context(sg_contexts[sg_num_contexts-1].cnum);
		    if (sg_changed_newsrc)
			sg_reinit_groups();
		    s_ref_all = TRUE;
		    return(0);
		case 5:		/* text */
		    sg_go_bot();
		    sg_show_text(sg_ents[a].restrict);
		    s_ref_all = TRUE;
		    return(0);
	    }
	    printf("Entry pointed to has an illegal type!\n") FLUSH;
	    assert(FALSE);
	    /* NOTREACHED */
	case 'q':	/* quit from context or strn */
	    /* maybe make behavior optional (sg_fastquit variable?) */
	    if (sg_num_contexts==1) {		/* at top */
		sg_loop = FALSE;
		sg_fakecmd = "q";
		sg_go_bot();
		return(SG_FAKE);
	    }
	    /* FALL THROUGH */
	case '(':	/* go up a context */
	    if (sg_num_contexts<2) {	/* already at top */
		s_beep();
		break;
	    }
	    sg_go_bot();
	    sg_old_context();	/* maybe call a wrapper later */
	    s_refill = TRUE;
	    s_ref_all = TRUE;	/* refill and refresh all */
	    break;
	case Ctl('e'):		/* edit current file */
	    for (i=sg_num_contexts-1;i>=0;i--)
		if (sg_contexts[i].filename)
		    break;
	    if (i<0) {
		s_beep();
		break;
	    }
	    xmouse_off();
	    sg_edit_file();
	    xmouse_on();
	    /* consider handling return value later */
	    (void)sg_reuse_file();
	    sg_fill_edit_or_up();
	    s_refill = TRUE;
	    s_ref_all = TRUE;
	    break;
	case 'L':	/* display newsgroup descriptions */
	    if (sg_desc_unavail) {
		sg_go_bot();
		printf("Newsgroup descriptions are unavailable now.\n") FLUSH;
		printf("Press any key to continue\n");
		(void)get_anything();
		eat_typeahead();
		break;
	    }
	    sg_use_desc = !sg_use_desc;
	    if (sg_use_desc)
		sg_look_num = 0;	/* reset lookahead */
	    s_refill = TRUE;
	    s_ref_all = TRUE;	/* refill and refresh all */
	    break;
	case 'A':	/* display all newsgroups */
	    sg_mode_allgroups = !sg_mode_allgroups;
	    sg_mode_unsub = FALSE;
	    s_refill = TRUE;
	    s_ref_all = TRUE;
	    break;
	case 'U':	/* show unsubscribed only */
	    sg_mode_unsub = !sg_mode_unsub;
	    sg_mode_allgroups = FALSE;
	    s_refill = TRUE;
	    s_ref_all = TRUE;
	    break;
	case '0':	/* show groups with 0 unread articles */
	    sg_mode_zero = !sg_mode_zero;
	    s_refill = TRUE;
	    s_ref_all = TRUE;
	    break;
	case 'u':	/* toggle subscription */
	    if (sg_ents[a].type != 1) {		/* not a newsgroup */
		s_beep();
		break;
	    }
	    sg_toread(sg_ents[a].groupnum,FALSE);
	    grp = sg_groups[sg_ents[a].groupnum].rcnum;
	    if ((grp<0) || (grp>nextrcline)) {
		/* ick.  let's not crash though... */
		s_beep();
		sg_go_bot();
		printf("This newsgroup no longer exists.\n") FLUSH;
		printf("Possibly an internal error.\n");
		printf("Press any key to continue\n");
		getcmd(buf);
		eat_typeahead();
		return(0);
	    }
	    if (toread[grp] < TR_UNSUB)
		break;		/* don't mess with these groups */
	    else if (toread[grp] == TR_UNSUB)
		sg_subscribe(sg_ents[a].groupnum);
	    else		/* subscribed group */
		sg_unsubscribe(sg_ents[a].groupnum);
	    s_refill = TRUE;
	    s_ref_all = TRUE;	/* refill and refresh all */
	    break;
	case 'c':	/* catch-up */
	    if (sg_ents[a].type != 1) {		/* not a newsgroup */
		s_beep();
		break;
	    }
	    sg_go_bot();
	    s_refill = TRUE;
	    s_ref_all = TRUE;	/* refill and refresh all */
	    grp = sg_groups[sg_ents[a].groupnum].rcnum;
	    if ((grp<0) || (grp>nextrcline)) {
		/* ick.  let's not crash though... */
		s_beep();
		sg_go_bot();
		printf("The pointed-to newsgroup no longer exists.\n") FLUSH;
		printf("Possibly an internal error.\n");
		printf("Press any key to continue\n");
		getcmd(buf);
		eat_typeahead();
		return(0);
	    }
	    ng = grp;
	    printf("Newsgroup %s:\n",rcline[ng]) FLUSH;
	    ch = mode;
	    mode = 'n';		/* act as if in newsgroup mode */
	    ask_catchup();
	    mode = ch;
	    break;
	case 'R':	/* re-check number of articles in all groups */
	    for (i=0;i<sg_num_groups;i++)
		sg_groups[i].flags &= ~2;	/* force a re-check */
	    fclose(actfp);
	    ngdata_init();	/* re-grab the active file */
	    /* consider handling return value later */
	    (void)sg_reuse_file();
	    sg_fill_edit_or_up();
	    s_refill = TRUE;
	    s_ref_all = TRUE;
	    break;
	case 'E':	/* group scan editing menu */
	    s_go_bot();
	    sg_ext_menu();
	    sg_fill_edit_or_up();
	    s_ref_all = TRUE;
	    s_refill = TRUE;
	    break;
	case 'e':	/* edit configuration */
	    s_go_bot();
	    xmouse_off();
	    scf_menu();
	    xmouse_on();
	    sg_fill_edit_or_up();
	    s_ref_all = TRUE;
	    s_refill = TRUE;
	    break;
	default:
	    s_beep();
	    break;
    }
    return(0);
}
#endif /* SCAN */
