/* This file is Copyright 1993 by Clifford A. Adams */
/* svirt.h
 *
 * Virtual scan main
 */

/* return codes */
#define SV_QUIT (-1)
#define SV_ERR (-2)
#define SV_FAKE (-3)
#define SV_RETURN (-4)

/* if true, strn is "in" a virtual newsgroup */
EXT bool sv_loop		INIT(FALSE);
/* if true, a virtual newsgroup is initialized */
EXT bool sv_initialized		INIT(FALSE);

/* if true, virtual scan mode is setting up. */
EXT bool sv_in_setup		INIT(FALSE);

/* if non-zero, this is an article number to read */
EXT ART_NUM sv_article		INIT(0);

/* if TRUE, the newsgroup mode should quit fast */
/* (The old newsgroup data was cleaned up and strn might not be
 *  in the same newsgroup, so don't try to clean up.
 */
EXT bool sv_ng_quit_fast	INIT(FALSE);

/* if TRUE, virtual scan is in follow mode */
EXT bool sv_follow		INIT(TRUE);

/* if TRUE, virtual scan is reading an article (used for follow) */
EXT bool sv_reading		INIT(FALSE);

/* put these somewhere else later? */

/* the difference between the _f_ and _e_ requirements is that the
 * _f_ (filter) articles which score outside the range are not added,
 * while the ones outside the _e_ (eligible) range are not displayed.
 * The eligibility range can be changed while reading a group.
 */

/* if true, only unread articles are added to a virtual group */
EXT bool sv_f_unread		INIT(TRUE);
/* if true, only unread articles are eligible for display */
EXT bool sv_e_unread		INIT(TRUE);

/* if true, use a minimum score requirement to add to virtual group */
EXT bool sv_f_minused		INIT(FALSE);
/* the minimum score requirement to add to virtual group */
EXT long sv_f_minscore		INIT(0);
/* if true, use a maximum score requirement to add to virtual group */
EXT bool sv_f_maxused		INIT(FALSE);
/* the maximum score requirement to add to virtual group */
EXT long sv_f_maxscore		INIT(0);

/* if true, use a minimum score for virtual group display eligibility */
EXT bool sv_e_minused		INIT(FALSE);
/* the minimum score for virtual group display eligibility */
EXT long sv_e_minscore		INIT(0);
/* if true, use a maximum score for virtual group display eligibility */
EXT bool sv_e_maxused		INIT(FALSE);
/* the maximum score for virtual group display eligibility */
EXT long sv_e_maxscore		INIT(0);

#ifdef SCORE
EXT bool sv_score_order		INIT(TRUE);
#else
EXT bool sv_score_order		INIT(FALSE);
#endif

#ifdef SCORE
EXT bool sv_show_score		INIT(TRUE);
#endif
EXT bool sv_show_author		INIT(TRUE);
EXT bool sv_show_subject	INIT(TRUE);
/* show the newsgroup the article is from */
EXT bool sv_show_groups		INIT(TRUE);
/* show subjects *only*, and not use any descriptions */
EXT bool sv_show_subjects_only	INIT(FALSE);

/* for faking up commands */
EXT char sv_fakecmd[LBUFLEN];

EXT char *sv_groupcmd		INIT((char*)NULL);
EXT char *sv_artcmd		INIT((char*)NULL);

int	sv_main		_((char*,char*));
bool	sv_init		_((char*,char*));
int	sv_continue	_((void));
