/*
 * list.h: header for list.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: list.h,v 1.4 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _LIST_H_
#define _LIST_H_

#include "irc_std.h"

typedef	struct	list_stru
{
	struct	list_stru	*next;
	char	*name;
}	List;

extern	void	add_to_list _((List **, List *));
extern	List	*find_in_list _((List **, char *, int));
extern	List	*remove_from_list _((List **, char *));
extern	List	*list_lookup _((List **, char *, int, int));
extern	List	*remove_from_list_ext _((List **, char *, int (*) _((List *, char *))));
extern	void	add_to_list_ext _((List **, List *, int (*) _((List *, List *))));
extern	List	*find_in_list_ext _((List **, char *, int, int (*) _((List *, char *))));

#define REMOVE_FROM_LIST 1
#define USE_WILDCARDS 1

#endif /* _LIST_H */
