package fix;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * A JFrame for displaying error messages.
 * 
 * This class prints the exceptions' stack trace if debugging is enabled.
 * 
 * $Date: 2010-02-04 12:01:01 +0100 (Thu, 04 Feb 2010) $
 * $Revision: 30 $
 * $Author: roth $
 * 
 * @author Dominik
 * 
 * Copyright (C) 2008 Dominik Greibl
 * Copyright (C) 2009 Sebastian Roth
 * 
 * All Rights Reserved
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

public class ErrorWindow extends JFrame implements ActionListener {

	private static final long serialVersionUID = 5502194335124559523L;
	private String mess = "";
	private JPanel contentPane = null;
	private JButton okButton = null;
	private JLabel messLabel = null;
	private JLabel errLabel = null;
	private JPanel buttonPanel = null;
	private JPanel messPanel = null;
	private JPanel errPanel = null;
	private Exception e = null;
	private boolean d = false;

	/**
	 * The default constructor
	 * 
	 * @param message
	 *            message to be displayed
	 * @param e1
	 *            Exception that is thrown (may be null)
	 * @param debug
	 *            Flag to set debugging
	 */
	public ErrorWindow(String message, Exception e1, boolean debug) {
		super();
		mess = message;
		e = e1;
		d = debug;
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 */
	private void initialize() {
		messLabel = new JLabel(mess);
		FontMetrics fm = getFontMetrics(messLabel.getFont());
		int width = fm.stringWidth(mess) + 40;
		int height = 100;
		int x = (int) Toolkit.getDefaultToolkit().getScreenSize().getWidth()
				/ 2 - width / 2;
		int y = (int) Toolkit.getDefaultToolkit().getScreenSize().getHeight()
				/ 2 - height / 2;
		this.setBounds(x, y, width, height);
		this.setContentPane(getJContentPane());
		this.setFocusable(true);
		this.setTitle("Error");
	}

	/**
	 * This method initializes ContentPane
	 * 
	 * @return JPanel
	 */
	private JPanel getJContentPane() {
		if (contentPane == null) {
			contentPane = new JPanel();
			contentPane.setLayout(new BorderLayout());
			contentPane.add(getMessPanel(), BorderLayout.NORTH);
			contentPane.add(getErrPanel(), BorderLayout.CENTER);
			contentPane.add(getButtonPanel(), BorderLayout.SOUTH);
		}
		return contentPane;
	}

	/**
	 * This method initializes okButton
	 * 
	 * @return JButton
	 */
	private JButton getOkButton() {
		if (okButton == null) {
			okButton = new JButton("OK");
			okButton.addActionListener(this);
		}
		return okButton;
	}

	public void actionPerformed(ActionEvent e) {
		this.setTitle("Error");
		this.setVisible(false);
	}

	/**
	 * This method initializes buttonPanel
	 * 
	 * @return JPanel
	 */
	public JPanel getButtonPanel() {
		if (buttonPanel == null) {
			buttonPanel = new JPanel(new FlowLayout());
			buttonPanel.add(getOkButton(), null);
		}
		return buttonPanel;
	}

	/**
	 * This method initializes messPanel
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getMessPanel() {
		if (messPanel == null) {
			messPanel = new JPanel();
			messPanel.setLayout(new FlowLayout());
			messPanel.add(messLabel);
		}
		return messPanel;
	}

	/**
	 * This method initializes errPanel
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getErrPanel() {
		if (errPanel == null) {
			errPanel = new JPanel();
			errLabel = new JLabel("");
			if (e != null) {
				errLabel.setText(e.getMessage());
			}
		}
		return errPanel;
	}

	/**
	 * This method sets the ErrorWindow's size matching to the message
	 * displayed.
	 * 
	 * @param m
	 *            The message to be displayed.
	 */
	public void setSize(String m) {
		FontMetrics fm = getFontMetrics(messLabel.getFont());
		int width = fm.stringWidth(mess) + 40;
		setSize(width, this.getHeight());
	}

	/**
	 * This method updates the message displayed and displays the possible
	 * Exception.
	 * 
	 * @param message
	 * @param e1
	 */
	public void setMess(String message, Exception e1) {
		if (d) {
			System.err.println(message);
			if (e1 != null)
				e1.printStackTrace();
		}
		mess = message;
		e = e1;
		if (e != null)
			errLabel.setText(e.getMessage());
		messLabel.setText(mess);
		setSize(mess);
		this.setVisible(true);
	}

	/**
	 * This method updates the message&title to be displayed and displays the dialog
	 * Exception.
	 * 
	 * @param message
	 * @param title
	 * @param e1
	 */
	public void setMess(String message, String title, Exception e1) {
		if (d) {
			System.err.println(message);
			if (e1 != null)
				e1.printStackTrace();
		}
		mess = message;
		e = e1;
		if (e != null)
			errLabel.setText(e.getMessage());
		messLabel.setText(mess);
		setSize(mess);
		this.setTitle(title);
		this.setVisible(true);
	}

	/**
	 * Returns the current set error message 
	 * 
	 * @return javax.swing.JLabel
	 */
	public JLabel getErrLabel() {
		return errLabel;
	}

} // @jve:decl-index=0:visual-constraint="10,10"
