#ifndef backend_h
#define backend_h
#include "config.h" // HAVE_LIBIPQ*
#include <linux/netfilter.h>
#include <netinet/in.h>
#include <syslog.h>
#include <openssl/ssl.h>
#include <net/if.h>
extern "C" {
//#include <libipq/libipq/libipq.h>
#ifdef HAVE_LIBIPQ_H
  #include <libipq.h>
#elif HAVE_LIBIPQ_LIBIPQ_H
  #include <libipq/libipq.h>
#endif
}
#include <stdio.h>
#include <iostream>
#include <time.h>
#include <signal.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <linux/icmp.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <libxml/parser.h>
//#include <unistd.h>
#include <errno.h>
#include <string>
#include <stdlib.h>
#include <pthread.h>
#include "../include/fireflier.h" // do NOT include AFTER rules.h
#include "queue.h" // a simple queue which supports iterator, maximum queue length
#include "rules.h" // manage iptables rules
#include "ports.h" // resolve localip/localport to programname
#include "pam.h" // authentication

using namespace std;

class packet {
public:
    unsigned long packet_id; // unique packet id, needed for accepting or dropping a packet (libipq)
    unsigned long arrived; // time the packet arrived (in seconds)
    unsigned char interface_in[IFNAMSIZ]; // name of incoming interface
    unsigned char interface_out[IFNAMSIZ]; // name of outgoing interface
    unsigned short int len; // length of packet data
    unsigned long ip_src; // source ip
    unsigned long ip_dst; // destination ip
    unsigned int protocol:8; // protocol id (see rules.h)

    unsigned short int port_src; // source port
    unsigned short int port_dst; // destination port

    unsigned short int tcp_flags; // tcp flags: ACK, FIN, RST, SYN, ...

    unsigned int icmp_type:8; // type of icmp packet

    unsigned int mac_addrlen:8; // real length of mac address 
    unsigned char mac_addr[8]; // mac is maximum 8 bytes
    unsigned int hook; // chain (INPUT=1, FORWARD=2, OUTPUT=3)
    char *data; // packet data
    char *programname; // program using this packets localport/localip
    ~packet();
};

class tentry {
public:
    char *buf; // which elements are considered important by rule (1= important, 0=not important)
    unsigned long timeout; // timeout if a rule entry
    int action; // action to be taken
    packet *pack; // copy of corresponding packet
    tentry(char *buf, packet *ptr, int act); 
    ~tentry();
};
// queue containing rules which have timeout
class queue *timeoutqueue;
// queue of userspace rules
class queue *userspacequeue;

// queue of "pending packets"
class queue *packetqueue;

// currently active packet
packet *currentPacket;

// socket of the client
//int clientSocket=-1;

// if 1 then when have to remove iptables rules on abort.
int rules_active;

struct ipq_handle *h;

// mutual exclusion for queues
pthread_mutex_t lock_mutex;

SSL *ssl;
SSL_CTX *ssl_ctx;

SSL *ssl_auth; // ssl object of the connected client
bool daemonize=false; // needed in finalize

extern int errno;
// handler for SIGINT, SIGTERM
void finalize(int sig);
void saveuserspacerules();
int saveUserspaceRulesXml(string filename);

// default values for configs
char *Config_ssl_file="/etc/fireflier/fireflier.pem";
char *Config_save_file="/var/lib/fireflier/usrules.xml";
int Config_port=1133;
int Config_create_queue_rules=1;
char *Config_ssl_password="password";
char *Config_client_ip="127.0.0.1";
char *Config_pid_file="/var/run/fireflier.pid";

#endif
