#ifndef CRESOLVERTHREAD_H
#define CRESOLVERTHREAD_H

#include "CkjThread.h"
#include "CSemaphore.h"
#include <netinet/in.h>


/**	resolves an ip address to the hostname and signals the gui-thread through a dispatcher.
 *	<br>
 *	there is no need for mutexing the variables
 *	@author triendl.kj
 */
class CResolverThread: public CkjThread
{
public:
	typedef SigC::Signal1 <void, const char*> signal_resolved_t;
	typedef SigC::Slot1 <void, const char*> slot_resolved_t;


private:
	bool m_bDoRun;
	in_addr_t m_nIP; ///< current ip
	in_addr_t m_nIPPrev; ///< previous ip
	signal_resolved_t m_signalResolved; ///< signal to connect to
	CSemaphore m_semResolve; ///< signaled in @see resolve if an ip address is to resolve
	Glib::Mutex m_sync;


public:
	CResolverThread();
	virtual ~CResolverThread()
	{}
		

protected:
	virtual void run();
		
public:
	/**	resolves an ip address to the hostname and emits a signal. @see signal_resolved
	 */
	void resolve(in_addr_t nIP);

	/**	if you wanna be nice, finish the thread.
	 */
	void finish()
	{
		m_bDoRun = false;
		m_semResolve.post(); // finish run()
	}
	
	/**	signal you can connect to. emitted if resolving ended, no matter whether successful or not.
	 *	for type of signal and slot @see signal_resolved_t, @see slot_resolved_t
	 */
	signal_resolved_t& signal_resolved()
	{
		return m_signalResolved;
	}
};

#endif
