#!/bin/sh
# $Id: solaris8.sh,v 1.11 2001/11/13 14:29:42 acormier Exp $
# Template updated by Paul Khavkine <paul@colba.net>
# Thanks paul.

LANGUAGE=C

if [ -z "$TSP_VERBOSE" ]; then
   TSP_VERBOSE=0
fi

KillProcess()
{
   if [ ! -z $TSP_VERBOSE ]; then
      if [ $TSP_VERBOSE -ge 2 ]; then
         echo killing $*
      fi
   fi
   /bin/pkill $1
}

Display()
{
   if [ -z "$TSP_VERBOSE" ]; then
      return;
   fi
   if [ $TSP_VERBOSE -lt $1 ]; then
      return;
   fi
   shift
   echo $*
}

Exec()
{
   if [ ! -z "$TSP_VERBOSE" ]; then
      if [ $TSP_VERBOSE -ge 2 ]; then
         echo $*
      fi
   fi
   $* # Execute command
   if [ $? -ne 0 ]; then
      echo "Error while executing $1"
      echo "   Command: $*"
      exit 1
   fi
}

# Program localization 

Display 1 "--- Start of configuration script. ---"
Display 1 "Script: " `basename $0`

ifconfig=/sbin/ifconfig
route=/usr/sbin/route
inetinit=/etc/init.d/inetinit
ndpd=/usr/lib/inet/in.ndpd
ndd=/usr/sbin/ndd
ripngd=/usr/lib/inet/in.ripngd

ndpdconfigfilename=ndpd.conf
ndpdconfigfile=$TSP_HOME_DIR/$ndpdconfigfilename

if [ -z "$TSP_HOME_DIR" ]; then
   echo "TSP_HOME_DIR variable not specified!;"
   exit 1
fi

if [ ! -d $TSP_HOME_DIR ]; then
   echo "Error : directory $TSP_HOME_DIR does not exist"
   exit 1
fi
#

if [ -z "$TSP_HOST_TYPE" ]; then
   echo Error: TSP_HOST_TYPE not defined.
   exit 1
fi

#change to upper case
TSP_HOST_TYPE=`echo $TSP_HOST_TYPE | tr -s [a-z] [A-Z]`

if [ X"${TSP_HOST_TYPE}" = X"HOST" ] || [ X"${TSP_HOST_TYPE}" = X"ROUTER" ]; then
   #
   # Configured tunnel config (IPv6) 
   Display 1 Setting up interface $TSP_TUNNEL_INTERFACE
   Exec $ifconfig $TSP_TUNNEL_INTERFACE inet6 plumb 
   Exec $ifconfig $TSP_TUNNEL_INTERFACE inet6 tsrc $TSP_CLIENT_ADDRESS_IPV4 tdst $TSP_SERVER_ADDRESS_IPV4 up
   Exec $ifconfig $TSP_TUNNEL_INTERFACE inet6 addif $TSP_CLIENT_ADDRESS_IPV6 $TSP_SERVER_ADDRESS_IPV6 up 

   # Default route  
   Exec $route delete -inet6 default $TSP_SERVER_ADDRESS_IPV6 2>/dev/null
   Display 1 "Adding default route"
   Exec $route add -inet6 default $TSP_SERVER_ADDRESS_IPV6
   # If ndpd is configured, run it
   if [ -f /usr/lib/inet/in.ndpd ] ; then
      Display "Starting IPv6 neighbor discovery."
      Exec $ndpd
   fi

fi

# Host only configuration
if [ X"${TSP_HOST_TYPE}" = X"HOST" ]; then
   Display 1 "Host configuration"
   Exec $ndd -set /dev/ip ip6_forwarding 0
   Exec $ndd -set /dev/ip ip6_send_redirects 0
   Exec $ndd -set /dev/ip ip6_ignore_redirect 0
fi

# Router configuration if required
if [ X"${TSP_HOST_TYPE}" = X"ROUTER" ]; then
   Display 1 "Router configuration"
   Display 1 "Kernel setup"
   Exec $ndd -set /dev/ip ip6_forwarding 1
   Exec $ndd -set /dev/ip ip6_send_redirects 1
   Exec $ndd -set /dev/ip ip6_ignore_redirect 1
   if [ -f /usr/lib/inet/in.ndpd ]; then
     Display 1 Creating new $ndpdconfigfile
     echo "##### ndpd.conf made by TSP ####" > "$ndpdconfigfile"
     echo "ifdefault AdvSendAdvertisements true" >> "$ndpdconfigfile"
     echo "prefix $TSP_PREFIX:1::1/64 $TSP_HOME_INTERFACE" >> "$ndpdconfigfile"
     if [ -f $ndpdconfigfile ]; then
       Display "Starting IPv6 neighbor discovery."
       KillProcess $ndpd
       Exec $ndpd -f $ndpdconfigfile
     else
       echo "Error : file $ndpdconfigfile not found"
       exit 1
     fi
   fi
   if [ -f /usr/lib/inet/in.ripngd ]; then
     Display 1 "Starting IPv6 in.ripngd"
     Exec $ripngd -s
   fi
fi

Display 1 "--- End of configuration script. ---"

exit 0
