/* $Id: genpoly.h,v 1.7 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.7 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#ifndef SHAPES_H
#define SHAPES_H

#include "common/Geometry.h"

/*
 *	shape generators
 */
struct PolyDef {
	bool isEllipse;
	double aspect; // for ellipses only (y/x)
	int sides, // for polys only
		peripheries;
	double perispacing,
		rotation,
		skew,distortion;
	bool regular;   
	Coord interior_box, // minimum inside size (e.g. for text)
		exterior_box; // minimum outside size
	Line input; // overrides sides,input
	PolyDef() : isEllipse(false), aspect(1),sides(4),peripheries(0),perispacing(0),
		rotation(0),skew(0),distortion(0),regular(false),
		interior_box(0,0),exterior_box(0,0) {
	}
};

extern void genpoly(const PolyDef &arg,Lines &out);
Coord polysize(const Line &poly);

// exceptions
struct BadPolyBounds : DGException {
  BadPolyBounds() : DGException("must specify internal or external box of poly; no one-dimensional or negative boxes") {}
};
struct BadPolyDef : DGException { 
  BadPolyDef() : DGException("polygon must have at least three sides") {}
};
struct BadInputPoly : DGException {
    BadInputPoly() : DGException("polydef input poly must have degree>0 and size>2") {}
};

//bezier_t *genellipse(polyreq_t *arg);

#endif
