/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.21
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/*************************************************************** -*- c -*-
 * perl5/precommon.swg
 *
 * Rename all exported symbols from common.swg, to avoid symbol
 * clashes if multiple interpreters are included
 *
 ************************************************************************/

#define SWIG_TypeRegister    SWIG_Perl_TypeRegister
#define SWIG_TypeCheck       SWIG_Perl_TypeCheck
#define SWIG_TypeCast        SWIG_Perl_TypeCast
#define SWIG_TypeDynamicCast SWIG_Perl_TypeDynamicCast
#define SWIG_TypeName        SWIG_Perl_TypeName
#define SWIG_TypeQuery       SWIG_Perl_TypeQuery
#define SWIG_TypeClientData  SWIG_Perl_TypeClientData
#define SWIG_PackData        SWIG_Perl_PackData 
#define SWIG_UnpackData      SWIG_Perl_UnpackData 


/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#  if defined(_MSC_VER) || defined(__GNUC__)
#    if defined(STATIC_LINKED)
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) extern a
#    else
#      define SWIGEXPORT(a) __declspec(dllexport) a
#      define SWIGIMPORT(a) extern a
#    endif
#  else
#    if defined(__BORLANDC__)
#      define SWIGEXPORT(a) a _export
#      define SWIGIMPORT(a) a _export
#    else
#      define SWIGEXPORT(a) a
#      define SWIGIMPORT(a) a
#    endif
#  endif
#else
#  define SWIGEXPORT(a) a
#  define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#  define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#  define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);
SWIGIMPORT(char *)           SWIG_PackData(char *, void *, int);
SWIGIMPORT(char *)           SWIG_UnpackData(char *, void *, int);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti) {
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
  l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) {
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
        if ((strcmp(tc->name, equiv->name) == 0))
          SWIG_TypeClientData(tc,clientdata);
        tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

#endif

#ifdef __cplusplus
}
#endif

/* ---------------------------------------------------------------------- -*- c -*-
 * perl5.swg
 *
 * Perl5 runtime library
 * $Header: /cvsroot/SWIG/Lib/perl5/perlrun.swg,v 1.14 2003/12/04 19:14:14 beazley Exp $
 * ----------------------------------------------------------------------------- */

#define SWIGPERL
#define SWIGPERL5
#ifdef __cplusplus
/* Needed on some windows machines---since MS plays funny games with the header files under C++ */
#include <math.h>
#include <stdlib.h>
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Get rid of free and malloc defined by perl */
#undef free
#undef malloc

#ifndef pTHX_
#define pTHX_
#endif

#include <string.h>
#ifdef __cplusplus
}
#endif

/* Macro to call an XS function */

#ifdef PERL_OBJECT 
#  define SWIG_CALLXS(_name) _name(cv,pPerl) 
#else 
#  ifndef MULTIPLICITY 
#    define SWIG_CALLXS(_name) _name(cv) 
#  else 
#    define SWIG_CALLXS(_name) _name(PERL_GET_THX, cv) 
#  endif 
#endif 

/* Contract support */

#define SWIG_contract_assert(expr,msg) if (!(expr)) { SWIG_croak(msg); } else

/* Note: SwigMagicFuncHack is a typedef used to get the C++ compiler to just shut up already */

#ifdef PERL_OBJECT
#define MAGIC_PPERL  CPerlObj *pPerl = (CPerlObj *) this;
typedef int (CPerlObj::*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (CPerlObj::*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
#define SWIGCLASS_STATIC
#else
#define MAGIC_PPERL
#define SWIGCLASS_STATIC static
#ifndef MULTIPLICITY
#define SWIG_MAGIC(a,b) (SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(SV *, MAGIC *);

#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(SV *, MAGIC *);
#ifdef __cplusplus
}
#endif


#else
#define SWIG_MAGIC(a,b) (struct interpreter *interp, SV *a, MAGIC *b)
typedef int (*SwigMagicFunc)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
extern "C" {
#endif
typedef int (*SwigMagicFuncHack)(struct interpreter *, SV *, MAGIC *);
#ifdef __cplusplus
}
#endif

#endif
#endif

#if defined(WIN32) && defined(PERL_OBJECT) && !defined(PerlIO_exportFILE)
#define PerlIO_exportFILE(fh,fl) (FILE*)(fh)
#endif

/* Modifications for newer Perl 5.005 releases */

#if !defined(PERL_REVISION) || ((PERL_REVISION >= 5) && ((PERL_VERSION < 5) || ((PERL_VERSION == 5) && (PERL_SUBVERSION < 50))))
#  ifndef PL_sv_yes
#    define PL_sv_yes sv_yes
#  endif
#  ifndef PL_sv_undef
#    define PL_sv_undef sv_undef
#  endif
#  ifndef PL_na
#    define PL_na na
#  endif
#endif

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SWIG_OWNER 1
#define SWIG_SHADOW 2

/* Common SWIG API */

#ifdef PERL_OBJECT
#  define SWIG_ConvertPtr(obj, pp, type, flags) \
     SWIG_Perl_ConvertPtr(pPerl, obj, pp, type, flags)
#  define SWIG_NewPointerObj(p, type, flags) \
     SWIG_Perl_NewPointerObj(pPerl, p, type, flags)
#  define SWIG_MakePackedObj(sv, p, s, type)	\
     SWIG_Perl_MakePackedObj(pPerl, sv, p, s, type)
#  define SWIG_ConvertPacked(obj, p, s, type, flags) \
     SWIG_Perl_ConvertPacked(pPerl, obj, p, s, type, flags)

#else
#  define SWIG_ConvertPtr(obj, pp, type, flags) \
     SWIG_Perl_ConvertPtr(obj, pp, type, flags)
#  define SWIG_NewPointerObj(p, type, flags) \
     SWIG_Perl_NewPointerObj(p, type, flags)
#  define SWIG_MakePackedObj(sv, p, s, type)	\
     SWIG_Perl_MakePackedObj(sv, p, s, type )
#  define SWIG_ConvertPacked(obj, p, s, type, flags) \
     SWIG_Perl_ConvertPacked(obj, p, s, type, flags)
#endif

/* Perl-specific API */
#ifdef PERL_OBJECT
#  define SWIG_MakePtr(sv, ptr, type, flags) \
     SWIG_Perl_MakePtr(pPerl, sv, ptr, type, flags)
#  define SWIG_TypeCheckRV(rv, ty) \
     SWIG_Perl_TypeCheckRV(pPerl, rv, ty)
#  define SWIG_SetError(str) \
     SWIG_Perl_SetError(pPerl, str)
#else
#  define SWIG_MakePtr(sv, ptr, type, flags) \
     SWIG_Perl_MakePtr(sv, ptr, type, flags)
#  define SWIG_TypeCheckRV(rv, ty) \
     SWIG_Perl_TypeCheckRV(rv, ty)
#  define SWIG_SetError(str) \
     SWIG_Perl_SetError(str)
#  define SWIG_SetErrorSV(str) \
     SWIG_Perl_SetErrorSV(str)
#endif

#define SWIG_SetErrorf SWIG_Perl_SetErrorf


#ifdef PERL_OBJECT
#  define SWIG_MAYBE_PERL_OBJECT CPerlObj *pPerl,
#else
#  define SWIG_MAYBE_PERL_OBJECT
#endif

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(int)               SWIG_Perl_ConvertPtr(SWIG_MAYBE_PERL_OBJECT SV *, void **, swig_type_info *, int flags);
SWIGIMPORT(void)              SWIG_Perl_MakePtr(SWIG_MAYBE_PERL_OBJECT SV *, void *, swig_type_info *, int flags);
SWIGIMPORT(SV *)              SWIG_Perl_NewPointerObj(SWIG_MAYBE_PERL_OBJECT void *, swig_type_info *, int flags);
SWIGIMPORT(void)              SWIG_Perl_MakePackedObj(SWIG_MAYBE_PERL_OBJECT SV *, void *, int, swig_type_info *);
SWIGIMPORT(int)               SWIG_Perl_ConvertPacked(SWIG_MAYBE_PERL_OBJECT SV *, void *, int, swig_type_info *, int flags);
SWIGIMPORT(swig_type_info *)  SWIG_Perl_TypeCheckRV(SWIG_MAYBE_PERL_OBJECT SV *rv, swig_type_info *ty);
SWIGIMPORT(SV *)              SWIG_Perl_SetError(SWIG_MAYBE_PERL_OBJECT char *);

#else

SWIGRUNTIME(swig_type_info *)
SWIG_Perl_TypeCheckRV(SWIG_MAYBE_PERL_OBJECT SV *rv, swig_type_info *ty) {
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (sv_derived_from(rv, (char *) s->name)) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
        s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Function for getting a pointer value */

SWIGRUNTIME(int) 
SWIG_Perl_ConvertPtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void **ptr, swig_type_info *_t, int flags) {
  swig_type_info *tc;
  void *voidptr = (void *)0;

  /* If magical, apply more magic */
  if (SvGMAGICAL(sv))
    mg_get(sv);

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    SV *tsv = (SV*) SvRV(sv);
    IV tmp = 0;
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
        mg = mg_find(tsv,'P');
        if (mg) {
          SV *rsv = mg->mg_obj;
          if (sv_isobject(rsv)) {
            tmp = SvIV((SV*)SvRV(rsv));
          }
        }
      } else {
        return -1;
      }
    } else {
      tmp = SvIV((SV*)SvRV(sv));
    }
    voidptr = (void *)tmp;
    if (!_t) {
      *(ptr) = voidptr;
      return 0;
    }
  } else if (! SvOK(sv)) {            /* Check for undef */
    *(ptr) = (void *) 0;
    return 0;
  } else if (SvTYPE(sv) == SVt_RV) {  /* Check for NULL pointer */
    *(ptr) = (void *) 0;
    if (!SvROK(sv))
      return 0;
    else
      return -1;
  } else {                            /* Don't know what it is */
    *(ptr) = (void *) 0;
    return -1;
  }
  if (_t) {
    /* Now see if the types match */
    tc = SWIG_TypeCheckRV(sv,_t);
    if (!tc) {
      *ptr = voidptr;
      return -1;
    }
    *ptr = SWIG_TypeCast(tc,voidptr);
    return 0;
  }
  *ptr = voidptr;
  return 0;
}

SWIGRUNTIME(void)
SWIG_Perl_MakePtr(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, swig_type_info *t, int flags) {
  if (ptr && (flags & SWIG_SHADOW)) {
    SV *self;
    SV *obj=newSV(0);
    HV *hash=newHV();
    HV *stash;
    sv_setref_pv(obj, (char *) t->name, ptr);
    stash=SvSTASH(SvRV(obj));
    if (flags & SWIG_OWNER) {
      HV *hv;
      GV *gv=*(GV**)hv_fetch(stash, "OWNER", 5, TRUE);
      if (!isGV(gv))
        gv_init(gv, stash, "OWNER", 5, FALSE);
      hv=GvHVn(gv);
      hv_store_ent(hv, obj, newSViv(1), 0);
    }
    sv_magic((SV *)hash, (SV *)obj, 'P', Nullch, 0);
    SvREFCNT_dec(obj);
    self=newRV_noinc((SV *)hash);
    sv_setsv(sv, self);
    SvREFCNT_dec((SV *)self);
    sv_bless(sv, stash);
  }
  else {
    sv_setref_pv(sv, (char *) t->name, ptr);
  }
}

SWIGRUNTIME(SV *)
SWIG_Perl_NewPointerObj(SWIG_MAYBE_PERL_OBJECT void *ptr, swig_type_info *t, int flags) {
  SV *result = sv_newmortal();
  SWIG_MakePtr(result, ptr, t, flags);
  return result;
}

SWIGRUNTIME(void)
  SWIG_Perl_MakePackedObj(SWIG_MAYBE_PERL_OBJECT SV *sv, void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  strcpy(r,type->name);
  sv_setpv(sv, result);
}

/* Convert a packed value value */
SWIGRUNTIME(int)
SWIG_Perl_ConvertPacked(SWIG_MAYBE_PERL_OBJECT SV *obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c = 0;

  if ((!obj) || (!SvOK(obj))) return -1;
  c = SvPV(obj, PL_na);
  /* Pointer values must start with leading underscore */
  if (*c != '_') return -1;
  c++;
  c = SWIG_UnpackData(c,ptr,sz);
  if (ty) {
    tc = SWIG_TypeCheck(c,ty);
    if (!tc) return -1;
  }
  return 0;
}

SWIGRUNTIME(void)
SWIG_Perl_SetError(SWIG_MAYBE_PERL_OBJECT const char *error) {
  if (error) sv_setpv(perl_get_sv("@", TRUE), error);
}

SWIGRUNTIME(void)
SWIG_Perl_SetErrorSV(SWIG_MAYBE_PERL_OBJECT SV *error) {
  if (error) sv_setsv(perl_get_sv("@", TRUE), error);
}

SWIGRUNTIME(void)
SWIG_Perl_SetErrorf(const char *fmt, ...) {
  va_list args;
  va_start(args, fmt);
  sv_vsetpvfn(perl_get_sv("@", TRUE), fmt, strlen(fmt), &args, Null(SV**), 0, Null(bool*));
  va_end(args);
}

#endif

/* Macros for low-level exception handling */
#define SWIG_fail       goto fail
#define SWIG_croak(x)   { SWIG_SetError(x); goto fail; }
#define SWIG_croakSV(x) { SWIG_SetErrorSV(x); goto fail; }
/* most preprocessors do not support vararg macros :-( */
/* #define SWIG_croakf(x...) { SWIG_SetErrorf(x); goto fail; } */


typedef XS(SwigPerlWrapper);
typedef SwigPerlWrapper *SwigPerlWrapperPtr;

/* Structure for command table */
typedef struct {
  const char         *name;
  SwigPerlWrapperPtr  wrapper;
} swig_command_info;

/* Information for constant table */

#define SWIG_INT     1
#define SWIG_FLOAT   2
#define SWIG_STRING  3
#define SWIG_POINTER 4
#define SWIG_BINARY  5

/* Constant information structure */
typedef struct swig_constant_info {
    int              type;
    const char      *name;
    long             lvalue;
    double           dvalue;
    void            *pvalue;
    swig_type_info **ptype;
} swig_constant_info;

#ifdef __cplusplus
}
#endif

/* Structure for variable table */
typedef struct {
  const char   *name;
  SwigMagicFunc   set;
  SwigMagicFunc   get;
  swig_type_info  **type;
} swig_variable_info;

/* Magic variable code */
#ifndef PERL_OBJECT
#define swig_create_magic(s,a,b,c) _swig_create_magic(s,a,b,c)
  #ifndef MULTIPLICITY
     static void _swig_create_magic(SV *sv, char *name, int (*set)(SV *, MAGIC *), int (*get)(SV *,MAGIC *)) {
  #else
     static void _swig_create_magic(SV *sv, char *name, int (*set)(struct interpreter*, SV *, MAGIC *), int (*get)(struct interpreter*, SV *,MAGIC *)) {
  #endif
#else
#  define swig_create_magic(s,a,b,c) _swig_create_magic(pPerl,s,a,b,c)
static void _swig_create_magic(CPerlObj *pPerl, SV *sv, const char *name, int (CPerlObj::*set)(SV *, MAGIC *), int (CPerlObj::*get)(SV *, MAGIC *)) {
#endif
  MAGIC *mg;
  sv_magic(sv,sv,'U',(char *) name,strlen(name));
  mg = mg_find(sv,'U');
  mg->mg_virtual = (MGVTBL *) malloc(sizeof(MGVTBL));
  mg->mg_virtual->svt_get = (SwigMagicFuncHack) get;
  mg->mg_virtual->svt_set = (SwigMagicFuncHack) set;
  mg->mg_virtual->svt_len = 0;
  mg->mg_virtual->svt_clear = 0;
  mg->mg_virtual->svt_free = 0;
}






#ifdef do_open
  #undef do_open
#endif
#ifdef do_close
  #undef do_close
#endif
#ifdef scalar
  #undef scalar
#endif
#ifdef list
  #undef list
#endif
#ifdef apply
  #undef apply
#endif
#ifdef convert
  #undef convert
#endif
#ifdef Error
  #undef Error
#endif
#ifdef form
  #undef form
#endif
#ifdef vform
  #undef vform
#endif
#ifdef LABEL
  #undef LABEL
#endif
#ifdef METHOD
  #undef METHOD
#endif
#ifdef Move
  #undef Move
#endif
#ifdef yylex
  #undef yylex
#endif
#ifdef yyparse
  #undef yyparse
#endif
#ifdef yyerror
  #undef yyerror
#endif
#ifdef invert
  #undef invert
#endif
#ifdef ref
  #undef ref
#endif
#ifdef ENTER
  #undef ENTER
#endif


/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_resultCacheMemberObj swig_types[0] 
#define  SWIGTYPE_p_markerCacheMemberObj swig_types[1] 
#define  SWIGTYPE_p_labelCacheMemberObj swig_types[2] 
#define  SWIGTYPE_p_layer_obj swig_types[3] 
#define  SWIGTYPE_p_lineObj swig_types[4] 
#define  SWIGTYPE_p_pointObj swig_types[5] 
#define  SWIGTYPE_p_map_obj swig_types[6] 
#define  SWIGTYPE_p_p_char swig_types[7] 
#define  SWIGTYPE_p_mapObj swig_types[8] 
#define  SWIGTYPE_p_resultCacheObj swig_types[9] 
#define  SWIGTYPE_p_labelCacheObj swig_types[10] 
#define  SWIGTYPE_p_char swig_types[11] 
#define  SWIGTYPE_p_imageObj swig_types[12] 
#define  SWIGTYPE_p_hashTableObj swig_types[13] 
#define  SWIGTYPE_p_gdBuffer swig_types[14] 
#define  SWIGTYPE_p_symbolObj swig_types[15] 
#define  SWIGTYPE_p_shapefileObj swig_types[16] 
#define  SWIGTYPE_p_labelObj swig_types[17] 
#define  SWIGTYPE_p_colorObj swig_types[18] 
#define  SWIGTYPE_p_cgiRequestObj swig_types[19] 
#define  SWIGTYPE_p_rectObj swig_types[20] 
#define  SWIGTYPE_p_webObj swig_types[21] 
#define  SWIGTYPE_p_DBFInfo swig_types[22] 
#define  SWIGTYPE_p_layerObj swig_types[23] 
#define  SWIGTYPE_p_scalebarObj swig_types[24] 
#define  SWIGTYPE_p_referenceMapObj swig_types[25] 
#define  SWIGTYPE_p_queryMapObj swig_types[26] 
#define  SWIGTYPE_p_symbolSetObj swig_types[27] 
#define  SWIGTYPE_p_fontSetObj swig_types[28] 
#define  SWIGTYPE_p_shapeObj swig_types[29] 
#define  SWIGTYPE_p_projectionObj swig_types[30] 
#define  SWIGTYPE_p_intarray swig_types[31] 
#define  SWIGTYPE_p_FILE swig_types[32] 
#define  SWIGTYPE_p_classObj swig_types[33] 
#define  SWIGTYPE_p_errorObj swig_types[34] 
#define  SWIGTYPE_p_int swig_types[35] 
#define  SWIGTYPE_p_styleObj swig_types[36] 
#define  SWIGTYPE_p_labelPathObj swig_types[37] 
#define  SWIGTYPE_p_p_outputFormatObj swig_types[38] 
#define  SWIGTYPE_p_outputFormatObj swig_types[39] 
#define  SWIGTYPE_p_legendObj swig_types[40] 
static swig_type_info *swig_types[42];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    boot_mapscript

#define SWIG_name   "mapscriptc::boot_mapscript"
#define SWIG_prefix "mapscriptc::"

#ifdef __cplusplus
extern "C"
#endif
#ifndef PERL_OBJECT
#ifndef MULTIPLICITY
SWIGEXPORT(void) SWIG_init (CV* cv);
#else
SWIGEXPORT(void) SWIG_init (pTHXo_ CV* cv);
#endif
#else
SWIGEXPORT(void) SWIG_init (CV *cv, CPerlObj *);
#endif


#include "../../map.h"
#include "../../maptemplate.h"
#include "../../mapogcsld.h"
#include "../../mapows.h"
#include "../../cgiutil.h"
#include "../../mapcopy.h"
#include "../../maperror.h"
#include "../../mapprimitive.h"
#include "../../mapshape.h"

#ifdef SWIGPYTHON
#include "pygdioctx/pygdioctx.h"
#endif



#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


#define SWIG_exception(a,b)   SWIG_croak(b)


typedef int intarray;

intarray *new_intarray(int nelements){
  return (int *) calloc(nelements,sizeof(int));
}
void delete_intarray(intarray *self){
  free(self);
}
int intarray_getitem(intarray *self,int index){
  return self[index];
}
void intarray_setitem(intarray *self,int index,int value){
  self[index] = value;
}
int *intarray_cast(intarray *self){
  return self;
}
intarray *intarray_frompointer(int *t){
  return (intarray *) t;
}

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
    unsigned char *data;
    int size;
    int owns_data;
} gdBuffer;

#ifdef __cplusplus
}
#endif

outputFormatObj *new_outputFormatObj(char const *driver,char *name){
        outputFormatObj *format;

        format = msCreateDefaultOutputFormat(NULL, driver);

        /* in the case of unsupported formats, msCreateDefaultOutputFormat
           should return NULL */
        if (!format)
        {
            msSetError(12, "Unsupported format driver: %s",
                       "outputFormatObj()", driver);
            return NULL;
        }
        
        /* Else, continue */
        format->refcount++;
	format->inmapfile = 1;

        if (name != NULL)
        {
            free(format->name);
            format->name = strdup(name);
        }
        return format;
    }
void delete_outputFormatObj(outputFormatObj *self){
        if ( --self->refcount < 1 )
            msFreeOutputFormat( self );
    }
void outputFormatObj_setExtension(outputFormatObj *self,char const *extension){
        msFree( self->extension );
        self->extension = strdup(extension);
    }
void outputFormatObj_setMimetype(outputFormatObj *self,char const *mimetype){
        msFree( self->mimetype );
        self->mimetype = strdup(mimetype);
    }
void outputFormatObj_setOption(outputFormatObj *self,char const *key,char const *value){
        msSetOutputFormatOption( self, key, value );
    }
int outputFormatObj_validate(outputFormatObj *self){
       	return msOutputFormatValidate( self );
    }
char *outputFormatObj_getOption(outputFormatObj *self,char const *key,char const *value){
        const char *retval;
        retval = msGetOutputFormatOption(self, key, value);
        return strdup(retval);
    }
webObj *new_webObj(){
        webObj *web;
        web = (webObj *) malloc(sizeof(webObj));
        initWeb(web);
        return web;
    }
void delete_webObj(webObj *self){
        if (!self) return;
	freeWeb(self);
        free(self);
    }
styleObj *new_styleObj(classObj *parent_class){
    
        styleObj *style;
        int result;
        
        if (!parent_class) 
        { 
            style = (styleObj *) malloc(sizeof(styleObj));
            if (!style) return NULL;
            result = initStyle(style);
            if (result == MS_SUCCESS) 
            {
                style->isachild = 0;
                return style;
            }
            else 
            {
                msSetError(12, "Failed to initialize styleObj",
                                       "styleObj()");
                return NULL;
            }
        }
        else 
        {
            if (parent_class->numstyles == 5) 
            {
                msSetError(31, "Exceeded max number of styles: %d",
                           "styleObj()", 5);
                return NULL;
            }
            parent_class->numstyles++;
            return &(parent_class->styles[parent_class->numstyles-1]);
        }
    }
void delete_styleObj(styleObj *self){
        if (self->isachild == 0) 
            free(self);
    }
styleObj *styleObj_clone(styleObj *self){
        styleObj *style;

        style = (styleObj *) malloc(sizeof(styleObj));
        if (!style)
        {
            msSetError(2,
                "Could not allocate memory for new styleObj instance",
                "clone()");
            return NULL;
        }
        if (initStyle(style) == -1)
        {
            msSetError(2, "Failed to initialize Style",
                                  "clone()");
            return NULL;
        }

        if (msCopyStyle(style, self) != MS_SUCCESS)
        {
            free(style);
            return NULL;
        }
        
        style->isachild = 0;
        return style;
    }
int styleObj_setSymbolByName(styleObj *self,mapObj *map,char *symbolname){
        self->symbol = msGetSymbolIndex(&map->symbolset, symbolname, 1);
        if (self->symbolname) free((char*)self->symbolname);
        if (symbolname) self->symbolname = strdup(symbolname);
        else self->symbolname = 0;
        return self->symbol;
	}
classObj *new_classObj(layerObj *layer){
        classObj *new_class=NULL;
        
        if (!layer)
        {
            new_class = (classObj *) malloc(sizeof(classObj));
            if (!new_class)
            {
                msSetError(2,
                    "Could not allocate memory for new classObj instance",
                    "classObj()");
                return NULL;
            }
            if (initClass(new_class) == -1) return NULL;
            new_class->layer = NULL;
            return new_class;
        }
        else
        {
            if (layer->numclasses == 250)
            {
                msSetError(31, "Max number of classes reached",
                           "classObj()");
                return NULL;
            }
            if (initClass(&(layer->class[layer->numclasses])) == -1)
                return NULL;
            layer->class[layer->numclasses].type = layer->type;
            layer->class[layer->numclasses].layer = layer;
            layer->numclasses++;
            return &(layer->class[layer->numclasses-1]);
        }

        return NULL;
    }
void delete_classObj(classObj *self){
        if (!self->layer)
        {
            freeClass(self);
            free(self);
        }
    }
classObj *classObj_clone(classObj *self){
        classObj *new_class;

        new_class = (classObj *) malloc(sizeof(classObj));
        if (!new_class)
        {
            msSetError(2,
                "Could not allocate memory for new classObj instance",
                "clone()");
            return NULL;
        }
        if (initClass(new_class) == -1)
        {
            msSetError(2, "Failed to initialize Class",
                                  "clone()");
            return NULL;
        }
        new_class->layer = NULL;

        if (msCopyClass(new_class, self, self->layer) != MS_SUCCESS) {
            freeClass(new_class);
            free(new_class);
            new_class = NULL;
        }
        
        return new_class;
    }
int classObj_setExpression(classObj *self,char *expression){
    if (!expression || strlen(expression) == 0) {
       freeExpression(&self->expression);
       return MS_SUCCESS;
    }
    else return msLoadExpressionString(&self->expression, expression);
  }
char *classObj_getExpressionString(classObj *self){
    return msGetExpressionString(&(self->expression));
  }
int classObj_setText(classObj *self,char *text){
    if (!text || strlen(text) == 0) {
      freeExpression(&self->text);
      return MS_SUCCESS;
    }	
    else return msLoadExpressionString(&self->text, text);
  }
char *classObj_getTextString(classObj *self){
    return msGetExpressionString(&(self->text));
  }
char *classObj_getMetaData(classObj *self,char *name){
    char *value = NULL;
    if (!name) {
      msSetError(16, "NULL key", "getMetaData");
    }
     
    value = (char *) msLookupHashTable(&(self->metadata), name);
    if (!value) {
      msSetError(16, "Key %s does not exist", "getMetaData", name);
      return NULL;
    }
    return value;
  }
int classObj_setMetaData(classObj *self,char *name,char *value){
    if (msInsertHashTable(&(self->metadata), name, value) == NULL)
        return MS_FAILURE;
    return MS_SUCCESS;
  }
char *classObj_getFirstMetaDataKey(classObj *self){
    return (char *) msFirstKeyFromHashTable(&(self->metadata));
  }
char *classObj_getNextMetaDataKey(classObj *self,char *lastkey){
    return (char *) msNextKeyFromHashTable(&(self->metadata), lastkey);
  }
int classObj_drawLegendIcon(classObj *self,mapObj *map,layerObj *layer,int width,int height,imageObj *dstImage,int dstX,int dstY){
    return msDrawLegendIcon(map, layer, self, width, height, dstImage->img.gd, dstX, dstY);
  }
imageObj *classObj_createLegendIcon(classObj *self,mapObj *map,layerObj *layer,int width,int height){
    return msCreateLegendIcon(map, layer, self, width, height);
  }
styleObj *classObj_getStyle(classObj *self,int i){
        if (i >= 0 && i < self->numstyles)	
            return &(self->styles[i]);
        else {
            msSetError(31, "Invalid index: %d", "getStyle()", i);
            return NULL;
        }
    }
int classObj_insertStyle(classObj *self,styleObj *style,int index){
        return msInsertStyle(self, style, index);
    }
styleObj *classObj_removeStyle(classObj *self,int index){
        return (styleObj *) msRemoveStyle(self, index);
    }
int classObj_moveStyleUp(classObj *self,int index){
        return msMoveStyleUp(self, index);
    }
int classObj_moveStyleDown(classObj *self,int index){
       return msMoveStyleDown(self, index);
    }
void labelCacheObj_freeCache(labelCacheObj *self){
        msFreeLabelCache(self);    
    }
resultCacheMemberObj *resultCacheObj_getResult(resultCacheObj *self,int i){
        if (i >= 0 && i < self->numresults) {
            return &self->results[i];
        }
        return NULL;
    }
symbolSetObj *new_symbolSetObj(char const *symbolfile){
        symbolSetObj *symbolset;
        mapObj *temp_map=NULL;
        symbolset = (symbolSetObj *) malloc(sizeof(symbolSetObj));
        msInitSymbolSet(symbolset);
        if (symbolfile) {
            symbolset->filename = strdup(symbolfile);
            temp_map = msNewMapObj();
            msLoadSymbolSet(symbolset, temp_map);
            symbolset->map = NULL;
            msFreeMap(temp_map);
        }
        return symbolset;
    }
void delete_symbolSetObj(symbolSetObj *self){
        msFreeSymbolSet(self);
        if (self->filename) free(self->filename);
        free(self);
    }
symbolObj *symbolSetObj_getSymbol(symbolSetObj *self,int i){
        if (i >= 0 && i < self->numsymbols)	
            return (symbolObj *) &(self->symbol[i]);
        else
            return NULL;
    }
symbolObj *symbolSetObj_getSymbolByName(symbolSetObj *self,char *symbolname){
        int i;

        if (!symbolname) return NULL;

        i = msGetSymbolIndex(self, symbolname, 1);
        if (i == -1)
            return NULL;
        else
            return (symbolObj *) &(self->symbol[i]);
    }
int symbolSetObj_index(symbolSetObj *self,char *symbolname){
        return msGetSymbolIndex(self, symbolname, 1);
    }
int symbolSetObj_appendSymbol(symbolSetObj *self,symbolObj *symbol){
        return msAppendSymbol(self, symbol);
    }
symbolObj *symbolSetObj_removeSymbol(symbolSetObj *self,int index){
        return (symbolObj *) msRemoveSymbol(self, index);
    }
int symbolSetObj_save(symbolSetObj *self,char const *filename){
        return msSaveSymbolSet(self, filename);
    }
layerObj *new_layerObj(mapObj *map){
        layerObj *layer;
        int result;
        
        if (!map) {
            layer = (layerObj *) malloc(sizeof(layerObj));
            if (!layer) {
                msSetError(2, "Failed to initialize Layer",
                                       "layerObj()");
                return NULL;
            } 
            result = initLayer(layer, NULL);
            if (result == MS_SUCCESS) {
                layer->index = -1;
                return layer;
            }
            else {
                msSetError(2, "Failed to initialize Layer",
                                       "layerObj()");
                return NULL;
            }
        }
        else {
            if (map->numlayers == 200) {
                msSetError(31, "Max number of layers exceeded",
                                        "layerObj()");
                return(NULL);
            }

            if (initLayer(&(map->layers[map->numlayers]), map) == -1)
                return(NULL);

            map->layers[map->numlayers].index = map->numlayers;
            map->layerorder[map->numlayers] = map->numlayers;
            map->numlayers++;

            return &(map->layers[map->numlayers-1]);
        }
    }
void delete_layerObj(layerObj *self){
        if (!self->map) {
            freeLayer(self);
            free(self);
        }
    }
layerObj *layerObj_clone(layerObj *self){
        layerObj *layer;
        int result;

        layer = (layerObj *) malloc(sizeof(layerObj));
        if (!layer) {
            msSetError(2, "Failed to initialize Layer",
                                  "layerObj()");
            return NULL;
        } 
        result = initLayer(layer, NULL);
        if (result != MS_SUCCESS) {
            msSetError(2, "Failed to initialize Layer",
                                  "layerObj()");
            return NULL;
        }

        if (msCopyLayer(layer, self) != MS_SUCCESS) {
            freeLayer(layer);
            free(layer);
            layer = NULL;
        }
        layer->map = NULL;
        layer->index = -1;
        
        return layer;
    }
int layerObj_insertClass(layerObj *self,classObj *classobj,int index){
        return msInsertClass(self, classobj, index);
    }
classObj *layerObj_removeClass(layerObj *self,int index){
        return msRemoveClass(self, index);
    }
int layerObj_open(layerObj *self){
        int status;
        status =  msLayerOpen(self);
        if (status == MS_SUCCESS) {
            return msLayerGetItems(self);
        }
        return status;
    }
int layerObj_whichShapes(layerObj *self,rectObj rect){
        /* 
        ** We assume folks use this like a simple query so retrieve all items with each shape.
        */
        msLayerGetItems(self);
        return msLayerWhichShapes(self, rect);
    }
shapeObj *layerObj_nextShape(layerObj *self){
       int status;
       shapeObj *shape;

       shape = (shapeObj *)malloc(sizeof(shapeObj));
       if (!shape) return NULL;
       msInitShape(shape);

       status = msLayerNextShape(self, shape);
       if(status != MS_SUCCESS) {
         msFreeShape(shape);
	 free(shape);
	 return NULL;
       } else
         return shape;
    }
void layerObj_close(layerObj *self){
        msLayerClose(self);
    }
shapeObj *layerObj_getFeature(layerObj *self,int shapeindex,int tileindex){
    /* This version properly returns shapeObj and also has its
     * arguments properly ordered so that users can ignore the
     * tileindex if they are not accessing a tileindexed layer.
     * See bug 586:
     * http://mapserver.gis.umn.edu/bugs/show_bug.cgi?id=586 */
        int retval;
        shapeObj *shape;
        shape = (shapeObj *)malloc(sizeof(shapeObj));
        if (!shape)
            return NULL;
        msInitShape(shape);
        shape->type = self->type;
        retval = msLayerGetShape(self, shape, tileindex, shapeindex);
        return shape;
    }
int layerObj_getShape(layerObj *self,shapeObj *shape,int tileindex,int shapeindex){
        return msLayerGetShape(self, shape, tileindex, shapeindex);
    }
int layerObj_getNumResults(layerObj *self){
        if (!self->resultcache) return 0;
        return self->resultcache->numresults;
    }
resultCacheMemberObj *layerObj_getResult(layerObj *self,int i){
        if (!self->resultcache) return NULL;
        if (i >= 0 && i < self->resultcache->numresults)
            return &self->resultcache->results[i]; 
        else
            return NULL;
    }
classObj *layerObj_getClass(layerObj *self,int i){

        if (i >= 0 && i < self->numclasses)
            return &(self->class[i]); 
        else
            return NULL;
    }
char *layerObj_getItem(layerObj *self,int i){
  
        if (i >= 0 && i < self->numitems)
            return (char *) (self->items[i]);
        else
            return NULL;
    }
int layerObj_draw(layerObj *self,mapObj *map,imageObj *image){
        return msDrawLayer(map, self, image);    
    }
int layerObj_drawQuery(layerObj *self,mapObj *map,imageObj *image){
        return msDrawQueryLayer(map, self, image);    
    }
int layerObj_queryByAttributes(layerObj *self,mapObj *map,char *qitem,char *qstring,int mode){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        retval = msQueryByAttributes(map, self->index, qitem, qstring, mode);
        self->status = status;
        return retval;
    }
int layerObj_queryByPoint(layerObj *self,mapObj *map,pointObj *point,int mode,double buffer){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        retval = msQueryByPoint(map, self->index, mode, *point, buffer);
        self->status = status;
        return retval;
    }
int layerObj_queryByRect(layerObj *self,mapObj *map,rectObj rect){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        retval = msQueryByRect(map, self->index, rect);
        self->status = status;
        return retval;
    }
int layerObj_queryByFeatures(layerObj *self,mapObj *map,int slayer){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        retval = msQueryByFeatures(map, self->index, slayer);
        self->status = status;
        return retval;
    }
int layerObj_queryByShape(layerObj *self,mapObj *map,shapeObj *shape){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        retval = msQueryByShape(map, self->index, shape);
        self->status = status;
        return retval;
    }
int layerObj_queryByIndex(layerObj *self,mapObj *map,int tileindex,int shapeindex,int bAddToQuery){
        int status;
        int retval;
        
        status = self->status;
        self->status = 1;
        if (bAddToQuery == 0)
            retval = msQueryByIndex(map, self->index, tileindex, shapeindex);
        else
            retval = msQueryByIndexAdd(map, self->index, tileindex, shapeindex);
        self->status = status;
        return retval;
    }
resultCacheObj *layerObj_getResults(layerObj *self){
        return self->resultcache;
    }
int layerObj_setFilter(layerObj *self,char *filter){
        if (!filter || strlen(filter) == 0) {
            freeExpression(&self->filter);
            return MS_SUCCESS;
        }
        else return msLoadExpressionString(&self->filter, filter);
    }
char *layerObj_getFilterString(layerObj *self){
        return msGetExpressionString(&(self->filter));
    }
int layerObj_setWKTProjection(layerObj *self,char *wkt){
        self->project = 1;
        return msOGCWKT2ProjectionObj(wkt, &(self->projection), self->debug);
    }
char *layerObj_getProjection(layerObj *self){    
        return (char *) msGetProjectionString(&(self->projection));
    }
int layerObj_setProjection(layerObj *self,char *proj4){
        self->project = 1;
        return msLoadProjectionString(&(self->projection), proj4);
    }
int layerObj_addFeature(layerObj *self,shapeObj *shape){    
        self->connectiontype = MS_INLINE;
        if (insertFeatureList(&(self->features), shape) == NULL) 
        return MS_FAILURE;
        return MS_SUCCESS;
    }
int layerObj_getNumFeatures(layerObj *self){
        return msLayerGetNumFeatures(self);
    }
rectObj *layerObj_getExtent(layerObj *self){
        rectObj *extent;
        extent = (rectObj *) malloc(sizeof(rectObj));
        msLayerGetExtent(self, extent);
        return extent;
    }
int layerObj_setExtent(layerObj *self,double minx,double miny,double maxx,double maxy){
        if (minx > maxx || miny > maxy) {
            msSetError(34,
                "{ 'minx': %f , 'miny': %f , 'maxx': %f , 'maxy': %f }",
                "layerObj::setExtent()", minx, miny, maxx, maxy);
            return MS_FAILURE;
        }

        return msLayerSetExtent(self, minx, miny, maxx, maxy);
    }
char *layerObj_getMetaData(layerObj *self,char *name){
        char *value = NULL;
        if (!name) {
            msSetError(16, "NULL key", "getMetaData");
        }
     
        value = (char *) msLookupHashTable(&(self->metadata), name);
	/*
	Umberto, 05/17/2006
	Exceptions should be reserved for situations when a serious error occurred
	and normal program flow must be interrupted.
	In this case returning null should be more that enough.
	*/

        if (!value) {
            msSetError(16, "Key %s does not exist", "getMetaData", name);
            return NULL;
        }

        return value;
    }
int layerObj_setMetaData(layerObj *self,char *name,char *value){
        if (msInsertHashTable(&(self->metadata), name, value) == NULL)
        return MS_FAILURE;
        return MS_SUCCESS;
    }
int layerObj_removeMetaData(layerObj *self,char *name){
        return(msRemoveHashTable(&(self->metadata), name));
    }
char *layerObj_getFirstMetaDataKey(layerObj *self){
        return (char *) msFirstKeyFromHashTable(&(self->metadata));
    }
char *layerObj_getNextMetaDataKey(layerObj *self,char *lastkey){
        return (char *) msNextKeyFromHashTable(&(self->metadata), lastkey);
    }
char *layerObj_getWMSFeatureInfoURL(layerObj *self,mapObj *map,int click_x,int click_y,int feature_count,char *info_format){
        return (char *) msWMSGetFeatureInfoURL(map, self, click_x, click_y,
               feature_count, info_format);
    }
char *layerObj_executeWFSGetFeature(layerObj *self,layerObj *layer){
        return (char *) msWFSExecuteGetFeature(layer);
    }
int layerObj_applySLD(layerObj *self,char *sld,char *stylelayer){
        return msSLDApplySLD(self->map, sld, self->index, stylelayer);
    }
int layerObj_applySLDURL(layerObj *self,char *sld,char *stylelayer){
        return msSLDApplySLDURL(self->map, sld, self->index, stylelayer);
    }
char *layerObj_generateSLD(layerObj *self){
        return (char *) msSLDGenerateSLD(self->map, self->index);
    }
int layerObj_isVisible(layerObj *self){
        if (!self->map)
        {
            msSetError(12,
                "visibility has no meaning outside of a map context",
                "isVisible()");
            return MS_FAILURE;
        }
        return msLayerIsVisible(self->map, self);
    }
int layerObj_moveClassUp(layerObj *self,int index){
        return msMoveClassUp(self, index);
    }
int layerObj_moveClassDown(layerObj *self,int index){
        return msMoveClassDown(self, index);
    }
void layerObj_setProcessingKey(layerObj *self,char const *key,char const *value){
	   msLayerSetProcessingKey( self, key, value );
    }
void layerObj_setProcessing(layerObj *self,char const *directive){
        msLayerAddProcessing( self, directive );
    }
void layerObj_addProcessing(layerObj *self,char const *directive){
        msLayerAddProcessing( self, directive );
    }
char *layerObj_getProcessing(layerObj *self,int index){
        return (char *) msLayerGetProcessing(self, index);
    }
int layerObj_clearProcessing(layerObj *self){
        return msLayerClearProcessing(self);
    }
mapObj *new_mapObj(char *filename){
        if (filename && strlen(filename))
            return msLoadMap(filename, NULL);
        else { /* create an empty map, no layers etc... */
            return msNewMapObj();
        }      
    }
void delete_mapObj(mapObj *self){
        msFreeMap(self);
    }
mapObj *mapObj_clone(mapObj *self){
        mapObj *dstMap;
        dstMap = msNewMapObj();
        if (msCopyMap(dstMap, self) != MS_SUCCESS) {
            msFreeMap(dstMap);
            dstMap = NULL;
        }
        return dstMap;
    }
int mapObj_insertLayer(mapObj *self,layerObj *layer,int index){
        return msInsertLayer(self, layer, index);  
    }
layerObj *mapObj_removeLayer(mapObj *self,int index){
        return msRemoveLayer(self, index);
    }
int mapObj_setExtent(mapObj *self,double minx,double miny,double maxx,double maxy){	
	return msMapSetExtent( self, minx, miny, maxx, maxy );
    }
int mapObj_setSize(mapObj *self,int width,int height){
        return msMapSetSize(self, width, height);
    }
int mapObj_setRotation(mapObj *self,double rotation_angle){
        return msMapSetRotation( self, rotation_angle );
    }
layerObj *mapObj_getLayer(mapObj *self,int i){
    if(i >= 0 && i < self->numlayers)	
      return &(self->layers[i]); /* returns an EXISTING layer */
    else
      return NULL;
  }
layerObj *mapObj_getLayerByName(mapObj *self,char *name){
    int i;

    i = msGetLayerIndex(self, name);

    if(i != -1)
      return &(self->layers[i]); /* returns an EXISTING layer */
    else
      return NULL;
  }
int mapObj_getSymbolByName(mapObj *self,char *name){
    return msGetSymbolIndex(&self->symbolset, name, 1);
  }
void mapObj_prepareQuery(mapObj *self){
    int status;

    status = msCalculateScale(self->extent, self->units, self->width, self->height, self->resolution, &self->scale);
    if(status != MS_SUCCESS) self->scale = -1;
  }
imageObj *mapObj_prepareImage(mapObj *self){
    return msPrepareImage(self, 0);
  }
void mapObj_setImageType(mapObj *self,char *imagetype){
      outputFormatObj *format;

      format = msSelectOutputFormat( self, imagetype );
      if( format == NULL )
	  msSetError(12, "Unable to find IMAGETYPE '%s'.", 
		     "setImageType()", imagetype );
      else
      {  
          msFree( self->imagetype );
          self->imagetype = strdup(imagetype);
          msApplyOutputFormat( &(self->outputformat), format, -1111, 
                               -1111, -1111 );
      }
  }
void mapObj_selectOutputFormat(mapObj *self,char *imagetype){
        outputFormatObj *format;

        format = msSelectOutputFormat( self, imagetype );
        if ( format == NULL )
	        msSetError(12, "Unable to find IMAGETYPE '%s'.", 
		               "setImageType()", imagetype );
        else
        {   
            msFree( self->imagetype );
            self->imagetype = strdup(imagetype);
            msApplyOutputFormat( &(self->outputformat), format, -1111, 
                                 -1111, -1111 );
        }
    }
void mapObj_setOutputFormat(mapObj *self,outputFormatObj *format){
      msApplyOutputFormat( &(self->outputformat), format, -1111, 
                           -1111, -1111 );
  }
imageObj *mapObj_draw(mapObj *self){
    return msDrawMap(self);
  }
imageObj *mapObj_drawQuery(mapObj *self){
    return msDrawQueryMap(self);
  }
imageObj *mapObj_drawLegend(mapObj *self){
    return msDrawLegend(self, 0);
  }
imageObj *mapObj_drawScalebar(mapObj *self){
    return msDrawScalebar(self);
  }
imageObj *mapObj_drawReferenceMap(mapObj *self){
    return msDrawReferenceMap(self);
  }
int mapObj_embedScalebar(mapObj *self,imageObj *image){	
    return msEmbedScalebar(self, image->img.gd);
  }
int mapObj_embedLegend(mapObj *self,imageObj *image){	
    return msEmbedLegend(self, image->img.gd);
  }
int mapObj_drawLabelCache(mapObj *self,imageObj *image){
    return msDrawLabelCache(image, self);
  }
labelCacheMemberObj *mapObj_getLabel(mapObj *self,int i){
    if(i >= 0 && i < self->labelcache.numlabels)	
      return &(self->labelcache.labels[i]);
    else
      return NULL;
  }
labelCacheMemberObj *mapObj_nextLabel(mapObj *self){
    static int i=0;

    if(i<self->labelcache.numlabels)
      return &(self->labelcache.labels[i++]);
    else
      return NULL;	
  }
int mapObj_queryByPoint(mapObj *self,pointObj *point,int mode,double buffer){
    return msQueryByPoint(self, -1, mode, *point, buffer);
  }
int mapObj_queryByRect(mapObj *self,rectObj rect){
    return msQueryByRect(self, -1, rect);
  }
int mapObj_queryByFeatures(mapObj *self,int slayer){
    return msQueryByFeatures(self, -1, slayer);
  }
int mapObj_queryByShape(mapObj *self,shapeObj *shape){
    return msQueryByShape(self, -1, shape);
  }
int mapObj_setWKTProjection(mapObj *self,char *wkt){
    return msOGCWKT2ProjectionObj(wkt, &(self->projection), self->debug);
  }
char *mapObj_getProjection(mapObj *self){
    return msGetProjectionString(&(self->projection));
  }
int mapObj_setProjection(mapObj *self,char *proj4){
    return msLoadProjectionString(&(self->projection), proj4);
  }
int mapObj_save(mapObj *self,char *filename){
    return msSaveMap(self, filename);
  }
int mapObj_saveQuery(mapObj *self,char *filename){
        return msSaveQuery(self, filename);
    }
int mapObj_loadQuery(mapObj *self,char *filename){
        return msLoadQuery(self, filename);
    }
void mapObj_freeQuery(mapObj *self,int qlayer){
        msQueryFree(self, qlayer);
    }
int mapObj_saveQueryAsGML(mapObj *self,char *filename,char const *ns){
    return msGMLWriteQuery(self, filename, ns);
  }
char *mapObj_getMetaData(mapObj *self,char *name){
    char *value = NULL;
    if (!name) {
      msSetError(16, "NULL key", "getMetaData");
    }
     
    value = (char *) msLookupHashTable(&(self->web.metadata), name);
    if (!value) {
      msSetError(16, "Key %s does not exist", "getMetaData", name);
      return NULL;
    }
    return value;
  }
int mapObj_setMetaData(mapObj *self,char *name,char *value){
    if (msInsertHashTable(&(self->web.metadata), name, value) == NULL)
	return MS_FAILURE;
    return MS_SUCCESS;
  }
int mapObj_removeMetaData(mapObj *self,char *name){
    return(msRemoveHashTable(&(self->web.metadata), name));
  }
char *mapObj_getFirstMetaDataKey(mapObj *self){
    return (char *) msFirstKeyFromHashTable(&(self->web.metadata));
  }
char *mapObj_getNextMetaDataKey(mapObj *self,char *lastkey){
    return (char *) msNextKeyFromHashTable(&(self->web.metadata), lastkey);
  }
int mapObj_setSymbolSet(mapObj *self,char *szFileName){
    msFreeSymbolSet(&self->symbolset);
    msInitSymbolSet(&self->symbolset);
   
    self->symbolset.filename = strdup(szFileName);

    /* Symbolset shares same fontset as main mapfile */
    self->symbolset.fontset = &(self->fontset);

    return msLoadSymbolSet(&self->symbolset, self);
  }
int mapObj_getNumSymbols(mapObj *self){
    return self->symbolset.numsymbols;
  }
int mapObj_setFontSet(mapObj *self,char *filename){
    msFreeFontSet(&(self->fontset));
    msInitFontSet(&(self->fontset));
   
    self->fontset.filename = strdup(filename);

    return msLoadFontSet(&(self->fontset), self);
  }
int mapObj_saveMapContext(mapObj *self,char *szFileName){
    return msSaveMapContext(self, szFileName);
  }
int mapObj_loadMapContext(mapObj *self,char *szFileName,int useUniqueNames){
    return msLoadMapContext(self, szFileName, useUniqueNames);
  }
int mapObj_moveLayerUp(mapObj *self,int layerindex){
    return msMoveLayerUp(self, layerindex);
  }
int mapObj_moveLayerDown(mapObj *self,int layerindex){
    return msMoveLayerDown(self, layerindex);
  }
intarray *mapObj_getLayersDrawingOrder(mapObj *self){
    int i;
    intarray *order;
    order = new_intarray(self->numlayers);
    for (i=0; i<self->numlayers; i++)
        


        intarray_setitem(order, i, self->layerorder[i]);
        
    return order;
  }
int mapObj_setLayersDrawingOrder(mapObj *self,int *panIndexes){
    return  msSetLayersdrawingOrder(self, panIndexes); 
  }
void mapObj_setConfigOption(mapObj *self,char *key,char *value){
    msSetConfigOption(self,key,value);
  }
char *mapObj_getConfigOption(mapObj *self,char *key){
    return (char *) msGetConfigOption(self,key);
  }
void mapObj_applyConfigOptions(mapObj *self){
    msApplyMapConfigOptions( self );
  }
int mapObj_applySLD(mapObj *self,char *sld){
        return msSLDApplySLD(self, sld, -1, NULL);
    }
int mapObj_applySLDURL(mapObj *self,char *sld){
        return msSLDApplySLDURL(self, sld, -1, NULL);
    }
char *mapObj_generateSLD(mapObj *self){
        return (char *) msSLDGenerateSLD(self, -1);
    }
char *mapObj_processTemplate(mapObj *self,int bGenerateImages,char **names,char **values,int numentries){
        return msProcessTemplate(self, bGenerateImages, names, values,
                                 numentries);
    }
char *mapObj_processLegendTemplate(mapObj *self,char **names,char **values,int numentries){
        return msProcessLegendTemplate(self, names, values, numentries);
    }
char *mapObj_processQueryTemplate(mapObj *self,char **names,char **values,int numentries){
        return msProcessQueryTemplate(self, 1, names, values, numentries);
    }
outputFormatObj *mapObj_getOutputFormatByName(mapObj *self,char *name){
        return msSelectOutputFormat(self, name); 
    }
int mapObj_appendOutputFormat(mapObj *self,outputFormatObj *format){
        return msAppendOutputFormat(self, format);
    }
int mapObj_removeOutputFormat(mapObj *self,char *name){
        return msRemoveOutputFormat(self, name);
    }
int mapObj_loadOWSParameters(mapObj *self,cgiRequestObj *request,char *wmtver_string){
        return msMapLoadOWSParameters(self, request, wmtver_string);
    }
int mapObj_OWSDispatch(mapObj *self,cgiRequestObj *req){
	return msOWSDispatch( self, req );
    }
int mapObj_zoomPoint(mapObj *self,int zoomfactor,pointObj *poPixPos,int width,int height,rectObj *poGeorefExt,rectObj *poMaxGeorefExt){
        double      dfGeoPosX, dfGeoPosY;
        double      dfDeltaX, dfDeltaY;
        rectObj     oNewGeorefExt;    
        double      dfNewScale;
        int         bMaxExtSet;
        double      dfDeltaExt;
        double dX, dY;
        
        dfNewScale = 0.0;
        bMaxExtSet = 0;
        dfDeltaExt = -1.0;

        if (poMaxGeorefExt != NULL) { bMaxExtSet = 1; }

        /* ----------------------------------------------------------- */
        /*      check the validity of the parameters.                  */
        /* ----------------------------------------------------------- */
        if (zoomfactor == 0 || 
            width <= 0 ||
            height <= 0 ||
            poGeorefExt == NULL ||
            poPixPos == NULL )
        {
            msSetError(12, "Incorrect arguments", 
                       "mapscript::mapObj::zoomPoint()");
            return MS_FAILURE;
        }

        /* ----------------------------------------------------------- */
        /*      check if the values passed are consistent min > max.   */
        /* ----------------------------------------------------------- */
        if (poGeorefExt->minx >= poGeorefExt->maxx)
        {
            msSetError(12, "Georeferenced coordinates minx >= maxx",
                       "mapscript::mapObj::zoomPoint()");
            return MS_FAILURE;
        }
        if (poGeorefExt->miny >= poGeorefExt->maxy)
        {
            msSetError(12, "Georeferenced coordinates miny >= maxy",
                       "mapscript::mapObj::zoomPoint()");
            return MS_FAILURE;
        }
        if (bMaxExtSet == 1)
        {
            if (poMaxGeorefExt->minx >= poMaxGeorefExt->maxx)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates minx >= maxx",
                           "mapscript::mapObj::zoomPoint()");
                return MS_FAILURE;
            }
            if (poMaxGeorefExt->miny >= poMaxGeorefExt->maxy)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates miny >= maxy",
                           "mapscript::mapObj::zoomPoint()");
            }
        }
   
        dfDeltaX = poGeorefExt->maxx - poGeorefExt->minx;
        dfDeltaY = poGeorefExt->maxy - poGeorefExt->miny;
        dX = dfDeltaX/(double)width;
        dY = dfDeltaY/(double)height;
        dfGeoPosX = poGeorefExt->minx + dX * (double)poPixPos->x;
        dfGeoPosY = poGeorefExt->maxy - dY * (double)poPixPos->y;
        
        /* --- -------------------------------------------------------- */
        /*      zoom in                                                 */
        /* ------------------------------------------------------------ */
        if (zoomfactor > 1)
        {
            oNewGeorefExt.minx = dfGeoPosX - (dfDeltaX/(2*zoomfactor));        
            oNewGeorefExt.miny = dfGeoPosY - (dfDeltaY/(2*zoomfactor));        
            oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaX/(2*zoomfactor));        
            oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaY/(2*zoomfactor));
        }

        if (zoomfactor < 0)
        {
            oNewGeorefExt.minx = dfGeoPosX - (dfDeltaX/2)*(abs(zoomfactor));    
            oNewGeorefExt.miny = dfGeoPosY - (dfDeltaY/2)*(abs(zoomfactor));    
            oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaX/2)*(abs(zoomfactor));    
            oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaY/2)*(abs(zoomfactor));
        }
        if (zoomfactor == 1)
        {
            oNewGeorefExt.minx = dfGeoPosX - (dfDeltaX/2);
            oNewGeorefExt.miny = dfGeoPosY - (dfDeltaY/2);
            oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaX/2);
            oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaY/2);
        }

        /* ------------------------------------------------------------ */
        /*   if the min and max scale are set in the map file, we will  */
        /*   use them to test before zooming.                           */
        /* ------------------------------------------------------------ */
        msAdjustExtent(&oNewGeorefExt, self->width, self->height);
        msCalculateScale(oNewGeorefExt, self->units, 
                             self->width, self->height, 
                             self->resolution, &dfNewScale);
    
        if (self->web.maxscale > 0)
        {
            if (zoomfactor < 0 && dfNewScale > self->web.maxscale)
            {
                return MS_FAILURE;
            }
        }

        /* ============================================================ */
        /*  we do a spcial case for zoom in : we try to zoom as much as */
        /*  possible using the mincale set in the .map.                 */
        /* ============================================================ */
        if (self->web.minscale > 0 &&
            dfNewScale < self->web.minscale &&
            zoomfactor > 1)
        {
            dfDeltaExt = (self->web.minscale * self->width)
                       /(self->resolution * msInchesPerUnit(self->units,0));
            /*dfDeltaExt = 
                GetDeltaExtentsUsingScale(self->web.minscale, self->units,
                                          dfGeoPosY, self->width, 
                                          self->resolution);*/
            if (dfDeltaExt > 0.0)
            {
                oNewGeorefExt.minx = dfGeoPosX - (dfDeltaExt/2);
                oNewGeorefExt.miny = dfGeoPosY - (dfDeltaExt/2);
                oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaExt/2);
                oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaExt/2);
            }
            else
                return MS_FAILURE;
        }

        /* ------------------------------------------------------------ */
        /*  If the buffer is set, make sure that the extents do not go  */
        /*  beyond the buffer.                                          */
        /* ------------------------------------------------------------ */
        if (bMaxExtSet)
        {
            dfDeltaX = oNewGeorefExt.maxx - oNewGeorefExt.minx;
            dfDeltaY = oNewGeorefExt.maxy - oNewGeorefExt.miny;
        
            /* Make sure Current georef extents is not bigger than 
             * max extents */
            if (dfDeltaX > (poMaxGeorefExt->maxx-poMaxGeorefExt->minx))
                dfDeltaX = poMaxGeorefExt->maxx-poMaxGeorefExt->minx;
            if (dfDeltaY > (poMaxGeorefExt->maxy-poMaxGeorefExt->miny))
                dfDeltaY = poMaxGeorefExt->maxy-poMaxGeorefExt->miny;

            if (oNewGeorefExt.minx < poMaxGeorefExt->minx)
            {
                oNewGeorefExt.minx = poMaxGeorefExt->minx;
                oNewGeorefExt.maxx =  oNewGeorefExt.minx + dfDeltaX;
            }
            if (oNewGeorefExt.maxx > poMaxGeorefExt->maxx)
            {
                oNewGeorefExt.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (oNewGeorefExt.miny < poMaxGeorefExt->miny)
            {
                oNewGeorefExt.miny = poMaxGeorefExt->miny;
                oNewGeorefExt.maxy =  oNewGeorefExt.miny + dfDeltaY;
            }
            if (oNewGeorefExt.maxy > poMaxGeorefExt->maxy)
            {
                oNewGeorefExt.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }
    
        /* ------------------------------------------------------------ */
        /*      set the map extents with new values.                    */
        /* ------------------------------------------------------------ */
        self->extent.minx = oNewGeorefExt.minx;
        self->extent.miny = oNewGeorefExt.miny;
        self->extent.maxx = oNewGeorefExt.maxx;
        self->extent.maxy = oNewGeorefExt.maxy;
    
        self->cellsize = msAdjustExtent(&(self->extent), self->width, 
                                        self->height);      
        dfDeltaX = self->extent.maxx - self->extent.minx;
        dfDeltaY = self->extent.maxy - self->extent.miny; 

        if (bMaxExtSet)
        {
            if (self->extent.minx < poMaxGeorefExt->minx)
            {
                self->extent.minx = poMaxGeorefExt->minx;
                self->extent.maxx = self->extent.minx + dfDeltaX;
            }
            if (self->extent.maxx > poMaxGeorefExt->maxx)
            {
                self->extent.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (self->extent.miny < poMaxGeorefExt->miny)
            {
                self->extent.miny = poMaxGeorefExt->miny;
                self->extent.maxy =  self->extent.miny + dfDeltaY;
            }
            if (self->extent.maxy > poMaxGeorefExt->maxy)
            {
                self->extent.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }
    
        msCalculateScale(self->extent, self->units, self->width, 
                         self->height, self->resolution, &(self->scale));
        return MS_SUCCESS;

    }
int mapObj_zoomRectangle(mapObj *self,rectObj *poPixRect,int width,int height,rectObj *poGeorefExt,rectObj *poMaxGeorefExt){
        double      dfDeltaX, dfDeltaY;
        rectObj     oNewGeorefExt;    
        double      dfNewScale;
        double      dfDeltaExt;
        double dfMiddleX, dfMiddleY;
        double dX, dY;
        int bMaxExtSet;
        
        bMaxExtSet = 0;
        dfNewScale = 0.0;
        dfDeltaExt = -1.0;

        if (poMaxGeorefExt != NULL) { bMaxExtSet = 1; }

        /* ----------------------------------------------------------- */
        /*      check the validity of the parameters.                  */
        /* ----------------------------------------------------------- */
        if (poPixRect == 0 || 
            width <= 0 ||
            height <= 0 ||
            poGeorefExt == NULL )
        {
            msSetError(12, "Incorrect arguments", 
                       "mapscript::mapObj::zoomRectangle");
            return MS_FAILURE;
        }

        /* ----------------------------------------------------------- */
        /*      check if the values passed are consistent min > max.   */
        /* ----------------------------------------------------------- */
        if (poPixRect->minx >= poPixRect->maxx)
        {
            msSetError(12, "image rectangle minx >= maxx",
                       "mapscript::mapObj::zoomRectangle()");
            return MS_FAILURE;
        }
        if (poPixRect->maxy >= poPixRect->miny)
        {
            msSetError(12, "image rectangle miny >= maxy",
                       "mapscript::mapObj::zoomRectangle()");
            return MS_FAILURE;
        }

        if (poGeorefExt->minx >= poGeorefExt->maxx)
        {
            msSetError(12, "Georeferenced coordinates minx >= maxx",
                       "mapscript::mapObj::zoomRectangle()");
            return MS_FAILURE;
        }
        if (poGeorefExt->miny >= poGeorefExt->maxy)
        {
            msSetError(12, "Georeferenced coordinates miny >= maxy",
                       "mapscript::mapObj::zoomRectangle()");
            return MS_FAILURE;
        }
        if (bMaxExtSet == 1)
        {
            if (poMaxGeorefExt->minx >= poMaxGeorefExt->maxx)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates minx >= maxx",
                           "mapscript::mapObj::zoomRectangle()");
                return MS_FAILURE;
            }
            if (poMaxGeorefExt->miny >= poMaxGeorefExt->maxy)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates miny >= maxy",
                           "mapscript::mapObj::zoomRectangle()");
            }
        }

  
        /* ----------------------------------------------------------- */
        /*   Convert pixel rectangle to georeferenced rectangle        */
        /* ----------------------------------------------------------- */
        
        dfDeltaX = poGeorefExt->maxx - poGeorefExt->minx;
        dfDeltaY = poGeorefExt->maxy - poGeorefExt->miny;
        dX = dfDeltaX/(double)width;
        dY = dfDeltaY/(double)height;

        oNewGeorefExt.minx = poGeorefExt->minx
                           + dX * (double)poPixRect->minx;
        oNewGeorefExt.miny = poGeorefExt->maxy
                           - dY * (double)poPixRect->miny;
        oNewGeorefExt.maxx = poGeorefExt->minx
                           + dX * (double)poPixRect->maxx;
        oNewGeorefExt.maxy = poGeorefExt->maxy
                           - dY * (double)poPixRect->maxy;

        msAdjustExtent(&oNewGeorefExt, self->width, self->height);

        /* ------------------------------------------------------------ */
        /*   if the min and max scale are set in the map file, we will  */
        /*   use them to test before setting extents.                   */
        /* ------------------------------------------------------------ */
        msCalculateScale(oNewGeorefExt, self->units, 
                         self->width, self->height, 
                         self->resolution, &dfNewScale);

        if (self->web.maxscale > 0 &&  dfNewScale > self->web.maxscale)
        {
            return MS_FAILURE;
        }

        if (self->web.minscale > 0 && dfNewScale <  self->web.minscale)
        {
            dfMiddleX = oNewGeorefExt.minx + 
                ((oNewGeorefExt.maxx - oNewGeorefExt.minx)/2);
            dfMiddleY = oNewGeorefExt.miny + 
                ((oNewGeorefExt.maxy - oNewGeorefExt.miny)/2);
        
            dfDeltaExt = (self->web.minscale * self->width)
                       / (self->resolution * msInchesPerUnit(self->units,0));
            /*dfDeltaExt = 
                GetDeltaExtentsUsingScale(self->web.minscale, self->units, 
                                          dfMiddleY, self->width, 
                                      self->resolution);*/

            if (dfDeltaExt > 0.0)
            {
                oNewGeorefExt.minx = dfMiddleX - (dfDeltaExt/2);
                oNewGeorefExt.miny = dfMiddleY - (dfDeltaExt/2);
                oNewGeorefExt.maxx = dfMiddleX + (dfDeltaExt/2);
                oNewGeorefExt.maxy = dfMiddleY + (dfDeltaExt/2);
            }
            else
                return MS_FAILURE;
        }

        /* ------------------------------------------------------------ */
        /*  If the buffer is set, make sure that the extents do not go  */
        /*  beyond the buffer.                                          */
        /* ------------------------------------------------------------ */
        if (bMaxExtSet)
        {
            dfDeltaX = oNewGeorefExt.maxx - oNewGeorefExt.minx;
            dfDeltaY = oNewGeorefExt.maxy - oNewGeorefExt.miny;
        
            /* Make sure Current georef extents is not bigger 
             * than max extents */
            if (dfDeltaX > (poMaxGeorefExt->maxx-poMaxGeorefExt->minx))
                dfDeltaX = poMaxGeorefExt->maxx-poMaxGeorefExt->minx;
            if (dfDeltaY > (poMaxGeorefExt->maxy-poMaxGeorefExt->miny))
                dfDeltaY = poMaxGeorefExt->maxy-poMaxGeorefExt->miny;

            if (oNewGeorefExt.minx < poMaxGeorefExt->minx)
            {
                oNewGeorefExt.minx = poMaxGeorefExt->minx;
                oNewGeorefExt.maxx =  oNewGeorefExt.minx + dfDeltaX;
            }
            if (oNewGeorefExt.maxx > poMaxGeorefExt->maxx)
            {
                oNewGeorefExt.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (oNewGeorefExt.miny < poMaxGeorefExt->miny)
            {
                oNewGeorefExt.miny = poMaxGeorefExt->miny;
                oNewGeorefExt.maxy =  oNewGeorefExt.miny + dfDeltaY;
            }
            if (oNewGeorefExt.maxy > poMaxGeorefExt->maxy)
            {
                oNewGeorefExt.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }

        self->extent.minx = oNewGeorefExt.minx;
        self->extent.miny = oNewGeorefExt.miny;
        self->extent.maxx = oNewGeorefExt.maxx;
        self->extent.maxy = oNewGeorefExt.maxy;
    
        self->cellsize = msAdjustExtent(&(self->extent), self->width, 
                                        self->height);    
        dfDeltaX = self->extent.maxx - self->extent.minx;
        dfDeltaY = self->extent.maxy - self->extent.miny; 

        if (bMaxExtSet)
        {
            if (self->extent.minx < poMaxGeorefExt->minx)
            {
                self->extent.minx = poMaxGeorefExt->minx;
                self->extent.maxx = self->extent.minx + dfDeltaX;
            }
            if (self->extent.maxx > poMaxGeorefExt->maxx)
            {
                self->extent.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (self->extent.miny < poMaxGeorefExt->miny)
            {
                self->extent.miny = poMaxGeorefExt->miny;
                self->extent.maxy =  self->extent.miny + dfDeltaY;
            }
            if (self->extent.maxy > poMaxGeorefExt->maxy)
            {
                self->extent.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }

        msCalculateScale(self->extent, self->units, self->width, 
                         self->height, self->resolution, &(self->scale));
        return MS_SUCCESS;

    }
int mapObj_zoomScale(mapObj *self,double scale,pointObj *poPixPos,int width,int height,rectObj *poGeorefExt,rectObj *poMaxGeorefExt){
        double      dfGeoPosX, dfGeoPosY;
        double      dfDeltaX, dfDeltaY;
        rectObj     oNewGeorefExt;    
        double      dfNewScale, dfCurrentScale;
        int         bMaxExtSet;
        int nTmp;
        double      dfDeltaExt;
        double dX, dY;
        
        dfNewScale = 0.0;
        dfCurrentScale = 0.0;
        nTmp = 0;
        bMaxExtSet = 0;
        dfDeltaExt = -1.0;

        if (poMaxGeorefExt != NULL) { bMaxExtSet = 1; }

        /* ----------------------------------------------------------- */
        /*      check the validity of the parameters.                  */
        /* ----------------------------------------------------------- */
        if (scale <= 0.0 || 
            width <= 0 ||
            height <= 0 ||
            poGeorefExt == NULL ||
            poPixPos == NULL )
        {
            msSetError(12, "Incorrect arguments", 
                       "mapscript::mapObj::zoomScale");
            return MS_FAILURE;
        }

        /* ----------------------------------------------------------- */
        /*      check if the values passed are consistent min > max.   */
        /* ----------------------------------------------------------- */
        if (poGeorefExt->minx >= poGeorefExt->maxx)
        {
            msSetError(12, "Georeferenced coordinates minx >= maxx",
                       "mapscript::mapObj::zoomScale()");
            return MS_FAILURE;
        }
        if (poGeorefExt->miny >= poGeorefExt->maxy)
        {
            msSetError(12, "Georeferenced coordinates miny >= maxy",
                       "mapscript::mapObj::zoomScale()");
            return MS_FAILURE;
        }
        if (bMaxExtSet == 1)
        {
            if (poMaxGeorefExt->minx >= poMaxGeorefExt->maxx)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates minx >= maxx",
                           "mapscript::mapObj::zoomScale()");
                return MS_FAILURE;
            }
            if (poMaxGeorefExt->miny >= poMaxGeorefExt->maxy)
            {
                msSetError(12, 
                           "Max Georeferenced coordinates miny >= maxy",
                           "mapscript::mapObj::zoomScale()");
            }
        }
   
        dfDeltaX = poGeorefExt->maxx - poGeorefExt->minx;
        dfDeltaY = poGeorefExt->maxy - poGeorefExt->miny;
        dX = dfDeltaX/(double)width;
        dY = dfDeltaY/(double)height;
        dfGeoPosX = poGeorefExt->minx + dX * (double)poPixPos->x;
        dfGeoPosY = poGeorefExt->maxy - dY * (double)poPixPos->y;
        
        /* ------------------------------------------------------------ */
        /*  Calculate new extents based on the scale.                   */
        /* ------------------------------------------------------------ */

        /* ============================================================ */
        /*  make sure to take the smallest size because this is the one */
        /*  that will be used to ajust the scale.                       */
        /* ============================================================ */

        if (self->width <  self->height)
            nTmp = self->width;
        else
            nTmp = self->height;

        dfDeltaExt=scale*nTmp/(self->resolution*msInchesPerUnit(self->units,0));

        if (dfDeltaExt > 0.0)
        {
            oNewGeorefExt.minx = dfGeoPosX - (dfDeltaExt/2);
            oNewGeorefExt.miny = dfGeoPosY - (dfDeltaExt/2);
            oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaExt/2);
            oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaExt/2);
        }
        else
            return MS_FAILURE;

        /* ------------------------------------------------------------ */
        /*   get current scale.                                         */
        /* ------------------------------------------------------------ */
        msCalculateScale(*poGeorefExt, self->units, 
                         self->width, self->height,
                         self->resolution, &dfCurrentScale);

        /* ------------------------------------------------------------ *
         *   if the min and max scale are set in the map file, we will  *
         *   use them to test before zooming.                           *
         *                                                              *
         *   This function has the same effect as zoomin or zoom out.
         *   If the current scale is > newscale we zoom in; else it is
         *   a zoom out.
         * ------------------------------------------------------------ */
        msAdjustExtent(&oNewGeorefExt, self->width, self->height);
        msCalculateScale(oNewGeorefExt, self->units, 
                         self->width, self->height,
                         self->resolution, &dfNewScale);

        if (self->web.maxscale > 0)
        {
            if (dfCurrentScale < dfNewScale && dfNewScale >  self->web.maxscale)
            {
                return MS_FAILURE;
            }
        }

        /* ============================================================ */
        /* we do a special case for zoom in : we try to zoom as much as */
        /* possible using the mincale set in the .map.                  */
        /* ============================================================ */
        if (self->web.minscale > 0 && dfNewScale <  self->web.minscale &&
            dfCurrentScale > dfNewScale)
        {
            dfDeltaExt=scale*nTmp/(self->resolution*msInchesPerUnit(self->units,0));
            if (dfDeltaExt > 0.0)
            {
                oNewGeorefExt.minx = dfGeoPosX - (dfDeltaExt/2);
                oNewGeorefExt.miny = dfGeoPosY - (dfDeltaExt/2);
                oNewGeorefExt.maxx = dfGeoPosX + (dfDeltaExt/2);
                oNewGeorefExt.maxy = dfGeoPosY + (dfDeltaExt/2);
            }
            else
                return MS_FAILURE;
        }

        /* ------------------------------------------------------------ */
        /*  If the buffer is set, make sure that the extents do not go  */
        /*  beyond the buffer.                                          */
        /* ------------------------------------------------------------ */
        if (bMaxExtSet)
        {
            dfDeltaX = oNewGeorefExt.maxx - oNewGeorefExt.minx;
            dfDeltaY = oNewGeorefExt.maxy - oNewGeorefExt.miny;
        
            /* Make sure Current georef extents is not bigger 
             * than max extents */
            if (dfDeltaX > (poMaxGeorefExt->maxx-poMaxGeorefExt->minx))
                dfDeltaX = poMaxGeorefExt->maxx-poMaxGeorefExt->minx;
            if (dfDeltaY > (poMaxGeorefExt->maxy-poMaxGeorefExt->miny))
                dfDeltaY = poMaxGeorefExt->maxy-poMaxGeorefExt->miny;

            if (oNewGeorefExt.minx < poMaxGeorefExt->minx)
            {
                oNewGeorefExt.minx = poMaxGeorefExt->minx;
                oNewGeorefExt.maxx =  oNewGeorefExt.minx + dfDeltaX;
            }
            if (oNewGeorefExt.maxx > poMaxGeorefExt->maxx)
            {
                oNewGeorefExt.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (oNewGeorefExt.miny < poMaxGeorefExt->miny)
            {
                oNewGeorefExt.miny = poMaxGeorefExt->miny;
                oNewGeorefExt.maxy =  oNewGeorefExt.miny + dfDeltaY;
            }
            if (oNewGeorefExt.maxy > poMaxGeorefExt->maxy)
            {
                oNewGeorefExt.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }

        self->extent.minx = oNewGeorefExt.minx;
        self->extent.miny = oNewGeorefExt.miny;
        self->extent.maxx = oNewGeorefExt.maxx;
        self->extent.maxy = oNewGeorefExt.maxy;
    
        self->cellsize = msAdjustExtent(&(self->extent), self->width, 
                                        self->height);    
        dfDeltaX = self->extent.maxx - self->extent.minx;
        dfDeltaY = self->extent.maxy - self->extent.miny; 

        if (bMaxExtSet)
        {
            if (self->extent.minx < poMaxGeorefExt->minx)
            {
                self->extent.minx = poMaxGeorefExt->minx;
                self->extent.maxx = self->extent.minx + dfDeltaX;
            }
            if (self->extent.maxx > poMaxGeorefExt->maxx)
            {
                self->extent.maxx = poMaxGeorefExt->maxx;
                oNewGeorefExt.minx = oNewGeorefExt.maxx - dfDeltaX;
            }
            if (self->extent.miny < poMaxGeorefExt->miny)
            {
                self->extent.miny = poMaxGeorefExt->miny;
                self->extent.maxy =  self->extent.miny + dfDeltaY;
            }
            if (self->extent.maxy > poMaxGeorefExt->maxy)
            {
                self->extent.maxy = poMaxGeorefExt->maxy;
                oNewGeorefExt.miny = oNewGeorefExt.maxy - dfDeltaY;
            }
        }

        msCalculateScale(self->extent, self->units, self->width, 
                         self->height, self->resolution, &(self->scale));
        return MS_SUCCESS;
    }
imageObj *new_imageObj(int width,int height,outputFormatObj *input_format,char const *file){
        imageObj *image=NULL;
        outputFormatObj *format;

        if (file) {
            return (imageObj *) msImageLoadGD(file);
        }
        if (input_format) {
            format = input_format;
        }
        else {
            format = msCreateDefaultOutputFormat(NULL, "GD/GIF");
            if (format == NULL)
                format = msCreateDefaultOutputFormat(NULL, "GD/PNG");
            if (format == NULL)
                format = msCreateDefaultOutputFormat(NULL, "GD/JPEG");
            if (format == NULL)
                format = msCreateDefaultOutputFormat(NULL, "GD/WBMP");
        }
        if (format == NULL) {
            msSetError(15, "Could not create output format",
                       "imageObj()");
            return NULL;
        }
        image = msImageCreate(width, height, format, NULL, NULL, NULL);
        return image;
    }
void delete_imageObj(imageObj *self){
        msFreeImage(self);    
    }
void imageObj_save(imageObj *self,char *filename,mapObj *map){
        msSaveImage(map, self, filename );
    }
int imageObj_write(imageObj *self,FILE *file){
        gdIOCtx *ctx=NULL;
        int retval=MS_FAILURE;
        
        if ( MS_DRIVER_GD(self->format) )
        {
            if (file)
            {
                /* gdNewFileCtx is a semi-documented function from 
                   gd_io_file.c */
                ctx = msNewGDFileCtx(file);
            }
            else /* create a gdIOCtx interface to stdout */
            {
                ctx = msNewGDFileCtx(stdout);
            }
            
            /* we wrap msSaveImageGDCtx in the same way that 
               gdImageJpeg() wraps gdImageJpegCtx()  (bug 1047). */
            retval = msSaveImageGDCtx(self->img.gd, ctx, self->format);
            ctx->gd_free(ctx);
        }
        else
        {
            msSetError(15, "Writing of %s format not implemented",
                       "imageObj::write");
        }

        return retval;
    }
gdBuffer imageObj_getBytes(imageObj *self){
        gdBuffer buffer;
        
  	buffer.owns_data = 1;
        buffer.data = msSaveImageBufferGD(self->img.gd, &buffer.size,
                                          self->format);
        if( buffer.size == 0 )
        {
            buffer.data = NULL;
            msSetError(12, "Failed to get image buffer", "getBytes");
            return buffer;
        }

        return buffer;
    }
rectObj *new_rectObj(double minx,double miny,double maxx,double maxy,int imageunits){	
        rectObj *rect;
    
        if (imageunits == 0)
        { 
            if (minx > maxx || miny > maxy)
            {
                msSetError(34,
                    "{ 'minx': %f , 'miny': %f , 'maxx': %f , 'maxy': %f }",
                    "rectObj()", minx, miny, maxx, maxy);
                return NULL;
            }
        }
        else 
        {
            if (minx > maxx || maxy > miny) 
            {
                msSetError(34,
                    "image (pixel/line) units { 'minx': %f , 'miny': %f , 'maxx': %f , 'maxy': %f }",
                    "rectObj()", minx, miny, maxx, maxy);
                return NULL;
            }
        }
    
        rect = (rectObj *)calloc(1, sizeof(rectObj));
        if (!rect)
            return(NULL);
    
        rect->minx = minx;
        rect->miny = miny;
        rect->maxx = maxx;
        rect->maxy = maxy;

        return(rect);    	
    }
void delete_rectObj(rectObj *self){
        free(self);
    }
int rectObj_project(rectObj *self,projectionObj *projin,projectionObj *projout){
        return msProjectRect(projin, projout, self);
    }
double rectObj_fit(rectObj *self,int width,int height){
        return  msAdjustExtent(self, width, height);
    }
int rectObj_draw(rectObj *self,mapObj *map,layerObj *layer,imageObj *image,int classindex,char *text){
        shapeObj shape;

        msInitShape(&shape);
        msRectToPolygon(*self, &shape);
        shape.classindex = classindex;
        shape.text = strdup(text);

        msDrawShape(map, layer, &shape, image, -1);

        msFreeShape(&shape);
    
        return MS_SUCCESS;
    }
shapeObj *rectObj_toPolygon(rectObj *self){
        lineObj line = {0,NULL};
        shapeObj *shape;
        shape = (shapeObj *)malloc(sizeof(shapeObj));
        if (!shape)
            return NULL;
        msInitShape(shape);
        shape->type = MS_SHAPE_POLYGON;
  
        line.point = (pointObj *)malloc(sizeof(pointObj)*5);
        line.point[0].x = self->minx;
        line.point[0].y = self->miny;
        line.point[1].x = self->minx;
        line.point[1].y = self->maxy;
        line.point[2].x = self->maxx;
        line.point[2].y = self->maxy;
        line.point[3].x = self->maxx;
        line.point[3].y = self->miny;
        line.point[4].x = line.point[0].x;
        line.point[4].y = line.point[0].y;
  
        line.numpoints = 5;
  
        msAddLine(shape, &line);
        msComputeBounds(shape);
        
        free(line.point);

        return shape;
    }
char *rectObj_toString(rectObj *self){
        char buffer[256];
        char fmt[]="{ 'minx': %.16g , 'miny': %.16g , 'maxx': %.16g , 'maxy': %.16g }";
        msRectToFormattedString(self, (char *) &fmt, (char *) &buffer, 256);
        return strdup(buffer);
    }
pointObj *new_pointObj(double x,double y,double z,double m){
        pointObj *p;
        p = (pointObj *)calloc(1,sizeof(pointObj));
        if (!p) return NULL;
        p->x = x;
        p->y = y;




        return p;
    }
void delete_pointObj(pointObj *self){
        free(self);
    }
int pointObj_project(pointObj *self,projectionObj *projin,projectionObj *projout){
        return msProjectPoint(projin, projout, self);
    }
int pointObj_draw(pointObj *self,mapObj *map,layerObj *layer,imageObj *image,int classindex,char *text){
        return msDrawPoint(map, layer, self, image, classindex, text);
    }
double pointObj_distanceToPoint(pointObj *self,pointObj *point){
        return msDistancePointToPoint(self, point);
    }
double pointObj_distanceToSegment(pointObj *self,pointObj *a,pointObj *b){
        return msDistancePointToSegment(self, a, b);
    }
double pointObj_distanceToShape(pointObj *self,shapeObj *shape){
        return msDistancePointToShape(self, shape);
    }
int pointObj_setXY(pointObj *self,double x,double y,double m){
        self->x = x;
        self->y = y;




	
        return MS_SUCCESS;
    }
int pointObj_setXYZ(pointObj *self,double x,double y,double z,double m){
        self->x = x;
        self->y = y;




        return MS_SUCCESS;
    }
int pointObj_setXYZM(pointObj *self,double x,double y,double z,double m){
        self->x = x;
        self->y = y;




        return MS_SUCCESS;
    }
char *pointObj_toString(pointObj *self){
        char buffer[256];
        const char *fmt;







        fmt = "{ 'x': %.16g, 'y': %.16g }";

	
        msPointToFormattedString(self, fmt, (char *) &buffer, 256);
        return strdup(buffer);
    }
shapeObj *pointObj_toShape(pointObj *self){
      shapeObj *shape;

      shape = (shapeObj *) malloc(sizeof(shapeObj));
      msInitShape(shape);
    
      shape->type = MS_SHAPE_POINT;
      shape->line = (lineObj *) malloc(sizeof(lineObj));
      shape->numlines = 1;
      shape->line[0].point = (pointObj *) malloc(sizeof(pointObj));
      shape->line[0].numpoints = 1;

      shape->line[0].point[0].x = self->x;
      shape->line[0].point[0].y = self->y;





      return shape;
    }
lineObj *new_lineObj(){
        lineObj *line;

        line = (lineObj *)malloc(sizeof(lineObj));
        if (!line)
            return(NULL);

        line->numpoints=0;
        line->point=NULL;

        return line;
    }
void delete_lineObj(lineObj *self){
        free(self->point);
        free(self);		
    }
int lineObj_project(lineObj *self,projectionObj *projin,projectionObj *projout){
        return msProjectLine(projin, projout, self);
    }
pointObj *lineObj_get(lineObj *self,int i){
        if (i<0 || i>=self->numpoints)
            return NULL;
        else
            return &(self->point[i]);
    }
int lineObj_add(lineObj *self,pointObj *p){
        if (self->numpoints == 0) { /* new */	
        self->point = (pointObj *)malloc(sizeof(pointObj));      
        if (!self->point)
	        return MS_FAILURE;
        } else { /* extend array */
            self->point = (pointObj *)realloc(self->point, 
                                      sizeof(pointObj)*(self->numpoints+1));
        if (!self->point)
	        return MS_FAILURE;
        }

        self->point[self->numpoints].x = p->x;
        self->point[self->numpoints].y = p->y;
        self->numpoints++;

        return MS_SUCCESS;
    }
int lineObj_set(lineObj *self,int i,pointObj *p){
        if (i<0 || i>=self->numpoints)
            return MS_FAILURE;

        self->point[i].x = p->x;
        self->point[i].y = p->y;
        return MS_SUCCESS;    
    }
shapeObj *new_shapeObj(int type){
        shapeObj *shape;

	shape = (shapeObj *)malloc(sizeof(shapeObj));
        if (!shape)
            return NULL;

        msInitShape(shape);
        if(type >= 0) shape->type = type;
        
        return shape;
    }
void delete_shapeObj(shapeObj *self){
        msFreeShape(self);
        free(self);		
    }
shapeObj *shapeObj_fromWKT(char *wkt){
	shapeObj *shape;
        
        if(!wkt) return NULL;

        shape = msShapeFromWKT(wkt);
	if(!shape) return NULL;

	return shape;
    }
int shapeObj_project(shapeObj *self,projectionObj *projin,projectionObj *projout){
        return msProjectShape(projin, projout, self);
    }
lineObj *shapeObj_get(shapeObj *self,int i){
        if (i<0 || i>=self->numlines)
            return NULL;
        else
            return &(self->line[i]);
    }
int shapeObj_add(shapeObj *self,lineObj *line){
        return msAddLine(self, line);
    }
int shapeObj_draw(shapeObj *self,mapObj *map,layerObj *layer,imageObj *image){
        return msDrawShape(map, layer, self, image, -1);
    }
void shapeObj_setBounds(shapeObj *self){    
        msComputeBounds(self);
        return;
    }
shapeObj *shapeObj_clone(shapeObj *self){
        shapeObj *shape;
        shape = (shapeObj *)malloc(sizeof(shapeObj));
        if (!shape)
            return NULL;
        msInitShape(shape);
        shape->type = self->type;
        msCopyShape(self, shape);
        return shape;
    }
int shapeObj_copy(shapeObj *self,shapeObj *dest){
        return(msCopyShape(self, dest));
    }
char *shapeObj_toWKT(shapeObj *self){
        return msShapeToWKT(self);
    }
shapeObj *shapeObj_buffer(shapeObj *self,double width){ return msGEOSBuffer(self, width); }
shapeObj *shapeObj_convexHull(shapeObj *self){ return msGEOSConvexHull(self); }
shapeObj *shapeObj_boundary(shapeObj *self){ return msGEOSBoundary(self); }
pointObj *shapeObj_getCentroid(shapeObj *self){ return msGEOSGetCentroid(self); }
shapeObj *shapeObj_Union(shapeObj *self,shapeObj *shape){ return msGEOSUnion(self, shape); }
shapeObj *shapeObj_intersection(shapeObj *self,shapeObj *shape){ return msGEOSIntersection(self, shape); }
shapeObj *shapeObj_difference(shapeObj *self,shapeObj *shape){ return msGEOSDifference(self, shape); }
shapeObj *shapeObj_symDifference(shapeObj *self,shapeObj *shape){ return msGEOSSymDifference(self, shape); }
int shapeObj_contains__SWIG_0(shapeObj *self,shapeObj *shape){ return msGEOSContains(self, shape); }
int shapeObj_overlaps(shapeObj *self,shapeObj *shape){ return msGEOSOverlaps(self, shape); }
int shapeObj_within(shapeObj *self,shapeObj *shape){ return msGEOSWithin(self, shape); }
int shapeObj_crosses(shapeObj *self,shapeObj *shape){ return msGEOSCrosses(self, shape); }
int shapeObj_intersects(shapeObj *self,shapeObj *shape){ return msGEOSIntersects(self, shape); }
int shapeObj_touches(shapeObj *self,shapeObj *shape){ return msGEOSTouches(self, shape); }
int shapeObj_equals(shapeObj *self,shapeObj *shape){ return msGEOSEquals(self, shape); }
int shapeObj_disjoint(shapeObj *self,shapeObj *shape){ return msGEOSDisjoint(self, shape); }
double shapeObj_getArea(shapeObj *self){ return msGEOSArea(self); }
double shapeObj_getLength(shapeObj *self){ return msGEOSLength(self); }
char *shapeObj_getValue(shapeObj *self,int i){
        if (i >= 0 && i < self->numvalues && self->values)
            return (self->values[i]);
        else
            return NULL;
    }
int shapeObj_contains__SWIG_1(shapeObj *self,pointObj *point){
        if (self->type == MS_SHAPE_POLYGON)
            return msIntersectPointPolygon(point, self);
        
        return -1;
    }
double shapeObj_distanceToPoint(shapeObj *self,pointObj *point){
        return msDistancePointToShape(point, self); /* should there be a GEOS version of this? */
    }
double shapeObj_distanceToShape(shapeObj *self,shapeObj *shape){
	return msGEOSDistance(self, shape); /* note this calls msDistanceShapeToShape() if GEOS support is not present */
    }
int shapeObj_setValue(shapeObj *self,int i,char *value){
        if (!self->values || !value)
        {
            msSetError(19, "Can't set value", "setValue()");
            return MS_FAILURE;
        }
        if (i >= 0 && i < self->numvalues)
        {
            msFree(self->values[i]);
            self->values[i] = strdup(value);
            if (!self->values[i])
            {
                return MS_FAILURE;
            }
            else return MS_SUCCESS;
        }
        else
        {
            msSetError(19, "Invalid value index", 
                                  "setValue()");
            return MS_FAILURE;
        }
    }
void shapeObj_initValues(shapeObj *self,int numvalues){
        int i;
        
        if(self->values) msFreeCharArray(self->values, self->numvalues);
        self->values = NULL;
        self->numvalues = 0;
        
        /* Allocate memory for the values */
        if (numvalues > 0) {
            if ((self->values = (char **)malloc(sizeof(char *)*numvalues)) == NULL) {
                msSetError(2, "Failed to allocate memory for values", "shapeObj()");
                return;
            } else {
                for (i=0; i<numvalues; i++) self->values[i] = strdup("");
            }
            self->numvalues = numvalues;
        }
    }
char *DBFInfo_getFieldName(DBFInfo *self,int iField){
        static char pszFieldName[1000];
	    int pnWidth;
	    int pnDecimals;
	    msDBFGetFieldInfo(self, iField, &pszFieldName[0], &pnWidth, 
                          &pnDecimals);
	    return pszFieldName;
    }
int DBFInfo_getFieldWidth(DBFInfo *self,int iField){
        char pszFieldName[1000];
	    int pnWidth;
	    int pnDecimals;
	    msDBFGetFieldInfo(self, iField, &pszFieldName[0], &pnWidth,
                          &pnDecimals);
	    return pnWidth;
    }
int DBFInfo_getFieldDecimals(DBFInfo *self,int iField){
        char pszFieldName[1000];
	    int pnWidth;
	    int pnDecimals;
	    msDBFGetFieldInfo(self, iField, &pszFieldName[0], &pnWidth,
                          &pnDecimals);
	    return pnDecimals;
    }
int DBFInfo_getFieldType(DBFInfo *self,int iField){
	    return msDBFGetFieldInfo(self, iField, NULL, NULL, NULL);
    }
shapefileObj *new_shapefileObj(char *filename,int type){    
        shapefileObj *shapefile;
        int status;

        shapefile = (shapefileObj *)malloc(sizeof(shapefileObj));
        if (!shapefile)
            return NULL;

        if (type == -1)
            status = msSHPOpenFile(shapefile, "rb", filename);
        else if (type == -2)
            status = msSHPOpenFile(shapefile, "rb+", filename);
        else
            status = msSHPCreateFile(shapefile, filename, type);

        if (status == -1) {
            msSHPCloseFile(shapefile);
            free(shapefile);
            return NULL;
        }
 
        return(shapefile);
    }
void delete_shapefileObj(shapefileObj *self){
        msSHPCloseFile(self);
        free(self);  
    }
int shapefileObj_get(shapefileObj *self,int i,shapeObj *shape){
        if (i<0 || i>=self->numshapes)
            return MS_FAILURE;

        msFreeShape(shape); /* frees all lines and points before re-filling */
        msSHPReadShape(self->hSHP, i, shape);

        return MS_SUCCESS;
    }
shapeObj *shapefileObj_getShape(shapefileObj *self,int i){
        shapeObj *shape;
        shape = (shapeObj *)malloc(sizeof(shapeObj));
        if (!shape)
            return NULL;
        msInitShape(shape);
        shape->type = self->type;
        msSHPReadShape(self->hSHP, i, shape);
        return shape;

    }
int shapefileObj_getPoint(shapefileObj *self,int i,pointObj *point){
        if (i<0 || i>=self->numshapes)
            return MS_FAILURE;

        msSHPReadPoint(self->hSHP, i, point);
        return MS_SUCCESS;
    }
int shapefileObj_getTransformed(shapefileObj *self,mapObj *map,int i,shapeObj *shape){
        if (i<0 || i>=self->numshapes)
            return MS_FAILURE;

        msFreeShape(shape); /* frees all lines and points before re-filling */
        msSHPReadShape(self->hSHP, i, shape);
        msTransformShapeToPixel(shape, map->extent, map->cellsize);

        return MS_SUCCESS;
    }
void shapefileObj_getExtent(shapefileObj *self,int i,rectObj *rect){
        msSHPReadBounds(self->hSHP, i, rect);
    }
int shapefileObj_add(shapefileObj *self,shapeObj *shape){
        /* Trap NULL or empty shapes -- bug 1201 */
        if (!shape) 
        {
            msSetError(19, "Can't add NULL shape", "shapefileObj::add");
            return MS_FAILURE;
        }
        else if (!shape->line)
        {
            msSetError(19, "Can't add empty shape", "shapefileObj::add");
            return MS_FAILURE;
        }

        return msSHPWriteShape(self->hSHP, shape);	
    }
int shapefileObj_addPoint(shapefileObj *self,pointObj *point){    
        return msSHPWritePoint(self->hSHP, point);	
    }
projectionObj *new_projectionObj(char *proj4){
        int status;
        projectionObj *proj=NULL;

        proj = (projectionObj *)malloc(sizeof(projectionObj));
        if (!proj) return NULL;
        msInitProjection(proj);

        status = msLoadProjectionString(proj, proj4);
        if (status == -1) {
            msFreeProjection(proj);
            free(proj);
            return NULL;
        }

        return proj;
    }
void delete_projectionObj(projectionObj *self){
        msFreeProjection(self);
        free(self);		
    }
colorObj *new_colorObj(int red,int green,int blue,int pen){
        colorObj *color;
        
        /* Check colors */
        if (red > 255 || green > 255 || blue > 255) {
            msSetError(12, "Invalid color index.", "colorObj()");
            return NULL;
        }
    
        color = (colorObj *)calloc(1, sizeof(colorObj));
        if (!color)
            return(NULL);
    
        MS_INIT_COLOR(*color, red, green, blue);

        return(color);    	
    }
void delete_colorObj(colorObj *self){
        free(self);
    }
int colorObj_setRGB(colorObj *self,int red,int green,int blue){
        /* Check colors */
        if (red > 255 || green > 255 || blue > 255) {
            msSetError(12, "Invalid color index.", "setRGB()");
            return MS_FAILURE;
        }
    
        MS_INIT_COLOR(*self, red, green, blue);
        return MS_SUCCESS;
    }
int colorObj_setHex(colorObj *self,char *psHexColor){
        int red, green, blue;
        if (psHexColor && strlen(psHexColor)== 7 && psHexColor[0] == '#') {
            red = hex2int(psHexColor+1);
            green = hex2int(psHexColor+3);
            blue= hex2int(psHexColor+5);
            if (red > 255 || green > 255 || blue > 255) {
                msSetError(12, "Invalid color index.", "setHex()");
                return MS_FAILURE;
            }

            MS_INIT_COLOR(*self, red, green, blue);
            return MS_SUCCESS;
        }
        else {
            msSetError(12, "Invalid hex color.", "setHex()");
            return MS_FAILURE;
        }
    }
char *colorObj_toHex(colorObj *self){
        char hexcolor[8] = "";

        if (!self) 
        {
            msSetError(12, "Can't express NULL color as hex",
                       "toHex()");
            return NULL;
        }
        if (self->red < 0 || self->green < 0 || self->blue < 0) 
        {
            msSetError(12, "Can't express invalid color as hex",
                       "toHex()");
            return NULL;
        }
        snprintf(hexcolor, 8, "#%02x%02x%02x",
                 self->red, self->green, self->blue);
        return strdup(hexcolor);
    }
symbolObj *new_symbolObj(char *symbolname,char const *imagefile){
        symbolObj *symbol;
        symbol = (symbolObj *) malloc(sizeof(symbolObj));
        initSymbol(symbol);
        symbol->name = strdup(symbolname);
        if (imagefile) {
            msLoadImageSymbol(symbol, imagefile);
        }
        return symbol;
    }
void delete_symbolObj(symbolObj *self){
        if (!self) return;
        if (self->name) free(self->name);
        if (self->img) gdImageDestroy(self->img);
        if (self->font) free(self->font);
        if (self->imagepath) free(self->imagepath);
        free(self);
    }
int symbolObj_setImagepath(symbolObj *self,char const *imagefile){
	return msLoadImageSymbol(self, imagefile);
    }
int symbolObj_setPoints(symbolObj *self,lineObj *line){
        int i;
        for (i=0; i<line->numpoints; i++) {
            MS_COPYPOINT(&(self->points[i]), &(line->point[i]));
        }
        self->numpoints = line->numpoints;
        return self->numpoints;
    }
lineObj *symbolObj_getPoints(symbolObj *self){
        int i;
        lineObj *line;
        line = (lineObj *) malloc(sizeof(lineObj));
        line->point = (pointObj *) malloc(sizeof(pointObj)*(self->numpoints));
        for (i=0; i<self->numpoints; i++) {
            line->point[i].x = self->points[i].x;
            line->point[i].y = self->points[i].y;
        }
        line->numpoints = self->numpoints;
        return line;
    }
int symbolObj_setStyle(symbolObj *self,int index,int value){
        if (index < 0 || index > 10) {
            msSetError(4, "Can't set style at index %d.", "setStyle()", index);
            return MS_FAILURE;
        }
        self->style[index] = value;
        return MS_SUCCESS;
    }
imageObj *symbolObj_getImage(symbolObj *self,outputFormatObj *format){
        return msSymbolGetImageGD(self, format);
    }
int symbolObj_setImage(symbolObj *self,imageObj *image){
        return msSymbolSetImageGD(self, image);
    }
errorObj *new_errorObj(){    
        return msGetErrorObj();
    }
void delete_errorObj(errorObj *self){}
errorObj *errorObj_next(errorObj *self){
        errorObj *ep;	

        if (self == NULL || self->next == NULL) return NULL;

        ep = msGetErrorObj();
        while (ep != self) {
            /* We reached end of list of active errorObj and 
               didn't find the errorObj... this is bad! */
            if (ep->next == NULL) return NULL;
            ep = ep->next;
        }
    
        return ep->next;
    }

#include "../../map.h"


#include "../../maphash.h"

hashTableObj *new_hashTableObj(){

        return msCreateHashTable();
    }
void delete_hashTableObj(hashTableObj *self){
        msFreeHashTable(self);
    }
int hashTableObj_set(hashTableObj *self,char *key,char *value){
        if (msInsertHashTable(self, key, value) == NULL) {
	        return MS_FAILURE;
        }
        return MS_SUCCESS;
    }
char *hashTableObj_get(hashTableObj *self,char *key,char *default_value){
        char *value = NULL;
        if (!key) {
            msSetError(16, "NULL key", "get");
        }
     
        value = (char *) msLookupHashTable(self, key);
        if (!value) {
            return default_value;
        }
        return value;
    }
int hashTableObj_remove(hashTableObj *self,char *key){
        return msRemoveHashTable(self, key);
    }
void hashTableObj_clear(hashTableObj *self){
        msFreeHashItems(self);
        initHashTable(self);
    }
char const *hashTableObj_nextKey(hashTableObj *self,char *prevkey){
        return msNextKeyFromHashTable(self, (const char *) prevkey);
    }
cgiRequestObj *new_cgiRequestObj(){
        cgiRequestObj *request;
        
        request = msAllocCgiObj();
        if (!request) {
            msSetError(13, "Failed to initialize object","OWSRequest()");
            return NULL;
        }
        
        request->ParamNames = (char **) malloc(100*sizeof(char*));
        request->ParamValues = (char **) malloc(100*sizeof(char*));
        if (request->ParamNames==NULL || request->ParamValues==NULL) {
	        msSetError(2, NULL, "OWSRequest()");
            return NULL;
        }
        return request;
    }
void delete_cgiRequestObj(cgiRequestObj *self){
        msFreeCharArray(self->ParamNames, self->NumParams);
        msFreeCharArray(self->ParamValues, self->NumParams);
        free(self);
    }
int cgiRequestObj_loadParams(cgiRequestObj *self){
	self->NumParams = loadParams( self );
	return self->NumParams;
    }
void cgiRequestObj_setParameter(cgiRequestObj *self,char *name,char *value){
        int i;
        
        if (self->NumParams == 100) {
            msSetError(31, "Maximum number of items, %d, has been reached", "setItem()", 100);
        }
        
        for (i=0; i<self->NumParams; i++) {
            if (strcasecmp(self->ParamNames[i], name) == 0) {
                free(self->ParamValues[i]);
                self->ParamValues[i] = strdup(value);
                break;
            }
        }
        if (i == self->NumParams) {
            self->ParamNames[self->NumParams] = strdup(name);
            self->ParamValues[self->NumParams] = strdup(value);
            self->NumParams++;
        }
    }
char *cgiRequestObj_getName(cgiRequestObj *self,int index){
        if (index < 0 || index >= self->NumParams) {
            msSetError(31, "Invalid index, valid range is [0, %d]", "getName()", self->NumParams-1);
            return NULL;
        }
        return self->ParamNames[index];
    }
char *cgiRequestObj_getValue(cgiRequestObj *self,int index){
        if (index < 0 || index >= self->NumParams) {
            msSetError(31, "Invalid index, valid range is [0, %d]", "getValue()", self->NumParams-1);
            return NULL;
        }
        return self->ParamValues[index];
    }
char *cgiRequestObj_getValueByName(cgiRequestObj *self,char const *name){
        int i;
        for (i=0; i<self->NumParams; i++) {
            if (strcasecmp(self->ParamNames[i], name) == 0) {
                return self->ParamValues[i];
            }
        }
        return NULL;
    }


const char *msIO_getStdoutBufferString() {
    msIOContext *ctx = msIO_getHandler( (FILE *) "stdout" );
    msIOBuffer  *buf;

    if( ctx == NULL || ctx->write_channel == MS_FALSE 
        || strcmp(ctx->label,"buffer") != 0 )
    {
	msSetError( MS_MISCERR, "Can't identify msIO buffer.",
                    "msIO_getStdoutBufferString" );
	return "";
    }

    buf = (msIOBuffer *) ctx->cbData;

    /* write one zero byte and backtrack if it isn't already there */
    if( buf->data_len == 0 || buf->data[buf->data_offset] != '\0' ) {
        msIO_bufferWrite( buf, "", 1 );
	buf->data_offset--;
    }

    return (const char *) (buf->data);
}

gdBuffer msIO_getStdoutBufferBytes() {
    msIOContext *ctx = msIO_getHandler( (FILE *) "stdout" );
    msIOBuffer  *buf;
    gdBuffer     gdBuf;

    if( ctx == NULL || ctx->write_channel == MS_FALSE 
        || strcmp(ctx->label,"buffer") != 0 )
    {
	msSetError( MS_MISCERR, "Can't identify msIO buffer.",
                    "msIO_getStdoutBufferString" );
	gdBuf.data = (unsigned char*)"";
	gdBuf.size = 0;
	gdBuf.owns_data = MS_FALSE;
	return gdBuf;
    }

    buf = (msIOBuffer *) ctx->cbData;

    gdBuf.data = buf->data;
    gdBuf.size = buf->data_offset;
    gdBuf.owns_data = MS_FALSE;

    /* we are seizing ownership of the buffer contents */
    buf->data_offset = 0;
    buf->data_len = 0;
    buf->data = NULL;

    return gdBuf;
}


#ifdef PERL_OBJECT
#define MAGIC_CLASS _wrap_mapscript_var::
class _wrap_mapscript_var : public CPerlObj {
public:
#else
#define MAGIC_CLASS
#endif
SWIGCLASS_STATIC int swig_magic_readonly(pTHX_ SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    sv = sv; mg = mg;
    croak("Value is read-only.");
    return 0;
}


#ifdef PERL_OBJECT
};
#endif

#ifdef __cplusplus
extern "C" {
#endif
XS(_wrap_new_intarray) {
    {
        int arg1 ;
        intarray *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_intarray(nelements);");
        }
        arg1 = (int) SvIV(ST(0));
        result = (intarray *)new_intarray(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_intarray, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_intarray) {
    {
        intarray *arg1 = (intarray *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_intarray(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_intarray,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_intarray. Expected _p_intarray");
            }
        }
        delete_intarray(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_intarray_getitem) {
    {
        intarray *arg1 = (intarray *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: intarray_getitem(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_intarray,0) < 0) {
                SWIG_croak("Type error in argument 1 of intarray_getitem. Expected _p_intarray");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)intarray_getitem(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_intarray_setitem) {
    {
        intarray *arg1 = (intarray *) 0 ;
        int arg2 ;
        int arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: intarray_setitem(self,index,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_intarray,0) < 0) {
                SWIG_croak("Type error in argument 1 of intarray_setitem. Expected _p_intarray");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (int) SvIV(ST(2));
        intarray_setitem(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_intarray_cast) {
    {
        intarray *arg1 = (intarray *) 0 ;
        int *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: intarray_cast(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_intarray,0) < 0) {
                SWIG_croak("Type error in argument 1 of intarray_cast. Expected _p_intarray");
            }
        }
        result = (int *)intarray_cast(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_int, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_intarray_frompointer) {
    {
        int *arg1 = (int *) 0 ;
        intarray *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: intarray_frompointer(t);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_int,0) < 0) {
                SWIG_croak("Type error in argument 1 of intarray_frompointer. Expected _p_int");
            }
        }
        result = (intarray *)intarray_frompointer(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_intarray, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_fontSetObj_filename_get) {
    {
        fontSetObj *arg1 = (fontSetObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: fontSetObj_filename_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_fontSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of fontSetObj_filename_get. Expected _p_fontSetObj");
            }
        }
        result = (char *) ((arg1)->filename);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_fontSetObj_numfonts_get) {
    {
        fontSetObj *arg1 = (fontSetObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: fontSetObj_numfonts_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_fontSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of fontSetObj_numfonts_get. Expected _p_fontSetObj");
            }
        }
        result = (int) ((arg1)->numfonts);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_fontSetObj_fonts_get) {
    {
        fontSetObj *arg1 = (fontSetObj *) 0 ;
        hashTableObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: fontSetObj_fonts_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_fontSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of fontSetObj_fonts_get. Expected _p_fontSetObj");
            }
        }
        result = (hashTableObj *)& ((arg1)->fonts);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_hashTableObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_fontSetObj) {
    {
        fontSetObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_fontSetObj();");
        }
        result = (fontSetObj *)(fontSetObj *) calloc(1, sizeof(fontSetObj));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_fontSetObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_fontSetObj) {
    {
        fontSetObj *arg1 = (fontSetObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_fontSetObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_fontSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_fontSetObj. Expected _p_fontSetObj");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_name_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_name_set(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_name_set. Expected _p_outputFormatObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->name) free((char*)arg1->name);
            if (arg2) {
                arg1->name = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->name,arg2);
            } else {
                arg1->name = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_name_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_name_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_name_get. Expected _p_outputFormatObj");
            }
        }
        result = (char *) ((arg1)->name);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_mimetype_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_mimetype_set(self,mimetype);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_mimetype_set. Expected _p_outputFormatObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->mimetype) free((char*)arg1->mimetype);
            if (arg2) {
                arg1->mimetype = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->mimetype,arg2);
            } else {
                arg1->mimetype = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_mimetype_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_mimetype_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_mimetype_get. Expected _p_outputFormatObj");
            }
        }
        result = (char *) ((arg1)->mimetype);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_driver_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_driver_set(self,driver);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_driver_set. Expected _p_outputFormatObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->driver) free((char*)arg1->driver);
            if (arg2) {
                arg1->driver = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->driver,arg2);
            } else {
                arg1->driver = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_driver_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_driver_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_driver_get. Expected _p_outputFormatObj");
            }
        }
        result = (char *) ((arg1)->driver);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_extension_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_extension_set(self,extension);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_extension_set. Expected _p_outputFormatObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->extension) free((char*)arg1->extension);
            if (arg2) {
                arg1->extension = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->extension,arg2);
            } else {
                arg1->extension = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_extension_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_extension_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_extension_get. Expected _p_outputFormatObj");
            }
        }
        result = (char *) ((arg1)->extension);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_renderer_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_renderer_set(self,renderer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_renderer_set. Expected _p_outputFormatObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->renderer = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_renderer_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_renderer_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_renderer_get. Expected _p_outputFormatObj");
            }
        }
        result = (int) ((arg1)->renderer);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_imagemode_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_imagemode_set(self,imagemode);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_imagemode_set. Expected _p_outputFormatObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->imagemode = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_imagemode_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_imagemode_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_imagemode_get. Expected _p_outputFormatObj");
            }
        }
        result = (int) ((arg1)->imagemode);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_transparent_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_transparent_set(self,transparent);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_transparent_set. Expected _p_outputFormatObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->transparent = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_transparent_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_transparent_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_transparent_get. Expected _p_outputFormatObj");
            }
        }
        result = (int) ((arg1)->transparent);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_bands_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_bands_set(self,bands);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_bands_set. Expected _p_outputFormatObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->bands = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_bands_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_bands_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_bands_get. Expected _p_outputFormatObj");
            }
        }
        result = (int) ((arg1)->bands);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_numformatoptions_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_numformatoptions_set(self,numformatoptions);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_numformatoptions_set. Expected _p_outputFormatObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->numformatoptions = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_numformatoptions_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_numformatoptions_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_numformatoptions_get. Expected _p_outputFormatObj");
            }
        }
        result = (int) ((arg1)->numformatoptions);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_formatoptions_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char **arg2 = (char **) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_formatoptions_set(self,formatoptions);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_formatoptions_set. Expected _p_outputFormatObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_p_char,0) < 0) {
                SWIG_croak("Type error in argument 2 of outputFormatObj_formatoptions_set. Expected _p_p_char");
            }
        }
        if (arg1) (arg1)->formatoptions = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_formatoptions_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char **result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_formatoptions_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_formatoptions_get. Expected _p_outputFormatObj");
            }
        }
        result = (char **) ((arg1)->formatoptions);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_p_char, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_refcount_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_refcount_set(self,refcount);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_refcount_set. Expected _p_outputFormatObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->refcount = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_refcount_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_refcount_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_refcount_get. Expected _p_outputFormatObj");
            }
        }
        result = (int) ((arg1)->refcount);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_inmapfile_set) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_inmapfile_set(self,inmapfile);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_inmapfile_set. Expected _p_outputFormatObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->inmapfile = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_inmapfile_get) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_inmapfile_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_inmapfile_get. Expected _p_outputFormatObj");
            }
        }
        result = (int) ((arg1)->inmapfile);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_outputFormatObj) {
    {
        char *arg1 ;
        char *arg2 = (char *) NULL ;
        outputFormatObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: new_outputFormatObj(driver,name);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (items > 1) {
            if (!SvOK((SV*) ST(1))) arg2 = 0;
            else arg2 = (char *) SvPV(ST(1), PL_na);
        }
        result = (outputFormatObj *)new_outputFormatObj((char const *)arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_outputFormatObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_outputFormatObj) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_outputFormatObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_outputFormatObj. Expected _p_outputFormatObj");
            }
        }
        delete_outputFormatObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_setExtension) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_setExtension(self,extension);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_setExtension. Expected _p_outputFormatObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        outputFormatObj_setExtension(arg1,(char const *)arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_setMimetype) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: outputFormatObj_setMimetype(self,mimetype);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_setMimetype. Expected _p_outputFormatObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        outputFormatObj_setMimetype(arg1,(char const *)arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_setOption) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *arg2 ;
        char *arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: outputFormatObj_setOption(self,key,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_setOption. Expected _p_outputFormatObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        outputFormatObj_setOption(arg1,(char const *)arg2,(char const *)arg3);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_validate) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: outputFormatObj_validate(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_validate. Expected _p_outputFormatObj");
            }
        }
        result = (int)outputFormatObj_validate(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_outputFormatObj_getOption) {
    {
        outputFormatObj *arg1 = (outputFormatObj *) 0 ;
        char *arg2 ;
        char *arg3 = (char *) "" ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: outputFormatObj_getOption(self,key,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of outputFormatObj_getOption. Expected _p_outputFormatObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (items > 2) {
            if (!SvOK((SV*) ST(2))) arg3 = 0;
            else arg3 = (char *) SvPV(ST(2), PL_na);
        }
        result = (char *)outputFormatObj_getOption(arg1,(char const *)arg2,(char const *)arg3);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_queryMapObj_height_set) {
    {
        queryMapObj *arg1 = (queryMapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: queryMapObj_height_set(self,height);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_queryMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of queryMapObj_height_set. Expected _p_queryMapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->height = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_queryMapObj_height_get) {
    {
        queryMapObj *arg1 = (queryMapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: queryMapObj_height_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_queryMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of queryMapObj_height_get. Expected _p_queryMapObj");
            }
        }
        result = (int) ((arg1)->height);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_queryMapObj_width_set) {
    {
        queryMapObj *arg1 = (queryMapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: queryMapObj_width_set(self,width);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_queryMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of queryMapObj_width_set. Expected _p_queryMapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->width = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_queryMapObj_width_get) {
    {
        queryMapObj *arg1 = (queryMapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: queryMapObj_width_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_queryMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of queryMapObj_width_get. Expected _p_queryMapObj");
            }
        }
        result = (int) ((arg1)->width);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_queryMapObj_status_set) {
    {
        queryMapObj *arg1 = (queryMapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: queryMapObj_status_set(self,status);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_queryMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of queryMapObj_status_set. Expected _p_queryMapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->status = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_queryMapObj_status_get) {
    {
        queryMapObj *arg1 = (queryMapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: queryMapObj_status_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_queryMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of queryMapObj_status_get. Expected _p_queryMapObj");
            }
        }
        result = (int) ((arg1)->status);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_queryMapObj_style_set) {
    {
        queryMapObj *arg1 = (queryMapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: queryMapObj_style_set(self,style);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_queryMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of queryMapObj_style_set. Expected _p_queryMapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->style = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_queryMapObj_style_get) {
    {
        queryMapObj *arg1 = (queryMapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: queryMapObj_style_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_queryMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of queryMapObj_style_get. Expected _p_queryMapObj");
            }
        }
        result = (int) ((arg1)->style);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_queryMapObj_color_set) {
    {
        queryMapObj *arg1 = (queryMapObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: queryMapObj_color_set(self,color);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_queryMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of queryMapObj_color_set. Expected _p_queryMapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of queryMapObj_color_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->color = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_queryMapObj_color_get) {
    {
        queryMapObj *arg1 = (queryMapObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: queryMapObj_color_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_queryMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of queryMapObj_color_get. Expected _p_queryMapObj");
            }
        }
        result = (colorObj *)& ((arg1)->color);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_queryMapObj) {
    {
        queryMapObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_queryMapObj();");
        }
        result = (queryMapObj *)(queryMapObj *) calloc(1, sizeof(queryMapObj));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_queryMapObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_queryMapObj) {
    {
        queryMapObj *arg1 = (queryMapObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_queryMapObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_queryMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_queryMapObj. Expected _p_queryMapObj");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_font_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_font_set(self,font);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_font_set. Expected _p_labelObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->font) free((char*)arg1->font);
            if (arg2) {
                arg1->font = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->font,arg2);
            } else {
                arg1->font = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_font_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_font_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_font_get. Expected _p_labelObj");
            }
        }
        result = (char *) ((arg1)->font);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_type_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_type_set(self,type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_type_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->type = (enum MS_FONT_TYPE)arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_type_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_type_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_type_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->type);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_color_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_color_set(self,color);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_color_set. Expected _p_labelObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of labelObj_color_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->color = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_color_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_color_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_color_get. Expected _p_labelObj");
            }
        }
        result = (colorObj *)& ((arg1)->color);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_outlinecolor_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_outlinecolor_set(self,outlinecolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_outlinecolor_set. Expected _p_labelObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of labelObj_outlinecolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->outlinecolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_outlinecolor_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_outlinecolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_outlinecolor_get. Expected _p_labelObj");
            }
        }
        result = (colorObj *)& ((arg1)->outlinecolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_shadowcolor_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_shadowcolor_set(self,shadowcolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_shadowcolor_set. Expected _p_labelObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of labelObj_shadowcolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->shadowcolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_shadowcolor_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_shadowcolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_shadowcolor_get. Expected _p_labelObj");
            }
        }
        result = (colorObj *)& ((arg1)->shadowcolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_shadowsizex_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_shadowsizex_set(self,shadowsizex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_shadowsizex_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->shadowsizex = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_shadowsizex_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_shadowsizex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_shadowsizex_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->shadowsizex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_shadowsizey_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_shadowsizey_set(self,shadowsizey);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_shadowsizey_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->shadowsizey = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_shadowsizey_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_shadowsizey_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_shadowsizey_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->shadowsizey);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_backgroundcolor_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_backgroundcolor_set(self,backgroundcolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_backgroundcolor_set. Expected _p_labelObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of labelObj_backgroundcolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->backgroundcolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_backgroundcolor_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_backgroundcolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_backgroundcolor_get. Expected _p_labelObj");
            }
        }
        result = (colorObj *)& ((arg1)->backgroundcolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_backgroundshadowcolor_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_backgroundshadowcolor_set(self,backgroundshadowcolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_backgroundshadowcolor_set. Expected _p_labelObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of labelObj_backgroundshadowcolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->backgroundshadowcolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_backgroundshadowcolor_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_backgroundshadowcolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_backgroundshadowcolor_get. Expected _p_labelObj");
            }
        }
        result = (colorObj *)& ((arg1)->backgroundshadowcolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_backgroundshadowsizex_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_backgroundshadowsizex_set(self,backgroundshadowsizex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_backgroundshadowsizex_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->backgroundshadowsizex = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_backgroundshadowsizex_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_backgroundshadowsizex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_backgroundshadowsizex_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->backgroundshadowsizex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_backgroundshadowsizey_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_backgroundshadowsizey_set(self,backgroundshadowsizey);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_backgroundshadowsizey_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->backgroundshadowsizey = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_backgroundshadowsizey_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_backgroundshadowsizey_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_backgroundshadowsizey_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->backgroundshadowsizey);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_size_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_size_set(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_size_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->size = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_size_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_size_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_size_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->size);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_minsize_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_minsize_set(self,minsize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_minsize_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->minsize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_minsize_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_minsize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_minsize_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->minsize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_maxsize_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_maxsize_set(self,maxsize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_maxsize_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->maxsize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_maxsize_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_maxsize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_maxsize_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->maxsize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_position_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_position_set(self,position);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_position_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->position = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_position_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_position_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_position_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->position);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_offsetx_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_offsetx_set(self,offsetx);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_offsetx_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->offsetx = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_offsetx_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_offsetx_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_offsetx_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->offsetx);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_offsety_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_offsety_set(self,offsety);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_offsety_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->offsety = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_offsety_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_offsety_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_offsety_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->offsety);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_angle_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_angle_set(self,angle);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_angle_set. Expected _p_labelObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->angle = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_angle_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_angle_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_angle_get. Expected _p_labelObj");
            }
        }
        result = (double) ((arg1)->angle);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_autoangle_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_autoangle_set(self,autoangle);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_autoangle_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->autoangle = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_autoangle_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_autoangle_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_autoangle_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->autoangle);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_autofollow_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_autofollow_set(self,autofollow);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_autofollow_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->autofollow = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_autofollow_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_autofollow_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_autofollow_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->autofollow);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_buffer_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_buffer_set(self,buffer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_buffer_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->buffer = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_buffer_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_buffer_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_buffer_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->buffer);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_antialias_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_antialias_set(self,antialias);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_antialias_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->antialias = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_antialias_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_antialias_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_antialias_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->antialias);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_wrap_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        char arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_wrap_set(self,wrap);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_wrap_set. Expected _p_labelObj");
            }
        }
        arg2 = (char) *SvPV(ST(1),PL_na);
        if (arg1) (arg1)->wrap = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_wrap_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        char result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_wrap_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_wrap_get. Expected _p_labelObj");
            }
        }
        result = (char) ((arg1)->wrap);
        
        ST(argvi) = sv_newmortal();
        sv_setpvn((SV*)ST(argvi++), &result, 1);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_minfeaturesize_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_minfeaturesize_set(self,minfeaturesize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_minfeaturesize_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->minfeaturesize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_minfeaturesize_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_minfeaturesize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_minfeaturesize_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->minfeaturesize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_autominfeaturesize_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_autominfeaturesize_set(self,autominfeaturesize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_autominfeaturesize_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->autominfeaturesize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_autominfeaturesize_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_autominfeaturesize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_autominfeaturesize_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->autominfeaturesize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_mindistance_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_mindistance_set(self,mindistance);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_mindistance_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->mindistance = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_mindistance_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_mindistance_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_mindistance_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->mindistance);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_partials_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_partials_set(self,partials);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_partials_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->partials = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_partials_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_partials_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_partials_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->partials);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_force_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_force_set(self,force);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_force_set. Expected _p_labelObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->force = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_force_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_force_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_force_get. Expected _p_labelObj");
            }
        }
        result = (int) ((arg1)->force);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_encoding_set) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: labelObj_encoding_set(self,encoding);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_encoding_set. Expected _p_labelObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->encoding) free((char*)arg1->encoding);
            if (arg2) {
                arg1->encoding = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->encoding,arg2);
            } else {
                arg1->encoding = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelObj_encoding_get) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelObj_encoding_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelObj_encoding_get. Expected _p_labelObj");
            }
        }
        result = (char *) ((arg1)->encoding);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_labelObj) {
    {
        labelObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_labelObj();");
        }
        result = (labelObj *)(labelObj *) calloc(1, sizeof(labelObj));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_labelObj) {
    {
        labelObj *arg1 = (labelObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_labelObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_labelObj. Expected _p_labelObj");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_log_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_log_set(self,log);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_log_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->log) free((char*)arg1->log);
            if (arg2) {
                arg1->log = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->log,arg2);
            } else {
                arg1->log = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_log_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_log_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_log_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->log);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_imagepath_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_imagepath_set(self,imagepath);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_imagepath_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->imagepath) free((char*)arg1->imagepath);
            if (arg2) {
                arg1->imagepath = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->imagepath,arg2);
            } else {
                arg1->imagepath = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_imagepath_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_imagepath_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_imagepath_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->imagepath);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_imageurl_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_imageurl_set(self,imageurl);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_imageurl_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->imageurl) free((char*)arg1->imageurl);
            if (arg2) {
                arg1->imageurl = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->imageurl,arg2);
            } else {
                arg1->imageurl = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_imageurl_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_imageurl_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_imageurl_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->imageurl);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_map_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        struct map_obj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_map_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_map_get. Expected _p_webObj");
            }
        }
        result = (struct map_obj *) ((arg1)->map);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_map_obj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_template_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_template_set(self,template);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_template_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->template) free((char*)arg1->template);
            if (arg2) {
                arg1->template = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->template,arg2);
            } else {
                arg1->template = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_template_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_template_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_template_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->template);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_header_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_header_set(self,header);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_header_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->header) free((char*)arg1->header);
            if (arg2) {
                arg1->header = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->header,arg2);
            } else {
                arg1->header = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_header_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_header_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_header_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->header);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_footer_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_footer_set(self,footer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_footer_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->footer) free((char*)arg1->footer);
            if (arg2) {
                arg1->footer = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->footer,arg2);
            } else {
                arg1->footer = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_footer_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_footer_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_footer_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->footer);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_empty_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_empty_set(self,empty);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_empty_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->empty) free((char*)arg1->empty);
            if (arg2) {
                arg1->empty = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->empty,arg2);
            } else {
                arg1->empty = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_empty_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_empty_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_empty_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->empty);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_error_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_error_set(self,error);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_error_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->error) free((char*)arg1->error);
            if (arg2) {
                arg1->error = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->error,arg2);
            } else {
                arg1->error = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_error_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_error_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_error_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->error);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_extent_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        rectObj *arg2 = (rectObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_extent_set(self,extent);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_extent_set. Expected _p_webObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of webObj_extent_set. Expected _p_rectObj");
            }
        }
        if (arg1) (arg1)->extent = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_extent_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        rectObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_extent_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_extent_get. Expected _p_webObj");
            }
        }
        result = (rectObj *)& ((arg1)->extent);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_rectObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_minscale_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_minscale_set(self,minscale);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_minscale_set. Expected _p_webObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->minscale = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_minscale_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_minscale_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_minscale_get. Expected _p_webObj");
            }
        }
        result = (double) ((arg1)->minscale);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_maxscale_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_maxscale_set(self,maxscale);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_maxscale_set. Expected _p_webObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->maxscale = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_maxscale_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_maxscale_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_maxscale_get. Expected _p_webObj");
            }
        }
        result = (double) ((arg1)->maxscale);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_mintemplate_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_mintemplate_set(self,mintemplate);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_mintemplate_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->mintemplate) free((char*)arg1->mintemplate);
            if (arg2) {
                arg1->mintemplate = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->mintemplate,arg2);
            } else {
                arg1->mintemplate = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_mintemplate_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_mintemplate_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_mintemplate_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->mintemplate);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_maxtemplate_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_maxtemplate_set(self,maxtemplate);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_maxtemplate_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->maxtemplate) free((char*)arg1->maxtemplate);
            if (arg2) {
                arg1->maxtemplate = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->maxtemplate,arg2);
            } else {
                arg1->maxtemplate = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_maxtemplate_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_maxtemplate_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_maxtemplate_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->maxtemplate);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_queryformat_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_queryformat_set(self,queryformat);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_queryformat_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->queryformat) free((char*)arg1->queryformat);
            if (arg2) {
                arg1->queryformat = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->queryformat,arg2);
            } else {
                arg1->queryformat = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_queryformat_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_queryformat_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_queryformat_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->queryformat);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_legendformat_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_legendformat_set(self,legendformat);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_legendformat_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->legendformat) free((char*)arg1->legendformat);
            if (arg2) {
                arg1->legendformat = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->legendformat,arg2);
            } else {
                arg1->legendformat = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_legendformat_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_legendformat_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_legendformat_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->legendformat);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_browseformat_set) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: webObj_browseformat_set(self,browseformat);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_browseformat_set. Expected _p_webObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->browseformat) free((char*)arg1->browseformat);
            if (arg2) {
                arg1->browseformat = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->browseformat,arg2);
            } else {
                arg1->browseformat = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_browseformat_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_browseformat_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_browseformat_get. Expected _p_webObj");
            }
        }
        result = (char *) ((arg1)->browseformat);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_webObj_metadata_get) {
    {
        webObj *arg1 = (webObj *) 0 ;
        hashTableObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: webObj_metadata_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of webObj_metadata_get. Expected _p_webObj");
            }
        }
        result = (hashTableObj *)& ((arg1)->metadata);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_hashTableObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_webObj) {
    {
        webObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_webObj();");
        }
        result = (webObj *)new_webObj();
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_webObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_webObj) {
    {
        webObj *arg1 = (webObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_webObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_webObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_webObj. Expected _p_webObj");
            }
        }
        delete_webObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_color_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_color_set(self,color);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_color_set. Expected _p_styleObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of styleObj_color_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->color = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_color_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_color_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_color_get. Expected _p_styleObj");
            }
        }
        result = (colorObj *)& ((arg1)->color);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_backgroundcolor_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_backgroundcolor_set(self,backgroundcolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_backgroundcolor_set. Expected _p_styleObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of styleObj_backgroundcolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->backgroundcolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_backgroundcolor_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_backgroundcolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_backgroundcolor_get. Expected _p_styleObj");
            }
        }
        result = (colorObj *)& ((arg1)->backgroundcolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_outlinecolor_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_outlinecolor_set(self,outlinecolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_outlinecolor_set. Expected _p_styleObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of styleObj_outlinecolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->outlinecolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_outlinecolor_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_outlinecolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_outlinecolor_get. Expected _p_styleObj");
            }
        }
        result = (colorObj *)& ((arg1)->outlinecolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_mincolor_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_mincolor_set(self,mincolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_mincolor_set. Expected _p_styleObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of styleObj_mincolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->mincolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_mincolor_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_mincolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_mincolor_get. Expected _p_styleObj");
            }
        }
        result = (colorObj *)& ((arg1)->mincolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_maxcolor_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_maxcolor_set(self,maxcolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_maxcolor_set. Expected _p_styleObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of styleObj_maxcolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->maxcolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_maxcolor_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_maxcolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_maxcolor_get. Expected _p_styleObj");
            }
        }
        result = (colorObj *)& ((arg1)->maxcolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_minvalue_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_minvalue_set(self,minvalue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_minvalue_set. Expected _p_styleObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->minvalue = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_minvalue_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_minvalue_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_minvalue_get. Expected _p_styleObj");
            }
        }
        result = (double) ((arg1)->minvalue);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_maxvalue_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_maxvalue_set(self,maxvalue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_maxvalue_set. Expected _p_styleObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->maxvalue = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_maxvalue_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_maxvalue_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_maxvalue_get. Expected _p_styleObj");
            }
        }
        result = (double) ((arg1)->maxvalue);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_rangeitem_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_rangeitem_set(self,rangeitem);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_rangeitem_set. Expected _p_styleObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->rangeitem) free((char*)arg1->rangeitem);
            if (arg2) {
                arg1->rangeitem = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->rangeitem,arg2);
            } else {
                arg1->rangeitem = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_rangeitem_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_rangeitem_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_rangeitem_get. Expected _p_styleObj");
            }
        }
        result = (char *) ((arg1)->rangeitem);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_rangeitemindex_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_rangeitemindex_set(self,rangeitemindex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_rangeitemindex_set. Expected _p_styleObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->rangeitemindex = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_rangeitemindex_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_rangeitemindex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_rangeitemindex_get. Expected _p_styleObj");
            }
        }
        result = (int) ((arg1)->rangeitemindex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_symbol_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_symbol_set(self,symbol);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_symbol_set. Expected _p_styleObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->symbol = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_symbol_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_symbol_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_symbol_get. Expected _p_styleObj");
            }
        }
        result = (int) ((arg1)->symbol);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_symbolname_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_symbolname_set(self,symbolname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_symbolname_set. Expected _p_styleObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->symbolname) free((char*)arg1->symbolname);
            if (arg2) {
                arg1->symbolname = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->symbolname,arg2);
            } else {
                arg1->symbolname = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_symbolname_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_symbolname_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_symbolname_get. Expected _p_styleObj");
            }
        }
        result = (char *) ((arg1)->symbolname);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_size_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_size_set(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_size_set. Expected _p_styleObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->size = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_size_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_size_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_size_get. Expected _p_styleObj");
            }
        }
        result = (int) ((arg1)->size);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_minsize_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_minsize_set(self,minsize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_minsize_set. Expected _p_styleObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->minsize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_minsize_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_minsize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_minsize_get. Expected _p_styleObj");
            }
        }
        result = (int) ((arg1)->minsize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_maxsize_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_maxsize_set(self,maxsize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_maxsize_set. Expected _p_styleObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->maxsize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_maxsize_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_maxsize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_maxsize_get. Expected _p_styleObj");
            }
        }
        result = (int) ((arg1)->maxsize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_width_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_width_set(self,width);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_width_set. Expected _p_styleObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->width = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_width_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_width_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_width_get. Expected _p_styleObj");
            }
        }
        result = (int) ((arg1)->width);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_minwidth_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_minwidth_set(self,minwidth);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_minwidth_set. Expected _p_styleObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->minwidth = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_minwidth_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_minwidth_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_minwidth_get. Expected _p_styleObj");
            }
        }
        result = (int) ((arg1)->minwidth);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_maxwidth_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_maxwidth_set(self,maxwidth);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_maxwidth_set. Expected _p_styleObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->maxwidth = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_maxwidth_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_maxwidth_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_maxwidth_get. Expected _p_styleObj");
            }
        }
        result = (int) ((arg1)->maxwidth);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_offsetx_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_offsetx_set(self,offsetx);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_offsetx_set. Expected _p_styleObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->offsetx = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_offsetx_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_offsetx_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_offsetx_get. Expected _p_styleObj");
            }
        }
        result = (int) ((arg1)->offsetx);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_offsety_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_offsety_set(self,offsety);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_offsety_set. Expected _p_styleObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->offsety = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_offsety_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_offsety_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_offsety_get. Expected _p_styleObj");
            }
        }
        result = (int) ((arg1)->offsety);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_angle_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_angle_set(self,angle);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_angle_set. Expected _p_styleObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->angle = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_angle_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_angle_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_angle_get. Expected _p_styleObj");
            }
        }
        result = (double) ((arg1)->angle);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_antialias_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_antialias_set(self,antialias);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_antialias_set. Expected _p_styleObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->antialias = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_antialias_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_antialias_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_antialias_get. Expected _p_styleObj");
            }
        }
        result = (int) ((arg1)->antialias);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_angleitem_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_angleitem_set(self,angleitem);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_angleitem_set. Expected _p_styleObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->angleitem) free((char*)arg1->angleitem);
            if (arg2) {
                arg1->angleitem = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->angleitem,arg2);
            } else {
                arg1->angleitem = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_angleitem_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_angleitem_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_angleitem_get. Expected _p_styleObj");
            }
        }
        result = (char *) ((arg1)->angleitem);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_sizeitem_set) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: styleObj_sizeitem_set(self,sizeitem);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_sizeitem_set. Expected _p_styleObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->sizeitem) free((char*)arg1->sizeitem);
            if (arg2) {
                arg1->sizeitem = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->sizeitem,arg2);
            } else {
                arg1->sizeitem = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_sizeitem_get) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_sizeitem_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_sizeitem_get. Expected _p_styleObj");
            }
        }
        result = (char *) ((arg1)->sizeitem);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_styleObj) {
    {
        classObj *arg1 = (classObj *) NULL ;
        styleObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: new_styleObj(parent_class);");
        }
        if (items > 0) {
            {
                if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                    SWIG_croak("Type error in argument 1 of new_styleObj. Expected _p_classObj");
                }
            }
        }
        result = (styleObj *)new_styleObj(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_styleObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_styleObj) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_styleObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_styleObj. Expected _p_styleObj");
            }
        }
        delete_styleObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_clone) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        styleObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: styleObj_clone(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_clone. Expected _p_styleObj");
            }
        }
        result = (styleObj *)styleObj_clone(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_styleObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_styleObj_setSymbolByName) {
    {
        styleObj *arg1 = (styleObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: styleObj_setSymbolByName(self,map,symbolname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of styleObj_setSymbolByName. Expected _p_styleObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of styleObj_setSymbolByName. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)styleObj_setSymbolByName(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_status_set) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_status_set(self,status);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_status_set. Expected _p_classObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->status = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_status_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_status_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_status_get. Expected _p_classObj");
            }
        }
        result = (int) ((arg1)->status);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_numstyles_set) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_numstyles_set(self,numstyles);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_numstyles_set. Expected _p_classObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->numstyles = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_numstyles_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_numstyles_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_numstyles_get. Expected _p_classObj");
            }
        }
        result = (int) ((arg1)->numstyles);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_label_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        labelObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_label_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_label_get. Expected _p_classObj");
            }
        }
        result = (labelObj *)& ((arg1)->label);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_name_set) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_name_set(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_name_set. Expected _p_classObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->name) free((char*)arg1->name);
            if (arg2) {
                arg1->name = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->name,arg2);
            } else {
                arg1->name = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_name_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_name_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_name_get. Expected _p_classObj");
            }
        }
        result = (char *) ((arg1)->name);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_title_set) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_title_set(self,title);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_title_set. Expected _p_classObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->title) free((char*)arg1->title);
            if (arg2) {
                arg1->title = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->title,arg2);
            } else {
                arg1->title = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_title_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_title_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_title_get. Expected _p_classObj");
            }
        }
        result = (char *) ((arg1)->title);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_template_set) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_template_set(self,template);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_template_set. Expected _p_classObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->template) free((char*)arg1->template);
            if (arg2) {
                arg1->template = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->template,arg2);
            } else {
                arg1->template = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_template_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_template_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_template_get. Expected _p_classObj");
            }
        }
        result = (char *) ((arg1)->template);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_type_set) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_type_set(self,type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_type_set. Expected _p_classObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->type = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_type_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_type_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_type_get. Expected _p_classObj");
            }
        }
        result = (int) ((arg1)->type);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_metadata_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        hashTableObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_metadata_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_metadata_get. Expected _p_classObj");
            }
        }
        result = (hashTableObj *)& ((arg1)->metadata);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_hashTableObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_minscale_set) {
    {
        classObj *arg1 = (classObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_minscale_set(self,minscale);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_minscale_set. Expected _p_classObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->minscale = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_minscale_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_minscale_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_minscale_get. Expected _p_classObj");
            }
        }
        result = (double) ((arg1)->minscale);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_maxscale_set) {
    {
        classObj *arg1 = (classObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_maxscale_set(self,maxscale);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_maxscale_set. Expected _p_classObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->maxscale = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_maxscale_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_maxscale_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_maxscale_get. Expected _p_classObj");
            }
        }
        result = (double) ((arg1)->maxscale);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_layer_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        struct layer_obj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_layer_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_layer_get. Expected _p_classObj");
            }
        }
        result = (struct layer_obj *) ((arg1)->layer);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_layer_obj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_debug_set) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_debug_set(self,debug);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_debug_set. Expected _p_classObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->debug = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_debug_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_debug_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_debug_get. Expected _p_classObj");
            }
        }
        result = (int) ((arg1)->debug);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_keyimage_set) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_keyimage_set(self,keyimage);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_keyimage_set. Expected _p_classObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->keyimage) free((char*)arg1->keyimage);
            if (arg2) {
                arg1->keyimage = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->keyimage,arg2);
            } else {
                arg1->keyimage = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_keyimage_get) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_keyimage_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_keyimage_get. Expected _p_classObj");
            }
        }
        result = (char *) ((arg1)->keyimage);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_classObj) {
    {
        layerObj *arg1 = (layerObj *) NULL ;
        classObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: new_classObj(layer);");
        }
        if (items > 0) {
            {
                if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                    SWIG_croak("Type error in argument 1 of new_classObj. Expected _p_layerObj");
                }
            }
        }
        result = (classObj *)new_classObj(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_classObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_classObj) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_classObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_classObj. Expected _p_classObj");
            }
        }
        delete_classObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_clone) {
    {
        classObj *arg1 = (classObj *) 0 ;
        classObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_clone(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_clone. Expected _p_classObj");
            }
        }
        result = (classObj *)classObj_clone(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_classObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_setExpression) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_setExpression(self,expression);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_setExpression. Expected _p_classObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)classObj_setExpression(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_getExpressionString) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_getExpressionString(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_getExpressionString. Expected _p_classObj");
            }
        }
        result = (char *)classObj_getExpressionString(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_setText) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_setText(self,text);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_setText. Expected _p_classObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)classObj_setText(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_getTextString) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_getTextString(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_getTextString. Expected _p_classObj");
            }
        }
        result = (char *)classObj_getTextString(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_getMetaData) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_getMetaData(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_getMetaData. Expected _p_classObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (char *)classObj_getMetaData(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_setMetaData) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *arg2 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: classObj_setMetaData(self,name,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_setMetaData. Expected _p_classObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)classObj_setMetaData(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_getFirstMetaDataKey) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: classObj_getFirstMetaDataKey(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_getFirstMetaDataKey. Expected _p_classObj");
            }
        }
        result = (char *)classObj_getFirstMetaDataKey(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_getNextMetaDataKey) {
    {
        classObj *arg1 = (classObj *) 0 ;
        char *arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_getNextMetaDataKey(self,lastkey);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_getNextMetaDataKey. Expected _p_classObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (char *)classObj_getNextMetaDataKey(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_drawLegendIcon) {
    {
        classObj *arg1 = (classObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        layerObj *arg3 = (layerObj *) 0 ;
        int arg4 ;
        int arg5 ;
        imageObj *arg6 = (imageObj *) 0 ;
        int arg7 ;
        int arg8 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 8) || (items > 8)) {
            SWIG_croak("Usage: classObj_drawLegendIcon(self,map,layer,width,height,dstImage,dstX,dstY);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_drawLegendIcon. Expected _p_classObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of classObj_drawLegendIcon. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of classObj_drawLegendIcon. Expected _p_layerObj");
            }
        }
        arg4 = (int) SvIV(ST(3));
        arg5 = (int) SvIV(ST(4));
        {
            if (SWIG_ConvertPtr(ST(5), (void **) &arg6, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 6 of classObj_drawLegendIcon. Expected _p_imageObj");
            }
        }
        arg7 = (int) SvIV(ST(6));
        arg8 = (int) SvIV(ST(7));
        result = (int)classObj_drawLegendIcon(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_createLegendIcon) {
    {
        classObj *arg1 = (classObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        layerObj *arg3 = (layerObj *) 0 ;
        int arg4 ;
        int arg5 ;
        imageObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: classObj_createLegendIcon(self,map,layer,width,height);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_createLegendIcon. Expected _p_classObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of classObj_createLegendIcon. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of classObj_createLegendIcon. Expected _p_layerObj");
            }
        }
        arg4 = (int) SvIV(ST(3));
        arg5 = (int) SvIV(ST(4));
        result = (imageObj *)classObj_createLegendIcon(arg1,arg2,arg3,arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_imageObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_getStyle) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int arg2 ;
        styleObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_getStyle(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_getStyle. Expected _p_classObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (styleObj *)classObj_getStyle(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_styleObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_insertStyle) {
    {
        classObj *arg1 = (classObj *) 0 ;
        styleObj *arg2 = (styleObj *) 0 ;
        int arg3 = (int) -1 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: classObj_insertStyle(self,style,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_insertStyle. Expected _p_classObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_styleObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of classObj_insertStyle. Expected _p_styleObj");
            }
        }
        if (items > 2) {
            arg3 = (int) SvIV(ST(2));
        }
        result = (int)classObj_insertStyle(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_removeStyle) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int arg2 ;
        styleObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_removeStyle(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_removeStyle. Expected _p_classObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (styleObj *)classObj_removeStyle(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_styleObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_moveStyleUp) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_moveStyleUp(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_moveStyleUp. Expected _p_classObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)classObj_moveStyleUp(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_classObj_moveStyleDown) {
    {
        classObj *arg1 = (classObj *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: classObj_moveStyleDown(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of classObj_moveStyleDown. Expected _p_classObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)classObj_moveStyleDown(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_text_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_text_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_text_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (char *) ((arg1)->text);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_featuresize_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_featuresize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_featuresize_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (double) ((arg1)->featuresize);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_styles_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        styleObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_styles_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_styles_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (styleObj *) ((arg1)->styles);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_styleObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_numstyles_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_numstyles_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_numstyles_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (int) ((arg1)->numstyles);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_label_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        labelObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_label_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_label_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (labelObj *)& ((arg1)->label);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_layerindex_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_layerindex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_layerindex_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (int) ((arg1)->layerindex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_classindex_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_classindex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_classindex_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (int) ((arg1)->classindex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_tileindex_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_tileindex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_tileindex_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (int) ((arg1)->tileindex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_shapeindex_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_shapeindex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_shapeindex_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (int) ((arg1)->shapeindex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_point_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        pointObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_point_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_point_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (pointObj *)& ((arg1)->point);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_pointObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_poly_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_poly_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_poly_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (shapeObj *) ((arg1)->poly);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_status_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_status_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_status_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (int) ((arg1)->status);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheMemberObj_labelpath_get) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        labelPathObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheMemberObj_labelpath_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheMemberObj_labelpath_get. Expected _p_labelCacheMemberObj");
            }
        }
        result = (labelPathObj *) ((arg1)->labelpath);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelPathObj, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_labelCacheMemberObj) {
    {
        labelCacheMemberObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_labelCacheMemberObj();");
        }
        result = (labelCacheMemberObj *)(labelCacheMemberObj *) calloc(1, sizeof(labelCacheMemberObj));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelCacheMemberObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_labelCacheMemberObj) {
    {
        labelCacheMemberObj *arg1 = (labelCacheMemberObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_labelCacheMemberObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_labelCacheMemberObj. Expected _p_labelCacheMemberObj");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_markerCacheMemberObj_id_get) {
    {
        markerCacheMemberObj *arg1 = (markerCacheMemberObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: markerCacheMemberObj_id_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_markerCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of markerCacheMemberObj_id_get. Expected _p_markerCacheMemberObj");
            }
        }
        result = (int) ((arg1)->id);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_markerCacheMemberObj_poly_get) {
    {
        markerCacheMemberObj *arg1 = (markerCacheMemberObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: markerCacheMemberObj_poly_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_markerCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of markerCacheMemberObj_poly_get. Expected _p_markerCacheMemberObj");
            }
        }
        result = (shapeObj *) ((arg1)->poly);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_markerCacheMemberObj) {
    {
        markerCacheMemberObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_markerCacheMemberObj();");
        }
        result = (markerCacheMemberObj *)(markerCacheMemberObj *) calloc(1, sizeof(markerCacheMemberObj));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_markerCacheMemberObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_markerCacheMemberObj) {
    {
        markerCacheMemberObj *arg1 = (markerCacheMemberObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_markerCacheMemberObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_markerCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_markerCacheMemberObj. Expected _p_markerCacheMemberObj");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheObj_labels_get) {
    {
        labelCacheObj *arg1 = (labelCacheObj *) 0 ;
        labelCacheMemberObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheObj_labels_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheObj_labels_get. Expected _p_labelCacheObj");
            }
        }
        result = (labelCacheMemberObj *) ((arg1)->labels);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelCacheMemberObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheObj_numlabels_get) {
    {
        labelCacheObj *arg1 = (labelCacheObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheObj_numlabels_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheObj_numlabels_get. Expected _p_labelCacheObj");
            }
        }
        result = (int) ((arg1)->numlabels);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheObj_cachesize_get) {
    {
        labelCacheObj *arg1 = (labelCacheObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheObj_cachesize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheObj_cachesize_get. Expected _p_labelCacheObj");
            }
        }
        result = (int) ((arg1)->cachesize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheObj_markers_get) {
    {
        labelCacheObj *arg1 = (labelCacheObj *) 0 ;
        markerCacheMemberObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheObj_markers_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheObj_markers_get. Expected _p_labelCacheObj");
            }
        }
        result = (markerCacheMemberObj *) ((arg1)->markers);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_markerCacheMemberObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheObj_nummarkers_get) {
    {
        labelCacheObj *arg1 = (labelCacheObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheObj_nummarkers_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheObj_nummarkers_get. Expected _p_labelCacheObj");
            }
        }
        result = (int) ((arg1)->nummarkers);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheObj_markercachesize_get) {
    {
        labelCacheObj *arg1 = (labelCacheObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheObj_markercachesize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheObj_markercachesize_get. Expected _p_labelCacheObj");
            }
        }
        result = (int) ((arg1)->markercachesize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_labelCacheObj_freeCache) {
    {
        labelCacheObj *arg1 = (labelCacheObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: labelCacheObj_freeCache(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of labelCacheObj_freeCache. Expected _p_labelCacheObj");
            }
        }
        labelCacheObj_freeCache(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_labelCacheObj) {
    {
        labelCacheObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_labelCacheObj();");
        }
        result = (labelCacheObj *)(labelCacheObj *) calloc(1, sizeof(labelCacheObj));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelCacheObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_labelCacheObj) {
    {
        labelCacheObj *arg1 = (labelCacheObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_labelCacheObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_labelCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_labelCacheObj. Expected _p_labelCacheObj");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_resultCacheMemberObj_shapeindex_get) {
    {
        resultCacheMemberObj *arg1 = (resultCacheMemberObj *) 0 ;
        long result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: resultCacheMemberObj_shapeindex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_resultCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of resultCacheMemberObj_shapeindex_get. Expected _p_resultCacheMemberObj");
            }
        }
        result = (long) ((arg1)->shapeindex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_resultCacheMemberObj_tileindex_get) {
    {
        resultCacheMemberObj *arg1 = (resultCacheMemberObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: resultCacheMemberObj_tileindex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_resultCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of resultCacheMemberObj_tileindex_get. Expected _p_resultCacheMemberObj");
            }
        }
        result = (int) ((arg1)->tileindex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_resultCacheMemberObj_classindex_get) {
    {
        resultCacheMemberObj *arg1 = (resultCacheMemberObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: resultCacheMemberObj_classindex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_resultCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of resultCacheMemberObj_classindex_get. Expected _p_resultCacheMemberObj");
            }
        }
        result = (int) ((arg1)->classindex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_resultCacheMemberObj) {
    {
        resultCacheMemberObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_resultCacheMemberObj();");
        }
        result = (resultCacheMemberObj *)(resultCacheMemberObj *) calloc(1, sizeof(resultCacheMemberObj));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_resultCacheMemberObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_resultCacheMemberObj) {
    {
        resultCacheMemberObj *arg1 = (resultCacheMemberObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_resultCacheMemberObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_resultCacheMemberObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_resultCacheMemberObj. Expected _p_resultCacheMemberObj");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_resultCacheObj_numresults_get) {
    {
        resultCacheObj *arg1 = (resultCacheObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: resultCacheObj_numresults_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_resultCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of resultCacheObj_numresults_get. Expected _p_resultCacheObj");
            }
        }
        result = (int) ((arg1)->numresults);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_resultCacheObj_bounds_get) {
    {
        resultCacheObj *arg1 = (resultCacheObj *) 0 ;
        rectObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: resultCacheObj_bounds_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_resultCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of resultCacheObj_bounds_get. Expected _p_resultCacheObj");
            }
        }
        result = (rectObj *)& ((arg1)->bounds);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_rectObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_resultCacheObj_getResult) {
    {
        resultCacheObj *arg1 = (resultCacheObj *) 0 ;
        int arg2 ;
        resultCacheMemberObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: resultCacheObj_getResult(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_resultCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of resultCacheObj_getResult. Expected _p_resultCacheObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (resultCacheMemberObj *)resultCacheObj_getResult(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_resultCacheMemberObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_resultCacheObj) {
    {
        resultCacheObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_resultCacheObj();");
        }
        result = (resultCacheObj *)(resultCacheObj *) calloc(1, sizeof(resultCacheObj));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_resultCacheObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_resultCacheObj) {
    {
        resultCacheObj *arg1 = (resultCacheObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_resultCacheObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_resultCacheObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_resultCacheObj. Expected _p_resultCacheObj");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_filename_set) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolSetObj_filename_set(self,filename);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_filename_set. Expected _p_symbolSetObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->filename) free((char*)arg1->filename);
            if (arg2) {
                arg1->filename = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->filename,arg2);
            } else {
                arg1->filename = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_filename_get) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolSetObj_filename_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_filename_get. Expected _p_symbolSetObj");
            }
        }
        result = (char *) ((arg1)->filename);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_imagecachesize_set) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolSetObj_imagecachesize_set(self,imagecachesize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_imagecachesize_set. Expected _p_symbolSetObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->imagecachesize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_imagecachesize_get) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolSetObj_imagecachesize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_imagecachesize_get. Expected _p_symbolSetObj");
            }
        }
        result = (int) ((arg1)->imagecachesize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_numsymbols_get) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolSetObj_numsymbols_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_numsymbols_get. Expected _p_symbolSetObj");
            }
        }
        result = (int) ((arg1)->numsymbols);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_symbol_set) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        symbolObj *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolSetObj_symbol_set(self,symbol);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_symbol_set. Expected _p_symbolSetObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of symbolSetObj_symbol_set. Expected _p_symbolObj");
            }
        }
        {
            int ii;
            symbolObj *b = (symbolObj *) arg1->symbol;
            for (ii = 0; ii < MS_MAXSYMBOLS; ii++) b[ii] = *((symbolObj *) arg2 + ii);
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_symbol_get) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        symbolObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolSetObj_symbol_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_symbol_get. Expected _p_symbolSetObj");
            }
        }
        result = (symbolObj *)(symbolObj *) ((arg1)->symbol);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_symbolObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_symbolSetObj) {
    {
        char *arg1 = (char *) NULL ;
        symbolSetObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: new_symbolSetObj(symbolfile);");
        }
        if (items > 0) {
            if (!SvOK((SV*) ST(0))) arg1 = 0;
            else arg1 = (char *) SvPV(ST(0), PL_na);
        }
        result = (symbolSetObj *)new_symbolSetObj((char const *)arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_symbolSetObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_symbolSetObj) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_symbolSetObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_symbolSetObj. Expected _p_symbolSetObj");
            }
        }
        delete_symbolSetObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_getSymbol) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        int arg2 ;
        symbolObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolSetObj_getSymbol(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_getSymbol. Expected _p_symbolSetObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (symbolObj *)symbolSetObj_getSymbol(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_symbolObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_getSymbolByName) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        char *arg2 ;
        symbolObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolSetObj_getSymbolByName(self,symbolname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_getSymbolByName. Expected _p_symbolSetObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (symbolObj *)symbolSetObj_getSymbolByName(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_symbolObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_index) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolSetObj_index(self,symbolname);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_index. Expected _p_symbolSetObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)symbolSetObj_index(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_appendSymbol) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        symbolObj *arg2 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolSetObj_appendSymbol(self,symbol);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_appendSymbol. Expected _p_symbolSetObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of symbolSetObj_appendSymbol. Expected _p_symbolObj");
            }
        }
        result = (int)symbolSetObj_appendSymbol(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_removeSymbol) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        int arg2 ;
        symbolObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolSetObj_removeSymbol(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_removeSymbol. Expected _p_symbolSetObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (symbolObj *)symbolSetObj_removeSymbol(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_symbolObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolSetObj_save) {
    {
        symbolSetObj *arg1 = (symbolSetObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolSetObj_save(self,filename);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolSetObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolSetObj_save. Expected _p_symbolSetObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)symbolSetObj_save(arg1,(char const *)arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_extent_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        rectObj *arg2 = (rectObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_extent_set(self,extent);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_extent_set. Expected _p_referenceMapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of referenceMapObj_extent_set. Expected _p_rectObj");
            }
        }
        if (arg1) (arg1)->extent = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_extent_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        rectObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_extent_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_extent_get. Expected _p_referenceMapObj");
            }
        }
        result = (rectObj *)& ((arg1)->extent);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_rectObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_height_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_height_set(self,height);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_height_set. Expected _p_referenceMapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->height = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_height_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_height_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_height_get. Expected _p_referenceMapObj");
            }
        }
        result = (int) ((arg1)->height);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_width_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_width_set(self,width);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_width_set. Expected _p_referenceMapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->width = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_width_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_width_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_width_get. Expected _p_referenceMapObj");
            }
        }
        result = (int) ((arg1)->width);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_color_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_color_set(self,color);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_color_set. Expected _p_referenceMapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of referenceMapObj_color_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->color = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_color_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_color_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_color_get. Expected _p_referenceMapObj");
            }
        }
        result = (colorObj *)& ((arg1)->color);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_outlinecolor_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_outlinecolor_set(self,outlinecolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_outlinecolor_set. Expected _p_referenceMapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of referenceMapObj_outlinecolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->outlinecolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_outlinecolor_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_outlinecolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_outlinecolor_get. Expected _p_referenceMapObj");
            }
        }
        result = (colorObj *)& ((arg1)->outlinecolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_image_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_image_set(self,image);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_image_set. Expected _p_referenceMapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->image) free((char*)arg1->image);
            if (arg2) {
                arg1->image = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->image,arg2);
            } else {
                arg1->image = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_image_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_image_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_image_get. Expected _p_referenceMapObj");
            }
        }
        result = (char *) ((arg1)->image);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_status_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_status_set(self,status);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_status_set. Expected _p_referenceMapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->status = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_status_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_status_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_status_get. Expected _p_referenceMapObj");
            }
        }
        result = (int) ((arg1)->status);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_marker_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_marker_set(self,marker);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_marker_set. Expected _p_referenceMapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->marker = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_marker_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_marker_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_marker_get. Expected _p_referenceMapObj");
            }
        }
        result = (int) ((arg1)->marker);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_markername_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_markername_set(self,markername);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_markername_set. Expected _p_referenceMapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->markername) free((char*)arg1->markername);
            if (arg2) {
                arg1->markername = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->markername,arg2);
            } else {
                arg1->markername = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_markername_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_markername_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_markername_get. Expected _p_referenceMapObj");
            }
        }
        result = (char *) ((arg1)->markername);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_markersize_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_markersize_set(self,markersize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_markersize_set. Expected _p_referenceMapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->markersize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_markersize_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_markersize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_markersize_get. Expected _p_referenceMapObj");
            }
        }
        result = (int) ((arg1)->markersize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_minboxsize_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_minboxsize_set(self,minboxsize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_minboxsize_set. Expected _p_referenceMapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->minboxsize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_minboxsize_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_minboxsize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_minboxsize_get. Expected _p_referenceMapObj");
            }
        }
        result = (int) ((arg1)->minboxsize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_maxboxsize_set) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: referenceMapObj_maxboxsize_set(self,maxboxsize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_maxboxsize_set. Expected _p_referenceMapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->maxboxsize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_maxboxsize_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_maxboxsize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_maxboxsize_get. Expected _p_referenceMapObj");
            }
        }
        result = (int) ((arg1)->maxboxsize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_referenceMapObj_map_get) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        struct map_obj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: referenceMapObj_map_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of referenceMapObj_map_get. Expected _p_referenceMapObj");
            }
        }
        result = (struct map_obj *) ((arg1)->map);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_map_obj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_referenceMapObj) {
    {
        referenceMapObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_referenceMapObj();");
        }
        result = (referenceMapObj *)(referenceMapObj *) calloc(1, sizeof(referenceMapObj));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_referenceMapObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_referenceMapObj) {
    {
        referenceMapObj *arg1 = (referenceMapObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_referenceMapObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_referenceMapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_referenceMapObj. Expected _p_referenceMapObj");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_imagecolor_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_imagecolor_set(self,imagecolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_imagecolor_set. Expected _p_scalebarObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of scalebarObj_imagecolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->imagecolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_imagecolor_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_imagecolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_imagecolor_get. Expected _p_scalebarObj");
            }
        }
        result = (colorObj *)& ((arg1)->imagecolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_height_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_height_set(self,height);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_height_set. Expected _p_scalebarObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->height = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_height_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_height_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_height_get. Expected _p_scalebarObj");
            }
        }
        result = (int) ((arg1)->height);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_width_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_width_set(self,width);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_width_set. Expected _p_scalebarObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->width = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_width_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_width_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_width_get. Expected _p_scalebarObj");
            }
        }
        result = (int) ((arg1)->width);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_style_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_style_set(self,style);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_style_set. Expected _p_scalebarObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->style = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_style_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_style_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_style_get. Expected _p_scalebarObj");
            }
        }
        result = (int) ((arg1)->style);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_intervals_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_intervals_set(self,intervals);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_intervals_set. Expected _p_scalebarObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->intervals = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_intervals_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_intervals_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_intervals_get. Expected _p_scalebarObj");
            }
        }
        result = (int) ((arg1)->intervals);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_label_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        labelObj *arg2 = (labelObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_label_set(self,label);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_label_set. Expected _p_scalebarObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_labelObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of scalebarObj_label_set. Expected _p_labelObj");
            }
        }
        if (arg1) (arg1)->label = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_label_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        labelObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_label_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_label_get. Expected _p_scalebarObj");
            }
        }
        result = (labelObj *)& ((arg1)->label);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_color_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_color_set(self,color);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_color_set. Expected _p_scalebarObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of scalebarObj_color_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->color = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_color_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_color_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_color_get. Expected _p_scalebarObj");
            }
        }
        result = (colorObj *)& ((arg1)->color);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_backgroundcolor_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_backgroundcolor_set(self,backgroundcolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_backgroundcolor_set. Expected _p_scalebarObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of scalebarObj_backgroundcolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->backgroundcolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_backgroundcolor_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_backgroundcolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_backgroundcolor_get. Expected _p_scalebarObj");
            }
        }
        result = (colorObj *)& ((arg1)->backgroundcolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_outlinecolor_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_outlinecolor_set(self,outlinecolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_outlinecolor_set. Expected _p_scalebarObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of scalebarObj_outlinecolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->outlinecolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_outlinecolor_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_outlinecolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_outlinecolor_get. Expected _p_scalebarObj");
            }
        }
        result = (colorObj *)& ((arg1)->outlinecolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_units_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_units_set(self,units);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_units_set. Expected _p_scalebarObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->units = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_units_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_units_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_units_get. Expected _p_scalebarObj");
            }
        }
        result = (int) ((arg1)->units);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_status_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_status_set(self,status);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_status_set. Expected _p_scalebarObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->status = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_status_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_status_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_status_get. Expected _p_scalebarObj");
            }
        }
        result = (int) ((arg1)->status);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_position_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_position_set(self,position);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_position_set. Expected _p_scalebarObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->position = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_position_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_position_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_position_get. Expected _p_scalebarObj");
            }
        }
        result = (int) ((arg1)->position);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_postlabelcache_set) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: scalebarObj_postlabelcache_set(self,postlabelcache);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_postlabelcache_set. Expected _p_scalebarObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->postlabelcache = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_scalebarObj_postlabelcache_get) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: scalebarObj_postlabelcache_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of scalebarObj_postlabelcache_get. Expected _p_scalebarObj");
            }
        }
        result = (int) ((arg1)->postlabelcache);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_scalebarObj) {
    {
        scalebarObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_scalebarObj();");
        }
        result = (scalebarObj *)(scalebarObj *) calloc(1, sizeof(scalebarObj));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_scalebarObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_scalebarObj) {
    {
        scalebarObj *arg1 = (scalebarObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_scalebarObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_scalebarObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_scalebarObj. Expected _p_scalebarObj");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_imagecolor_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_imagecolor_set(self,imagecolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_imagecolor_set. Expected _p_legendObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of legendObj_imagecolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->imagecolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_imagecolor_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_imagecolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_imagecolor_get. Expected _p_legendObj");
            }
        }
        result = (colorObj *)& ((arg1)->imagecolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_label_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        labelObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_label_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_label_get. Expected _p_legendObj");
            }
        }
        result = (labelObj *)& ((arg1)->label);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_keysizex_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_keysizex_set(self,keysizex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_keysizex_set. Expected _p_legendObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->keysizex = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_keysizex_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_keysizex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_keysizex_get. Expected _p_legendObj");
            }
        }
        result = (int) ((arg1)->keysizex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_keysizey_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_keysizey_set(self,keysizey);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_keysizey_set. Expected _p_legendObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->keysizey = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_keysizey_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_keysizey_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_keysizey_get. Expected _p_legendObj");
            }
        }
        result = (int) ((arg1)->keysizey);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_keyspacingx_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_keyspacingx_set(self,keyspacingx);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_keyspacingx_set. Expected _p_legendObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->keyspacingx = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_keyspacingx_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_keyspacingx_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_keyspacingx_get. Expected _p_legendObj");
            }
        }
        result = (int) ((arg1)->keyspacingx);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_keyspacingy_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_keyspacingy_set(self,keyspacingy);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_keyspacingy_set. Expected _p_legendObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->keyspacingy = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_keyspacingy_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_keyspacingy_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_keyspacingy_get. Expected _p_legendObj");
            }
        }
        result = (int) ((arg1)->keyspacingy);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_outlinecolor_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_outlinecolor_set(self,outlinecolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_outlinecolor_set. Expected _p_legendObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of legendObj_outlinecolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->outlinecolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_outlinecolor_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_outlinecolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_outlinecolor_get. Expected _p_legendObj");
            }
        }
        result = (colorObj *)& ((arg1)->outlinecolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_status_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_status_set(self,status);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_status_set. Expected _p_legendObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->status = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_status_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_status_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_status_get. Expected _p_legendObj");
            }
        }
        result = (int) ((arg1)->status);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_height_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_height_set(self,height);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_height_set. Expected _p_legendObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->height = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_height_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_height_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_height_get. Expected _p_legendObj");
            }
        }
        result = (int) ((arg1)->height);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_width_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_width_set(self,width);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_width_set. Expected _p_legendObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->width = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_width_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_width_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_width_get. Expected _p_legendObj");
            }
        }
        result = (int) ((arg1)->width);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_position_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_position_set(self,position);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_position_set. Expected _p_legendObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->position = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_position_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_position_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_position_get. Expected _p_legendObj");
            }
        }
        result = (int) ((arg1)->position);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_postlabelcache_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_postlabelcache_set(self,postlabelcache);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_postlabelcache_set. Expected _p_legendObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->postlabelcache = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_postlabelcache_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_postlabelcache_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_postlabelcache_get. Expected _p_legendObj");
            }
        }
        result = (int) ((arg1)->postlabelcache);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_template_set) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: legendObj_template_set(self,template);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_template_set. Expected _p_legendObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->template) free((char*)arg1->template);
            if (arg2) {
                arg1->template = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->template,arg2);
            } else {
                arg1->template = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_template_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_template_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_template_get. Expected _p_legendObj");
            }
        }
        result = (char *) ((arg1)->template);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_legendObj_map_get) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        struct map_obj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: legendObj_map_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of legendObj_map_get. Expected _p_legendObj");
            }
        }
        result = (struct map_obj *) ((arg1)->map);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_map_obj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_legendObj) {
    {
        legendObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_legendObj();");
        }
        result = (legendObj *)(legendObj *) calloc(1, sizeof(legendObj));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_legendObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_legendObj) {
    {
        legendObj *arg1 = (legendObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_legendObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_legendObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_legendObj. Expected _p_legendObj");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_classitem_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_classitem_set(self,classitem);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_classitem_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->classitem) free((char*)arg1->classitem);
            if (arg2) {
                arg1->classitem = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->classitem,arg2);
            } else {
                arg1->classitem = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_classitem_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_classitem_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_classitem_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->classitem);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_numclasses_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_numclasses_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_numclasses_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->numclasses);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_index_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_index_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_index_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->index);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_map_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        struct map_obj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_map_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_map_get. Expected _p_layerObj");
            }
        }
        result = (struct map_obj *) ((arg1)->map);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_map_obj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_header_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_header_set(self,header);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_header_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->header) free((char*)arg1->header);
            if (arg2) {
                arg1->header = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->header,arg2);
            } else {
                arg1->header = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_header_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_header_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_header_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->header);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_footer_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_footer_set(self,footer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_footer_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->footer) free((char*)arg1->footer);
            if (arg2) {
                arg1->footer = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->footer,arg2);
            } else {
                arg1->footer = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_footer_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_footer_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_footer_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->footer);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_template_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_template_set(self,template);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_template_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->template) free((char*)arg1->template);
            if (arg2) {
                arg1->template = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->template,arg2);
            } else {
                arg1->template = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_template_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_template_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_template_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->template);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_name_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_name_set(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_name_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->name) free((char*)arg1->name);
            if (arg2) {
                arg1->name = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->name,arg2);
            } else {
                arg1->name = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_name_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_name_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_name_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->name);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_group_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_group_set(self,group);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_group_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->group) free((char*)arg1->group);
            if (arg2) {
                arg1->group = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->group,arg2);
            } else {
                arg1->group = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_group_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_group_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_group_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->group);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_status_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_status_set(self,status);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_status_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->status = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_status_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_status_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_status_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->status);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_data_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_data_set(self,data);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_data_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->data) free((char*)arg1->data);
            if (arg2) {
                arg1->data = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->data,arg2);
            } else {
                arg1->data = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_data_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_data_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_data_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->data);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_type_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_type_set(self,type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_type_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->type = (enum MS_LAYER_TYPE)arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_type_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_type_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_type_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->type);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_tolerance_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_tolerance_set(self,tolerance);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_tolerance_set. Expected _p_layerObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->tolerance = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_tolerance_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_tolerance_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_tolerance_get. Expected _p_layerObj");
            }
        }
        result = (double) ((arg1)->tolerance);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_toleranceunits_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_toleranceunits_set(self,toleranceunits);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_toleranceunits_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->toleranceunits = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_toleranceunits_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_toleranceunits_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_toleranceunits_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->toleranceunits);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_symbolscale_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_symbolscale_set(self,symbolscale);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_symbolscale_set. Expected _p_layerObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->symbolscale = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_symbolscale_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_symbolscale_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_symbolscale_get. Expected _p_layerObj");
            }
        }
        result = (double) ((arg1)->symbolscale);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_minscale_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_minscale_set(self,minscale);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_minscale_set. Expected _p_layerObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->minscale = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_minscale_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_minscale_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_minscale_get. Expected _p_layerObj");
            }
        }
        result = (double) ((arg1)->minscale);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_maxscale_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_maxscale_set(self,maxscale);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_maxscale_set. Expected _p_layerObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->maxscale = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_maxscale_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_maxscale_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_maxscale_get. Expected _p_layerObj");
            }
        }
        result = (double) ((arg1)->maxscale);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelminscale_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_labelminscale_set(self,labelminscale);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelminscale_set. Expected _p_layerObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->labelminscale = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelminscale_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_labelminscale_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelminscale_get. Expected _p_layerObj");
            }
        }
        result = (double) ((arg1)->labelminscale);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelmaxscale_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_labelmaxscale_set(self,labelmaxscale);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelmaxscale_set. Expected _p_layerObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->labelmaxscale = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelmaxscale_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_labelmaxscale_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelmaxscale_get. Expected _p_layerObj");
            }
        }
        result = (double) ((arg1)->labelmaxscale);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_sizeunits_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_sizeunits_set(self,sizeunits);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_sizeunits_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->sizeunits = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_sizeunits_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_sizeunits_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_sizeunits_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->sizeunits);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_maxfeatures_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_maxfeatures_set(self,maxfeatures);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_maxfeatures_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->maxfeatures = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_maxfeatures_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_maxfeatures_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_maxfeatures_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->maxfeatures);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_offsite_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_offsite_set(self,offsite);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_offsite_set. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_offsite_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->offsite = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_offsite_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_offsite_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_offsite_get. Expected _p_layerObj");
            }
        }
        result = (colorObj *)& ((arg1)->offsite);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_transform_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_transform_set(self,transform);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_transform_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->transform = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_transform_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_transform_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_transform_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->transform);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelcache_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_labelcache_set(self,labelcache);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelcache_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->labelcache = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelcache_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_labelcache_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelcache_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->labelcache);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_postlabelcache_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_postlabelcache_set(self,postlabelcache);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_postlabelcache_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->postlabelcache = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_postlabelcache_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_postlabelcache_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_postlabelcache_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->postlabelcache);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelitem_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_labelitem_set(self,labelitem);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelitem_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->labelitem) free((char*)arg1->labelitem);
            if (arg2) {
                arg1->labelitem = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->labelitem,arg2);
            } else {
                arg1->labelitem = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelitem_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_labelitem_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelitem_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->labelitem);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelsizeitem_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_labelsizeitem_set(self,labelsizeitem);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelsizeitem_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->labelsizeitem) free((char*)arg1->labelsizeitem);
            if (arg2) {
                arg1->labelsizeitem = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->labelsizeitem,arg2);
            } else {
                arg1->labelsizeitem = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelsizeitem_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_labelsizeitem_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelsizeitem_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->labelsizeitem);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelangleitem_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_labelangleitem_set(self,labelangleitem);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelangleitem_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->labelangleitem) free((char*)arg1->labelangleitem);
            if (arg2) {
                arg1->labelangleitem = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->labelangleitem,arg2);
            } else {
                arg1->labelangleitem = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelangleitem_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_labelangleitem_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelangleitem_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->labelangleitem);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_tileitem_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_tileitem_set(self,tileitem);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_tileitem_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->tileitem) free((char*)arg1->tileitem);
            if (arg2) {
                arg1->tileitem = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->tileitem,arg2);
            } else {
                arg1->tileitem = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_tileitem_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_tileitem_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_tileitem_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->tileitem);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_tileindex_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_tileindex_set(self,tileindex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_tileindex_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->tileindex) free((char*)arg1->tileindex);
            if (arg2) {
                arg1->tileindex = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->tileindex,arg2);
            } else {
                arg1->tileindex = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_tileindex_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_tileindex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_tileindex_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->tileindex);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_units_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_units_set(self,units);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_units_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->units = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_units_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_units_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_units_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->units);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_connection_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_connection_set(self,connection);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_connection_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->connection) free((char*)arg1->connection);
            if (arg2) {
                arg1->connection = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->connection,arg2);
            } else {
                arg1->connection = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_connection_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_connection_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_connection_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->connection);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_plugin_library_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_plugin_library_set(self,plugin_library);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_plugin_library_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->plugin_library) free((char*)arg1->plugin_library);
            if (arg2) {
                arg1->plugin_library = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->plugin_library,arg2);
            } else {
                arg1->plugin_library = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_plugin_library_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_plugin_library_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_plugin_library_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->plugin_library);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_plugin_library_original_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_plugin_library_original_set(self,plugin_library_original);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_plugin_library_original_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->plugin_library_original) free((char*)arg1->plugin_library_original);
            if (arg2) {
                arg1->plugin_library_original = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->plugin_library_original,arg2);
            } else {
                arg1->plugin_library_original = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_plugin_library_original_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_plugin_library_original_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_plugin_library_original_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->plugin_library_original);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_connectiontype_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_connectiontype_set(self,connectiontype);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_connectiontype_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->connectiontype = (enum MS_CONNECTION_TYPE)arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_connectiontype_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_connectiontype_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_connectiontype_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->connectiontype);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_numitems_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_numitems_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_numitems_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->numitems);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_bandsitem_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_bandsitem_set(self,bandsitem);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_bandsitem_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->bandsitem) free((char*)arg1->bandsitem);
            if (arg2) {
                arg1->bandsitem = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->bandsitem,arg2);
            } else {
                arg1->bandsitem = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_bandsitem_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_bandsitem_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_bandsitem_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->bandsitem);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_filteritem_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_filteritem_set(self,filteritem);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_filteritem_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->filteritem) free((char*)arg1->filteritem);
            if (arg2) {
                arg1->filteritem = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->filteritem,arg2);
            } else {
                arg1->filteritem = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_filteritem_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_filteritem_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_filteritem_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->filteritem);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_styleitem_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_styleitem_set(self,styleitem);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_styleitem_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->styleitem) free((char*)arg1->styleitem);
            if (arg2) {
                arg1->styleitem = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->styleitem,arg2);
            } else {
                arg1->styleitem = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_styleitem_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_styleitem_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_styleitem_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->styleitem);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_requires_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_requires_set(self,requires);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_requires_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->requires) free((char*)arg1->requires);
            if (arg2) {
                arg1->requires = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->requires,arg2);
            } else {
                arg1->requires = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_requires_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_requires_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_requires_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->requires);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelrequires_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_labelrequires_set(self,labelrequires);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelrequires_set. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->labelrequires) free((char*)arg1->labelrequires);
            if (arg2) {
                arg1->labelrequires = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->labelrequires,arg2);
            } else {
                arg1->labelrequires = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_labelrequires_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_labelrequires_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_labelrequires_get. Expected _p_layerObj");
            }
        }
        result = (char *) ((arg1)->labelrequires);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_metadata_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        hashTableObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_metadata_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_metadata_get. Expected _p_layerObj");
            }
        }
        result = (hashTableObj *)& ((arg1)->metadata);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_hashTableObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_transparency_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_transparency_set(self,transparency);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_transparency_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->transparency = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_transparency_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_transparency_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_transparency_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->transparency);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_dump_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_dump_set(self,dump);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_dump_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->dump = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_dump_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_dump_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_dump_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->dump);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_debug_set) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_debug_set(self,debug);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_debug_set. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->debug = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_debug_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_debug_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_debug_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->debug);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_extent_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        rectObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_extent_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_extent_get. Expected _p_layerObj");
            }
        }
        result = (rectObj *)& ((arg1)->extent);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_rectObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_numprocessing_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_numprocessing_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_numprocessing_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->numprocessing);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_numjoins_get) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_numjoins_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_numjoins_get. Expected _p_layerObj");
            }
        }
        result = (int) ((arg1)->numjoins);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_layerObj) {
    {
        mapObj *arg1 = (mapObj *) NULL ;
        layerObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: new_layerObj(map);");
        }
        if (items > 0) {
            {
                if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                    SWIG_croak("Type error in argument 1 of new_layerObj. Expected _p_mapObj");
                }
            }
        }
        result = (layerObj *)new_layerObj(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_layerObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_layerObj) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_layerObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_layerObj. Expected _p_layerObj");
            }
        }
        delete_layerObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_clone) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        layerObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_clone(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_clone. Expected _p_layerObj");
            }
        }
        result = (layerObj *)layerObj_clone(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_layerObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_insertClass) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        classObj *arg2 = (classObj *) 0 ;
        int arg3 = (int) -1 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: layerObj_insertClass(self,classobj,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_insertClass. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_classObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_insertClass. Expected _p_classObj");
            }
        }
        if (items > 2) {
            arg3 = (int) SvIV(ST(2));
        }
        result = (int)layerObj_insertClass(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_removeClass) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        classObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_removeClass(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_removeClass. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (classObj *)layerObj_removeClass(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_classObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_open) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_open(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_open. Expected _p_layerObj");
            }
        }
        result = (int)layerObj_open(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_whichShapes) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        rectObj arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_whichShapes(self,rect);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_whichShapes. Expected _p_layerObj");
            }
        }
        {
            rectObj * argp;
            if (SWIG_ConvertPtr(ST(1),(void **) &argp, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_whichShapes. Expected _p_rectObj");
            }
            arg2 = *argp;
        }
        result = (int)layerObj_whichShapes(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_nextShape) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_nextShape(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_nextShape. Expected _p_layerObj");
            }
        }
        result = (shapeObj *)layerObj_nextShape(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_close) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_close(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_close. Expected _p_layerObj");
            }
        }
        layerObj_close(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getFeature) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int arg3 = (int) -1 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: layerObj_getFeature(self,shapeindex,tileindex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getFeature. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (items > 2) {
            arg3 = (int) SvIV(ST(2));
        }
        result = (shapeObj *)layerObj_getFeature(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getShape) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int arg3 ;
        int arg4 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: layerObj_getShape(self,shape,tileindex,shapeindex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getShape. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_getShape. Expected _p_shapeObj");
            }
        }
        arg3 = (int) SvIV(ST(2));
        arg4 = (int) SvIV(ST(3));
        result = (int)layerObj_getShape(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getNumResults) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_getNumResults(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getNumResults. Expected _p_layerObj");
            }
        }
        result = (int)layerObj_getNumResults(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getResult) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        resultCacheMemberObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_getResult(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getResult. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (resultCacheMemberObj *)layerObj_getResult(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_resultCacheMemberObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getClass) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        classObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_getClass(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getClass. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (classObj *)layerObj_getClass(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_classObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getItem) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_getItem(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getItem. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (char *)layerObj_getItem(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_draw) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        imageObj *arg3 = (imageObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: layerObj_draw(self,map,image);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_draw. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_draw. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of layerObj_draw. Expected _p_imageObj");
            }
        }
        result = (int)layerObj_draw(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_drawQuery) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        imageObj *arg3 = (imageObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: layerObj_drawQuery(self,map,image);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_drawQuery. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_drawQuery. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of layerObj_drawQuery. Expected _p_imageObj");
            }
        }
        result = (int)layerObj_drawQuery(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_queryByAttributes) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        char *arg3 ;
        char *arg4 ;
        int arg5 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: layerObj_queryByAttributes(self,map,qitem,qstring,mode);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_queryByAttributes. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_queryByAttributes. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        if (!SvOK((SV*) ST(3))) arg4 = 0;
        else arg4 = (char *) SvPV(ST(3), PL_na);
        arg5 = (int) SvIV(ST(4));
        result = (int)layerObj_queryByAttributes(arg1,arg2,arg3,arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_queryByPoint) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        pointObj *arg3 = (pointObj *) 0 ;
        int arg4 ;
        double arg5 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: layerObj_queryByPoint(self,map,point,mode,buffer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_queryByPoint. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_queryByPoint. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of layerObj_queryByPoint. Expected _p_pointObj");
            }
        }
        arg4 = (int) SvIV(ST(3));
        arg5 = (double) SvNV(ST(4));
        
        result = (int)layerObj_queryByPoint(arg1,arg2,arg3,arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_queryByRect) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        rectObj arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: layerObj_queryByRect(self,map,rect);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_queryByRect. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_queryByRect. Expected _p_mapObj");
            }
        }
        {
            rectObj * argp;
            if (SWIG_ConvertPtr(ST(2),(void **) &argp, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of layerObj_queryByRect. Expected _p_rectObj");
            }
            arg3 = *argp;
        }
        result = (int)layerObj_queryByRect(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_queryByFeatures) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        int arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: layerObj_queryByFeatures(self,map,slayer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_queryByFeatures. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_queryByFeatures. Expected _p_mapObj");
            }
        }
        arg3 = (int) SvIV(ST(2));
        result = (int)layerObj_queryByFeatures(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_queryByShape) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        shapeObj *arg3 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: layerObj_queryByShape(self,map,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_queryByShape. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_queryByShape. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of layerObj_queryByShape. Expected _p_shapeObj");
            }
        }
        result = (int)layerObj_queryByShape(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_queryByIndex) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        int arg3 ;
        int arg4 ;
        int arg5 = (int) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 5)) {
            SWIG_croak("Usage: layerObj_queryByIndex(self,map,tileindex,shapeindex,bAddToQuery);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_queryByIndex. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_queryByIndex. Expected _p_mapObj");
            }
        }
        arg3 = (int) SvIV(ST(2));
        arg4 = (int) SvIV(ST(3));
        if (items > 4) {
            arg5 = (int) SvIV(ST(4));
        }
        result = (int)layerObj_queryByIndex(arg1,arg2,arg3,arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getResults) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        resultCacheObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_getResults(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getResults. Expected _p_layerObj");
            }
        }
        result = (resultCacheObj *)layerObj_getResults(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_resultCacheObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_setFilter) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_setFilter(self,filter);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_setFilter. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)layerObj_setFilter(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getFilterString) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_getFilterString(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getFilterString. Expected _p_layerObj");
            }
        }
        result = (char *)layerObj_getFilterString(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_setWKTProjection) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_setWKTProjection(self,wkt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_setWKTProjection. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)layerObj_setWKTProjection(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getProjection) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_getProjection(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getProjection. Expected _p_layerObj");
            }
        }
        result = (char *)layerObj_getProjection(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_setProjection) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_setProjection(self,proj4);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_setProjection. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)layerObj_setProjection(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_addFeature) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_addFeature(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_addFeature. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_addFeature. Expected _p_shapeObj");
            }
        }
        result = (int)layerObj_addFeature(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getNumFeatures) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_getNumFeatures(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getNumFeatures. Expected _p_layerObj");
            }
        }
        result = (int)layerObj_getNumFeatures(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getExtent) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        rectObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_getExtent(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getExtent. Expected _p_layerObj");
            }
        }
        result = (rectObj *)layerObj_getExtent(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_rectObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_setExtent) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        double arg2 = (double) -1.0 ;
        double arg3 = (double) -1.0 ;
        double arg4 = (double) -1.0 ;
        double arg5 = (double) -1.0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 5)) {
            SWIG_croak("Usage: layerObj_setExtent(self,minx,miny,maxx,maxy);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_setExtent. Expected _p_layerObj");
            }
        }
        if (items > 1) {
            arg2 = (double) SvNV(ST(1));
            
        }
        if (items > 2) {
            arg3 = (double) SvNV(ST(2));
            
        }
        if (items > 3) {
            arg4 = (double) SvNV(ST(3));
            
        }
        if (items > 4) {
            arg5 = (double) SvNV(ST(4));
            
        }
        result = (int)layerObj_setExtent(arg1,arg2,arg3,arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getMetaData) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_getMetaData(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getMetaData. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (char *)layerObj_getMetaData(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_setMetaData) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: layerObj_setMetaData(self,name,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_setMetaData. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)layerObj_setMetaData(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_removeMetaData) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_removeMetaData(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_removeMetaData. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)layerObj_removeMetaData(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getFirstMetaDataKey) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_getFirstMetaDataKey(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getFirstMetaDataKey. Expected _p_layerObj");
            }
        }
        result = (char *)layerObj_getFirstMetaDataKey(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getNextMetaDataKey) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_getNextMetaDataKey(self,lastkey);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getNextMetaDataKey. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (char *)layerObj_getNextMetaDataKey(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getWMSFeatureInfoURL) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        int arg3 ;
        int arg4 ;
        int arg5 ;
        char *arg6 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 6)) {
            SWIG_croak("Usage: layerObj_getWMSFeatureInfoURL(self,map,click_x,click_y,feature_count,info_format);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getWMSFeatureInfoURL. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_getWMSFeatureInfoURL. Expected _p_mapObj");
            }
        }
        arg3 = (int) SvIV(ST(2));
        arg4 = (int) SvIV(ST(3));
        arg5 = (int) SvIV(ST(4));
        if (!SvOK((SV*) ST(5))) arg6 = 0;
        else arg6 = (char *) SvPV(ST(5), PL_na);
        result = (char *)layerObj_getWMSFeatureInfoURL(arg1,arg2,arg3,arg4,arg5,arg6);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_executeWFSGetFeature) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        layerObj *arg2 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_executeWFSGetFeature(self,layer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_executeWFSGetFeature. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of layerObj_executeWFSGetFeature. Expected _p_layerObj");
            }
        }
        result = (char *)layerObj_executeWFSGetFeature(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_applySLD) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: layerObj_applySLD(self,sld,stylelayer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_applySLD. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)layerObj_applySLD(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_applySLDURL) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: layerObj_applySLDURL(self,sld,stylelayer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_applySLDURL. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)layerObj_applySLDURL(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_generateSLD) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_generateSLD(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_generateSLD. Expected _p_layerObj");
            }
        }
        result = (char *)layerObj_generateSLD(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_isVisible) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_isVisible(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_isVisible. Expected _p_layerObj");
            }
        }
        result = (int)layerObj_isVisible(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_moveClassUp) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_moveClassUp(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_moveClassUp. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)layerObj_moveClassUp(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_moveClassDown) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_moveClassDown(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_moveClassDown. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)layerObj_moveClassDown(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_setProcessingKey) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        char *arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: layerObj_setProcessingKey(self,key,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_setProcessingKey. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        layerObj_setProcessingKey(arg1,(char const *)arg2,(char const *)arg3);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_setProcessing) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_setProcessing(self,directive);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_setProcessing. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        layerObj_setProcessing(arg1,(char const *)arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_addProcessing) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_addProcessing(self,directive);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_addProcessing. Expected _p_layerObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        layerObj_addProcessing(arg1,(char const *)arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_getProcessing) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: layerObj_getProcessing(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_getProcessing. Expected _p_layerObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (char *)layerObj_getProcessing(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_layerObj_clearProcessing) {
    {
        layerObj *arg1 = (layerObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: layerObj_clearProcessing(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of layerObj_clearProcessing. Expected _p_layerObj");
            }
        }
        result = (int)layerObj_clearProcessing(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_name_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_name_set(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_name_set. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->name) free((char*)arg1->name);
            if (arg2) {
                arg1->name = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->name,arg2);
            } else {
                arg1->name = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_name_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_name_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_name_get. Expected _p_mapObj");
            }
        }
        result = (char *) ((arg1)->name);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_status_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_status_set(self,status);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_status_set. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->status = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_status_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_status_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_status_get. Expected _p_mapObj");
            }
        }
        result = (int) ((arg1)->status);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_height_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_height_set(self,height);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_height_set. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->height = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_height_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_height_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_height_get. Expected _p_mapObj");
            }
        }
        result = (int) ((arg1)->height);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_width_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_width_set(self,width);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_width_set. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->width = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_width_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_width_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_width_get. Expected _p_mapObj");
            }
        }
        result = (int) ((arg1)->width);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_maxsize_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_maxsize_set(self,maxsize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_maxsize_set. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->maxsize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_maxsize_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_maxsize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_maxsize_get. Expected _p_mapObj");
            }
        }
        result = (int) ((arg1)->maxsize);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_numlayers_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_numlayers_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_numlayers_get. Expected _p_mapObj");
            }
        }
        result = (int) ((arg1)->numlayers);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_symbolset_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        symbolSetObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_symbolset_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_symbolset_get. Expected _p_mapObj");
            }
        }
        result = (symbolSetObj *)& ((arg1)->symbolset);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_symbolSetObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_fontset_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        fontSetObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_fontset_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_fontset_get. Expected _p_mapObj");
            }
        }
        result = (fontSetObj *)& ((arg1)->fontset);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_fontSetObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_labelcache_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        labelCacheObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_labelcache_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_labelcache_get. Expected _p_mapObj");
            }
        }
        result = (labelCacheObj *)& ((arg1)->labelcache);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelCacheObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_transparent_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_transparent_set(self,transparent);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_transparent_set. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->transparent = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_transparent_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_transparent_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_transparent_get. Expected _p_mapObj");
            }
        }
        result = (int) ((arg1)->transparent);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_interlace_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_interlace_set(self,interlace);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_interlace_set. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->interlace = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_interlace_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_interlace_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_interlace_get. Expected _p_mapObj");
            }
        }
        result = (int) ((arg1)->interlace);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_imagequality_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_imagequality_set(self,imagequality);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_imagequality_set. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->imagequality = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_imagequality_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_imagequality_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_imagequality_get. Expected _p_mapObj");
            }
        }
        result = (int) ((arg1)->imagequality);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_extent_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        rectObj *arg2 = (rectObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_extent_set(self,extent);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_extent_set. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_extent_set. Expected _p_rectObj");
            }
        }
        if (arg1) (arg1)->extent = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_extent_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        rectObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_extent_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_extent_get. Expected _p_mapObj");
            }
        }
        result = (rectObj *)& ((arg1)->extent);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_rectObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_cellsize_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_cellsize_set(self,cellsize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_cellsize_set. Expected _p_mapObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->cellsize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_cellsize_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_cellsize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_cellsize_get. Expected _p_mapObj");
            }
        }
        result = (double) ((arg1)->cellsize);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_saved_extent_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        rectObj *arg2 = (rectObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_saved_extent_set(self,saved_extent);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_saved_extent_set. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_saved_extent_set. Expected _p_rectObj");
            }
        }
        if (arg1) (arg1)->saved_extent = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_saved_extent_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        rectObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_saved_extent_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_saved_extent_get. Expected _p_mapObj");
            }
        }
        result = (rectObj *)& ((arg1)->saved_extent);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_rectObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_units_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_units_set(self,units);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_units_set. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->units = (enum MS_UNITS)arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_units_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_units_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_units_get. Expected _p_mapObj");
            }
        }
        result = (int) ((arg1)->units);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_scale_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_scale_set(self,scale);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_scale_set. Expected _p_mapObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->scale = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_scale_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_scale_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_scale_get. Expected _p_mapObj");
            }
        }
        result = (double) ((arg1)->scale);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_resolution_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_resolution_set(self,resolution);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_resolution_set. Expected _p_mapObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->resolution = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_resolution_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_resolution_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_resolution_get. Expected _p_mapObj");
            }
        }
        result = (double) ((arg1)->resolution);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_shapepath_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_shapepath_set(self,shapepath);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_shapepath_set. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->shapepath) free((char*)arg1->shapepath);
            if (arg2) {
                arg1->shapepath = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->shapepath,arg2);
            } else {
                arg1->shapepath = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_shapepath_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_shapepath_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_shapepath_get. Expected _p_mapObj");
            }
        }
        result = (char *) ((arg1)->shapepath);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_mappath_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_mappath_set(self,mappath);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_mappath_set. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->mappath) free((char*)arg1->mappath);
            if (arg2) {
                arg1->mappath = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->mappath,arg2);
            } else {
                arg1->mappath = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_mappath_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_mappath_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_mappath_get. Expected _p_mapObj");
            }
        }
        result = (char *) ((arg1)->mappath);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_imagecolor_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        colorObj *arg2 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_imagecolor_set(self,imagecolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_imagecolor_set. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_imagecolor_set. Expected _p_colorObj");
            }
        }
        if (arg1) (arg1)->imagecolor = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_imagecolor_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_imagecolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_imagecolor_get. Expected _p_mapObj");
            }
        }
        result = (colorObj *)& ((arg1)->imagecolor);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_numoutputformats_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_numoutputformats_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_numoutputformats_get. Expected _p_mapObj");
            }
        }
        result = (int) ((arg1)->numoutputformats);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_outputformatlist_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        outputFormatObj **result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_outputformatlist_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_outputformatlist_get. Expected _p_mapObj");
            }
        }
        result = (outputFormatObj **) ((arg1)->outputformatlist);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_p_outputFormatObj, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_outputformat_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        outputFormatObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_outputformat_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_outputformat_get. Expected _p_mapObj");
            }
        }
        result = (outputFormatObj *) ((arg1)->outputformat);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_outputFormatObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_imagetype_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_imagetype_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_imagetype_get. Expected _p_mapObj");
            }
        }
        result = (char *) ((arg1)->imagetype);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_reference_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        referenceMapObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_reference_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_reference_get. Expected _p_mapObj");
            }
        }
        result = (referenceMapObj *)& ((arg1)->reference);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_referenceMapObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_scalebar_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        scalebarObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_scalebar_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_scalebar_get. Expected _p_mapObj");
            }
        }
        result = (scalebarObj *)& ((arg1)->scalebar);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_scalebarObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_legend_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        legendObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_legend_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_legend_get. Expected _p_mapObj");
            }
        }
        result = (legendObj *)& ((arg1)->legend);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_legendObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_querymap_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        queryMapObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_querymap_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_querymap_get. Expected _p_mapObj");
            }
        }
        result = (queryMapObj *)& ((arg1)->querymap);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_queryMapObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_web_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        webObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_web_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_web_get. Expected _p_mapObj");
            }
        }
        result = (webObj *)& ((arg1)->web);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_webObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_layerorder_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int *arg2 = (int *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_layerorder_set(self,layerorder);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_layerorder_set. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_int,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_layerorder_set. Expected _p_int");
            }
        }
        if (arg1) (arg1)->layerorder = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_layerorder_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_layerorder_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_layerorder_get. Expected _p_mapObj");
            }
        }
        result = (int *) ((arg1)->layerorder);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_int, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_debug_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_debug_set(self,debug);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_debug_set. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->debug = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_debug_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_debug_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_debug_get. Expected _p_mapObj");
            }
        }
        result = (int) ((arg1)->debug);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_datapattern_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_datapattern_set(self,datapattern);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_datapattern_set. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->datapattern) free((char*)arg1->datapattern);
            if (arg2) {
                arg1->datapattern = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->datapattern,arg2);
            } else {
                arg1->datapattern = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_datapattern_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_datapattern_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_datapattern_get. Expected _p_mapObj");
            }
        }
        result = (char *) ((arg1)->datapattern);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_templatepattern_set) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_templatepattern_set(self,templatepattern);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_templatepattern_set. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->templatepattern) free((char*)arg1->templatepattern);
            if (arg2) {
                arg1->templatepattern = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->templatepattern,arg2);
            } else {
                arg1->templatepattern = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_templatepattern_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_templatepattern_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_templatepattern_get. Expected _p_mapObj");
            }
        }
        result = (char *) ((arg1)->templatepattern);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_configoptions_get) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        hashTableObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_configoptions_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_configoptions_get. Expected _p_mapObj");
            }
        }
        result = (hashTableObj *)& ((arg1)->configoptions);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_hashTableObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_mapObj) {
    {
        char *arg1 = (char *) "" ;
        mapObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: new_mapObj(filename);");
        }
        if (items > 0) {
            if (!SvOK((SV*) ST(0))) arg1 = 0;
            else arg1 = (char *) SvPV(ST(0), PL_na);
        }
        result = (mapObj *)new_mapObj(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_mapObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_mapObj) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_mapObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_mapObj. Expected _p_mapObj");
            }
        }
        delete_mapObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_clone) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        mapObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_clone(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_clone. Expected _p_mapObj");
            }
        }
        result = (mapObj *)mapObj_clone(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_mapObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_insertLayer) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        layerObj *arg2 = (layerObj *) 0 ;
        int arg3 = (int) -1 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: mapObj_insertLayer(self,layer,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_insertLayer. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_insertLayer. Expected _p_layerObj");
            }
        }
        if (items > 2) {
            arg3 = (int) SvIV(ST(2));
        }
        result = (int)mapObj_insertLayer(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_removeLayer) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        layerObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_removeLayer(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_removeLayer. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (layerObj *)mapObj_removeLayer(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_layerObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setExtent) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        double arg2 ;
        double arg3 ;
        double arg4 ;
        double arg5 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: mapObj_setExtent(self,minx,miny,maxx,maxy);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setExtent. Expected _p_mapObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        arg3 = (double) SvNV(ST(2));
        
        arg4 = (double) SvNV(ST(3));
        
        arg5 = (double) SvNV(ST(4));
        
        result = (int)mapObj_setExtent(arg1,arg2,arg3,arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setSize) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: mapObj_setSize(self,width,height);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setSize. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (int) SvIV(ST(2));
        result = (int)mapObj_setSize(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setRotation) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        double arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_setRotation(self,rotation_angle);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setRotation. Expected _p_mapObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        result = (int)mapObj_setRotation(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getLayer) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        layerObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_getLayer(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getLayer. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (layerObj *)mapObj_getLayer(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_layerObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getLayerByName) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        layerObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_getLayerByName(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getLayerByName. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (layerObj *)mapObj_getLayerByName(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_layerObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getSymbolByName) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_getSymbolByName(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getSymbolByName. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_getSymbolByName(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_prepareQuery) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_prepareQuery(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_prepareQuery. Expected _p_mapObj");
            }
        }
        mapObj_prepareQuery(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_prepareImage) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        imageObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_prepareImage(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_prepareImage. Expected _p_mapObj");
            }
        }
        result = (imageObj *)mapObj_prepareImage(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_imageObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setImageType) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_setImageType(self,imagetype);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setImageType. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        mapObj_setImageType(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_selectOutputFormat) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_selectOutputFormat(self,imagetype);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_selectOutputFormat. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        mapObj_selectOutputFormat(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setOutputFormat) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        outputFormatObj *arg2 = (outputFormatObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_setOutputFormat(self,format);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setOutputFormat. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_setOutputFormat. Expected _p_outputFormatObj");
            }
        }
        mapObj_setOutputFormat(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_draw) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        imageObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_draw(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_draw. Expected _p_mapObj");
            }
        }
        result = (imageObj *)mapObj_draw(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_imageObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_drawQuery) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        imageObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_drawQuery(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_drawQuery. Expected _p_mapObj");
            }
        }
        result = (imageObj *)mapObj_drawQuery(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_imageObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_drawLegend) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        imageObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_drawLegend(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_drawLegend. Expected _p_mapObj");
            }
        }
        result = (imageObj *)mapObj_drawLegend(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_imageObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_drawScalebar) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        imageObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_drawScalebar(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_drawScalebar. Expected _p_mapObj");
            }
        }
        result = (imageObj *)mapObj_drawScalebar(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_imageObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_drawReferenceMap) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        imageObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_drawReferenceMap(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_drawReferenceMap. Expected _p_mapObj");
            }
        }
        result = (imageObj *)mapObj_drawReferenceMap(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_imageObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_embedScalebar) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        imageObj *arg2 = (imageObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_embedScalebar(self,image);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_embedScalebar. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_embedScalebar. Expected _p_imageObj");
            }
        }
        result = (int)mapObj_embedScalebar(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_embedLegend) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        imageObj *arg2 = (imageObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_embedLegend(self,image);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_embedLegend. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_embedLegend. Expected _p_imageObj");
            }
        }
        result = (int)mapObj_embedLegend(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_drawLabelCache) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        imageObj *arg2 = (imageObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_drawLabelCache(self,image);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_drawLabelCache. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_drawLabelCache. Expected _p_imageObj");
            }
        }
        result = (int)mapObj_drawLabelCache(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getLabel) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        labelCacheMemberObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_getLabel(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getLabel. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (labelCacheMemberObj *)mapObj_getLabel(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelCacheMemberObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_nextLabel) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        labelCacheMemberObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_nextLabel(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_nextLabel. Expected _p_mapObj");
            }
        }
        result = (labelCacheMemberObj *)mapObj_nextLabel(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_labelCacheMemberObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_queryByPoint) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        pointObj *arg2 = (pointObj *) 0 ;
        int arg3 ;
        double arg4 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: mapObj_queryByPoint(self,point,mode,buffer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_queryByPoint. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_queryByPoint. Expected _p_pointObj");
            }
        }
        arg3 = (int) SvIV(ST(2));
        arg4 = (double) SvNV(ST(3));
        
        result = (int)mapObj_queryByPoint(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_queryByRect) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        rectObj arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_queryByRect(self,rect);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_queryByRect. Expected _p_mapObj");
            }
        }
        {
            rectObj * argp;
            if (SWIG_ConvertPtr(ST(1),(void **) &argp, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_queryByRect. Expected _p_rectObj");
            }
            arg2 = *argp;
        }
        result = (int)mapObj_queryByRect(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_queryByFeatures) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_queryByFeatures(self,slayer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_queryByFeatures. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)mapObj_queryByFeatures(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_queryByShape) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_queryByShape(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_queryByShape. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_queryByShape. Expected _p_shapeObj");
            }
        }
        result = (int)mapObj_queryByShape(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setWKTProjection) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_setWKTProjection(self,wkt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setWKTProjection. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_setWKTProjection(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getProjection) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_getProjection(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getProjection. Expected _p_mapObj");
            }
        }
        result = (char *)mapObj_getProjection(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setProjection) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_setProjection(self,proj4);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setProjection. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_setProjection(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_save) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_save(self,filename);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_save. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_save(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_saveQuery) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_saveQuery(self,filename);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_saveQuery. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_saveQuery(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_loadQuery) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_loadQuery(self,filename);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_loadQuery. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_loadQuery(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_freeQuery) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 = (int) -1 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: mapObj_freeQuery(self,qlayer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_freeQuery. Expected _p_mapObj");
            }
        }
        if (items > 1) {
            arg2 = (int) SvIV(ST(1));
        }
        mapObj_freeQuery(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_saveQueryAsGML) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        char *arg3 = (char *) "GOMF" ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: mapObj_saveQueryAsGML(self,filename,ns);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_saveQueryAsGML. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (items > 2) {
            if (!SvOK((SV*) ST(2))) arg3 = 0;
            else arg3 = (char *) SvPV(ST(2), PL_na);
        }
        result = (int)mapObj_saveQueryAsGML(arg1,arg2,(char const *)arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getMetaData) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_getMetaData(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getMetaData. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (char *)mapObj_getMetaData(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setMetaData) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: mapObj_setMetaData(self,name,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setMetaData. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)mapObj_setMetaData(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_removeMetaData) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_removeMetaData(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_removeMetaData. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_removeMetaData(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getFirstMetaDataKey) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_getFirstMetaDataKey(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getFirstMetaDataKey. Expected _p_mapObj");
            }
        }
        result = (char *)mapObj_getFirstMetaDataKey(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getNextMetaDataKey) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_getNextMetaDataKey(self,lastkey);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getNextMetaDataKey. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (char *)mapObj_getNextMetaDataKey(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setSymbolSet) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_setSymbolSet(self,szFileName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setSymbolSet. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_setSymbolSet(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getNumSymbols) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_getNumSymbols(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getNumSymbols. Expected _p_mapObj");
            }
        }
        result = (int)mapObj_getNumSymbols(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setFontSet) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_setFontSet(self,filename);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setFontSet. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_setFontSet(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_saveMapContext) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_saveMapContext(self,szFileName);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_saveMapContext. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_saveMapContext(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_loadMapContext) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int arg3 = (int) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: mapObj_loadMapContext(self,szFileName,useUniqueNames);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_loadMapContext. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (items > 2) {
            arg3 = (int) SvIV(ST(2));
        }
        result = (int)mapObj_loadMapContext(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_moveLayerUp) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_moveLayerUp(self,layerindex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_moveLayerUp. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)mapObj_moveLayerUp(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_moveLayerDown) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_moveLayerDown(self,layerindex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_moveLayerDown. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)mapObj_moveLayerDown(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getLayersDrawingOrder) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        intarray *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_getLayersDrawingOrder(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getLayersDrawingOrder. Expected _p_mapObj");
            }
        }
        result = (intarray *)mapObj_getLayersDrawingOrder(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_intarray, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setLayersDrawingOrder) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int *arg2 = (int *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_setLayersDrawingOrder(self,panIndexes);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setLayersDrawingOrder. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_int,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_setLayersDrawingOrder. Expected _p_int");
            }
        }
        result = (int)mapObj_setLayersDrawingOrder(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_setConfigOption) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        char *arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: mapObj_setConfigOption(self,key,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_setConfigOption. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        mapObj_setConfigOption(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getConfigOption) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_getConfigOption(self,key);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getConfigOption. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (char *)mapObj_getConfigOption(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_applyConfigOptions) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_applyConfigOptions(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_applyConfigOptions. Expected _p_mapObj");
            }
        }
        mapObj_applyConfigOptions(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_applySLD) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_applySLD(self,sld);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_applySLD. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_applySLD(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_applySLDURL) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_applySLDURL(self,sld);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_applySLDURL. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_applySLDURL(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_generateSLD) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: mapObj_generateSLD(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_generateSLD. Expected _p_mapObj");
            }
        }
        result = (char *)mapObj_generateSLD(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_processTemplate) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        char **arg3 = (char **) 0 ;
        char **arg4 = (char **) 0 ;
        int arg5 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: mapObj_processTemplate(self,bGenerateImages,names,values,numentries);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_processTemplate. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_p_char,0) < 0) {
                SWIG_croak("Type error in argument 3 of mapObj_processTemplate. Expected _p_p_char");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_p_char,0) < 0) {
                SWIG_croak("Type error in argument 4 of mapObj_processTemplate. Expected _p_p_char");
            }
        }
        arg5 = (int) SvIV(ST(4));
        result = (char *)mapObj_processTemplate(arg1,arg2,arg3,arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_processLegendTemplate) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char **arg2 = (char **) 0 ;
        char **arg3 = (char **) 0 ;
        int arg4 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: mapObj_processLegendTemplate(self,names,values,numentries);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_processLegendTemplate. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_p_char,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_processLegendTemplate. Expected _p_p_char");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_p_char,0) < 0) {
                SWIG_croak("Type error in argument 3 of mapObj_processLegendTemplate. Expected _p_p_char");
            }
        }
        arg4 = (int) SvIV(ST(3));
        result = (char *)mapObj_processLegendTemplate(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_processQueryTemplate) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char **arg2 = (char **) 0 ;
        char **arg3 = (char **) 0 ;
        int arg4 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: mapObj_processQueryTemplate(self,names,values,numentries);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_processQueryTemplate. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_p_char,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_processQueryTemplate. Expected _p_p_char");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_p_char,0) < 0) {
                SWIG_croak("Type error in argument 3 of mapObj_processQueryTemplate. Expected _p_p_char");
            }
        }
        arg4 = (int) SvIV(ST(3));
        result = (char *)mapObj_processQueryTemplate(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_getOutputFormatByName) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        outputFormatObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_getOutputFormatByName(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_getOutputFormatByName. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (outputFormatObj *)mapObj_getOutputFormatByName(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_outputFormatObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_appendOutputFormat) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        outputFormatObj *arg2 = (outputFormatObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_appendOutputFormat(self,format);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_appendOutputFormat. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_appendOutputFormat. Expected _p_outputFormatObj");
            }
        }
        result = (int)mapObj_appendOutputFormat(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_removeOutputFormat) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_removeOutputFormat(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_removeOutputFormat. Expected _p_mapObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)mapObj_removeOutputFormat(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_loadOWSParameters) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        cgiRequestObj *arg2 = (cgiRequestObj *) 0 ;
        char *arg3 = (char *) "1.1.1" ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: mapObj_loadOWSParameters(self,request,wmtver_string);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_loadOWSParameters. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_loadOWSParameters. Expected _p_cgiRequestObj");
            }
        }
        if (items > 2) {
            if (!SvOK((SV*) ST(2))) arg3 = 0;
            else arg3 = (char *) SvPV(ST(2), PL_na);
        }
        result = (int)mapObj_loadOWSParameters(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_OWSDispatch) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        cgiRequestObj *arg2 = (cgiRequestObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: mapObj_OWSDispatch(self,req);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_OWSDispatch. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_OWSDispatch. Expected _p_cgiRequestObj");
            }
        }
        result = (int)mapObj_OWSDispatch(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_zoomPoint) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        int arg2 ;
        pointObj *arg3 = (pointObj *) 0 ;
        int arg4 ;
        int arg5 ;
        rectObj *arg6 = (rectObj *) 0 ;
        rectObj *arg7 = (rectObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 7) || (items > 7)) {
            SWIG_croak("Usage: mapObj_zoomPoint(self,zoomfactor,poPixPos,width,height,poGeorefExt,poMaxGeorefExt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_zoomPoint. Expected _p_mapObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of mapObj_zoomPoint. Expected _p_pointObj");
            }
        }
        arg4 = (int) SvIV(ST(3));
        arg5 = (int) SvIV(ST(4));
        {
            if (SWIG_ConvertPtr(ST(5), (void **) &arg6, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 6 of mapObj_zoomPoint. Expected _p_rectObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(6), (void **) &arg7, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 7 of mapObj_zoomPoint. Expected _p_rectObj");
            }
        }
        result = (int)mapObj_zoomPoint(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_zoomRectangle) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        rectObj *arg2 = (rectObj *) 0 ;
        int arg3 ;
        int arg4 ;
        rectObj *arg5 = (rectObj *) 0 ;
        rectObj *arg6 = (rectObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 6)) {
            SWIG_croak("Usage: mapObj_zoomRectangle(self,poPixRect,width,height,poGeorefExt,poMaxGeorefExt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_zoomRectangle. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of mapObj_zoomRectangle. Expected _p_rectObj");
            }
        }
        arg3 = (int) SvIV(ST(2));
        arg4 = (int) SvIV(ST(3));
        {
            if (SWIG_ConvertPtr(ST(4), (void **) &arg5, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 5 of mapObj_zoomRectangle. Expected _p_rectObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(5), (void **) &arg6, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 6 of mapObj_zoomRectangle. Expected _p_rectObj");
            }
        }
        result = (int)mapObj_zoomRectangle(arg1,arg2,arg3,arg4,arg5,arg6);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_mapObj_zoomScale) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        double arg2 ;
        pointObj *arg3 = (pointObj *) 0 ;
        int arg4 ;
        int arg5 ;
        rectObj *arg6 = (rectObj *) 0 ;
        rectObj *arg7 = (rectObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 7) || (items > 7)) {
            SWIG_croak("Usage: mapObj_zoomScale(self,scale,poPixPos,width,height,poGeorefExt,poMaxGeorefExt);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of mapObj_zoomScale. Expected _p_mapObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of mapObj_zoomScale. Expected _p_pointObj");
            }
        }
        arg4 = (int) SvIV(ST(3));
        arg5 = (int) SvIV(ST(4));
        {
            if (SWIG_ConvertPtr(ST(5), (void **) &arg6, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 6 of mapObj_zoomScale. Expected _p_rectObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(6), (void **) &arg7, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 7 of mapObj_zoomScale. Expected _p_rectObj");
            }
        }
        result = (int)mapObj_zoomScale(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_width_get) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: imageObj_width_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_width_get. Expected _p_imageObj");
            }
        }
        result = (int) ((arg1)->width);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_height_get) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: imageObj_height_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_height_get. Expected _p_imageObj");
            }
        }
        result = (int) ((arg1)->height);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_imagepath_get) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: imageObj_imagepath_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_imagepath_get. Expected _p_imageObj");
            }
        }
        result = (char *) ((arg1)->imagepath);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_imageurl_get) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: imageObj_imageurl_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_imageurl_get. Expected _p_imageObj");
            }
        }
        result = (char *) ((arg1)->imageurl);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_format_get) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        outputFormatObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: imageObj_format_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_format_get. Expected _p_imageObj");
            }
        }
        result = (outputFormatObj *) ((arg1)->format);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_outputFormatObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_renderer_set) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: imageObj_renderer_set(self,renderer);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_renderer_set. Expected _p_imageObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->renderer = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_renderer_get) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: imageObj_renderer_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_renderer_get. Expected _p_imageObj");
            }
        }
        result = (int) ((arg1)->renderer);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_size_set) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: imageObj_size_set(self,size);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_size_set. Expected _p_imageObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->size = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_size_get) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: imageObj_size_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_size_get. Expected _p_imageObj");
            }
        }
        result = (int) ((arg1)->size);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_imageObj) {
    {
        int arg1 ;
        int arg2 ;
        outputFormatObj *arg3 = (outputFormatObj *) NULL ;
        char *arg4 = (char *) NULL ;
        imageObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 4)) {
            SWIG_croak("Usage: new_imageObj(width,height,input_format,file);");
        }
        arg1 = (int) SvIV(ST(0));
        arg2 = (int) SvIV(ST(1));
        if (items > 2) {
            {
                if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_outputFormatObj,0) < 0) {
                    SWIG_croak("Type error in argument 3 of new_imageObj. Expected _p_outputFormatObj");
                }
            }
        }
        if (items > 3) {
            if (!SvOK((SV*) ST(3))) arg4 = 0;
            else arg4 = (char *) SvPV(ST(3), PL_na);
        }
        result = (imageObj *)new_imageObj(arg1,arg2,arg3,(char const *)arg4);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_imageObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_imageObj) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_imageObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_imageObj. Expected _p_imageObj");
            }
        }
        delete_imageObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_save) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        char *arg2 ;
        mapObj *arg3 = (mapObj *) NULL ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: imageObj_save(self,filename,map);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_save. Expected _p_imageObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (items > 2) {
            {
                if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_mapObj,0) < 0) {
                    SWIG_croak("Type error in argument 3 of imageObj_save. Expected _p_mapObj");
                }
            }
        }
        imageObj_save(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_write) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        FILE *arg2 = (FILE *) NULL ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: imageObj_write(self,file);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_write. Expected _p_imageObj");
            }
        }
        if (items > 1) {
            {
                if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_FILE,0) < 0) {
                    SWIG_croak("Type error in argument 2 of imageObj_write. Expected _p_FILE");
                }
            }
        }
        result = (int)imageObj_write(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_imageObj_getBytes) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        gdBuffer result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: imageObj_getBytes(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of imageObj_getBytes. Expected _p_imageObj");
            }
        }
        result = imageObj_getBytes(arg1);
        
        {
            gdBuffer * resultobj = (gdBuffer *) malloc(sizeof(gdBuffer));
            memmove(resultobj, &result, sizeof(gdBuffer));
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_gdBuffer, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msSaveImage) {
    {
        mapObj *arg1 = (mapObj *) 0 ;
        imageObj *arg2 = (imageObj *) 0 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: msSaveImage(map,img,filename);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of msSaveImage. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of msSaveImage. Expected _p_imageObj");
            }
        }
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)msSaveImage(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msFreeImage) {
    {
        imageObj *arg1 = (imageObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: msFreeImage(img);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of msFreeImage. Expected _p_imageObj");
            }
        }
        msFreeImage(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msSetup) {
    {
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msSetup();");
        }
        result = (int)msSetup();
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msCleanup) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msCleanup();");
        }
        msCleanup();
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_minx_set) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: rectObj_minx_set(self,minx);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_minx_set. Expected _p_rectObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->minx = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_minx_get) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: rectObj_minx_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_minx_get. Expected _p_rectObj");
            }
        }
        result = (double) ((arg1)->minx);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_miny_set) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: rectObj_miny_set(self,miny);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_miny_set. Expected _p_rectObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->miny = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_miny_get) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: rectObj_miny_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_miny_get. Expected _p_rectObj");
            }
        }
        result = (double) ((arg1)->miny);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_maxx_set) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: rectObj_maxx_set(self,maxx);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_maxx_set. Expected _p_rectObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->maxx = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_maxx_get) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: rectObj_maxx_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_maxx_get. Expected _p_rectObj");
            }
        }
        result = (double) ((arg1)->maxx);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_maxy_set) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: rectObj_maxy_set(self,maxy);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_maxy_set. Expected _p_rectObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->maxy = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_maxy_get) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: rectObj_maxy_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_maxy_get. Expected _p_rectObj");
            }
        }
        result = (double) ((arg1)->maxy);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_rectObj) {
    {
        double arg1 = (double) -1.0 ;
        double arg2 = (double) -1.0 ;
        double arg3 = (double) -1.0 ;
        double arg4 = (double) -1.0 ;
        int arg5 = (int) 0 ;
        rectObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 5)) {
            SWIG_croak("Usage: new_rectObj(minx,miny,maxx,maxy,imageunits);");
        }
        if (items > 0) {
            arg1 = (double) SvNV(ST(0));
            
        }
        if (items > 1) {
            arg2 = (double) SvNV(ST(1));
            
        }
        if (items > 2) {
            arg3 = (double) SvNV(ST(2));
            
        }
        if (items > 3) {
            arg4 = (double) SvNV(ST(3));
            
        }
        if (items > 4) {
            arg5 = (int) SvIV(ST(4));
        }
        result = (rectObj *)new_rectObj(arg1,arg2,arg3,arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_rectObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_rectObj) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_rectObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_rectObj. Expected _p_rectObj");
            }
        }
        delete_rectObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_project) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        projectionObj *arg2 = (projectionObj *) 0 ;
        projectionObj *arg3 = (projectionObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: rectObj_project(self,projin,projout);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_project. Expected _p_rectObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_projectionObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of rectObj_project. Expected _p_projectionObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_projectionObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of rectObj_project. Expected _p_projectionObj");
            }
        }
        result = (int)rectObj_project(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_fit) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        int arg2 ;
        int arg3 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: rectObj_fit(self,width,height);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_fit. Expected _p_rectObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (int) SvIV(ST(2));
        result = (double)rectObj_fit(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_draw) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        layerObj *arg3 = (layerObj *) 0 ;
        imageObj *arg4 = (imageObj *) 0 ;
        int arg5 ;
        char *arg6 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 6)) {
            SWIG_croak("Usage: rectObj_draw(self,map,layer,image,classindex,text);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_draw. Expected _p_rectObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of rectObj_draw. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of rectObj_draw. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 4 of rectObj_draw. Expected _p_imageObj");
            }
        }
        arg5 = (int) SvIV(ST(4));
        if (!SvOK((SV*) ST(5))) arg6 = 0;
        else arg6 = (char *) SvPV(ST(5), PL_na);
        result = (int)rectObj_draw(arg1,arg2,arg3,arg4,arg5,arg6);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_toPolygon) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: rectObj_toPolygon(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_toPolygon. Expected _p_rectObj");
            }
        }
        result = (shapeObj *)rectObj_toPolygon(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_rectObj_toString) {
    {
        rectObj *arg1 = (rectObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: rectObj_toString(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of rectObj_toString. Expected _p_rectObj");
            }
        }
        result = (char *)rectObj_toString(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_x_set) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: pointObj_x_set(self,x);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_x_set. Expected _p_pointObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->x = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_x_get) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: pointObj_x_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_x_get. Expected _p_pointObj");
            }
        }
        result = (double) ((arg1)->x);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_y_set) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: pointObj_y_set(self,y);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_y_set. Expected _p_pointObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->y = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_y_get) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: pointObj_y_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_y_get. Expected _p_pointObj");
            }
        }
        result = (double) ((arg1)->y);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_pointObj) {
    {
        double arg1 = (double) 0.0 ;
        double arg2 = (double) 0.0 ;
        double arg3 = (double) 0.0 ;
        double arg4 = (double) -2e38 ;
        pointObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 4)) {
            SWIG_croak("Usage: new_pointObj(x,y,z,m);");
        }
        if (items > 0) {
            arg1 = (double) SvNV(ST(0));
            
        }
        if (items > 1) {
            arg2 = (double) SvNV(ST(1));
            
        }
        if (items > 2) {
            arg3 = (double) SvNV(ST(2));
            
        }
        if (items > 3) {
            arg4 = (double) SvNV(ST(3));
            
        }
        result = (pointObj *)new_pointObj(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_pointObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_pointObj) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_pointObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_pointObj. Expected _p_pointObj");
            }
        }
        delete_pointObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_project) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        projectionObj *arg2 = (projectionObj *) 0 ;
        projectionObj *arg3 = (projectionObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: pointObj_project(self,projin,projout);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_project. Expected _p_pointObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_projectionObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of pointObj_project. Expected _p_projectionObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_projectionObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of pointObj_project. Expected _p_projectionObj");
            }
        }
        result = (int)pointObj_project(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_draw) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        layerObj *arg3 = (layerObj *) 0 ;
        imageObj *arg4 = (imageObj *) 0 ;
        int arg5 ;
        char *arg6 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 6) || (items > 6)) {
            SWIG_croak("Usage: pointObj_draw(self,map,layer,image,classindex,text);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_draw. Expected _p_pointObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of pointObj_draw. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of pointObj_draw. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 4 of pointObj_draw. Expected _p_imageObj");
            }
        }
        arg5 = (int) SvIV(ST(4));
        if (!SvOK((SV*) ST(5))) arg6 = 0;
        else arg6 = (char *) SvPV(ST(5), PL_na);
        result = (int)pointObj_draw(arg1,arg2,arg3,arg4,arg5,arg6);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_distanceToPoint) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        pointObj *arg2 = (pointObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: pointObj_distanceToPoint(self,point);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_distanceToPoint. Expected _p_pointObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of pointObj_distanceToPoint. Expected _p_pointObj");
            }
        }
        result = (double)pointObj_distanceToPoint(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_distanceToSegment) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        pointObj *arg2 = (pointObj *) 0 ;
        pointObj *arg3 = (pointObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: pointObj_distanceToSegment(self,a,b);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_distanceToSegment. Expected _p_pointObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of pointObj_distanceToSegment. Expected _p_pointObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of pointObj_distanceToSegment. Expected _p_pointObj");
            }
        }
        result = (double)pointObj_distanceToSegment(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_distanceToShape) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: pointObj_distanceToShape(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_distanceToShape. Expected _p_pointObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of pointObj_distanceToShape. Expected _p_shapeObj");
            }
        }
        result = (double)pointObj_distanceToShape(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_setXY) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        double arg2 ;
        double arg3 ;
        double arg4 = (double) -2e38 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 4)) {
            SWIG_croak("Usage: pointObj_setXY(self,x,y,m);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_setXY. Expected _p_pointObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        arg3 = (double) SvNV(ST(2));
        
        if (items > 3) {
            arg4 = (double) SvNV(ST(3));
            
        }
        result = (int)pointObj_setXY(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_setXYZ) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        double arg2 ;
        double arg3 ;
        double arg4 ;
        double arg5 = (double) -2e38 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 5)) {
            SWIG_croak("Usage: pointObj_setXYZ(self,x,y,z,m);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_setXYZ. Expected _p_pointObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        arg3 = (double) SvNV(ST(2));
        
        arg4 = (double) SvNV(ST(3));
        
        if (items > 4) {
            arg5 = (double) SvNV(ST(4));
            
        }
        result = (int)pointObj_setXYZ(arg1,arg2,arg3,arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_setXYZM) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        double arg2 ;
        double arg3 ;
        double arg4 ;
        double arg5 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 5) || (items > 5)) {
            SWIG_croak("Usage: pointObj_setXYZM(self,x,y,z,m);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_setXYZM. Expected _p_pointObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        arg3 = (double) SvNV(ST(2));
        
        arg4 = (double) SvNV(ST(3));
        
        arg5 = (double) SvNV(ST(4));
        
        result = (int)pointObj_setXYZM(arg1,arg2,arg3,arg4,arg5);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_toString) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: pointObj_toString(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_toString. Expected _p_pointObj");
            }
        }
        result = (char *)pointObj_toString(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_pointObj_toShape) {
    {
        pointObj *arg1 = (pointObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: pointObj_toShape(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of pointObj_toShape. Expected _p_pointObj");
            }
        }
        result = (shapeObj *)pointObj_toShape(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_lineObj_numpoints_get) {
    {
        lineObj *arg1 = (lineObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: lineObj_numpoints_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_lineObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of lineObj_numpoints_get. Expected _p_lineObj");
            }
        }
        result = (int) ((arg1)->numpoints);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_lineObj_point_get) {
    {
        lineObj *arg1 = (lineObj *) 0 ;
        pointObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: lineObj_point_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_lineObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of lineObj_point_get. Expected _p_lineObj");
            }
        }
        result = (pointObj *) ((arg1)->point);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_pointObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_lineObj) {
    {
        lineObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_lineObj();");
        }
        result = (lineObj *)new_lineObj();
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_lineObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_lineObj) {
    {
        lineObj *arg1 = (lineObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_lineObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_lineObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_lineObj. Expected _p_lineObj");
            }
        }
        delete_lineObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_lineObj_project) {
    {
        lineObj *arg1 = (lineObj *) 0 ;
        projectionObj *arg2 = (projectionObj *) 0 ;
        projectionObj *arg3 = (projectionObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: lineObj_project(self,projin,projout);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_lineObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of lineObj_project. Expected _p_lineObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_projectionObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of lineObj_project. Expected _p_projectionObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_projectionObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of lineObj_project. Expected _p_projectionObj");
            }
        }
        result = (int)lineObj_project(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_lineObj_get) {
    {
        lineObj *arg1 = (lineObj *) 0 ;
        int arg2 ;
        pointObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: lineObj_get(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_lineObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of lineObj_get. Expected _p_lineObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (pointObj *)lineObj_get(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_pointObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_lineObj_add) {
    {
        lineObj *arg1 = (lineObj *) 0 ;
        pointObj *arg2 = (pointObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: lineObj_add(self,p);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_lineObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of lineObj_add. Expected _p_lineObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of lineObj_add. Expected _p_pointObj");
            }
        }
        result = (int)lineObj_add(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_lineObj_set) {
    {
        lineObj *arg1 = (lineObj *) 0 ;
        int arg2 ;
        pointObj *arg3 = (pointObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: lineObj_set(self,i,p);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_lineObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of lineObj_set. Expected _p_lineObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of lineObj_set. Expected _p_pointObj");
            }
        }
        result = (int)lineObj_set(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_numlines_get) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_numlines_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_numlines_get. Expected _p_shapeObj");
            }
        }
        result = (int) ((arg1)->numlines);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_numvalues_get) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_numvalues_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_numvalues_get. Expected _p_shapeObj");
            }
        }
        result = (int) ((arg1)->numvalues);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_line_get) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        lineObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_line_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_line_get. Expected _p_shapeObj");
            }
        }
        result = (lineObj *) ((arg1)->line);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_lineObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_values_get) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        char **result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_values_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_values_get. Expected _p_shapeObj");
            }
        }
        result = (char **) ((arg1)->values);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_p_char, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_bounds_set) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        rectObj *arg2 = (rectObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_bounds_set(self,bounds);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_bounds_set. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_bounds_set. Expected _p_rectObj");
            }
        }
        if (arg1) (arg1)->bounds = *arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_bounds_get) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        rectObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_bounds_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_bounds_get. Expected _p_shapeObj");
            }
        }
        result = (rectObj *)& ((arg1)->bounds);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_rectObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_type_set) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_type_set(self,type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_type_set. Expected _p_shapeObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->type = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_type_get) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_type_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_type_get. Expected _p_shapeObj");
            }
        }
        result = (int) ((arg1)->type);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_index_set) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        long arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_index_set(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_index_set. Expected _p_shapeObj");
            }
        }
        arg2 = (long) SvIV(ST(1));
        if (arg1) (arg1)->index = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_index_get) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        long result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_index_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_index_get. Expected _p_shapeObj");
            }
        }
        result = (long) ((arg1)->index);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_tileindex_set) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_tileindex_set(self,tileindex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_tileindex_set. Expected _p_shapeObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->tileindex = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_tileindex_get) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_tileindex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_tileindex_get. Expected _p_shapeObj");
            }
        }
        result = (int) ((arg1)->tileindex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_classindex_set) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_classindex_set(self,classindex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_classindex_set. Expected _p_shapeObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->classindex = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_classindex_get) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_classindex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_classindex_get. Expected _p_shapeObj");
            }
        }
        result = (int) ((arg1)->classindex);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_text_set) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_text_set(self,text);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_text_set. Expected _p_shapeObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->text) free((char*)arg1->text);
            if (arg2) {
                arg1->text = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->text,arg2);
            } else {
                arg1->text = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_text_get) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_text_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_text_get. Expected _p_shapeObj");
            }
        }
        result = (char *) ((arg1)->text);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_shapeObj) {
    {
        int arg1 = (int) MS_SHAPE_NULL ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 1)) {
            SWIG_croak("Usage: new_shapeObj(type);");
        }
        if (items > 0) {
            arg1 = (int) SvIV(ST(0));
        }
        result = (shapeObj *)new_shapeObj(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_shapeObj) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_shapeObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_shapeObj. Expected _p_shapeObj");
            }
        }
        delete_shapeObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_fromWKT) {
    {
        char *arg1 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_fromWKT(wkt);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (shapeObj *)shapeObj_fromWKT(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_project) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        projectionObj *arg2 = (projectionObj *) 0 ;
        projectionObj *arg3 = (projectionObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: shapeObj_project(self,projin,projout);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_project. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_projectionObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_project. Expected _p_projectionObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_projectionObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of shapeObj_project. Expected _p_projectionObj");
            }
        }
        result = (int)shapeObj_project(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_get) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int arg2 ;
        lineObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_get(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_get. Expected _p_shapeObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (lineObj *)shapeObj_get(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_lineObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_add) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        lineObj *arg2 = (lineObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_add(self,line);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_add. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_lineObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_add. Expected _p_lineObj");
            }
        }
        result = (int)shapeObj_add(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_draw) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        layerObj *arg3 = (layerObj *) 0 ;
        imageObj *arg4 = (imageObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: shapeObj_draw(self,map,layer,image);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_draw. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_draw. Expected _p_mapObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_layerObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of shapeObj_draw. Expected _p_layerObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 4 of shapeObj_draw. Expected _p_imageObj");
            }
        }
        result = (int)shapeObj_draw(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_setBounds) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_setBounds(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_setBounds. Expected _p_shapeObj");
            }
        }
        shapeObj_setBounds(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_clone) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_clone(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_clone. Expected _p_shapeObj");
            }
        }
        result = (shapeObj *)shapeObj_clone(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_copy) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_copy(self,dest);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_copy. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_copy. Expected _p_shapeObj");
            }
        }
        result = (int)shapeObj_copy(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_toWKT) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_toWKT(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_toWKT. Expected _p_shapeObj");
            }
        }
        result = (char *)shapeObj_toWKT(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_buffer) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        double arg2 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_buffer(self,width);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_buffer. Expected _p_shapeObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        result = (shapeObj *)shapeObj_buffer(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_convexHull) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_convexHull(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_convexHull. Expected _p_shapeObj");
            }
        }
        result = (shapeObj *)shapeObj_convexHull(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_boundary) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_boundary(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_boundary. Expected _p_shapeObj");
            }
        }
        result = (shapeObj *)shapeObj_boundary(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_getCentroid) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        pointObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_getCentroid(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_getCentroid. Expected _p_shapeObj");
            }
        }
        result = (pointObj *)shapeObj_getCentroid(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_pointObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_Union) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_Union(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_Union. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_Union. Expected _p_shapeObj");
            }
        }
        result = (shapeObj *)shapeObj_Union(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_intersection) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_intersection(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_intersection. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_intersection. Expected _p_shapeObj");
            }
        }
        result = (shapeObj *)shapeObj_intersection(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_difference) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_difference(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_difference. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_difference. Expected _p_shapeObj");
            }
        }
        result = (shapeObj *)shapeObj_difference(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_symDifference) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_symDifference(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_symDifference. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_symDifference. Expected _p_shapeObj");
            }
        }
        result = (shapeObj *)shapeObj_symDifference(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_contains__SWIG_0) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_contains(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_contains. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_contains. Expected _p_shapeObj");
            }
        }
        result = (int)shapeObj_contains__SWIG_0(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_overlaps) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_overlaps(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_overlaps. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_overlaps. Expected _p_shapeObj");
            }
        }
        result = (int)shapeObj_overlaps(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_within) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_within(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_within. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_within. Expected _p_shapeObj");
            }
        }
        result = (int)shapeObj_within(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_crosses) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_crosses(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_crosses. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_crosses. Expected _p_shapeObj");
            }
        }
        result = (int)shapeObj_crosses(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_intersects) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_intersects(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_intersects. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_intersects. Expected _p_shapeObj");
            }
        }
        result = (int)shapeObj_intersects(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_touches) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_touches(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_touches. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_touches. Expected _p_shapeObj");
            }
        }
        result = (int)shapeObj_touches(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_equals) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_equals(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_equals. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_equals. Expected _p_shapeObj");
            }
        }
        result = (int)shapeObj_equals(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_disjoint) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_disjoint(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_disjoint. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_disjoint. Expected _p_shapeObj");
            }
        }
        result = (int)shapeObj_disjoint(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_getArea) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_getArea(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_getArea. Expected _p_shapeObj");
            }
        }
        result = (double)shapeObj_getArea(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_getLength) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapeObj_getLength(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_getLength. Expected _p_shapeObj");
            }
        }
        result = (double)shapeObj_getLength(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_getValue) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_getValue(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_getValue. Expected _p_shapeObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (char *)shapeObj_getValue(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_contains__SWIG_1) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        pointObj *arg2 = (pointObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_contains(self,point);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_contains. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_contains. Expected _p_pointObj");
            }
        }
        result = (int)shapeObj_contains__SWIG_1(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_contains) {
    dXSARGS;
    
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_shapeObj, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, SWIGTYPE_p_shapeObj, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_shapeObj_contains__SWIG_0); return;
            }
        }
    }
    if (items == 2) {
        int _v;
        {
            void *tmp;
            if (SWIG_ConvertPtr(ST(0), (void **) &tmp, SWIGTYPE_p_shapeObj, 0) == -1) {
                _v = 0;
            } else {
                _v = 1;
            }
        }
        if (_v) {
            {
                void *tmp;
                if (SWIG_ConvertPtr(ST(1), (void **) &tmp, SWIGTYPE_p_pointObj, 0) == -1) {
                    _v = 0;
                } else {
                    _v = 1;
                }
            }
            if (_v) {
                (*PL_markstack_ptr++);SWIG_CALLXS(_wrap_shapeObj_contains__SWIG_1); return;
            }
        }
    }
    
    croak("No matching function for overloaded 'shapeObj_contains'");
    XSRETURN(0);
}


XS(_wrap_shapeObj_distanceToPoint) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        pointObj *arg2 = (pointObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_distanceToPoint(self,point);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_distanceToPoint. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_distanceToPoint. Expected _p_pointObj");
            }
        }
        result = (double)shapeObj_distanceToPoint(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_distanceToShape) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_distanceToShape(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_distanceToShape. Expected _p_shapeObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapeObj_distanceToShape. Expected _p_shapeObj");
            }
        }
        result = (double)shapeObj_distanceToShape(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_setValue) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int arg2 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: shapeObj_setValue(self,i,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_setValue. Expected _p_shapeObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)shapeObj_setValue(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapeObj_initValues) {
    {
        shapeObj *arg1 = (shapeObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapeObj_initValues(self,numvalues);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapeObj_initValues. Expected _p_shapeObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        shapeObj_initValues(arg1,arg2);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_fp_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        FILE *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_fp_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_fp_get. Expected _p_DBFInfo");
            }
        }
        result = (FILE *) ((arg1)->fp);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_FILE, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_nRecords_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_nRecords_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_nRecords_get. Expected _p_DBFInfo");
            }
        }
        result = (int) ((arg1)->nRecords);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_nRecordLength_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_nRecordLength_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_nRecordLength_get. Expected _p_DBFInfo");
            }
        }
        result = (int) ((arg1)->nRecordLength);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_nHeaderLength_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_nHeaderLength_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_nHeaderLength_get. Expected _p_DBFInfo");
            }
        }
        result = (int) ((arg1)->nHeaderLength);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_nFields_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_nFields_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_nFields_get. Expected _p_DBFInfo");
            }
        }
        result = (int) ((arg1)->nFields);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_panFieldOffset_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_panFieldOffset_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_panFieldOffset_get. Expected _p_DBFInfo");
            }
        }
        result = (int *) ((arg1)->panFieldOffset);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_int, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_panFieldSize_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_panFieldSize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_panFieldSize_get. Expected _p_DBFInfo");
            }
        }
        result = (int *) ((arg1)->panFieldSize);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_int, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_panFieldDecimals_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_panFieldDecimals_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_panFieldDecimals_get. Expected _p_DBFInfo");
            }
        }
        result = (int *) ((arg1)->panFieldDecimals);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_int, 0|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_pachFieldType_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_pachFieldType_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_pachFieldType_get. Expected _p_DBFInfo");
            }
        }
        result = (char *) ((arg1)->pachFieldType);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_pszHeader_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_pszHeader_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_pszHeader_get. Expected _p_DBFInfo");
            }
        }
        result = (char *) ((arg1)->pszHeader);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_nCurrentRecord_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_nCurrentRecord_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_nCurrentRecord_get. Expected _p_DBFInfo");
            }
        }
        result = (int) ((arg1)->nCurrentRecord);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_bCurrentRecordModified_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_bCurrentRecordModified_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_bCurrentRecordModified_get. Expected _p_DBFInfo");
            }
        }
        result = (int) ((arg1)->bCurrentRecordModified);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_pszCurrentRecord_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_pszCurrentRecord_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_pszCurrentRecord_get. Expected _p_DBFInfo");
            }
        }
        result = (char *) ((arg1)->pszCurrentRecord);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_bNoHeader_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_bNoHeader_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_bNoHeader_get. Expected _p_DBFInfo");
            }
        }
        result = (int) ((arg1)->bNoHeader);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_bUpdated_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_bUpdated_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_bUpdated_get. Expected _p_DBFInfo");
            }
        }
        result = (int) ((arg1)->bUpdated);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_pszStringField_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_pszStringField_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_pszStringField_get. Expected _p_DBFInfo");
            }
        }
        result = (char *) ((arg1)->pszStringField);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_nStringFieldLen_get) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: DBFInfo_nStringFieldLen_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_nStringFieldLen_get. Expected _p_DBFInfo");
            }
        }
        result = (int) ((arg1)->nStringFieldLen);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_getFieldName) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DBFInfo_getFieldName(self,iField);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_getFieldName. Expected _p_DBFInfo");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (char *)DBFInfo_getFieldName(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_getFieldWidth) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DBFInfo_getFieldWidth(self,iField);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_getFieldWidth. Expected _p_DBFInfo");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)DBFInfo_getFieldWidth(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_getFieldDecimals) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DBFInfo_getFieldDecimals(self,iField);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_getFieldDecimals. Expected _p_DBFInfo");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)DBFInfo_getFieldDecimals(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_DBFInfo_getFieldType) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: DBFInfo_getFieldType(self,iField);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of DBFInfo_getFieldType. Expected _p_DBFInfo");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (int)DBFInfo_getFieldType(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_DBFInfo) {
    {
        DBFInfo *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_DBFInfo();");
        }
        result = (DBFInfo *)(DBFInfo *) calloc(1, sizeof(DBFInfo));
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_DBFInfo, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_DBFInfo) {
    {
        DBFInfo *arg1 = (DBFInfo *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_DBFInfo(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_DBFInfo,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_DBFInfo. Expected _p_DBFInfo");
            }
        }
        free((char *) arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_source_get) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapefileObj_source_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_source_get. Expected _p_shapefileObj");
            }
        }
        result = (char *)(char *) ((arg1)->source);
        
        ST(argvi) = sv_newmortal();
        sv_setpv((SV*)ST(argvi++),(char *) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_type_get) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapefileObj_type_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_type_get. Expected _p_shapefileObj");
            }
        }
        result = (int) ((arg1)->type);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_numshapes_get) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapefileObj_numshapes_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_numshapes_get. Expected _p_shapefileObj");
            }
        }
        result = (int) ((arg1)->numshapes);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_bounds_get) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        rectObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapefileObj_bounds_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_bounds_get. Expected _p_shapefileObj");
            }
        }
        result = (rectObj *)& ((arg1)->bounds);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_rectObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_lastshape_get) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapefileObj_lastshape_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_lastshape_get. Expected _p_shapefileObj");
            }
        }
        result = (int) ((arg1)->lastshape);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_status_get) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapefileObj_status_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_status_get. Expected _p_shapefileObj");
            }
        }
        result = (char *) ((arg1)->status);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_statusbounds_get) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        rectObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapefileObj_statusbounds_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_statusbounds_get. Expected _p_shapefileObj");
            }
        }
        result = (rectObj *)& ((arg1)->statusbounds);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_rectObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_isopen_get) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: shapefileObj_isopen_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_isopen_get. Expected _p_shapefileObj");
            }
        }
        result = (int) ((arg1)->isopen);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_shapefileObj) {
    {
        char *arg1 ;
        int arg2 = (int) -1 ;
        shapefileObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: new_shapefileObj(filename,type);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (items > 1) {
            arg2 = (int) SvIV(ST(1));
        }
        result = (shapefileObj *)new_shapefileObj(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapefileObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_shapefileObj) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_shapefileObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_shapefileObj. Expected _p_shapefileObj");
            }
        }
        delete_shapefileObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_get) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        int arg2 ;
        shapeObj *arg3 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: shapefileObj_get(self,i,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_get. Expected _p_shapefileObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of shapefileObj_get. Expected _p_shapeObj");
            }
        }
        result = (int)shapefileObj_get(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_getShape) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        int arg2 ;
        shapeObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapefileObj_getShape(self,i);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_getShape. Expected _p_shapefileObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (shapeObj *)shapefileObj_getShape(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_shapeObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_getPoint) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        int arg2 ;
        pointObj *arg3 = (pointObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: shapefileObj_getPoint(self,i,point);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_getPoint. Expected _p_shapefileObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of shapefileObj_getPoint. Expected _p_pointObj");
            }
        }
        result = (int)shapefileObj_getPoint(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_getTransformed) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        mapObj *arg2 = (mapObj *) 0 ;
        int arg3 ;
        shapeObj *arg4 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: shapefileObj_getTransformed(self,map,i,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_getTransformed. Expected _p_shapefileObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_mapObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapefileObj_getTransformed. Expected _p_mapObj");
            }
        }
        arg3 = (int) SvIV(ST(2));
        {
            if (SWIG_ConvertPtr(ST(3), (void **) &arg4, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 4 of shapefileObj_getTransformed. Expected _p_shapeObj");
            }
        }
        result = (int)shapefileObj_getTransformed(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_getExtent) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        int arg2 ;
        rectObj *arg3 = (rectObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: shapefileObj_getExtent(self,i,rect);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_getExtent. Expected _p_shapefileObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        {
            if (SWIG_ConvertPtr(ST(2), (void **) &arg3, SWIGTYPE_p_rectObj,0) < 0) {
                SWIG_croak("Type error in argument 3 of shapefileObj_getExtent. Expected _p_rectObj");
            }
        }
        shapefileObj_getExtent(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_add) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        shapeObj *arg2 = (shapeObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapefileObj_add(self,shape);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_add. Expected _p_shapefileObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_shapeObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapefileObj_add. Expected _p_shapeObj");
            }
        }
        result = (int)shapefileObj_add(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_shapefileObj_addPoint) {
    {
        shapefileObj *arg1 = (shapefileObj *) 0 ;
        pointObj *arg2 = (pointObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: shapefileObj_addPoint(self,point);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_shapefileObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of shapefileObj_addPoint. Expected _p_shapefileObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_pointObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of shapefileObj_addPoint. Expected _p_pointObj");
            }
        }
        result = (int)shapefileObj_addPoint(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_projectionObj_numargs_get) {
    {
        projectionObj *arg1 = (projectionObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: projectionObj_numargs_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_projectionObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of projectionObj_numargs_get. Expected _p_projectionObj");
            }
        }
        result = (int) ((arg1)->numargs);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_projectionObj) {
    {
        char *arg1 ;
        projectionObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: new_projectionObj(proj4);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (projectionObj *)new_projectionObj(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_projectionObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_projectionObj) {
    {
        projectionObj *arg1 = (projectionObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_projectionObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_projectionObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_projectionObj. Expected _p_projectionObj");
            }
        }
        delete_projectionObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_colorObj_pen_set) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: colorObj_pen_set(self,pen);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of colorObj_pen_set. Expected _p_colorObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->pen = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_colorObj_pen_get) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: colorObj_pen_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of colorObj_pen_get. Expected _p_colorObj");
            }
        }
        result = (int) ((arg1)->pen);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_colorObj_red_set) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: colorObj_red_set(self,red);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of colorObj_red_set. Expected _p_colorObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->red = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_colorObj_red_get) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: colorObj_red_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of colorObj_red_get. Expected _p_colorObj");
            }
        }
        result = (int) ((arg1)->red);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_colorObj_green_set) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: colorObj_green_set(self,green);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of colorObj_green_set. Expected _p_colorObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->green = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_colorObj_green_get) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: colorObj_green_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of colorObj_green_get. Expected _p_colorObj");
            }
        }
        result = (int) ((arg1)->green);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_colorObj_blue_set) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: colorObj_blue_set(self,blue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of colorObj_blue_set. Expected _p_colorObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->blue = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_colorObj_blue_get) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: colorObj_blue_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of colorObj_blue_get. Expected _p_colorObj");
            }
        }
        result = (int) ((arg1)->blue);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_colorObj) {
    {
        int arg1 = (int) 0 ;
        int arg2 = (int) 0 ;
        int arg3 = (int) 0 ;
        int arg4 = (int) MS_PEN_UNSET ;
        colorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 4)) {
            SWIG_croak("Usage: new_colorObj(red,green,blue,pen);");
        }
        if (items > 0) {
            arg1 = (int) SvIV(ST(0));
        }
        if (items > 1) {
            arg2 = (int) SvIV(ST(1));
        }
        if (items > 2) {
            arg3 = (int) SvIV(ST(2));
        }
        if (items > 3) {
            arg4 = (int) SvIV(ST(3));
        }
        result = (colorObj *)new_colorObj(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_colorObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_colorObj) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_colorObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_colorObj. Expected _p_colorObj");
            }
        }
        delete_colorObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_colorObj_setRGB) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        int arg2 ;
        int arg3 ;
        int arg4 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 4) || (items > 4)) {
            SWIG_croak("Usage: colorObj_setRGB(self,red,green,blue);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of colorObj_setRGB. Expected _p_colorObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (int) SvIV(ST(2));
        arg4 = (int) SvIV(ST(3));
        result = (int)colorObj_setRGB(arg1,arg2,arg3,arg4);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_colorObj_setHex) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: colorObj_setHex(self,psHexColor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of colorObj_setHex. Expected _p_colorObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)colorObj_setHex(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_colorObj_toHex) {
    {
        colorObj *arg1 = (colorObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: colorObj_toHex(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_colorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of colorObj_toHex. Expected _p_colorObj");
            }
        }
        result = (char *)colorObj_toHex(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        free(result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_name_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_name_set(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_name_set. Expected _p_symbolObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->name) free((char*)arg1->name);
            if (arg2) {
                arg1->name = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->name,arg2);
            } else {
                arg1->name = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_name_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_name_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_name_get. Expected _p_symbolObj");
            }
        }
        result = (char *) ((arg1)->name);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_type_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_type_set(self,type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_type_set. Expected _p_symbolObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->type = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_type_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_type_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_type_get. Expected _p_symbolObj");
            }
        }
        result = (int) ((arg1)->type);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_sizex_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_sizex_set(self,sizex);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_sizex_set. Expected _p_symbolObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->sizex = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_sizex_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_sizex_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_sizex_get. Expected _p_symbolObj");
            }
        }
        result = (double) ((arg1)->sizex);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_sizey_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_sizey_set(self,sizey);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_sizey_set. Expected _p_symbolObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->sizey = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_sizey_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_sizey_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_sizey_get. Expected _p_symbolObj");
            }
        }
        result = (double) ((arg1)->sizey);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_numpoints_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_numpoints_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_numpoints_get. Expected _p_symbolObj");
            }
        }
        result = (int) ((arg1)->numpoints);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_filled_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_filled_set(self,filled);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_filled_set. Expected _p_symbolObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->filled = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_filled_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_filled_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_filled_get. Expected _p_symbolObj");
            }
        }
        result = (int) ((arg1)->filled);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_stylelength_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_stylelength_set(self,stylelength);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_stylelength_set. Expected _p_symbolObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->stylelength = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_stylelength_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_stylelength_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_stylelength_get. Expected _p_symbolObj");
            }
        }
        result = (int) ((arg1)->stylelength);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_style_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_style_set(self,style);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_style_set. Expected _p_symbolObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_int,0) < 0) {
                SWIG_croak("Type error in argument 2 of symbolObj_style_set. Expected _p_int");
            }
        }
        {
            int ii;
            int *b = (int *) arg1->style;
            for (ii = 0; ii < 10; ii++) b[ii] = *((int *) arg2 + ii);
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_style_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_style_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_style_get. Expected _p_symbolObj");
            }
        }
        result = (int *)(int *) ((arg1)->style);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_int, 0|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_imagepath_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_imagepath_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_imagepath_get. Expected _p_symbolObj");
            }
        }
        result = (char *) ((arg1)->imagepath);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_transparent_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_transparent_set(self,transparent);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_transparent_set. Expected _p_symbolObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->transparent = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_transparent_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_transparent_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_transparent_get. Expected _p_symbolObj");
            }
        }
        result = (int) ((arg1)->transparent);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_transparentcolor_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_transparentcolor_set(self,transparentcolor);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_transparentcolor_set. Expected _p_symbolObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->transparentcolor = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_transparentcolor_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_transparentcolor_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_transparentcolor_get. Expected _p_symbolObj");
            }
        }
        result = (int) ((arg1)->transparentcolor);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_character_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_character_set(self,character);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_character_set. Expected _p_symbolObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->character) free((char*)arg1->character);
            if (arg2) {
                arg1->character = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->character,arg2);
            } else {
                arg1->character = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_character_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_character_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_character_get. Expected _p_symbolObj");
            }
        }
        result = (char *) ((arg1)->character);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_antialias_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_antialias_set(self,antialias);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_antialias_set. Expected _p_symbolObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->antialias = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_antialias_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_antialias_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_antialias_get. Expected _p_symbolObj");
            }
        }
        result = (int) ((arg1)->antialias);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_font_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_font_set(self,font);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_font_set. Expected _p_symbolObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->font) free((char*)arg1->font);
            if (arg2) {
                arg1->font = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->font,arg2);
            } else {
                arg1->font = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_font_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_font_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_font_get. Expected _p_symbolObj");
            }
        }
        result = (char *) ((arg1)->font);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_gap_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_gap_set(self,gap);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_gap_set. Expected _p_symbolObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->gap = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_gap_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_gap_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_gap_get. Expected _p_symbolObj");
            }
        }
        result = (int) ((arg1)->gap);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_position_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_position_set(self,position);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_position_set. Expected _p_symbolObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->position = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_position_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_position_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_position_get. Expected _p_symbolObj");
            }
        }
        result = (int) ((arg1)->position);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_linecap_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_linecap_set(self,linecap);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_linecap_set. Expected _p_symbolObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->linecap = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_linecap_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_linecap_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_linecap_get. Expected _p_symbolObj");
            }
        }
        result = (int) ((arg1)->linecap);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_linejoin_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_linejoin_set(self,linejoin);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_linejoin_set. Expected _p_symbolObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->linejoin = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_linejoin_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_linejoin_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_linejoin_get. Expected _p_symbolObj");
            }
        }
        result = (int) ((arg1)->linejoin);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_linejoinmaxsize_set) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        double arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_linejoinmaxsize_set(self,linejoinmaxsize);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_linejoinmaxsize_set. Expected _p_symbolObj");
            }
        }
        arg2 = (double) SvNV(ST(1));
        
        if (arg1) (arg1)->linejoinmaxsize = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_linejoinmaxsize_get) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        double result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_linejoinmaxsize_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_linejoinmaxsize_get. Expected _p_symbolObj");
            }
        }
        result = (double) ((arg1)->linejoinmaxsize);
        
        ST(argvi) = sv_newmortal();
        sv_setnv(ST(argvi++), (double) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_symbolObj) {
    {
        char *arg1 ;
        char *arg2 = (char *) NULL ;
        symbolObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: new_symbolObj(symbolname,imagefile);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        if (items > 1) {
            if (!SvOK((SV*) ST(1))) arg2 = 0;
            else arg2 = (char *) SvPV(ST(1), PL_na);
        }
        result = (symbolObj *)new_symbolObj(arg1,(char const *)arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_symbolObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_symbolObj) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_symbolObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_symbolObj. Expected _p_symbolObj");
            }
        }
        delete_symbolObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_setImagepath) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_setImagepath(self,imagefile);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_setImagepath. Expected _p_symbolObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)symbolObj_setImagepath(arg1,(char const *)arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_setPoints) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        lineObj *arg2 = (lineObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_setPoints(self,line);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_setPoints. Expected _p_symbolObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_lineObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of symbolObj_setPoints. Expected _p_lineObj");
            }
        }
        result = (int)symbolObj_setPoints(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_getPoints) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        lineObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: symbolObj_getPoints(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_getPoints. Expected _p_symbolObj");
            }
        }
        result = (lineObj *)symbolObj_getPoints(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_lineObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_setStyle) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        int arg2 ;
        int arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: symbolObj_setStyle(self,index,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_setStyle. Expected _p_symbolObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        arg3 = (int) SvIV(ST(2));
        result = (int)symbolObj_setStyle(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_getImage) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        outputFormatObj *arg2 = (outputFormatObj *) 0 ;
        imageObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_getImage(self,format);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_getImage. Expected _p_symbolObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_outputFormatObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of symbolObj_getImage. Expected _p_outputFormatObj");
            }
        }
        result = (imageObj *)symbolObj_getImage(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_imageObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_symbolObj_setImage) {
    {
        symbolObj *arg1 = (symbolObj *) 0 ;
        imageObj *arg2 = (imageObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: symbolObj_setImage(self,image);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_symbolObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of symbolObj_setImage. Expected _p_symbolObj");
            }
        }
        {
            if (SWIG_ConvertPtr(ST(1), (void **) &arg2, SWIGTYPE_p_imageObj,0) < 0) {
                SWIG_croak("Type error in argument 2 of symbolObj_setImage. Expected _p_imageObj");
            }
        }
        result = (int)symbolObj_setImage(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_errorObj_code_set) {
    {
        errorObj *arg1 = (errorObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: errorObj_code_set(self,code);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_errorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of errorObj_code_set. Expected _p_errorObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->code = arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_errorObj_code_get) {
    {
        errorObj *arg1 = (errorObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: errorObj_code_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_errorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of errorObj_code_get. Expected _p_errorObj");
            }
        }
        result = (int) ((arg1)->code);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_errorObj_routine_set) {
    {
        errorObj *arg1 = (errorObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: errorObj_routine_set(self,routine);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_errorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of errorObj_routine_set. Expected _p_errorObj");
            }
        }
        arg2 = SvPV(ST(1),PL_na);
        
        {
            if (arg2) strncpy(arg1->routine,arg2,64);
            else arg1->routine[0] = 0;
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_errorObj_routine_get) {
    {
        errorObj *arg1 = (errorObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: errorObj_routine_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_errorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of errorObj_routine_get. Expected _p_errorObj");
            }
        }
        result = (char *)(char *) ((arg1)->routine);
        
        ST(argvi) = sv_newmortal();
        sv_setpv((SV*)ST(argvi++),(char *) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_errorObj_message_set) {
    {
        errorObj *arg1 = (errorObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: errorObj_message_set(self,message);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_errorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of errorObj_message_set. Expected _p_errorObj");
            }
        }
        arg2 = SvPV(ST(1),PL_na);
        
        {
            if (arg2) strncpy(arg1->message,arg2,2048);
            else arg1->message[0] = 0;
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_errorObj_message_get) {
    {
        errorObj *arg1 = (errorObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: errorObj_message_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_errorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of errorObj_message_get. Expected _p_errorObj");
            }
        }
        result = (char *)(char *) ((arg1)->message);
        
        ST(argvi) = sv_newmortal();
        sv_setpv((SV*)ST(argvi++),(char *) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_errorObj) {
    {
        errorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_errorObj();");
        }
        result = (errorObj *)new_errorObj();
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_errorObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_errorObj) {
    {
        errorObj *arg1 = (errorObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_errorObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_errorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_errorObj. Expected _p_errorObj");
            }
        }
        delete_errorObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_errorObj_next) {
    {
        errorObj *arg1 = (errorObj *) 0 ;
        errorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: errorObj_next(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_errorObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of errorObj_next. Expected _p_errorObj");
            }
        }
        result = (errorObj *)errorObj_next(arg1);
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_errorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msGetErrorObj) {
    {
        errorObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msGetErrorObj();");
        }
        result = (errorObj *)msGetErrorObj();
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_errorObj, SWIG_SHADOW|0);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msResetErrorList) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msResetErrorList();");
        }
        msResetErrorList();
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msGetVersion) {
    {
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msGetVersion();");
        }
        result = (char *)msGetVersion();
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msGetErrorString) {
    {
        char *arg1 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: msGetErrorString(delimiter);");
        }
        if (!SvOK((SV*) ST(0))) arg1 = 0;
        else arg1 = (char *) SvPV(ST(0), PL_na);
        result = (char *)msGetErrorString(arg1);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_hashTableObj_numitems_get) {
    {
        hashTableObj *arg1 = (hashTableObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: hashTableObj_numitems_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_hashTableObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of hashTableObj_numitems_get. Expected _p_hashTableObj");
            }
        }
        result = (int) ((arg1)->numitems);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_hashTableObj) {
    {
        hashTableObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_hashTableObj();");
        }
        result = (hashTableObj *)new_hashTableObj();
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_hashTableObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_hashTableObj) {
    {
        hashTableObj *arg1 = (hashTableObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_hashTableObj(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_hashTableObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_hashTableObj. Expected _p_hashTableObj");
            }
        }
        delete_hashTableObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_hashTableObj_set) {
    {
        hashTableObj *arg1 = (hashTableObj *) 0 ;
        char *arg2 ;
        char *arg3 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: hashTableObj_set(self,key,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_hashTableObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of hashTableObj_set. Expected _p_hashTableObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        result = (int)hashTableObj_set(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_hashTableObj_get) {
    {
        hashTableObj *arg1 = (hashTableObj *) 0 ;
        char *arg2 ;
        char *arg3 = (char *) NULL ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 3)) {
            SWIG_croak("Usage: hashTableObj_get(self,key,default_value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_hashTableObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of hashTableObj_get. Expected _p_hashTableObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (items > 2) {
            if (!SvOK((SV*) ST(2))) arg3 = 0;
            else arg3 = (char *) SvPV(ST(2), PL_na);
        }
        result = (char *)hashTableObj_get(arg1,arg2,arg3);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_hashTableObj_remove) {
    {
        hashTableObj *arg1 = (hashTableObj *) 0 ;
        char *arg2 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: hashTableObj_remove(self,key);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_hashTableObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of hashTableObj_remove. Expected _p_hashTableObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (int)hashTableObj_remove(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_hashTableObj_clear) {
    {
        hashTableObj *arg1 = (hashTableObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: hashTableObj_clear(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_hashTableObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of hashTableObj_clear. Expected _p_hashTableObj");
            }
        }
        hashTableObj_clear(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_hashTableObj_nextKey) {
    {
        hashTableObj *arg1 = (hashTableObj *) 0 ;
        char *arg2 = (char *) NULL ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 2)) {
            SWIG_croak("Usage: hashTableObj_nextKey(self,prevkey);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_hashTableObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of hashTableObj_nextKey. Expected _p_hashTableObj");
            }
        }
        if (items > 1) {
            if (!SvOK((SV*) ST(1))) arg2 = 0;
            else arg2 = (char *) SvPV(ST(1), PL_na);
        }
        result = (char *)hashTableObj_nextKey(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_NumParams_get) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: OWSRequest_NumParams_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_NumParams_get. Expected _p_cgiRequestObj");
            }
        }
        result = (int) ((arg1)->NumParams);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_type_set) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        int arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: OWSRequest_type_set(self,type);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_type_set. Expected _p_cgiRequestObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        if (arg1) (arg1)->type = (enum MS_REQUEST_TYPE)arg2;
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_type_get) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: OWSRequest_type_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_type_get. Expected _p_cgiRequestObj");
            }
        }
        result = (int) ((arg1)->type);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_contenttype_set) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: OWSRequest_contenttype_set(self,contenttype);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_contenttype_set. Expected _p_cgiRequestObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->contenttype) free((char*)arg1->contenttype);
            if (arg2) {
                arg1->contenttype = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->contenttype,arg2);
            } else {
                arg1->contenttype = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_contenttype_get) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: OWSRequest_contenttype_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_contenttype_get. Expected _p_cgiRequestObj");
            }
        }
        result = (char *) ((arg1)->contenttype);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_postrequest_set) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        char *arg2 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: OWSRequest_postrequest_set(self,postrequest);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_postrequest_set. Expected _p_cgiRequestObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        {
            if (arg1->postrequest) free((char*)arg1->postrequest);
            if (arg2) {
                arg1->postrequest = (char *) malloc(strlen(arg2)+1);
                strcpy((char*)arg1->postrequest,arg2);
            } else {
                arg1->postrequest = 0;
            }
        }
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_postrequest_get) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: OWSRequest_postrequest_get(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_postrequest_get. Expected _p_cgiRequestObj");
            }
        }
        result = (char *) ((arg1)->postrequest);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_new_OWSRequest) {
    {
        cgiRequestObj *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: new_OWSRequest();");
        }
        result = (cgiRequestObj *)new_cgiRequestObj();
        
        ST(argvi) = sv_newmortal();
        SWIG_MakePtr(ST(argvi++), (void *) result, SWIGTYPE_p_cgiRequestObj, SWIG_SHADOW|SWIG_OWNER);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_delete_OWSRequest) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: delete_OWSRequest(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of delete_OWSRequest. Expected _p_cgiRequestObj");
            }
        }
        delete_cgiRequestObj(arg1);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_loadParams) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        int result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 1) || (items > 1)) {
            SWIG_croak("Usage: OWSRequest_loadParams(self);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_loadParams. Expected _p_cgiRequestObj");
            }
        }
        result = (int)cgiRequestObj_loadParams(arg1);
        
        ST(argvi) = sv_newmortal();
        sv_setiv(ST(argvi++), (IV) result);
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_setParameter) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        char *arg2 ;
        char *arg3 ;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 3) || (items > 3)) {
            SWIG_croak("Usage: OWSRequest_setParameter(self,name,value);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_setParameter. Expected _p_cgiRequestObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        if (!SvOK((SV*) ST(2))) arg3 = 0;
        else arg3 = (char *) SvPV(ST(2), PL_na);
        cgiRequestObj_setParameter(arg1,arg2,arg3);
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_getName) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        int arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: OWSRequest_getName(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_getName. Expected _p_cgiRequestObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (char *)cgiRequestObj_getName(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_getValue) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        int arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: OWSRequest_getValue(self,index);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_getValue. Expected _p_cgiRequestObj");
            }
        }
        arg2 = (int) SvIV(ST(1));
        result = (char *)cgiRequestObj_getValue(arg1,arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_OWSRequest_getValueByName) {
    {
        cgiRequestObj *arg1 = (cgiRequestObj *) 0 ;
        char *arg2 ;
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 2) || (items > 2)) {
            SWIG_croak("Usage: OWSRequest_getValueByName(self,name);");
        }
        {
            if (SWIG_ConvertPtr(ST(0), (void **) &arg1, SWIGTYPE_p_cgiRequestObj,0) < 0) {
                SWIG_croak("Type error in argument 1 of OWSRequest_getValueByName. Expected _p_cgiRequestObj");
            }
        }
        if (!SvOK((SV*) ST(1))) arg2 = 0;
        else arg2 = (char *) SvPV(ST(1), PL_na);
        result = (char *)cgiRequestObj_getValueByName(arg1,(char const *)arg2);
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msConnPoolCloseUnreferenced) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msConnPoolCloseUnreferenced();");
        }
        msConnPoolCloseUnreferenced();
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msIO_resetHandlers) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msIO_resetHandlers();");
        }
        msIO_resetHandlers();
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msIO_installStdoutToBuffer) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msIO_installStdoutToBuffer();");
        }
        msIO_installStdoutToBuffer();
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msIO_installStdinFromBuffer) {
    {
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msIO_installStdinFromBuffer();");
        }
        msIO_installStdinFromBuffer();
        
        
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msIO_stripStdoutBufferContentType) {
    {
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msIO_stripStdoutBufferContentType();");
        }
        result = (char *)msIO_stripStdoutBufferContentType();
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msIO_getStdoutBufferString) {
    {
        char *result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msIO_getStdoutBufferString();");
        }
        result = (char *)msIO_getStdoutBufferString();
        
        ST(argvi) = sv_newmortal();
        if (result) {
            sv_setpv((SV*)ST(argvi++), (char *) result);
        } else {
            sv_setsv((SV*)ST(argvi++), &PL_sv_undef);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}


XS(_wrap_msIO_getStdoutBufferBytes) {
    {
        gdBuffer result;
        int argvi = 0;
        dXSARGS;
        
        if ((items < 0) || (items > 0)) {
            SWIG_croak("Usage: msIO_getStdoutBufferBytes();");
        }
        result = msIO_getStdoutBufferBytes();
        
        {
            gdBuffer * resultobj = (gdBuffer *) malloc(sizeof(gdBuffer));
            memmove(resultobj, &result, sizeof(gdBuffer));
            ST(argvi) = sv_newmortal();
            SWIG_MakePtr(ST(argvi++), (void *) resultobj, SWIGTYPE_p_gdBuffer, 0|SWIG_OWNER);
        }
        XSRETURN(argvi);
        fail:
        ;
    }
    croak(Nullch);
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static void *_p_intarrayTo_p_int(void *x) {
    return (void *)((int *)  ((intarray *) x));
}
static swig_type_info _swigt__p_resultCacheMemberObj[] = {{"mapscript::resultCacheMemberObj", 0, "resultCacheMemberObj *", 0},{"mapscript::resultCacheMemberObj"},{0}};
static swig_type_info _swigt__p_markerCacheMemberObj[] = {{"mapscript::markerCacheMemberObj", 0, "markerCacheMemberObj *", 0},{"mapscript::markerCacheMemberObj"},{0}};
static swig_type_info _swigt__p_labelCacheMemberObj[] = {{"mapscript::labelCacheMemberObj", 0, "labelCacheMemberObj *", 0},{"mapscript::labelCacheMemberObj"},{0}};
static swig_type_info _swigt__p_layer_obj[] = {{"_p_layer_obj", 0, "struct layer_obj *", 0},{"_p_layer_obj"},{"mapscript::layerObj"},{0}};
static swig_type_info _swigt__p_lineObj[] = {{"mapscript::lineObj", 0, "lineObj *", 0},{"mapscript::lineObj"},{0}};
static swig_type_info _swigt__p_pointObj[] = {{"mapscript::pointObj", 0, "pointObj *", 0},{"mapscript::pointObj"},{0}};
static swig_type_info _swigt__p_map_obj[] = {{"_p_map_obj", 0, "struct map_obj *", 0},{"_p_map_obj"},{"mapscript::mapObj"},{0}};
static swig_type_info _swigt__p_p_char[] = {{"_p_p_char", 0, "char **", 0},{"_p_p_char"},{0}};
static swig_type_info _swigt__p_mapObj[] = {{"mapscript::mapObj", 0, "mapObj *", 0},{"_p_map_obj"},{"mapscript::mapObj"},{0}};
static swig_type_info _swigt__p_resultCacheObj[] = {{"mapscript::resultCacheObj", 0, "resultCacheObj *", 0},{"mapscript::resultCacheObj"},{0}};
static swig_type_info _swigt__p_labelCacheObj[] = {{"mapscript::labelCacheObj", 0, "labelCacheObj *", 0},{"mapscript::labelCacheObj"},{0}};
static swig_type_info _swigt__p_char[] = {{"_p_char", 0, "char *", 0},{"_p_char"},{0}};
static swig_type_info _swigt__p_imageObj[] = {{"mapscript::imageObj", 0, "imageObj *", 0},{"mapscript::imageObj"},{0}};
static swig_type_info _swigt__p_hashTableObj[] = {{"mapscript::hashTableObj", 0, "hashTableObj *", 0},{"mapscript::hashTableObj"},{0}};
static swig_type_info _swigt__p_gdBuffer[] = {{"_p_gdBuffer", 0, "gdBuffer *", 0},{"_p_gdBuffer"},{0}};
static swig_type_info _swigt__p_symbolObj[] = {{"mapscript::symbolObj", 0, "symbolObj *", 0},{"mapscript::symbolObj"},{0}};
static swig_type_info _swigt__p_shapefileObj[] = {{"mapscript::shapefileObj", 0, "shapefileObj *", 0},{"mapscript::shapefileObj"},{0}};
static swig_type_info _swigt__p_labelObj[] = {{"mapscript::labelObj", 0, "labelObj *", 0},{"mapscript::labelObj"},{0}};
static swig_type_info _swigt__p_colorObj[] = {{"mapscript::colorObj", 0, "colorObj *", 0},{"mapscript::colorObj"},{0}};
static swig_type_info _swigt__p_cgiRequestObj[] = {{"mapscript::OWSRequest", 0, "cgiRequestObj *", 0},{"mapscript::OWSRequest"},{0}};
static swig_type_info _swigt__p_rectObj[] = {{"mapscript::rectObj", 0, "rectObj *", 0},{"mapscript::rectObj"},{0}};
static swig_type_info _swigt__p_webObj[] = {{"mapscript::webObj", 0, "webObj *", 0},{"mapscript::webObj"},{0}};
static swig_type_info _swigt__p_DBFInfo[] = {{"mapscript::DBFInfo", 0, "DBFInfo *", 0},{"mapscript::DBFInfo"},{0}};
static swig_type_info _swigt__p_layerObj[] = {{"mapscript::layerObj", 0, "layerObj *", 0},{"_p_layer_obj"},{"mapscript::layerObj"},{0}};
static swig_type_info _swigt__p_scalebarObj[] = {{"mapscript::scalebarObj", 0, "scalebarObj *", 0},{"mapscript::scalebarObj"},{0}};
static swig_type_info _swigt__p_referenceMapObj[] = {{"mapscript::referenceMapObj", 0, "referenceMapObj *", 0},{"mapscript::referenceMapObj"},{0}};
static swig_type_info _swigt__p_queryMapObj[] = {{"mapscript::queryMapObj", 0, "queryMapObj *", 0},{"mapscript::queryMapObj"},{0}};
static swig_type_info _swigt__p_symbolSetObj[] = {{"mapscript::symbolSetObj", 0, "symbolSetObj *", 0},{"mapscript::symbolSetObj"},{0}};
static swig_type_info _swigt__p_fontSetObj[] = {{"mapscript::fontSetObj", 0, "fontSetObj *", 0},{"mapscript::fontSetObj"},{0}};
static swig_type_info _swigt__p_shapeObj[] = {{"mapscript::shapeObj", 0, "shapeObj *", 0},{"mapscript::shapeObj"},{0}};
static swig_type_info _swigt__p_projectionObj[] = {{"mapscript::projectionObj", 0, "projectionObj *", 0},{"mapscript::projectionObj"},{0}};
static swig_type_info _swigt__p_intarray[] = {{"mapscript::intarray", 0, "intarray *", 0},{"mapscript::intarray"},{0}};
static swig_type_info _swigt__p_FILE[] = {{"_p_FILE", 0, "FILE *", 0},{"_p_FILE"},{0}};
static swig_type_info _swigt__p_classObj[] = {{"mapscript::classObj", 0, "classObj *", 0},{"mapscript::classObj"},{0}};
static swig_type_info _swigt__p_errorObj[] = {{"mapscript::errorObj", 0, "errorObj *", 0},{"mapscript::errorObj"},{0}};
static swig_type_info _swigt__p_int[] = {{"_p_int", 0, "int *", 0},{"_p_int"},{"mapscript::intarray", _p_intarrayTo_p_int},{0}};
static swig_type_info _swigt__p_styleObj[] = {{"mapscript::styleObj", 0, "styleObj *", 0},{"mapscript::styleObj"},{0}};
static swig_type_info _swigt__p_labelPathObj[] = {{"_p_labelPathObj", 0, "labelPathObj *", 0},{"_p_labelPathObj"},{0}};
static swig_type_info _swigt__p_p_outputFormatObj[] = {{"_p_p_outputFormatObj", 0, "outputFormatObj **", 0},{"_p_p_outputFormatObj"},{0}};
static swig_type_info _swigt__p_outputFormatObj[] = {{"mapscript::outputFormatObj", 0, "outputFormatObj *", 0},{"mapscript::outputFormatObj"},{0}};
static swig_type_info _swigt__p_legendObj[] = {{"mapscript::legendObj", 0, "legendObj *", 0},{"mapscript::legendObj"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_resultCacheMemberObj, 
_swigt__p_markerCacheMemberObj, 
_swigt__p_labelCacheMemberObj, 
_swigt__p_layer_obj, 
_swigt__p_lineObj, 
_swigt__p_pointObj, 
_swigt__p_map_obj, 
_swigt__p_p_char, 
_swigt__p_mapObj, 
_swigt__p_resultCacheObj, 
_swigt__p_labelCacheObj, 
_swigt__p_char, 
_swigt__p_imageObj, 
_swigt__p_hashTableObj, 
_swigt__p_gdBuffer, 
_swigt__p_symbolObj, 
_swigt__p_shapefileObj, 
_swigt__p_labelObj, 
_swigt__p_colorObj, 
_swigt__p_cgiRequestObj, 
_swigt__p_rectObj, 
_swigt__p_webObj, 
_swigt__p_DBFInfo, 
_swigt__p_layerObj, 
_swigt__p_scalebarObj, 
_swigt__p_referenceMapObj, 
_swigt__p_queryMapObj, 
_swigt__p_symbolSetObj, 
_swigt__p_fontSetObj, 
_swigt__p_shapeObj, 
_swigt__p_projectionObj, 
_swigt__p_intarray, 
_swigt__p_FILE, 
_swigt__p_classObj, 
_swigt__p_errorObj, 
_swigt__p_int, 
_swigt__p_styleObj, 
_swigt__p_labelPathObj, 
_swigt__p_p_outputFormatObj, 
_swigt__p_outputFormatObj, 
_swigt__p_legendObj, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

static swig_constant_info swig_constants[] = {
{ SWIG_STRING,  (char *) SWIG_prefix "MS_VERSION", 0, 0, (void *)"4.10.0", 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_TRUE", (long) 1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_FALSE", (long) 0, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_ON", (long) 1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_OFF", (long) 0, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_DEFAULT", (long) 2, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_EMBED", (long) 3, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_DELETE", (long) 4, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_YES", (long) 1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_NO", (long) 0, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SINGLE", (long) 0, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MULTIPLE", (long) 1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_GD_ALPHA", (long) 1000, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MAXCLASSES", (long) 250, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MAXSTYLES", (long) 5, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MAXLAYERS", (long) 200, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_FILE_MAP", (long) MS_FILE_MAP, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_FILE_SYMBOL", (long) MS_FILE_SYMBOL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_INCHES", (long) MS_INCHES, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_FEET", (long) MS_FEET, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MILES", (long) MS_MILES, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_METERS", (long) MS_METERS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_KILOMETERS", (long) MS_KILOMETERS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_DD", (long) MS_DD, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_PIXELS", (long) MS_PIXELS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_PERCENTAGES", (long) MS_PERCENTAGES, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHAPE_POINT", (long) MS_SHAPE_POINT, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHAPE_LINE", (long) MS_SHAPE_LINE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHAPE_POLYGON", (long) MS_SHAPE_POLYGON, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHAPE_NULL", (long) MS_SHAPE_NULL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LAYER_POINT", (long) MS_LAYER_POINT, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LAYER_LINE", (long) MS_LAYER_LINE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LAYER_POLYGON", (long) MS_LAYER_POLYGON, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LAYER_RASTER", (long) MS_LAYER_RASTER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LAYER_ANNOTATION", (long) MS_LAYER_ANNOTATION, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LAYER_QUERY", (long) MS_LAYER_QUERY, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LAYER_CIRCLE", (long) MS_LAYER_CIRCLE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LAYER_TILEINDEX", (long) MS_LAYER_TILEINDEX, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_TRUETYPE", (long) MS_TRUETYPE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_BITMAP", (long) MS_BITMAP, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_POSITIONS_LENGTH", (long) 12, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_UL", (long) MS_UL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LR", (long) MS_LR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_UR", (long) MS_UR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LL", (long) MS_LL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CR", (long) MS_CR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CL", (long) MS_CL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_UC", (long) MS_UC, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LC", (long) MS_LC, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CC", (long) MS_CC, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_AUTO", (long) MS_AUTO, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_XY", (long) MS_XY, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_FOLLOW", (long) MS_FOLLOW, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_TINY", (long) MS_TINY, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SMALL", (long) MS_SMALL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MEDIUM", (long) MS_MEDIUM, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_LARGE", (long) MS_LARGE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_GIANT", (long) MS_GIANT, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_NORMAL", (long) MS_NORMAL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_HILITE", (long) MS_HILITE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SELECTED", (long) MS_SELECTED, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_INLINE", (long) MS_INLINE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHAPEFILE", (long) MS_SHAPEFILE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_TILED_SHAPEFILE", (long) MS_TILED_SHAPEFILE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SDE", (long) MS_SDE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_OGR", (long) MS_OGR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_UNUSED_1", (long) MS_UNUSED_1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_POSTGIS", (long) MS_POSTGIS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_WMS", (long) MS_WMS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_ORACLESPATIAL", (long) MS_ORACLESPATIAL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_WFS", (long) MS_WFS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_GRATICULE", (long) MS_GRATICULE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MYGIS", (long) MS_MYGIS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_RASTER", (long) MS_RASTER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_PLUGIN", (long) MS_PLUGIN, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_DB_XBASE", (long) MS_DB_XBASE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_DB_CSV", (long) MS_DB_CSV, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_DB_MYSQL", (long) MS_DB_MYSQL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_DB_ORACLE", (long) MS_DB_ORACLE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_DB_POSTGRES", (long) MS_DB_POSTGRES, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_JOIN_ONE_TO_ONE", (long) MS_JOIN_ONE_TO_ONE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_JOIN_ONE_TO_MANY", (long) MS_JOIN_ONE_TO_MANY, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CJC_NONE", (long) MS_CJC_NONE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CJC_BEVEL", (long) MS_CJC_BEVEL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CJC_BUTT", (long) MS_CJC_BUTT, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CJC_MITER", (long) MS_CJC_MITER, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CJC_ROUND", (long) MS_CJC_ROUND, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CJC_SQUARE", (long) MS_CJC_SQUARE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CJC_TRIANGLE", (long) MS_CJC_TRIANGLE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SUCCESS", (long) MS_SUCCESS, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_FAILURE", (long) MS_FAILURE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_DONE", (long) MS_DONE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_IMAGEMODE_PC256", (long) MS_IMAGEMODE_PC256, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_IMAGEMODE_RGB", (long) MS_IMAGEMODE_RGB, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_IMAGEMODE_RGBA", (long) MS_IMAGEMODE_RGBA, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_IMAGEMODE_INT16", (long) MS_IMAGEMODE_INT16, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_IMAGEMODE_FLOAT32", (long) MS_IMAGEMODE_FLOAT32, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_IMAGEMODE_BYTE", (long) MS_IMAGEMODE_BYTE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_IMAGEMODE_NULL", (long) MS_IMAGEMODE_NULL, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_NOOVERRIDE", (long) -1111, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHAPEFILE_POINT", (long) 1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHAPEFILE_ARC", (long) 3, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHAPEFILE_POLYGON", (long) 5, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHAPEFILE_MULTIPOINT", (long) 8, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHP_POINTZ", (long) 11, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHP_ARCZ", (long) 13, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHP_POLYGONZ", (long) 15, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHP_MULTIPOINTZ", (long) 18, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHP_POINTM", (long) 21, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHP_ARCM", (long) 23, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHP_POLYGONM", (long) 25, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHP_MULTIPOINTM", (long) 28, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FTString", (long) FTString, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FTInteger", (long) FTInteger, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FTDouble", (long) FTDouble, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "FTInvalid", (long) FTInvalid, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SYMBOL_SIMPLE", (long) MS_SYMBOL_SIMPLE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SYMBOL_VECTOR", (long) MS_SYMBOL_VECTOR, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SYMBOL_ELLIPSE", (long) MS_SYMBOL_ELLIPSE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SYMBOL_PIXMAP", (long) MS_SYMBOL_PIXMAP, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SYMBOL_TRUETYPE", (long) MS_SYMBOL_TRUETYPE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SYMBOL_CARTOLINE", (long) MS_SYMBOL_CARTOLINE, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SYMBOL_HATCH", (long) MS_SYMBOL_HATCH, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MAXSYMBOLS", (long) 64, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MAXVECTORPOINTS", (long) 100, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MAXSTYLELENGTH", (long) 10, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_IMAGECACHESIZE", (long) 6, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_NOERR", (long) 0, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_IOERR", (long) 1, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MEMERR", (long) 2, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_TYPEERR", (long) 3, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SYMERR", (long) 4, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_REGEXERR", (long) 5, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_TTFERR", (long) 6, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_DBFERR", (long) 7, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_GDERR", (long) 8, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_IDENTERR", (long) 9, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_EOFERR", (long) 10, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_PROJERR", (long) 11, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MISCERR", (long) 12, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CGIERR", (long) 13, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_WEBERR", (long) 14, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_IMGERR", (long) 15, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_HASHERR", (long) 16, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_JOINERR", (long) 17, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_NOTFOUND", (long) 18, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SHPERR", (long) 19, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_PARSEERR", (long) 20, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SDEERR", (long) 21, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_OGRERR", (long) 22, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_QUERYERR", (long) 23, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_WMSERR", (long) 24, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_WMSCONNERR", (long) 25, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_ORACLESPATIALERR", (long) 26, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_WFSERR", (long) 27, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_WFSCONNERR", (long) 28, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MAPCONTEXTERR", (long) 29, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_HTTPERR", (long) 30, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_CHILDERR", (long) 31, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_WCSERR", (long) 32, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_GEOSERR", (long) 33, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_RECTERR", (long) 34, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_TIMEERR", (long) 35, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_GMLERR", (long) 36, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_SOSERR", (long) 37, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_NUMERRORCODES", (long) 38, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MESSAGELENGTH", (long) 2048, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "ROUTINELENGTH", (long) 64, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_HASHSIZE", (long) 41, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_MAX_CGI_PARAMS", (long) 100, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_GET_REQUEST", (long) MS_GET_REQUEST, 0, 0, 0},
{ SWIG_INT,     (char *) SWIG_prefix "MS_POST_REQUEST", (long) MS_POST_REQUEST, 0, 0, 0},
{0}
};
#ifdef __cplusplus
}
#endif
static swig_variable_info swig_variables[] = {
{0}
};
static swig_command_info swig_commands[] = {
{"mapscriptc::new_intarray", _wrap_new_intarray},
{"mapscriptc::delete_intarray", _wrap_delete_intarray},
{"mapscriptc::intarray_getitem", _wrap_intarray_getitem},
{"mapscriptc::intarray_setitem", _wrap_intarray_setitem},
{"mapscriptc::intarray_cast", _wrap_intarray_cast},
{"mapscriptc::intarray_frompointer", _wrap_intarray_frompointer},
{"mapscriptc::fontSetObj_filename_get", _wrap_fontSetObj_filename_get},
{"mapscriptc::fontSetObj_numfonts_get", _wrap_fontSetObj_numfonts_get},
{"mapscriptc::fontSetObj_fonts_get", _wrap_fontSetObj_fonts_get},
{"mapscriptc::new_fontSetObj", _wrap_new_fontSetObj},
{"mapscriptc::delete_fontSetObj", _wrap_delete_fontSetObj},
{"mapscriptc::outputFormatObj_name_set", _wrap_outputFormatObj_name_set},
{"mapscriptc::outputFormatObj_name_get", _wrap_outputFormatObj_name_get},
{"mapscriptc::outputFormatObj_mimetype_set", _wrap_outputFormatObj_mimetype_set},
{"mapscriptc::outputFormatObj_mimetype_get", _wrap_outputFormatObj_mimetype_get},
{"mapscriptc::outputFormatObj_driver_set", _wrap_outputFormatObj_driver_set},
{"mapscriptc::outputFormatObj_driver_get", _wrap_outputFormatObj_driver_get},
{"mapscriptc::outputFormatObj_extension_set", _wrap_outputFormatObj_extension_set},
{"mapscriptc::outputFormatObj_extension_get", _wrap_outputFormatObj_extension_get},
{"mapscriptc::outputFormatObj_renderer_set", _wrap_outputFormatObj_renderer_set},
{"mapscriptc::outputFormatObj_renderer_get", _wrap_outputFormatObj_renderer_get},
{"mapscriptc::outputFormatObj_imagemode_set", _wrap_outputFormatObj_imagemode_set},
{"mapscriptc::outputFormatObj_imagemode_get", _wrap_outputFormatObj_imagemode_get},
{"mapscriptc::outputFormatObj_transparent_set", _wrap_outputFormatObj_transparent_set},
{"mapscriptc::outputFormatObj_transparent_get", _wrap_outputFormatObj_transparent_get},
{"mapscriptc::outputFormatObj_bands_set", _wrap_outputFormatObj_bands_set},
{"mapscriptc::outputFormatObj_bands_get", _wrap_outputFormatObj_bands_get},
{"mapscriptc::outputFormatObj_numformatoptions_set", _wrap_outputFormatObj_numformatoptions_set},
{"mapscriptc::outputFormatObj_numformatoptions_get", _wrap_outputFormatObj_numformatoptions_get},
{"mapscriptc::outputFormatObj_formatoptions_set", _wrap_outputFormatObj_formatoptions_set},
{"mapscriptc::outputFormatObj_formatoptions_get", _wrap_outputFormatObj_formatoptions_get},
{"mapscriptc::outputFormatObj_refcount_set", _wrap_outputFormatObj_refcount_set},
{"mapscriptc::outputFormatObj_refcount_get", _wrap_outputFormatObj_refcount_get},
{"mapscriptc::outputFormatObj_inmapfile_set", _wrap_outputFormatObj_inmapfile_set},
{"mapscriptc::outputFormatObj_inmapfile_get", _wrap_outputFormatObj_inmapfile_get},
{"mapscriptc::new_outputFormatObj", _wrap_new_outputFormatObj},
{"mapscriptc::delete_outputFormatObj", _wrap_delete_outputFormatObj},
{"mapscriptc::outputFormatObj_setExtension", _wrap_outputFormatObj_setExtension},
{"mapscriptc::outputFormatObj_setMimetype", _wrap_outputFormatObj_setMimetype},
{"mapscriptc::outputFormatObj_setOption", _wrap_outputFormatObj_setOption},
{"mapscriptc::outputFormatObj_validate", _wrap_outputFormatObj_validate},
{"mapscriptc::outputFormatObj_getOption", _wrap_outputFormatObj_getOption},
{"mapscriptc::queryMapObj_height_set", _wrap_queryMapObj_height_set},
{"mapscriptc::queryMapObj_height_get", _wrap_queryMapObj_height_get},
{"mapscriptc::queryMapObj_width_set", _wrap_queryMapObj_width_set},
{"mapscriptc::queryMapObj_width_get", _wrap_queryMapObj_width_get},
{"mapscriptc::queryMapObj_status_set", _wrap_queryMapObj_status_set},
{"mapscriptc::queryMapObj_status_get", _wrap_queryMapObj_status_get},
{"mapscriptc::queryMapObj_style_set", _wrap_queryMapObj_style_set},
{"mapscriptc::queryMapObj_style_get", _wrap_queryMapObj_style_get},
{"mapscriptc::queryMapObj_color_set", _wrap_queryMapObj_color_set},
{"mapscriptc::queryMapObj_color_get", _wrap_queryMapObj_color_get},
{"mapscriptc::new_queryMapObj", _wrap_new_queryMapObj},
{"mapscriptc::delete_queryMapObj", _wrap_delete_queryMapObj},
{"mapscriptc::labelObj_font_set", _wrap_labelObj_font_set},
{"mapscriptc::labelObj_font_get", _wrap_labelObj_font_get},
{"mapscriptc::labelObj_type_set", _wrap_labelObj_type_set},
{"mapscriptc::labelObj_type_get", _wrap_labelObj_type_get},
{"mapscriptc::labelObj_color_set", _wrap_labelObj_color_set},
{"mapscriptc::labelObj_color_get", _wrap_labelObj_color_get},
{"mapscriptc::labelObj_outlinecolor_set", _wrap_labelObj_outlinecolor_set},
{"mapscriptc::labelObj_outlinecolor_get", _wrap_labelObj_outlinecolor_get},
{"mapscriptc::labelObj_shadowcolor_set", _wrap_labelObj_shadowcolor_set},
{"mapscriptc::labelObj_shadowcolor_get", _wrap_labelObj_shadowcolor_get},
{"mapscriptc::labelObj_shadowsizex_set", _wrap_labelObj_shadowsizex_set},
{"mapscriptc::labelObj_shadowsizex_get", _wrap_labelObj_shadowsizex_get},
{"mapscriptc::labelObj_shadowsizey_set", _wrap_labelObj_shadowsizey_set},
{"mapscriptc::labelObj_shadowsizey_get", _wrap_labelObj_shadowsizey_get},
{"mapscriptc::labelObj_backgroundcolor_set", _wrap_labelObj_backgroundcolor_set},
{"mapscriptc::labelObj_backgroundcolor_get", _wrap_labelObj_backgroundcolor_get},
{"mapscriptc::labelObj_backgroundshadowcolor_set", _wrap_labelObj_backgroundshadowcolor_set},
{"mapscriptc::labelObj_backgroundshadowcolor_get", _wrap_labelObj_backgroundshadowcolor_get},
{"mapscriptc::labelObj_backgroundshadowsizex_set", _wrap_labelObj_backgroundshadowsizex_set},
{"mapscriptc::labelObj_backgroundshadowsizex_get", _wrap_labelObj_backgroundshadowsizex_get},
{"mapscriptc::labelObj_backgroundshadowsizey_set", _wrap_labelObj_backgroundshadowsizey_set},
{"mapscriptc::labelObj_backgroundshadowsizey_get", _wrap_labelObj_backgroundshadowsizey_get},
{"mapscriptc::labelObj_size_set", _wrap_labelObj_size_set},
{"mapscriptc::labelObj_size_get", _wrap_labelObj_size_get},
{"mapscriptc::labelObj_minsize_set", _wrap_labelObj_minsize_set},
{"mapscriptc::labelObj_minsize_get", _wrap_labelObj_minsize_get},
{"mapscriptc::labelObj_maxsize_set", _wrap_labelObj_maxsize_set},
{"mapscriptc::labelObj_maxsize_get", _wrap_labelObj_maxsize_get},
{"mapscriptc::labelObj_position_set", _wrap_labelObj_position_set},
{"mapscriptc::labelObj_position_get", _wrap_labelObj_position_get},
{"mapscriptc::labelObj_offsetx_set", _wrap_labelObj_offsetx_set},
{"mapscriptc::labelObj_offsetx_get", _wrap_labelObj_offsetx_get},
{"mapscriptc::labelObj_offsety_set", _wrap_labelObj_offsety_set},
{"mapscriptc::labelObj_offsety_get", _wrap_labelObj_offsety_get},
{"mapscriptc::labelObj_angle_set", _wrap_labelObj_angle_set},
{"mapscriptc::labelObj_angle_get", _wrap_labelObj_angle_get},
{"mapscriptc::labelObj_autoangle_set", _wrap_labelObj_autoangle_set},
{"mapscriptc::labelObj_autoangle_get", _wrap_labelObj_autoangle_get},
{"mapscriptc::labelObj_autofollow_set", _wrap_labelObj_autofollow_set},
{"mapscriptc::labelObj_autofollow_get", _wrap_labelObj_autofollow_get},
{"mapscriptc::labelObj_buffer_set", _wrap_labelObj_buffer_set},
{"mapscriptc::labelObj_buffer_get", _wrap_labelObj_buffer_get},
{"mapscriptc::labelObj_antialias_set", _wrap_labelObj_antialias_set},
{"mapscriptc::labelObj_antialias_get", _wrap_labelObj_antialias_get},
{"mapscriptc::labelObj_wrap_set", _wrap_labelObj_wrap_set},
{"mapscriptc::labelObj_wrap_get", _wrap_labelObj_wrap_get},
{"mapscriptc::labelObj_minfeaturesize_set", _wrap_labelObj_minfeaturesize_set},
{"mapscriptc::labelObj_minfeaturesize_get", _wrap_labelObj_minfeaturesize_get},
{"mapscriptc::labelObj_autominfeaturesize_set", _wrap_labelObj_autominfeaturesize_set},
{"mapscriptc::labelObj_autominfeaturesize_get", _wrap_labelObj_autominfeaturesize_get},
{"mapscriptc::labelObj_mindistance_set", _wrap_labelObj_mindistance_set},
{"mapscriptc::labelObj_mindistance_get", _wrap_labelObj_mindistance_get},
{"mapscriptc::labelObj_partials_set", _wrap_labelObj_partials_set},
{"mapscriptc::labelObj_partials_get", _wrap_labelObj_partials_get},
{"mapscriptc::labelObj_force_set", _wrap_labelObj_force_set},
{"mapscriptc::labelObj_force_get", _wrap_labelObj_force_get},
{"mapscriptc::labelObj_encoding_set", _wrap_labelObj_encoding_set},
{"mapscriptc::labelObj_encoding_get", _wrap_labelObj_encoding_get},
{"mapscriptc::new_labelObj", _wrap_new_labelObj},
{"mapscriptc::delete_labelObj", _wrap_delete_labelObj},
{"mapscriptc::webObj_log_set", _wrap_webObj_log_set},
{"mapscriptc::webObj_log_get", _wrap_webObj_log_get},
{"mapscriptc::webObj_imagepath_set", _wrap_webObj_imagepath_set},
{"mapscriptc::webObj_imagepath_get", _wrap_webObj_imagepath_get},
{"mapscriptc::webObj_imageurl_set", _wrap_webObj_imageurl_set},
{"mapscriptc::webObj_imageurl_get", _wrap_webObj_imageurl_get},
{"mapscriptc::webObj_map_get", _wrap_webObj_map_get},
{"mapscriptc::webObj_template_set", _wrap_webObj_template_set},
{"mapscriptc::webObj_template_get", _wrap_webObj_template_get},
{"mapscriptc::webObj_header_set", _wrap_webObj_header_set},
{"mapscriptc::webObj_header_get", _wrap_webObj_header_get},
{"mapscriptc::webObj_footer_set", _wrap_webObj_footer_set},
{"mapscriptc::webObj_footer_get", _wrap_webObj_footer_get},
{"mapscriptc::webObj_empty_set", _wrap_webObj_empty_set},
{"mapscriptc::webObj_empty_get", _wrap_webObj_empty_get},
{"mapscriptc::webObj_error_set", _wrap_webObj_error_set},
{"mapscriptc::webObj_error_get", _wrap_webObj_error_get},
{"mapscriptc::webObj_extent_set", _wrap_webObj_extent_set},
{"mapscriptc::webObj_extent_get", _wrap_webObj_extent_get},
{"mapscriptc::webObj_minscale_set", _wrap_webObj_minscale_set},
{"mapscriptc::webObj_minscale_get", _wrap_webObj_minscale_get},
{"mapscriptc::webObj_maxscale_set", _wrap_webObj_maxscale_set},
{"mapscriptc::webObj_maxscale_get", _wrap_webObj_maxscale_get},
{"mapscriptc::webObj_mintemplate_set", _wrap_webObj_mintemplate_set},
{"mapscriptc::webObj_mintemplate_get", _wrap_webObj_mintemplate_get},
{"mapscriptc::webObj_maxtemplate_set", _wrap_webObj_maxtemplate_set},
{"mapscriptc::webObj_maxtemplate_get", _wrap_webObj_maxtemplate_get},
{"mapscriptc::webObj_queryformat_set", _wrap_webObj_queryformat_set},
{"mapscriptc::webObj_queryformat_get", _wrap_webObj_queryformat_get},
{"mapscriptc::webObj_legendformat_set", _wrap_webObj_legendformat_set},
{"mapscriptc::webObj_legendformat_get", _wrap_webObj_legendformat_get},
{"mapscriptc::webObj_browseformat_set", _wrap_webObj_browseformat_set},
{"mapscriptc::webObj_browseformat_get", _wrap_webObj_browseformat_get},
{"mapscriptc::webObj_metadata_get", _wrap_webObj_metadata_get},
{"mapscriptc::new_webObj", _wrap_new_webObj},
{"mapscriptc::delete_webObj", _wrap_delete_webObj},
{"mapscriptc::styleObj_color_set", _wrap_styleObj_color_set},
{"mapscriptc::styleObj_color_get", _wrap_styleObj_color_get},
{"mapscriptc::styleObj_backgroundcolor_set", _wrap_styleObj_backgroundcolor_set},
{"mapscriptc::styleObj_backgroundcolor_get", _wrap_styleObj_backgroundcolor_get},
{"mapscriptc::styleObj_outlinecolor_set", _wrap_styleObj_outlinecolor_set},
{"mapscriptc::styleObj_outlinecolor_get", _wrap_styleObj_outlinecolor_get},
{"mapscriptc::styleObj_mincolor_set", _wrap_styleObj_mincolor_set},
{"mapscriptc::styleObj_mincolor_get", _wrap_styleObj_mincolor_get},
{"mapscriptc::styleObj_maxcolor_set", _wrap_styleObj_maxcolor_set},
{"mapscriptc::styleObj_maxcolor_get", _wrap_styleObj_maxcolor_get},
{"mapscriptc::styleObj_minvalue_set", _wrap_styleObj_minvalue_set},
{"mapscriptc::styleObj_minvalue_get", _wrap_styleObj_minvalue_get},
{"mapscriptc::styleObj_maxvalue_set", _wrap_styleObj_maxvalue_set},
{"mapscriptc::styleObj_maxvalue_get", _wrap_styleObj_maxvalue_get},
{"mapscriptc::styleObj_rangeitem_set", _wrap_styleObj_rangeitem_set},
{"mapscriptc::styleObj_rangeitem_get", _wrap_styleObj_rangeitem_get},
{"mapscriptc::styleObj_rangeitemindex_set", _wrap_styleObj_rangeitemindex_set},
{"mapscriptc::styleObj_rangeitemindex_get", _wrap_styleObj_rangeitemindex_get},
{"mapscriptc::styleObj_symbol_set", _wrap_styleObj_symbol_set},
{"mapscriptc::styleObj_symbol_get", _wrap_styleObj_symbol_get},
{"mapscriptc::styleObj_symbolname_set", _wrap_styleObj_symbolname_set},
{"mapscriptc::styleObj_symbolname_get", _wrap_styleObj_symbolname_get},
{"mapscriptc::styleObj_size_set", _wrap_styleObj_size_set},
{"mapscriptc::styleObj_size_get", _wrap_styleObj_size_get},
{"mapscriptc::styleObj_minsize_set", _wrap_styleObj_minsize_set},
{"mapscriptc::styleObj_minsize_get", _wrap_styleObj_minsize_get},
{"mapscriptc::styleObj_maxsize_set", _wrap_styleObj_maxsize_set},
{"mapscriptc::styleObj_maxsize_get", _wrap_styleObj_maxsize_get},
{"mapscriptc::styleObj_width_set", _wrap_styleObj_width_set},
{"mapscriptc::styleObj_width_get", _wrap_styleObj_width_get},
{"mapscriptc::styleObj_minwidth_set", _wrap_styleObj_minwidth_set},
{"mapscriptc::styleObj_minwidth_get", _wrap_styleObj_minwidth_get},
{"mapscriptc::styleObj_maxwidth_set", _wrap_styleObj_maxwidth_set},
{"mapscriptc::styleObj_maxwidth_get", _wrap_styleObj_maxwidth_get},
{"mapscriptc::styleObj_offsetx_set", _wrap_styleObj_offsetx_set},
{"mapscriptc::styleObj_offsetx_get", _wrap_styleObj_offsetx_get},
{"mapscriptc::styleObj_offsety_set", _wrap_styleObj_offsety_set},
{"mapscriptc::styleObj_offsety_get", _wrap_styleObj_offsety_get},
{"mapscriptc::styleObj_angle_set", _wrap_styleObj_angle_set},
{"mapscriptc::styleObj_angle_get", _wrap_styleObj_angle_get},
{"mapscriptc::styleObj_antialias_set", _wrap_styleObj_antialias_set},
{"mapscriptc::styleObj_antialias_get", _wrap_styleObj_antialias_get},
{"mapscriptc::styleObj_angleitem_set", _wrap_styleObj_angleitem_set},
{"mapscriptc::styleObj_angleitem_get", _wrap_styleObj_angleitem_get},
{"mapscriptc::styleObj_sizeitem_set", _wrap_styleObj_sizeitem_set},
{"mapscriptc::styleObj_sizeitem_get", _wrap_styleObj_sizeitem_get},
{"mapscriptc::new_styleObj", _wrap_new_styleObj},
{"mapscriptc::delete_styleObj", _wrap_delete_styleObj},
{"mapscriptc::styleObj_clone", _wrap_styleObj_clone},
{"mapscriptc::styleObj_setSymbolByName", _wrap_styleObj_setSymbolByName},
{"mapscriptc::classObj_status_set", _wrap_classObj_status_set},
{"mapscriptc::classObj_status_get", _wrap_classObj_status_get},
{"mapscriptc::classObj_numstyles_set", _wrap_classObj_numstyles_set},
{"mapscriptc::classObj_numstyles_get", _wrap_classObj_numstyles_get},
{"mapscriptc::classObj_label_get", _wrap_classObj_label_get},
{"mapscriptc::classObj_name_set", _wrap_classObj_name_set},
{"mapscriptc::classObj_name_get", _wrap_classObj_name_get},
{"mapscriptc::classObj_title_set", _wrap_classObj_title_set},
{"mapscriptc::classObj_title_get", _wrap_classObj_title_get},
{"mapscriptc::classObj_template_set", _wrap_classObj_template_set},
{"mapscriptc::classObj_template_get", _wrap_classObj_template_get},
{"mapscriptc::classObj_type_set", _wrap_classObj_type_set},
{"mapscriptc::classObj_type_get", _wrap_classObj_type_get},
{"mapscriptc::classObj_metadata_get", _wrap_classObj_metadata_get},
{"mapscriptc::classObj_minscale_set", _wrap_classObj_minscale_set},
{"mapscriptc::classObj_minscale_get", _wrap_classObj_minscale_get},
{"mapscriptc::classObj_maxscale_set", _wrap_classObj_maxscale_set},
{"mapscriptc::classObj_maxscale_get", _wrap_classObj_maxscale_get},
{"mapscriptc::classObj_layer_get", _wrap_classObj_layer_get},
{"mapscriptc::classObj_debug_set", _wrap_classObj_debug_set},
{"mapscriptc::classObj_debug_get", _wrap_classObj_debug_get},
{"mapscriptc::classObj_keyimage_set", _wrap_classObj_keyimage_set},
{"mapscriptc::classObj_keyimage_get", _wrap_classObj_keyimage_get},
{"mapscriptc::new_classObj", _wrap_new_classObj},
{"mapscriptc::delete_classObj", _wrap_delete_classObj},
{"mapscriptc::classObj_clone", _wrap_classObj_clone},
{"mapscriptc::classObj_setExpression", _wrap_classObj_setExpression},
{"mapscriptc::classObj_getExpressionString", _wrap_classObj_getExpressionString},
{"mapscriptc::classObj_setText", _wrap_classObj_setText},
{"mapscriptc::classObj_getTextString", _wrap_classObj_getTextString},
{"mapscriptc::classObj_getMetaData", _wrap_classObj_getMetaData},
{"mapscriptc::classObj_setMetaData", _wrap_classObj_setMetaData},
{"mapscriptc::classObj_getFirstMetaDataKey", _wrap_classObj_getFirstMetaDataKey},
{"mapscriptc::classObj_getNextMetaDataKey", _wrap_classObj_getNextMetaDataKey},
{"mapscriptc::classObj_drawLegendIcon", _wrap_classObj_drawLegendIcon},
{"mapscriptc::classObj_createLegendIcon", _wrap_classObj_createLegendIcon},
{"mapscriptc::classObj_getStyle", _wrap_classObj_getStyle},
{"mapscriptc::classObj_insertStyle", _wrap_classObj_insertStyle},
{"mapscriptc::classObj_removeStyle", _wrap_classObj_removeStyle},
{"mapscriptc::classObj_moveStyleUp", _wrap_classObj_moveStyleUp},
{"mapscriptc::classObj_moveStyleDown", _wrap_classObj_moveStyleDown},
{"mapscriptc::labelCacheMemberObj_text_get", _wrap_labelCacheMemberObj_text_get},
{"mapscriptc::labelCacheMemberObj_featuresize_get", _wrap_labelCacheMemberObj_featuresize_get},
{"mapscriptc::labelCacheMemberObj_styles_get", _wrap_labelCacheMemberObj_styles_get},
{"mapscriptc::labelCacheMemberObj_numstyles_get", _wrap_labelCacheMemberObj_numstyles_get},
{"mapscriptc::labelCacheMemberObj_label_get", _wrap_labelCacheMemberObj_label_get},
{"mapscriptc::labelCacheMemberObj_layerindex_get", _wrap_labelCacheMemberObj_layerindex_get},
{"mapscriptc::labelCacheMemberObj_classindex_get", _wrap_labelCacheMemberObj_classindex_get},
{"mapscriptc::labelCacheMemberObj_tileindex_get", _wrap_labelCacheMemberObj_tileindex_get},
{"mapscriptc::labelCacheMemberObj_shapeindex_get", _wrap_labelCacheMemberObj_shapeindex_get},
{"mapscriptc::labelCacheMemberObj_point_get", _wrap_labelCacheMemberObj_point_get},
{"mapscriptc::labelCacheMemberObj_poly_get", _wrap_labelCacheMemberObj_poly_get},
{"mapscriptc::labelCacheMemberObj_status_get", _wrap_labelCacheMemberObj_status_get},
{"mapscriptc::labelCacheMemberObj_labelpath_get", _wrap_labelCacheMemberObj_labelpath_get},
{"mapscriptc::new_labelCacheMemberObj", _wrap_new_labelCacheMemberObj},
{"mapscriptc::delete_labelCacheMemberObj", _wrap_delete_labelCacheMemberObj},
{"mapscriptc::markerCacheMemberObj_id_get", _wrap_markerCacheMemberObj_id_get},
{"mapscriptc::markerCacheMemberObj_poly_get", _wrap_markerCacheMemberObj_poly_get},
{"mapscriptc::new_markerCacheMemberObj", _wrap_new_markerCacheMemberObj},
{"mapscriptc::delete_markerCacheMemberObj", _wrap_delete_markerCacheMemberObj},
{"mapscriptc::labelCacheObj_labels_get", _wrap_labelCacheObj_labels_get},
{"mapscriptc::labelCacheObj_numlabels_get", _wrap_labelCacheObj_numlabels_get},
{"mapscriptc::labelCacheObj_cachesize_get", _wrap_labelCacheObj_cachesize_get},
{"mapscriptc::labelCacheObj_markers_get", _wrap_labelCacheObj_markers_get},
{"mapscriptc::labelCacheObj_nummarkers_get", _wrap_labelCacheObj_nummarkers_get},
{"mapscriptc::labelCacheObj_markercachesize_get", _wrap_labelCacheObj_markercachesize_get},
{"mapscriptc::labelCacheObj_freeCache", _wrap_labelCacheObj_freeCache},
{"mapscriptc::new_labelCacheObj", _wrap_new_labelCacheObj},
{"mapscriptc::delete_labelCacheObj", _wrap_delete_labelCacheObj},
{"mapscriptc::resultCacheMemberObj_shapeindex_get", _wrap_resultCacheMemberObj_shapeindex_get},
{"mapscriptc::resultCacheMemberObj_tileindex_get", _wrap_resultCacheMemberObj_tileindex_get},
{"mapscriptc::resultCacheMemberObj_classindex_get", _wrap_resultCacheMemberObj_classindex_get},
{"mapscriptc::new_resultCacheMemberObj", _wrap_new_resultCacheMemberObj},
{"mapscriptc::delete_resultCacheMemberObj", _wrap_delete_resultCacheMemberObj},
{"mapscriptc::resultCacheObj_numresults_get", _wrap_resultCacheObj_numresults_get},
{"mapscriptc::resultCacheObj_bounds_get", _wrap_resultCacheObj_bounds_get},
{"mapscriptc::resultCacheObj_getResult", _wrap_resultCacheObj_getResult},
{"mapscriptc::new_resultCacheObj", _wrap_new_resultCacheObj},
{"mapscriptc::delete_resultCacheObj", _wrap_delete_resultCacheObj},
{"mapscriptc::symbolSetObj_filename_set", _wrap_symbolSetObj_filename_set},
{"mapscriptc::symbolSetObj_filename_get", _wrap_symbolSetObj_filename_get},
{"mapscriptc::symbolSetObj_imagecachesize_set", _wrap_symbolSetObj_imagecachesize_set},
{"mapscriptc::symbolSetObj_imagecachesize_get", _wrap_symbolSetObj_imagecachesize_get},
{"mapscriptc::symbolSetObj_numsymbols_get", _wrap_symbolSetObj_numsymbols_get},
{"mapscriptc::symbolSetObj_symbol_set", _wrap_symbolSetObj_symbol_set},
{"mapscriptc::symbolSetObj_symbol_get", _wrap_symbolSetObj_symbol_get},
{"mapscriptc::new_symbolSetObj", _wrap_new_symbolSetObj},
{"mapscriptc::delete_symbolSetObj", _wrap_delete_symbolSetObj},
{"mapscriptc::symbolSetObj_getSymbol", _wrap_symbolSetObj_getSymbol},
{"mapscriptc::symbolSetObj_getSymbolByName", _wrap_symbolSetObj_getSymbolByName},
{"mapscriptc::symbolSetObj_index", _wrap_symbolSetObj_index},
{"mapscriptc::symbolSetObj_appendSymbol", _wrap_symbolSetObj_appendSymbol},
{"mapscriptc::symbolSetObj_removeSymbol", _wrap_symbolSetObj_removeSymbol},
{"mapscriptc::symbolSetObj_save", _wrap_symbolSetObj_save},
{"mapscriptc::referenceMapObj_extent_set", _wrap_referenceMapObj_extent_set},
{"mapscriptc::referenceMapObj_extent_get", _wrap_referenceMapObj_extent_get},
{"mapscriptc::referenceMapObj_height_set", _wrap_referenceMapObj_height_set},
{"mapscriptc::referenceMapObj_height_get", _wrap_referenceMapObj_height_get},
{"mapscriptc::referenceMapObj_width_set", _wrap_referenceMapObj_width_set},
{"mapscriptc::referenceMapObj_width_get", _wrap_referenceMapObj_width_get},
{"mapscriptc::referenceMapObj_color_set", _wrap_referenceMapObj_color_set},
{"mapscriptc::referenceMapObj_color_get", _wrap_referenceMapObj_color_get},
{"mapscriptc::referenceMapObj_outlinecolor_set", _wrap_referenceMapObj_outlinecolor_set},
{"mapscriptc::referenceMapObj_outlinecolor_get", _wrap_referenceMapObj_outlinecolor_get},
{"mapscriptc::referenceMapObj_image_set", _wrap_referenceMapObj_image_set},
{"mapscriptc::referenceMapObj_image_get", _wrap_referenceMapObj_image_get},
{"mapscriptc::referenceMapObj_status_set", _wrap_referenceMapObj_status_set},
{"mapscriptc::referenceMapObj_status_get", _wrap_referenceMapObj_status_get},
{"mapscriptc::referenceMapObj_marker_set", _wrap_referenceMapObj_marker_set},
{"mapscriptc::referenceMapObj_marker_get", _wrap_referenceMapObj_marker_get},
{"mapscriptc::referenceMapObj_markername_set", _wrap_referenceMapObj_markername_set},
{"mapscriptc::referenceMapObj_markername_get", _wrap_referenceMapObj_markername_get},
{"mapscriptc::referenceMapObj_markersize_set", _wrap_referenceMapObj_markersize_set},
{"mapscriptc::referenceMapObj_markersize_get", _wrap_referenceMapObj_markersize_get},
{"mapscriptc::referenceMapObj_minboxsize_set", _wrap_referenceMapObj_minboxsize_set},
{"mapscriptc::referenceMapObj_minboxsize_get", _wrap_referenceMapObj_minboxsize_get},
{"mapscriptc::referenceMapObj_maxboxsize_set", _wrap_referenceMapObj_maxboxsize_set},
{"mapscriptc::referenceMapObj_maxboxsize_get", _wrap_referenceMapObj_maxboxsize_get},
{"mapscriptc::referenceMapObj_map_get", _wrap_referenceMapObj_map_get},
{"mapscriptc::new_referenceMapObj", _wrap_new_referenceMapObj},
{"mapscriptc::delete_referenceMapObj", _wrap_delete_referenceMapObj},
{"mapscriptc::scalebarObj_imagecolor_set", _wrap_scalebarObj_imagecolor_set},
{"mapscriptc::scalebarObj_imagecolor_get", _wrap_scalebarObj_imagecolor_get},
{"mapscriptc::scalebarObj_height_set", _wrap_scalebarObj_height_set},
{"mapscriptc::scalebarObj_height_get", _wrap_scalebarObj_height_get},
{"mapscriptc::scalebarObj_width_set", _wrap_scalebarObj_width_set},
{"mapscriptc::scalebarObj_width_get", _wrap_scalebarObj_width_get},
{"mapscriptc::scalebarObj_style_set", _wrap_scalebarObj_style_set},
{"mapscriptc::scalebarObj_style_get", _wrap_scalebarObj_style_get},
{"mapscriptc::scalebarObj_intervals_set", _wrap_scalebarObj_intervals_set},
{"mapscriptc::scalebarObj_intervals_get", _wrap_scalebarObj_intervals_get},
{"mapscriptc::scalebarObj_label_set", _wrap_scalebarObj_label_set},
{"mapscriptc::scalebarObj_label_get", _wrap_scalebarObj_label_get},
{"mapscriptc::scalebarObj_color_set", _wrap_scalebarObj_color_set},
{"mapscriptc::scalebarObj_color_get", _wrap_scalebarObj_color_get},
{"mapscriptc::scalebarObj_backgroundcolor_set", _wrap_scalebarObj_backgroundcolor_set},
{"mapscriptc::scalebarObj_backgroundcolor_get", _wrap_scalebarObj_backgroundcolor_get},
{"mapscriptc::scalebarObj_outlinecolor_set", _wrap_scalebarObj_outlinecolor_set},
{"mapscriptc::scalebarObj_outlinecolor_get", _wrap_scalebarObj_outlinecolor_get},
{"mapscriptc::scalebarObj_units_set", _wrap_scalebarObj_units_set},
{"mapscriptc::scalebarObj_units_get", _wrap_scalebarObj_units_get},
{"mapscriptc::scalebarObj_status_set", _wrap_scalebarObj_status_set},
{"mapscriptc::scalebarObj_status_get", _wrap_scalebarObj_status_get},
{"mapscriptc::scalebarObj_position_set", _wrap_scalebarObj_position_set},
{"mapscriptc::scalebarObj_position_get", _wrap_scalebarObj_position_get},
{"mapscriptc::scalebarObj_postlabelcache_set", _wrap_scalebarObj_postlabelcache_set},
{"mapscriptc::scalebarObj_postlabelcache_get", _wrap_scalebarObj_postlabelcache_get},
{"mapscriptc::new_scalebarObj", _wrap_new_scalebarObj},
{"mapscriptc::delete_scalebarObj", _wrap_delete_scalebarObj},
{"mapscriptc::legendObj_imagecolor_set", _wrap_legendObj_imagecolor_set},
{"mapscriptc::legendObj_imagecolor_get", _wrap_legendObj_imagecolor_get},
{"mapscriptc::legendObj_label_get", _wrap_legendObj_label_get},
{"mapscriptc::legendObj_keysizex_set", _wrap_legendObj_keysizex_set},
{"mapscriptc::legendObj_keysizex_get", _wrap_legendObj_keysizex_get},
{"mapscriptc::legendObj_keysizey_set", _wrap_legendObj_keysizey_set},
{"mapscriptc::legendObj_keysizey_get", _wrap_legendObj_keysizey_get},
{"mapscriptc::legendObj_keyspacingx_set", _wrap_legendObj_keyspacingx_set},
{"mapscriptc::legendObj_keyspacingx_get", _wrap_legendObj_keyspacingx_get},
{"mapscriptc::legendObj_keyspacingy_set", _wrap_legendObj_keyspacingy_set},
{"mapscriptc::legendObj_keyspacingy_get", _wrap_legendObj_keyspacingy_get},
{"mapscriptc::legendObj_outlinecolor_set", _wrap_legendObj_outlinecolor_set},
{"mapscriptc::legendObj_outlinecolor_get", _wrap_legendObj_outlinecolor_get},
{"mapscriptc::legendObj_status_set", _wrap_legendObj_status_set},
{"mapscriptc::legendObj_status_get", _wrap_legendObj_status_get},
{"mapscriptc::legendObj_height_set", _wrap_legendObj_height_set},
{"mapscriptc::legendObj_height_get", _wrap_legendObj_height_get},
{"mapscriptc::legendObj_width_set", _wrap_legendObj_width_set},
{"mapscriptc::legendObj_width_get", _wrap_legendObj_width_get},
{"mapscriptc::legendObj_position_set", _wrap_legendObj_position_set},
{"mapscriptc::legendObj_position_get", _wrap_legendObj_position_get},
{"mapscriptc::legendObj_postlabelcache_set", _wrap_legendObj_postlabelcache_set},
{"mapscriptc::legendObj_postlabelcache_get", _wrap_legendObj_postlabelcache_get},
{"mapscriptc::legendObj_template_set", _wrap_legendObj_template_set},
{"mapscriptc::legendObj_template_get", _wrap_legendObj_template_get},
{"mapscriptc::legendObj_map_get", _wrap_legendObj_map_get},
{"mapscriptc::new_legendObj", _wrap_new_legendObj},
{"mapscriptc::delete_legendObj", _wrap_delete_legendObj},
{"mapscriptc::layerObj_classitem_set", _wrap_layerObj_classitem_set},
{"mapscriptc::layerObj_classitem_get", _wrap_layerObj_classitem_get},
{"mapscriptc::layerObj_numclasses_get", _wrap_layerObj_numclasses_get},
{"mapscriptc::layerObj_index_get", _wrap_layerObj_index_get},
{"mapscriptc::layerObj_map_get", _wrap_layerObj_map_get},
{"mapscriptc::layerObj_header_set", _wrap_layerObj_header_set},
{"mapscriptc::layerObj_header_get", _wrap_layerObj_header_get},
{"mapscriptc::layerObj_footer_set", _wrap_layerObj_footer_set},
{"mapscriptc::layerObj_footer_get", _wrap_layerObj_footer_get},
{"mapscriptc::layerObj_template_set", _wrap_layerObj_template_set},
{"mapscriptc::layerObj_template_get", _wrap_layerObj_template_get},
{"mapscriptc::layerObj_name_set", _wrap_layerObj_name_set},
{"mapscriptc::layerObj_name_get", _wrap_layerObj_name_get},
{"mapscriptc::layerObj_group_set", _wrap_layerObj_group_set},
{"mapscriptc::layerObj_group_get", _wrap_layerObj_group_get},
{"mapscriptc::layerObj_status_set", _wrap_layerObj_status_set},
{"mapscriptc::layerObj_status_get", _wrap_layerObj_status_get},
{"mapscriptc::layerObj_data_set", _wrap_layerObj_data_set},
{"mapscriptc::layerObj_data_get", _wrap_layerObj_data_get},
{"mapscriptc::layerObj_type_set", _wrap_layerObj_type_set},
{"mapscriptc::layerObj_type_get", _wrap_layerObj_type_get},
{"mapscriptc::layerObj_tolerance_set", _wrap_layerObj_tolerance_set},
{"mapscriptc::layerObj_tolerance_get", _wrap_layerObj_tolerance_get},
{"mapscriptc::layerObj_toleranceunits_set", _wrap_layerObj_toleranceunits_set},
{"mapscriptc::layerObj_toleranceunits_get", _wrap_layerObj_toleranceunits_get},
{"mapscriptc::layerObj_symbolscale_set", _wrap_layerObj_symbolscale_set},
{"mapscriptc::layerObj_symbolscale_get", _wrap_layerObj_symbolscale_get},
{"mapscriptc::layerObj_minscale_set", _wrap_layerObj_minscale_set},
{"mapscriptc::layerObj_minscale_get", _wrap_layerObj_minscale_get},
{"mapscriptc::layerObj_maxscale_set", _wrap_layerObj_maxscale_set},
{"mapscriptc::layerObj_maxscale_get", _wrap_layerObj_maxscale_get},
{"mapscriptc::layerObj_labelminscale_set", _wrap_layerObj_labelminscale_set},
{"mapscriptc::layerObj_labelminscale_get", _wrap_layerObj_labelminscale_get},
{"mapscriptc::layerObj_labelmaxscale_set", _wrap_layerObj_labelmaxscale_set},
{"mapscriptc::layerObj_labelmaxscale_get", _wrap_layerObj_labelmaxscale_get},
{"mapscriptc::layerObj_sizeunits_set", _wrap_layerObj_sizeunits_set},
{"mapscriptc::layerObj_sizeunits_get", _wrap_layerObj_sizeunits_get},
{"mapscriptc::layerObj_maxfeatures_set", _wrap_layerObj_maxfeatures_set},
{"mapscriptc::layerObj_maxfeatures_get", _wrap_layerObj_maxfeatures_get},
{"mapscriptc::layerObj_offsite_set", _wrap_layerObj_offsite_set},
{"mapscriptc::layerObj_offsite_get", _wrap_layerObj_offsite_get},
{"mapscriptc::layerObj_transform_set", _wrap_layerObj_transform_set},
{"mapscriptc::layerObj_transform_get", _wrap_layerObj_transform_get},
{"mapscriptc::layerObj_labelcache_set", _wrap_layerObj_labelcache_set},
{"mapscriptc::layerObj_labelcache_get", _wrap_layerObj_labelcache_get},
{"mapscriptc::layerObj_postlabelcache_set", _wrap_layerObj_postlabelcache_set},
{"mapscriptc::layerObj_postlabelcache_get", _wrap_layerObj_postlabelcache_get},
{"mapscriptc::layerObj_labelitem_set", _wrap_layerObj_labelitem_set},
{"mapscriptc::layerObj_labelitem_get", _wrap_layerObj_labelitem_get},
{"mapscriptc::layerObj_labelsizeitem_set", _wrap_layerObj_labelsizeitem_set},
{"mapscriptc::layerObj_labelsizeitem_get", _wrap_layerObj_labelsizeitem_get},
{"mapscriptc::layerObj_labelangleitem_set", _wrap_layerObj_labelangleitem_set},
{"mapscriptc::layerObj_labelangleitem_get", _wrap_layerObj_labelangleitem_get},
{"mapscriptc::layerObj_tileitem_set", _wrap_layerObj_tileitem_set},
{"mapscriptc::layerObj_tileitem_get", _wrap_layerObj_tileitem_get},
{"mapscriptc::layerObj_tileindex_set", _wrap_layerObj_tileindex_set},
{"mapscriptc::layerObj_tileindex_get", _wrap_layerObj_tileindex_get},
{"mapscriptc::layerObj_units_set", _wrap_layerObj_units_set},
{"mapscriptc::layerObj_units_get", _wrap_layerObj_units_get},
{"mapscriptc::layerObj_connection_set", _wrap_layerObj_connection_set},
{"mapscriptc::layerObj_connection_get", _wrap_layerObj_connection_get},
{"mapscriptc::layerObj_plugin_library_set", _wrap_layerObj_plugin_library_set},
{"mapscriptc::layerObj_plugin_library_get", _wrap_layerObj_plugin_library_get},
{"mapscriptc::layerObj_plugin_library_original_set", _wrap_layerObj_plugin_library_original_set},
{"mapscriptc::layerObj_plugin_library_original_get", _wrap_layerObj_plugin_library_original_get},
{"mapscriptc::layerObj_connectiontype_set", _wrap_layerObj_connectiontype_set},
{"mapscriptc::layerObj_connectiontype_get", _wrap_layerObj_connectiontype_get},
{"mapscriptc::layerObj_numitems_get", _wrap_layerObj_numitems_get},
{"mapscriptc::layerObj_bandsitem_set", _wrap_layerObj_bandsitem_set},
{"mapscriptc::layerObj_bandsitem_get", _wrap_layerObj_bandsitem_get},
{"mapscriptc::layerObj_filteritem_set", _wrap_layerObj_filteritem_set},
{"mapscriptc::layerObj_filteritem_get", _wrap_layerObj_filteritem_get},
{"mapscriptc::layerObj_styleitem_set", _wrap_layerObj_styleitem_set},
{"mapscriptc::layerObj_styleitem_get", _wrap_layerObj_styleitem_get},
{"mapscriptc::layerObj_requires_set", _wrap_layerObj_requires_set},
{"mapscriptc::layerObj_requires_get", _wrap_layerObj_requires_get},
{"mapscriptc::layerObj_labelrequires_set", _wrap_layerObj_labelrequires_set},
{"mapscriptc::layerObj_labelrequires_get", _wrap_layerObj_labelrequires_get},
{"mapscriptc::layerObj_metadata_get", _wrap_layerObj_metadata_get},
{"mapscriptc::layerObj_transparency_set", _wrap_layerObj_transparency_set},
{"mapscriptc::layerObj_transparency_get", _wrap_layerObj_transparency_get},
{"mapscriptc::layerObj_dump_set", _wrap_layerObj_dump_set},
{"mapscriptc::layerObj_dump_get", _wrap_layerObj_dump_get},
{"mapscriptc::layerObj_debug_set", _wrap_layerObj_debug_set},
{"mapscriptc::layerObj_debug_get", _wrap_layerObj_debug_get},
{"mapscriptc::layerObj_extent_get", _wrap_layerObj_extent_get},
{"mapscriptc::layerObj_numprocessing_get", _wrap_layerObj_numprocessing_get},
{"mapscriptc::layerObj_numjoins_get", _wrap_layerObj_numjoins_get},
{"mapscriptc::new_layerObj", _wrap_new_layerObj},
{"mapscriptc::delete_layerObj", _wrap_delete_layerObj},
{"mapscriptc::layerObj_clone", _wrap_layerObj_clone},
{"mapscriptc::layerObj_insertClass", _wrap_layerObj_insertClass},
{"mapscriptc::layerObj_removeClass", _wrap_layerObj_removeClass},
{"mapscriptc::layerObj_open", _wrap_layerObj_open},
{"mapscriptc::layerObj_whichShapes", _wrap_layerObj_whichShapes},
{"mapscriptc::layerObj_nextShape", _wrap_layerObj_nextShape},
{"mapscriptc::layerObj_close", _wrap_layerObj_close},
{"mapscriptc::layerObj_getFeature", _wrap_layerObj_getFeature},
{"mapscriptc::layerObj_getShape", _wrap_layerObj_getShape},
{"mapscriptc::layerObj_getNumResults", _wrap_layerObj_getNumResults},
{"mapscriptc::layerObj_getResult", _wrap_layerObj_getResult},
{"mapscriptc::layerObj_getClass", _wrap_layerObj_getClass},
{"mapscriptc::layerObj_getItem", _wrap_layerObj_getItem},
{"mapscriptc::layerObj_draw", _wrap_layerObj_draw},
{"mapscriptc::layerObj_drawQuery", _wrap_layerObj_drawQuery},
{"mapscriptc::layerObj_queryByAttributes", _wrap_layerObj_queryByAttributes},
{"mapscriptc::layerObj_queryByPoint", _wrap_layerObj_queryByPoint},
{"mapscriptc::layerObj_queryByRect", _wrap_layerObj_queryByRect},
{"mapscriptc::layerObj_queryByFeatures", _wrap_layerObj_queryByFeatures},
{"mapscriptc::layerObj_queryByShape", _wrap_layerObj_queryByShape},
{"mapscriptc::layerObj_queryByIndex", _wrap_layerObj_queryByIndex},
{"mapscriptc::layerObj_getResults", _wrap_layerObj_getResults},
{"mapscriptc::layerObj_setFilter", _wrap_layerObj_setFilter},
{"mapscriptc::layerObj_getFilterString", _wrap_layerObj_getFilterString},
{"mapscriptc::layerObj_setWKTProjection", _wrap_layerObj_setWKTProjection},
{"mapscriptc::layerObj_getProjection", _wrap_layerObj_getProjection},
{"mapscriptc::layerObj_setProjection", _wrap_layerObj_setProjection},
{"mapscriptc::layerObj_addFeature", _wrap_layerObj_addFeature},
{"mapscriptc::layerObj_getNumFeatures", _wrap_layerObj_getNumFeatures},
{"mapscriptc::layerObj_getExtent", _wrap_layerObj_getExtent},
{"mapscriptc::layerObj_setExtent", _wrap_layerObj_setExtent},
{"mapscriptc::layerObj_getMetaData", _wrap_layerObj_getMetaData},
{"mapscriptc::layerObj_setMetaData", _wrap_layerObj_setMetaData},
{"mapscriptc::layerObj_removeMetaData", _wrap_layerObj_removeMetaData},
{"mapscriptc::layerObj_getFirstMetaDataKey", _wrap_layerObj_getFirstMetaDataKey},
{"mapscriptc::layerObj_getNextMetaDataKey", _wrap_layerObj_getNextMetaDataKey},
{"mapscriptc::layerObj_getWMSFeatureInfoURL", _wrap_layerObj_getWMSFeatureInfoURL},
{"mapscriptc::layerObj_executeWFSGetFeature", _wrap_layerObj_executeWFSGetFeature},
{"mapscriptc::layerObj_applySLD", _wrap_layerObj_applySLD},
{"mapscriptc::layerObj_applySLDURL", _wrap_layerObj_applySLDURL},
{"mapscriptc::layerObj_generateSLD", _wrap_layerObj_generateSLD},
{"mapscriptc::layerObj_isVisible", _wrap_layerObj_isVisible},
{"mapscriptc::layerObj_moveClassUp", _wrap_layerObj_moveClassUp},
{"mapscriptc::layerObj_moveClassDown", _wrap_layerObj_moveClassDown},
{"mapscriptc::layerObj_setProcessingKey", _wrap_layerObj_setProcessingKey},
{"mapscriptc::layerObj_setProcessing", _wrap_layerObj_setProcessing},
{"mapscriptc::layerObj_addProcessing", _wrap_layerObj_addProcessing},
{"mapscriptc::layerObj_getProcessing", _wrap_layerObj_getProcessing},
{"mapscriptc::layerObj_clearProcessing", _wrap_layerObj_clearProcessing},
{"mapscriptc::mapObj_name_set", _wrap_mapObj_name_set},
{"mapscriptc::mapObj_name_get", _wrap_mapObj_name_get},
{"mapscriptc::mapObj_status_set", _wrap_mapObj_status_set},
{"mapscriptc::mapObj_status_get", _wrap_mapObj_status_get},
{"mapscriptc::mapObj_height_set", _wrap_mapObj_height_set},
{"mapscriptc::mapObj_height_get", _wrap_mapObj_height_get},
{"mapscriptc::mapObj_width_set", _wrap_mapObj_width_set},
{"mapscriptc::mapObj_width_get", _wrap_mapObj_width_get},
{"mapscriptc::mapObj_maxsize_set", _wrap_mapObj_maxsize_set},
{"mapscriptc::mapObj_maxsize_get", _wrap_mapObj_maxsize_get},
{"mapscriptc::mapObj_numlayers_get", _wrap_mapObj_numlayers_get},
{"mapscriptc::mapObj_symbolset_get", _wrap_mapObj_symbolset_get},
{"mapscriptc::mapObj_fontset_get", _wrap_mapObj_fontset_get},
{"mapscriptc::mapObj_labelcache_get", _wrap_mapObj_labelcache_get},
{"mapscriptc::mapObj_transparent_set", _wrap_mapObj_transparent_set},
{"mapscriptc::mapObj_transparent_get", _wrap_mapObj_transparent_get},
{"mapscriptc::mapObj_interlace_set", _wrap_mapObj_interlace_set},
{"mapscriptc::mapObj_interlace_get", _wrap_mapObj_interlace_get},
{"mapscriptc::mapObj_imagequality_set", _wrap_mapObj_imagequality_set},
{"mapscriptc::mapObj_imagequality_get", _wrap_mapObj_imagequality_get},
{"mapscriptc::mapObj_extent_set", _wrap_mapObj_extent_set},
{"mapscriptc::mapObj_extent_get", _wrap_mapObj_extent_get},
{"mapscriptc::mapObj_cellsize_set", _wrap_mapObj_cellsize_set},
{"mapscriptc::mapObj_cellsize_get", _wrap_mapObj_cellsize_get},
{"mapscriptc::mapObj_saved_extent_set", _wrap_mapObj_saved_extent_set},
{"mapscriptc::mapObj_saved_extent_get", _wrap_mapObj_saved_extent_get},
{"mapscriptc::mapObj_units_set", _wrap_mapObj_units_set},
{"mapscriptc::mapObj_units_get", _wrap_mapObj_units_get},
{"mapscriptc::mapObj_scale_set", _wrap_mapObj_scale_set},
{"mapscriptc::mapObj_scale_get", _wrap_mapObj_scale_get},
{"mapscriptc::mapObj_resolution_set", _wrap_mapObj_resolution_set},
{"mapscriptc::mapObj_resolution_get", _wrap_mapObj_resolution_get},
{"mapscriptc::mapObj_shapepath_set", _wrap_mapObj_shapepath_set},
{"mapscriptc::mapObj_shapepath_get", _wrap_mapObj_shapepath_get},
{"mapscriptc::mapObj_mappath_set", _wrap_mapObj_mappath_set},
{"mapscriptc::mapObj_mappath_get", _wrap_mapObj_mappath_get},
{"mapscriptc::mapObj_imagecolor_set", _wrap_mapObj_imagecolor_set},
{"mapscriptc::mapObj_imagecolor_get", _wrap_mapObj_imagecolor_get},
{"mapscriptc::mapObj_numoutputformats_get", _wrap_mapObj_numoutputformats_get},
{"mapscriptc::mapObj_outputformatlist_get", _wrap_mapObj_outputformatlist_get},
{"mapscriptc::mapObj_outputformat_get", _wrap_mapObj_outputformat_get},
{"mapscriptc::mapObj_imagetype_get", _wrap_mapObj_imagetype_get},
{"mapscriptc::mapObj_reference_get", _wrap_mapObj_reference_get},
{"mapscriptc::mapObj_scalebar_get", _wrap_mapObj_scalebar_get},
{"mapscriptc::mapObj_legend_get", _wrap_mapObj_legend_get},
{"mapscriptc::mapObj_querymap_get", _wrap_mapObj_querymap_get},
{"mapscriptc::mapObj_web_get", _wrap_mapObj_web_get},
{"mapscriptc::mapObj_layerorder_set", _wrap_mapObj_layerorder_set},
{"mapscriptc::mapObj_layerorder_get", _wrap_mapObj_layerorder_get},
{"mapscriptc::mapObj_debug_set", _wrap_mapObj_debug_set},
{"mapscriptc::mapObj_debug_get", _wrap_mapObj_debug_get},
{"mapscriptc::mapObj_datapattern_set", _wrap_mapObj_datapattern_set},
{"mapscriptc::mapObj_datapattern_get", _wrap_mapObj_datapattern_get},
{"mapscriptc::mapObj_templatepattern_set", _wrap_mapObj_templatepattern_set},
{"mapscriptc::mapObj_templatepattern_get", _wrap_mapObj_templatepattern_get},
{"mapscriptc::mapObj_configoptions_get", _wrap_mapObj_configoptions_get},
{"mapscriptc::new_mapObj", _wrap_new_mapObj},
{"mapscriptc::delete_mapObj", _wrap_delete_mapObj},
{"mapscriptc::mapObj_clone", _wrap_mapObj_clone},
{"mapscriptc::mapObj_insertLayer", _wrap_mapObj_insertLayer},
{"mapscriptc::mapObj_removeLayer", _wrap_mapObj_removeLayer},
{"mapscriptc::mapObj_setExtent", _wrap_mapObj_setExtent},
{"mapscriptc::mapObj_setSize", _wrap_mapObj_setSize},
{"mapscriptc::mapObj_setRotation", _wrap_mapObj_setRotation},
{"mapscriptc::mapObj_getLayer", _wrap_mapObj_getLayer},
{"mapscriptc::mapObj_getLayerByName", _wrap_mapObj_getLayerByName},
{"mapscriptc::mapObj_getSymbolByName", _wrap_mapObj_getSymbolByName},
{"mapscriptc::mapObj_prepareQuery", _wrap_mapObj_prepareQuery},
{"mapscriptc::mapObj_prepareImage", _wrap_mapObj_prepareImage},
{"mapscriptc::mapObj_setImageType", _wrap_mapObj_setImageType},
{"mapscriptc::mapObj_selectOutputFormat", _wrap_mapObj_selectOutputFormat},
{"mapscriptc::mapObj_setOutputFormat", _wrap_mapObj_setOutputFormat},
{"mapscriptc::mapObj_draw", _wrap_mapObj_draw},
{"mapscriptc::mapObj_drawQuery", _wrap_mapObj_drawQuery},
{"mapscriptc::mapObj_drawLegend", _wrap_mapObj_drawLegend},
{"mapscriptc::mapObj_drawScalebar", _wrap_mapObj_drawScalebar},
{"mapscriptc::mapObj_drawReferenceMap", _wrap_mapObj_drawReferenceMap},
{"mapscriptc::mapObj_embedScalebar", _wrap_mapObj_embedScalebar},
{"mapscriptc::mapObj_embedLegend", _wrap_mapObj_embedLegend},
{"mapscriptc::mapObj_drawLabelCache", _wrap_mapObj_drawLabelCache},
{"mapscriptc::mapObj_getLabel", _wrap_mapObj_getLabel},
{"mapscriptc::mapObj_nextLabel", _wrap_mapObj_nextLabel},
{"mapscriptc::mapObj_queryByPoint", _wrap_mapObj_queryByPoint},
{"mapscriptc::mapObj_queryByRect", _wrap_mapObj_queryByRect},
{"mapscriptc::mapObj_queryByFeatures", _wrap_mapObj_queryByFeatures},
{"mapscriptc::mapObj_queryByShape", _wrap_mapObj_queryByShape},
{"mapscriptc::mapObj_setWKTProjection", _wrap_mapObj_setWKTProjection},
{"mapscriptc::mapObj_getProjection", _wrap_mapObj_getProjection},
{"mapscriptc::mapObj_setProjection", _wrap_mapObj_setProjection},
{"mapscriptc::mapObj_save", _wrap_mapObj_save},
{"mapscriptc::mapObj_saveQuery", _wrap_mapObj_saveQuery},
{"mapscriptc::mapObj_loadQuery", _wrap_mapObj_loadQuery},
{"mapscriptc::mapObj_freeQuery", _wrap_mapObj_freeQuery},
{"mapscriptc::mapObj_saveQueryAsGML", _wrap_mapObj_saveQueryAsGML},
{"mapscriptc::mapObj_getMetaData", _wrap_mapObj_getMetaData},
{"mapscriptc::mapObj_setMetaData", _wrap_mapObj_setMetaData},
{"mapscriptc::mapObj_removeMetaData", _wrap_mapObj_removeMetaData},
{"mapscriptc::mapObj_getFirstMetaDataKey", _wrap_mapObj_getFirstMetaDataKey},
{"mapscriptc::mapObj_getNextMetaDataKey", _wrap_mapObj_getNextMetaDataKey},
{"mapscriptc::mapObj_setSymbolSet", _wrap_mapObj_setSymbolSet},
{"mapscriptc::mapObj_getNumSymbols", _wrap_mapObj_getNumSymbols},
{"mapscriptc::mapObj_setFontSet", _wrap_mapObj_setFontSet},
{"mapscriptc::mapObj_saveMapContext", _wrap_mapObj_saveMapContext},
{"mapscriptc::mapObj_loadMapContext", _wrap_mapObj_loadMapContext},
{"mapscriptc::mapObj_moveLayerUp", _wrap_mapObj_moveLayerUp},
{"mapscriptc::mapObj_moveLayerDown", _wrap_mapObj_moveLayerDown},
{"mapscriptc::mapObj_getLayersDrawingOrder", _wrap_mapObj_getLayersDrawingOrder},
{"mapscriptc::mapObj_setLayersDrawingOrder", _wrap_mapObj_setLayersDrawingOrder},
{"mapscriptc::mapObj_setConfigOption", _wrap_mapObj_setConfigOption},
{"mapscriptc::mapObj_getConfigOption", _wrap_mapObj_getConfigOption},
{"mapscriptc::mapObj_applyConfigOptions", _wrap_mapObj_applyConfigOptions},
{"mapscriptc::mapObj_applySLD", _wrap_mapObj_applySLD},
{"mapscriptc::mapObj_applySLDURL", _wrap_mapObj_applySLDURL},
{"mapscriptc::mapObj_generateSLD", _wrap_mapObj_generateSLD},
{"mapscriptc::mapObj_processTemplate", _wrap_mapObj_processTemplate},
{"mapscriptc::mapObj_processLegendTemplate", _wrap_mapObj_processLegendTemplate},
{"mapscriptc::mapObj_processQueryTemplate", _wrap_mapObj_processQueryTemplate},
{"mapscriptc::mapObj_getOutputFormatByName", _wrap_mapObj_getOutputFormatByName},
{"mapscriptc::mapObj_appendOutputFormat", _wrap_mapObj_appendOutputFormat},
{"mapscriptc::mapObj_removeOutputFormat", _wrap_mapObj_removeOutputFormat},
{"mapscriptc::mapObj_loadOWSParameters", _wrap_mapObj_loadOWSParameters},
{"mapscriptc::mapObj_OWSDispatch", _wrap_mapObj_OWSDispatch},
{"mapscriptc::mapObj_zoomPoint", _wrap_mapObj_zoomPoint},
{"mapscriptc::mapObj_zoomRectangle", _wrap_mapObj_zoomRectangle},
{"mapscriptc::mapObj_zoomScale", _wrap_mapObj_zoomScale},
{"mapscriptc::imageObj_width_get", _wrap_imageObj_width_get},
{"mapscriptc::imageObj_height_get", _wrap_imageObj_height_get},
{"mapscriptc::imageObj_imagepath_get", _wrap_imageObj_imagepath_get},
{"mapscriptc::imageObj_imageurl_get", _wrap_imageObj_imageurl_get},
{"mapscriptc::imageObj_format_get", _wrap_imageObj_format_get},
{"mapscriptc::imageObj_renderer_set", _wrap_imageObj_renderer_set},
{"mapscriptc::imageObj_renderer_get", _wrap_imageObj_renderer_get},
{"mapscriptc::imageObj_size_set", _wrap_imageObj_size_set},
{"mapscriptc::imageObj_size_get", _wrap_imageObj_size_get},
{"mapscriptc::new_imageObj", _wrap_new_imageObj},
{"mapscriptc::delete_imageObj", _wrap_delete_imageObj},
{"mapscriptc::imageObj_save", _wrap_imageObj_save},
{"mapscriptc::imageObj_write", _wrap_imageObj_write},
{"mapscriptc::imageObj_getBytes", _wrap_imageObj_getBytes},
{"mapscriptc::msSaveImage", _wrap_msSaveImage},
{"mapscriptc::msFreeImage", _wrap_msFreeImage},
{"mapscriptc::msSetup", _wrap_msSetup},
{"mapscriptc::msCleanup", _wrap_msCleanup},
{"mapscriptc::rectObj_minx_set", _wrap_rectObj_minx_set},
{"mapscriptc::rectObj_minx_get", _wrap_rectObj_minx_get},
{"mapscriptc::rectObj_miny_set", _wrap_rectObj_miny_set},
{"mapscriptc::rectObj_miny_get", _wrap_rectObj_miny_get},
{"mapscriptc::rectObj_maxx_set", _wrap_rectObj_maxx_set},
{"mapscriptc::rectObj_maxx_get", _wrap_rectObj_maxx_get},
{"mapscriptc::rectObj_maxy_set", _wrap_rectObj_maxy_set},
{"mapscriptc::rectObj_maxy_get", _wrap_rectObj_maxy_get},
{"mapscriptc::new_rectObj", _wrap_new_rectObj},
{"mapscriptc::delete_rectObj", _wrap_delete_rectObj},
{"mapscriptc::rectObj_project", _wrap_rectObj_project},
{"mapscriptc::rectObj_fit", _wrap_rectObj_fit},
{"mapscriptc::rectObj_draw", _wrap_rectObj_draw},
{"mapscriptc::rectObj_toPolygon", _wrap_rectObj_toPolygon},
{"mapscriptc::rectObj_toString", _wrap_rectObj_toString},
{"mapscriptc::pointObj_x_set", _wrap_pointObj_x_set},
{"mapscriptc::pointObj_x_get", _wrap_pointObj_x_get},
{"mapscriptc::pointObj_y_set", _wrap_pointObj_y_set},
{"mapscriptc::pointObj_y_get", _wrap_pointObj_y_get},
{"mapscriptc::new_pointObj", _wrap_new_pointObj},
{"mapscriptc::delete_pointObj", _wrap_delete_pointObj},
{"mapscriptc::pointObj_project", _wrap_pointObj_project},
{"mapscriptc::pointObj_draw", _wrap_pointObj_draw},
{"mapscriptc::pointObj_distanceToPoint", _wrap_pointObj_distanceToPoint},
{"mapscriptc::pointObj_distanceToSegment", _wrap_pointObj_distanceToSegment},
{"mapscriptc::pointObj_distanceToShape", _wrap_pointObj_distanceToShape},
{"mapscriptc::pointObj_setXY", _wrap_pointObj_setXY},
{"mapscriptc::pointObj_setXYZ", _wrap_pointObj_setXYZ},
{"mapscriptc::pointObj_setXYZM", _wrap_pointObj_setXYZM},
{"mapscriptc::pointObj_toString", _wrap_pointObj_toString},
{"mapscriptc::pointObj_toShape", _wrap_pointObj_toShape},
{"mapscriptc::lineObj_numpoints_get", _wrap_lineObj_numpoints_get},
{"mapscriptc::lineObj_point_get", _wrap_lineObj_point_get},
{"mapscriptc::new_lineObj", _wrap_new_lineObj},
{"mapscriptc::delete_lineObj", _wrap_delete_lineObj},
{"mapscriptc::lineObj_project", _wrap_lineObj_project},
{"mapscriptc::lineObj_get", _wrap_lineObj_get},
{"mapscriptc::lineObj_add", _wrap_lineObj_add},
{"mapscriptc::lineObj_set", _wrap_lineObj_set},
{"mapscriptc::shapeObj_numlines_get", _wrap_shapeObj_numlines_get},
{"mapscriptc::shapeObj_numvalues_get", _wrap_shapeObj_numvalues_get},
{"mapscriptc::shapeObj_line_get", _wrap_shapeObj_line_get},
{"mapscriptc::shapeObj_values_get", _wrap_shapeObj_values_get},
{"mapscriptc::shapeObj_bounds_set", _wrap_shapeObj_bounds_set},
{"mapscriptc::shapeObj_bounds_get", _wrap_shapeObj_bounds_get},
{"mapscriptc::shapeObj_type_set", _wrap_shapeObj_type_set},
{"mapscriptc::shapeObj_type_get", _wrap_shapeObj_type_get},
{"mapscriptc::shapeObj_index_set", _wrap_shapeObj_index_set},
{"mapscriptc::shapeObj_index_get", _wrap_shapeObj_index_get},
{"mapscriptc::shapeObj_tileindex_set", _wrap_shapeObj_tileindex_set},
{"mapscriptc::shapeObj_tileindex_get", _wrap_shapeObj_tileindex_get},
{"mapscriptc::shapeObj_classindex_set", _wrap_shapeObj_classindex_set},
{"mapscriptc::shapeObj_classindex_get", _wrap_shapeObj_classindex_get},
{"mapscriptc::shapeObj_text_set", _wrap_shapeObj_text_set},
{"mapscriptc::shapeObj_text_get", _wrap_shapeObj_text_get},
{"mapscriptc::new_shapeObj", _wrap_new_shapeObj},
{"mapscriptc::delete_shapeObj", _wrap_delete_shapeObj},
{"mapscriptc::shapeObj_fromWKT", _wrap_shapeObj_fromWKT},
{"mapscriptc::shapeObj_project", _wrap_shapeObj_project},
{"mapscriptc::shapeObj_get", _wrap_shapeObj_get},
{"mapscriptc::shapeObj_add", _wrap_shapeObj_add},
{"mapscriptc::shapeObj_draw", _wrap_shapeObj_draw},
{"mapscriptc::shapeObj_setBounds", _wrap_shapeObj_setBounds},
{"mapscriptc::shapeObj_clone", _wrap_shapeObj_clone},
{"mapscriptc::shapeObj_copy", _wrap_shapeObj_copy},
{"mapscriptc::shapeObj_toWKT", _wrap_shapeObj_toWKT},
{"mapscriptc::shapeObj_buffer", _wrap_shapeObj_buffer},
{"mapscriptc::shapeObj_convexHull", _wrap_shapeObj_convexHull},
{"mapscriptc::shapeObj_boundary", _wrap_shapeObj_boundary},
{"mapscriptc::shapeObj_getCentroid", _wrap_shapeObj_getCentroid},
{"mapscriptc::shapeObj_Union", _wrap_shapeObj_Union},
{"mapscriptc::shapeObj_intersection", _wrap_shapeObj_intersection},
{"mapscriptc::shapeObj_difference", _wrap_shapeObj_difference},
{"mapscriptc::shapeObj_symDifference", _wrap_shapeObj_symDifference},
{"mapscriptc::shapeObj_overlaps", _wrap_shapeObj_overlaps},
{"mapscriptc::shapeObj_within", _wrap_shapeObj_within},
{"mapscriptc::shapeObj_crosses", _wrap_shapeObj_crosses},
{"mapscriptc::shapeObj_intersects", _wrap_shapeObj_intersects},
{"mapscriptc::shapeObj_touches", _wrap_shapeObj_touches},
{"mapscriptc::shapeObj_equals", _wrap_shapeObj_equals},
{"mapscriptc::shapeObj_disjoint", _wrap_shapeObj_disjoint},
{"mapscriptc::shapeObj_getArea", _wrap_shapeObj_getArea},
{"mapscriptc::shapeObj_getLength", _wrap_shapeObj_getLength},
{"mapscriptc::shapeObj_getValue", _wrap_shapeObj_getValue},
{"mapscriptc::shapeObj_contains", _wrap_shapeObj_contains},
{"mapscriptc::shapeObj_distanceToPoint", _wrap_shapeObj_distanceToPoint},
{"mapscriptc::shapeObj_distanceToShape", _wrap_shapeObj_distanceToShape},
{"mapscriptc::shapeObj_setValue", _wrap_shapeObj_setValue},
{"mapscriptc::shapeObj_initValues", _wrap_shapeObj_initValues},
{"mapscriptc::DBFInfo_fp_get", _wrap_DBFInfo_fp_get},
{"mapscriptc::DBFInfo_nRecords_get", _wrap_DBFInfo_nRecords_get},
{"mapscriptc::DBFInfo_nRecordLength_get", _wrap_DBFInfo_nRecordLength_get},
{"mapscriptc::DBFInfo_nHeaderLength_get", _wrap_DBFInfo_nHeaderLength_get},
{"mapscriptc::DBFInfo_nFields_get", _wrap_DBFInfo_nFields_get},
{"mapscriptc::DBFInfo_panFieldOffset_get", _wrap_DBFInfo_panFieldOffset_get},
{"mapscriptc::DBFInfo_panFieldSize_get", _wrap_DBFInfo_panFieldSize_get},
{"mapscriptc::DBFInfo_panFieldDecimals_get", _wrap_DBFInfo_panFieldDecimals_get},
{"mapscriptc::DBFInfo_pachFieldType_get", _wrap_DBFInfo_pachFieldType_get},
{"mapscriptc::DBFInfo_pszHeader_get", _wrap_DBFInfo_pszHeader_get},
{"mapscriptc::DBFInfo_nCurrentRecord_get", _wrap_DBFInfo_nCurrentRecord_get},
{"mapscriptc::DBFInfo_bCurrentRecordModified_get", _wrap_DBFInfo_bCurrentRecordModified_get},
{"mapscriptc::DBFInfo_pszCurrentRecord_get", _wrap_DBFInfo_pszCurrentRecord_get},
{"mapscriptc::DBFInfo_bNoHeader_get", _wrap_DBFInfo_bNoHeader_get},
{"mapscriptc::DBFInfo_bUpdated_get", _wrap_DBFInfo_bUpdated_get},
{"mapscriptc::DBFInfo_pszStringField_get", _wrap_DBFInfo_pszStringField_get},
{"mapscriptc::DBFInfo_nStringFieldLen_get", _wrap_DBFInfo_nStringFieldLen_get},
{"mapscriptc::DBFInfo_getFieldName", _wrap_DBFInfo_getFieldName},
{"mapscriptc::DBFInfo_getFieldWidth", _wrap_DBFInfo_getFieldWidth},
{"mapscriptc::DBFInfo_getFieldDecimals", _wrap_DBFInfo_getFieldDecimals},
{"mapscriptc::DBFInfo_getFieldType", _wrap_DBFInfo_getFieldType},
{"mapscriptc::new_DBFInfo", _wrap_new_DBFInfo},
{"mapscriptc::delete_DBFInfo", _wrap_delete_DBFInfo},
{"mapscriptc::shapefileObj_source_get", _wrap_shapefileObj_source_get},
{"mapscriptc::shapefileObj_type_get", _wrap_shapefileObj_type_get},
{"mapscriptc::shapefileObj_numshapes_get", _wrap_shapefileObj_numshapes_get},
{"mapscriptc::shapefileObj_bounds_get", _wrap_shapefileObj_bounds_get},
{"mapscriptc::shapefileObj_lastshape_get", _wrap_shapefileObj_lastshape_get},
{"mapscriptc::shapefileObj_status_get", _wrap_shapefileObj_status_get},
{"mapscriptc::shapefileObj_statusbounds_get", _wrap_shapefileObj_statusbounds_get},
{"mapscriptc::shapefileObj_isopen_get", _wrap_shapefileObj_isopen_get},
{"mapscriptc::new_shapefileObj", _wrap_new_shapefileObj},
{"mapscriptc::delete_shapefileObj", _wrap_delete_shapefileObj},
{"mapscriptc::shapefileObj_get", _wrap_shapefileObj_get},
{"mapscriptc::shapefileObj_getShape", _wrap_shapefileObj_getShape},
{"mapscriptc::shapefileObj_getPoint", _wrap_shapefileObj_getPoint},
{"mapscriptc::shapefileObj_getTransformed", _wrap_shapefileObj_getTransformed},
{"mapscriptc::shapefileObj_getExtent", _wrap_shapefileObj_getExtent},
{"mapscriptc::shapefileObj_add", _wrap_shapefileObj_add},
{"mapscriptc::shapefileObj_addPoint", _wrap_shapefileObj_addPoint},
{"mapscriptc::projectionObj_numargs_get", _wrap_projectionObj_numargs_get},
{"mapscriptc::new_projectionObj", _wrap_new_projectionObj},
{"mapscriptc::delete_projectionObj", _wrap_delete_projectionObj},
{"mapscriptc::colorObj_pen_set", _wrap_colorObj_pen_set},
{"mapscriptc::colorObj_pen_get", _wrap_colorObj_pen_get},
{"mapscriptc::colorObj_red_set", _wrap_colorObj_red_set},
{"mapscriptc::colorObj_red_get", _wrap_colorObj_red_get},
{"mapscriptc::colorObj_green_set", _wrap_colorObj_green_set},
{"mapscriptc::colorObj_green_get", _wrap_colorObj_green_get},
{"mapscriptc::colorObj_blue_set", _wrap_colorObj_blue_set},
{"mapscriptc::colorObj_blue_get", _wrap_colorObj_blue_get},
{"mapscriptc::new_colorObj", _wrap_new_colorObj},
{"mapscriptc::delete_colorObj", _wrap_delete_colorObj},
{"mapscriptc::colorObj_setRGB", _wrap_colorObj_setRGB},
{"mapscriptc::colorObj_setHex", _wrap_colorObj_setHex},
{"mapscriptc::colorObj_toHex", _wrap_colorObj_toHex},
{"mapscriptc::symbolObj_name_set", _wrap_symbolObj_name_set},
{"mapscriptc::symbolObj_name_get", _wrap_symbolObj_name_get},
{"mapscriptc::symbolObj_type_set", _wrap_symbolObj_type_set},
{"mapscriptc::symbolObj_type_get", _wrap_symbolObj_type_get},
{"mapscriptc::symbolObj_sizex_set", _wrap_symbolObj_sizex_set},
{"mapscriptc::symbolObj_sizex_get", _wrap_symbolObj_sizex_get},
{"mapscriptc::symbolObj_sizey_set", _wrap_symbolObj_sizey_set},
{"mapscriptc::symbolObj_sizey_get", _wrap_symbolObj_sizey_get},
{"mapscriptc::symbolObj_numpoints_get", _wrap_symbolObj_numpoints_get},
{"mapscriptc::symbolObj_filled_set", _wrap_symbolObj_filled_set},
{"mapscriptc::symbolObj_filled_get", _wrap_symbolObj_filled_get},
{"mapscriptc::symbolObj_stylelength_set", _wrap_symbolObj_stylelength_set},
{"mapscriptc::symbolObj_stylelength_get", _wrap_symbolObj_stylelength_get},
{"mapscriptc::symbolObj_style_set", _wrap_symbolObj_style_set},
{"mapscriptc::symbolObj_style_get", _wrap_symbolObj_style_get},
{"mapscriptc::symbolObj_imagepath_get", _wrap_symbolObj_imagepath_get},
{"mapscriptc::symbolObj_transparent_set", _wrap_symbolObj_transparent_set},
{"mapscriptc::symbolObj_transparent_get", _wrap_symbolObj_transparent_get},
{"mapscriptc::symbolObj_transparentcolor_set", _wrap_symbolObj_transparentcolor_set},
{"mapscriptc::symbolObj_transparentcolor_get", _wrap_symbolObj_transparentcolor_get},
{"mapscriptc::symbolObj_character_set", _wrap_symbolObj_character_set},
{"mapscriptc::symbolObj_character_get", _wrap_symbolObj_character_get},
{"mapscriptc::symbolObj_antialias_set", _wrap_symbolObj_antialias_set},
{"mapscriptc::symbolObj_antialias_get", _wrap_symbolObj_antialias_get},
{"mapscriptc::symbolObj_font_set", _wrap_symbolObj_font_set},
{"mapscriptc::symbolObj_font_get", _wrap_symbolObj_font_get},
{"mapscriptc::symbolObj_gap_set", _wrap_symbolObj_gap_set},
{"mapscriptc::symbolObj_gap_get", _wrap_symbolObj_gap_get},
{"mapscriptc::symbolObj_position_set", _wrap_symbolObj_position_set},
{"mapscriptc::symbolObj_position_get", _wrap_symbolObj_position_get},
{"mapscriptc::symbolObj_linecap_set", _wrap_symbolObj_linecap_set},
{"mapscriptc::symbolObj_linecap_get", _wrap_symbolObj_linecap_get},
{"mapscriptc::symbolObj_linejoin_set", _wrap_symbolObj_linejoin_set},
{"mapscriptc::symbolObj_linejoin_get", _wrap_symbolObj_linejoin_get},
{"mapscriptc::symbolObj_linejoinmaxsize_set", _wrap_symbolObj_linejoinmaxsize_set},
{"mapscriptc::symbolObj_linejoinmaxsize_get", _wrap_symbolObj_linejoinmaxsize_get},
{"mapscriptc::new_symbolObj", _wrap_new_symbolObj},
{"mapscriptc::delete_symbolObj", _wrap_delete_symbolObj},
{"mapscriptc::symbolObj_setImagepath", _wrap_symbolObj_setImagepath},
{"mapscriptc::symbolObj_setPoints", _wrap_symbolObj_setPoints},
{"mapscriptc::symbolObj_getPoints", _wrap_symbolObj_getPoints},
{"mapscriptc::symbolObj_setStyle", _wrap_symbolObj_setStyle},
{"mapscriptc::symbolObj_getImage", _wrap_symbolObj_getImage},
{"mapscriptc::symbolObj_setImage", _wrap_symbolObj_setImage},
{"mapscriptc::errorObj_code_set", _wrap_errorObj_code_set},
{"mapscriptc::errorObj_code_get", _wrap_errorObj_code_get},
{"mapscriptc::errorObj_routine_set", _wrap_errorObj_routine_set},
{"mapscriptc::errorObj_routine_get", _wrap_errorObj_routine_get},
{"mapscriptc::errorObj_message_set", _wrap_errorObj_message_set},
{"mapscriptc::errorObj_message_get", _wrap_errorObj_message_get},
{"mapscriptc::new_errorObj", _wrap_new_errorObj},
{"mapscriptc::delete_errorObj", _wrap_delete_errorObj},
{"mapscriptc::errorObj_next", _wrap_errorObj_next},
{"mapscriptc::msGetErrorObj", _wrap_msGetErrorObj},
{"mapscriptc::msResetErrorList", _wrap_msResetErrorList},
{"mapscriptc::msGetVersion", _wrap_msGetVersion},
{"mapscriptc::msGetErrorString", _wrap_msGetErrorString},
{"mapscriptc::hashTableObj_numitems_get", _wrap_hashTableObj_numitems_get},
{"mapscriptc::new_hashTableObj", _wrap_new_hashTableObj},
{"mapscriptc::delete_hashTableObj", _wrap_delete_hashTableObj},
{"mapscriptc::hashTableObj_set", _wrap_hashTableObj_set},
{"mapscriptc::hashTableObj_get", _wrap_hashTableObj_get},
{"mapscriptc::hashTableObj_remove", _wrap_hashTableObj_remove},
{"mapscriptc::hashTableObj_clear", _wrap_hashTableObj_clear},
{"mapscriptc::hashTableObj_nextKey", _wrap_hashTableObj_nextKey},
{"mapscriptc::OWSRequest_NumParams_get", _wrap_OWSRequest_NumParams_get},
{"mapscriptc::OWSRequest_type_set", _wrap_OWSRequest_type_set},
{"mapscriptc::OWSRequest_type_get", _wrap_OWSRequest_type_get},
{"mapscriptc::OWSRequest_contenttype_set", _wrap_OWSRequest_contenttype_set},
{"mapscriptc::OWSRequest_contenttype_get", _wrap_OWSRequest_contenttype_get},
{"mapscriptc::OWSRequest_postrequest_set", _wrap_OWSRequest_postrequest_set},
{"mapscriptc::OWSRequest_postrequest_get", _wrap_OWSRequest_postrequest_get},
{"mapscriptc::new_OWSRequest", _wrap_new_OWSRequest},
{"mapscriptc::delete_OWSRequest", _wrap_delete_OWSRequest},
{"mapscriptc::OWSRequest_loadParams", _wrap_OWSRequest_loadParams},
{"mapscriptc::OWSRequest_setParameter", _wrap_OWSRequest_setParameter},
{"mapscriptc::OWSRequest_getName", _wrap_OWSRequest_getName},
{"mapscriptc::OWSRequest_getValue", _wrap_OWSRequest_getValue},
{"mapscriptc::OWSRequest_getValueByName", _wrap_OWSRequest_getValueByName},
{"mapscriptc::msConnPoolCloseUnreferenced", _wrap_msConnPoolCloseUnreferenced},
{"mapscriptc::msIO_resetHandlers", _wrap_msIO_resetHandlers},
{"mapscriptc::msIO_installStdoutToBuffer", _wrap_msIO_installStdoutToBuffer},
{"mapscriptc::msIO_installStdinFromBuffer", _wrap_msIO_installStdinFromBuffer},
{"mapscriptc::msIO_stripStdoutBufferContentType", _wrap_msIO_stripStdoutBufferContentType},
{"mapscriptc::msIO_getStdoutBufferString", _wrap_msIO_getStdoutBufferString},
{"mapscriptc::msIO_getStdoutBufferBytes", _wrap_msIO_getStdoutBufferBytes},
{0,0}
};

#ifdef __cplusplus
extern "C"
#endif

XS(SWIG_init) {
    dXSARGS;
    int i;
    static int _init = 0;
    if (!_init) {
        for (i = 0; swig_types_initial[i]; i++) {
            swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        }	
        _init = 1;
    }
    
    /* Install commands */
    for (i = 0; swig_commands[i].name; i++) {
        newXS((char*) swig_commands[i].name,swig_commands[i].wrapper, (char*)__FILE__);
    }
    
    /* Install variables */
    for (i = 0; swig_variables[i].name; i++) {
        SV *sv;
        sv = perl_get_sv((char*) swig_variables[i].name, TRUE | 0x2);
        if (swig_variables[i].type) {
            SWIG_MakePtr(sv,(void *)1, *swig_variables[i].type,0);
        } else {
            sv_setiv(sv,(IV) 0);
        }
        swig_create_magic(sv, (char *) swig_variables[i].name, swig_variables[i].set, swig_variables[i].get); 
    }
    
    /* Install constant */
    for (i = 0; swig_constants[i].type; i++) {
        SV *sv;
        sv = perl_get_sv((char*)swig_constants[i].name, TRUE | 0x2);
        switch(swig_constants[i].type) {
            case SWIG_INT:
            sv_setiv(sv, (IV) swig_constants[i].lvalue);
            break;
            case SWIG_FLOAT:
            sv_setnv(sv, (double) swig_constants[i].dvalue);
            break;
            case SWIG_STRING:
            sv_setpv(sv, (char *) swig_constants[i].pvalue);
            break;
            case SWIG_POINTER:
            SWIG_MakePtr(sv, swig_constants[i].pvalue, *(swig_constants[i].ptype),0);
            break;
            case SWIG_BINARY:
            SWIG_MakePackedObj(sv, swig_constants[i].pvalue, swig_constants[i].lvalue, *(swig_constants[i].ptype));
            break;
            default:
            break;
        }
        SvREADONLY_on(sv);
    }
    
    SWIG_TypeClientData(SWIGTYPE_p_intarray, (void*) "mapscript::intarray");
    
    if(msSetup() != MS_SUCCESS) {
        msSetError(MS_MISCERR, "Error initializing MapServer/Mapscript.", "msSetup()");
    }
    
    SWIG_TypeClientData(SWIGTYPE_p_fontSetObj, (void*) "mapscript::fontSetObj");
    SWIG_TypeClientData(SWIGTYPE_p_outputFormatObj, (void*) "mapscript::outputFormatObj");
    SWIG_TypeClientData(SWIGTYPE_p_queryMapObj, (void*) "mapscript::queryMapObj");
    SWIG_TypeClientData(SWIGTYPE_p_labelObj, (void*) "mapscript::labelObj");
    SWIG_TypeClientData(SWIGTYPE_p_webObj, (void*) "mapscript::webObj");
    SWIG_TypeClientData(SWIGTYPE_p_styleObj, (void*) "mapscript::styleObj");
    SWIG_TypeClientData(SWIGTYPE_p_classObj, (void*) "mapscript::classObj");
    SWIG_TypeClientData(SWIGTYPE_p_labelCacheMemberObj, (void*) "mapscript::labelCacheMemberObj");
    SWIG_TypeClientData(SWIGTYPE_p_markerCacheMemberObj, (void*) "mapscript::markerCacheMemberObj");
    SWIG_TypeClientData(SWIGTYPE_p_labelCacheObj, (void*) "mapscript::labelCacheObj");
    SWIG_TypeClientData(SWIGTYPE_p_resultCacheMemberObj, (void*) "mapscript::resultCacheMemberObj");
    SWIG_TypeClientData(SWIGTYPE_p_resultCacheObj, (void*) "mapscript::resultCacheObj");
    SWIG_TypeClientData(SWIGTYPE_p_symbolSetObj, (void*) "mapscript::symbolSetObj");
    SWIG_TypeClientData(SWIGTYPE_p_referenceMapObj, (void*) "mapscript::referenceMapObj");
    SWIG_TypeClientData(SWIGTYPE_p_scalebarObj, (void*) "mapscript::scalebarObj");
    SWIG_TypeClientData(SWIGTYPE_p_legendObj, (void*) "mapscript::legendObj");
    SWIG_TypeClientData(SWIGTYPE_p_layerObj, (void*) "mapscript::layerObj");
    SWIG_TypeClientData(SWIGTYPE_p_mapObj, (void*) "mapscript::mapObj");
    SWIG_TypeClientData(SWIGTYPE_p_imageObj, (void*) "mapscript::imageObj");
    SWIG_TypeClientData(SWIGTYPE_p_rectObj, (void*) "mapscript::rectObj");
    SWIG_TypeClientData(SWIGTYPE_p_pointObj, (void*) "mapscript::pointObj");
    SWIG_TypeClientData(SWIGTYPE_p_lineObj, (void*) "mapscript::lineObj");
    SWIG_TypeClientData(SWIGTYPE_p_shapeObj, (void*) "mapscript::shapeObj");
    SWIG_TypeClientData(SWIGTYPE_p_DBFInfo, (void*) "mapscript::DBFInfo");
    SWIG_TypeClientData(SWIGTYPE_p_shapefileObj, (void*) "mapscript::shapefileObj");
    SWIG_TypeClientData(SWIGTYPE_p_projectionObj, (void*) "mapscript::projectionObj");
    SWIG_TypeClientData(SWIGTYPE_p_colorObj, (void*) "mapscript::colorObj");
    SWIG_TypeClientData(SWIGTYPE_p_symbolObj, (void*) "mapscript::symbolObj");
    SWIG_TypeClientData(SWIGTYPE_p_errorObj, (void*) "mapscript::errorObj");
    SWIG_TypeClientData(SWIGTYPE_p_hashTableObj, (void*) "mapscript::hashTableObj");
    SWIG_TypeClientData(SWIGTYPE_p_cgiRequestObj, (void*) "mapscript::OWSRequest");
    ST(0) = &PL_sv_yes;
    XSRETURN(1);
}

