.\" Hey, Emacs!  This is an -*- nroff -*- source file.
.\" run-mailcap and this manpage were written by Brian White and
.\" have been placed in the public domain (the only true "free").
.\"
.TH RUN-MAILCAP 1 "14th Mar 1998" "Debian Project" "Run Mailcap Programs"
.SH NAME
run-mailcap, see, edit, compose, print \- execute programs via entries in the
.I mailcap
file
.SH SYNOPSIS
.B run-mailcap
\-\-action=<action> [\-\-debug=<value>]
[<mime-type>:[<encoding>:]]<filename>  [...]

The
.BR see ,
.BR edit ,
.B compose
and
.B print
versions are just aliases that default to the view, edit, compose, and
print actions (respectively).

You can make this your default pager and/or editor by adding the
following to your shell startup:

  shell  file        line(s) to add
  ~~~~~  ~~~~~~~~~~  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  sh     ~/.profile  PAGER=/usr/bin/see; export PAGER
                     EDITOR=/usr/bin/edit; export EDITOR
  csh    ~/.login    setenv PAGER /usr/bin/see
                     setenv EDITOR /usr/bin/edit

.SH DESCRIPTION
.PP
.B run-mailcap
(or any of its aliases) will use the given action to process each
mime-type/file in turn.  Each file is is specified as its mime-type,
its encoding (eg. compression), and filename together, separated by
colons.  If the mime-type is omitted, an attempt to determine the type
is made by trying to match the file's extension with those in the
.I mime.types
files.  If the encoding is omitted, it will also be determined from
the file's extensions.  Currently supported encodings are
.B gzip
(.gz) and
.B compress
(.Z).  A filename of "-" can be used to mean "standard input", but
then a mime-type
.B must
be specied.

Both the user's files (~/.mailcap; ~/.mime.types) and the system files
(/etc/mailcap; /etc/mime.types) are searched in turn for information.
.SS OPTIONS
All options are in the form --<opt>=<value>.
.TP
.BI \-\-action=<action>
Performs the specified action on the files.  Valid actions are
.IR view ,
.IR compose ,
.IR composetyped ,
.I edit
and
.IR print .
If no action is specified, the action will be determined by how the
program was called.
.TP
.BI \-\-debug=<value>
Turns on extra information to find out what is happening.  Any value
other than zero (0) will turn on debugging output.
.SH "SEE ALSO"
.BR update-mime "(8)"
.SH AUTHOR
.B run-mailcap
(and its aliases) was written by Brian White <bcwhite@pobox.com>.
.SH COPYRIGHT
.B run-mailcap
(and its aliases) is in the public domain (the only true "free").
