#**** neon Win32 -*- Makefile -*- ********************************************
#
# Define DEBUG_BUILD to create a debug version of the library.

!IF "$(OS)" == "Windows_NT"
NULL=
!ELSE
NULL=nul
!ENDIF


########
# Support for Expat integration
!IF "$(EXPAT_SRC)" == ""
EXPAT_FLAGS =
!ELSE
EXPAT_FLAGS = /I "$(EXPAT_SRC)"
!ENDIF

########
# Support for OpenSSL integration
!IF "$(OPENSSL_SRC)" == ""
OPENSSL_FLAGS =
!ELSE
OPENSSL_FLAGS = /I "$(OPENSSL_SRC)\inc" /D NEON_SSL
!ENDIF

########
# Support for zlib integration
!IF "$(ZLIB_SRC)" == ""
ZLIB_FLAGS =
ZLIB_LIBS =
!ELSE
ZLIB_FLAGS = /I "$(ZLIB_SRC)" /D NEON_ZLIB
!IF "$(ZLIB_DLL)" == ""
ZLIB_LIBS = "$(ZLIB_SRC)\zlibstat.lib"
!ELSE
ZLIB_FLAGS = $(ZLIB_FLAGS) /D ZLIB_DLL
ZLIB_LIBS = "$(ZLIB_SRC)\zlibdll.lib"
!ENDIF
!ENDIF


!IF "$(DEBUG_BUILD)" == ""
INTDIR = Release
CFLAGS = /MD /W3 /GX /O2 /D "_DEBUG"
TARGET = .\libneon.lib
!ELSE
INTDIR = Debug
CFLAGS = /MDd /W3 /Gm /GX /Zi /Od /D "NDEBUG"
TARGET = .\libneonD.lib
!ENDIF


CPP=cl.exe
CPP_PROJ = /c /nologo $(CFLAGS) $(EXPAT_FLAGS) $(OPENSSL_FLAGS) $(ZLIB_FLAGS) /D "HAVE_CONFIG_H" /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\"
LIB32=link.exe -lib
LIB32_FLAGS=/nologo /out:"$(TARGET)"
LIB32_OBJS= \
	"$(INTDIR)\base64.obj" \
	"$(INTDIR)\ne_xml.obj" \
	"$(INTDIR)\ne_acl.obj" \
	"$(INTDIR)\ne_alloc.obj" \
	"$(INTDIR)\ne_auth.obj" \
	"$(INTDIR)\ne_basic.obj" \
	"$(INTDIR)\ne_cookies.obj" \
	"$(INTDIR)\ne_dates.obj" \
	"$(INTDIR)\ne_i18n.obj" \
	"$(INTDIR)\ne_locks.obj" \
	"$(INTDIR)\ne_md5.obj" \
	"$(INTDIR)\ne_props.obj" \
	"$(INTDIR)\ne_redirect.obj" \
	"$(INTDIR)\ne_request.obj" \
	"$(INTDIR)\ne_session.obj" \
	"$(INTDIR)\ne_socket.obj" \
	"$(INTDIR)\ne_string.obj" \
	"$(INTDIR)\ne_uri.obj" \
	"$(INTDIR)\ne_utils.obj" \
	"$(INTDIR)\ne_207.obj"


!IF "$(OPENSSL_SRC)" != ""
LIB32_OBJS = $(LIB32_OBJS) $(OPENSSL_SRC)\lib\libeay32.lib \
			   $(OPENSSL_SRC)\lib\ssleay32.lib
!ENDIF
!IF "$(ZLIB_SRC)" != ""
LIB32_OBJS = $(LIB32_OBJS) "$(INTDIR)\ne_compress.obj" $(ZLIB_LIBS)
!ENDIF


ALL: ".\src\config.h" "$(TARGET)"

CLEAN:
	-@erase "$(INTDIR)\base64.obj"
	-@erase "$(INTDIR)\ne_207.obj"
	-@erase "$(INTDIR)\ne_alloc.obj"
	-@erase "$(INTDIR)\ne_acl.obj"
	-@erase "$(INTDIR)\ne_auth.obj"
	-@erase "$(INTDIR)\ne_basic.obj"
	-@erase "$(INTDIR)\ne_compress.obj"
	-@erase "$(INTDIR)\ne_cookies.obj"
	-@erase "$(INTDIR)\ne_dates.obj"
	-@erase "$(INTDIR)\ne_i18n.obj"
	-@erase "$(INTDIR)\ne_locks.obj"
	-@erase "$(INTDIR)\ne_md5.obj"
	-@erase "$(INTDIR)\ne_props.obj"
	-@erase "$(INTDIR)\ne_redirect.obj"
	-@erase "$(INTDIR)\ne_request.obj"
	-@erase "$(INTDIR)\ne_session.obj"
	-@erase "$(INTDIR)\ne_socket.obj"
	-@erase "$(INTDIR)\ne_string.obj"
	-@erase "$(INTDIR)\ne_uri.obj"
	-@erase "$(INTDIR)\ne_utils.obj"
	-@erase "$(INTDIR)\ne_xml.obj"
	-@erase "$(TARGET)"
	-@erase ".\src\config.h"

"$(TARGET)": $(DEF_FILE) $(LIB32_OBJS)
	-@if not exist "$(INTDIR)/$(NULL)" mkdir "$(INTDIR)"
	$(LIB32) @<<
  $(LIB32_FLAGS) $(DEF_FLAGS) $(LIB32_OBJS)
<<

{src}.c{$(INTDIR)}.obj::
	-@if not exist "$(INTDIR)/$(NULL)" mkdir "$(INTDIR)"
	$(CPP) @<<
  $(CPP_PROJ) $<
<<

".\src\config.h": config.hw
	-@if not exist "$(INTDIR)/$(NULL)" mkdir "$(INTDIR)"
	<<tempfile.bat
  @echo off
  copy .\config.hw .\src\config.h > nul
  echo Created config.h from config.hw
<<

"$(INTDIR)\base64.obj":      .\src\base64.c
"$(INTDIR)\ne_207.obj":      .\src\ne_207.c
"$(INTDIR)\ne_alloc.obj":    .\src\ne_alloc.c
"$(INTDIR)\ne_acl.obj":      .\src\ne_acl.c
"$(INTDIR)\ne_auth.obj":     .\src\ne_auth.c
"$(INTDIR)\ne_basic.obj":    .\src\ne_basic.c
"$(INTDIR)\ne_compress.obj": .\src\ne_compress.c
"$(INTDIR)\ne_cookies.obj":  .\src\ne_cookies.c
"$(INTDIR)\ne_dates.obj":    .\src\ne_dates.c
"$(INTDIR)\ne_i18n.obj":     .\src\ne_i18n.c
"$(INTDIR)\ne_locks.obj":    .\src\ne_locks.c
"$(INTDIR)\ne_md5.obj":      .\src\ne_md5.c
"$(INTDIR)\ne_props.obj":    .\src\ne_props.c
"$(INTDIR)\ne_redirect.obj": .\src\ne_redirect.c
"$(INTDIR)\ne_request.obj":  .\src\ne_request.c
"$(INTDIR)\ne_session.obj":  .\src\ne_session.c
"$(INTDIR)\ne_socket.obj":   .\src\ne_socket.c
"$(INTDIR)\ne_string.obj":   .\src\ne_string.c
"$(INTDIR)\ne_uri.obj":      .\src\ne_uri.c
"$(INTDIR)\ne_utils.obj":    .\src\ne_utils.c
"$(INTDIR)\ne_xml.obj":      .\src\ne_xml.c
