/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 1.32 $ of : mfd-top.m2c,v $ 
 *
 * $Id: inetCidrRouteTable.c,v 1.5.2.1 2006/06/09 22:53:50 tanders Exp $
 */
/** \mainpage MFD helper for inetCidrRouteTable
 *
 * \section intro Introduction
 * Introductory text.
 *
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "inetCidrRouteTable.h"

#include <net-snmp/agent/mib_modules.h>

#include "inetCidrRouteTable_interface.h"

oid             inetCidrRouteTable_oid[] = { INETCIDRROUTETABLE_OID };
int             inetCidrRouteTable_oid_size =
OID_LENGTH(inetCidrRouteTable_oid);

void            initialize_table_inetCidrRouteTable(void);


/**
 * Initializes the inetCidrRouteTable module
 */
void
init_inetCidrRouteTable(void)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:init_inetCidrRouteTable",
                "called\n"));

    /*
     * TODO:300:o: Perform inetCidrRouteTable one-time module initialization.
     */

    /*
     * here we initialize all the tables we're planning on supporting
     */
    if (should_init("inetCidrRouteTable"))
        initialize_table_inetCidrRouteTable();

}                               /* init_inetCidrRouteTable */

/**
 * Initialize the table inetCidrRouteTable 
 *    (Define its contents and how it's structured)
 */
void
initialize_table_inetCidrRouteTable(void)
{
    inetCidrRouteTable_registration_ptr user_context;
    u_long          flags;

    DEBUGMSGTL(("verbose:inetCidrRouteTable:initialize_table_inetCidrRouteTable", "called\n"));

    /*
     * TODO:301:o: Perform inetCidrRouteTable one-time table initialization.
     */

    /*
     * TODO:302:o: |->Initialize inetCidrRouteTable user context
     * if you'd like to pass in a pointer to some data for this
     * table, allocate or set it up here.
     */
    /*
     * a netsnmp_data_list is a simple way to store void pointers. A simple
     * string token is used to add, find or remove pointers.
     */
    user_context =
        netsnmp_create_data_list("inetCidrRouteTable", NULL, NULL);

    /*
     * No support for any flags yet, but in the future you would
     * set any flags here.
     */
    flags = 0;

    /*
     * call interface initialization code
     */
    _inetCidrRouteTable_initialize_interface(user_context, flags);
}                               /* initialize_table_inetCidrRouteTable */

/**
 * pre-request callback
 *
 *
 * @retval MFD_SUCCESS              : success.
 * @retval MFD_ERROR                : other error
 */
int
inetCidrRouteTable_pre_request(inetCidrRouteTable_registration_ptr
                               user_context)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteTable_pre_request", "called\n"));

    /*
     * TODO:510:o: Perform inetCidrRouteTable pre-request actions.
     */

    return MFD_SUCCESS;
}                               /* inetCidrRouteTable_pre_request */

/**
 * post-request callback
 *
 *
 * @retval MFD_SUCCESS : success.
 * @retval MFD_ERROR   : other error (ignored)
 */
int
inetCidrRouteTable_post_request(inetCidrRouteTable_registration_ptr
                                user_context)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteTable_post_request", "called\n"));

    /*
     * TODO:511:o: Perform inetCidrRouteTable pos-request actions.
     */

    return MFD_SUCCESS;
}                               /* inetCidrRouteTable_post_request */


/**********************************************************************
 **********************************************************************
 ***
 *** Table inetCidrRouteTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * inetCidrRouteTable is subid 7 of ipForward.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.4.24.7, length: 9
 */

/*
 * ---------------------------------------------------------------------
 * * TODO:200:r: Implement inetCidrRouteTable data context functions.
 */
/*
 * inetCidrRouteTable_allocate_data
 *
 * Purpose: create new inetCidrRouteTable_data.
 */
inetCidrRouteTable_data *
inetCidrRouteTable_allocate_data(void)
{
    /*
     * TODO:201:r: |-> allocate memory for the inetCidrRouteTable data context.
     */
    inetCidrRouteTable_data *rtn = netsnmp_access_route_entry_create();

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteTable_allocate_data", "called\n"));

    if (NULL == rtn) {
        snmp_log(LOG_ERR, "unable to malloc memory for new "
                 "inetCidrRouteTable_data.\n");
    }

    return rtn;
}                               /* inetCidrRouteTable_allocate_data */

/*
 * inetCidrRouteTable_release_data
 *
 * Purpose: release inetCidrRouteTable data.
 */
void
inetCidrRouteTable_release_data(inetCidrRouteTable_data * data)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteTable_release_data", "called\n"));

    /*
     * TODO:202:r: |-> release memory for the inetCidrRouteTable data context.
     */
    netsnmp_access_route_entry_free(data);
}                               /* inetCidrRouteTable_release_data */



/**
 * set mib index(es)
 *
 * @param tbl_idx mib index structure
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This convenience function is useful for setting all the MIB index
 *  components with a single function call. It is assume that the C values
 *  have already been mapped from their native/rawformat to the MIB format.
 */
int
inetCidrRouteTable_indexes_set_tbl_idx(inetCidrRouteTable_mib_index *
                                       tbl_idx,
                                       u_long inetCidrRouteDestType_val,
                                       char *inetCidrRouteDest_val_ptr,
                                       size_t
                                       inetCidrRouteDest_val_ptr_len,
                                       u_long inetCidrRoutePfxLen_val,
                                       oid * inetCidrRoutePolicy_val_ptr,
                                       size_t
                                       inetCidrRoutePolicy_val_ptr_len,
                                       u_long inetCidrRouteNextHopType_val,
                                       char *inetCidrRouteNextHop_val_ptr,
                                       size_t
                                       inetCidrRouteNextHop_val_ptr_len)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteTable_indexes_set_tbl_idx", "called\n"));

    /*
     * inetCidrRouteDestType(1)/InetAddressType/ASN_INTEGER/long(u_long)//l/a/w/E/r/d/h 
     */
    /** WARNING: this code might not work for netsnmp_route_entry */
    tbl_idx->inetCidrRouteDestType = inetCidrRouteDestType_val;

    /*
     * inetCidrRouteDest(2)/InetAddress/ASN_OCTET_STR/char(char)//L/a/w/e/R/d/h 
     */
    tbl_idx->inetCidrRouteDest_len = sizeof(tbl_idx->inetCidrRouteDest);
    /** WARNING: this code might not work for netsnmp_route_entry */
    /*
     * make sure there is enough space for inetCidrRouteDest data
     */
    if (tbl_idx->inetCidrRouteDest_len < inetCidrRouteDest_val_ptr_len) {
        snmp_log(LOG_ERR, "not enough space for value\n");
        return MFD_ERROR;
    }
    tbl_idx->inetCidrRouteDest_len = inetCidrRouteDest_val_ptr_len;
    memcpy(tbl_idx->inetCidrRouteDest, inetCidrRouteDest_val_ptr,
           tbl_idx->inetCidrRouteDest_len *
           sizeof(tbl_idx->inetCidrRouteDest[0]));

    /*
     * inetCidrRoutePfxLen(3)/InetAddressPrefixLength/ASN_UNSIGNED/u_long(u_long)//l/a/w/e/R/d/H 
     */
    /** WARNING: this code might not work for netsnmp_route_entry */
    tbl_idx->inetCidrRoutePfxLen = inetCidrRoutePfxLen_val;

    /*
     * inetCidrRoutePolicy(4)/OBJECTID/ASN_OBJECT_ID/oid(oid)//L/a/w/e/r/d/h 
     */
    tbl_idx->inetCidrRoutePolicy_len =
        sizeof(tbl_idx->inetCidrRoutePolicy);
    /** WARNING: this code might not work for netsnmp_route_entry */
    /*
     * make sure there is enough space for inetCidrRoutePolicy data
     */
    if (tbl_idx->inetCidrRoutePolicy_len < inetCidrRoutePolicy_val_ptr_len) {
        snmp_log(LOG_ERR, "not enough space for value\n");
        return MFD_ERROR;
    }
    if (0 != inetCidrRoutePolicy_val_ptr_len)
        tbl_idx->inetCidrRoutePolicy_len = inetCidrRoutePolicy_val_ptr_len;
    else {
        tbl_idx->inetCidrRoutePolicy_len = nullOidLen / sizeof(oid);
        inetCidrRoutePolicy_val_ptr = nullOid;
    }
    memcpy(tbl_idx->inetCidrRoutePolicy, inetCidrRoutePolicy_val_ptr,
           tbl_idx->inetCidrRoutePolicy_len *
           sizeof(tbl_idx->inetCidrRoutePolicy[0]));

    /*
     * inetCidrRouteNextHopType(5)/InetAddressType/ASN_INTEGER/long(u_long)//l/a/w/E/r/d/h 
     */
    /** WARNING: this code might not work for netsnmp_route_entry */
    tbl_idx->inetCidrRouteNextHopType = inetCidrRouteNextHopType_val;

    /*
     * inetCidrRouteNextHop(6)/InetAddress/ASN_OCTET_STR/char(char)//L/a/w/e/R/d/h 
     */
    tbl_idx->inetCidrRouteNextHop_len =
        sizeof(tbl_idx->inetCidrRouteNextHop);
    /** WARNING: this code might not work for netsnmp_route_entry */
    /*
     * make sure there is enough space for inetCidrRouteNextHop data
     */
    if ((NULL == tbl_idx->inetCidrRouteNextHop)
        || (tbl_idx->inetCidrRouteNextHop_len <
            inetCidrRouteNextHop_val_ptr_len)) {
        snmp_log(LOG_ERR, "not enough space for value\n");
        return MFD_ERROR;
    }
    tbl_idx->inetCidrRouteNextHop_len = inetCidrRouteNextHop_val_ptr_len;
    memcpy(tbl_idx->inetCidrRouteNextHop, inetCidrRouteNextHop_val_ptr,
           tbl_idx->inetCidrRouteNextHop_len *
           sizeof(tbl_idx->inetCidrRouteNextHop[0]));


    return MFD_SUCCESS;
}                               /* inetCidrRouteTable_indexes_set_tbl_idx */

/**
 * @internal
 * set row context indexes
 *
 * @param reqreq_ctx the row context that needs updated indexes
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This function sets the mib indexs, then updates the oid indexs
 *  from the mib index.
 */
int
inetCidrRouteTable_indexes_set(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                               u_long inetCidrRouteDestType_val,
                               char *inetCidrRouteDest_val_ptr,
                               size_t inetCidrRouteDest_val_ptr_len,
                               u_long inetCidrRoutePfxLen_val,
                               oid * inetCidrRoutePolicy_val_ptr,
                               size_t inetCidrRoutePolicy_val_ptr_len,
                               u_long inetCidrRouteNextHopType_val,
                               char *inetCidrRouteNextHop_val_ptr,
                               size_t inetCidrRouteNextHop_val_ptr_len)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteTable_indexes_set", "called\n"));

    if (MFD_SUCCESS !=
        inetCidrRouteTable_indexes_set_tbl_idx(&rowreq_ctx->tbl_idx,
                                               inetCidrRouteDestType_val,
                                               inetCidrRouteDest_val_ptr,
                                               inetCidrRouteDest_val_ptr_len,
                                               inetCidrRoutePfxLen_val,
                                               inetCidrRoutePolicy_val_ptr,
                                               inetCidrRoutePolicy_val_ptr_len,
                                               inetCidrRouteNextHopType_val,
                                               inetCidrRouteNextHop_val_ptr,
                                               inetCidrRouteNextHop_val_ptr_len))
        return MFD_ERROR;

    /*
     * convert mib index to oid index
     */
    rowreq_ctx->oid_idx.len = sizeof(rowreq_ctx->oid_tmp) / sizeof(oid);
    if (0 != inetCidrRouteTable_index_to_oid(&rowreq_ctx->oid_idx,
                                             &rowreq_ctx->tbl_idx)) {
        return MFD_ERROR;
    }

    return MFD_SUCCESS;
}                               /* inetCidrRouteTable_indexes_set */


/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteIfIndex
 * inetCidrRouteIfIndex is subid 7 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.7
 * Description:
The ifIndex value which identifies the local interface 
                through which the next hop of this route should be  
                reached.  A value of 0 is valid and represents the 
                scenario where no interface is specified.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   1
 *   settable   1
 *   hint: d
 *
 * Ranges:  0 - 2147483647;
 *
 * Its syntax is InterfaceIndexOrZero (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Extract the current value of the inetCidrRouteIfIndex data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteIfIndex_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
inetCidrRouteIfIndex_get(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long *inetCidrRouteIfIndex_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != inetCidrRouteIfIndex_val_ptr);


    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteIfIndex_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the inetCidrRouteIfIndex data.
     * set (* inetCidrRouteIfIndex_val_ptr ) from rowreq_ctx->data
     */
    (*inetCidrRouteIfIndex_val_ptr) = rowreq_ctx->data->if_index;

    return MFD_SUCCESS;
}                               /* inetCidrRouteIfIndex_get */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteType
 * inetCidrRouteType is subid 8 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.8
 * Description:
The type of route.  Note that local(3) refers to a  
                route for which the next hop is the final destination;  
                remote(4)refers to a route for which the next hop is  
                not the final destination. 

                Routes which do not result in traffic forwarding or 
                rejection should not be displayed even if the  
                implementation keeps them stored internally. 

                reject(2) refers to a route which, if matched, discards  
                the message as unreachable and returns a notification  
                (e.g. ICMP error) to the message sender.  This is used  
                in some protocols as a means of correctly aggregating  
                routes. 

                blackhole(5) refers to a route which, if matched,  
                discards the message silently.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 3/8. Values:  other(1), reject(2), local(3), remote(4), blackhole(5)
 *
 * Its syntax is INTEGER (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Extract the current value of the inetCidrRouteType data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteType_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
inetCidrRouteType_get(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                      u_long * inetCidrRouteType_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != inetCidrRouteType_val_ptr);


    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteType_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the inetCidrRouteType data.
     * set (* inetCidrRouteType_val_ptr ) from rowreq_ctx->data
     */
    (*inetCidrRouteType_val_ptr) = rowreq_ctx->data->rt_type;

    return MFD_SUCCESS;
}                               /* inetCidrRouteType_get */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteProto
 * inetCidrRouteProto is subid 9 of inetCidrRouteEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.24.7.1.9
 * Description:
The routing mechanism via which this route was learned. 
                Inclusion of values for gateway routing protocols is  
                not intended to imply that hosts should support those 
                protocols.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 * Enum range: 13/32. Values:  other(1), local(2), netmgmt(3), icmp(4), egp(5), ggp(6), hello(7), rip(8), isIs(9), esIs(10), ciscoIgrp(11), bbnSpfIgp(12), ospf(13), bgp(14), idpr(15), ciscoEigrp(16), dvmrp(17)
 *
 * Its syntax is IANAipRouteProtocol (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Extract the current value of the inetCidrRouteProto data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteProto_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
inetCidrRouteProto_get(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                       u_long * inetCidrRouteProto_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != inetCidrRouteProto_val_ptr);


    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteProto_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the inetCidrRouteProto data.
     * set (* inetCidrRouteProto_val_ptr ) from rowreq_ctx->data
     */
    (*inetCidrRouteProto_val_ptr) = rowreq_ctx->data->rt_proto;

    return MFD_SUCCESS;
}                               /* inetCidrRouteProto_get */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteAge
 * inetCidrRouteAge is subid 10 of inetCidrRouteEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.24.7.1.10
 * Description:
The number of seconds since this route was last updated  
                or otherwise determined to be correct.  Note that no  
                semantics of 'too old' can be implied except through  
                knowledge of the routing protocol by which the route  
                was learned.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is GAUGE (based on perltype GAUGE)
 * The net-snmp type is ASN_GAUGE. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the inetCidrRouteAge data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteAge_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
inetCidrRouteAge_get(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                     u_long * inetCidrRouteAge_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != inetCidrRouteAge_val_ptr);


    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteAge_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the inetCidrRouteAge data.
     * set (* inetCidrRouteAge_val_ptr ) from rowreq_ctx->data
     */
    (*inetCidrRouteAge_val_ptr) = rowreq_ctx->data->rt_age;

    return MFD_SUCCESS;
}                               /* inetCidrRouteAge_get */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteNextHopAS
 * inetCidrRouteNextHopAS is subid 11 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.11
 * Description:
The Autonomous System Number of the Next Hop.  The  
                semantics of this object are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value. When this object is unknown or not relevant its  
                value should be set to zero.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   1
 *   settable   1
 *   defval: 0
 *   hint: d
 *
 *
 * Its syntax is InetAutonomousSystemNumber (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the inetCidrRouteNextHopAS data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteNextHopAS_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
inetCidrRouteNextHopAS_get(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                           u_long * inetCidrRouteNextHopAS_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != inetCidrRouteNextHopAS_val_ptr);


    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteNextHopAS_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the inetCidrRouteNextHopAS data.
     * set (* inetCidrRouteNextHopAS_val_ptr ) from rowreq_ctx->data
     */
    (*inetCidrRouteNextHopAS_val_ptr) = rowreq_ctx->data->rt_nexthop_as;

    return MFD_SUCCESS;
}                               /* inetCidrRouteNextHopAS_get */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteMetric1
 * inetCidrRouteMetric1 is subid 12 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.12
 * Description:
The primary routing metric for this route.  The  
                semantics of this metric are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value.  If this metric is not used, its value should be  
                set to -1.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *   defval: -1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Extract the current value of the inetCidrRouteMetric1 data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteMetric1_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
inetCidrRouteMetric1_get(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long *inetCidrRouteMetric1_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != inetCidrRouteMetric1_val_ptr);


    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric1_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the inetCidrRouteMetric1 data.
     * set (* inetCidrRouteMetric1_val_ptr ) from rowreq_ctx->data
     */
    (*inetCidrRouteMetric1_val_ptr) = rowreq_ctx->data->rt_metric1;

    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric1_get */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteMetric2
 * inetCidrRouteMetric2 is subid 13 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.13
 * Description:
An alternate routing metric for this route.  The  
                semantics of this metric are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value.  If this metric is not used, its value should be  
                set to -1.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *   defval: -1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Extract the current value of the inetCidrRouteMetric2 data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteMetric2_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
inetCidrRouteMetric2_get(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long *inetCidrRouteMetric2_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != inetCidrRouteMetric2_val_ptr);


    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric2_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the inetCidrRouteMetric2 data.
     * set (* inetCidrRouteMetric2_val_ptr ) from rowreq_ctx->data
     */
    (*inetCidrRouteMetric2_val_ptr) = rowreq_ctx->data->rt_metric2;

    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric2_get */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteMetric3
 * inetCidrRouteMetric3 is subid 14 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.14
 * Description:
An alternate routing metric for this route.  The  
                semantics of this metric are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value.  If this metric is not used, its value should be  
                set to -1.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *   defval: -1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Extract the current value of the inetCidrRouteMetric3 data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteMetric3_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
inetCidrRouteMetric3_get(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long *inetCidrRouteMetric3_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != inetCidrRouteMetric3_val_ptr);


    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric3_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the inetCidrRouteMetric3 data.
     * set (* inetCidrRouteMetric3_val_ptr ) from rowreq_ctx->data
     */
    (*inetCidrRouteMetric3_val_ptr) = rowreq_ctx->data->rt_metric3;

    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric3_get */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteMetric4
 * inetCidrRouteMetric4 is subid 15 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.15
 * Description:
An alternate routing metric for this route.  The  
                semantics of this metric are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value.  If this metric is not used, its value should be  
                set to -1.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *   defval: -1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Extract the current value of the inetCidrRouteMetric4 data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteMetric4_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
inetCidrRouteMetric4_get(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long *inetCidrRouteMetric4_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != inetCidrRouteMetric4_val_ptr);


    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric4_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the inetCidrRouteMetric4 data.
     * set (* inetCidrRouteMetric4_val_ptr ) from rowreq_ctx->data
     */
    (*inetCidrRouteMetric4_val_ptr) = rowreq_ctx->data->rt_metric4;

    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric4_get */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteMetric5
 * inetCidrRouteMetric5 is subid 16 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.16
 * Description:
An alternate routing metric for this route.  The  
                semantics of this metric are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value.  If this metric is not used, its value should be  
                set to -1.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *   defval: -1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Extract the current value of the inetCidrRouteMetric5 data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteMetric5_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
inetCidrRouteMetric5_get(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long *inetCidrRouteMetric5_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != inetCidrRouteMetric5_val_ptr);


    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric5_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the inetCidrRouteMetric5 data.
     * set (* inetCidrRouteMetric5_val_ptr ) from rowreq_ctx->data
     */
    (*inetCidrRouteMetric5_val_ptr) = rowreq_ctx->data->rt_metric5;

    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric5_get */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteStatus
 * inetCidrRouteStatus is subid 17 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.17
 * Description:
The row status variable, used according to row  
                installation and removal conventions. 

                A row entry cannot be modified when the status is 
                marked as active(1).
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 3/8. Values:  active(1), notInService(2), notReady(3), createAndGo(4), createAndWait(5), destroy(6)
 *
 * Its syntax is RowStatus (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Extract the current value of the inetCidrRouteStatus data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteStatus_val_ptr
 *        Pointer to storage for a long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
inetCidrRouteStatus_get(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                        u_long * inetCidrRouteStatus_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != inetCidrRouteStatus_val_ptr);

    /** WARNING: this code might not work for netsnmp_route_entry */
    (*inetCidrRouteStatus_val_ptr) = rowreq_ctx->inetCidrRouteStatus;

    return MFD_SUCCESS;
}                               /* inetCidrRouteStatus_get */



/** @} */
/**********************************************************************
 **********************************************************************
 ***
 *** Table inetCidrRouteTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * inetCidrRouteTable is subid 7 of ipForward.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.4.24.7, length: 9
 */
    /*
     * NOTE: if you update this chart, please update the versions in
     *       local/mib2c-conf.d/parent-set.m2i
     *       agent/mibgroup/helpers/baby_steps.c
     * while you're at it.
     */
    /*
     ***********************************************************************
     * Baby Steps Flow Chart (2004.06.05)                                  *
     *                                                                     *
     * +--------------+    +================+    U = unconditional path    *
     * |optional state|    ||required state||    S = path for success      *
     * +--------------+    +================+    E = path for error        *
     ***********************************************************************
     *
     *                        +--------------+
     *                        |     pre      |
     *                        |   request    |
     *                        +--------------+
     *                               | U
     * +-------------+        +==============+
     * |    row    |f|<-------||  object    ||
     * |  create   |1|      E ||  lookup    ||
     * +-------------+        +==============+
     *     E |   | S                 | S
     *       |   +------------------>|
     *       |                +==============+
     *       |              E ||   check    ||
     *       |<---------------||   values   ||
     *       |                +==============+
     *       |                       | S
     *       |                +==============+
     *       |       +<-------||   undo     ||
     *       |       |      E ||   setup    ||
     *       |       |        +==============+
     *       |       |               | S
     *       |       |        +==============+
     *       |       |        ||    set     ||-------------------------->+
     *       |       |        ||   value    || E                         |
     *       |       |        +==============+                           |
     *       |       |               | S                                 |
     *       |       |        +--------------+                           |
     *       |       |        |    check     |-------------------------->|
     *       |       |        |  consistency | E                         |
     *       |       |        +--------------+                           |
     *       |       |               | S                                 |
     *       |       |        +==============+         +==============+  |
     *       |       |        ||   commit   ||-------->||     undo   ||  |
     *       |       |        ||            || E       ||    commit  ||  |
     *       |       |        +==============+         +==============+  |
     *       |       |               | S                     U |<--------+
     *       |       |        +--------------+         +==============+
     *       |       |        | irreversible |         ||    undo    ||
     *       |       |        |    commit    |         ||     set    ||
     *       |       |        +--------------+         +==============+
     *       |       |               | U                     U |
     *       |       +-------------->|<------------------------+
     *       |                +==============+
     *       |                ||   undo     ||
     *       |                ||  cleanup   ||
     *       |                +==============+
     *       +---------------------->| U
     *                               |
     *                          (err && f1)------------------->+
     *                               |                         |
     *                        +--------------+         +--------------+
     *                        |    post      |<--------|      row     |
     *                        |   request    |       U |    release   |
     *                        +--------------+         +--------------+
     *
     */

/**
 * verify specified index is valid.
 *
 * This check is independent of whether or not the values specified for
 * the columns of the new row are valid. Column values and row consistency
 * will be checked later. At this point, only the index values should be
 * checked.
 *
 * All of the individual index validation functions have been called, so this
 * is the place to make sure they are valid as a whole when combined. If
 * you only have one index, 
 * 
 *
 *
 * @param inetCidrRouteTable_reg
 *        Pointer to the user registration data
 * @param inetCidrRouteTable_rowreq_ctx
 *        Pointer to the users context.
 * @retval MFD_SUCCESS            : success
 * @retval MFD_CANNOT_CREATE_NOW  : index not valid right now
 * @retval MFD_CANNOT_CREATE_EVER : index never valid
 */
int
inetCidrRouteTable_validate_index(inetCidrRouteTable_registration_ptr
                                  inetCidrRouteTable_reg,
                                  inetCidrRouteTable_rowreq_ctx *
                                  rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteTable_validate_index", "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:430:M: |-> Validate potential inetCidrRouteTable index.
     */
    if (1) {
        snmp_log(LOG_WARNING, "invalid index for a new row in the "
                 "inetCidrRouteTable table.\n");
        /*
         * determine failure type.
         *
         * If the index could not ever be created, return MFD_NOT_EVER
         * If the index can not be created under the present circumstances
         * (even though it could be created under other circumstances),
         * return MFD_NOT_NOW.
         */
        if (0) {
            return MFD_CANNOT_CREATE_EVER;
        } else {
            return MFD_CANNOT_CREATE_NOW;
        }
    }

    return rc;
}                               /* inetCidrRouteTable_validate_index */

/**
 * Setup up context with information needed to undo a set request.
 *
 * This function will be called before the individual node undo setup
 * functions are called. If you need to do any undo setup that is not
 * related to a specific column, you can do it here.
 *
 * Note that an individual node's undo_setup function will only be called
 * if that node is being set to a new value.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in the node's undo_setup
 * function, so it won't be done unless it is necessary.
 *
 * @param rowreq_ctx
 *        Pointer to the table context (inetCidrRouteTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 */
int
inetCidrRouteTable_undo_setup(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteTable_undo_setup",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:451:M: |-> Setup inetCidrRouteTable undo.
     * set up inetCidrRouteTable undo information, in preparation for a set.
     */

    return rc;
}                               /* inetCidrRouteTable_undo_setup */

/**
 * Cleanup up context undo information.
 *
 * This function will be called after set/commit processing. If you
 * allocated any resources in undo_setup, this is the place to release
 * those resources.
 *
 * This function is called regardless of the success or failure of the set
 * request. If you need to perform different steps for cleanup depending
 * on success or failure, you can add a flag to the rowreq_ctx.
 *
 * @param rowreq_ctx
 *        Pointer to the table context (inetCidrRouteTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
inetCidrRouteTable_undo_cleanup(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteTable_undo_cleanup", "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:452:M: |-> Cleanup inetCidrRouteTable undo.
     */

    return rc;
}                               /* inetCidrRouteTable_undo_cleanup */

/**
 * commit new values.
 *
 * At this point, you should have done everything you can to ensure that
 * this commit will not fail.
 *
 * Should you need different behavior depending on which columns were
 * set, rowreq_ctx->column_set_flags will indicate which writeable columns were
 * set. The definitions for the FLAG_* bits can be found in
 * inetCidrRouteTable.h.
 * A new row will have the MFD_ROW_CREATED bit set in rowreq_flags.
 *
 * @param inetCidrRouteTable_rowreq_ctx
 *        Pointer to the users context.
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
inetCidrRouteTable_commit(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;
    int             save_flags;

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteTable_commit",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * save flags, then clear until we actually do something
     */
    save_flags = rowreq_ctx->column_set_flags;
    rowreq_ctx->column_set_flags = 0;

    /*
     * commit inetCidrRouteTable data
     * 1) check the column's flag in save_flags to see if it was set.
     * 2) clear the flag when you handle that column
     * 3) set the column's flag in column_set_flags if it needs undo
     *    processing in case of a failure.
     */
    if (save_flags & FLAG_INETCIDRROUTEIFINDEX) {
        save_flags &= ~FLAG_INETCIDRROUTEIFINDEX;       /* clear inetCidrRouteIfIndex */
        /*
         * TODO:482:o: |-> commit column inetCidrRouteIfIndex.
         */
        rc = -1;
        if (-1 == rc) {
            snmp_log(LOG_ERR,
                     "inetCidrRouteTable column inetCidrRouteIfIndex commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo inetCidrRouteIfIndex
             */
            rowreq_ctx->column_set_flags |= FLAG_INETCIDRROUTEIFINDEX;
        }
    }

    if (save_flags & FLAG_INETCIDRROUTETYPE) {
        save_flags &= ~FLAG_INETCIDRROUTETYPE;  /* clear inetCidrRouteType */
        /*
         * TODO:482:o: |-> commit column inetCidrRouteType.
         */
        rc = -1;
        if (-1 == rc) {
            snmp_log(LOG_ERR,
                     "inetCidrRouteTable column inetCidrRouteType commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo inetCidrRouteType
             */
            rowreq_ctx->column_set_flags |= FLAG_INETCIDRROUTETYPE;
        }
    }

    if (save_flags & FLAG_INETCIDRROUTENEXTHOPAS) {
        save_flags &= ~FLAG_INETCIDRROUTENEXTHOPAS;     /* clear inetCidrRouteNextHopAS */
        /*
         * TODO:482:o: |-> commit column inetCidrRouteNextHopAS.
         */
        rc = -1;
        if (-1 == rc) {
            snmp_log(LOG_ERR,
                     "inetCidrRouteTable column inetCidrRouteNextHopAS commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo inetCidrRouteNextHopAS
             */
            rowreq_ctx->column_set_flags |= FLAG_INETCIDRROUTENEXTHOPAS;
        }
    }

    if (save_flags & FLAG_INETCIDRROUTEMETRIC1) {
        save_flags &= ~FLAG_INETCIDRROUTEMETRIC1;       /* clear inetCidrRouteMetric1 */
        /*
         * TODO:482:o: |-> commit column inetCidrRouteMetric1.
         */
        rc = -1;
        if (-1 == rc) {
            snmp_log(LOG_ERR,
                     "inetCidrRouteTable column inetCidrRouteMetric1 commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo inetCidrRouteMetric1
             */
            rowreq_ctx->column_set_flags |= FLAG_INETCIDRROUTEMETRIC1;
        }
    }

    if (save_flags & FLAG_INETCIDRROUTESTATUS) {
        save_flags &= ~FLAG_INETCIDRROUTESTATUS;        /* clear inetCidrRouteStatus */
        /*
         * TODO:482:o: |-> commit column inetCidrRouteStatus.
         */
        rc = -1;
        if (-1 == rc) {
            snmp_log(LOG_ERR,
                     "inetCidrRouteTable column inetCidrRouteStatus commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo inetCidrRouteStatus
             */
            rowreq_ctx->column_set_flags |= FLAG_INETCIDRROUTESTATUS;
        }
    }
    if (save_flags) {
        snmp_log(LOG_ERR, "unhandled columns (0x%x) in commit\n",
                 save_flags);
        return MFD_ERROR;
    }

    return rc;
}                               /* inetCidrRouteTable_commit */

/**
 * undo commit new values.
 *
 * Should you need different behavior depending on which columns were
 * set, rowreq_ctx->column_set_flags will indicate which writeable columns were
 * set. The definitions for the FLAG_* bits can be found in
 * inetCidrRouteTable.h.
 * A new row will have the MFD_ROW_CREATED bit set in rowreq_flags.
 *
 * @param inetCidrRouteTable_rowreq_ctx
 *        Pointer to the users context.
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
inetCidrRouteTable_undo_commit(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteTable_undo_commit", "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:485:M: |-> Undo inetCidrRouteTable commit.
     * check the column's flag in rowreq_ctx->column_set_flags to see
     * if it was set during commit, then undo it.
     *
     * eg: if (rowreq_ctx->column_set_flags & FLAG_) {}
     */

    return rc;
}                               /* inetCidrRouteTable_undo_commit */

/*
 * TODO:420:r: Implement inetCidrRouteTable index validation.
 */
/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteDestType
 * inetCidrRouteDestType is subid 1 of inetCidrRouteEntry.
 * Its status is Current, and its access level is NoAccess.
 * OID: .1.3.6.1.2.1.4.24.7.1.1
 * Description:
The type of the inetCidrRouteDest address, as defined  
                in the InetAddress MIB. 

                Only those address types that may appear in an actual 
                routing table are allowed as values of this object.
 *
 * Attributes:
 *   accessible 0     isscalar 0     enums  1      hasdefval 0
 *   readable   0     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 * Enum range: 5/8. Values:  unknown(0), ipv4(1), ipv6(2), ipv4z(3), ipv6z(4), dns(16)
 *
 * Its syntax is InetAddressType (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 *
 *
 *
 * NOTE: NODE inetCidrRouteDestType IS NOT ACCESSIBLE
 *
 *
 */
/**
 * check validity of inetCidrRouteDestType index portion
 *
 * @retval MFD_SUCCESS   : the incoming value is legal
 * @retval MFD_BAD_VALUE : the incoming value is NOT legal
 *
 * @note this is not the place to do any checks for the sanity
 *       of multiple indexes. Those types of checks should be done in the
 *       inetCidrRouteTable_validate_index() function.
 */
int
inetCidrRouteDestType_check_index(inetCidrRouteTable_rowreq_ctx *
                                  rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteDestType_check_index", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:426:M: |-> Check inetCidrRouteTable index inetCidrRouteDestType.
     * check that index value in the table context (rowreq_ctx)
     * for inetCidrRouteDestType is legal.
     */

    return MFD_SUCCESS;         /* inetCidrRouteDestType index ok */
}                               /* inetCidrRouteDestType_check_index */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteDest
 * inetCidrRouteDest is subid 2 of inetCidrRouteEntry.
 * Its status is Current, and its access level is NoAccess.
 * OID: .1.3.6.1.2.1.4.24.7.1.2
 * Description:
The destination IP address of this route. 

                The type of this address is determined by the value of 
                the inetCidrRouteDestType object. 

                The values for the index objects inetCidrRouteDest and 
                inetCidrRoutePfxLen must be consistent.  When the value 
                of inetCidrRouteDest (excluding the zone index, if one 
                is present) is x, then the bitwise logical-AND 
                of x with the value of the mask formed from the 
                corresponding index object inetCidrRoutePfxLen MUST be 
                equal to x.  If not, then the index pair is not 
                consistent and an inconsistentName error must be 
                returned on SET or CREATE requests.
 *
 * Attributes:
 *   accessible 0     isscalar 0     enums  0      hasdefval 0
 *   readable   0     iscolumn 1     ranges 1      hashint   0
 *   settable   0
 *
 * Ranges:  0 - 255;
 *
 * Its syntax is InetAddress (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 255)
 *
 *
 *
 * NOTE: NODE inetCidrRouteDest IS NOT ACCESSIBLE
 *
 *
 */
/**
 * check validity of inetCidrRouteDest index portion
 *
 * @retval MFD_SUCCESS   : the incoming value is legal
 * @retval MFD_BAD_VALUE : the incoming value is NOT legal
 *
 * @note this is not the place to do any checks for the sanity
 *       of multiple indexes. Those types of checks should be done in the
 *       inetCidrRouteTable_validate_index() function.
 */
int
inetCidrRouteDest_check_index(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteDest_check_index",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:426:M: |-> Check inetCidrRouteTable index inetCidrRouteDest.
     * check that index value in the table context (rowreq_ctx)
     * for inetCidrRouteDest is legal.
     */

    return MFD_SUCCESS;         /* inetCidrRouteDest index ok */
}                               /* inetCidrRouteDest_check_index */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRoutePfxLen
 * inetCidrRoutePfxLen is subid 3 of inetCidrRouteEntry.
 * Its status is Current, and its access level is NoAccess.
 * OID: .1.3.6.1.2.1.4.24.7.1.3
 * Description:
Indicates the number of leading one bits which form the  
                mask to be logical-ANDed with the destination address  
                before being compared to the value in the 
                inetCidrRouteDest field. 

                The values for the index objects inetCidrRouteDest and 
                inetCidrRoutePfxLen must be consistent.  When the value 
                of inetCidrRouteDest (excluding the zone index, if one 
                is present) is x, then the bitwise logical-AND 
                of x with the value of the mask formed from the 
                corresponding index object inetCidrRoutePfxLen MUST be 
                equal to x.  If not, then the index pair is not 
                consistent and an inconsistentName error must be 
                returned on SET or CREATE requests.
 *
 * Attributes:
 *   accessible 0     isscalar 0     enums  0      hasdefval 0
 *   readable   0     iscolumn 1     ranges 1      hashint   1
 *   settable   0
 *   hint: d
 *
 * Ranges:  0 - 2040;
 *
 * Its syntax is InetAddressPrefixLength (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 *
 *
 *
 * NOTE: NODE inetCidrRoutePfxLen IS NOT ACCESSIBLE
 *
 *
 */
/**
 * check validity of inetCidrRoutePfxLen index portion
 *
 * @retval MFD_SUCCESS   : the incoming value is legal
 * @retval MFD_BAD_VALUE : the incoming value is NOT legal
 *
 * @note this is not the place to do any checks for the sanity
 *       of multiple indexes. Those types of checks should be done in the
 *       inetCidrRouteTable_validate_index() function.
 */
int
inetCidrRoutePfxLen_check_index(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRoutePfxLen_check_index", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:426:M: |-> Check inetCidrRouteTable index inetCidrRoutePfxLen.
     * check that index value in the table context (rowreq_ctx)
     * for inetCidrRoutePfxLen is legal.
     */

    return MFD_SUCCESS;         /* inetCidrRoutePfxLen index ok */
}                               /* inetCidrRoutePfxLen_check_index */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRoutePolicy
 * inetCidrRoutePolicy is subid 4 of inetCidrRouteEntry.
 * Its status is Current, and its access level is NoAccess.
 * OID: .1.3.6.1.2.1.4.24.7.1.4
 * Description:
This object is an opaque object without any defined 
                semantics.  Its purpose is to serve as an additional 
                index which may delineate between multiple entries to 
                the same destination.  The value { 0 0 } shall be used 
                as the default value for this object.
 *
 * Attributes:
 *   accessible 0     isscalar 0     enums  0      hasdefval 0
 *   readable   0     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is OBJECTID (based on perltype OBJECTID)
 * The net-snmp type is ASN_OBJECT_ID. The C type decl is oid (oid)
 * This data type requires a length.  (Max 2040)
 *
 *
 *
 * NOTE: NODE inetCidrRoutePolicy IS NOT ACCESSIBLE
 *
 *
 */
/**
 * check validity of inetCidrRoutePolicy index portion
 *
 * @retval MFD_SUCCESS   : the incoming value is legal
 * @retval MFD_BAD_VALUE : the incoming value is NOT legal
 *
 * @note this is not the place to do any checks for the sanity
 *       of multiple indexes. Those types of checks should be done in the
 *       inetCidrRouteTable_validate_index() function.
 */
int
inetCidrRoutePolicy_check_index(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRoutePolicy_check_index", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:426:M: |-> Check inetCidrRouteTable index inetCidrRoutePolicy.
     * check that index value in the table context (rowreq_ctx)
     * for inetCidrRoutePolicy is legal.
     */

    return MFD_SUCCESS;         /* inetCidrRoutePolicy index ok */
}                               /* inetCidrRoutePolicy_check_index */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteNextHopType
 * inetCidrRouteNextHopType is subid 5 of inetCidrRouteEntry.
 * Its status is Current, and its access level is NoAccess.
 * OID: .1.3.6.1.2.1.4.24.7.1.5
 * Description:
The type of the inetCidrRouteNextHop address, as  
                defined in the InetAddress MIB. 

                Value should be set to unknown(0) for non-remote  
                routes. 

                Only those address types that may appear in an actual 
                routing table are allowed as values of this object.
 *
 * Attributes:
 *   accessible 0     isscalar 0     enums  1      hasdefval 0
 *   readable   0     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 * Enum range: 5/8. Values:  unknown(0), ipv4(1), ipv6(2), ipv4z(3), ipv6z(4), dns(16)
 *
 * Its syntax is InetAddressType (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 *
 *
 *
 * NOTE: NODE inetCidrRouteNextHopType IS NOT ACCESSIBLE
 *
 *
 */
/**
 * check validity of inetCidrRouteNextHopType index portion
 *
 * @retval MFD_SUCCESS   : the incoming value is legal
 * @retval MFD_BAD_VALUE : the incoming value is NOT legal
 *
 * @note this is not the place to do any checks for the sanity
 *       of multiple indexes. Those types of checks should be done in the
 *       inetCidrRouteTable_validate_index() function.
 */
int
inetCidrRouteNextHopType_check_index(inetCidrRouteTable_rowreq_ctx *
                                     rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteNextHopType_check_index", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:426:M: |-> Check inetCidrRouteTable index inetCidrRouteNextHopType.
     * check that index value in the table context (rowreq_ctx)
     * for inetCidrRouteNextHopType is legal.
     */

    return MFD_SUCCESS;         /* inetCidrRouteNextHopType index ok */
}                               /* inetCidrRouteNextHopType_check_index */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteNextHop
 * inetCidrRouteNextHop is subid 6 of inetCidrRouteEntry.
 * Its status is Current, and its access level is NoAccess.
 * OID: .1.3.6.1.2.1.4.24.7.1.6
 * Description:
On remote routes, the address of the next system en              
                route.  For non-remote routes, a zero length string. 

                The type of this address is determined by the value of 
                the inetCidrRouteNextHopType object.
 *
 * Attributes:
 *   accessible 0     isscalar 0     enums  0      hasdefval 0
 *   readable   0     iscolumn 1     ranges 1      hashint   0
 *   settable   0
 *
 * Ranges:  0 - 255;
 *
 * Its syntax is InetAddress (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 255)
 *
 *
 *
 * NOTE: NODE inetCidrRouteNextHop IS NOT ACCESSIBLE
 *
 *
 */
/**
 * check validity of inetCidrRouteNextHop index portion
 *
 * @retval MFD_SUCCESS   : the incoming value is legal
 * @retval MFD_BAD_VALUE : the incoming value is NOT legal
 *
 * @note this is not the place to do any checks for the sanity
 *       of multiple indexes. Those types of checks should be done in the
 *       inetCidrRouteTable_validate_index() function.
 */
int
inetCidrRouteNextHop_check_index(inetCidrRouteTable_rowreq_ctx *
                                 rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteNextHop_check_index", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:426:M: |-> Check inetCidrRouteTable index inetCidrRouteNextHop.
     * check that index value in the table context (rowreq_ctx)
     * for inetCidrRouteNextHop is legal.
     */

    return MFD_SUCCESS;         /* inetCidrRouteNextHop index ok */
}                               /* inetCidrRouteNextHop_check_index */

/*
 * TODO:440:M: Implement inetCidrRouteTable node value checks.
 * TODO:450:M: Implement inetCidrRouteTable undo functions.
 * TODO:460:M: Implement inetCidrRouteTable set functions.
 * TODO:480:M: Implement inetCidrRouteTable commit functions.
 */
/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteIfIndex
 * inetCidrRouteIfIndex is subid 7 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.7
 * Description:
The ifIndex value which identifies the local interface 
                through which the next hop of this route should be  
                reached.  A value of 0 is valid and represents the 
                scenario where no interface is specified.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   1
 *   settable   1
 *   hint: d
 *
 * Ranges:  0 - 2147483647;
 *
 * Its syntax is InterfaceIndexOrZero (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteIfIndex_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * inetCidrRouteTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *    The value is in (one of) the range set(s):  0 - 2147483647
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
inetCidrRouteIfIndex_check_value(inetCidrRouteTable_rowreq_ctx *
                                 rowreq_ctx, long inetCidrRouteIfIndex_val)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteIfIndex_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid inetCidrRouteIfIndex value.
     */

    return MFD_SUCCESS;         /* inetCidrRouteIfIndex value not illegal */
}                               /* inetCidrRouteIfIndex_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (inetCidrRouteTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * inetCidrRouteTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
inetCidrRouteIfIndex_undo_setup(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteIfIndex_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup inetCidrRouteIfIndex undo.
     */
    /*
     * copy inetCidrRouteIfIndex data
     * set rowreq_ctx->undo->inetCidrRouteIfIndex from rowreq_ctx->data->inetCidrRouteIfIndex
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteIfIndex_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param inetCidrRouteIfIndex_val
 *        A long containing the new value.
 */
int
inetCidrRouteIfIndex_set(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long inetCidrRouteIfIndex_val)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteIfIndex_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set inetCidrRouteIfIndex value.
     * set inetCidrRouteIfIndex value in rowreq_ctx->data
     */

    return MFD_SUCCESS;
}                               /* inetCidrRouteIfIndex_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
inetCidrRouteIfIndex_undo(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteIfIndex_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up inetCidrRouteIfIndex undo.
     */
    /*
     * copy inetCidrRouteIfIndex data
     * set rowreq_ctx->data->inetCidrRouteIfIndex from rowreq_ctx->undo->inetCidrRouteIfIndex
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteIfIndex_undo */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteType
 * inetCidrRouteType is subid 8 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.8
 * Description:
The type of route.  Note that local(3) refers to a  
                route for which the next hop is the final destination;  
                remote(4)refers to a route for which the next hop is  
                not the final destination. 

                Routes which do not result in traffic forwarding or 
                rejection should not be displayed even if the  
                implementation keeps them stored internally. 

                reject(2) refers to a route which, if matched, discards  
                the message as unreachable and returns a notification  
                (e.g. ICMP error) to the message sender.  This is used  
                in some protocols as a means of correctly aggregating  
                routes. 

                blackhole(5) refers to a route which, if matched,  
                discards the message silently.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 3/8. Values:  other(1), reject(2), local(3), remote(4), blackhole(5)
 *
 * Its syntax is INTEGER (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteType_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * inetCidrRouteTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *    The value is one of  other(1), reject(2), local(3), remote(4), blackhole(5)
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
inetCidrRouteType_check_value(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                              u_long inetCidrRouteType_val)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteType_check_value",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid inetCidrRouteType value.
     */

    return MFD_SUCCESS;         /* inetCidrRouteType value not illegal */
}                               /* inetCidrRouteType_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (inetCidrRouteTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * inetCidrRouteTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
inetCidrRouteType_undo_setup(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteType_undo_setup",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup inetCidrRouteType undo.
     */
    /*
     * copy inetCidrRouteType data
     * set rowreq_ctx->undo->inetCidrRouteType from rowreq_ctx->data->inetCidrRouteType
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteType_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param inetCidrRouteType_val
 *        A long containing the new value.
 */
int
inetCidrRouteType_set(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                      u_long inetCidrRouteType_val)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteType_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set inetCidrRouteType value.
     * set inetCidrRouteType value in rowreq_ctx->data
     */

    return MFD_SUCCESS;
}                               /* inetCidrRouteType_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
inetCidrRouteType_undo(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteType_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up inetCidrRouteType undo.
     */
    /*
     * copy inetCidrRouteType data
     * set rowreq_ctx->data->inetCidrRouteType from rowreq_ctx->undo->inetCidrRouteType
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteType_undo */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteNextHopAS
 * inetCidrRouteNextHopAS is subid 11 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.11
 * Description:
The Autonomous System Number of the Next Hop.  The  
                semantics of this object are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value. When this object is unknown or not relevant its  
                value should be set to zero.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   1
 *   settable   1
 *   defval: 0
 *   hint: d
 *
 *
 * Its syntax is InetAutonomousSystemNumber (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteNextHopAS_val
 *        A u_long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * inetCidrRouteTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_UNSIGNED
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
inetCidrRouteNextHopAS_check_value(inetCidrRouteTable_rowreq_ctx *
                                   rowreq_ctx,
                                   u_long inetCidrRouteNextHopAS_val)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteNextHopAS_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid inetCidrRouteNextHopAS value.
     */

    return MFD_SUCCESS;         /* inetCidrRouteNextHopAS value not illegal */
}                               /* inetCidrRouteNextHopAS_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (inetCidrRouteTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * inetCidrRouteTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
inetCidrRouteNextHopAS_undo_setup(inetCidrRouteTable_rowreq_ctx *
                                  rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteNextHopAS_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup inetCidrRouteNextHopAS undo.
     */
    /*
     * copy inetCidrRouteNextHopAS data
     * set rowreq_ctx->undo->inetCidrRouteNextHopAS from rowreq_ctx->data->inetCidrRouteNextHopAS
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteNextHopAS_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param inetCidrRouteNextHopAS_val
 *        A u_long containing the new value.
 */
int
inetCidrRouteNextHopAS_set(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                           u_long inetCidrRouteNextHopAS_val)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteNextHopAS_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set inetCidrRouteNextHopAS value.
     * set inetCidrRouteNextHopAS value in rowreq_ctx->data
     */

    return MFD_SUCCESS;
}                               /* inetCidrRouteNextHopAS_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
inetCidrRouteNextHopAS_undo(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteNextHopAS_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up inetCidrRouteNextHopAS undo.
     */
    /*
     * copy inetCidrRouteNextHopAS data
     * set rowreq_ctx->data->inetCidrRouteNextHopAS from rowreq_ctx->undo->inetCidrRouteNextHopAS
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteNextHopAS_undo */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteMetric1
 * inetCidrRouteMetric1 is subid 12 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.12
 * Description:
The primary routing metric for this route.  The  
                semantics of this metric are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value.  If this metric is not used, its value should be  
                set to -1.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *   defval: -1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteMetric1_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * inetCidrRouteTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
inetCidrRouteMetric1_check_value(inetCidrRouteTable_rowreq_ctx *
                                 rowreq_ctx, long inetCidrRouteMetric1_val)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric1_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid inetCidrRouteMetric1 value.
     */

    return MFD_SUCCESS;         /* inetCidrRouteMetric1 value not illegal */
}                               /* inetCidrRouteMetric1_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (inetCidrRouteTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * inetCidrRouteTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
inetCidrRouteMetric1_undo_setup(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric1_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup inetCidrRouteMetric1 undo.
     */
    /*
     * copy inetCidrRouteMetric1 data
     * set rowreq_ctx->undo->inetCidrRouteMetric1 from rowreq_ctx->data->inetCidrRouteMetric1
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric1_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param inetCidrRouteMetric1_val
 *        A long containing the new value.
 */
int
inetCidrRouteMetric1_set(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long inetCidrRouteMetric1_val)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric1_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set inetCidrRouteMetric1 value.
     * set inetCidrRouteMetric1 value in rowreq_ctx->data
     */

    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric1_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
inetCidrRouteMetric1_undo(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric1_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up inetCidrRouteMetric1 undo.
     */
    /*
     * copy inetCidrRouteMetric1 data
     * set rowreq_ctx->data->inetCidrRouteMetric1 from rowreq_ctx->undo->inetCidrRouteMetric1
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric1_undo */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteMetric2
 * inetCidrRouteMetric2 is subid 13 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.13
 * Description:
An alternate routing metric for this route.  The  
                semantics of this metric are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value.  If this metric is not used, its value should be  
                set to -1.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *   defval: -1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteMetric2_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * inetCidrRouteTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
inetCidrRouteMetric2_check_value(inetCidrRouteTable_rowreq_ctx *
                                 rowreq_ctx, long inetCidrRouteMetric2_val)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric2_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid inetCidrRouteMetric2 value.
     */
    /*
     * does any os use metrics 2-5? If so, update this to deal with it.
     */

    return MFD_NOT_VALID_EVER;
}                               /* inetCidrRouteMetric2_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (inetCidrRouteTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * inetCidrRouteTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
inetCidrRouteMetric2_undo_setup(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric2_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup inetCidrRouteMetric2 undo.
     */
    /*
     * copy inetCidrRouteMetric2 data
     * set rowreq_ctx->undo->inetCidrRouteMetric2 from rowreq_ctx->data->inetCidrRouteMetric2
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric2_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param inetCidrRouteMetric2_val
 *        A long containing the new value.
 */
int
inetCidrRouteMetric2_set(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long inetCidrRouteMetric2_val)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric2_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set inetCidrRouteMetric2 value.
     * set inetCidrRouteMetric2 value in rowreq_ctx->data
     */

    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric2_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
inetCidrRouteMetric2_undo(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric2_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up inetCidrRouteMetric2 undo.
     */
    /*
     * copy inetCidrRouteMetric2 data
     * set rowreq_ctx->data->inetCidrRouteMetric2 from rowreq_ctx->undo->inetCidrRouteMetric2
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric2_undo */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteMetric3
 * inetCidrRouteMetric3 is subid 14 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.14
 * Description:
An alternate routing metric for this route.  The  
                semantics of this metric are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value.  If this metric is not used, its value should be  
                set to -1.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *   defval: -1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteMetric3_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * inetCidrRouteTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
inetCidrRouteMetric3_check_value(inetCidrRouteTable_rowreq_ctx *
                                 rowreq_ctx, long inetCidrRouteMetric3_val)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric3_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid inetCidrRouteMetric3 value.
     */
    /*
     * does any os use metrics 2-5? If so, update this to deal with it.
     */

    return MFD_NOT_VALID_NOW;
}                               /* inetCidrRouteMetric3_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (inetCidrRouteTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * inetCidrRouteTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
inetCidrRouteMetric3_undo_setup(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric3_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup inetCidrRouteMetric3 undo.
     */
    /*
     * copy inetCidrRouteMetric3 data
     * set rowreq_ctx->undo->inetCidrRouteMetric3 from rowreq_ctx->data->inetCidrRouteMetric3
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric3_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param inetCidrRouteMetric3_val
 *        A long containing the new value.
 */
int
inetCidrRouteMetric3_set(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long inetCidrRouteMetric3_val)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric3_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set inetCidrRouteMetric3 value.
     * set inetCidrRouteMetric3 value in rowreq_ctx->data
     */

    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric3_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
inetCidrRouteMetric3_undo(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric3_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up inetCidrRouteMetric3 undo.
     */
    /*
     * copy inetCidrRouteMetric3 data
     * set rowreq_ctx->data->inetCidrRouteMetric3 from rowreq_ctx->undo->inetCidrRouteMetric3
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric3_undo */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteMetric4
 * inetCidrRouteMetric4 is subid 15 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.15
 * Description:
An alternate routing metric for this route.  The  
                semantics of this metric are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value.  If this metric is not used, its value should be  
                set to -1.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *   defval: -1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteMetric4_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * inetCidrRouteTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
inetCidrRouteMetric4_check_value(inetCidrRouteTable_rowreq_ctx *
                                 rowreq_ctx, long inetCidrRouteMetric4_val)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric4_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid inetCidrRouteMetric4 value.
     */
    /*
     * does any os use metrics 2-5? If so, update this to deal with it.
     */

    return MFD_NOT_VALID_NOW;
}                               /* inetCidrRouteMetric4_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (inetCidrRouteTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * inetCidrRouteTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
inetCidrRouteMetric4_undo_setup(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric4_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup inetCidrRouteMetric4 undo.
     */
    /*
     * copy inetCidrRouteMetric4 data
     * set rowreq_ctx->undo->inetCidrRouteMetric4 from rowreq_ctx->data->inetCidrRouteMetric4
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric4_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param inetCidrRouteMetric4_val
 *        A long containing the new value.
 */
int
inetCidrRouteMetric4_set(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long inetCidrRouteMetric4_val)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric4_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set inetCidrRouteMetric4 value.
     * set inetCidrRouteMetric4 value in rowreq_ctx->data
     */

    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric4_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
inetCidrRouteMetric4_undo(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric4_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up inetCidrRouteMetric4 undo.
     */
    /*
     * copy inetCidrRouteMetric4 data
     * set rowreq_ctx->data->inetCidrRouteMetric4 from rowreq_ctx->undo->inetCidrRouteMetric4
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric4_undo */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteMetric5
 * inetCidrRouteMetric5 is subid 16 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.16
 * Description:
An alternate routing metric for this route.  The  
                semantics of this metric are determined by the routing- 
                protocol specified in the route's inetCidrRouteProto  
                value.  If this metric is not used, its value should be  
                set to -1.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 1
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *   defval: -1
 *
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteMetric5_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * inetCidrRouteTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
inetCidrRouteMetric5_check_value(inetCidrRouteTable_rowreq_ctx *
                                 rowreq_ctx, long inetCidrRouteMetric5_val)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric5_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid inetCidrRouteMetric5 value.
     */
    /*
     * does any os use metrics 2-5? If so, update this to deal with it.
     */
    return MFD_NOT_VALID_NOW;
}                               /* inetCidrRouteMetric5_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (inetCidrRouteTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * inetCidrRouteTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
inetCidrRouteMetric5_undo_setup(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric5_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup inetCidrRouteMetric5 undo.
     */
    /*
     * copy inetCidrRouteMetric5 data
     * set rowreq_ctx->undo->inetCidrRouteMetric5 from rowreq_ctx->data->inetCidrRouteMetric5
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric5_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param inetCidrRouteMetric5_val
 *        A long containing the new value.
 */
int
inetCidrRouteMetric5_set(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                         long inetCidrRouteMetric5_val)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric5_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set inetCidrRouteMetric5 value.
     * set inetCidrRouteMetric5 value in rowreq_ctx->data
     */

    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric5_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
inetCidrRouteMetric5_undo(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteMetric5_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up inetCidrRouteMetric5 undo.
     */
    /*
     * copy inetCidrRouteMetric5 data
     * set rowreq_ctx->data->inetCidrRouteMetric5 from rowreq_ctx->undo->inetCidrRouteMetric5
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteMetric5_undo */

/*---------------------------------------------------------------------
 * IP-FORWARD-MIB::inetCidrRouteEntry.inetCidrRouteStatus
 * inetCidrRouteStatus is subid 17 of inetCidrRouteEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.4.24.7.1.17
 * Description:
The row status variable, used according to row  
                installation and removal conventions. 

                A row entry cannot be modified when the status is 
                marked as active(1).
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 3/8. Values:  active(1), notInService(2), notReady(3), createAndGo(4), createAndWait(5), destroy(6)
 *
 * Its syntax is RowStatus (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param inetCidrRouteStatus_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transistion from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * inetCidrRouteTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *    The value is one of  active(1), notInService(2), notReady(3), createAndGo(4), createAndWait(5), destroy(6)
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
inetCidrRouteStatus_check_value(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                                u_long inetCidrRouteStatus_val)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteStatus_check_value", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid inetCidrRouteStatus value.
     */

    return MFD_SUCCESS;         /* inetCidrRouteStatus value not illegal */
}                               /* inetCidrRouteStatus_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (inetCidrRouteTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * inetCidrRouteTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
inetCidrRouteStatus_undo_setup(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteStatus_undo_setup", "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup inetCidrRouteStatus undo.
     */
    /*
     * copy inetCidrRouteStatus data
     * set rowreq_ctx->undo->inetCidrRouteStatus from rowreq_ctx->data->inetCidrRouteStatus
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteStatus_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param inetCidrRouteStatus_val
 *        A long containing the new value.
 */
int
inetCidrRouteStatus_set(inetCidrRouteTable_rowreq_ctx * rowreq_ctx,
                        u_long inetCidrRouteStatus_val)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteStatus_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set inetCidrRouteStatus value.
     * set inetCidrRouteStatus value in rowreq_ctx->data
     */

    return MFD_SUCCESS;
}                               /* inetCidrRouteStatus_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
inetCidrRouteStatus_undo(inetCidrRouteTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:inetCidrRouteTable:inetCidrRouteStatus_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up inetCidrRouteStatus undo.
     */
    /*
     * copy inetCidrRouteStatus data
     * set rowreq_ctx->data->inetCidrRouteStatus from rowreq_ctx->undo->inetCidrRouteStatus
     */


    return MFD_SUCCESS;
}                               /* inetCidrRouteStatus_undo */

/** @} */
/** @{ */
