## PowerDNS Security Advisory 2008-01: System random generator can be predicted, leading to the potential to 'spoof' PowerDNS Recursor

 * CVE: Not yet assigned
 * Date: 31st of March 2008
 * Affects: PowerDNS Recursor versions 3.1.4 and earlier, on most operating systems
 * Not affected: No versions of the PowerDNS Authoritative Server ('pdns\_server') are affected.
 * Severity:Moderate
 * Impact: Data manipulation; client redirection
 * Exploit: This problem can be triggered by sending queries for specifically configured domains, sending spoofed answer packets immediately afterwards.
 * Solution: Upgrade to PowerDNS Recursor 3.1.5, or apply changesets [1159](http://wiki.powerdns.com/projects/trac/changeset/1159), [1160](http://wiki.powerdns.com/projects/trac/changeset/1160) and [1164](http://wiki.powerdns.com/projects/trac/changeset/1164).
 * Workaround: None known. Exposure can be limited by configuring the **allow-from** setting so only trusted users can query your nameserver.

We would like to thank Amit Klein of Trusteer for bringing a serious vulnerability to our attention which would enable a smart attacker to 'spoof' previous versions of the PowerDNS Recursor into accepting possibly malicious data.

Details can be found on [this Trusteer page](http://www.trusteer.com/docs/powerdnsrecursor.html).

This security problem was announced in [this email message](http://mailman.powerdns.com/pipermail/pdns-users/2008-March/005279.html).

It is recommended that all users of the PowerDNS Recursor upgrade to 3.1.5 as soon as practicable, while we simultaneously note that busy servers are less susceptible to the attack, but not immune.

The vulnerability is present on all operating systems where the behaviour of the libc random() function can be predicted based on its past output. This includes at least all known versions of Linux, as well as Microsoft Windows, and probably FreeBSD and Solaris.

The magnitude of this vulnerability depends on internal details of the system random() generator. For Linux, the mathematics of the random generator are complex, but well understood and Amit Klein has written and published a proof of concept that can successfully predict its output after uninterrupted observation of 40-50 DNS queries.

Because the observation needs to be uninterrupted, busy PowerDNS Recursor instances are harder to subvert - other data is highly likely to be interleaved with traffic generated by an attacker.

Nevertheless, operators are urged to update at their earliest convenience.
