################################################################################
# CONTACT CONFIGURATION
#
# SYNTAX:
# contact[<contact_name>]=<contact_alias>;<svc_notification_period>;
#                         <host_notification_period>;<notify_service_recovery>;
#                         <notify_service_critical>;<notify_service_warning>;
#                         <notify_host_recovery>;<notify_host_down>;
#                         <notify_host_unreachable>;<service_notify_commands>;
#                         <host_notify_commands>;<email_address>;<pager>
#
# <contact_name>             = A short name used to identify the contact
#                              (i.e. username)
# <contact_alias>            = Full name and/or description for the contact
# <svc_notification_period>  = The short name of the timeperiod (as defined
#                              above) that determines when service notifications
#                              may be sent to this contact
# <host_notification_period> = The short name of the timeperiod (as defined
#                              above) that determines when host notifications
#                              may be sent to this contact
# <notify_service_recovery>  = Notify the contact on service recoveries?
#                              1 = yes, 0 = no
# <notify_service_critical>  = Notify the contact on critical service states?
#                              1 = yes, 0 = no
# <notify_service_warning>   = Notify the contact on warning service states?
#                              1 = yes, 0 = no
# <notify_host_recovery>     = Notify the contact on host recoveries?
#                              1 = yes, 0 = no
# <notify_host_down>         = Notify the contact when hosts are down?
#                              1 = yes, 0 = no
# <notify_host_unreachable>  = Notify the contact when hosts are unreachable?
#                              1 = yes, 0 = no
# <service_notify_commands>  = Short names for commands (defined above) used to
#                              notify the contact of service recoveries and 
#                              warning or critical service levels.  Multiple
#                              commands are comma delimited.  All commands are
#                              executed when the contact needs to be notified.
# <host_notify_commands>     = Short names for commands (defined above) used to
#                              notify the contact when a host goes down or comes
#                              back up.  Multiple commands are comma delimited.
#                              All commands are executed when the contact needs
#                              to be notified.
# <email_address>            = Email address for the contact
# <pager>                    = Pager number or pager email address for the
#                              contact (see documentation for more information)
#
# Note: All fields are required, except for the <email_address> and <pager>
#       fields.  However,either the email address *or* the pager must be
#       specified - both cannot be empty!
#
################################################################################
<!-- BEGIN config_contact -->

contact[{c_name}]={c_alias};{csv_period};{h_period};{s_rec};{s_crit};{s_warn};{h_rec};{h_down};{h_unreach};{s_command};{h_command};{email};{pager}

<!-- END config_contact -->