/*************************************************************************/
/* module:          Definition of WBXML/XML tags for the en-/decoder     */
/* file:            XLTTags.h                                            */
/* target system:   all                                                  */
/* target OS:       all                                                  */   
/*************************************************************************/

/*
 * Copyright Notice
 * Copyright (c) Ericsson, IBM, Lotus, Matsushita Communication 
 * Industrial Co., LTD,Motorola, Nokia, Palm, Inc., Psion, 
 * Starfish Software (2001).
 * All Rights Reserved.
 * Implementation of all or part of any Specification may require 
 * licenses under third party intellectual property rights, 
 * including without limitation, patent rights (such a third party 
 * may or may not be a Supporter). The Sponsors of the Specification 
 * are not responsible and shall not be held responsible in any 
 * manner for identifying or failing to identify any or all such 
 * third party intellectual property rights.
 * 
 * THIS DOCUMENT AND THE INFORMATION CONTAINED HEREIN ARE PROVIDED 
 * ON AN "AS IS" BASIS WITHOUT WARRANTY OF ANY KIND AND ERICSSON, IBM, 
 * LOTUS, MATSUSHITA COMMUNICATION INDUSTRIAL CO. LTD, MOTOROLA, 
 * NOKIA, PALM INC., PSION, STARFISH SOFTWARE AND ALL OTHER SYNCML 
 * SPONSORS DISCLAIM ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION 
 * HEREIN WILL NOT INFRINGE ANY RIGHTS OR ANY IMPLIED WARRANTIES OF 
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT 
 * SHALL ERICSSON, IBM, LOTUS, MATSUSHITA COMMUNICATION INDUSTRIAL CO., 
 * LTD, MOTOROLA, NOKIA, PALM INC., PSION, STARFISH SOFTWARE OR ANY 
 * OTHER SYNCML SPONSOR BE LIABLE TO ANY PARTY FOR ANY LOSS OF 
 * PROFITS, LOSS OF BUSINESS, LOSS OF USE OF DATA, INTERRUPTION OF 
 * BUSINESS, OR FOR DIRECT, INDIRECT, SPECIAL OR EXEMPLARY, INCIDENTAL, 
 * PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND IN CONNECTION WITH 
 * THIS DOCUMENT OR THE INFORMATION CONTAINED HEREIN, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 * 
 * The above notice and this paragraph must be included on all copies 
 * of this document that are made.
 * 
 */

/*************************************************************************/
/*  Definitions                                                          */
/*************************************************************************/

#ifndef _XLT_TAGS_H
#define _XLT_TAGS_H

#include <smldtd.h>
#include <smldef.h>

#define SML_CP 0
#define META_CP 1
#define XML_MAX_TAGLEN 35
#define XML_MAX_PREFIXLEN 10

#ifdef _cplusplus
extern "C" {
#endif

// Tag IDs
typedef enum {

    TN_ADD = 0,
    TN_ALERT,
    TN_ARCHIVE,
    TN_ATOMIC,
    TN_ATOMIC_END,
    TN_CHAL,
    TN_CMD,
    TN_CMDID,
    TN_CMDREF,
    TN_COPY,
    TN_CRED,
    TN_DATA,
    TN_DELETE,
    TN_EXEC,
    TN_FINAL,
    TN_GET,
    TN_ITEM,
    TN_LANG,
    TN_LOCNAME,
    TN_LOCURI,
    TN_MAP,
    TN_MAPITEM,
    TN_META,
    TN_MSGID,
    TN_MSGREF,
    TN_NORESP,
    TN_NORESULTS,
    TN_PUT,
    TN_REPLACE,
    TN_RESPURI,
    TN_RESULTS,
    TN_SEARCH,
    TN_SEQUENCE,
    TN_SEQUENCE_END,
    TN_SESSIONID,
    TN_SFTDEL,
    TN_SOURCE,
    TN_SOURCEREF,
    TN_STATUS,
    TN_SYNC,
    TN_SYNCBODY,
    TN_SYNCHDR,
    TN_SYNCML_END,
    TN_SYNCML_START,
    TN_SYNC_END,
    TN_TARGET,
    TN_TARGETREF,
    TN_VERSION,
    TN_PROTO,
#ifdef __META_EXT__
    TN_META_ANCHOR,   
    TN_META_EMI,      
    TN_META_FORMAT,   
    TN_META_FREEID,   
    TN_META_FREEMEM,  
    TN_META_LAST,     
    TN_META_MARK,     
    TN_META_MAXMSGSIZE,
    TN_META_MEM, 
    TN_META_METINF,
    TN_META_NEXT,     
    TN_META_NEXTNONCE,
    TN_META_SHAREDMEM,
    TN_META_SIZE,
    TN_META_TYPE,
    TN_META_VERSION,
#endif
    TN_UNDEF
} XltTagID_t;

typedef struct Tag_s
{
    XltTagID_t  id;
    Byte_t      cp;
    Byte_t      wbxml;
    String_t    xml;
} Tag_t, *TagPtr_t;

/**
 * FUNCTION: getTagString
 *
 * Returns a tag string which belongs to a tag ID. 
 * This function is needed for the XML encoding
 *
 * PRE-Condition:   valid tag ID, the tagSring has to be allocated 
 *
 * POST-Condition:  tag string is returned
 *
 * IN:              tagId, the ID for the tag 
 *
 * IN/OUT:          tagString, allocated string into which the XML 
 *                             tag string will be written
 * 
 * RETURN:          0, if OK
 */
Ret_t getTagString(XltTagID_t tagID, String_t tagString);

/**
 * FUNCTION: getTagByte
 *
 * Returns a WBXML byte which belongs to a tag ID in a defined codepage. 
 * This function is needed for the WBXML encoding
 *
 * PRE-Condition:   valid tag ID, valid code page
 *
 * POST-Condition:  tag byte is returned
 *
 * IN:              tagId, the ID for the tag 
 *                  cp, code page group for the tag 
 *                  tagByte, the byte representation of the tag
 * 
 * RETURN:          0, if OK
 */
Ret_t getTagByte(XltTagID_t tagID, Byte_t cp, Byte_t *tagByte);

/**
 * FUNCTION: getCodePage
 *
 * Returns the code page which belongs to a certain PCDATA extension type. 
 *
 * PRE-Condition:   valid PCDATA extension type
 *
 * POST-Condition:  the code page is returned
 *
 * IN:              ext, the PCDATA extension type
 * 
 * RETURN:          the code page
 */
Byte_t     getCodePage(SmlPcdataExtension_t ext);

/**
 * FUNCTION: getTagIDByStringAndCodepage
 *
 * Returns the tag ID which belongs to a tag string in a certain codepage
 *
 * PRE-Condition:   valid tag string, valid code page
 *
 * POST-Condition:  tag id is returned
 *
 * IN:              tag, the string representation of the tag 
 *                  cp, code page group for the tag 
 *                  pTagID, the tag id of the tag
 * 
 * RETURN:          0, if OK
 */
Ret_t getTagIDByStringAndCodepage(String_t tag, Byte_t cp, XltTagID_t *pTagID);

/**
 * FUNCTION: getTagIDByByteAndCodepage
 *
 * Returns the tag ID which belongs to a tag byte in a certain codepage
 *
 * PRE-Condition:   valid tag byte, valid code page
 *
 * POST-Condition:  tag id is returned
 *
 * IN:              tag, the byte representation of the tag 
 *                  cp, code page group for the tag  
 *                  pTagID, the tag id of the tag
 * 
 * RETURN:          0, if OK
 */
Ret_t getTagIDByByteAndCodepage(Byte_t tag, Byte_t cp, XltTagID_t *pTagID);

/**
 * FUNCTION: getTagIDByStringAndNamespace
 *
 * Returns the tag ID which belongs to a tag string in a certain namespace
 *
 * PRE-Condition:   valid tag string, valid namespace
 *
 * POST-Condition:  tag id is returned
 *
 * IN:              tag, the string representation of the tag 
 *                  ns, namespace group for the tag  
 *                  pTagID, the tag id of the tag
 * 
 * RETURN:          0, if OK
 */
Ret_t getTagIDByStringAndNamespace(String_t tag, String_t ns, XltTagID_t *pTagID);

/**
 * FUNCTION: getCodePageById
 *
 * Returns the codepage which belongs to a certain tag ID
 *
 * PRE-Condition:   valid tag ID
 *
 * POST-Condition:  the code page is returned
 *
 * IN:              tagID, the ID of the tag 
 *                  pCp, the codepage of the tag
 *
 * RETURN:          0, if OK
 */
Ret_t getCodePageById(XltTagID_t tagID, Byte_t *pCp);


#ifdef _cplusplus
}
#endif

#endif
