/*************************************************************************/
/* module:          Compiler Flag Definition File                        */
/* file:            define.h                                             */
/* target system:   win                                                  */
/* target OS:       win                                                  */   
/*************************************************************************/

/*
 * Copyright Notice
 * Copyright (c) Ericsson, IBM, Lotus, Matsushita Communication 
 * Industrial Co., LTD,Motorola, Nokia, Palm, Inc., Psion, 
 * Starfish Software (2001).
 * All Rights Reserved.
 * Implementation of all or part of any Specification may require 
 * licenses under third party intellectual property rights, 
 * including without limitation, patent rights (such a third party 
 * may or may not be a Supporter). The Sponsors of the Specification 
 * are not responsible and shall not be held responsible in any 
 * manner for identifying or failing to identify any or all such 
 * third party intellectual property rights.
 * 
 * THIS DOCUMENT AND THE INFORMATION CONTAINED HEREIN ARE PROVIDED 
 * ON AN "AS IS" BASIS WITHOUT WARRANTY OF ANY KIND AND ERICSSON, IBM, 
 * LOTUS, MATSUSHITA COMMUNICATION INDUSTRIAL CO. LTD, MOTOROLA, 
 * NOKIA, PALM INC., PSION, STARFISH SOFTWARE AND ALL OTHER SYNCML 
 * SPONSORS DISCLAIM ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION 
 * HEREIN WILL NOT INFRINGE ANY RIGHTS OR ANY IMPLIED WARRANTIES OF 
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT 
 * SHALL ERICSSON, IBM, LOTUS, MATSUSHITA COMMUNICATION INDUSTRIAL CO., 
 * LTD, MOTOROLA, NOKIA, PALM INC., PSION, STARFISH SOFTWARE OR ANY 
 * OTHER SYNCML SPONSOR BE LIABLE TO ANY PARTY FOR ANY LOSS OF 
 * PROFITS, LOSS OF BUSINESS, LOSS OF USE OF DATA, INTERRUPTION OF 
 * BUSINESS, OR FOR DIRECT, INDIRECT, SPECIAL OR EXEMPLARY, INCIDENTAL, 
 * PUNITIVE OR CONSEQUENTIAL DAMAGES OF ANY KIND IN CONNECTION WITH 
 * THIS DOCUMENT OR THE INFORMATION CONTAINED HEREIN, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH LOSS OR DAMAGE.
 * 
 * The above notice and this paragraph must be included on all copies 
 * of this document that are made.
 * 
 */

/**
 * File for Windows Specific Compiler Flags
 */

#ifndef _DEFINE_H
  #define _DEFINE_H

#define __ANSI_C__

//enable/disable Meta SubDTD encoding/parsing
#define __META_EXT__

//enable/disable WBXML
#define __SML_WBXML__

//enable/disable XML
#define __SML_XML__


/* 
When building the DLL codewith GNU, you should define BUILDING_DLL so that
the variables/functions are exported correctly. When using the DLL,
do NOT define BUILDING_DLL, and then the variables/functions will be 
imported correctly.

You need to be using egcs-1.1.1 or newer.

Building the DLL:
 - define BUILDING_DLL, which defines SML_API __attribute__((dllexport))
Building the client code:
 - DO NOT define BUILDING_DLL, which defines SML_API to be one __attribute__((dllimport))
*/

#if __GNUC__ || __MSVC__ || __MSVCPP__
	/* define this, if you want to link the toolkit static */
	#if __LINK_TOOLKIT_STATIC__ || __linux__
		#define SML_API 
		#define SML_API_DEF
		#define XPT_API 
		#define XPT_API_DEF
	#else
		#if BUILDING_DLL
			#define SML_API 	__declspec (dllexport)
			#define SML_API_DEF 	__declspec (dllexport)
			#define XPT_API 	__declspec (dllexport)
			#define XPT_API_DEF 	__declspec (dllexport)
		#else /* Not BUILDING_DLL */
			#define SML_API 	__declspec (dllimport)
			#define SML_API_DEF 	__declspec (dllimport)
			#define XPT_API 	__declspec (dllimport)
			#define XPT_API_DEF 	__declspec (dllimport)
		#endif /* Not BUILDING_DLL */
	#endif
#else
	#if __IBMC__ || __IBMCPP__
		#define SML_API_DEF 	__stdcall
		#define SML_API 	__stdcall _Export
		#define XPT_API_DEF 	__stdcall
		#define XPT_API 	__stdcall _Export
	#else
		#define SML_API_DEF 	__stdcall
		#define SML_API    	__stdcall
		#define XPT_API_DEF 	__stdcall
		#define XPT_API    	__stdcall
	#endif
#endif

#endif
