<?php

  /**************************************************************************\
  * phpGroupWare - SyncML Synchronization                                    *
  * http://www.phpgroupware.org                                              *
  * Written by Jens P. Elsner <jpelsner@gmx.net>                             *
  *            Mark Wormgoor <mark@wormgoor.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

/*
This product includes software developed by The SyncML Initiative.
*/

	/********************************************************************\
	* Allow debugging, 0 = debugging off, 1 = debugging on               *
	* This will generate a VERY EXTENSIVE logfile                        *
	\********************************************************************/
	$prefix = date ( 'M j Y H:i:s' ) . ' SyncML: ';
	$debug = array (
		'level'       => 1,
		'type'        => 3,
		'destination' => './debug.log',
		'prefix'      => $prefix
	);


	/********************************************************************\
	* Register a shutdown function, in case of timeouts and such!        *
	\********************************************************************/
	function syncml_shutdown () {
		if ( $debug['level'] > 0 ) {
			error_log ( $debug['prefix'] . 'PHPGW Sync Engine shutdown prematurely!',
				$debug['type'], $debug['destination'] );
		}
	}
	register_shutdown_function('syncml_shutdown');


	/********************************************************************\
	* Start receiving the message                                        *
	\********************************************************************/
	if ( ! isset ($HTTP_RAW_POST_DATA) ) {
		if ( $debug['level'] > 0 ) {
			error_log( $debug['prefix'] . 'No POST Data available',
				$debug['type'], $debug['destination'] );
		}
		exit (1);
	}
	if ( $debug['level'] > 0 ) {
		error_log ($debug['prefix'] . 'POST Data received:\n' . $HTTP_RAW_POST_DATA,
			$debug['type'], $debug['destination'] );
	}

	strtolower ( $CONTENT_TYPE );
	switch ( $CONTENT_TYPE ) {
		case 'application/vnd.syncml-wbxml':
			$syncml_encoding = 1;			
		case 'application/vnd.syncml-xml':
			$syncml_encoding = 2;			
		default:
		if ( $debug['level'] > 0 ) {
			error_log( $debug['prefix'] . 'No valid Content-type: ' . $CONTENT_TYPE,
				$debug['type'], $debug['destination'] );
		}
		exit (1);
	}
	if ( $debug['level'] > 0 ) {
		error_log ($debug['prefix'] . 'POST Content-type:\n' . $CONTENT_TYPE,
			$debug['type'], $debug['destination'] );
	}

	/********************************************************************\
	* Create a new SyncML instance                                       *
	\********************************************************************/
	if ( $debug['level'] > 0 ) {
		error_log ($debug['prefix'] . 'Starting new SyncML instance with 2.5MB workspace',
			$debug['type'], $debug['destination']);
	}
	$instance = new syncml ( $encoding, 2500000, 'instance' );

	/* Writing incoming data to buffer */
	if ( $debug['level'] > 0 ) {
		error_log ($debug['prefix'] . 'Writing incoming SyncML data to buffer',
			$debug['type'], $debug['destination'] );
	}
	$instance->write_in_buffer ( $HTTP_RAW_POST_DATA );

	/* Start processing incoming data */
	if ( $debug['level'] > 0 ) {
		error_log ($debug['prefix'] . 'Starting processing of incoming SyncML data',
			$debug['type'], $debug['destination);
	}
	$instance->process_data();

?>
