<?php

/*************************************************************************\
* phpGroupWare app (Bookkeeping)                                          *
* http://www.phpgroupware.org                                             *
* Written by Rick Bakker <r.bakker@linvision.com>                         *
* --------------------------------------------                            *
* This program is free software; you can redistribute it and/or modify it *
* under the terms of the GNU General Public License as published by the   *
* Free Software Foundation; either version 2 of the License, or (at your  *
* option) any later version.                                              *
\*************************************************************************/

/* $Id: class.bookkeeping_admin.inc.php,v 1.4 2001/06/11 20:49:37 darw1n Exp $ */

class bookkeeping_admin
{
	// functions:
	// get_bookkeeping_admins_string($separator)
	// account_in($bookkeeping_admins, $not='')
	// get_bookkeeping_admin_list($order, $sort)
	// get_phpgw_account_list_without_bookkeeping_admins($order, $sort)

	// Function:
	// Abstract:
	function get_bookkeeping_admins_string($separator)
	{
		global $phpgw;
		$phpgw->db->query("SELECT acl_account FROM phpgw_acl WHERE acl_appname='bookkeeping' AND acl_location='1' AND acl_rights='1'");
		$bookkeeping_admins = '';
		while($phpgw->db->next_record())
		{
			if ($bookkeeping_admins == '')
			{
				$bookkeeping_admins = $phpgw->db->f('acl_account');
			}
			else
			{
				$bookkeeping_admins .= ($separator . $phpgw->db->f('acl_account'));
			}
		}
		return ($bookkeeping_admins);
	}

	// Function:
	// Abstract:
	function account_in($bookkeeping_admins, $not='')
	{
                if ($bookkeeping_admins == '')
                {
			if ($not == '')
			{
				$in = " AND account_id IN ('') ";
			}
			else
			{
				$in = " AND account_id NOT IN ('') ";
			}
                }
                else
                {
			if ($not == '')
			{
	                        $in = ' AND account_id IN (' . $bookkeeping_admins . ') ';
			}
			else
			{
				$in = ' AND account_id NOT IN (' . $bookkeeping_admins . ') ';
			}
                }
		return ($in);
	}

	// Function:
	// Abstract:
        function get_bookkeeping_admin_list($order, $sort)
	{
		global $phpgw;
		$order_by = 'ORDER BY ' . $order . ' ';
		$bookkeeping_admins = $this->get_bookkeeping_admins_string(',');
		$in = $this->account_in($bookkeeping_admins);
		$phpgw->db->query("SELECT account_id,account_lid,account_firstname,account_lastname FROM phpgw_accounts WHERE account_status='A' AND account_type='u'" . $in . $order_by . $sort);
		$i = 0;
		while($phpgw->db->next_record())
		{
			$bookkeeping_admin[$i]['phpgw_account_id']        = $phpgw->db->f('account_id');
			$bookkeeping_admin[$i]['phpgw_account_lid']       = $phpgw->db->f('account_lid');
			$bookkeeping_admin[$i]['phpgw_account_firstname'] = $phpgw->db->f('account_firstname');
			$bookkeeping_admin[$i]['phpgw_account_lastname']  = $phpgw->db->f('account_lastname');
			$i++;
		}
		return ($bookkeeping_admin);
	}

	// Function:
	// Abstract:
	function get_phpgw_account_list_without_bookkeeping_admins($order, $sort)
	{
		global $phpgw;
		$order_by = 'ORDER BY ' . $order . ' ';
		$bookkeeping_admins = $this->get_bookkeeping_admins_string(',');
		$in = $this->account_in($bookkeeping_admins, 'NOT');
		$phpgw->db->query("SELECT account_id,account_lid,account_firstname,account_lastname FROM phpgw_accounts WHERE account_status='A' AND account_type='u'" . $in . $order_by . $sort);
		$i = 0;
		while($phpgw->db->next_record())
		{
			$phpgw_account[$i]['phpgw_account_id'] = $phpgw->db->f('account_id');
			$phpgw_account[$i]['phpgw_account_lid'] = $phpgw->db->f('account_lid');
			$phpgw_account[$i]['phpgw_account_firstname'] = $phpgw->db->f('account_firstname');
			$phpgw_account[$i]['phpgw_account_lastname'] = $phpgw->db->f('account_lastname');
			$i++;
		}
		return ($phpgw_account);
	}
}

?>
