<?php
  /**************************************************************************\
  * phpGroupWare                                                             *
  * http://www.phpgroupware.org/                                             *
  * This file written by Patrick Walsh <patrick@phpgroupware.org>            *
  * ------------------------------------------------------------------------ *
  * Please see the documentation for these classes in the README file in     *
  * this directory.                                                          *
  * ------------------------------------------------------------------------ *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: class.cdb_contact_meta.inc.php,v 1.2 2001/11/11 16:04:09 milosch Exp $ */

	class cdb_contact_meta extends cdb_generic
	{
		function cdb_contact_meta()
		{
			$this->_ = array(
				'entity_type' => 'contact',	//Either 'contact' or 'organization'
				'entity_id'   => 0,        	//The id of the loaded entity
				'organization_obj' => '',  	//if entity_type='organization' and 
											// loaded=true then this contains the 
											// loaded org data
				'contact_obj' => '',        //if entity_type='contact' and loaded=
											// true then this contains the loaded
											// contact data
				'loaded'      => False		//True when the object is already loaded
			);
		}

		function get_type()
		{
			return $this->get('entity_type');
		}

		function let_type($new_type)
		{
			if (strtolower($new_type) == 'contact')
			{
				$this->let('entity_type', 'contact');
			}
			elseif(strtolower(substr($new_type,0,3)) == 'org')
			{
				$this->let('entity_type', 'organization');
			}
		}

		function get_id()
		{
			return $this->id();
		}

		function save()
		{
			/* TODO */
			$myReply = False;
			return $myReply;
		}
		function load($intID)
		{
			/* TODO */
			$myReply = False;
			return $myReply;
		}
		function date_created()
		{
			return $this->get('date_created');
		}
		function date_modified()
		{
			return $this->get('date_modified');
		}
		function created_by()
		{
			return 'SOMETHING';
		}
		function version()
		{
			return $this->get('version');
		}
		function get_status()
		{
			/* Can be either 'active', 'pending', 'deleted' */
			return $this->get('status');
		} 
		function let_status($strStatus)
		{
			$mySuccess = False;
			if($strStatus=='active' || $strStatus=='pending' || $strStatus=='deleted')
			{
				$this->let('status', $strStatus);
				$mySuccess = True;
			}
			return $mySuccess;
		}
		function get_file_as()
		{
			return $this->get('file_as');
		}
		function let_file_as($strStatus)
		{
			$mySuccess = False;
			/* TODO defaults to "last_name, first_name" */ 
			$this->let('file_as', $strStatus);
			$mySuccess = True;
			return $mySuccess;
		}
		
		function get_followup_status()
		{
			return $this->get('followup_status');
		}
		function let_followup_status($intStatus)
		{
			$mySuccess = False;
			if(is_int($intStatus))
			{
				$this->let('followup_status', $intStatus);
				$mySuccess = True;
			}
			return $mySuccess;
		}
		
		function get_keywords()
		{
			return $this->get('keywords');
		}
		function let_keywords($strKeywords)
		{
			$mySuccess = False;
			/* TODO */
			/* keywords should either be an array or a comma separated list */
			if(1==1) // TODO
			{
				$this->let('keywords', $strKeywords);
				$mySuccess = True;
			}
			return $mySuccess;
		}
		function get_group_access()
		{
			/* ????  perhaps this should be a string?  controls on access? */
			return $this->get('group_access');
		}
		function let_group_access($intGroupAccess)
		{
			$mySuccess = False;
			/* TODO Check for existance of group as well */
			if(is_int($intGroupAccess))
			{
				$this->let('group_access', $intGroupAccess);
				$mySuccess = True;
			}
			return $mySuccess;
		}
		function get_ldap_sync()
		{
			return $this->get('ldap_sync');
		}
		function let_ldap_sync($doLdapSync)
		{
			$mySuccess = False;
			if($doLdapSync == True || $doLdapSync > 0)
			{
				$this->let('ldap_sync', True);
				$mySuccess = True;
			}
			elseif($doLdapSync == False || $doLdapSync == 0)
			{
				$this->let('ldap_sync', False);
				$mySuccess = True;
			}
			return $mySuccess;
		}
		function get_ldap_dn()
		{
			/* TODO */
			/*  if ldap_sync is true, and this record has already been 
			propogated, then this will return the dn which can directly
			reference the ldap entry.
			I have no clue what the above means. Mathieu.
			*/
			$this->get('ldap_dn');
		}
		function let_ldap_dn($strLdapDn)
		{
			/* TODO */
			/* see get_ldap_dn */
			$mySuccess = False;
			return $mySuccess;
		}
	}
?>
