<?php
  /**************************************************************************\
  * phpGroupWare Application (Napster)                                       *
  * http://www.phpgroupware.org                                              *
  * Written by Mark Peters <mpeters@satx.rr.com>                             *
  * Based on WebNap Client copyright 2000                                    *
  * Written by Aakash Kambuj <aakash@idearing.com>                           *
  *            Kalpak Kothari <kalpak@idearing.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  * --------------------------------------------                             *
  * Napster is a registered trademark of Napster Inc  http://www.napster.com *
  \**************************************************************************/

  /* $Id: index.php,v 1.6 2001/09/28 22:46:41 milosch Exp $ */

	$GLOBALS['phpgw_info']['flags']['currentapp'] = 'napster';
	$GLOBALS['phpgw_info']['flags']['enable_network_class'] = True;
	include('../header.inc.php');

	function close_routine()
	{
		$GLOBALS['phpgw']->network->close_port();
	}

	$napserver  = $HTTP_POST_VARS['napserver'];
	$linespeed  = $HTTP_POST_VARS['linespeed'];
	$linktype   = $HTTP_POST_VARS['linktype'];
	$keywords   = $HTTP_POST_VARS['keywords'];
	$nofirewall = $HTTP_POST_VARS['nofirewall'];

	$napster = CreateObject('napster.napster');

	register_shutdown_function('close_routine');

	if(!isset($napserver))
	{
		$napster->napserver = $napster->servers['imperialfleet.com'];
	}
	if(!isset($linespeed))
	{
		$napster->linespeed = 'AT BEST';
	}
	if(!isset($linktype))
	{
		$napster->$linktype = 10;
	}
	if(!isset($nofirewall))
	{
		$napster->nofirewall = 0;
	}

	$GLOBALS['phpgw']->template->set_file(array( 'search_form' => 'search.tpl'));
//	$GLOBALS['phpgw']->template->set_block('search_form','search_form');

//	$GLOBALS['phpgw']->db->query("SELECT * FROM phpgw_napster_servers WHERE lastupdated <= ".(time() - 86400));
	$GLOBALS['phpgw']->db->query("SELECT * FROM phpgw_napster_servers WHERE lastupdated <= ".(time() - 3600));
	if($GLOBALS['phpgw']->db->num_rows() > 0)
	{
		$napster->update_servers();
	}

	$GLOBALS['phpgw']->template->set_var('action_url',$GLOBALS['phpgw']->link('/napster/searchmp3.php'));
	$GLOBALS['phpgw']->template->set_var('search_word',lang('Search'));
	$GLOBALS['phpgw']->template->set_var('help_url',$GLOBALS['phpgw']->link('/napster/help.php'));
	$GLOBALS['phpgw']->template->set_var('help_word',lang('Help'));
	$GLOBALS['phpgw']->template->set_var('queue_url',$GLOBALS['phpgw']->link('/napster/queue.php','list=1'));
	$GLOBALS['phpgw']->template->set_var('queue_word',lang('Queue'));
	$GLOBALS['phpgw']->template->set_var('charts_url',$GLOBALS['phpgw']->link('/napster/mp3chart.php','napserver='.$napster->napserver
		.'&linespeed='.$napster->linespeed.'&linktype='.$napster->linktype
		.'&nofirewall='.$napster->nofirewall));
	$GLOBALS['phpgw']->template->set_var('charts_word',lang('Charts'));
	$GLOBALS['phpgw']->template->set_var('keywords',$keywords);
	$GLOBALS['phpgw']->template->set_var('napserver_list',$napster->select_options($napster->napserver,$napster->servers,0));
	$GLOBALS['phpgw']->template->set_var('linespeed_list',$napster->select_options($napster->linespeed,$napster->comparators,0));
	$GLOBALS['phpgw']->template->set_var('linktype_list',$napster->select_options($napster->linktype,$napster->speeds,1));
	$GLOBALS['phpgw']->template->set_var('firewall_filter_word',lang('Firewall Filter'));
	$GLOBALS['phpgw']->template->set_var('slow_word',lang('Slow'));
	$GLOBALS['phpgw']->template->set_var('firewall_checked',($napster->nofirewall ? 'checked' : ''));
	$GLOBALS['phpgw']->template->set_var('go_word',lang('Go'));
	$GLOBALS['phpgw']->template->set_var('server_stat_url',$GLOBALS['phpgw']->link('/napster/servers.php','getstats=1'));
	$GLOBALS['phpgw']->template->pparse('out','search_form');

	$GLOBALS['phpgw']->common->phpgw_footer();
?>
