#!/usr/bin/perl
 ############################################################################
 # phpGroupWare - phpgw_dj export util                                      #
 # http://www.phpgroupware.org                                              #
 # Written by Miles Lott <milosch@phpgroupware.org>                         #
 #   Export phpgroupware DJ MP3 info to id3 tags in the mp3 files listed    #
 # --------------------------------------------                             #
 #  This program is free software; you can redistribute it and/or modify it #
 #  under the terms of the GNU General Public License as published by the   #
 #  Free Software Foundation; either version 2 of the License, or (at your  #
 #  option) any later version.                                              #
 ############################################################################

 # $Id: export.pl,v 1.2 2001/05/02 02:39:44 milosch Exp $

	$dbtype  = 'mysql';
	$db_name = 'phpgroupware';
	$db_host = 'localhost';
	$db_user = 'root';
	$db_pass = '';

	# Do not edit below

	$_ = `which mp3info`;
	chomp;
	$mp3info = $_;

	sub usage
	{
		print qq~
$0 usage:
	$0 OR
	$0 h	Display this help screen
	$0 p	Process files flagged for export
	$0 a	Process all files in database
	$0 v	Verbose output

~;
	}

	use DBI;

	$option=$ARGV[0];
	$option = lc $option;
	$_=$option;
	if (/h/ || /help/ || /\?/) { &usage; exit; }

	if (/a/ || /p/)
	{
		if (/a/) { $where = ""; }
		if (/p/) { $where = " WHERE export=1"; }
	}
	else
	{
		&usage; exit;
	}

	if (/v/) { $verbose = 1; }

	$db = DBI->connect("DBI:$dbtype:database=$db_name;host=$db_host",$db_user,$db_pass);

	$sh = $db->prepare("SELECT song_name,song_title,song_artist,song_album,song_year,song_comment,song_genre FROM phpgw_dj_songlist$where");
	$sh->execute();

	while (@r = $sh->fetchrow_array())
	{
		if ($r[0])
		{
			$file    = $r[0];
			$title   = $r[1];
			$artist  = $r[2];
			$album   = $r[3];
			$year    = $r[4];
			$comment = $r[5];
			$genre   = $r[6];
		
			$cmd = "$mp3info -t \"$title\" -a \"$artist\" -l \"$album\" -y \"$year\" -c \"$comment\" -g \"$genre\" \"$file\"";
			if ($verbose) { print $cmd."\n"; }
			system($cmd);
		}
	}

	if ($verbose) { print "Done!\n"; }

