#include <stdio.h>
#include <sys/types.h>

#include <config.h>
#include <support.h>

#include <xcio.h>
#include <ppxp.h>

static struct {
    char *dname;
    char *mname;
    char *number;
    char *uname;
    char *passwd;
    char *fname;
    char *idle;
    char *ipmasq;
    char *dtype;
    char *atype;
    char *mode;
    bool_t vjc;
} qSets;

static void
QuickGet(int fd)
{
    u_int8_t xid;
    char *p;

    xid = PPxPEnvRequestv(fd, "LINE", NULL);
    p = PPxPEnvGet(fd, xid);
    qSets.dname = Strdup((p && *p) ? p: "/dev/modem");

    xid = PPxPEnvRequestv(fd, "SERIAL.MODEM", NULL);
    p = PPxPEnvGet(fd, xid);
    if (!strcmp(p, "direct")) p = NULL;
    qSets.mname = Strdup((p && *p) ? p: "generic");

    xid = PPxPEnvRequestv(fd, "DIAL.TYPE", NULL);
    p = PPxPEnvGet(fd, xid);
    qSets.dtype = Strdup((p && *p) ? p: "default");

    xid = PPxPEnvRequestv(fd, "DIAL.LIST", NULL);
    p = PPxPEnvGet(fd, xid);
    qSets.number = Strdup((p && *p) ? p: "");

    xid = PPxPEnvRequestv(fd, "AUTH.PROTO", NULL);
    p = PPxPEnvGet(fd, xid);
    qSets.atype = Strdup((p && *p) ? p: "");

    PPxPwdGet(fd, &qSets.uname, &qSets.passwd);
}

void
QuickTitle()
{
    printf("<HTML>"
	   "<HEAD><TITLE>PPxP Quick Diap-up</TITLE>"
	   "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html\">"
	   "</HEAD>"
	   "<BODY BGCOLOR=\"#CCBBAA\" TEXT=\"green\""
	   " LINK=\"yellow\" ALINK=\"yellow\" VLINK=\"yellow\">"
	   "<TABLE CELLPADDING=0 CELLSPACING=0 WIDTH=600 BORDER=0>"
	   "<TR>"
	   "<TD ALIGN=\"left\" VALIGN=\"top\">"
	   "<IMG SRC=\"logo.gif\" WIDTH=129 HEIGHT=66>"
	   "<TD WIDTH=450 ALIGN=\"center\" VALIGN=\"mid\">"
	   "<H1>å륢å</H1>"
	   "</TABLE></HTML>\n");
}

void
QuickMain()
{
    struct list_s *lh, *lp;
    FILE *fp;
    char *p, buf[256];
    int fd;

    fd = HttpdFd();
    QuickGet(fd);
    printf("<HTML>"
	   "<HEAD><TITLE>PPxP Quick Diap-up</TITLE>"
	   "<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html\">"
	   "</HEAD>"
	   "<BODY BGCOLOR=\"#CCBBAA\" TEXT=\"green\""
	   " LINK=\"yellow\" ALINK=\"yellow\" VLINK=\"yellow\">"
	   "<FORM NAME=\"ppxpquick\" METHOD=\"POST\" "
	   "ACTION=\"quickmain\">\n");

    /*
     * ³
     */

    printf("<FONT COLOR=\"blue\"><H2>"
	   "³</H2></FONT><TABLE>\n");

    printf("<TR><TD WIDTH=200>"
	   "<A HREF=\"help.html#DialList\" TARGET=\"help\">"
	   "ֹ</A></TD><TD>"
	   "<INPUT NAME=\"DIAL.LIST\" MAXLENTH=\"32\" VALUE=\"%s\">"
	   "</TD></TR>\n", qSets.number);

    printf("<TR><TD WIDTH=200>"
	   "<A HREF=\"help.html#UserName\" TARGET=\"help\">"
	   "桼̾</A></TD><TD>"
	   "<INPUT NAME=\"USERNAME\" MAXLENTH=\"32\" VALUE=\"%s\">"
	   "</TD></TR>\n", qSets.uname ? qSets.uname:"");

    printf("<TR><TD WIDTH=200>"
	   "<A HREF=\"help.html#UserPasswd\" TARGET=\"help\">"
	   "ѥ</A></TD><TD>"
	   "<INPUT NAME=\"USERPASSWD\" TYPE=\"password\" "
	   "VALUE=\"%s\" MAXLENTH=\"32\"></TD></TR>\n",
	   qSets.passwd ? qSets.passwd: "");

    printf("<TR><TD WIDTH=200>"
	   "<A HREF=\"help.html#AuthProtocol\" TARGET=\"help\">"
	   "ǧ</A></TD>"
	   "<TD><SELECT NAME=\"AUTH.PROTO\">"
	   "<OPTION VALUE=\"pap chap/md5 chap/ms\">ư"
	   "<OPTION VALUE=\"pap\" %s>PAP"
	   "<OPTION VALUE=\"chap/md5\" %s>CHAP/MD5"
	   "<OPTION VALUE=\"chap/ms\" %s>CHAP/MS"
	   "</SELECT></TD></TR>\n",
	   strncasecmp(qSets.atype, "pap", 3) ? "": "SELECTED",
	   strncasecmp(qSets.atype, "chap/md5", 8) ? "": "SELECTED",
	   strncasecmp(qSets.atype, "chap/ms", 7) ? "": "SELECTED");

    /*
     * ϡɥ
     */

    printf("</TABLE><HR><FONT COLOR=\"blue\">"
	   "<H2>ϡɥ</H2></FONT><TABLE>\n");

    printf("<TR><TD WIDTH=200>"
	   "<A HREF=\"help.html#DialStyle\" TARGET=\"help\">"
	   "</A></TD>"
	   "<TD><SELECT NAME=\"DIAL.TYPE\">"
	   "<OPTION VALUE=\"default\" %s>ɸ/ISDN"
	   "<OPTION VALUE=\"Pulse\" %s>ѥ륹"
	   "<OPTION VALUE=\"Tone\" %s>ȡ(ץå)"
	   "</SELECT></TD></TR>\n",
	   strcasecmp(qSets.dtype, "default") ? "": "SELECTED",
	   strcasecmp(qSets.dtype, "pulse") ? "": "SELECTED",
	   strcasecmp(qSets.dtype, "tone") ? "": "SELECTED");

    lh = FileList(sysPPxP, "modem");
    printf("<TR><TD WIDTH=200>"
	   "<A HREF=\"help.html#ModemType\" TARGET=\"help\">"
	   "ǥε</A></TD><TD><SELECT NAME=\"SERIAL.MODEM\">\n");
    lp = lh;
    while (lp) {
	p = lp->name;
	if ((fp = fopen(lp->data, "r")) != NULL) {
	    while (fgets(buf, sizeof(buf), fp)) {
		if (!strncasecmp(buf, "Name", 4)) {
		    char *r;

		    p = buf + 5;
		    while (*p && strchr(" \t\"", *p)) p ++;
		    r = buf + strlen(buf) - 1;
		    while (r > p && strchr(" \t\r\n\"", *r)) r --;
		    if (r > p) *(r + 1) = '\0';
		    break;
		}
	    }
	    fclose(fp);
	}
	if (lp->data) Free(lp->data);
	lp->data = lp->name;
	lp->name = Strdup(p);
	lp = lp->next;
    }
    lh = SortList(lh);
    lp = lh;
    while (lp) {
	printf("<OPTION VALUE=\"%s\"%s>%s\n", lp->data,
	       strncasecmp(lp->data, qSets.mname, strlen(lp->data))
	       ? "": " SELECTED", lp->name);
	lp = lp->next;
    }
    printf("</SELECT></TD></TR>\n");

    printf("<TR><TD WIDTH=200>"
	   "<A HREF=\"help.html#DeviceName\" TARGET=\"help\">"
	   "ǥХ̾</A></TD><TD>"
	   "<INPUT NAME=\"LINE\" MAXLENTH=\"32\" VALUE=\"%s\">"
	   "</TD></TR>", qSets.dname);

    /*
     * ü쵡ǽ
     */

    printf("</TABLE><HR><FONT COLOR=\"blue\">"
	   "<H2>ü쵡ǽ</H2></FONT><TABLE>\n");

    printf("<TR><TD WIDTH=200>"
	   "<A HREF=\"help.html#IPMasq\" TARGET=\"help\">"
	   "IPޥ졼</A></TD><TD>"
	   "<INPUT NAME=\"IPMASQ\" MAXLENTH=\"32\"></TD></TR>\n");

    printf("</TABLE><HR>\n");
    printf("<TABLE><TR><TD>Ǥ?</TD>"
	   "<TD><INPUT TYPE=\"submit\" VALUE=\"Yes\">"
	   "<TD><INPUT TYPE=\"reset\" VALUE=\"Cancel\">"
	   "</TD></TR></TABLE>");
    printf("</HTML>\n");
}
