#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/cursorfont.h>
#include <stdio.h>
#include <stdlib.h>
#include <config.h>
#include <support.h>
#include <xcio.h>
#include <string.h>
#include "pixmap/menu0.xbm"
#include "pixmap/menu1.xbm"
#include "pixmap/menu2.xbm"
#include "pixmap/menu3.xbm"
#include "pixmap/menu4.xbm"
#include "pixmap/menu5.xbm"
#include "pixmap/menu6.xbm"
#include "xppxpm.h"

Widget menuShell;
Widget buttonTitle;
Widget buttonAuto;
Widget buttonConnect;
Widget buttonDisconnect;
Widget buttonBye;
Widget buttonQuit;
Widget buttonTerminal;
Cursor cursor;

static Widget *menuButton[] = {
	&buttonTitle,
	&buttonAuto,
	&buttonConnect,
	&buttonDisconnect,
	&buttonBye,
	&buttonQuit,
	&buttonTerminal,
};

static Bool menu_button_up = False;

static void
MenuPopup( Widget w, XEvent *e, String *p, Cardinal *n )
{
	Dimension width, height;

	if ( w != menuShell) {
		XtCallActionProc( w, "XawPositionSimpleMenu", e, p, *n );
		XtPopup( menuShell, XtGrabNonexclusive );
		XtGrabPointer(menuShell, True,
		      ButtonPressMask|ButtonReleaseMask|ButtonMotionMask,
		      GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
		menu_button_up = False;
	} else {
		XtVaGetValues( menuShell, 
			       XtNwidth, &width, XtNheight, &height, NULL);
		if (e->xbutton.x < 0 || e->xbutton.x > width
		    || e->xbutton.y < 0 || e->xbutton.y > height ) {
			XtPopdown( menuShell );
		}
	}
}

static void
MenuSelect( Widget w, XEvent *e, String *p, Cardinal *n )
{
	unsigned int i;
	Position x, y;
	Dimension width, height;

	if ( w != menuShell )
		return;
	if ( !menu_button_up ) {
		menu_button_up = True;
		return;
	}
	for( i=0; i<XtNumber( menuButton ); i++ ) {
		XtVaGetValues( *menuButton[i],
			       XtNx, &x,
			       XtNy, &y,
			       XtNwidth, &width,
			       XtNheight, &height,
			       NULL );
		if ( e->xbutton.x >= x && e->xbutton.x <= (x+width)
		     && e->xbutton.y >= y && e->xbutton.y <= (y+height) ) {
			XtCallActionProc( w, "highlight", e, p, *n );
			XtCallCallbacks( *menuButton[i], XtNcallback, NULL );
			XtCallActionProc( w, "unhighlight", e, p, *n );
			XtPopdown( menuShell );
			return;
		}
	}
}

static void
MenuHighlight( Widget w, XEvent *e, String *p, Cardinal *n)
{
	unsigned int i;
	Position x, y;
	Dimension width, height;

	for( i=1; i<XtNumber( menuButton ); i++ ) {
		menu_button_up = True;
		XtVaGetValues( *menuButton[i],
			       XtNx, &x,
			       XtNy, &y,
			       XtNwidth, &width,
			       XtNheight, &height,
			       NULL );
		if ( e->xbutton.x > x && e->xbutton.x < (x+width)
		     && e->xbutton.y > y && e->xbutton.y < (y+height) ) {
			XtCallActionProc(w, "highlight", e, p, *n);
			return;
		}
	}
}

void
MenuTitle(Widget w, XtPointer call_data, XtPointer client_data )
{
	if (ppxpFd > 0) {
		PPxPCommandv(ppxpFd, XCMD_SET, "IDLE.TIME", "300", NULL);
	}
}

void
MenuAuto(Widget w, XtPointer call_data, XtPointer client_data )
{
	String label;

	if (ppxpFd > 0) {
		XtVaGetValues(buttonAuto, XtNlabel,  &label, NULL);

		if ( strcmp( label, LabelAutoON ) == 0 ) {
			PPxPCommandv(ppxpFd, XCMD_AUTO, "on", NULL);
		} else {
			PPxPCommandv(ppxpFd, XCMD_AUTO, "off", NULL);
		}
	}
}

void
MenuConnect(Widget w, XtPointer call_data, XtPointer client_data )
{
	if (ppxpFd > 0) {
		PPxPCommandv(ppxpFd, XCMD_CONNECT, NULL);
	}
}

void
MenuDisconnect(Widget w, XtPointer call_data, XtPointer client_data )
{
	if (ppxpFd > 0) {
		PPxPCommandv(ppxpFd, XCMD_DISCONNECT, NULL);
	}
}

void
MenuBye(Widget w, XtPointer call_data, XtPointer client_data )
{
	if (ppxpFd > 0) {
		PPxPCommandv(ppxpFd, XCMD_BYE, NULL);
	}
	FreeAll();
	exit(0);
}

void
MenuQuit(Widget w, XtPointer call_data, XtPointer client_data )
{
	if (ppxpFd > 0) {
		PPxPCommandv(ppxpFd, XCMD_QUIT, NULL);
	}
}

void
MenuTerminal(Widget w, XtPointer call_data, XtPointer client_data )
{
	if (fork()==0) {
		execlp("xterm", "xterm", "-e", "ppxp", NULL);
		exit(0);
	}
}

Widget
AddMenu( char *name, XtCallbackProc callback, char *fgcolor,
	Dimension lm, Dimension rm, Pixmap pixmenu)
{
	Widget w;

	w=XtVaCreateManagedWidget( name, smeBSBObjectClass, menuShell, 
		   XtVaTypedArg, 
		   XtNforeground, XtRString, fgcolor, strlen(fgcolor)+1,
		   XtNleftMargin, lm, XtNrightMargin, rm,
		   XtNleftBitmap, pixmenu, NULL);
	XtAddCallback( w, XtNcallback, callback, NULL );
	return w;
}

static XtActionsRec menuActions[] = {
	{ "PPxPMenuPopup", (XtActionProc) MenuPopup },
	{ "PPxPMenuSelect", (XtActionProc) MenuSelect },
	{ "PPxPMenuHighlight", (XtActionProc) MenuHighlight },
};

static char baseTranslations[] = 
	"<Btn1Down>: PPxPMenuPopup(ppxp)\n"
	"<Btn3Up>: MenuPopdown(ppxp)\n"
;
static char menuTranslations[] = 
	"<Btn1Down>: PPxPMenuPopup(ppxp)\n"
	"<Btn1Up>: PPxPMenuSelect()\n"
	"<Btn3Up>: MenuPopdown(ppxp)\n"
	"<MotionNotify>: PPxPMenuHighlight()\n"
	"<BtnUp>: \n"
;

void
CreateMenu( Widget top )
{
	static Pixmap pixmenu0, pixmenu1, pixmenu2, pixmenu3;
	static Pixmap pixmenu4, pixmenu5, pixmenu6;

	pixmenu0 = XCreateBitmapFromData(XtDisplay(top), 
		XtWindow(top), menu0_bits, menu0_width, menu0_height);
	pixmenu1 = XCreateBitmapFromData(XtDisplay(top), 
		XtWindow(top), menu1_bits, menu1_width, menu1_height);
	pixmenu2 = XCreateBitmapFromData(XtDisplay(top), 
		XtWindow(top), menu2_bits, menu2_width, menu2_height);
	pixmenu3 = XCreateBitmapFromData(XtDisplay(top), 
		XtWindow(top), menu3_bits, menu3_width, menu3_height);
	pixmenu4 = XCreateBitmapFromData(XtDisplay(top), 
		XtWindow(top), menu4_bits, menu4_width, menu4_height);
	pixmenu5 = XCreateBitmapFromData(XtDisplay(top), 
		XtWindow(top), menu5_bits, menu5_width, menu5_height);
	pixmenu6 = XCreateBitmapFromData(XtDisplay(top), 
		XtWindow(top), menu6_bits, menu6_width, menu6_height);

	XtAppAddActions(appc, menuActions, XtNumber(menuActions));

	cursor=XCreateFontCursor( XtDisplay( top ), XC_hand2 );

	menuShell=XtVaCreatePopupShell( "ppxp", simpleMenuWidgetClass, top, 
		XtNcursor, cursor,
		XtVaTypedArg,
		XtNbackground, XtRString, BG_COLOR, strlen(BG_COLOR)+1,
		NULL);

	XtOverrideTranslations(menuShell,
			       XtParseTranslationTable(menuTranslations));
	XtOverrideTranslations(base,
			       XtParseTranslationTable(baseTranslations));

	buttonTitle = AddMenu("",
		MenuTitle, FG_COLOR, 94, 0, pixmenu0);
	XtVaSetValues(buttonTitle, XtNsensitive, False, NULL);

	buttonAuto = AddMenu("Auto",
		MenuAuto, AUTO_COLOR, 18, 0, pixmenu1);
	buttonConnect = AddMenu( "Connect",
		MenuConnect, FG_COLOR, 18, 0, pixmenu2);
	buttonDisconnect= AddMenu( "Disconnect",
		MenuDisconnect, FG_COLOR, 18, 0, pixmenu3);
	buttonBye=AddMenu( "Bye",
		MenuBye, FG_COLOR, 18, 0, pixmenu4);
	buttonQuit=AddMenu( "Quit",
		MenuQuit, FG_COLOR, 18, 0, pixmenu5);
	buttonTerminal=AddMenu( "Terminal",
		MenuTerminal, TERM_COLOR, 18, 0, pixmenu6);

	ButtonSet( BS_False, BS_False );
}

void
MenuChange(int menuType)
{
        if (menuType) {
                XtVaSetValues(buttonAuto, 
                              XtVaTypedArg, XtNforeground, XtRString, 
                              OFF_COLOR, strlen(OFF_COLOR)+1,NULL);
                XtVaSetValues(buttonConnect,
                              XtVaTypedArg, XtNforeground, XtRString, 
                              OFF_COLOR, strlen(OFF_COLOR)+1, NULL);
                XtVaSetValues(buttonDisconnect,
                              XtVaTypedArg, XtNforeground, XtRString, 
                              OFF_COLOR, strlen(OFF_COLOR)+1, NULL);
                XtVaSetValues(buttonQuit,
                              XtVaTypedArg, XtNforeground, XtRString, 
                              OFF_COLOR, strlen(OFF_COLOR)+1, NULL);
        } else {
                XtVaSetValues(buttonAuto, 
                              XtVaTypedArg, XtNforeground, XtRString, 
                              AUTO_COLOR, strlen(AUTO_COLOR)+1, NULL);
                XtVaSetValues(buttonConnect,
                              XtVaTypedArg, XtNforeground, XtRString, 
                              FG_COLOR, strlen(FG_COLOR)+1, NULL);
                XtVaSetValues(buttonDisconnect,
                              XtVaTypedArg, XtNforeground, XtRString, 
                              FG_COLOR, strlen(FG_COLOR)+1, NULL);
                XtVaSetValues(buttonQuit,
                              XtVaTypedArg, XtNforeground, XtRString, 
                              FG_COLOR, strlen(FG_COLOR)+1, NULL);
        }
}
