#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <netinet/in.h>

#include <config.h>
#include <support.h>

#include "option.h"
#include "log.h"
#include "phase.h"
#include "env.h"
#include "console.h"
#include "timer.h"
#include "frame.h"
#include "fsm.h"
#include "cps.h"
#include "lcp.h"

struct cbcpopt_s {
    struct in_addr r_addr;
    struct in_addr r_mask;
    struct in_addr l_addr;
    struct in_addr l_mask;
    struct in_addr netmask;
    struct in_addr network;
    struct in_addr dns[2];
    char *up, *down, *domain;
    bool_t vjcmp;
    u_int8_t vj_max_slot;
    u_int8_t vj_cmp_slot;
};

static struct cbcpopt_s cbcpOpt;

#define	CBCPCODE_MAX	CPCODE_RESET_REP

#define	CBCPCONF_NOCB	1
#define	CBCPCONF_USER	2
#define	CBCPCONF_ADMIN	3
#define	CBCPCONF_LIST	4
#define	CBCPCONF_MAX	5

static b256_t remoteReject;
static b256_t localReject;

#if 0
static struct cbcpreg_s {
    int type;
    union {
	bool_t pred1;
	bool_t pred2;
	bool_t bsdlzw;
    } regs;
#define	reg_pred1	regs.pred1	
#define	reg_pred2	regs.pred2
#define	reg_bsdlzw	regs.bsdlzw
} remoteReg, localReg, tmpReg;

static struct fsmreg_s cbcpFsm;
static struct cpcodeop_s cbcpCop[CBCPCODE_MAX + 1];
static struct cptypeop_s cbcpTop[]={
    {
	"OUI", NULL,
	NULL, NULL, 0,
	CBCPCONF_OUI
    }, {
	"Predictor type 1", NULL,
	&tmpReg.reg_pred1, NULL, 0,
	CBCPCONF_PRED1
    }, {
	"Predictor type 2", NULL,
	NULL, NULL, 0,
	CBCPCONF_PRED2
    }, {
	"Puddle Jumper", NULL,
	NULL, NULL, 0,
	CBCPCONF_PUDDLE
    }, {
	"Hewlett-Packard PPC", NULL,
	NULL, NULL, 0,
	CBCPCONF_HPPPC
    }, {
	"Stac Electronics LZS", NULL,
	NULL, NULL, 0,
	CBCPCONF_SELZS
    }, {
	"Microsoft PPC", NULL,
	NULL, NULL, 0,
	CBCPCONF_MSPPC
    }, {
	"Gandalf FZA", NULL,
	NULL, NULL, 0,
	CBCPCONF_GFZA
    }, {
	"V.42bis compression", NULL,
	NULL, NULL, 0,
	CBCPCONF_V42BIS
    }, {
	"BSD LZW Compress", NULL,
	NULL, NULL, 0,
	CBCPCONF_BSDLZW
    }
};

static cptype_t remoteOrder[CBCPCONF_MAX], localOrder[CBCPCONF_MAX];

static struct cpstate_s cbcpState={
    cbcpCop,		/* code oprators */
    cbcpTop,		/* type operators */
    (void *)&remoteReg,	/* remote registry */
    (void *)&localReg,	/* local registry */
    NULL,		/* received buffer pointers */
    NULL,		/* encode order */
    remoteOrder,	/* remote(received) order */
    localOrder,		/* request(local) order */
    {0},		/* encode list */
    {0},		/* remote(received) list */
    {0},		/* request(local) list */
    /* number of configuration types */
    sizeof(cbcpTop)/sizeof(struct cptypeop_s),
    NBO_PROTO_CBCP,
    1, 1		/* remote/local ID */
};

static int
CbcpEncodeReg(u_char *buf, struct cbcpreg_s *ccr)
{
    if (ccr) memcpy(&tmpReg, ccr, sizeof(struct cbcpreg_s));
    CpEncodeReg(&cbcpState, buf, FALSE);
}

/* FSM action functions */

static void
CbcpDown()
{
    lineMode &= ~LINE_NLINK;
    FsmClose(&cbcpFsm);
}

static void
TLU(struct fsmreg_s *fsm)
{
    /*RegisterDownPhase(CbcpDown);*/
}

static void
TLD(struct fsmreg_s *fsm)
{
/*
    const char *oldpath;

    oldpath = SetLoadFilePath("ip");
    LoadScriptFile(ipcpOpt.down);
    SetLoadFilePath(oldpath);
*/
}

static void
TLF(struct fsmreg_s *fsm)
{
/*
    lineMode &= ~LINE_PPP;
    phaseShift = PHASE_DOWN;
*/
}

static int
RCR(u_char *buf, int n)
{
    int i=0;
    cptype_t type;
    b256_t rej, nak;

    memset(&tmpReg, 0, sizeof(struct cbcpreg_s));
    CpDecodeReg(&cbcpState, buf, n);
    B256_ZERO(&nak);
    B256_ZERO(&rej);
    cbcpFsm.nak_rcr = cbcpFsm.rej_rcr = 0;
    while ((type = remoteOrder[i++])) {
	switch (type) {
	case CBCPCONF_PRED1:
/*	    continue;*/
	default:
	    /* not supported */
	    cbcpFsm.rej_rcr = 1;
	    B256_SET(&rej, type);
	    continue;
	}
	cbcpFsm.nak_rcr = 1;
	B256_SET(&nak, type);
    }
    memcpy(&remoteReg, &tmpReg, sizeof(struct cbcpreg_s));
    if (cbcpFsm.rej_rcr) B256_CPY(&cbcpState.r_list, &rej);
    else if (cbcpFsm.nak_rcr) B256_CPY(&cbcpState.r_list, &nak);
    FsmRCR(&cbcpFsm);
}

static int
RCA(u_char *buf, int n)
{
    memset(&tmpReg, 0, sizeof(struct cbcpreg_s));
    CpDecodeReg(&cbcpState, buf, n);
/*    cbcpFsm.good_rcr = localReject ? 0: 1;*/
    FsmRCA(&cbcpFsm);
}

static int
RXJ(u_char *buf, int n)
{
    memset(&tmpReg, 0, sizeof(struct cbcpreg_s));
/*
    CpDecodeReg(&cbcpState, buf, n);
    cbcpState.l_list &= ~cbcpState.r_list;
    cbcpFsm.fatal_rxj = (cbcpState.r_list & FATAL_RXJ) ? 0: 1;
*/
    FsmRXJ(&cbcpFsm);
}

static int
RCN(u_char *buf, int n)
{
    RXJ(buf, n);
}

static int
RTR(u_char *buf, int n)
{
    return(CpRtr(&cbcpFsm, buf, n));
}

static int
RTA(u_char *buf, int n)
{
    return(CpRta(&cbcpFsm, buf, n));
}

static void
CbcpEnable(bool_t sw)
{
    FrameEnable(NBO_PROTO_CBCP, sw);
}

void
CbcpSetup()
{
/*
    static struct env_s envlist[]={
	{"TIMEOUT", &pppOpt.r_to, ENV_INT32, 0, 0, 0666},
	{"RETRY", &pppOpt.r_count, ENV_INT32, 0, 0, 0666},
	{"ACCMAP", &pppOpt.hbo_accm, ENV_INT32X, 0, 0, 0666},
	{"ACFC", &pppOpt.acfc, ENV_BOOL, 0, 0, 0666},
	{NULL}
    };

    RegisterEnvs(envlist, "CBCP", CbcpEnable);
*/
    RegisterCp(&cbcpState, &cbcpFsm);
    cbcpFsm.name = "CBCP";
    cbcpFsm.timer.name = "CBCPFSM";
    cbcpFsm.timer.arg = &cbcpFsm;
    cbcpCop[CPCODE_CONF_REQ].fsmevent = RCR;
    cbcpCop[CPCODE_CONF_REQ].encode = CbcpEncodeReg;
    cbcpCop[CPCODE_CONF_ACK].fsmevent = RCA;
    cbcpCop[CPCODE_CONF_ACK].encode = CbcpEncodeReg;
    cbcpCop[CPCODE_CONF_NAK].fsmevent = RCN;
    cbcpCop[CPCODE_CONF_NAK].encode = CbcpEncodeReg;
    cbcpCop[CPCODE_CONF_REJ].fsmevent = RXJ;
    cbcpCop[CPCODE_CONF_REJ].encode = CbcpEncodeReg;
    cbcpCop[CPCODE_TERM_REQ].fsmevent = RTR;
    cbcpCop[CPCODE_TERM_ACK].fsmevent = RTA;
    cbcpFsm.tlu = TLU;
    cbcpFsm.tlf = TLF;
    cbcpFsm.tld = TLD;
}

void
CbcpInit()
{
    int i, k;

    B256_ZERO(&cbcpState.l_list);
/*
    CPT_SET(&cbcpState.l_list, CBCPCONF_PRED1);
    localReg.reg_pred1 = TRUE;
*/
    for (k = 0, i = 0; i < CBCPCONF_MAX; i ++)
	if (B256_ISSET(&cbcpState.l_list, i)) localOrder[k++] = i;

    cbcpFsm.init_r_count = pppOpt.r_count;
    cbcpFsm.init_r_to = pppOpt.r_to;
    FsmInit(&cbcpFsm);
    FsmUp(&cbcpFsm);
    cbcpFsm.opt_p = (pppOpt.mode == RUN_PASSIVE) ? 1: 0;
    FsmOpen(&cbcpFsm);
}
#endif

void
CbcpInit()
{
    extern struct lcpreg_s lcprReg;
    extern struct lcpreg_s lcplReg;

    if (lcplReg.callback_type != CALLBACK_CBCP) PhaseUp();
}
