/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: addform.cpp 
 *              
 *      Abstract: Implement add/edit profile settings 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      PaulL           22nd Jan 02     Created
 *      MarkW           9th  Feb 04     Baseline of code
 *	MarkW		3rd  Oct 04	Change to standard bits reference
 ***************************************************************************/ 


#include "addform.h"
#include "raconfigform.h"
#include "rt_tool.h"

#include <qapplication.h>
#include <qvariant.h>
#include <qheader.h>
#include <qmime.h>
#include <qdragobject.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qlistview.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qvalidator.h>
#include <qmessagebox.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/wireless.h>
#include <ctype.h>

extern char  *strAryNetworkType[3];
extern UCHAR CountryRegion;
extern UCHAR G_nCountryCount;
extern REGSTR_COUNTRY_ENTRY CountryRegionTable[];

static QPixmap uic_load_pixmap_AddForm( const QString &name )
{
	const QMimeSource *m = QMimeSourceFactory::defaultFactory()->data( name );
	
	if ( !m )
		return QPixmap();
	QPixmap pix;
	QImageDrag::decode( m, pix );

	return pix;
}
/* 
 *  Constructs a AddForm which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
AddForm::AddForm( int socket_id, const char *device_name, QWidget* parent,  const char* name,  int type, QListView* pListView, bool modal, const char *BSSIDName, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
	if ( !name )
		setName( "AddForm" );
	resize( 600, 480 ); 
	setMinimumSize(600, 480);
	setMaximumSize(600, 480);
	setCaption( trUtf8( "AddProfile" ) );
	setIcon( uic_load_pixmap_AddForm( "raconfig.xpm" ) );		 
	setPaletteBackgroundColor( QColor( 222, 222,  222 ) );

	// qApp->setStyle("Windows");

	TextLabel1 = new QLabel( this, "TextLabel1" );
	TextLabel1->setGeometry( QRect( 30, 20, 80, 20 ) ); 
	TextLabel1->setText( trUtf8( "Profile Name" ) );

	TextLabel2 = new QLabel( this, "TextLabel2" );
	TextLabel2->setGeometry( QRect( 310, 20, 40, 20 ) ); 
	TextLabel2->setText( trUtf8( "SSID" ) );

	ProfileLineEdit = new QLineEdit( this, "ProfileLineEdit" );
	ProfileLineEdit->setGeometry( QRect( 130, 20, 160, 22 ) ); 
	ProfileLineEdit->setMaxLength( 32 );

	SsidComboBox = new QComboBox( FALSE, this, "SsidComboBox" );	 
	SsidComboBox->setGeometry( QRect( 360, 20, 180, 24 ) ); 
	SsidComboBox->setEditable( TRUE );

	ProfileTabWidget = new QTabWidget( this, "ProfileTabWidget" );
	ProfileTabWidget->setGeometry( QRect( 20, 60, 560, 360 ) ); 
	ProfileTabWidget->setPaletteBackgroundColor( QColor( 222, 222,  222 ) );

	tab = new QWidget( ProfileTabWidget, "tab" );

	PowerSaveButtonGroup = new QButtonGroup( tab, "PowerSaveButtonGroup" );
	PowerSaveButtonGroup->setEnabled( TRUE );
	PowerSaveButtonGroup->setGeometry( QRect( 20, 8, 500, 70 ) ); 
	PowerSaveButtonGroup->setTitle( trUtf8( "Power Saving Mode" ) );

	CAMRadioButton = new QRadioButton( PowerSaveButtonGroup, "CAMRadioButton" );
	CAMRadioButton->setGeometry( QRect( 20, 20, 210, 16 ) ); 
	CAMRadioButton->setText( trUtf8( "CAM (Constantly Awake Mode)" ) );
	PowerSaveButtonGroup->insert( CAMRadioButton, 0 );
	CAMRadioButton->setChecked( TRUE );

	Fast_PSPRadioButton = new QRadioButton( PowerSaveButtonGroup, "Fast_PSPRadioButton" );
	Fast_PSPRadioButton->setGeometry( QRect( 20, 40, 210, 20 ) ); 
	Fast_PSPRadioButton->setText( trUtf8( "Fast_PSP (Power Saving Mode)" ) );
	PowerSaveButtonGroup->insert( Fast_PSPRadioButton, 2 );

	Max_PSPRadioButton = new QRadioButton( PowerSaveButtonGroup, "Max_PSPRadioButton" );
	Max_PSPRadioButton->setGeometry( QRect( 270, 20, 210, 16 ) ); 
	Max_PSPRadioButton->setText( trUtf8( "Max_PSP(Max Power Savings)" ) );
	PowerSaveButtonGroup->insert( Max_PSPRadioButton, 1 );

	ButtonGroup2 = new QButtonGroup( tab, "ButtonGroup2" );
	ButtonGroup2->setGeometry( QRect( 20, 84, 500, 50 ) ); 
	ButtonGroup2->setTitle( trUtf8( "Antenna  Tx Diversity" ) );

	TxDiversityRadioButton = new QRadioButton( ButtonGroup2, "TxDiversityRadioButton" );
	TxDiversityRadioButton->setGeometry( QRect( 20, 23, 90, 16 ) ); 
	TxDiversityRadioButton->setText( trUtf8( "Diversity" ) );
	ButtonGroup2->insert( TxDiversityRadioButton, 0 );
	TxDiversityRadioButton->setChecked( TRUE );

	TxRightAntRadioButton = new QRadioButton( ButtonGroup2, "TxRightAntRadioButton" );
	TxRightAntRadioButton->setGeometry( QRect( 150, 20, 160, 16 ) ); 
	TxRightAntRadioButton->setText( trUtf8( "Antenna A only" ) );
	ButtonGroup2->insert( TxRightAntRadioButton, 1 );

	TxLeftAntRadioButton = new QRadioButton( ButtonGroup2, "TxLeftAntRadioButton" );
	TxLeftAntRadioButton->setGeometry( QRect( 310, 20, 160, 16 ) ); 
	TxLeftAntRadioButton->setText( trUtf8( "Antenna B only" ) );
	ButtonGroup2->insert( TxLeftAntRadioButton, 2 );

	ButtonGroup6 = new QButtonGroup( tab, "ButtonGroup6" );
	ButtonGroup6->setGeometry( QRect( 20, 140, 500, 50 ) ); 
	ButtonGroup6->setTitle( trUtf8( "Antenna Rx Diversity" ) );

	RxDiversityRadioButton = new QRadioButton( ButtonGroup6, "RxDiversityRadioButton" );
	RxDiversityRadioButton->setGeometry( QRect( 20, 20, 130, 20 ) ); 
	RxDiversityRadioButton->setText( trUtf8( "Diversity" ) );
	ButtonGroup6->insert( RxDiversityRadioButton, 0 );
	RxDiversityRadioButton->setChecked( TRUE );

	RxRightAntRadioButton = new QRadioButton( ButtonGroup6, "RxRightAntRadioButton" );
	RxRightAntRadioButton->setGeometry( QRect( 150, 20, 160, 16 ) ); 
	RxRightAntRadioButton->setText( trUtf8( "Antenna A only" ) );
	ButtonGroup6->insert( RxRightAntRadioButton, 1);

	RxAntRadioButton = new QRadioButton( ButtonGroup6, "RxAntRadioButton" );
	RxAntRadioButton->setGeometry( QRect( 310, 20, 120, 20 ) ); 
	RxAntRadioButton->setText( trUtf8( "Antenna B only" ) );
	ButtonGroup6->insert( RxAntRadioButton, 2 );

	TextLabel3 = new QLabel( tab, "TextLabel3" );
	TextLabel3->setGeometry( QRect( 20, 195, 100, 20 ) ); 
	TextLabel3->setText( trUtf8( "Network Type" ) );

	NetworkComboBox = new QComboBox( FALSE, tab, "NetworkComboBox" );
	NetworkComboBox->insertItem( trUtf8( "802.11 Ad Hoc" ) );
	NetworkComboBox->insertItem( trUtf8( "Infrastructure" ) );
	NetworkComboBox->setGeometry( QRect( 120, 195, 130, 20 ) ); 
	NetworkComboBox->setCurrentItem(1);

	TextLabel4 = new QLabel( tab, "TextLabel4" );
	TextLabel4->setGeometry( QRect( 280, 195, 90, 20 ) ); 
	TextLabel4->setText( trUtf8( "Transmit Rate" ) );

	TransmitRateComboBox = new QComboBox( FALSE, tab, "TransmitRateComboBox" );
	TransmitRateComboBox->insertItem( trUtf8( "Auto" ) );
	TransmitRateComboBox->insertItem( trUtf8( "1  Mbps" ) );
	TransmitRateComboBox->insertItem( trUtf8( "2  Mbps" ) );
	TransmitRateComboBox->insertItem( trUtf8( "5.5Mbps" ) );
	TransmitRateComboBox->insertItem( trUtf8( "11 Mbps" ) );
	TransmitRateComboBox->setGeometry( QRect( 400, 195, 110, 20 ) ); 

	PreambleTextLabel = new QLabel( tab, "PreambleTextLabel" );
	PreambleTextLabel->setGeometry( QRect( 20, 224, 90, 30 ) ); 
	PreambleTextLabel->setText( trUtf8( "Preamble Type" ) );
	PreambleTextLabel->setEnabled(FALSE);

	PreambleComboBox = new QComboBox( FALSE, tab, "PreambleComboBox" );
	PreambleComboBox->insertItem( trUtf8( "Long" ) );
	PreambleComboBox->insertItem( trUtf8( "Short" ) );
	PreambleComboBox->insertItem( trUtf8( "Auto" ) );
	PreambleComboBox->setGeometry( QRect( 120, 226, 130, 20 ) ); 
	PreambleComboBox->setEnabled(FALSE);

	RTSCheckBox = new QCheckBox( tab, "RTSCheckBox" );
	RTSCheckBox->setGeometry( QRect( 18, 266, 130, 20 ) ); 
	RTSCheckBox->setText( trUtf8( "RTS Threshold " ) );

	TextLabel7 = new QLabel( tab, "TextLabel7" );
	TextLabel7->setGeometry( QRect( 170, 260, 20, 20 ) ); 
	TextLabel7->setText( trUtf8( "0" ) );

	RTSSlider = new QSlider( tab, "RTSSlider" );
	RTSSlider->setEnabled( FALSE );
	RTSSlider->setGeometry( QRect( 182, 270, 200, 24 ) ); 
	RTSSlider->setMinValue( 0 );
	RTSSlider->setMaxValue( 2312 );
	RTSSlider->setLineStep( 32 );
	RTSSlider->setPageStep( 256 );
	RTSSlider->setValue( 2312 );
	RTSSlider->setOrientation( QSlider::Horizontal );

	TextLabel9 = new QLabel( tab, "TextLabel9" );
	TextLabel9->setGeometry( QRect( 385, 260, 32, 20 ) ); 
	TextLabel9->setText( trUtf8( "2312" ) );

	RTSLineEdit = new QLineEdit( tab, "RTSLineEdit" );
	RTSLineEdit->setEnabled( FALSE );
	RTSLineEdit->setGeometry( QRect( 420, 266, 50, 20 ) ); 
	RTSLineEdit->setText( trUtf8( "2312" ) );
	RTSLineEdit->setMaxLength( 4 );
	RTSLineEdit->setValidator( new QIntValidator( 0, 2312, RTSLineEdit ) );

	FragmentCheckBox = new QCheckBox( tab, "FragmentCheckBox" );
	FragmentCheckBox->setGeometry( QRect( 18, 296, 140, 30 ) ); 
	FragmentCheckBox->setText( trUtf8( "Fragment Threshold" ) );

	TextLabel8 = new QLabel( tab, "TextLabel8" );
	TextLabel8->setGeometry( QRect( 160, 290, 25, 21 ) ); 
	TextLabel8->setText( trUtf8( "256" ) );

	FragmentSlider = new QSlider( tab, "FragmentSlider" );
	FragmentSlider->setEnabled( FALSE );
	FragmentSlider->setGeometry( QRect( 183, 300, 200, 24 ) ); 
	FragmentSlider->setMinValue( 256 );
	FragmentSlider->setMaxValue( 2312 );
	FragmentSlider->setLineStep( 32 );
	FragmentSlider->setPageStep( 256 );
	FragmentSlider->setValue( 2312 );
	FragmentSlider->setOrientation( QSlider::Horizontal );

	TextLabel9_2 = new QLabel( tab, "TextLabel9_2" );
	TextLabel9_2->setGeometry( QRect( 385, 286, 32, 20 ) ); 
	TextLabel9_2->setText( trUtf8( "2312" ) );

	FragmentLineEdit = new QLineEdit( tab, "FragmentLineEdit" );
	FragmentLineEdit->setEnabled( FALSE );
	FragmentLineEdit->setGeometry( QRect( 420, 296, 50, 20 ) ); 
	FragmentLineEdit->setText( trUtf8( "2312" ) );
	FragmentLineEdit->setMaxLength( 4 );
	FragmentLineEdit->setValidator( new QIntValidator( 256, 2312, FragmentLineEdit ) );

	ChannelTextLabel = new QLabel( tab, "ChannelTextLabel" );
	ChannelTextLabel->setEnabled( FALSE );
	ChannelTextLabel->setGeometry( QRect( 488, 268, 50, 20 ) ); 
	ChannelTextLabel->setText( trUtf8( "Channel" ) );

	ChannelComboBox = new QComboBox( FALSE, tab, "ChannelComboBox" );
	ChannelComboBox->setEnabled( FALSE );
	ChannelComboBox->setGeometry( QRect( 487, 298, 60, 20 ) ); 

	int nChannelMax=11, nChannelMin=1;
	char channelString[3];
	if( CountryRegion < G_nCountryCount)
	{
		nChannelMax = CountryRegionTable[CountryRegion].nChMax;
		nChannelMin = CountryRegionTable[CountryRegion].nChMin;
	}
	for(int channelIndex=nChannelMin; channelIndex <= nChannelMax; channelIndex++)
	{
		sprintf(channelString, "%d", channelIndex);
		ChannelComboBox->insertItem(channelString);
	}	
	ChannelComboBox->setCurrentItem(0);

	ProfileTabWidget->insertTab( tab, trUtf8( "&System Configuration" ) );

	tab_2 = new QWidget( ProfileTabWidget, "tab_2" );

	ButtonGroup3 = new QButtonGroup( tab_2, "ButtonGroup3" );
	ButtonGroup3->setGeometry( QRect( 20, 16, 520, 60 ) ); 
	ButtonGroup3->setTitle( trUtf8( "Authentication Setting" ) );

	TextLabel10 = new QLabel( ButtonGroup3, "TextLabel10" );
	TextLabel10->setGeometry( QRect( 30, 18, 130, 30 ) ); 
	TextLabel10->setText( trUtf8( "Authentication Type" ) );

	AuthenticationComboBox = new QComboBox( FALSE, ButtonGroup3, "AuthenticationComboBox" );
	AuthenticationComboBox->insertItem( trUtf8( "Open System" ) );
	AuthenticationComboBox->insertItem( trUtf8( "Shared Key" ) );
	AuthenticationComboBox->setEnabled( FALSE );
	AuthenticationComboBox->setGeometry( QRect( 210, 20, 280, 20 ) ); 

	ButtonGroup4 = new QButtonGroup( tab_2, "ButtonGroup4" );
	ButtonGroup4->setGeometry( QRect( 20, 100, 520, 220 ) ); 
	ButtonGroup4->setTitle( trUtf8( "" ) );

	TextLabel11 = new QLabel( ButtonGroup4, "TextLabel11" );
	TextLabel11->setGeometry( QRect( 30, 16, 100, 20 ) ); 
	TextLabel11->setText( trUtf8( "WEP key type" ) );

	TextLabel12 = new QLabel( ButtonGroup4, "TextLabel12" );
	TextLabel12->setGeometry( QRect( 30, 40, 100, 20 ) ); 
	TextLabel12->setText( trUtf8( "WEP Key Length" ) );

	WEPKeyTypeComboBox = new QComboBox( FALSE, ButtonGroup4, "WEPKeyTypeComboBox" );
	WEPKeyTypeComboBox->insertItem( trUtf8( "Hexadecimal" ) );
	WEPKeyTypeComboBox->insertItem( trUtf8( "ASCII" ) );
	WEPKeyTypeComboBox->setEnabled( FALSE );
	WEPKeyTypeComboBox->setGeometry( QRect( 210, 10, 280, 20 ) ); 

	WEPKeyLengthComboBox = new QComboBox( FALSE, ButtonGroup4, "WEPKeyLengthComboBox" );
	WEPKeyLengthComboBox->insertItem( trUtf8( " 64 Bits" ) );
	WEPKeyLengthComboBox->insertItem( trUtf8( "128 Bits" ) );
	WEPKeyLengthComboBox->setEnabled( FALSE );
	WEPKeyLengthComboBox->setGeometry( QRect( 210, 40, 280, 20 ) ); 

	ButtonGroup5 = new QButtonGroup( ButtonGroup4, "ButtonGroup5" );
	ButtonGroup5->setGeometry( QRect( 20, 66, 480, 140 ) ); 	 
	ButtonGroup5->setTitle( trUtf8( "WEP KEY" ) );

	Key1RadioButton = new QRadioButton( ButtonGroup5, "Key1RadioButton" );
	Key1RadioButton->setEnabled( FALSE );
	Key1RadioButton->setGeometry( QRect( 30, 15, 110, 20 ) ); 
	Key1RadioButton->setText( trUtf8( "Key #1" ) );
	Key1RadioButton->setChecked( TRUE );
	ButtonGroup5->insert( Key1RadioButton, 0 );

	Key2RadioButton = new QRadioButton( ButtonGroup5, "Key2RadioButton" );
	Key2RadioButton->setEnabled( FALSE );
	Key2RadioButton->setGeometry( QRect( 30, 45, 110, 20 ) ); 
	Key2RadioButton->setText( trUtf8( "Key #2" ) );
	ButtonGroup5->insert( Key2RadioButton, 1 );

	Key3RadioButton = new QRadioButton( ButtonGroup5, "Key3RadioButton" );
	Key3RadioButton->setEnabled( FALSE );
	Key3RadioButton->setGeometry( QRect( 30, 75, 110, 20 ) ); 
	Key3RadioButton->setText( trUtf8( "Key #3" ) );
	ButtonGroup5->insert( Key3RadioButton, 2 );

	Key4RadioButton = new QRadioButton( ButtonGroup5, "Key4RadioButton" );
	Key4RadioButton->setEnabled( FALSE );
	Key4RadioButton->setGeometry( QRect( 30, 105, 110, 20 ) ); 
	Key4RadioButton->setText( trUtf8( "Key #4" ) );
	ButtonGroup5->insert( Key4RadioButton, 3 );

	Key1LineEdit = new QLineEdit( ButtonGroup5, "Key1LineEdit" );
	Key1LineEdit->setEnabled( FALSE );
	Key1LineEdit->setGeometry( QRect( 220, 15, 240, 22 ) ); 

	Key2LineEdit = new QLineEdit( ButtonGroup5, "Key2LineEdit" );
	Key2LineEdit->setEnabled( FALSE );
	Key2LineEdit->setGeometry( QRect( 220, 45, 240, 22 ) ); 

	Key3LineEdit = new QLineEdit( ButtonGroup5, "Key3LineEdit" );
	Key3LineEdit->setEnabled( FALSE );
	Key3LineEdit->setGeometry( QRect( 220, 75, 240, 22 ) ); 

	Key4LineEdit = new QLineEdit( ButtonGroup5, "Key4LineEdit" );
	Key4LineEdit->setEnabled( FALSE );
	Key4LineEdit->setGeometry( QRect( 220, 105, 240, 22 ) ); 

	EncryptionCheckBox = new QCheckBox( tab_2, "EncryptionCheckBox" );
	EncryptionCheckBox->setGeometry( QRect( 40, 90, 100, 20 ) ); 
	EncryptionCheckBox->setText( trUtf8( "Encryption" ) );
	ProfileTabWidget->insertTab( tab_2, trUtf8( "&Authentication && Security" ) );

	OkProfilePushButton = new QPushButton( this, "OkProfilePushButton" );
	OkProfilePushButton->setGeometry( QRect( 160, 430, 100, 30 ) ); 
	OkProfilePushButton->setText( trUtf8( "&OK" ) );

	CancelProfilePushButton = new QPushButton( this, "CancelProfilePushButton" );
	CancelProfilePushButton->setGeometry( QRect( 340, 430, 100, 30 ) ); 
	CancelProfilePushButton->setText( trUtf8( "&Cancel" ) );

	hexValidator = new QHexValidator(this);	
	Key1LineEdit->setValidator(hexValidator);
	Key2LineEdit->setValidator(hexValidator);
	Key3LineEdit->setValidator(hexValidator);
	Key4LineEdit->setValidator(hexValidator);

    // signals and slots connections
	connect( OkProfilePushButton, SIGNAL( clicked() ), this, SLOT( OkProfileButton_Click() ) );
	connect( CancelProfilePushButton, SIGNAL( clicked() ), this, SLOT( CancelProfileButton_Click() ) );	
	connect( NetworkComboBox, SIGNAL( activated(int) ), this, SLOT( NetworkComboBox_activated(int) ) );
	connect( RTSCheckBox, SIGNAL( toggled(bool) ), this, SLOT( RTSCheckBox_toggled(bool) ) );
	connect( RTSSlider, SIGNAL( valueChanged(int) ), this, SLOT( RTSSlider_valueChanged(int) ) );
	connect( FragmentCheckBox, SIGNAL( toggled(bool) ), this, SLOT( FragmentCheckBox_toggled(bool) ) );
	connect( FragmentSlider, SIGNAL( valueChanged(int) ), this, SLOT( FragmentSlider_valueChanged(int) ) );
	connect( EncryptionCheckBox, SIGNAL( toggled(bool) ), this, SLOT( EncryptionCheckBox_toggled(bool) ) );
	connect( WEPKeyLengthComboBox, SIGNAL( activated(int) ), this, SLOT( WEPKeyLengthComboBox_activated(int) ) );
	connect( WEPKeyTypeComboBox, SIGNAL( activated(int) ), this, SLOT( WEPKeyTypeComboBox_activated(int) ) );
	connect( RTSLineEdit, SIGNAL( lostFocus()), this, SLOT( RTSLineEdit_lostFocus()));
	connect( FragmentLineEdit, SIGNAL( lostFocus()), this, SLOT( FragmentLineEdit_lostFocus()));
	
	//Init
	Socket_Id = socket_id;
	Device_Name = (char *)malloc(strlen(device_name)+1);
	if(Device_Name)
		strcpy(Device_Name, device_name);

	ProfileListView = pListView;
	ULONG lBufLen = sizeof(NDIS_802_11_BSSID_LIST) + sizeof(NDIS_WLAN_BSSID) * 19;	
	m_pBssidList = (PNDIS_802_11_BSSID_LIST) malloc(lBufLen);
	AddForm_Type = type;
	if(type == PROFILE_EDIT)
	{
		//Initial.
		char tmp[40];
		int  found=FALSE;
		QListViewItem *Item=ProfileListView->currentItem();
		QString str=Item->text(0);		
		PRT_PROFILE_SETTING  ptr;
		ptr = RTMPProfile;
		while(ptr!=NULL)
		{
			DBGPRINT(RT_DEBUG_TRACE, (">> find %s in %s", str.data(), (const char *)ptr->Profile));	
			if(str.compare((const char *)ptr->Profile) == 0)
			{		
				found = TRUE;
				ProfileSetting = ptr;
				ProfileLineEdit->setText((const char *)ptr->Profile);
				SsidComboBox->insertItem((const char *)ptr->SSID);
				PowerSaveButtonGroup->setButton(ptr->PSmode);
				ButtonGroup2->setButton(ptr->AntennaTx);
				ButtonGroup6->setButton(ptr->AntennaRx);
				NetworkComboBox->setCurrentItem(ptr->NetworkType);
				PreambleComboBox->setCurrentItem(ptr->PreamType);
				TransmitRateComboBox->setCurrentItem(ptr->TransRate);
				//				TrasmitPowerComboBox->setCurrentItem(ptr->TransPower);
				AuthenticationComboBox->setCurrentItem(ptr->Authentication);
				WEPKeyLengthComboBox->setCurrentItem(ptr->KeyLength);
				WEPKeyTypeComboBox->setCurrentItem(ptr->KeyType);				
				ButtonGroup5->setButton(ptr->KeyIndex);				
				sprintf(tmp, "%d", ptr->RTS);				
				RTSLineEdit->setText(tmp);				
				RTSSlider->setValue( ptr->RTS );				
				sprintf(tmp, "%d", ptr->Fragment);				
				FragmentLineEdit->setText(tmp);				
				FragmentSlider->setValue(ptr->Fragment);				
				EncryptionCheckBox->setChecked(ptr->Encryption);								
				RTSCheckBox->setChecked(ptr->RTSCheck);					
				FragmentCheckBox->setChecked(ptr->FragmentCheck);				
				if(ptr->NetworkType == Ndis802_11IBSS)
				{
					ChannelTextLabel->setEnabled( TRUE );
					ChannelComboBox->setEnabled( TRUE );					
				}				
				Key1LineEdit->setText((const char *)ptr->Key1);
				Key2LineEdit->setText((const char *)ptr->Key2);
				Key3LineEdit->setText((const char *)ptr->Key3);
				Key4LineEdit->setText((const char *)ptr->Key4);				
			}
			ptr=ptr->Next;
		} 
		if(!found)
		{
			//Not found. not happens.
			QMessageBox::warning(this, "Warning", "Edit Profile failed, try again!");		
			close();
		}
	}
	else
	{ //Add Profile
		PRT_PROFILE_SETTING  ptr;
		char tmp[40];
		int nProfIndex = 0;
		int nTemp;

		ptr = RTMPProfile;
		while(ptr!=NULL)
		{
			strcpy(tmp, (const char *)ptr->Profile);
			for(unsigned int i=0; i<strlen(tmp); i++)
				tmp[i] = toupper(tmp[i]);

			if(strncmp(tmp, "PROF", 4) == 0)
			{
				nTemp=atoi(tmp+4);
				nProfIndex = (nTemp > nProfIndex)? nTemp : nProfIndex;
			}
			ptr=ptr->Next;
		}
		sprintf(tmp, "PROF%d", nProfIndex+1);
		ProfileLineEdit->setText(tmp);

		GetAllSSIDName();
		if(BSSIDName != 0x00)
		{
			NDIS_802_11_MAC_ADDRESS tmpBssid;
			QString strBssid;
			int j = 0;

			strBssid = BSSIDName;
			while ( ( j = strBssid.find( '-', j ) ) != -1 )
				strBssid.remove( j ,1 );

			DBGPRINT(RT_DEBUG_TRACE, ("AddForm [BSSID=%s]", strBssid.ascii()));
			AtoH((char *)strBssid.ascii(), tmpBssid, 6);

			NDIS_WLAN_BSSID* Bssid = m_pBssidList->Bssid;	
			for(unsigned int i = 0; i < m_pBssidList->NumberOfItems; i++)
			{
				sprintf(tmp, "%s", Bssid->Ssid.Ssid);
				//tmp[Bssid->Ssid.SsidLength] = 0x00;

				if(memcmp(tmpBssid, Bssid->MacAddress, 6) == 0)
				{
					SsidComboBox->setCurrentItem(i);
					if(Bssid->InfrastructureMode == Ndis802_11Infrastructure)
						NetworkComboBox->setCurrentItem(Ndis802_11Infrastructure);
					else if(Bssid->InfrastructureMode == Ndis802_11IBSS)
						NetworkComboBox->setCurrentItem(Ndis802_11IBSS);					
					
					if(Bssid->Privacy)
					{
						EncryptionCheckBox->setChecked(TRUE);
						//EncryptionCheckBox_toggled(TRUE);
						if(Bssid->InfrastructureMode == Ndis802_11IBSS)
						{
							AuthenticationComboBox->setCurrentItem(0); //Open System.
							AuthenticationComboBox->setEnabled(FALSE);							
						}
						else if(Bssid->InfrastructureMode == Ndis802_11Infrastructure)
						{
							AuthenticationComboBox->setCurrentItem(1); //Shared key.
							AuthenticationComboBox->setEnabled(TRUE);
						}
					}

					int nChannel = 1;
					if (Bssid->Configuration.DSConfig == 2484000)
						nChannel = 14;
					else if (Bssid->Configuration.DSConfig >= 2412000 && Bssid->Configuration.DSConfig < 2484000) 
						nChannel = (int)((Bssid->Configuration.DSConfig - 2412000) / 5000) + 1;
					ChannelComboBox->setCurrentItem(nChannel-1);					
					break;
				}
				// Get next Bssid struct
				Bssid++;			
			}
		}
	}

	if(WEPKeyTypeComboBox->currentItem() == 0)
	{//hex
		if(WEPKeyLengthComboBox->currentItem() == 0)
		{//40bits
			Key1LineEdit->setMaxLength(10);		
			Key2LineEdit->setMaxLength(10);		
			Key3LineEdit->setMaxLength(10);		
			Key4LineEdit->setMaxLength(10);		
		}
		else
		{
			Key1LineEdit->setMaxLength(26);		
			Key2LineEdit->setMaxLength(26);		
			Key3LineEdit->setMaxLength(26);		
			Key4LineEdit->setMaxLength(26);		
		}
	}
	else
	{
		if(WEPKeyLengthComboBox->currentItem() == 0)
		{//40bits
			Key1LineEdit->setMaxLength(5);		
			Key2LineEdit->setMaxLength(5);		
			Key3LineEdit->setMaxLength(5);		
			Key4LineEdit->setMaxLength(5);		
		}
		else
		{
			Key1LineEdit->setMaxLength(13);		
			Key2LineEdit->setMaxLength(13);		
			Key3LineEdit->setMaxLength(13);		
			Key4LineEdit->setMaxLength(13);		
		}
	}		
	if(NetworkComboBox->currentItem() == 0)
	{//Ad-hoc.
		ChannelComboBox->show();
		ChannelTextLabel->show();	

		ChannelComboBox->setEnabled( TRUE );
		ChannelTextLabel->setEnabled( TRUE );
		CAMRadioButton->setEnabled(FALSE);
		Fast_PSPRadioButton->setEnabled(FALSE);
		Max_PSPRadioButton->setEnabled(FALSE);
		PreambleComboBox->setEnabled(TRUE);
		PreambleTextLabel->setEnabled(TRUE);
	}
	else
	{//Infrastructure.
		ChannelComboBox->hide();
		ChannelTextLabel->hide();

		ChannelComboBox->setEnabled( FALSE );
		ChannelTextLabel->setEnabled( FALSE );
		CAMRadioButton->setEnabled(TRUE);
		Fast_PSPRadioButton->setEnabled(TRUE);
		Max_PSPRadioButton->setEnabled(TRUE);
		PreambleComboBox->setEnabled(FALSE);
		PreambleTextLabel->setEnabled(FALSE);
	}

	IsAddToProfile = FALSE;
}

/*  
 *  Destroys the object and frees any allocated resources
 */
AddForm::~AddForm()
{
    // no need to delete child widgets, Qt does it all for us
}

void AddForm::CancelProfileButton_Click()
{
    close();
}

void AddForm::GetAllSSIDName()
{
	ULONG		i;
	char   tmp[40];	

	Get_OID_802_11_BSSID_LIST(Socket_Id, Device_Name, m_pBssidList);
	NDIS_WLAN_BSSID* Bssid = m_pBssidList->Bssid;
	
	SsidComboBox->clear();

	for(i = 0; i < m_pBssidList->NumberOfItems; i++)
	{

		sprintf(tmp, "%s", Bssid->Ssid.Ssid);
		tmp[Bssid->Ssid.SsidLength] = 0x00;
		SsidComboBox->insertItem(tmp);
	
		// Get next Bssid struct
		Bssid++;
	}
	if(m_pBssidList->NumberOfItems > 0)
		SsidComboBox->setCurrentItem(0);
}

void AddForm::NetworkComboBox_activated(int index)
{
	if(index == 0)
	{//Ad-hoc mode.
		ChannelTextLabel->show();
		ChannelComboBox->show();

		ChannelComboBox->setEnabled( TRUE );
		ChannelTextLabel->setEnabled( TRUE );
		CAMRadioButton->setEnabled(FALSE);
		Fast_PSPRadioButton->setEnabled(FALSE);
		Max_PSPRadioButton->setEnabled(FALSE);
		PreambleComboBox->setEnabled(TRUE);
		PreambleTextLabel->setEnabled(TRUE);
	}
	else
	{//infrastructure.
		ChannelComboBox->hide();
		ChannelTextLabel->hide();

		ChannelComboBox->setEnabled( FALSE );
		ChannelTextLabel->setEnabled( FALSE );
		CAMRadioButton->setEnabled(TRUE);
		Fast_PSPRadioButton->setEnabled(TRUE);
		Max_PSPRadioButton->setEnabled(TRUE);
		PreambleComboBox->setEnabled(FALSE);
		PreambleTextLabel->setEnabled(FALSE);
	}
}

void AddForm::RTSCheckBox_toggled(bool flag)
{
	if(flag)
	{
		RTSSlider->setEnabled( TRUE );
		RTSLineEdit->setEnabled( TRUE );
	}
	else
	{
		RTSSlider->setValue( 2312 );
		RTSSlider->setEnabled( FALSE );
		RTSLineEdit->setEnabled( FALSE );
	}

}

void AddForm::FragmentCheckBox_toggled(bool flag)
{
	if(flag)
	{
		FragmentSlider->setEnabled( TRUE );
		FragmentLineEdit->setEnabled( TRUE );
	}
	else
	{
		FragmentSlider->setValue( 2312 );
		FragmentSlider->setEnabled( FALSE );
		FragmentLineEdit->setEnabled( FALSE );		
	}
}

void AddForm::FragmentSlider_valueChanged(int value)
{
	char tmp[40];

	sprintf(tmp, "%d", value);
	FragmentLineEdit->setText(tmp);
}

void AddForm::RTSSlider_valueChanged(int value)
{
	char tmp[40];

	sprintf(tmp, "%d", value);
	RTSLineEdit->setText(tmp);
}

void AddForm::EncryptionCheckBox_toggled(bool flag)
{
	if(flag)
	{
		AuthenticationComboBox->setEnabled( TRUE );
		WEPKeyTypeComboBox->setEnabled( TRUE );
		WEPKeyLengthComboBox->setEnabled( TRUE );
		Key1RadioButton->setEnabled( TRUE );
		Key2RadioButton->setEnabled( TRUE );
		Key3RadioButton->setEnabled( TRUE );
		Key4RadioButton->setEnabled( TRUE );
		Key1LineEdit->setEnabled( TRUE );
		Key2LineEdit->setEnabled( TRUE );
		Key3LineEdit->setEnabled( TRUE );
		Key4LineEdit->setEnabled( TRUE );
	}
	else
	{
		AuthenticationComboBox->setCurrentItem(0); //Open System.
		AuthenticationComboBox->setEnabled( FALSE );
		WEPKeyTypeComboBox->setEnabled( FALSE );
		WEPKeyLengthComboBox->setEnabled( FALSE );
		Key1RadioButton->setEnabled( FALSE );
		Key2RadioButton->setEnabled( FALSE );
		Key3RadioButton->setEnabled( FALSE );
		Key4RadioButton->setEnabled( FALSE );
		Key1LineEdit->setEnabled( FALSE );
		Key2LineEdit->setEnabled( FALSE );
		Key3LineEdit->setEnabled( FALSE );
		Key4LineEdit->setEnabled( FALSE );
	}
}

void AddForm::OkProfileButton_Click()
{
	//QListView* ProfileListView;
	QListViewItem *Item;
	QString str;	
	PRT_PROFILE_SETTING  ptr;
	PRT_PROFILE_SETTING  previous=NULL;
	int		found=FALSE;
	unsigned int     length;
	//RTMPProfile


	DBGPRINT(RT_DEBUG_TRACE, ("OkProfileButton_Click()"));

	if(EncryptionCheckBox->isChecked())
	{
		if(WEPKeyTypeComboBox->currentItem() == 0)
		{//hex
			if(WEPKeyLengthComboBox->currentItem() == 0) 
				length=10; //40bits
			else
				length=26;
		}
		else
		{
			if(WEPKeyLengthComboBox->currentItem() == 0) 
				length=5; //40bits
			else
				length=13;
		}

		switch(ButtonGroup5->id(ButtonGroup5->selected()))
		{
			case 0:
					str=Key1LineEdit->text();
					if(str.length() != length)
					{
						QMessageBox::warning(this, "Warning", "KEY#1: Invalid WEP key length!");
						ProfileTabWidget->setCurrentPage(1);
						return;
					}
					break;
			case 1:
					str=Key2LineEdit->text();
					if(str.length() != length)
					{
						QMessageBox::warning(this, "Warning", "KEY#2: Invalid WEP key length!");
						ProfileTabWidget->setCurrentPage(1);
						return;
					}
					break;
			case 2: 
					str=Key3LineEdit->text();
					if(str.length() != length)
					{
						QMessageBox::warning(this, "Warning", "KEY#3: Invalid WEP key length!");
						ProfileTabWidget->setCurrentPage(1);
						return;
					}
					break;
			case 3:
					str=Key4LineEdit->text();
					if(str.length() != length)
					{
						QMessageBox::warning(this, "Warning", "KEY#4: Invalid WEP key length!");
						ProfileTabWidget->setCurrentPage(1);
						return;
					}
					break;
			default :
				    break;
		}
	}	
	
	str=ProfileLineEdit->text();
	if(str.length() == 0)
	{
		QMessageBox::warning(this, "Warning", "Profile name can't be empty!");
		return;
	}
	
	str = SsidComboBox->currentText();
	if( (NetworkComboBox->currentItem() == 0) && (str.length() == 0))
	{
		QMessageBox::warning(this, "Warning", "Ad Hoc mode must input SSID!");
		return;
	}

	str=ProfileLineEdit->text();
	if(AddForm_Type == PROFILE_ADD)
	{
		ptr = RTMPProfile;
		if(RTMPProfile != NULL)
		{
			while(ptr!=NULL)
			{
				if(str.compare((const char *)ptr->Profile) == 0)
				{
					found = TRUE;
					break;
				}
				previous = ptr;
				ptr=ptr->Next;
			}

			if(!found)
			{

				ProfileSetting = (PRT_PROFILE_SETTING) malloc(sizeof(RT_PROFILE_SETTING));
				memset(ProfileSetting, 0x00, sizeof(RT_PROFILE_SETTING));
				previous->Next = ProfileSetting;
				ProfileSetting->Next = NULL;
				strcpy((char *)ProfileSetting->Profile, str.data());		
			}
			else
			{
				ProfileSetting = ptr;
			}
		}
		else
		{
			RTMPProfile = (PRT_PROFILE_SETTING) malloc(sizeof(RT_PROFILE_SETTING));
			memset(RTMPProfile, 0x00, sizeof(RT_PROFILE_SETTING));		
			ProfileSetting = RTMPProfile;
			strcpy((char *)ProfileSetting->Profile, str.data());		
			ProfileSetting->Next = NULL;
		}	
	}
	else
	{ //Edit profile, check does it Duplicate profile name?
		ptr = RTMPProfile;
		while(ptr!=NULL)
		{
			if( (str.compare((const char *)ptr->Profile) == 0) && (ptr!=ProfileSetting))
			{
				found = TRUE;
				break;
			}
			previous = ptr;
			ptr=ptr->Next;
		}
	}

	if(found)
	{
		QMessageBox::warning(this, "Warning", "Duplicate profile name.!");
		return;	
	}


	if(AddForm_Type == PROFILE_ADD)
	{
		Item = new QListViewItem(ProfileListView, 0);
		str = ProfileLineEdit->text();
		Item->setText(0, str);		
		Item->setPixmap(0, uic_load_pixmap_AddForm("uncheck16.xpm"));		
	}
	else
	{
		Item =  ProfileListView->findItem((const char *) ProfileSetting->Profile, 0);
		strcpy((char *)ProfileSetting->Profile, str.data());		
		Item->setText(0, str);		
	}

	//SSID
	str = SsidComboBox->currentText();			
	ProfileSetting ->SsidLen = str.length() <= 32 ? str.length() : 32;	
	strncpy((char *)ProfileSetting->SSID, str.data(), ProfileSetting ->SsidLen);
	Item->setText(1, (char *)ProfileSetting->SSID);
	//NetworkType
	ProfileSetting->NetworkType = NetworkComboBox->currentItem(); //0: ADHOC  1: Infrastructure
	//Channel
	if(ProfileSetting->NetworkType == 0)
		ProfileSetting->Channel = ChannelComboBox->currentItem() +1;
	else
		ProfileSetting->Channel = 0;  // 0: Auto.
	Item->setText(2, (NetworkComboBox->currentItem()==0 ? (const char *)ChannelComboBox->currentText():"Auto"));
	//Authentication
	ProfileSetting->Authentication = AuthenticationComboBox->currentItem();  //0:Open System  1:Share Key
	Item->setText(3, (AuthenticationComboBox->currentItem()==0 ? "Open System":"Shared key") );
	//Encryption	
	ProfileSetting->Encryption = EncryptionCheckBox->isChecked();
	Item->setText(4, (EncryptionCheckBox->isChecked()? "WEP":"Not Use") );	
	ProfileSetting->NetworkType = NetworkComboBox->currentItem();
	
	Item->setText(5, strAryNetworkType[NetworkComboBox->currentItem()]);
	//KeyIndex
	ProfileSetting->KeyIndex = ButtonGroup5->id(ButtonGroup5->selected());
	//KeyLength
	ProfileSetting->KeyLength = WEPKeyLengthComboBox->currentItem(); //0: 64 1:128
	//KeyType
	ProfileSetting->KeyType = WEPKeyTypeComboBox->currentItem(); //0: Hex  1:Ascii
	//Key1
	str = Key1LineEdit->text();
	strcpy((char *)ProfileSetting->Key1, str.data());	
	//Key2
	str = Key2LineEdit->text();
	strcpy((char *)ProfileSetting->Key2, str.data());	
	//Key3
	str = Key3LineEdit->text();
	strcpy((char *)ProfileSetting->Key3, str.data());	
	//Key4
	str = Key4LineEdit->text();
	strcpy((char *)ProfileSetting->Key4, str.data());	
	//Trans Rate
	ProfileSetting->TransRate = TransmitRateComboBox->currentItem();
	//Fragment
	str = FragmentLineEdit->text();
	ProfileSetting->Fragment = str.toUInt();
	//RTS
	str = RTSLineEdit->text();
	ProfileSetting->RTS = str.toUInt();
	//PSmode;
	ProfileSetting->PSmode = PowerSaveButtonGroup->id(PowerSaveButtonGroup->selected());
	//PreamType
	ProfileSetting->PreamType = PreambleComboBox->currentItem();
	//AntennaTx
	ProfileSetting->AntennaTx = ButtonGroup2->id(ButtonGroup2->selected());
	//AntennaRx
	ProfileSetting->AntennaRx = ButtonGroup6->id(ButtonGroup6->selected());
	//RTS Checkbox
	ProfileSetting->RTSCheck = RTSCheckBox->isChecked();
	//Fragment Checkbox
	ProfileSetting->FragmentCheck = FragmentCheckBox->isChecked();
	ProfileListView->setCurrentItem(Item);
	IsAddToProfile = TRUE;
	close();
}	

void AddForm::WEPKeyLengthComboBox_activated(int id)
{
	if(id == 0) 
	{//40		
		if(WEPKeyTypeComboBox->currentItem() == 0)
		{//hex
			Key1LineEdit->setMaxLength(10);
			Key2LineEdit->setMaxLength(10);
			Key3LineEdit->setMaxLength(10);
			Key4LineEdit->setMaxLength(10);
		}
		else
		{
			Key1LineEdit->setMaxLength(5);
			Key2LineEdit->setMaxLength(5);
			Key3LineEdit->setMaxLength(5);
			Key4LineEdit->setMaxLength(5);
		}
	}
	else
	{
		if(WEPKeyTypeComboBox->currentItem() == 0)
		{//hex
			Key1LineEdit->setMaxLength(26);
			Key2LineEdit->setMaxLength(26);
			Key3LineEdit->setMaxLength(26);
			Key4LineEdit->setMaxLength(26);
		}
		else
		{
			Key1LineEdit->setMaxLength(13);
			Key2LineEdit->setMaxLength(13);
			Key3LineEdit->setMaxLength(13);
			Key4LineEdit->setMaxLength(13);
		}
	}
}

void AddForm::WEPKeyTypeComboBox_activated(int id)
{

	if(id==0) 
	{//Hex		
		Key1LineEdit->setValidator(hexValidator);
		Key2LineEdit->setValidator(hexValidator);
		Key3LineEdit->setValidator(hexValidator);
		Key4LineEdit->setValidator(hexValidator);
		if(WEPKeyLengthComboBox->currentItem()==0)
		{//40
			Key1LineEdit->setMaxLength(10);
			Key2LineEdit->setMaxLength(10);
			Key3LineEdit->setMaxLength(10);
			Key4LineEdit->setMaxLength(10);
		}
		else
		{
			Key1LineEdit->setMaxLength(26);
			Key2LineEdit->setMaxLength(26);
			Key3LineEdit->setMaxLength(26);
			Key4LineEdit->setMaxLength(26);
		}
	}
	else
	{
		Key1LineEdit->clearValidator();
		Key2LineEdit->clearValidator();
		Key3LineEdit->clearValidator();
		Key4LineEdit->clearValidator();
		if(WEPKeyLengthComboBox->currentItem()==0)
		{
			Key1LineEdit->setMaxLength(5);
			Key2LineEdit->setMaxLength(5);
			Key3LineEdit->setMaxLength(5);
			Key4LineEdit->setMaxLength(5);
		}
		else
		{
			Key1LineEdit->setMaxLength(13);
			Key2LineEdit->setMaxLength(13);
			Key3LineEdit->setMaxLength(13);
			Key4LineEdit->setMaxLength(13);
		}
	}
	Key1LineEdit->clear();
	Key2LineEdit->clear();
	Key3LineEdit->clear();
	Key4LineEdit->clear();
}

bool AddForm::m_IsAddToProfile()
{

	return (IsAddToProfile);
}

void AddForm::FragmentLineEdit_lostFocus()
{
	QString str;
	
	str = FragmentLineEdit->text();
	if(str.isNull() || (str.toInt() <= 256))
	{
		FragmentLineEdit->setText("256");
		FragmentSlider->setValue(256);
	}
	else if(str.toInt() >= 2312)
	{
		FragmentLineEdit->setText("2312");
		FragmentSlider->setValue(2312);
	}
	else
		FragmentSlider->setValue(str.toInt());	
}

void AddForm::RTSLineEdit_lostFocus()
{
	QString str;
	
	str = RTSLineEdit->text();
	if(str.isNull() || (str.toInt() <= 0))
	{
		RTSLineEdit->setText("0");
		RTSSlider->setValue(0);
	}
	else if(str.toInt() >= 2312)
	{
		RTSLineEdit->setText("2312");
		RTSSlider->setValue(2312);
	}
	else
		RTSSlider->setValue(str.toInt());	
}


