/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: raconfigform.cpp 
 *              
 *      Abstract: Raconfig main UI 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      PaulL           22nd Jan 02     Created
 *      MarkW           9th  Feb 04     Baseline of code
 *      MarkW           22nd Feb 04     Added errno.h include
 *      Mike Skinner    22nd Feb 04     Rolled in main form GUI changes
 *      MarkW           22nd Feb 04     Minor GUI tweaks
 *      Ivo van Doorn   17th May 04     Updates to QT styles
 *      Ivo van Doorn   19th May 04     Cleanup of GUI sizings 
 *      MarkW		3rd  Oct 04	Fixed profile file permissions
 ***************************************************************************/ 


#include "raconfigform.h"
#include "addform.h"
#include "sitewepdlg.h"
#include "rt_tool.h"
#include "configapi.h"

#include <qvariant.h>
#include <qapplication.h>
#include <qgroupbox.h>
#include <qheader.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qprogressbar.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qmime.h>
#include <qdragobject.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qtextedit.h>

#include <qmessagebox.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/wireless.h>
#include <unistd.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/stat.h>

extern char Configfile_name[255];
extern int errno;
extern UCHAR CountryRegion;

char  *strAryNetworkType[3] = { "Ad Hoc", "Infrastructure", "Automatic" };

static QPixmap uic_load_pixmap_RaConfigForm( const QString &name )
{
	const QMimeSource *m = QMimeSourceFactory::defaultFactory()->data( name );
	
	if ( !m )
		return QPixmap();
	QPixmap pix;
	QImageDrag::decode( m, pix );
	return pix;
}

// most likely OID_802_11_RSSI ranged from -20 to -100 dbm
//  -40 dBm (100%) ------- -80 dBm (20%) ------- -84 dBm (0%)
//
unsigned int  ConvertRssiToSignalQuality(int RSSI)
{
	unsigned int signal_quality;
	if (RSSI >= -40 )
		signal_quality = 100;
	else if (RSSI >= -80)    // between -40 ~ -80dbm
		signal_quality = 20 + (RSSI + 80) * 2;   
	else if (RSSI >= -84 )   // between -80 ~ -84dbm
		signal_quality = (RSSI + 84) * 5;   
	else    // < -84 dbm
		signal_quality = 0;
	
	return signal_quality;
}



/* 
 *  Constructs a RaConfigForm which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
RaConfigForm::RaConfigForm( int socket_id, const char *device_name, QWidget *parent, const char *name)
	: QWidget( parent, name )
	{
	if ( !name )
		setName( "RaConfigForm" );
	resize( 600, 520 ); 
	setMinimumSize(600, 520);
	setMaximumSize(600, 520);	 
	setCaption( trUtf8( "rt2400 Wireless Configuration Utility" ) );
	setIcon( uic_load_pixmap_RaConfigForm( "raconfig.xpm" ) );	
	setPaletteBackgroundColor( QColor( 222, 222,  222 ) );
	
	// qApp->setStyle("Keramik");
	
	TabWidget3 = new QTabWidget( this, "TabWidget3" );
	TabWidget3->setGeometry( QRect( 20, 20, 560, 440 ) ); 
	TabWidget3->setPaletteBackgroundColor( QColor( 222, 222,  222 ) );
	
	tab_3 = new QWidget( TabWidget3, "tab_3" );
	
	GroupBox1 = new QGroupBox( tab_3, "GroupBox1" );
	GroupBox1->setGeometry( QRect( 8, 16, 540, 370 ) ); 
	GroupBox1->setTitle( trUtf8( "Profiles" ) );
	
	ProfileListView = new QListView( GroupBox1, "ProfileListView" );
	ProfileListView->addColumn( trUtf8( "Profile             " ) );
	ProfileListView->addColumn( trUtf8( "SSID                      " ) );
	ProfileListView->addColumn( trUtf8( "Channel" ) );
	ProfileListView->addColumn( trUtf8( "Authentication       " ) );
	ProfileListView->addColumn( trUtf8( "Encryption " ) );
	ProfileListView->addColumn( trUtf8( "Network Type      " ) );
	ProfileListView->setSelectionMode( QListView::Single );
	ProfileListView->setAllColumnsShowFocus( TRUE );
	ProfileListView->setGeometry( QRect( 10, 20, 521, 290 ) ); 
	
	AddPushButton = new QPushButton( GroupBox1, "AddPushButton" );
	AddPushButton->setGeometry( QRect( 40, 320, 100, 30 ) ); 
	AddPushButton->setText( trUtf8( "&Add" ) );
	
	DeletePushButton = new QPushButton( GroupBox1, "DeletePushButton" );
	DeletePushButton->setGeometry( QRect( 160, 320, 100, 30 ) ); 
	DeletePushButton->setText( trUtf8( "&Delete" ) );    
	
	EditPushButton = new QPushButton( GroupBox1, "EditPushButton" );
	EditPushButton->setGeometry( QRect( 280, 320, 100, 30 ) ); 
	EditPushButton->setText( trUtf8( "&Edit" ) );
	
	ActivePushButton = new QPushButton( GroupBox1, "ActivePushButton" );
	ActivePushButton->setGeometry( QRect( 400, 320, 100, 30 ) ); 
	ActivePushButton->setText( trUtf8( "A&ctive" ) );
	
	TabWidget3->insertTab( tab_3, trUtf8( "&Profiles" ) );
	
	tab_2 = new QWidget( TabWidget3, "tab_2" );
	
	TextLabel1 = new QLabel( tab_2, "TextLabel1" );
	TextLabel1->setGeometry( QRect( 20, 10, 150, 30 ) ); 
	TextLabel1->setText( trUtf8( "Connected To :" ) );
	
	TextLabel2 = new QLabel( tab_2, "TextLabel2" );
	TextLabel2->setGeometry( QRect( 20, 50, 150, 30 ) ); 
	TextLabel2->setText( trUtf8( "Current Channel & Frequency :" ) );
	
	TextLabel3 = new QLabel( tab_2, "TextLabel3" );
	TextLabel3->setGeometry( QRect( 20, 90, 150, 30 ) ); 
	TextLabel3->setText( trUtf8( "Current Tx Rate :" ) );

	StatusTextLabel = new QLabel( tab_2, "StatusTextLabel" );
	StatusTextLabel->setGeometry( QRect( 190, 10, 350, 30 ) ); 
	StatusTextLabel->setText( trUtf8( "" ) );
	
	ChannelTextLabel = new QLabel( tab_2, "ChannelTextLabel" );
	ChannelTextLabel->setGeometry( QRect( 190, 50, 350, 30 ) ); 
	
	RateTextLabel = new QLabel( tab_2, "RateTextLabel" );
	RateTextLabel->setGeometry( QRect( 190, 90, 350, 30 ) ); 

	TextLabel4 = new QLabel( tab_2, "TextLabel4" );
	TextLabel4->setGeometry( QRect( 20, 150, 150, 30 ) ); 
	TextLabel4->setText( trUtf8( "Current Throughput / Second :" ) );
	
	TextLabel4_2_2 = new QLabel( tab_2, "TextLabel4_2_2" );
	TextLabel4_2_2->setGeometry( QRect( 190, 150, 70, 30 ) ); 
	TextLabel4_2_2->setText( trUtf8( "Receiving :" ) );
	
	TextLabel4_2 = new QLabel( tab_2, "TextLabel4_2" );
	TextLabel4_2->setGeometry( QRect( 190, 190, 70, 30 ) ); 
	TextLabel4_2->setText( trUtf8( "Sending :" ) );

	RxTextLabel = new QLabel( tab_2, "RxTextLabel" );
	RxTextLabel->setGeometry( QRect( 265, 150, 100, 30 ) ); 
	RxTextLabel->setFrameShape( QLabel::LineEditPanel );
	RxTextLabel->setFrameShadow( QLabel::Sunken );
	RxTextLabel->setPaletteBackgroundColor( QColor( 200, 200, 200 ) );	

	TxTextLabel = new QLabel( tab_2, "TxTextLabel" );
	TxTextLabel->setGeometry( QRect( 265, 190, 100, 30 ) ); 
	TxTextLabel->setFrameShape( QLabel::LineEditPanel );
	TxTextLabel->setFrameShadow( QLabel::Sunken );
	TxTextLabel->setPaletteBackgroundColor( QColor( 200, 200, 200 ) );	

	TextLabel6 = new QLabel( tab_2, "TextLabel6" );
	TextLabel6->setGeometry( QRect( 20, 250, 100, 20 ) ); 
	TextLabel6->setText( trUtf8( "Link Quality :" ) );

	TextLabel7_1 = new QLabel( tab_2, "TextLabel7_1" );
	TextLabel7_1->setGeometry( QRect( 20, 320, 100, 20 ) ); 
	TextLabel7_1->setText( trUtf8( "Signal Strength :" ) );

	TextLabel15 = new QLabel( tab_2, "TextLabel15" );
	TextLabel15->setGeometry( QRect( 140, 250, 160, 20 ) ); 
	TextLabel15->setText( trUtf8( " " ) );
	
	TextLabel16 = new QLabel( tab_2, "TextLabel16" );
	TextLabel16->setGeometry( QRect( 140, 320, 160, 20 ) ); 
	TextLabel16->setText( trUtf8( " " ) );

	LinkProgressBar = new QProgressBar(tab_2, "LinkProgressBar" );
	LinkProgressBar->setGeometry( QRect( 20, 270, 400, 30 ) ); 
	
	SignalProgressBar = new QProgressBar(tab_2, "SignalProgressBar" );
	SignalProgressBar->setGeometry( QRect( 20, 340, 400, 30 ) ); 
	

	TabWidget3->insertTab( tab_2, trUtf8( "&Link Status" ) );
	tab = new QWidget( TabWidget3, "tab" );
	
	NetworkListView = new QListView( tab, "NetworkListView" );
	NetworkListView->addColumn( trUtf8( "SSID                       " ) );
	NetworkListView->addColumn( trUtf8( "BSSID                         " ) );
	NetworkListView->addColumn( trUtf8( "Signal " ) );
	NetworkListView->addColumn( trUtf8( "Channel " ) );
	NetworkListView->addColumn( trUtf8( "Encryption " ) );
	NetworkListView->addColumn( trUtf8( "Network Type " ) );
	NetworkListView->setGeometry( QRect( 18, 16, 520, 310 ) ); 
	NetworkListView->setSelectionMode( QListView::Single );
	NetworkListView->setAllColumnsShowFocus( TRUE ); 
	
	RadioTextLabel = new QLabel( tab, "RadioTextLabel" );
	RadioTextLabel->setText( trUtf8( " Test " ) );
	RadioTextLabel->setGeometry( QRect( 20, 360, 30, 30 ) ); 
	RadioTextLabel->setPixmap( uic_load_pixmap_RaConfigForm( "radioon.png" ) );
	
	RadioPushButton = new QPushButton( tab, "RadioPushButton" );
	RadioPushButton->setGeometry( QRect( 50, 360, 70, 30 ) ); 
	RadioPushButton->setText( trUtf8( "Radio &Off" ) );
	
	
	LineEdit1 = new QLineEdit( tab, "LineEdit1" );
	LineEdit1->setEnabled( FALSE );
	LineEdit1->setPaletteForegroundColor( QColor( 0, 0, 0 ) );
	LineEdit1->setGeometry( QRect( 20, 328, 520, 20 ) ); 
	
	RescanPushButton = new QPushButton( tab, "RescanPushButton" );
	RescanPushButton->setGeometry( QRect( 320, 360, 70, 30 ) ); 
	RescanPushButton->setText( trUtf8( "&Rescan" ) );
	
	ConnectPushButton = new QPushButton( tab, "ConnectPushButton" );
	ConnectPushButton->setGeometry( QRect( 395, 360, 70, 30 ) ); 
	ConnectPushButton->setText( trUtf8( "&Connect" ) );
	
	AddToProfilePushButton = new QPushButton( tab, "AddToProfilePushButton" );
	AddToProfilePushButton->setGeometry( QRect( 470, 360, 70, 30 ) ); 
	AddToProfilePushButton->setText( trUtf8( "&Add Profile" ) );
	
	TabWidget3->insertTab( tab, trUtf8( "&Site Survey" ) );
	
	tab_4 = new QWidget( TabWidget3, "tab_4" );
	
	GroupBox3 = new QGroupBox( tab_4, "GroupBox3" );
	GroupBox3->setGeometry( QRect( 20, 210, 511, 130 ) ); 
	GroupBox3->setTitle( trUtf8( "Received Frames Statistics" ) );
	
	ST_TextLabel8 = new QLabel( GroupBox3, "ST_TextLabel8" );
	ST_TextLabel8->setGeometry( QRect( 16, 45, 231, 21 ) ); 
	ST_TextLabel8->setText( trUtf8( "Frames Received With CRC Error" ) );


	ST_TextLabel9 = new QLabel( GroupBox3, "ST_TextLabel9" );
	ST_TextLabel9->setGeometry( QRect( 16, 70, 241, 21 ) ); 
	ST_TextLabel9->setText( trUtf8( "Frames Dropped Due To Out-of-Resource" ) );
	
	RcvSucFrameLabel = new QLabel( GroupBox3, "RcvSucFrameLabel" );
	RcvSucFrameLabel->setGeometry( QRect( 380, 20, 100, 20 ) ); 
	RcvSucFrameLabel->setText( trUtf8( "0" ) );
	RcvSucFrameLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	
	RcvCRCErrLabel = new QLabel( GroupBox3, "RcvCRCErrLabel" );
	RcvCRCErrLabel->setGeometry( QRect( 380, 45, 100, 20 ) ); 
	RcvCRCErrLabel->setText( trUtf8( "0" ) );
	RcvCRCErrLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	
	RcvDropFrameLabel = new QLabel( GroupBox3, "RcvDropFrameLabel" );
	RcvDropFrameLabel->setGeometry( QRect( 380, 70, 100, 20 ) ); 
	RcvDropFrameLabel->setText( trUtf8( "0" ) );
	RcvDropFrameLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	
	RcvDupFrameLabel = new QLabel( GroupBox3, "RcvDupFrameLabel" );
	RcvDupFrameLabel->setGeometry( QRect( 380, 95, 100, 20 ) ); 
	RcvDupFrameLabel->setText( trUtf8( "0" ) );
	RcvDupFrameLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	
	ST_TextLabel7 = new QLabel( GroupBox3, "ST_TextLabel7" );
	ST_TextLabel7->setGeometry( QRect( 16, 20, 210, 21 ) ); 
	ST_TextLabel7->setText( trUtf8( "Frames Received Successfully" ) );
	
	ST_TextLabel10 = new QLabel( GroupBox3, "ST_TextLabel10" );
	ST_TextLabel10->setGeometry( QRect( 16, 95, 281, 21 ) ); 
	ST_TextLabel10->setText( trUtf8( "Duplicate Frames Received" ) );
	
	ST_TextLabel17 = new QLabel( GroupBox3, "ST_TextLabel17" );
	ST_TextLabel17->setGeometry( QRect( 328, 20, 20, 20 ) ); 
	ST_TextLabel17->setText( trUtf8( "=" ) );
	
	ST_TextLabel18 = new QLabel( GroupBox3, "ST_TextLabel18" );
	ST_TextLabel18->setGeometry( QRect( 328, 45, 30, 20 ) ); 
	ST_TextLabel18->setText( trUtf8( "=" ) );
	
	ST_TextLabel19 = new QLabel( GroupBox3, "ST_TextLabel19" );
	ST_TextLabel19->setGeometry( QRect( 328, 70, 30, 20 ) ); 
	ST_TextLabel19->setText( trUtf8( "=" ) );
	
	ST_TextLabel20 = new QLabel( GroupBox3, "ST_TextLabel20" );
	ST_TextLabel20->setGeometry( QRect( 328, 95, 30, 20 ) ); 
	ST_TextLabel20->setText( trUtf8( "=" ) );
	
	GroupBox2 = new QGroupBox( tab_4, "GroupBox2" );
	GroupBox2->setGeometry( QRect( 20, 20, 511, 180 ) ); 
	GroupBox2->setTitle( trUtf8( "Trasmitted Frames Statistics" ) );
	
	ST_TextLabel2 = new QLabel( GroupBox2, "ST_TextLabel2" );
	ST_TextLabel2->setGeometry( QRect( 16, 45, 270, 20 ) ); 
	ST_TextLabel2->setText( trUtf8( "Frames Transmitted Successfully Without Retry" ) );
	
	ST_TextLabel3 = new QLabel( GroupBox2, "ST_TextLabel3" );
	ST_TextLabel3->setGeometry( QRect( 16, 70, 270, 21 ) ); 
	ST_TextLabel3->setText( trUtf8( "Frames Transmitted Successfully After Retry(s)" ) );
	
	ST_TextLabel4 = new QLabel( GroupBox2, "ST_TextLabel4" );
	ST_TextLabel4->setGeometry( QRect( 16, 95, 291, 20 ) ); 
	ST_TextLabel4->setText( trUtf8( "Frames Fail to Receive ACK After All Retries" ) );
	
	ST_TextLabel5 = new QLabel( GroupBox2, "ST_TextLabel5" );
	ST_TextLabel5->setGeometry( QRect( 16, 120, 301, 21 ) ); 
	ST_TextLabel5->setText( trUtf8( "RTS Frames Successfully Receive CTS" ) );
	
	ST_TextLabel6 = new QLabel( GroupBox2, "ST_TextLabel6" );
	ST_TextLabel6->setGeometry( QRect( 16, 145, 271, 21 ) ); 
	ST_TextLabel6->setText( trUtf8( "RTS Frames Fail to Receive CTS" ) );
	
	TranSucFrameLable = new QLabel( GroupBox2, "TranSucFrameLable" );
	TranSucFrameLable->setGeometry( QRect( 380, 20, 100, 21 ) ); 
	TranSucFrameLable->setText( trUtf8( "0" ) );
	TranSucFrameLable->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	
	TranSucWithoutRetryLabel = new QLabel( GroupBox2, "TranSucWithoutRetryLabel" );
	TranSucWithoutRetryLabel->setGeometry( QRect( 380, 45, 100, 20 ) ); 
	TranSucWithoutRetryLabel->setText( trUtf8( "0" ) );
	TranSucWithoutRetryLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	
	TranSucAftRetryLabel = new QLabel( GroupBox2, "TranSucAftRetryLabel" );
	TranSucAftRetryLabel->setGeometry( QRect( 380, 70, 100, 20 ) ); 
	TranSucAftRetryLabel->setText( trUtf8( "0" ) );
	TranSucAftRetryLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	
	TranFailAckLabel = new QLabel( GroupBox2, "TranFailAckLabel" );
	TranFailAckLabel->setGeometry( QRect( 380, 95, 100, 20 ) ); 
	TranFailAckLabel->setText( trUtf8( "0" ) );
	TranFailAckLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	
	TranSucRTSLabel = new QLabel( GroupBox2, "TranSucRTSLabel" );
	TranSucRTSLabel->setGeometry( QRect( 380, 120, 100, 20 ) ); 
	TranSucRTSLabel->setText( trUtf8( "0" ) );
	TranSucRTSLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	
	TranFailRTSLabel = new QLabel( GroupBox2, "TranFailRTSLabel" );
	TranFailRTSLabel->setGeometry( QRect( 380, 145, 100, 20 ) ); 
	TranFailRTSLabel->setText( trUtf8( "0" ) );
	TranFailRTSLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	
	ST_TextLabel1 = new QLabel( GroupBox2, "ST_TextLabel1" );
	ST_TextLabel1->setGeometry( QRect( 16, 20, 231, 19 ) ); 
	ST_TextLabel1->setText( trUtf8( "Frames Transmitted Successfully" ) );
	
	ST_TextLabel11 = new QLabel( GroupBox2, "ST_TextLabel11" );
	ST_TextLabel11->setGeometry( QRect( 328, 20, 16, 20 ) ); 
	ST_TextLabel11->setText( trUtf8( "=" ) );
	
	ST_TextLabel12 = new QLabel( GroupBox2, "ST_TextLabel12" );
	ST_TextLabel12->setGeometry( QRect( 328, 45, 20, 20 ) ); 
	ST_TextLabel12->setText( trUtf8( "=" ) );
	
	ST_TextLabel13 = new QLabel( GroupBox2, "ST_TextLabel13" );
	ST_TextLabel13->setGeometry( QRect( 328, 75, 20, 20 ) ); 
	ST_TextLabel13->setText( trUtf8( "=" ) );
	
	ST_TextLabel14 = new QLabel( GroupBox2, "ST_TextLabel14" );
	ST_TextLabel14->setGeometry( QRect( 328, 95, 30, 20 ) ); 
	ST_TextLabel14->setText( trUtf8( "=" ) );
	
	ST_TextLabel15_2 = new QLabel( GroupBox2, "ST_TextLabel15_2" );
	ST_TextLabel15_2->setGeometry( QRect( 328, 120, 20, 20 ) ); 
	ST_TextLabel15_2->setText( trUtf8( "=" ) );
	
	ST_TextLabel16_2 = new QLabel( GroupBox2, "ST_TextLabel16_2" );
	ST_TextLabel16_2->setGeometry( QRect( 328, 145, 20, 20 ) ); 
	ST_TextLabel16_2->setText( trUtf8( "=" ) );
	
	ResetPushButton = new QPushButton( tab_4, "ResetPushButton" );
	ResetPushButton->setGeometry( QRect( 420, 360, 110, 30 ) ); 
	ResetPushButton->setText( trUtf8( "&Reset Counters" ) );
	TabWidget3->insertTab( tab_4, trUtf8( "S&tatistics" ) );
	
	tab_5 = new QWidget( TabWidget3, "tab_5" );
	
	AboutRTlogoTextLabel = new QLabel( tab_5, "AboutRTlogoTextLabel" );
	AboutRTlogoTextLabel->setGeometry( QRect( 20, 30, 170, 80 ) ); 
	AboutRTlogoTextLabel->setText( trUtf8( "" ) );
	AboutRTlogoTextLabel->setPixmap( uic_load_pixmap_RaConfigForm( "rtlogo.png" ) );
	
	GroupBox4 = new QGroupBox( tab_5, "GroupBox4" );
	GroupBox4->setGeometry( QRect( 20, 120, 520, 60 ) ); 
	GroupBox4->setTitle( trUtf8( "Configuration Utility" ) );
	
	Ver_TextLabel1 = new QLabel( GroupBox4, "Ver_TextLabel1" );
	Ver_TextLabel1->setGeometry( QRect( 20, 25, 60, 20 ) ); 
	Ver_TextLabel1->setText( trUtf8( "Version :" ) );
	
	UIVersionTextLabel = new QLabel( GroupBox4, "UIVersionTextLabel" );
	UIVersionTextLabel->setGeometry( QRect( 110, 25, 72, 20 ) ); 
	UIVersionTextLabel->setText( trUtf8( CONFIGURATION_UI_VERSION ) );
	
	Date_TextLabel1 = new QLabel( GroupBox4, "Date_TextLabel1" );
	Date_TextLabel1->setGeometry( QRect( 260, 25, 60, 20 ) ); 
	Date_TextLabel1->setText( trUtf8( "Date :" ) );
	
	UIDateTextLabel = new QLabel( GroupBox4, "UIDateTextLabel" );
	UIDateTextLabel->setGeometry( QRect( 336, 25, 100, 20 ) ); 
	UIDateTextLabel->setText( trUtf8( CONFIGURATION_UI_DATE ) );
	
	GroupBox5 = new QGroupBox( tab_5, "GroupBox5" );
	GroupBox5->setGeometry( QRect( 20, 206, 520, 60 ) ); 
	GroupBox5->setTitle( trUtf8( "NIC Driver" ) );
	
	Ver_TextLabel2 = new QLabel( GroupBox5, "Ver_TextLabel2" );
	Ver_TextLabel2->setGeometry( QRect( 20, 25, 60, 20 ) ); 
	Ver_TextLabel2->setText( trUtf8( "Version :" ) );
	
	NICVersionTextLabel = new QLabel( GroupBox5, "NICVersionTextLabel" );
	NICVersionTextLabel->setGeometry( QRect( 110, 25, 100, 20 ) ); 
	NICVersionTextLabel->setText( trUtf8( "0.0.0" ) );
	
	Date_TextLabel2 = new QLabel( GroupBox5, "Date_TextLabel2" );
	Date_TextLabel2->setGeometry( QRect( 260, 25, 72, 20 ) ); 
	Date_TextLabel2->setText( trUtf8( "Date :" ) );
	
	NICDateTextLabel = new QLabel( GroupBox5, "NICDateTextLabel" );
	NICDateTextLabel->setGeometry( QRect( 336, 25, 100, 20 ) ); 
	NICDateTextLabel->setText( trUtf8( "YYYY-MM-DD"));
	
	GroupBox6 = new QGroupBox( tab_5, "GroupBox6" );
	GroupBox6->setGeometry( QRect( 20, 296, 520, 60 ) ); 
	GroupBox6->setTitle( trUtf8( "MAC Address" ) );
	
	phy_AddressTextLabel = new QLabel( GroupBox6, "phy_AddressTextLabel" );
	phy_AddressTextLabel->setGeometry( QRect( 20, 25, 90, 20 ) ); 
	phy_AddressTextLabel->setText( trUtf8( "Physical Address :" ) );
	
	MACTextLabel = new QLabel( GroupBox6, "MACTextLabel" );
	MACTextLabel->setGeometry( QRect( 180, 25, 180, 20 ) ); 
	MACTextLabel->setText( trUtf8( "MAC_Adr" ) );

	cautionTextLabel = new QLabel( tab_5, "cautionTextLabel" );
	cautionTextLabel->setGeometry( QRect( 20, 360, 460, 50 ) ); 
	cautionTextLabel->setText( trUtf8( "" ) );
	
	TabWidget3->insertTab( tab_5, trUtf8( "A&bout" ) );
	
#ifdef RTQA_DEBUG
	hexValidator = new QHexValidator(this);	
	
	tab_6 = new QWidget( TabWidget3, "tab_6" );
	
	SetMacGroupBox = new QGroupBox( tab_6, "SetMacGroupBox" );
	SetMacGroupBox->setGeometry( QRect( 18, 20, 521, 71 ) ); 
	SetMacGroupBox->setTitle( trUtf8( "MAC" ) );
	
	MacOffsetLineEdit = new QLineEdit( SetMacGroupBox, "MacOffsetLineEdit" );
	MacOffsetLineEdit->setGeometry( QRect( 148, 28, 70, 22 ) ); 
	MacOffsetLineEdit->setMargin( 0 );
	MacOffsetLineEdit->setText( trUtf8( "00000000" ) );
	MacOffsetLineEdit->setMaxLength( 8 );
	MacOffsetLineEdit->setValidator(hexValidator);
	MacOffsetLineEdit->setAlignment( int( QLineEdit::AlignRight ) );
	
	MacOffsetTextLabel = new QLabel( SetMacGroupBox, "MacOffsetTextLabel" );
	MacOffsetTextLabel->setGeometry( QRect( 112, 28, 36, 22 ) ); 
	MacOffsetTextLabel->setText( trUtf8( "Offset" ) );
	
	MacValueTextLabel = new QLabel( SetMacGroupBox, "MacValueTextLabel" );
	MacValueTextLabel->setGeometry( QRect( 246, 28, 37, 21 ) ); 
	MacValueTextLabel->setText( trUtf8( "Value" ) );
	
	MacValueLineEdit = new QLineEdit( SetMacGroupBox, "MacValueLineEdit" );
	MacValueLineEdit->setGeometry( QRect( 282, 28, 70, 22 ) ); 
	MacValueLineEdit->setText( trUtf8( "00000000" ) );
	MacValueLineEdit->setValidator(hexValidator);
	MacValueLineEdit->setMaxLength( 8 );
	MacValueLineEdit->setAlignment( int( QLineEdit::AlignRight ) );
	
	MacQueryPushButton = new QPushButton( SetMacGroupBox, "MacQueryPushButton" );
	MacQueryPushButton->setGeometry( QRect( 370, 28, 60, 21 ) ); 
	MacQueryPushButton->setText( trUtf8( "Query" ) );
	
	MacSetPushButton = new QPushButton( SetMacGroupBox, "MacSetPushButton" );
	MacSetPushButton->setGeometry( QRect( 442, 28, 60, 21 ) ); 
	MacSetPushButton->setText( trUtf8( "Set" ) );
	
	SetMacTextLabel1_2 = new QLabel( SetMacGroupBox, "SetMacTextLabel1_2" );
	SetMacTextLabel1_2->setGeometry( QRect( 10, 28, 90, 21 ) ); 
	SetMacTextLabel1_2->setText( trUtf8( "MAC Register :" ) );
	
	SetBBPGroupBox = new QGroupBox( tab_6, "SetBBPGroupBox" );
	SetBBPGroupBox->setGeometry( QRect( 18, 116, 521, 71 ) ); 
	SetBBPGroupBox->setTitle( trUtf8( "Baseband" ) );
	
	SetMacTextLabel4_3 = new QLabel( SetBBPGroupBox, "SetMacTextLabel4_3" );
	SetMacTextLabel4_3->setGeometry( QRect( 10, 28, 90, 21 ) ); 
	SetMacTextLabel4_3->setText( trUtf8( "BBP Register :" ) );
	
	SetMacTextLabel5 = new QLabel( SetBBPGroupBox, "SetMacTextLabel5" );
	SetMacTextLabel5->setGeometry( QRect( 112, 28, 30, 21 ) ); 
	SetMacTextLabel5->setText( trUtf8( "ID" ) );
	
	BBPIDLineEdit = new QLineEdit( SetBBPGroupBox, "BBPIDLineEdit" );
	BBPIDLineEdit->setGeometry( QRect( 151, 28, 70, 22 ) ); 
	BBPIDLineEdit->setText( trUtf8( "00" ) );
	BBPIDLineEdit->setValidator(hexValidator);
	BBPIDLineEdit->setMaxLength( 2 );
	BBPIDLineEdit->setAlignment( int( QLineEdit::AlignRight ) );
	
	SetMacTextLabel6_2 = new QLabel( SetBBPGroupBox, "SetMacTextLabel6_2" );
	SetMacTextLabel6_2->setGeometry( QRect( 246, 28, 37, 21 ) ); 
	SetMacTextLabel6_2->setText( trUtf8( "Value" ) );
	
	BBPSetPushButton = new QPushButton( SetBBPGroupBox, "BBPSetPushButton" );
	BBPSetPushButton->setGeometry( QRect( 442, 28, 60, 21 ) ); 
	BBPSetPushButton->setText( trUtf8( "Set" ) );
	
	BBPValueLineEdit = new QLineEdit( SetBBPGroupBox, "BBPValueLineEdit" );
	BBPValueLineEdit->setGeometry( QRect( 282, 28, 70, 22 ) ); 
	BBPValueLineEdit->setText( trUtf8( "00" ) );
	BBPValueLineEdit->setMaxLength( 2 );
	BBPValueLineEdit->setValidator(hexValidator);
	BBPValueLineEdit->setAlignment( int( QLineEdit::AlignRight ) );
	
	BBPQueryPushButton = new QPushButton( SetBBPGroupBox, "BBPQueryPushButton" );
	BBPQueryPushButton->setGeometry( QRect( 370, 28, 60, 21 ) ); 
	BBPQueryPushButton->setText( trUtf8( "Query" ) );
	
	SetRFGroupBox = new QGroupBox( tab_6, "SetRFGroupBox" );
	SetRFGroupBox->setEnabled( FALSE );
	SetRFGroupBox->setGeometry( QRect( 18, 216, 521, 71 ) ); 
	SetRFGroupBox->setTitle( trUtf8( "RF" ) );
	
	SetMacTextLabel9 = new QLabel( SetRFGroupBox, "SetMacTextLabel9" );
	SetMacTextLabel9->setGeometry( QRect( 240, 28, 40, 21 ) ); 
	SetMacTextLabel9->setText( trUtf8( "Value" ) );
	
	SetMacTextLabel8 = new QLabel( SetRFGroupBox, "SetMacTextLabel8" );
	SetMacTextLabel8->setGeometry( QRect( 10, 28, 80, 21 ) ); 
	SetMacTextLabel8->setText( trUtf8( "RF Register :" ) );
	
	RFValueLineEdit = new QLineEdit( SetRFGroupBox, "RFValueLineEdit" );
	RFValueLineEdit->setGeometry( QRect( 280, 28, 70, 22 ) ); 
	RFValueLineEdit->setText( trUtf8( "00000000" ) );
	RFValueLineEdit->setValidator(hexValidator);
	RFValueLineEdit->setMaxLength( 8 );
	RFValueLineEdit->setAlignment( int( QLineEdit::AlignRight ) );
	
	RFSetPushButton = new QPushButton( SetRFGroupBox, "RFSetPushButton" );
	RFSetPushButton->setGeometry( QRect( 370, 28, 130, 21 ) ); 
	RFSetPushButton->setText( trUtf8( "Set" ) );
	TabWidget3->insertTab( tab_6, trUtf8( "Setting Register" ) );
#endif

	tab_7 = new QWidget( TabWidget3, "tab_7" );
	notesTextEdit1 = new QTextEdit( tab_7, "notesTextEdit1" );
	notesTextEdit1->setReadOnly( TRUE );
	notesTextEdit1->setGeometry( QRect( 20, 20, 521, 380 ) );
	notesTextEdit1->setPaletteBackgroundColor( QColor( 222, 222,  222 ) ); 
	notesTextEdit1->setText( trUtf8(
		"You need to have qt, qt-devel, XFree86-devel, fontconfig-devel and freetype-devel to compile RaConfig."
		"\n"
		"\nTested on Fedora Core 1, kernel 2.4.22 and qt 3.1.2 in Ad-Hoc mode."
		"\n"
		"\n/sbin/iwconfig ra0 mode Ad-Hoc (Ad-Hoc Mode)"
		"\n/sbin/iwconfig ra0 ap off (Ad-Hoc Mode)"
		"\n/sbin/wconfig ra0 mode managed (Infrastructure Mode)"
		"\n/sbin/iwconfig ra0 ap 00:0b:be:6d:8b:d5 (Infrastructure Mode)"
		"\n"
		"\n/sbin/iwconfig ra0 essid any"
		"\n/sbin/iwconfig ra0 essid mike"
		"\n/sbin/iwconfig ra0 channel 1"
		"\n/sbin/iwconfig ra0 rts 2312"
		"\n/sbin/iwconfig ra0 frag 2312"
		"\n/sbin/iwconfig ra0 rate 11M auto"
		"\n/sbin/iwconfig ra0 rate auto"
		"\n/sbin/iwconfig ra0 rate 11M"
		"\n/sbin/iwconfig ra0 key off"
		"\n/sbin/iwconfig ra0 key [1] 85C473ABCD restricted"
		"\n/sbin/iwconfig ra0 key [1] 11111111111111111111111111 open"
		"\n/sbin/iwconfig ra0 nick mike"
		"\n/sbin/iwconfig ra0 nwid off"
		"\n"
		"\n/sbin/iwconfig ra0 (read only - doesn't set anything)" ) );

	TabWidget3->insertTab( tab_7, trUtf8( "&Notes" ) );

	TabWidget3->showPage(tab);  //Site survey.
	
	ExitPushButton = new QPushButton( this, "ExitPushButton" );
	ExitPushButton->setGeometry( QRect( 470, 470, 100, 30 ) ); 
	ExitPushButton->setText( trUtf8( "E&xit" ) );
	
	// signals and slots connections
	connect( TabWidget3, SIGNAL( currentChanged(QWidget*) ), this, SLOT( m_TabChanged() ) );
	connect( RadioPushButton, SIGNAL( clicked() ), this, SLOT( RadioPushButton_clicked() ) );
	connect( RescanPushButton, SIGNAL( clicked() ), this, SLOT( m_Rescan() ) );
	connect( ConnectPushButton, SIGNAL( clicked() ), this, SLOT( m_Connect() ) );
	connect( AddToProfilePushButton, SIGNAL( clicked() ), this, SLOT( AddToProfilePushButton_clicked() ) );	 
	connect( NetworkListView, SIGNAL( doubleClicked(QListViewItem*) ), this, SLOT( NetworkListView_doubleClicked() ) );
	connect( AddPushButton, SIGNAL( clicked() ), this, SLOT( AddProfile() ) );
	connect( DeletePushButton, SIGNAL( clicked() ), this, SLOT( DeleteProfile() ) );
	connect( EditPushButton, SIGNAL( clicked() ), this, SLOT( EditProfile() ) );
	connect( ActivePushButton, SIGNAL( clicked() ), this, SLOT( ActiveProfile() ) );	 
	connect( ResetPushButton, SIGNAL( clicked() ), this, SLOT( ResetPushButton_clicked() ) );	 	 
	connect( ExitPushButton, SIGNAL( clicked() ), this, SLOT( close() ) );
	connect( ProfileListView, SIGNAL( doubleClicked(QListViewItem*) ), this, SLOT( ProfileListView_doubleClicked() ) );
#ifdef RTQA_DEBUG
	connect( MacQueryPushButton, SIGNAL( clicked() ), this, SLOT( MacQueryPushButton_clicked() ) );
	connect( MacSetPushButton, SIGNAL( clicked() ), this, SLOT( MacSetPushButton_clicked() ) );
	connect( BBPSetPushButton, SIGNAL( clicked() ), this, SLOT( BBPSetPushButton_clicked() ) );
	connect( BBPQueryPushButton, SIGNAL( clicked() ), this, SLOT( BBPQueryPushButton_clicked() ) );
	connect( RFSetPushButton, SIGNAL( clicked() ), this, SLOT( RFSetPushButton_clicked() ) );
#endif
	//Initial
	SiteItemIndex = -1;
	m_pBssidList = NULL;
	ULONG lBufLen = sizeof(NDIS_802_11_BSSID_LIST) + sizeof(NDIS_WLAN_BSSID) * 19;
	m_pBssidList = (PNDIS_802_11_BSSID_LIST) malloc(lBufLen);	
	char cfgdir[256];
	char cfgProfile[256];	
	FILE  *cfgProfileId;
	PRT_PROFILE_SETTING  nowProfileSetting=NULL;
	PRT_PROFILE_SETTING  lastProfileSetting=NULL;
	RT_PROFILE_SETTING   tmpProfileSetting;
	QListViewItem *Item;
	char tempstr[40];
	char strSSID[40];
	char strProfileID[40];
	
	Socket_Id = socket_id;
	Device_Name = (char *)malloc(strlen(device_name)+1);
	if(Device_Name)
		strcpy(Device_Name, device_name);
	
	memset(strSSID, 0x00, 40);
	memset(strProfileID, 0x00, 40);
	if(getuid() == 0)
	{//Root user
		getkeystring(Device_Name, "ProfileID", strProfileID, 40, RT2460_SYSTEM_PATH, CONFIG_FILE);
		getkeystring(Device_Name, "SSID", strSSID, 40, RT2460_SYSTEM_PATH, CONFIG_FILE);
		sprintf(cfgProfile, "%s/%s", RT2460_SYSTEM_PATH, PROFILE_FILE);
	}
	else
	{
		sprintf(cfgdir, "%s%s", getenv("HOME"), RT2460_LOCAL_PATH);
		getkeystring(Device_Name, "ProfileID", strProfileID, 32, cfgdir, CONFIG_FILE);
		getkeystring(Device_Name, "SSID", strSSID, 40, cfgdir, CONFIG_FILE);
		sprintf(cfgProfile, "%s%s/%s", getenv("HOME"), RT2460_LOCAL_PATH, PROFILE_FILE);
	}
	DBGPRINT(RT_DEBUG_INFO, ("Read config file ProfileID=%s SSID=%s", strProfileID, strSSID));			
	memset(active_profile, 0x00, 32+1);
	strcpy(active_profile, strProfileID);
	strcpy(test_profile, strProfileID);
	
	DBGPRINT(RT_DEBUG_INFO, ("active_profile=[%s]", active_profile));
	ProfileSetting=NULL;
	if((cfgProfileId = fopen(cfgProfile, "rb")) != NULL)
	{
		while(fread((void *)&tmpProfileSetting, sizeof(RT_PROFILE_SETTING), (unsigned) 1, cfgProfileId) != 0)
		{			
			if(( nowProfileSetting = (PRT_PROFILE_SETTING) malloc(sizeof(RT_PROFILE_SETTING))) == NULL)
				break;
			
			memcpy(nowProfileSetting, (void *)&tmpProfileSetting, sizeof(RT_PROFILE_SETTING));
			nowProfileSetting->Next=lastProfileSetting;
			lastProfileSetting = nowProfileSetting;
			
			Item = new QListViewItem(ProfileListView, 0);							
			Item->setText(0, (const char *)nowProfileSetting->Profile);
			Item->setText(1, (const char *)nowProfileSetting->SSID);
			if( (strcmp(strSSID, (const char *)nowProfileSetting->SSID) ==0) && 
				(strcmp(strProfileID, (const char *)nowProfileSetting->Profile) == 0))
			{
				ProfileSetting=nowProfileSetting;
				DBGPRINT(RT_DEBUG_INFO, (">>Get Media status"));			
				if(Get_Media_State(Socket_Id, Device_Name) != NdisMediaStateConnected)
				{
					DBGPRINT(RT_DEBUG_INFO, (">>Status=Disconnect, Connect to deafult Profile=%s SSID=%s", strProfileID, strSSID));			
					m_ActiveSetting(ProfileSetting);
				}
				Item->setPixmap(0, uic_load_pixmap_RaConfigForm("check16.xpm"));
			}
			else
				Item->setPixmap(0, uic_load_pixmap_RaConfigForm("uncheck16.xpm"));
			
			if(nowProfileSetting->Channel != 0)
			{
				sprintf(tempstr, "%d", nowProfileSetting->Channel);
				Item->setText(2, tempstr);
			}
			else
				Item->setText(2, "Auto");
			
			Item->setText(3, nowProfileSetting->Authentication==0 ? "Open System":"Shared key");
			Item->setText(4, nowProfileSetting->Encryption == TRUE? "WEP":"Not Used" );	
			Item->setText(5, strAryNetworkType[nowProfileSetting->NetworkType]);			                 
			DBGPRINT(RT_DEBUG_INFO, ("Read from config file [%s] Profile=%s", cfgProfile, (const char *)nowProfileSetting->Profile));
		}		
		fclose(cfgProfileId);
	}
	
	RTMPProfile = lastProfileSetting;
	timerId_alive = startTimer(2000); //check device driver per 2 seconds.
	timerId_refresh = -1;
	timerId_connected = -1;
	timerId_getLinkStatus = -1;
	timerId_sitesurvey = -1;
	timerId_statistic = -1;
	timerId_updatepro = -1;
	m_bRescan = FALSE;
	m_bRadio = TRUE;
	// Get Radio Status
	bool tmpRadioStatus;
	if(GET_RT_OID_802_11_QUERY_RADIO(Socket_Id, Device_Name, &tmpRadioStatus) >=0 )
		m_bRadio = tmpRadioStatus;
	
	if(m_bRadio)
	{ 
		RadioPushButton->setText( trUtf8( "Radio &Off" ) );
		RadioTextLabel->setPixmap( uic_load_pixmap_RaConfigForm( "radioon.png" ) );
	}
	else
	{
		RadioPushButton->setText( trUtf8( "Radio &On" ) );
		RadioTextLabel->setPixmap( uic_load_pixmap_RaConfigForm( "radiooff.png" ) );
		ConnectPushButton->setEnabled(FALSE);
		RescanPushButton->setEnabled(FALSE);
		AddToProfilePushButton->setEnabled(FALSE);
		LineEdit1->setText("Radio Status <--> OFF");
	}
	
}

/*  
 *  Destroys the object and frees any allocated resources
 */
RaConfigForm::~RaConfigForm()
{
	// no need to delete child widgets, Qt does it all for us
}

void RaConfigForm::m_Rescan()
{
	killTimer(timerId_refresh);
	timerId_refresh = -1;
	killTimer(timerId_sitesurvey);
	timerId_sitesurvey = -1;
	killTimer(timerId_connected);
	timerId_connected = -1;
	LineEdit1->setText("Rescanning...");
	ConnectPushButton->setEnabled(FALSE);
	RescanPushButton->setEnabled(FALSE);
	AddToProfilePushButton->setEnabled(FALSE);
	RadioPushButton->setEnabled(FALSE);
	Set_OID_802_11_BSSID_LIST_SCAN(Socket_Id, Device_Name);
	timerId_sitesurvey = startTimer(2000);
	m_bRescan = TRUE;
}

void RaConfigForm::m_Connect()
{
	QListViewItem *selectedItem;	
	QString str;	
	unsigned int i;
	ULONG lEncryp;
	NDIS_802_11_AUTHENTICATION_MODE AuthenticationMode = Ndis802_11AuthModeOpen;
	char strWepKey[30];
	NDIS_802_11_MAC_ADDRESS tmpBssid;
	
	killTimer(timerId_refresh);
	timerId_refresh = -1;
	killTimer(timerId_sitesurvey);
	timerId_sitesurvey = -1;
	killTimer(timerId_connected);
	timerId_connected = -1;
	
	selectedItem = NetworkListView->selectedItem();
	if(!selectedItem)
	{    	
		DBGPRINT(RT_DEBUG_INFO, ("***No selected****"));				
		QMessageBox::warning(this, "Warning", "Please select a network first!");
		return;
	}
	
	if(!m_pBssidList)
		return;
	
	ConnectPushButton->setEnabled(FALSE);
	RescanPushButton->setEnabled(FALSE);
	AddToProfilePushButton->setEnabled(FALSE);
	RadioPushButton->setEnabled(FALSE);
	
	NDIS_WLAN_BSSID* Bssid = m_pBssidList->Bssid;
	str=selectedItem->text(1);
	int j = 0;
	while ( ( j = str.find( '-', j ) ) != -1 )
		str.remove( j ,1 );				
	AtoH((char *)str.ascii(), tmpBssid, 6);
	
	for(i = 0; i < m_pBssidList->NumberOfItems; i ++)
	{			
		if(memcmp(tmpBssid, Bssid->MacAddress, 6) != 0)
			Bssid++;
		else
			break;
	}
	
	DBGPRINT(RT_DEBUG_TRACE, ("Connetct to SSID=%s", Bssid->Ssid.Ssid));
	
	if(Bssid->Privacy)
	{		
		SiteWepDlg *siteWepDlg = new SiteWepDlg(this, "WEP Setting", TRUE);			
		if(Bssid->InfrastructureMode == Ndis802_11IBSS)
		{
			siteWepDlg->m_ChangeAuthType(0); //Open System.
			siteWepDlg->m_EnableAuthType(FALSE);			
		}
		else if(Bssid->InfrastructureMode == Ndis802_11Infrastructure)
		{
			siteWepDlg->m_ChangeAuthType(1); //Shared key.
			siteWepDlg->m_EnableAuthType(TRUE);
		}
		
		siteWepDlg->exec();		
		
		if(siteWepDlg->m_IsClickWepOkButton() == FALSE)
		{ //cancel.
			ProbeConnectStatus();
			return;
		}
		
		lEncryp = Ndis802_11WEPEnabled;		
		
		if(Bssid->InfrastructureMode != Ndis802_11IBSS && siteWepDlg->m_GetWepAuthenType() == 1)
			AuthenticationMode = Ndis802_11AuthModeShared;
		
		ULONG nWepKeyLen;
		
		if(siteWepDlg->Get_Wep_KeyLength() == 0)
			nWepKeyLen = 5;
		else
			nWepKeyLen = 13;
		
		ULONG lBufLen = (sizeof(NDIS_802_11_WEP) + nWepKeyLen - 1);
		
		PNDIS_802_11_WEP pWepKey = (PNDIS_802_11_WEP)malloc(lBufLen);
		pWepKey->Length = lBufLen;
		pWepKey->KeyLength = nWepKeyLen;
		DBGPRINT(RT_DEBUG_TRACE, ("Get_Wep_KeyID() = %d", siteWepDlg->Get_Wep_KeyID()));
		DBGPRINT(RT_DEBUG_TRACE, ("Keyid= %d", siteWepDlg->Get_Wep_KeyID()));
		for(int i = 0; i < 4; i++) 
		{
			pWepKey->KeyIndex = i;
			memset(pWepKey->KeyMaterial, 0x00, nWepKeyLen);
			if(siteWepDlg->Get_Wep_KeyID() == i)
				pWepKey->KeyIndex |= 0x80000000;
			
			memset(strWepKey, 0x00, 30);
			strcpy(strWepKey, siteWepDlg->Get_Wep_KeyString(i));
			DBGPRINT(RT_DEBUG_TRACE, ("KEY= %s", strWepKey));
			if(strcmp(strWepKey, "") == 0)
				Set_OID_802_11_REMOVE_WEP(Socket_Id, Device_Name, &pWepKey->KeyIndex);
			else
			{
				if(siteWepDlg->Get_Wep_KeyType() == 0)  //Hex
					AtoH((char *)strWepKey, pWepKey->KeyMaterial, nWepKeyLen);
				else
					memcpy(pWepKey->KeyMaterial, strWepKey, nWepKeyLen);
				Set_OID_802_11_ADD_WEP(Socket_Id, Device_Name, pWepKey);				
				
				DBGPRINT(RT_DEBUG_TRACE, ("WEP Key length = %ld", nWepKeyLen));
				DBGPRINT(RT_DEBUG_TRACE, ("key=%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X\n", strWepKey[0], strWepKey[1], strWepKey[2], 
										  strWepKey[3], strWepKey[4], strWepKey[5], strWepKey[6],
										  strWepKey[7], strWepKey[8], strWepKey[9], strWepKey[10], strWepKey[11], strWepKey[12]));
			}
		}
		delete siteWepDlg;
	}
	else
		lEncryp = Ndis802_11WEPDisabled;
	
	ResetOidValue(Bssid->InfrastructureMode);
	
	LineEdit1->setText("Connecting");
	Set_OID_802_11_WEP_STATUS(Socket_Id, Device_Name, &lEncryp);
	
	// Set Authentication Mode	
	Set_OID_802_11_AUTHENTICATION_MODE(Socket_Id, Device_Name, &AuthenticationMode);
	
	// Set Infrastructure Mode	
	Set_OID_802_11_INFRASTRUCTURE_MODE(Socket_Id, Device_Name, &Bssid->InfrastructureMode);
	
	DBGPRINT(RT_DEBUG_TRACE, (">> Bssid->Ssid.Ssid = %s", Bssid->Ssid.Ssid));
	memcpy(m_BssidSet, Bssid->MacAddress, 6);
	// Set BSSID	
	Set_OID_802_11_BSSID(Socket_Id, Device_Name, &Bssid->MacAddress);
	timerId_connected = startTimer(2000);
	DBGPRINT(RT_DEBUG_TRACE, ("<debug> timerId_connected=%d", timerId_connected));
}

void RaConfigForm::timerEvent(QTimerEvent* e)
{
	NDIS_802_11_MAC_ADDRESS Bssid;
	
	if(e->timerId() == timerId_alive)
	{
		if(Get_OID_802_11_BSSID(Socket_Id, Device_Name, &Bssid) == -1 &&
		   errno == ENODEV) //No such device from errno.h)
		{			
			killTimers();
			close();
		}
		
	}
	if(e->timerId() == timerId_refresh)
	{
		ProbeConnectStatus();
	}
	if(e->timerId() == timerId_sitesurvey)
	{
		killTimer(timerId_sitesurvey);
		timerId_sitesurvey = -1;
		DBGPRINT(RT_DEBUG_TRACE, ("**timerId_sitesurvey** active"));
		ProbeConnectStatus();
	}
	else if(e->timerId() == timerId_connected)
	{
		killTimer(timerId_connected);
		timerId_connected=-1;
		DBGPRINT(RT_DEBUG_TRACE, ("**timerId_connected**"));
		ProbeConnectStatus();
	}
	else if(e->timerId() == timerId_getLinkStatus)
	{
		DBGPRINT(RT_DEBUG_TRACE, ("<debug>timerId_getLinkStatus"));
		m_Get_LinkStatus();
	}
	else if(e->timerId() == timerId_statistic)
	{
		DBGPRINT(RT_DEBUG_TRACE, ("<debug>timerId_statistic"));
		m_Get_Statistic();
	}
	else if(e->timerId() == timerId_updatepro)
	{
		DBGPRINT(RT_DEBUG_TRACE, ("<debug>timerId_updatepro"));
		UpdateProfileStatus();
	}
}

void RaConfigForm::ProbeConnectStatus()
{
	QListViewItem  *viewItem;
	QString        str;
	NDIS_MEDIA_STATE ConnectStatus;	
	NDIS_802_11_MAC_ADDRESS Bssid;
	bool found = FALSE;
	char  tmp[60];
	
	killTimer(timerId_refresh);
	timerId_refresh = -1;
	
	if ( m_bRescan == TRUE)
	{
		RescanTimerFunc();
		m_bRescan = FALSE;
	}
	
	ConnectStatus = Get_Media_State(Socket_Id, Device_Name);
	
	if(ConnectStatus == NdisMediaStateConnected)
	{		
		Get_OID_802_11_BSSID(Socket_Id, Device_Name, &m_BssidQuery);
	}
	else
	{		
		memset((void *) &m_BssidQuery, 0x00, sizeof(NDIS_802_11_MAC_ADDRESS));
		if(m_bRadio)
			LineEdit1->setText("Not Connected");
		else
			LineEdit1->setText("Radio OFF - Not Connected");
	}
	
	viewItem = NetworkListView->firstChild();
	for(int i=0; i<NetworkListView->childCount(); i++)
	{
		str=viewItem->text(0);
		str=viewItem->text(1);
		int j = 0;
		while ( ( j = str.find( '-', j ) ) != -1 )
			str.remove( j ,1 );						
		AtoH((char *)str.ascii(), Bssid, 6);
		
		if(memcmp(m_BssidQuery, Bssid, 6) == 0)
		{
			SiteItemIndex  = i;
			str=viewItem->text(0);
			NDIS_802_11_SSID SSID;		
			Get_OID_802_11_SSID(Socket_Id, Device_Name, &SSID);				
			SSID.Ssid[SSID.SsidLength]=0x00;
			//sprintf(tmp, "Connected <--> %s", str.ascii());
			NDIS_802_11_MAC_ADDRESS Bssid;		
			Get_OID_802_11_BSSID(Socket_Id, Device_Name, &Bssid);		
			DBGPRINT(RT_DEBUG_TRACE, (">> %02X:%02X:%02X:%02X:%02X:%02X", Bssid[0],Bssid[1],Bssid[2],Bssid[3],Bssid[4],Bssid[5]));
			SSID.Ssid[SSID.SsidLength]=0x00;   
			sprintf(tmp, "Connected : %02X-%02X-%02X-%02X-%02X-%02X / %s", Bssid[0], Bssid[1], Bssid[2], Bssid[3], Bssid[4], Bssid[5], SSID.Ssid );
			LineEdit1->setText(tmp);
			found = TRUE;
			viewItem->setPixmap(0, uic_load_pixmap_RaConfigForm("handshak16.xpm"));
		}
		else
			viewItem->setPixmap(0, uic_load_pixmap_RaConfigForm("uncheck16.xpm"));
		viewItem = viewItem->itemBelow();
	}
	
	if( (!found) && (ConnectStatus == NdisMediaStateConnected))
	{
		RescanTimerFunc();
		m_bRescan = TRUE;
	}
	
	timerId_refresh = startTimer(3000); //Refresh associated icon.
	RadioPushButton->setEnabled(TRUE);
	if(m_bRadio)
		RescanPushButton->setEnabled(TRUE);
	
	if(NetworkListView->childCount() == 0)
	{ //No SSID list.
		ConnectPushButton->setEnabled(FALSE);
		AddToProfilePushButton->setEnabled(FALSE);			
	}
	else
	{
		if(m_bRadio)
		{
			ConnectPushButton->setEnabled(TRUE);  	
			AddToProfilePushButton->setEnabled(TRUE);
		}
	}
}

void RaConfigForm::RescanTimerFunc()
{
	char  tmp[40];
	unsigned int i;
	ULONG lBufLen;
	QListViewItem  *ListItem;
	
	lBufLen = sizeof(NDIS_802_11_BSSID_LIST) + sizeof(NDIS_WLAN_BSSID) * 19;	
	memset(m_pBssidList, 0x00, lBufLen);
	DBGPRINT(RT_DEBUG_TRACE, ("<<Get_OID_802_11_BSSID_LIST>>"));			
	if(Get_OID_802_11_BSSID_LIST(Socket_Id, Device_Name, m_pBssidList) < 0)
	{
		memset(m_pBssidList, 0x00, lBufLen);
		return;
	}
	
	NetworkListView->clear();
	
	NDIS_WLAN_BSSID* Bssid = m_pBssidList->Bssid;	
	
	for(i=0; i<m_pBssidList->NumberOfItems; i++)
	{
		ListItem=new QListViewItem(NetworkListView);
		
		ListItem->setPixmap(0, uic_load_pixmap_RaConfigForm("uncheck16.xpm"));
		ListItem->setText(0, (const char *)Bssid->Ssid.Ssid);				
		sprintf(tmp, "%02X-%02X-%02X-%02X-%02X-%02X", Bssid->MacAddress[0], Bssid->MacAddress[1], Bssid->MacAddress[2],
				Bssid->MacAddress[3], Bssid->MacAddress[4], Bssid->MacAddress[5]);
		ListItem->setText(1, tmp);				
		sprintf(tmp, "%d%%", ConvertRssiToSignalQuality((int )Bssid->Rssi));												
		ListItem->setText(2, tmp);				
		sprintf(tmp, "%ld", (Bssid->Configuration.DSConfig - 2412000) / 5000 + 1);		
		ListItem->setText(3, tmp);				
		sprintf(tmp, "%s", Bssid->Privacy ? "WEP":"Not Used");
		ListItem->setText(4, tmp);				
		sprintf(tmp, "%s", strAryNetworkType[Bssid->InfrastructureMode]);
		ListItem->setText(5, tmp);				
		Bssid++;
	}	
}

void RaConfigForm::UpdateProfileStatus()
{	
	NDIS_MEDIA_STATE ConnectStatus;	
	QListViewItem  *Item=NULL;
	NDIS_802_11_SSID SSID;
	QString str;
	
	DBGPRINT(RT_DEBUG_TRACE, ("<UpdateProfileStatus>"));
	DBGPRINT(RT_DEBUG_TRACE, ("active_profile=%s", active_profile));
	if(active_profile[0] == 0) //Null string.
		return;
	
	Item = ProfileListView->findItem((const char *)active_profile, 0);
	if(!Item)
		return;
	
	ConnectStatus = Get_Media_State(Socket_Id, Device_Name);
	if(ConnectStatus == NdisMediaStateConnected)
	{
		Get_OID_802_11_SSID(Socket_Id, Device_Name, &SSID);
		SSID.Ssid[SSID.SsidLength]=0x00; 
		str=Item->text(1);  //get ssid.
		if(str.compare((const char *)SSID.Ssid) == 0)
		{
			DBGPRINT(RT_DEBUG_TRACE, ("Active %s", SSID.Ssid)); 
			Item->setPixmap(0, uic_load_pixmap_RaConfigForm("check16.xpm"));
		}
		else
			Item->setPixmap(0, uic_load_pixmap_RaConfigForm("noactive16.xpm"));
	}
	else
		Item->setPixmap(0, uic_load_pixmap_RaConfigForm("noactive16.xpm"));
}

void RaConfigForm::m_TabChanged()
{
	killTimer(timerId_refresh);
	timerId_refresh = -1;
	killTimer(timerId_connected);
	timerId_connected = -1;
	killTimer(timerId_getLinkStatus);
	timerId_getLinkStatus = -1;
	killTimer(timerId_sitesurvey);
	timerId_sitesurvey = -1;
	killTimer(timerId_statistic);
	timerId_statistic = -1;
	killTimer(timerId_updatepro);	
	timerId_updatepro = -1;
	
	if(TabWidget3->currentPageIndex() != 1)  //Linkstatus
	{
		if(timerId_getLinkStatus != 0)
		{
			killTimer(timerId_getLinkStatus);
			timerId_getLinkStatus = -1;			
		}
	}
	
	if(TabWidget3->currentPageIndex() != 3)  //Statistic
	{
		if(timerId_statistic != 0)
		{
			killTimer(timerId_statistic);
			timerId_statistic= -1;			
		}
	}
	
	switch(TabWidget3->currentPageIndex())
	{
		case 0: //Page:Profile				
		UpdateProfileStatus();
		timerId_updatepro = startTimer(2000);
		if (ProfileListView->childCount() == 0 )
		{
			EditPushButton->setEnabled(FALSE);
			DeletePushButton->setEnabled(FALSE);
			ActivePushButton->setEnabled(FALSE);
		}
		else
		{
			EditPushButton->setEnabled(TRUE);
			DeletePushButton->setEnabled(TRUE);
			ActivePushButton->setEnabled(TRUE);
		}
		break;
		case 1: //Page:Link Status
		LinkStatusPage_Active();
		break;
		case 2: //Page:Site Survey				
		if(m_bRadio)
			m_Rescan();
		break;
		case 3: //Page:Statistics
		StatisticPage_Active();
		break;
		case 4: //Page:About
		AboutPage_Active();
		break;
	default:
		break;
	}
}


void RaConfigForm::LinkStatusPage_Active()
{	
	RT_802_11_LINK_STATUS LinkStatus;
	
	if(Get_RT_OID_802_11_QUERY_LINK_STATUS(Socket_Id, Device_Name, &LinkStatus) >= 0)
	{
		m_lTxCount = LinkStatus.TxByteCount;
		m_lRxCount = LinkStatus.RxByteCount;			
	}
	timerId_getLinkStatus = startTimer(2000);
}

void RaConfigForm::m_Get_LinkStatus()
{
	char tmp[60];	
	NDIS_MEDIA_STATE state;	
	
	state = Get_Media_State(Socket_Id, Device_Name);
	if(state == NdisMediaStateConnected)
	{
		NDIS_802_11_SSID SSID;		
		Get_OID_802_11_SSID(Socket_Id, Device_Name, &SSID);				
		DBGPRINT(RT_DEBUG_TRACE, (">> SSID=%s", SSID.Ssid));
		NDIS_802_11_MAC_ADDRESS Bssid;		
		Get_OID_802_11_BSSID(Socket_Id, Device_Name, &Bssid);		
		DBGPRINT(RT_DEBUG_TRACE, (">> %02X:%02X:%02X:%02X:%02X:%02X", Bssid[0],Bssid[1],Bssid[2],Bssid[3],Bssid[4],Bssid[5]));
		SSID.Ssid[SSID.SsidLength]=0x00;   
		sprintf(tmp, "BSSID: %02X-%02X-%02X-%02X-%02X-%02X  -  SSID: %s", Bssid[0], Bssid[1], Bssid[2], Bssid[3], Bssid[4], Bssid[5], SSID.Ssid );
		StatusTextLabel->setText(tmp);
		
		NDIS_802_11_CONFIGURATION Configuration;		
		Get_NDIS_802_11_CONFIGURATION(Socket_Id, Device_Name, &Configuration);
		sprintf(tmp, "%ld  -  2.%ld GHz", ((Configuration.DSConfig - 2412000) / 5000) + 1, ((Configuration.DSConfig-2000000)/1000));
		ChannelTextLabel->setText(tmp);
		
		RT_802_11_LINK_STATUS LinkStatus;		
		Get_RT_OID_802_11_QUERY_LINK_STATUS(Socket_Id, Device_Name, &LinkStatus);
		// Current Tx Rate
		if((LinkStatus.CurrTxRate % 2) == 0)
		{
			sprintf(tmp, "%ld Mbps", LinkStatus.CurrTxRate / 2);
			RateTextLabel->setText(tmp);
		}
		else
		{
			sprintf(tmp, "%.1f Mbps", double(LinkStatus.CurrTxRate / 2));
			RateTextLabel->setText(tmp);
		}
		
		// Tx Throughput (KBits/sec) (LinkStatus.TxByteCount - m_lTxCount) * 8(bits) /1000 / 2(sec)
		if( (double)((LinkStatus.TxByteCount - m_lTxCount) * 4) < 1000)
		{
			sprintf(tmp, "%.1f bps", (double)((LinkStatus.TxByteCount - m_lTxCount) * 4));
		}
		else
		{
			sprintf(tmp, "%.1f Kbps", (double)((LinkStatus.TxByteCount - m_lTxCount) / 250));
		}
		TxTextLabel->setText(tmp);
		if( (double)((LinkStatus.TxByteCount - m_lTxCount) * 4) > 0)
		{
			TxTextLabel->setPaletteForegroundColor( QColor(0, 0, 255) );
		}
		else
		{
			TxTextLabel->setPaletteForegroundColor( QColor(0, 0, 0) );
		}
		m_lTxCount = LinkStatus.TxByteCount;
		
		// Rx Throughput (KBits/sec) (LinkStatus.RxByteCount - m_lRxCount) * 8(bits) /1000 / 2(sec)
		if( (double)((LinkStatus.RxByteCount - m_lRxCount) * 4) < 1000)
		{
			sprintf(tmp, "%.1f bps", (double)(LinkStatus.RxByteCount - m_lRxCount) * 4);
		}
		else
		{
			sprintf(tmp, "%.1f Kbps", (double)(LinkStatus.RxByteCount - m_lRxCount) / 250);
		}
		RxTextLabel->setText(tmp);		
		if( (double)((LinkStatus.RxByteCount - m_lTxCount) * 4) > 0)
		{
			RxTextLabel->setPaletteForegroundColor( QColor(0, 0, 255) );
		}
		else
		{
			RxTextLabel->setPaletteForegroundColor( QColor(0, 0, 0) );
		}
		m_lRxCount = LinkStatus.RxByteCount;
		
		// Link Quality
		if(LinkStatus.ChannelQuality >= 100)
		{
			sprintf(tmp, "Perfect %ld%%", LinkStatus.ChannelQuality);
			LinkStatus.ChannelQuality = 100;
		}
		else if(LinkStatus.ChannelQuality > 85)
			sprintf(tmp, "Excellent %ld%%", LinkStatus.ChannelQuality);
		else if(LinkStatus.ChannelQuality > 75)
			sprintf(tmp, "Very Good %ld%%", LinkStatus.ChannelQuality);
		else if(LinkStatus.ChannelQuality > 50)
			sprintf(tmp, "Good %ld%%", LinkStatus.ChannelQuality);
		else if(LinkStatus.ChannelQuality > 30)
			sprintf(tmp, "Average %ld%%", LinkStatus.ChannelQuality);
		else if(LinkStatus.ChannelQuality > 15)
			sprintf(tmp, "Weak %ld%%", LinkStatus.ChannelQuality);
		else
			sprintf(tmp, "Very Weak %ld%%", LinkStatus.ChannelQuality);
		//TextLabel15->setFont(QFont("Helvetica",12,75,false));
		TextLabel15->setText(tmp);
		//TextLabel15->setPaletteBackgroundColor( QColor(0, 0, 0) );
		//TextLabel15->setPaletteForegroundColor( QColor(0, 0, 0) );
		// Display the Link Quality Progress Meter
		LinkProgressBar->setPercentageVisible(false);
		//LinkProgressBar->setTotalSteps(100);
		LinkProgressBar->setFont(QFont("Bitstream Vera Sans",10,75,false));
		if(LinkStatus.ChannelQuality >= 90)
			LinkProgressBar->setPaletteBackgroundColor( QColor(0, 255, 0) );
		else if(LinkStatus.ChannelQuality >= 80)
			LinkProgressBar->setPaletteBackgroundColor( QColor(0, 230, 0) );
		else if(LinkStatus.ChannelQuality >= 70)
			LinkProgressBar->setPaletteBackgroundColor( QColor(0, 205, 0) );
		else if(LinkStatus.ChannelQuality >= 60)
			LinkProgressBar->setPaletteBackgroundColor( QColor(0, 180, 0) );
		else if(LinkStatus.ChannelQuality >= 50)
			LinkProgressBar->setPaletteBackgroundColor( QColor(0, 155, 0) );
		else if(LinkStatus.ChannelQuality >= 40)
			LinkProgressBar->setPaletteBackgroundColor( QColor(255,170, 0) );
		else if(LinkStatus.ChannelQuality >= 30)
			LinkProgressBar->setPaletteBackgroundColor( QColor(255, 150, 0) );
		else if(LinkStatus.ChannelQuality >= 20)
			LinkProgressBar->setPaletteBackgroundColor( QColor(255, 130, 0) );
		else if(LinkStatus.ChannelQuality >= 10)
			LinkProgressBar->setPaletteBackgroundColor( QColor(255, 110, 0) );
		else
			LinkProgressBar->setPaletteBackgroundColor( QColor(255, 0, 0) );
		LinkProgressBar->setProgress(LinkStatus.ChannelQuality);
		//LinkProgressBar->setPaletteForegroundColor( QColor(222, 0, 0) );
		
		// Signal Strength
		NDIS_802_11_RSSI RSSI;
		unsigned int signal_quality;		
		Get_OID_802_11_RSSI(Socket_Id, Device_Name, &RSSI);
		
		signal_quality = ConvertRssiToSignalQuality((int) RSSI);
		if(signal_quality >= 100)
		{
			sprintf(tmp, "Perfect 100%%");
			signal_quality=100;
		}
		else if(signal_quality > 85)
			sprintf(tmp, "Excellent %d%%", signal_quality);
		else if(signal_quality > 75)
			sprintf(tmp, "Very Good %d%%", signal_quality);
		else if(signal_quality > 50)
			sprintf(tmp, "Good %d%%", signal_quality);
		else if(signal_quality > 30)
			sprintf(tmp, "Average %d%%", signal_quality);
		else if(signal_quality > 15)
			sprintf(tmp, "Weak %d%%", signal_quality);
		else
			sprintf(tmp, "Very Weak %d%%", signal_quality);
		TextLabel16->setText(tmp);
		DBGPRINT(RT_DEBUG_TRACE, ("<debug> RSSI=%d", signal_quality));		
		// Display the Signal Strength Progress Meter
		SignalProgressBar->setPercentageVisible(false);
		SignalProgressBar->setFont(QFont("Bitstream Vera Sans",10,75,false));
		if(signal_quality >= 90)
			SignalProgressBar->setPaletteBackgroundColor( QColor(0, 255, 0) );
		else if(signal_quality >= 80)
			SignalProgressBar->setPaletteBackgroundColor( QColor(0, 230, 0) );
		else if(signal_quality >= 70)
			SignalProgressBar->setPaletteBackgroundColor( QColor(0, 205, 0) );
		else if(signal_quality >= 60)
			SignalProgressBar->setPaletteBackgroundColor( QColor(0, 180, 0) );
		else if(signal_quality >= 50)
			SignalProgressBar->setPaletteBackgroundColor( QColor(0, 155, 0) );
		else if(signal_quality >= 40)
			SignalProgressBar->setPaletteBackgroundColor( QColor(255,170, 0) );
		else if(signal_quality >= 30)
			SignalProgressBar->setPaletteBackgroundColor( QColor(255, 150, 0) );
		else if(signal_quality >= 20)
			SignalProgressBar->setPaletteBackgroundColor( QColor(255, 130, 0) );
		else if(signal_quality >= 10)
			SignalProgressBar->setPaletteBackgroundColor( QColor(255, 110, 0) );
		else
			SignalProgressBar->setPaletteBackgroundColor( QColor(255, 0, 0) );
		SignalProgressBar->setProgress(signal_quality);
	}
	else
	{
		if(m_bRadio)
			StatusTextLabel->setText("Not Connected!");
		else
			StatusTextLabel->setText("Radio OFF - Not Connected");
		ChannelTextLabel->setText("");
		RateTextLabel->setText("");
		TxTextLabel->setPaletteForegroundColor( QColor(0, 0, 0) );
		TxTextLabel->setText("");
		RxTextLabel->setPaletteForegroundColor( QColor(0, 0, 0) );
		RxTextLabel->setText("");		
		TextLabel15->setText("");
		LinkProgressBar->setProgress(0);
		LinkProgressBar->setPaletteBackgroundColor( QColor(255, 0, 0) );
		TextLabel16->setText("");
		SignalProgressBar->setProgress(0);
		SignalProgressBar->setPaletteBackgroundColor( QColor(255, 0, 0) );
	}
}

void RaConfigForm::AddProfile()
{	
	killTimer(timerId_sitesurvey);
	timerId_sitesurvey = -1;
	
	DBGPRINT(RT_DEBUG_TRACE, ("Click AddProfile"));
	AddForm  *addForm = new AddForm(Socket_Id, Device_Name, this, "TEST", PROFILE_ADD, ProfileListView, TRUE);
	addForm->exec();	
	
	delete addForm;
	killTimer(timerId_sitesurvey);
	timerId_sitesurvey = -1;
	timerId_sitesurvey = startTimer(2000);
	m_SaveConfig();    //Save config profile to rt2400.pro
	if (ProfileListView->childCount() == 0 )
	{
		EditPushButton->setEnabled(FALSE);
		DeletePushButton->setEnabled(FALSE);
		ActivePushButton->setEnabled(FALSE);
	}
	else
	{
		EditPushButton->setEnabled(TRUE);
		DeletePushButton->setEnabled(TRUE);
		ActivePushButton->setEnabled(TRUE);
	}
	
}

void RaConfigForm::DeleteProfile()
{
	QListViewItem *Item;
	QString			str;
	PRT_PROFILE_SETTING  ptr;
	PRT_PROFILE_SETTING  previous;
	int answer = 0;
	
	DBGPRINT(RT_DEBUG_TRACE, ("click DeleteProfile"));
	Item = ProfileListView->currentItem();
	if(Item == NULL)
	{
		DBGPRINT(RT_DEBUG_TRACE, ("No more data selected"));
		return ;
	}
	
	str=Item->text(0);
	DBGPRINT(RT_DEBUG_TRACE, ("DeleteProfile <%s>, active_profile=%s", str.ascii(), active_profile));
	if(strcmp(str.ascii(), active_profile) == 0)
	{		
		answer = QMessageBox::warning(this, "Warning", "The profile which you want to delete is current active profile!",
									  "&Yes", "&No", QString::null, 1, 1 );
		if ( answer == 0 ) 
		{ //Yes.
			DBGPRINT(RT_DEBUG_TRACE, ("Remove active_profile[%s]", active_profile));		
			memset(active_profile, 0x00, 32+1);
			DBGPRINT(RT_DEBUG_TRACE, ("After Remove active_profile[%s]", active_profile));		
			ProfileSetting=NULL;
			m_WriteToProfile();
		}
		else
			return;
	}
	ptr = RTMPProfile;
	previous = ptr;
	while(ptr!=NULL)
	{
		if(str.compare((const char *)ptr->Profile) == 0)
		{
			DBGPRINT(RT_DEBUG_TRACE, ("found %s", ptr->Profile));
			if(ptr == RTMPProfile)
			{
				RTMPProfile = ptr->Next;
				free(ptr);
			}
			else
			{
				previous->Next = ptr->Next;
				free(ptr);
			}
			
			DBGPRINT(RT_DEBUG_TRACE, ("RTMPProfile=%p", RTMPProfile));
			ProfileListView->takeItem(Item);
			break;
		}
		else
			previous = ptr;
		ptr = ptr->Next;
	}
	m_SaveConfig();    //Save config profile to rt2400.pro
	
	if (ProfileListView->childCount() == 0 )
	{
		EditPushButton->setEnabled(FALSE);
		DeletePushButton->setEnabled(FALSE);
		ActivePushButton->setEnabled(FALSE);
	}
	else
	{
		EditPushButton->setEnabled(TRUE);
		DeletePushButton->setEnabled(TRUE);
		ActivePushButton->setEnabled(TRUE);
	}
	
}

void RaConfigForm::EditProfile()
{
	QListViewItem *Item;
	QString str;
	bool    bChangeProfileName = FALSE;
	
	DBGPRINT(RT_DEBUG_TRACE, ("Click EditProfile"));
	
	if(ProfileListView->childCount()==0)
	{
		QMessageBox::warning(this, "Warning", "No profile list, Please add profile first.!");
		return;
	}
	Item = ProfileListView->currentItem();	
	if(Item == NULL)
	{
		QMessageBox::warning(this, "Warning", "Please select profile first.!");
		return ;
	}
	str=Item->text(0);
	if(strcmp(str.ascii(), active_profile) == 0)
		bChangeProfileName = TRUE;
	AddForm  *addForm = new AddForm(Socket_Id, Device_Name, this, "TEST", PROFILE_EDIT, ProfileListView, TRUE);	
	addForm->exec();
	if(bChangeProfileName)
	{
		Item = ProfileListView->currentItem();	
		str=Item->text(0);
		strcpy(active_profile, str.ascii());
		DBGPRINT(RT_DEBUG_TRACE, ("Edit profile [%s]", active_profile));
		DBGPRINT(RT_DEBUG_TRACE, ("ProfileSetting->Profile=%s", ProfileSetting->Profile));
		m_WriteToProfile();
	}
	m_SaveConfig();    //Save config profile to rt2400.pro
}

void	RaConfigForm::m_ActiveSetting(PRT_PROFILE_SETTING prtProfile)
{
	bool	bSetSSID = FALSE;
	//	***************************************************
	RT_802_11_PREAMBLE					enumPreamType;
	NDIS_802_11_RATES					aryRates;
	NDIS_802_11_ANTENNA					lAntenna;
	NDIS_802_11_POWER_MODE				enumPSMode;
	NDIS_802_11_RTS_THRESHOLD			lRtsThre;
	NDIS_802_11_FRAGMENTATION_THRESHOLD	lFragThre;
	NDIS_802_11_CONFIGURATION			Configuration;
	NDIS_802_11_TX_POWER_LEVEL			lTransPower;
	NDIS_802_11_WEP_STATUS				enumEncryp;
	NDIS_802_11_AUTHENTICATION_MODE		enumAuthenType;
	NDIS_802_11_NETWORK_INFRASTRUCTURE enumOldNetType;
	NDIS_802_11_NETWORK_INFRASTRUCTURE enumNewNetType;
	//	***************************************************
	
	Get_OID_802_11_INFRASTRUCTURE_MODE(Socket_Id, Device_Name, &enumOldNetType);
	DBGPRINT(RT_DEBUG_TRACE, (">> enumOldNettype = %d prtProfile->NetworkType=%d", enumOldNetType, prtProfile->NetworkType));	
	if((unsigned) enumOldNetType != prtProfile->NetworkType)
	{
		bSetSSID = TRUE;
		if(prtProfile->NetworkType == Ndis802_11IBSS)
			enumNewNetType = Ndis802_11IBSS;
		else if(prtProfile->NetworkType == Ndis802_11Infrastructure)
			enumNewNetType = Ndis802_11Infrastructure;
		else if(prtProfile->NetworkType == Ndis802_11AutoUnknown)
			enumNewNetType = Ndis802_11AutoUnknown;
		else 
			enumNewNetType = Ndis802_11InfrastructureMax;						
		
		Set_OID_802_11_INFRASTRUCTURE_MODE(Socket_Id, Device_Name, &enumNewNetType);
	}
	
	//OID_802_11_TX_ANTENNA_SELECTED
	NDIS_802_11_ANTENNA lOldAntenna;	
	Get_OID_802_11_TX_ANTENNA_SELECTED(Socket_Id, Device_Name, &lOldAntenna);
	DBGPRINT(RT_DEBUG_TRACE, ("(TX Antenna)lOldAntenna = %08lx", lOldAntenna));
	switch(prtProfile->AntennaTx)
	{
	case 0:
		lAntenna = 0xffffffff;
		break;
	case 1:
		lAntenna = 0x00000000;
		break;
	case 2:
		lAntenna = 0x00000001;
		break;
	default:
		break;
	}
	DBGPRINT(RT_DEBUG_TRACE, ("(TX Antenna)lAntenna = %08lx", lAntenna));
	if(lOldAntenna != lAntenna)
	{			
		Set_OID_802_11_TX_ANTENNA_SELECTED(Socket_Id, Device_Name, &lAntenna);
	}
	
	Get_OID_802_11_RX_ANTENNA_SELECTED(Socket_Id, Device_Name, &lOldAntenna);
	DBGPRINT(RT_DEBUG_TRACE, ("(RX Antenna)lOldAntenna = %08lx", lOldAntenna));
	switch(prtProfile->AntennaRx)
	{
	case 0:
		lAntenna = 0xffffffff;
		break;
	case 1:
		lAntenna = 0x00000000;
		break;
	case 2:
		lAntenna = 0x00000001;
		break;
	default:
		break;
	}
	DBGPRINT(RT_DEBUG_TRACE, ("(RX Antenna)lAntenna = %08lx", lAntenna));
	if(lOldAntenna != lAntenna)
	{			
		Set_OID_802_11_RX_ANTENNA_SELECTED(Socket_Id, Device_Name, &lAntenna);
	}
	
	memset(&aryRates, 0x00, sizeof(NDIS_802_11_RATES));
	switch(prtProfile->TransRate)
	{
	case 0:
		aryRates[0] = 0x16 | 0x80;
		aryRates[1] = 0x0b | 0x80;
		aryRates[2] = 0x04 | 0x80;
		aryRates[3] = 0x02 | 0x80;
		break;
	case 1:
		aryRates[0] = 0x02 | 0x80;
		break;
	case 2:
		aryRates[0] = 0x04 | 0x80;
		break;
	case 3:
		aryRates[0] = 0x0b | 0x80;
		break;
	case 4:
		aryRates[0] = 0x16 | 0x80;
		break;
	default:
		break;
	}
	NDIS_802_11_RATES aryOldRates;
	memset(aryOldRates, 0x00, sizeof(NDIS_802_11_RATES));	
	
	Get_OID_802_11_DESIRED_RATES(Socket_Id, Device_Name, &aryOldRates);
	DBGPRINT(RT_DEBUG_TRACE, ("aryOldRates = (%d,%d,%d,%d,%d,%d,%d,%d)\n",
							  aryOldRates[0],aryOldRates[1],aryOldRates[2],aryOldRates[3],aryOldRates[4],aryOldRates[5],aryOldRates[6],aryOldRates[7]));
	
	if(memcmp(aryRates, aryOldRates, sizeof(NDIS_802_11_RATES) != 0))		
		Set_OID_802_11_DESIRED_RATES(Socket_Id, Device_Name, &aryRates);	
	
	RT_802_11_PREAMBLE enumOldPreamType;
	
	if(prtProfile->PreamType == Rt802_11PreambleLong)
		enumPreamType = Rt802_11PreambleLong;
	else if(prtProfile->PreamType == Rt802_11PreambleShort)
		enumPreamType = Rt802_11PreambleShort;
	else if(prtProfile->PreamType == Rt802_11PreambleAuto)
		enumPreamType = Rt802_11PreambleAuto;
	
	Get_OID_802_11_QUERY_PREAMBLE(Socket_Id, Device_Name, &enumOldPreamType);
	DBGPRINT(RT_DEBUG_TRACE, ("enumPreamType=%d, enumOldPreamType=%d", enumPreamType, enumOldPreamType));
	if(enumOldPreamType != enumPreamType)		
		Set_OID_802_11_SET_PREAMBLE(Socket_Id, Device_Name, &enumPreamType);
	
	switch (prtProfile->TransPower) 
	{
	case 0:
		lTransPower = 100;
		break;
	case 1:
		lTransPower = 50;
		break;
	case 2:
		lTransPower = 30;
		break;
	case 3:
		lTransPower = 20;
		break;
	case 4:
		lTransPower = 5;
		break;
	case 5:
		lTransPower = 1;
		break;
	default:
		break;
	}
	NDIS_802_11_TX_POWER_LEVEL lOldTransPower;		
	Get_OID_802_11_TX_POWER_LEVEL(Socket_Id, Device_Name, &lOldTransPower);
	
	if(lOldTransPower != lTransPower)		
		Set_OID_802_11_TX_POWER_LEVEL(Socket_Id, Device_Name, &lTransPower);
	
	NDIS_802_11_RTS_THRESHOLD lOldRtsThre;		
	Get_OID_802_11_RTS_THRESHOLD(Socket_Id, Device_Name, &lOldRtsThre);
	lRtsThre = prtProfile->RTS;
	
	if(lOldRtsThre != lRtsThre)		
		Set_OID_802_11_RTS_THRESHOLD(Socket_Id, Device_Name, &lRtsThre);		
	NDIS_802_11_FRAGMENTATION_THRESHOLD lOldFragThre;		
	Get_OID_802_11_FRAGMENTATION_THRESHOLD(Socket_Id, Device_Name, &lOldFragThre);
	lFragThre = prtProfile->Fragment;
	
	if(lOldFragThre != lFragThre)		
		Set_OID_802_11_FRAGMENTATION_THRESHOLD(Socket_Id, Device_Name, &lFragThre);
	
	NDIS_802_11_AUTHENTICATION_MODE enumOldAuthenType; 	
	if(prtProfile->Authentication == Ndis802_11AuthModeOpen)
		enumAuthenType = Ndis802_11AuthModeOpen;
	else if(prtProfile->Authentication == Ndis802_11AuthModeShared)
		enumAuthenType = Ndis802_11AuthModeShared;
	else if(prtProfile->Authentication == Ndis802_11AuthModeAutoSwitch)
		enumAuthenType = Ndis802_11AuthModeAutoSwitch;
	else if(prtProfile->Authentication == Ndis802_11AuthModeMax)
		enumAuthenType = Ndis802_11AuthModeMax;	
	
	Get_OID_802_11_AUTHENTICATION_MODE(Socket_Id, Device_Name, &enumOldAuthenType);
	
	if(enumAuthenType != enumOldAuthenType)
	{
		bSetSSID = TRUE;		
		Set_OID_802_11_AUTHENTICATION_MODE(Socket_Id, Device_Name, &enumAuthenType);
	}
	
	if(prtProfile->Encryption)
		enumEncryp = Ndis802_11WEPEnabled;
	else
		enumEncryp = Ndis802_11WEPDisabled;
	
	NDIS_802_11_WEP_STATUS enumOldEncryp;	
	
	Get_OID_802_11_WEP_STATUS(Socket_Id, Device_Name, &enumOldEncryp);
	DBGPRINT(RT_DEBUG_TRACE, ("enumEncryp=%d, enumOldEncryp=%d", enumEncryp, enumOldEncryp));
	if(enumOldEncryp != enumEncryp)
	{
		bSetSSID = TRUE;				
		Set_OID_802_11_WEP_STATUS(Socket_Id, Device_Name, &enumEncryp);
	}
	
	if(enumEncryp == Ndis802_11WEPEnabled)
	{
		ULONG nWepKeyLen;
		if(prtProfile->KeyLength == 0)
			nWepKeyLen = 5;
		else
			nWepKeyLen = 13;
		
		ULONG lBufLen = (sizeof(NDIS_802_11_WEP) + nWepKeyLen - 1);
		
		// Allocate Resouce
		PNDIS_802_11_WEP pWepKey = (PNDIS_802_11_WEP)malloc(lBufLen);
		pWepKey->Length = lBufLen;
		pWepKey->KeyLength = nWepKeyLen;
		
		pWepKey->KeyIndex = 0;
		if(prtProfile->KeyIndex==0)
			pWepKey->KeyIndex |= 0x80000000;
		
		if(strcmp((const char *)prtProfile->Key1, "") == 0)			
			Set_OID_802_11_REMOVE_WEP(Socket_Id, Device_Name, &pWepKey->KeyIndex); 
		else
		{			
			if(prtProfile->KeyType == 0)  //Hex
				AtoH((char *)prtProfile->Key1, pWepKey->KeyMaterial, nWepKeyLen);
			else
				memcpy(pWepKey->KeyMaterial, prtProfile->Key1, nWepKeyLen);			
			Set_OID_802_11_ADD_WEP(Socket_Id, Device_Name, pWepKey);
			DBGPRINT(RT_DEBUG_TRACE, ("key=%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X:%02X\n", pWepKey->KeyMaterial[0], pWepKey->KeyMaterial[1], pWepKey->KeyMaterial[2], 
									  pWepKey->KeyMaterial[3], pWepKey->KeyMaterial[4], pWepKey->KeyMaterial[5], pWepKey->KeyMaterial[6],
									  pWepKey->KeyMaterial[7], pWepKey->KeyMaterial[8], pWepKey->KeyMaterial[9], pWepKey->KeyMaterial[10], pWepKey->KeyMaterial[11], pWepKey->KeyMaterial[12]));
			
		}
		
		pWepKey->KeyIndex = 1;
		if(prtProfile->KeyIndex==1)
			pWepKey->KeyIndex |= 0x80000000;
		
		if(strcmp((const char *)prtProfile->Key2, "") == 0)			
			Set_OID_802_11_REMOVE_WEP(Socket_Id, Device_Name, &pWepKey->KeyIndex); 
		else
		{
			if(prtProfile->KeyType == 0)  //Hex
				AtoH((char *)prtProfile->Key2, pWepKey->KeyMaterial, nWepKeyLen);
			else
				memcpy(pWepKey->KeyMaterial, prtProfile->Key2, nWepKeyLen);			
			Set_OID_802_11_ADD_WEP(Socket_Id, Device_Name, pWepKey);
		}
		
		pWepKey->KeyIndex = 2;
		if(prtProfile->KeyIndex==2)
			pWepKey->KeyIndex |= 0x80000000;
		
		if(strcmp((const char *)prtProfile->Key3, "") == 0)			
			Set_OID_802_11_REMOVE_WEP(Socket_Id, Device_Name, &pWepKey->KeyIndex); 
		else
		{
			if(prtProfile->KeyType == 0)  //Hex
				AtoH((char *)prtProfile->Key3, pWepKey->KeyMaterial, nWepKeyLen);
			else
				memcpy(pWepKey->KeyMaterial, prtProfile->Key3, nWepKeyLen);			
			Set_OID_802_11_ADD_WEP(Socket_Id, Device_Name, pWepKey);
		}
		
		
		pWepKey->KeyIndex = 3;
		if(prtProfile->KeyIndex==3)
			pWepKey->KeyIndex |= 0x80000000;
		
		if(strcmp((const char *)prtProfile->Key4, "") == 0)			
			Set_OID_802_11_REMOVE_WEP(Socket_Id, Device_Name, &pWepKey->KeyIndex); 
		else
		{
			if(prtProfile->KeyType == 0)  //Hex
				AtoH((char *)prtProfile->Key4, pWepKey->KeyMaterial, nWepKeyLen);
			else
				memcpy(pWepKey->KeyMaterial, prtProfile->Key4, nWepKeyLen);			
			Set_OID_802_11_ADD_WEP(Socket_Id, Device_Name, pWepKey);
		}		
	}	
	
	DBGPRINT(RT_DEBUG_TRACE, ("enumNewNetType = %d Ndis802_11IBSS=%d", prtProfile->NetworkType, Ndis802_11IBSS));
	if(prtProfile->NetworkType == Ndis802_11IBSS)
	{
		ULONG	lChannel;
		lChannel = prtProfile->Channel;				
		Get_NDIS_802_11_CONFIGURATION(Socket_Id, Device_Name, &Configuration);
		
		if(lChannel != ((Configuration.DSConfig - 2412000) / 5000) + 1)
		{
			bSetSSID = TRUE;
			Configuration.DSConfig = (lChannel - 1) * 5000 + 2412000 ;			
			Set_OID_802_11_CONFIGURATION(Socket_Id, Device_Name, &Configuration);
		}
	}
	else
	{
		int nPSMode = prtProfile->PSmode;
		if(nPSMode == Ndis802_11PowerModeCAM)
			enumPSMode = Ndis802_11PowerModeCAM;
		else if(nPSMode == Ndis802_11PowerModeMAX_PSP)
			enumPSMode = Ndis802_11PowerModeMAX_PSP;
		else if(nPSMode == Ndis802_11PowerModeFast_PSP)
			enumPSMode = Ndis802_11PowerModeFast_PSP;
		else if(nPSMode == Ndis802_11PowerModeMax)
			enumPSMode = Ndis802_11PowerModeMax;
		
		NDIS_802_11_POWER_MODE enumOldPSMode;				
		Get_OID_802_11_POWER_MODE(Socket_Id, Device_Name, &enumOldPSMode);
		DBGPRINT(RT_DEBUG_TRACE, ("enumPSMode=%d, enumOldPSMode=%d", enumPSMode, enumOldPSMode));
		if(enumPSMode != enumOldPSMode)			
			Set_OID_802_11_POWER_MODE(Socket_Id, Device_Name, &enumPSMode);
	}
	
	NDIS_802_11_SSID SSID;
	Get_OID_802_11_SSID(Socket_Id, Device_Name, &SSID);
	DBGPRINT(RT_DEBUG_TRACE, ("oldSSID=%s", SSID.Ssid));
	if(bSetSSID || (strcmp((const char *)prtProfile->SSID, (const char *)SSID.Ssid)  != 0))
	{		
		memset(&SSID, 0x00, sizeof(NDIS_802_11_SSID));
		strcpy((char *)SSID.Ssid, (const char *)prtProfile->SSID);		
		SSID.SsidLength = strlen((const char *)SSID.Ssid);
		DBGPRINT(RT_DEBUG_TRACE, ("prtProfile->SSID = %s %ld", prtProfile->SSID, SSID.SsidLength));		
		Set_OID_802_11_SSID(Socket_Id, Device_Name, &SSID);
	}
}

void RaConfigForm::ActiveProfile()
{
	QString str;	
	QListViewItem *Item;	
	PRT_PROFILE_SETTING  ptr=NULL;
	
	DBGPRINT(RT_DEBUG_TRACE, ("click ActiveProfile"));
	if(ProfileListView->childCount()==0)
	{
		QMessageBox::warning(this, "Warning", "No profile list, Please add profile first.!");
		return;
	}
	
	Item = ProfileListView->currentItem();	
	if(Item == NULL)
	{
		QMessageBox::warning(this, "Warning", "Please select profile first.!");
		return ;
	}
	
	ptr = RTMPProfile;
	str=Item->text(0);
	while(ptr!=NULL)
	{
		Item = ProfileListView->findItem((const char *)ptr->Profile, 0);		
		Item->setPixmap(0, uic_load_pixmap_RaConfigForm("uncheck16.xpm"));
		if(str.compare((const char *)ptr->Profile) == 0)
		{
			DBGPRINT(RT_DEBUG_TRACE, ("Active %s", ptr->Profile)); 
			ProfileSetting = ptr;
		}
		ptr=ptr->Next;
	}
	killTimer(timerId_updatepro);	
	timerId_updatepro = startTimer(2000);
	m_ActiveSetting(ProfileSetting);
	strcpy(active_profile, str.ascii());
	DBGPRINT(RT_DEBUG_TRACE, ("Active profile [%s]", active_profile));
	m_WriteToProfile();
}

void RaConfigForm::StatisticPage_Active()
{
	m_Get_Statistic();
	timerId_statistic = startTimer(2000);			
}

void RaConfigForm::m_Get_Statistic()
{
	NDIS_802_11_STATISTICS Statistics;
	char tmp[40];	
	
	if( Get_OID_802_11_STATISTICS(Socket_Id, Device_Name, &Statistics) >= 0 )
	{
		sprintf(tmp, "%8lld", Statistics.TransmittedFragmentCount);
		TranSucFrameLable->setText(tmp);
		sprintf(tmp, "%8lld", Statistics.TransmittedFragmentCount - Statistics.RetryCount);
		TranSucWithoutRetryLabel->setText(tmp);
		sprintf(tmp, "%8lld", Statistics.RetryCount);
		TranSucAftRetryLabel->setText(tmp);
		sprintf(tmp, "%8lld", Statistics.FailedCount);
		TranFailAckLabel->setText(tmp);
		if( Statistics.FailedCount > 0)
		{
			TranFailAckLabel->setPaletteForegroundColor( QColor( 255, 0, 0 ) );
		}
		else
		{
			TranFailAckLabel->setPaletteForegroundColor( QColor( 0, 0, 0 ) );
		}
		sprintf(tmp, "%8lld", Statistics.RTSSuccessCount);
		TranSucRTSLabel->setText(tmp);
		sprintf(tmp, "%8lld", Statistics.RTSFailureCount);
		TranFailRTSLabel->setText(tmp);
		if( Statistics.RTSFailureCount > 0)
		{
			TranFailRTSLabel->setPaletteForegroundColor( QColor( 255, 0, 0 ) );
		}
		else
		{
			TranFailRTSLabel->setPaletteForegroundColor( QColor( 0, 0, 0 ) );
		}
	}
	
	ULONG lRcvOk = 0;
	if( Get_OID_GEN_RCV_OK(Socket_Id, Device_Name, &lRcvOk) >= 0 )
	{
		sprintf(tmp, "%8ld", lRcvOk);
		RcvSucFrameLabel->setText(tmp);
		sprintf(tmp, "%8lld", Statistics.FCSErrorCount);
		RcvCRCErrLabel->setText(tmp);
		if( Statistics.FCSErrorCount > 0)
		{
			RcvCRCErrLabel->setPaletteForegroundColor( QColor( 255, 0, 0 ) );
		}
		else
		{
			RcvCRCErrLabel->setPaletteForegroundColor( QColor( 0, 0, 0 ) );
		}
	}
	
	ULONG lRcvNoBuf = 0;
	if( Get_OID_GEN_RCV_NO_BUFFER(Socket_Id, Device_Name, &lRcvNoBuf) >= 0 )
	{
		sprintf(tmp, "%8ld", lRcvNoBuf);
		RcvDropFrameLabel->setText(tmp);
		if( lRcvNoBuf > 0)
		{
			RcvDropFrameLabel->setPaletteForegroundColor( QColor( 255, 0, 0 ) );
		}
		else
		{
			RcvDropFrameLabel->setPaletteForegroundColor( QColor( 0, 0, 0 ) );
		}
		sprintf(tmp, "%8lld", Statistics.FrameDuplicateCount);
		RcvDupFrameLabel->setText(tmp);
	}
}

void RaConfigForm::ResetPushButton_clicked()
{
	TranSucFrameLable->setText("0");
	TranSucWithoutRetryLabel->setText("0");
	TranSucAftRetryLabel->setText("0");
	TranFailAckLabel->setText("0");
	TranSucRTSLabel->setText("0");
	TranFailRTSLabel->setText("0");
	
	RcvSucFrameLabel->setText("0");
	RcvCRCErrLabel->setText("0");
	RcvDropFrameLabel->setText("0");
	RcvDupFrameLabel->setText("0");
	
	Set_OID_802_11_RESET_COUNTERS(Socket_Id, Device_Name);
}

void RaConfigForm::AboutPage_Active()
{
	char tmp[40];
	NDIS_802_11_MAC_ADDRESS		CurrentAddress;      
	VERSION_INFO				DriverVersionInfo;
	
	Get_OID_802_3_CURRENT_ADDRESS(Socket_Id, Device_Name, &CurrentAddress);
	sprintf(tmp, "%02X-%02X-%02X-%02X-%02X-%02X", CurrentAddress[0], CurrentAddress[1],
			CurrentAddress[2], CurrentAddress[3], CurrentAddress[4], CurrentAddress[5]);
	MACTextLabel->setText(tmp);	
	
	Get_VERSION_INFO(Socket_Id, Device_Name, &DriverVersionInfo);
	sprintf(tmp, "%d.%d.%d", DriverVersionInfo.DriverMajorVersion, DriverVersionInfo.DriverMinorVersion,
			DriverVersionInfo.DriverSubVersion);
	NICVersionTextLabel->setText(tmp);
	sprintf(tmp, "%04d-%02d-%02d", DriverVersionInfo.DriverBuildYear, DriverVersionInfo.DriverBuildMonth,
			DriverVersionInfo.DriverBuildDay);
	NICDateTextLabel->setText(tmp);	
}

bool RaConfigForm::ResetOidValue(NDIS_802_11_NETWORK_INFRASTRUCTURE enumInfrastructureMode)
{
	NDIS_802_11_RATES					aryRates;
	NDIS_802_11_ANTENNA					lAntenna = 0xffffffff;
	NDIS_802_11_POWER_MODE				enumPSMode = Ndis802_11PowerModeCAM;
	NDIS_802_11_RTS_THRESHOLD			lRtsThre = RTS_MAX;
	NDIS_802_11_FRAGMENTATION_THRESHOLD	lFragThre = 0;
	NDIS_802_11_TX_POWER_LEVEL			lTransPower = 100;
	RT_802_11_PREAMBLE					enumPreamType = Rt802_11PreambleLong;
	
	Set_OID_802_11_TX_ANTENNA_SELECTED(Socket_Id, Device_Name, &lAntenna);
	Set_OID_802_11_RX_ANTENNA_SELECTED(Socket_Id, Device_Name, &lAntenna);
	
	aryRates[0] = 0x16 | 0x80;
	aryRates[1] = 0x0b | 0x80;
	aryRates[2] = 0x04 | 0x80;
	aryRates[3] = 0x02 | 0x80;
	Set_OID_802_11_DESIRED_RATES(Socket_Id, Device_Name, &aryRates);	
	Set_OID_802_11_SET_PREAMBLE(Socket_Id, Device_Name, &enumPreamType);
	Set_OID_802_11_TX_POWER_LEVEL(Socket_Id, Device_Name, &lTransPower);
	Set_OID_802_11_RTS_THRESHOLD(Socket_Id, Device_Name, &lRtsThre);
	Set_OID_802_11_FRAGMENTATION_THRESHOLD(Socket_Id, Device_Name, &lFragThre);
	if(enumInfrastructureMode == Ndis802_11Infrastructure)
	{
		Set_OID_802_11_POWER_MODE(Socket_Id, Device_Name, &enumPSMode);
	}
	return TRUE;
}

void RaConfigForm::NetworkListView_doubleClicked()
{
	m_Connect();	
}

void RaConfigForm::ProfileListView_doubleClicked()
{	
	ActiveProfile();
}

void RaConfigForm::MacSetPushButton_clicked()
{
	RT_802_11_HARDWARE_REGISTER hardwareRegister;
	char tmp[20];
	QString text;
	
	hardwareRegister.HardwareType = REGISTER_TYPE_MAC;
	text=MacOffsetLineEdit->text();
	sprintf(tmp, "%s", text.ascii());
	sscanf(tmp, "%lx", &hardwareRegister.Offset);	
	text=MacValueLineEdit->text();
	sprintf(tmp, "%s", text.ascii());
	sscanf(tmp, "%lx", &hardwareRegister.Data);	
	
	Set_RT_OID_802_11_SET_HARDWARE_REGISTER(Socket_Id, Device_Name, &hardwareRegister);
}

void RaConfigForm::MacQueryPushButton_clicked()
{
	RT_802_11_HARDWARE_REGISTER hardwareRegister;
	char tmp[20];
	QString text;
	
	hardwareRegister.HardwareType = REGISTER_TYPE_MAC;
	text=MacOffsetLineEdit->text();
	sprintf(tmp, "%s", text.ascii());
	sscanf(tmp, "%lx", &hardwareRegister.Offset);	
	
	Get_RT_OID_802_11_QUERY_HARDWARE_REGISTER(Socket_Id, Device_Name, &hardwareRegister);
	text.sprintf("%08lx", hardwareRegister.Data);
	MacValueLineEdit->setText(text);
}

void RaConfigForm::BBPSetPushButton_clicked()
{
	RT_802_11_HARDWARE_REGISTER hardwareRegister;
	char tmp[20];
	QString text;
	
	hardwareRegister.HardwareType = REGISTER_TYPE_BBP;
	text=BBPIDLineEdit->text();
	sprintf(tmp, "%s", text.ascii());
	sscanf(tmp, "%lx", &hardwareRegister.Offset);	 
	text=BBPValueLineEdit->text();
	sprintf(tmp, "%s", text.ascii());
	sscanf(tmp, "%lx", &hardwareRegister.Data);	 
	
	Set_RT_OID_802_11_SET_HARDWARE_REGISTER(Socket_Id, Device_Name, &hardwareRegister);
}

void RaConfigForm::BBPQueryPushButton_clicked()
{
	RT_802_11_HARDWARE_REGISTER hardwareRegister;
	char tmp[20];
	QString text;
	
	hardwareRegister.HardwareType = REGISTER_TYPE_BBP;
	text=BBPIDLineEdit->text();
	sprintf(tmp, "%s", text.ascii());
	sscanf(tmp, "%lx", &hardwareRegister.Offset);	 
	Get_RT_OID_802_11_QUERY_HARDWARE_REGISTER(Socket_Id, Device_Name, &hardwareRegister);
	text.sprintf("%02lx", hardwareRegister.Data);
	BBPValueLineEdit->setText(text);
}

void RaConfigForm::RFSetPushButton_clicked()
{
	RT_802_11_HARDWARE_REGISTER hardwareRegister;
	char tmp[20];
	QString text;
	
	hardwareRegister.HardwareType = REGISTER_TYPE_RF;
	hardwareRegister.Offset = 0;
	text=RFValueLineEdit->text();
	sprintf(tmp, "%s", text.ascii());
	sscanf(tmp, "%lx", &hardwareRegister.Data);	 
	Set_RT_OID_802_11_SET_HARDWARE_REGISTER(Socket_Id, Device_Name, &hardwareRegister);
}

void RaConfigForm::AddToProfilePushButton_clicked()
{
	QListViewItem *Item;
	QString  str;
	DBGPRINT(RT_DEBUG_TRACE, ("Click AddToProfilePushButton"));
	
	if(NetworkListView->childCount()==0)
	{
		QMessageBox::warning(this, "Warning", "No Selected Item!");
		return;
	}
	Item = NetworkListView->currentItem();	
	if(Item == NULL)
	{
		QMessageBox::warning(this, "Warning", "No Selected Item!");
		return ;
	}	
	str = Item->text(1);
	DBGPRINT(RT_DEBUG_TRACE, ("Add to Profile[BSSID=%s]", str.ascii()));
	AddForm  *addForm = new AddForm(Socket_Id, Device_Name, this, "TEST", PROFILE_ADD, ProfileListView, TRUE, str.ascii() );
	addForm->exec();	
	if( addForm->m_IsAddToProfile())
	{
		DBGPRINT(RT_DEBUG_TRACE, ("Change Page to Profile."));
		TabWidget3->setCurrentPage(0);
	}
	else
		m_Rescan();
	m_SaveConfig();    //Save config profile to rt2400.pro
}

void RaConfigForm::RadioPushButton_clicked()
{
	bool tmpbRadio;
	
	tmpbRadio = !m_bRadio;
	
	if(Set_RT_OID_802_11_SET_RADIO(Socket_Id, Device_Name, &tmpbRadio) < 0)
	{//Set failed.
		DBGPRINT(RT_DEBUG_TRACE, ("Set Radio failed[Radio %s]", tmpbRadio ? "On":"Off"));
		return;
	}
	
	killTimer(timerId_refresh);
	timerId_refresh = -1;
	killTimer(timerId_sitesurvey);
	timerId_sitesurvey = -1;
	killTimer(timerId_connected);
	timerId_connected = -1;
	
	ConnectPushButton->setEnabled(FALSE);
	RescanPushButton->setEnabled(FALSE);
	AddToProfilePushButton->setEnabled(FALSE);
	RadioPushButton->setEnabled(TRUE);	
	
	m_bRadio = !m_bRadio;
	if(m_bRadio)
	{ 
		RadioPushButton->setText( trUtf8( "Radio &Off" ) );
		RadioTextLabel->setPixmap( uic_load_pixmap_RaConfigForm( "radioon.png" ) );
	}
	else
	{
		RadioPushButton->setText( trUtf8( "Radio &On" ) );
		RadioTextLabel->setPixmap( uic_load_pixmap_RaConfigForm( "radiooff.png" ) );
	}
	
	Set_OID_802_11_BSSID_LIST_SCAN(Socket_Id, Device_Name);
	m_bRescan = TRUE;
	timerId_refresh = startTimer(2000); //Refresh associated icon.
}

void RaConfigForm::m_SaveConfig()
{
	char cfgdir[256];
	char cfgProfile[256];
	char cmdString[256];
	FILE *cfgProfileId;	
	PRT_PROFILE_SETTING   tmpProfileSetting;
	
	
	if(getuid() == 0)
	{//Root user.
		DBGPRINT(RT_DEBUG_INFO, ("Root User"));		
		sprintf(cfgdir, "%s", RT2460_SYSTEM_PATH);
		sprintf(cfgProfile, "%s/%s", RT2460_SYSTEM_PATH, PROFILE_FILE);		
		sprintf(cmdString, " if [ ! -d %s ] ; then mkdir -p %s ; fi ", RT2460_SYSTEM_PATH, RT2460_SYSTEM_PATH);
		system(cmdString);
	}
	else
	{
		sprintf(cfgdir, "%s%s", getenv("HOME"), RT2460_LOCAL_PATH);
		sprintf(cfgProfile, "%s%s/%s", getenv("HOME"), RT2460_LOCAL_PATH, PROFILE_FILE);
		sprintf(cmdString, " if [ ! -d %s ] ; then mkdir -p %s ; fi ", cfgdir, cfgdir);
		system(cmdString);
	}
	
	if((cfgProfileId = fopen(cfgProfile, "wb")) != NULL)
	{
		DBGPRINT(RT_DEBUG_INFO, ("Write profile settings to %s", cfgProfile));		
		tmpProfileSetting = RTMPProfile;
		while(tmpProfileSetting != NULL)
		{
			fwrite(tmpProfileSetting, sizeof(RT_PROFILE_SETTING), 1, cfgProfileId);
			tmpProfileSetting = tmpProfileSetting->Next;
		}
		fclose(cfgProfileId);
		chmod(cfgProfile, 00600);
	}
}

void RaConfigForm::m_WriteToProfile()
{
	char cfgdir[256];
	char intProfile[256];
	char cmdString[256];
	unsigned char tmpKey[255];
	FILE *intProfileId;
	RT_PROFILE_SETTING	 saveProfile;	
	PRT_PROFILE_SETTING  ptr=NULL;
	
	DBGPRINT(RT_DEBUG_INFO, ("<<WriteToProfile>>"));		
	DBGPRINT(RT_DEBUG_INFO, ("active_profile=%s", active_profile));	
	
	ProfileSetting = NULL;
	if(strcmp(active_profile, "") != 0)
	{
		ptr = RTMPProfile;
		while(ptr!=NULL)
		{
			if(strcmp(active_profile, (const char *)ptr->Profile) == 0)
				ProfileSetting = ptr;
			ptr=ptr->Next;
		}
	}
	
	if(getuid() == 0)
	{//Root user.
		DBGPRINT(RT_DEBUG_INFO, ("Root User"));		
		sprintf(cfgdir, "%s", RT2460_SYSTEM_PATH);		
		sprintf(intProfile, "%s/%s", RT2460_SYSTEM_PATH, INIT_FILE);
		sprintf(cmdString, " if [ ! -d %s ] ; then mkdir -p %s ; fi ", RT2460_SYSTEM_PATH, RT2460_SYSTEM_PATH);
		system(cmdString);
		if(ProfileSetting!=NULL)
		{			
			if((intProfileId = fopen(intProfile, "wb")) != NULL)
			{
				memcpy(&saveProfile, ProfileSetting, sizeof(RT_PROFILE_SETTING));
				DBGPRINT(RT_DEBUG_INFO, ("Write initial pramaters to %s", intProfile));		
				if( saveProfile.KeyLength == 0)
					saveProfile.KeyLength = 5;
				else
					saveProfile.KeyLength = 13;
				
				DBGPRINT(RT_DEBUG_INFO, ("saveProfile.KeyType = %d length=%d", saveProfile.KeyType, saveProfile.KeyLength));		
				if(saveProfile.KeyType == 0) 
				{//Hex type
					if( saveProfile.Key1[0] != 0x00)
					{
						AtoH((char *)saveProfile.Key1, tmpKey, saveProfile.KeyLength);
						memset(saveProfile.Key1, 0, 27);
						memcpy(saveProfile.Key1, tmpKey, saveProfile.KeyLength);
					}
					
					if( saveProfile.Key2[0] != 0x00)
					{
						AtoH((char *)saveProfile.Key2, tmpKey, saveProfile.KeyLength);
						memset(saveProfile.Key2, 0, 27);
						memcpy(saveProfile.Key2, tmpKey, saveProfile.KeyLength);
					}
					
					if( saveProfile.Key3[0] != 0x00)
					{
						AtoH((char *)saveProfile.Key3, tmpKey, saveProfile.KeyLength);
						memset(saveProfile.Key3, 0, 27);
						memcpy(saveProfile.Key3, tmpKey, saveProfile.KeyLength);
					}
					
					if( saveProfile.Key4[0] != 0x00)
					{
						AtoH((char *)saveProfile.Key4, tmpKey, saveProfile.KeyLength);
						memset(saveProfile.Key4, 0, 27);
						memcpy(saveProfile.Key4, tmpKey, saveProfile.KeyLength);
					}
				}		
				//TX_ANTENNA_SELECTED
				switch (saveProfile.AntennaTx) 
				{
				case 0:
					saveProfile.AntennaTx = 0xffffffff;
					break;
				case 1:
					saveProfile.AntennaTx = 0x00000000;
					break;
				case 2:
					saveProfile.AntennaTx = 0x00000001;
					break;
				default:
					saveProfile.AntennaTx = 0x00000001;
					break;
				}
				//RX_ANTENNA_SELECTED
				switch (saveProfile.AntennaRx) 
				{
				case 0:
					saveProfile.AntennaRx = 0xffffffff;
					break;
				case 1:
					saveProfile.AntennaRx = 0x00000000;
					break;
				case 2:
					saveProfile.AntennaRx = 0x00000001;
					break;
				default:
					saveProfile.AntennaRx = 0x00000001;
					break;
				}
				//CountryRegion.
				saveProfile.CountryRegion = CountryRegion;
				fwrite(&saveProfile, sizeof(RT_PROFILE_SETTING), 1, intProfileId);
				DBGPRINT(RT_DEBUG_INFO, ("SSID=%s", ProfileSetting->SSID));		
				fclose(intProfileId);
			}
			else
				DBGPRINT(RT_DEBUG_INFO, ("Write initial pramaters to %s failed", intProfile));		
		}
		else
		{
			DBGPRINT(RT_DEBUG_INFO, ("None Active profile, so remove file [%s]", intProfile));		
			unlink(intProfile);
		}
	}
	else
	{
		sprintf(cfgdir, "%s%s", getenv("HOME"), RT2460_LOCAL_PATH);
		sprintf(cmdString, " if [ ! -d %s ] ; then mkdir -p %s ; fi ", cfgdir, cfgdir);
		system(cmdString);
	}
	
	if(ProfileSetting != NULL)
	{
		writekeystring(Device_Name, "ProfileID", (char *)ProfileSetting->Profile, cfgdir, CONFIG_FILE);
		writekeystring(Device_Name, "SSID", (char *)ProfileSetting->SSID, cfgdir, CONFIG_FILE);
		DBGPRINT(RT_DEBUG_INFO, ("Write to config file ProfileID=%s SSID=%s", (char *)ProfileSetting->Profile, (char *)ProfileSetting->SSID));		
	}
	else
	{
		writekeystring(Device_Name, "ProfileID", "", cfgdir, CONFIG_FILE);
		writekeystring(Device_Name, "SSID", "", cfgdir, CONFIG_FILE);
		DBGPRINT(RT_DEBUG_INFO, ("Write to config file ProfileID= SSID= "));		
	}
}

