/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: sitewepdlg.cpp 
 *              
 *      Abstract: Implement WEP dialog for connection to WEP enabled AP 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      PaulL           22nd Jan 03     Created
 *      MarkW           9th  Feb 04     Baseline of code
 *      Ivo van Doorn   17th May 04     Updates to QT styles
 *	MarkW		3rd  Oct 04	Changed bit references to standard
 ***************************************************************************/ 


#include "sitewepdlg.h"
#include "qhexvalidator.h"
#include "rt_tool.h"

#include <qapplication.h>
#include <qvariant.h>
#include <qheader.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qmime.h>
#include <qdragobject.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qmessagebox.h>

static QPixmap uic_load_pixmap_SiteWepDlg( const QString &name )
{
	const QMimeSource *m = QMimeSourceFactory::defaultFactory()->data( name );

	if ( !m )
		return QPixmap();
	QPixmap pix;
	QImageDrag::decode( m, pix );
	
	return pix;
}
/* 
 *  Constructs a SiteWepDlg which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SiteWepDlg::SiteWepDlg( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
	if ( !name )
		setName( "SiteWepDlg" );
	resize( 578, 417 ); 
	setMinimumSize(578, 417); 
	setMaximumSize(578, 417); 
	setCaption( trUtf8( "Wep Setting" ) );
	setIcon( uic_load_pixmap_SiteWepDlg( "raconfig.xpm" ) );		 
	setPaletteBackgroundColor( QColor( 222, 222,  222 ) );

	// qApp->setStyle("Windows");

	Frame5 = new QFrame( this, "Frame5" );
	Frame5->setGeometry( QRect( 10, 10, 560, 350 ) ); 
	Frame5->setFrameShape( QFrame::StyledPanel );
	Frame5->setFrameShadow( QFrame::Raised );

	ButtonGroup3 = new QButtonGroup( Frame5, "ButtonGroup3" );
	ButtonGroup3->setGeometry( QRect( 20, 20, 520, 60 ) ); 
	ButtonGroup3->setTitle( trUtf8( "Authentication Setting" ) );

	TextLabel10_2 = new QLabel( ButtonGroup3, "TextLabel10_2" );
	TextLabel10_2->setGeometry( QRect( 30, 18, 130, 30 ) ); 
	TextLabel10_2->setText( trUtf8( "Authentication Type" ) );

	WepAuthenticationComboBox = new QComboBox( FALSE, ButtonGroup3, "WepAuthenticationComboBox" );
	WepAuthenticationComboBox->insertItem( trUtf8( "Open System" ) );
	WepAuthenticationComboBox->insertItem( trUtf8( "Shared Key" ) );
	WepAuthenticationComboBox->setEnabled( TRUE );
	WepAuthenticationComboBox->setGeometry( QRect( 210, 20, 280, 20 ) ); 

	ButtonGroup4 = new QButtonGroup( Frame5, "ButtonGroup4" );
	ButtonGroup4->setGeometry( QRect( 20, 110, 520, 225 ) ); 
	ButtonGroup4->setTitle( trUtf8( "WEP Key Setting" ) );

	TextLabel11_2 = new QLabel( ButtonGroup4, "TextLabel11_2" );
	TextLabel11_2->setGeometry( QRect( 30, 16, 100, 20 ) ); 
	TextLabel11_2->setText( trUtf8( "WEP key type" ) );

	TextLabel12_2 = new QLabel( ButtonGroup4, "TextLabel12_2" );
	TextLabel12_2->setGeometry( QRect( 30, 40, 100, 20 ) ); 
	TextLabel12_2->setText( trUtf8( "WEP Key Length" ) );

	WepWEPKeyTypeComboBox = new QComboBox( FALSE, ButtonGroup4, "WepWEPKeyTypeComboBox" );
	WepWEPKeyTypeComboBox->insertItem( trUtf8( "Hexadecimal" ) );
	WepWEPKeyTypeComboBox->insertItem( trUtf8( "ASCII" ) );
	WepWEPKeyTypeComboBox->setEnabled( TRUE );
	WepWEPKeyTypeComboBox->setGeometry( QRect( 210, 10, 280, 20 ) ); 

	WepWEPKeyLengthComboBox = new QComboBox( FALSE, ButtonGroup4, "WepWEPKeyLengthComboBox" );
	WepWEPKeyLengthComboBox->insertItem( trUtf8( " 64 Bits" ) );
	WepWEPKeyLengthComboBox->insertItem( trUtf8( "128 Bits" ) );
	WepWEPKeyLengthComboBox->setEnabled( TRUE );
	WepWEPKeyLengthComboBox->setGeometry( QRect( 210, 40, 280, 20 ) ); 

	ButtonGroup5_2 = new QButtonGroup( ButtonGroup4, "ButtonGroup5_2" );
	ButtonGroup5_2->setGeometry( QRect( 20, 66, 480, 145 ) ); 
	ButtonGroup5_2->setTitle( trUtf8( "WEP KEY" ) );

	WepKey1RadioButton = new QRadioButton( ButtonGroup5_2, "WepKey1RadioButton" );
	WepKey1RadioButton->setEnabled( TRUE );
	WepKey1RadioButton->setGeometry( QRect( 30, 20, 110, 20 ) ); 
	WepKey1RadioButton->setText( trUtf8( "Key  #1" ) );
	WepKey1RadioButton->setChecked( TRUE );
	ButtonGroup5_2->insert( WepKey1RadioButton, 0 );

	WepKey2RadioButton = new QRadioButton( ButtonGroup5_2, "WepKey2RadioButton" );
	WepKey2RadioButton->setEnabled( TRUE );
	WepKey2RadioButton->setGeometry( QRect( 30, 50, 110, 20 ) ); 
	WepKey2RadioButton->setText( trUtf8( "Key  #2" ) );
	ButtonGroup5_2->insert( WepKey2RadioButton, 1 );

	WepKey3RadioButton = new QRadioButton( ButtonGroup5_2, "WepKey3RadioButton" );
	WepKey3RadioButton->setEnabled( TRUE );
	WepKey3RadioButton->setGeometry( QRect( 30, 80, 110, 20 ) ); 
	WepKey3RadioButton->setText( trUtf8( "Key  #3" ) );
	ButtonGroup5_2->insert( WepKey3RadioButton, 2 );

	WepKey4RadioButton = new QRadioButton( ButtonGroup5_2, "WepKey4RadioButton" );
	WepKey4RadioButton->setEnabled( TRUE );
	WepKey4RadioButton->setGeometry( QRect( 30, 110, 110, 20 ) ); 
	WepKey4RadioButton->setText( trUtf8( "Key  #4" ) );
	ButtonGroup5_2->insert( WepKey4RadioButton, 3 );

	WepKey1LineEdit = new QLineEdit( ButtonGroup5_2, "WepKey1LineEdit" );
	WepKey1LineEdit->setEnabled( TRUE );
	WepKey1LineEdit->setGeometry( QRect( 220, 20, 240, 22 ) ); 

	WepKey2LineEdit = new QLineEdit( ButtonGroup5_2, "WepKey2LineEdit" );
	WepKey2LineEdit->setEnabled( TRUE );
	WepKey2LineEdit->setGeometry( QRect( 220, 50, 240, 22 ) ); 

	WepKey3LineEdit = new QLineEdit( ButtonGroup5_2, "WepKey3LineEdit" );
	WepKey3LineEdit->setEnabled( TRUE );
	WepKey3LineEdit->setGeometry( QRect( 220, 80, 240, 22 ) ); 

	WepKey4LineEdit = new QLineEdit( ButtonGroup5_2, "WepKey4LineEdit" );
	WepKey4LineEdit->setEnabled( TRUE );
	WepKey4LineEdit->setGeometry( QRect( 220, 110, 240, 22 ) ); 

	WepOkPushButton = new QPushButton( this, "WepOkPushButton" );
	WepOkPushButton->setGeometry( QRect( 150, 370, 90, 22 ) ); 
	WepOkPushButton->setText( trUtf8( "&Ok" ) );

	WepCancelPushButton = new QPushButton( this, "WepCancelPushButton" );
	WepCancelPushButton->setGeometry( QRect( 350, 370, 90, 22 ) ); 
	WepCancelPushButton->setText( trUtf8( "&Cancel" ) );

	hexValidator = new QHexValidator(this);	
	WepKey1LineEdit->setValidator(hexValidator);
	WepKey2LineEdit->setValidator(hexValidator);
	WepKey3LineEdit->setValidator(hexValidator);
	WepKey4LineEdit->setValidator(hexValidator);

	if(WepWEPKeyTypeComboBox->currentItem() == 0)
	{//hex
		if(WepWEPKeyLengthComboBox->currentItem() == 0)
		{//40bits
			WepKey1LineEdit->setMaxLength(10);		
			WepKey2LineEdit->setMaxLength(10);		
			WepKey3LineEdit->setMaxLength(10);		
			WepKey4LineEdit->setMaxLength(10);		
		}
		else
		{
			WepKey1LineEdit->setMaxLength(26);		
			WepKey2LineEdit->setMaxLength(26);		
			WepKey3LineEdit->setMaxLength(26);		
			WepKey4LineEdit->setMaxLength(26);		
		}
	}
	else
	{
		if(WepWEPKeyLengthComboBox->currentItem() == 0)
		{//40bits
			WepKey1LineEdit->setMaxLength(5);		
			WepKey2LineEdit->setMaxLength(5);		
			WepKey3LineEdit->setMaxLength(5);		
			WepKey4LineEdit->setMaxLength(5);		
		}
		else
		{
			WepKey1LineEdit->setMaxLength(13);		
			WepKey2LineEdit->setMaxLength(13);		
			WepKey3LineEdit->setMaxLength(13);		
			WepKey4LineEdit->setMaxLength(13);		
		}
	}

	connect( WepOkPushButton, SIGNAL( clicked() ), this, SLOT( WepOkPushButton_Click() ) );
	connect( WepCancelPushButton, SIGNAL( clicked() ), this, SLOT( WepCancelPushButton_Click() ) );
 	connect( WepWEPKeyLengthComboBox, SIGNAL( activated(int) ), this, SLOT( WepWEPKeyLengthComboBox_activated(int) ) );
	connect( WepWEPKeyTypeComboBox, SIGNAL( activated(int) ), this, SLOT( WepWEPKeyTypeComboBox_activated(int) ) );
	
	isWepOk = FALSE;
}

/*  
 *  Destroys the object and frees any allocated resources
 */
SiteWepDlg::~SiteWepDlg()
{
    // no need to delete child widgets, Qt does it all for us
}

void SiteWepDlg::WepOkPushButton_Click()
{
	QString str;
	unsigned int length;

	if(WepWEPKeyTypeComboBox->currentItem() == 0)
	{//hex
		if(WepWEPKeyLengthComboBox->currentItem() == 0) 
			length=10; //40bits
		else
			length=26;
	}
	else
	{
		if(WepWEPKeyLengthComboBox->currentItem() == 0) 
			length=5; //40bits
		else
			length=13;
	}

	switch(ButtonGroup5_2->id(ButtonGroup5_2->selected()))
	{
		case 0:
				str=WepKey1LineEdit->text();
				if(str.length() != length)
				{
					QMessageBox::warning(this, "Warning", "KEY#1: Invalid WEP key length!");					
					return;
				}
				break;
		case 1:
				str=WepKey2LineEdit->text();
				if(str.length() != length)
				{
					QMessageBox::warning(this, "Warning", "KEY#2: Invalid WEP key length!");
					return;
				}
				break;
		case 2: 
				str=WepKey3LineEdit->text();
				if(str.length() != length)
				{
					QMessageBox::warning(this, "Warning", "KEY#3: Invalid WEP key length!");
					return;
				}
				break;
		case 3:
				str=WepKey4LineEdit->text();
				if(str.length() != length)
				{
					QMessageBox::warning(this, "Warning", "KEY#4: Invalid WEP key length!");
					return;
				}
				break;
		default :
				break;
	}
		
	isWepOk = TRUE;
	close();
}

void SiteWepDlg::WepCancelPushButton_Click()
{
	close();
}

void SiteWepDlg::EncryptionCheckBox_toggled(bool flag)
{
	if(flag)
	{
		WepAuthenticationComboBox->setEnabled( TRUE );
		WepWEPKeyTypeComboBox->setEnabled( TRUE );
		WepWEPKeyLengthComboBox->setEnabled( TRUE );
		WepKey1RadioButton->setEnabled( TRUE );
		WepKey2RadioButton->setEnabled( TRUE );
		WepKey3RadioButton->setEnabled( TRUE );
		WepKey4RadioButton->setEnabled( TRUE );
		WepKey1LineEdit->setEnabled( TRUE );
		WepKey2LineEdit->setEnabled( TRUE );
		WepKey3LineEdit->setEnabled( TRUE );
		WepKey4LineEdit->setEnabled( TRUE );
	}
	else
	{
		WepAuthenticationComboBox->setCurrentItem(0); //Open System.
		WepAuthenticationComboBox->setEnabled( FALSE );
		WepWEPKeyTypeComboBox->setEnabled( FALSE );
		WepWEPKeyLengthComboBox->setEnabled( FALSE );
		WepKey1RadioButton->setEnabled( FALSE );
		WepKey2RadioButton->setEnabled( FALSE );
		WepKey3RadioButton->setEnabled( FALSE );
		WepKey4RadioButton->setEnabled( FALSE );
		WepKey1LineEdit->setEnabled( FALSE );
		WepKey2LineEdit->setEnabled( FALSE );
		WepKey3LineEdit->setEnabled( FALSE );
		WepKey4LineEdit->setEnabled( FALSE );
	}
}

void SiteWepDlg::WepWEPKeyLengthComboBox_activated(int id)
{
	if(id == 0) 
	{//40		
		if(WepWEPKeyTypeComboBox->currentItem() == 0)
		{//hex
			WepKey1LineEdit->setMaxLength(10);
			WepKey2LineEdit->setMaxLength(10);
			WepKey3LineEdit->setMaxLength(10);
			WepKey4LineEdit->setMaxLength(10);
		}
		else
		{//ascii
			WepKey1LineEdit->setMaxLength(5);
			WepKey2LineEdit->setMaxLength(5);
			WepKey3LineEdit->setMaxLength(5);
			WepKey4LineEdit->setMaxLength(5);
		}
	}
	else
	{ //104 bits
		if(WepWEPKeyTypeComboBox->currentItem() == 0)
		{//hex
			WepKey1LineEdit->setMaxLength(26);
			WepKey2LineEdit->setMaxLength(26);
			WepKey3LineEdit->setMaxLength(26);
			WepKey4LineEdit->setMaxLength(26);
		}
		else
		{//ascii
			WepKey1LineEdit->setMaxLength(13);
			WepKey2LineEdit->setMaxLength(13);
			WepKey3LineEdit->setMaxLength(13);
			WepKey4LineEdit->setMaxLength(13);
		}
	}
}

void SiteWepDlg::WepWEPKeyTypeComboBox_activated(int id)
{
	if(id==0) 
	{//Hex		
		DBGPRINT(RT_DEBUG_TRACE, ("Set WEPKEY_HEXTYPE\n"));
		WepKey1LineEdit->setValidator(hexValidator);
		WepKey2LineEdit->setValidator(hexValidator);
		WepKey3LineEdit->setValidator(hexValidator);
		WepKey4LineEdit->setValidator(hexValidator);
		if(WepWEPKeyLengthComboBox->currentItem()==0)
		{//40 bits
			WepKey1LineEdit->setMaxLength(10);
			WepKey2LineEdit->setMaxLength(10);
			WepKey3LineEdit->setMaxLength(10);
			WepKey4LineEdit->setMaxLength(10);
		}
		else
		{//104 bits
			WepKey1LineEdit->setMaxLength(26);
			WepKey2LineEdit->setMaxLength(26);
			WepKey3LineEdit->setMaxLength(26);
			WepKey4LineEdit->setMaxLength(26);
		}
	}
	else
	{
		DBGPRINT(RT_DEBUG_TRACE, ("set WEPKEY_ASCIITYPE"));
		WepKey1LineEdit->clearValidator();
		WepKey2LineEdit->clearValidator();
		WepKey3LineEdit->clearValidator();
		WepKey4LineEdit->clearValidator();
		if(WepWEPKeyLengthComboBox->currentItem()==0)
		{//40 bits
			WepKey1LineEdit->setMaxLength(5);
			WepKey2LineEdit->setMaxLength(5);
			WepKey3LineEdit->setMaxLength(5);
			WepKey4LineEdit->setMaxLength(5);
		}
		else
		{//104 bits
			WepKey1LineEdit->setMaxLength(13);
			WepKey2LineEdit->setMaxLength(13);
			WepKey3LineEdit->setMaxLength(13);
			WepKey4LineEdit->setMaxLength(13);
		}
	}
	WepKey1LineEdit->clear();
	WepKey2LineEdit->clear();
	WepKey3LineEdit->clear();
	WepKey4LineEdit->clear();
}


int	 SiteWepDlg::Get_Wep_KeyID()
{
	return (ButtonGroup5_2->id(ButtonGroup5_2->selected()));
}

int  SiteWepDlg::Get_Wep_KeyLength()
{
	if(WepWEPKeyLengthComboBox->currentItem()==0)
		return (0);
	else
		return (1);
}

int  SiteWepDlg::Get_Wep_KeyType()
{
	if(WepWEPKeyTypeComboBox->currentItem() == 0) 
		return (0); //Hex
	else
		return (1); //Ascii
}


const char *SiteWepDlg::Get_Wep_KeyString(int index)
{
	QString str;

	switch (index)
	{
		case 0:
			str = WepKey1LineEdit->text();
			return str.ascii();
		case 1:
			str = WepKey2LineEdit->text();
			return str.ascii();
		case 2:
			str = WepKey3LineEdit->text();
			return str.ascii();
		case 3:
			str = WepKey4LineEdit->text();
			return str.ascii();
	}
	
	return NULL;
}

void SiteWepDlg::m_ChangeAuthType(int type)   //0: open system,  1: shared key
{
	if(type == 0)
		WepAuthenticationComboBox->setCurrentItem(0);
	else
		WepAuthenticationComboBox->setCurrentItem(1);
}

void SiteWepDlg::m_EnableAuthType(bool bFlag)
{
	WepAuthenticationComboBox->setEnabled( bFlag );	
}

int SiteWepDlg::m_GetWepAuthenType()
{
	return (WepAuthenticationComboBox->currentItem());	        
}

bool SiteWepDlg::m_IsClickWepOkButton()
{
	return (isWepOk);
}

