<?php

require_once 'Horde/Form/Renderer.php';

/**
 * Turba Form Renderer
 *
 * $Horde: turba/lib/Renderer.php,v 1.19 2004/11/24 17:30:14 jan Exp $
 *
 * @package Turba
 */
class Turba_Renderer extends Horde_Form_Renderer {

    var $_active = false;
    var $_object;

    function setObject(&$object)
    {
        $this->_object = &$object;
    }

    function beginActive($name)
    {
        $this->_active = true;
        parent::beginActive($name);
    }

    function beginInactive($name)
    {
        $this->_active = false;
        parent::beginInactive($name);
    }

    function _sectionHeader($title)
    {
?><div class="header">
<?php
if (!$this->_active && is_a($this->_object, 'Turba_AbstractObject')) {
    $edit = Turba::hasPermission($this->_object, 'object', PERMS_EDIT);
    $delete = Turba::hasPermission($this->_object, 'object', PERMS_DELETE);
    if ($edit || $delete) {
        $url = Util::addParameter('', 'source', $this->_object->driver->name);
        $url = Util::addParameter($url, 'key', $this->_object->getValue('__key'));
?>
 <span class="smallheader" style="float:right">
  <?php if ($edit) echo Horde::link(Horde::applicationUrl('edit.php' . $url), _("Edit")) . _("Edit") ?></a>
  <?php if ($edit && $delete) echo ' | ' ?>
  <?php if ($delete) echo Horde::link(Horde::applicationUrl('delete.php' . $url), _("Delete")) . _("Delete") ?></a>
 </span>
<?php   }
    } ?>
 <?php echo htmlspecialchars($title) ?>
</div><?php
    }

}
