#!/bin/env python
#---------------------------------------------------------------------------
# This script generates a template that can be used in the Python
# build process (on posix systems) in order to staticly link the
# wxPython modules into the Python executable.  The output of this
# script should be put into a file named Setup.local (or perhaps just
# concatenated to Setup) in the Modules dir of the Python source
# distribution, then just build Python like normal.
#
# You can use any of the command-line args that setup.py understands
# with this script too in order to control what modules are built and
# which compile options and such are used.
#
# This script must be run from the wxPython directory.
#---------------------------------------------------------------------------


import sys, os, re

# if you need to change some setup.py flags do it here before it is
# imported.  Just append to sys.argv.
sys.argv.append("BUILD_GLCANVAS=0")
sys.argv.append("BUILD_OGL=0")
sys.argv.append("BUILD_DLLWIDGET=0")
#sys.argv.append("CORE_ONLY=1")

import setup


def printitem(st):
    if st:
        print '\\\n\t', st,


def buildflags(items, flag, path=None):
    st = ''
    for item in items:
        if path is not None and item[0] != '/':
            item = os.path.join(path, item)
        st += "%s%s " % (flag, item)
    return st


def buildmacros(items):
    st = ''
    for item in items:
        if len(item) == 1:
            st += "-U%s " % item[0]
        elif item[1] is None:
            st += "-D%s " % item[0]
        else:
            st += "-D%s=%s " % item
    return st


# Python's makesetup can't handle -D flags with = in them, so we need to workaround
def fixmacros(st):
    defs = []
    pat = re.compile(r'-D([A-Za-z0-9_]*)=([A-Za-z0-9_]*)')
    match = pat.search(st)
    while match is not None:
        name = match.group(1)
        value = match.group(2)
        defs.append("m_%s = -D%s=%s" % (name, name, value))
        st = st[:match.start()] + ("$(m_%s)" % name) +  st[match.end():]
        match = pat.search(st)

    return st, defs



def main():
    cwd = os.getcwd()

    print """\
# This file is autogenerated by %s and should be
# placed in the <PythonDist>/Modules/Setup.local file before
# Python is built.

*static*

""" % sys.argv[0]

    for ext in setup.wxpExtensions:
        eca = " ".join(ext.extra_compile_args)
        macros =  buildmacros(ext.define_macros)

        eca, defs = fixmacros(eca)
        print "\n".join(defs)
        macros, defs = fixmacros(macros)
        print "\n".join(defs)

        print ext.name,
        for s in ext.sources:
            printitem(os.path.join(cwd, s))
        printitem(buildflags(ext.include_dirs, '-I', cwd))
        printitem(buildflags(ext.library_dirs, '-L'))
        printitem(buildflags(ext.libraries, '-l'))
        printitem(macros)
        printitem(eca)
        # filter out some options that makesetup can't handle, but it shouldn't hurt to remove these...
        ela = filter(lambda x: x not in ['-pthread', '-rdynamic'], ext.extra_link_args)
        printitem(" ".join(ela))

        print; print; print



if __name__ == "__main__":
    main()

