# Makefile for zgv binary distribution

# Set BINDIR to directory for binaries,
# INFODIR to directory for info files,
# MANDIR to directory for man page.
# Usually it will be simpler to just set PREFIX.
#
PREFIX=/usr

# uncomment this to use the FHS-friendly info/man locations
# /usr/share/info and /usr/share/man/man1, rather than the traditional
# /usr/info and /usr/man/man1.
#
# (This default is the opposite of that in the source distribution,
# since the traditional setup is less likely to cause trouble in the
# general case.)
#
#SHARE_INFIX=/share

BINDIR=$(PREFIX)/bin
INFODIR=$(PREFIX)$(SHARE_INFIX)/info
MANDIR=$(PREFIX)$(SHARE_INFIX)/man/man1

# Normally `make install' will update your `dir' file (in INFODIR),
# using a copy of texinfo's `install-info' bundled with zgv.
#
# But if you have a different way of keeping `dir' up-to-date (for
# example, perhaps your distribution automatically handles this for
# you) you should uncomment this to prevent `make install' doing that.
#
# If you don't know what to do, leave it as-is.
#
#INFO_DIR_UPDATE=no


# You shouldn't need to modify anything below this line.


all: install

install:
	install -m 4755 -o root -g root -s zgv $(BINDIR)
	install -m 644 doc/zgv.1 $(MANDIR)
	install -m 644 doc/zgv doc/zgv-? $(INFODIR)
# Update info `dir' file
# Info always uses a dir file in preference to a dir.gz, so we don't use
# dir.gz unless it's the only game in town.
ifneq ($(INFO_DIR_UPDATE),no)
	if [ -f $(INFODIR)/dir.gz -a ! -f $(INFODIR)/dir ]; then \
	  gzip -d $(INFODIR)/dir.gz; \
	  ./install-info doc/zgv $(INFODIR)/dir; \
	  gzip $(INFODIR)/dir; \
	else \
	  ./install-info doc/zgv $(INFODIR)/dir; \
	fi
endif

# can't easily fix dir :-/, but do remove the files.
# explicitly removes /usr/man/man1/zgv.1* and /usr/info/zgv*
# in case of old installation.
uninstall:
	$(RM) $(BINDIR)/zgv
	$(RM) $(MANDIR)/zgv.1*
	$(RM) /usr/man/man1/zgv.1*
	$(RM) $(INFODIR)/zgv*
	$(RM) /usr/info/zgv*
