// -*- C++ -*-
/* This file is part of*
 * ======================================================
 *
 *           LyX, The Document Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/

#ifndef _INSET_LATEX_DEL_H
#define _INSET_LATEX_DEL_H

#ifdef __GNUG__
#pragma interface
#endif

#include "lyxinset.h"
#include "LString.h"

/** LatexDel's are deletable latex-insets inserted automatically

  Used for SGML-labels, cross references, URLs, html,
  optional hyphenation points, lists of figures, lists of tables
  and table of contents. They are drawn in a grey box with
  the LaTeX- or SGML-code in red, except hyphenation points which are
  drawn as a small red circle. Deletable means that these can be deleted 
  with the normal delete/backspace operation. */
class InsetLatexDel: public Inset {
public:
	///
	InsetLatexDel();
	///
	InsetLatexDel(LString const & string);
	///
	~InsetLatexDel();
	///
	int Ascent(LyXFont const &font) const;
	///
	int Descent(LyXFont const &font) const;
	///
	int Width(LyXFont const &font) const;
	///
	void Draw(LyXFont font, LyXScreen &scr, int baseline, float &x);
	///
	void Write(FILE *file);
	///
	void Read(LyXLex &lex);
	///
	int Latex(FILE *file, signed char fragile);
	///
	int Latex(LString &file, signed char fragile);
	///
	bool Deletable() const;
	///
	Inset* Clone();
	///
	Inset::Code LyxCode() const; 
private:
	///
	LString contents;
};

#endif
