/*
 * Copyright (C) 1996,1997 Michael R. Elkins <me@cs.hmc.edu>
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */ 

#include "mutt.h"
#include "mutt_curses.h"
#include "mutt_menu.h"

#include <string.h>
#include <stdlib.h>
#include <unistd.h>

int mutt_extract_url (HEADER *hdr, LIST **urls)
{
  STATE s;
  FILE *fp;
  LIST *lptr = NULL;
  char temp[_POSIX_PATH_MAX];
  char buf[LONG_STRING];
  char buf2[LONG_STRING];
  MESSAGE *msg;
  regmatch_t match[1];
  size_t l;
  int n = 0;

  mutt_parse_mime_message (hdr);

  memset (&s, 0, sizeof (s));

  mutt_mktemp (temp);
  if ((s.fpout = safe_fopen (temp, "w")) == NULL)
  {
    mutt_perror (temp);
    return (-1);
  }

  if ((msg = mx_open_message (Context, hdr->msgno)) == NULL)
  {
    fclose (s.fpout);
    unlink (temp);
    return (-1);
  }

#ifdef _PGPPATH
  unset_option (OPTVERIFYSIG);
#endif

  s.fpin = msg->fp;
  mutt_copy_header (msg->fp, hdr, s.fpout,
		    (option (OPTWEED) ? CH_WEED : 0) | CH_DECODE);
  mutt_body_handler (hdr->content, &s);
  fclose (s.fpout);
  mx_close_message (&msg);

  if ((fp = fopen (temp, "r")) == NULL)
  {
    mutt_perror (temp);
    unlink (temp);
    return (-1);
  }

  buf[sizeof (buf) - 1] = 0;

  while (fgets (buf, sizeof (buf) - 1, fp) != NULL)
  {
    l = 0;
    while (regexec ((regex_t *) UrlRegexp.rx, buf + l, 1, match, (l ? REG_NOTBOL : 0)) == 0)
    {
      match[0].rm_so += l;
      match[0].rm_eo += l;
      l = match[0].rm_eo - match[0].rm_so;

      if (l)
      {
	if (l > sizeof (buf2) - 1) l = sizeof (buf2) - 1;
	memcpy (buf2, buf + match[0].rm_so, l);
	buf2[l] = 0;

	if (*urls == NULL) /* first url found */
	{
	  *urls = (LIST *) safe_malloc (sizeof (LIST));
	  lptr = *urls;
	}
	else /* second url and more */
	{
	  lptr->next = (LIST *) safe_malloc (sizeof (LIST));
	  lptr = lptr->next;
	}

	lptr->data = safe_strdup (buf2);
	lptr->next = NULL;
	n++;

	l = match[0].rm_eo;
      }
      else
	l = match[0].rm_eo + 1; /* avoid degenerate cases */
      if (!buf[l])
	break;
    }
  }

  fclose (fp);
  mutt_unlink (temp);
  return (n);
}

void url_make_entry (char *s, size_t size, MUTTMENU *m, int num)
{  
  char **url_table = (char **) m->data;

  snprintf (s, size, "%2d   %-50s", num+1, url_table[num]);
}

void mutt_browse_url (HEADER *hdr)
{
  LIST *urls = NULL;
  LIST *url_ptr;
  MUTTMENU *menu;
  char **url_table; 
  int i, urlmax, done = 0;
  char buf[STRING] = "";
  char cmd[LONG_STRING];
  char helpstr[SHORT_STRING];

  switch (mutt_extract_url (hdr, &urls))
  {
    case 0:
      mutt_error ("No URLs found.");
      /* fall through! */

    case -1:
      return;
  }

  for (urlmax = 0, url_ptr = urls; url_ptr; url_ptr = url_ptr->next, urlmax++);
  url_table = (char **) safe_malloc (sizeof (char *) * (urlmax+1));
  url_table[urlmax] = 0;
  for (i=0, url_ptr = urls; url_ptr; url_ptr = url_ptr->next, i++)
    url_table[i] = url_ptr->data;

  menu = mutt_new_menu ();
  menu->max = urlmax;
  menu->make_entry = url_make_entry;
  menu->menu = MENU_URL;
  menu->title = "URL";
  menu->data = url_table;

  helpstr[0] = 0;
  mutt_make_help (buf, sizeof (buf), "Exit  ", MENU_URL, OP_EXIT);
  strcat (helpstr, buf);
  mutt_make_help (buf, sizeof (buf), "Display  ", MENU_URL, OP_GENERIC_SELECT_ENTRY);
  strcat (helpstr, buf);
  mutt_make_help (buf, sizeof (buf), "Help", MENU_URL, OP_HELP);
  strcat (helpstr, buf);
  menu->help = helpstr;

  while (!done)
  {
    switch (mutt_menuLoop (menu))
    {
      case OP_GENERIC_SELECT_ENTRY:

	strfcpy (buf, url_table[menu->current], sizeof (buf));
	if (ci_get_field ("Browse URL: ", buf, sizeof (buf), 0) == 0 && buf[0])
	{
	  endwin ();
	  mutt_expand_fmt (cmd, sizeof (cmd), WebBrowser, buf);
	  mutt_system (cmd);
	}
	break;

      case OP_EXIT:

	done = 1;
	break;
    }
  }
  mutt_menuDestroy (&menu);
  safe_free ((void **) &url_table);
  mutt_free_list (&urls);
  return;
}
