.\" $Id: isdnrep.man,v 1.1 1997/09/04 11:34:17 aj Exp $
.\" CHECKIN $Date: 1997/09/04 11:34:17 $
.TH isdnrep 8 "@MANDATE@" "ISDN 4 Linux @I4LVERSION@" "Linux System Administration"

.PD 0
.SH NAME
isdnrep \- report isdn activity

.SH DESCRIPTION
Isdnrep reads the isdnlog log files, generates reports, does statistics,
and other things. It can also generate HTML output for use with a web
server.

.SH OPTIONS
.TP
.B \-V
show version information and exit.

.TP
.B \-a	all
Show all connections registered. If this option is
not given, show only the connections made today.

.TP
.B \-h	no header
There will be no header for each day, nor will the summary at the end
of each day and at the end of the report be generated. This is useful
if the output is to be processed by another program.
.br
This option doesn't work if the
.B \-wX
is also given.

.TP
.B \-n	numbers
Display numbers instead of the aliases for those numbers.

.TP
.B -c zone	compute="zone"
This option can be used to define which default zone unknown called
numbers ("calling ?") are in, if no AOC-E (advice of charge at end of call)
messages are received. This way isdnrep "guesses" what the cost of the
call was.

Values for "zone" may be:

.RS
.TP 4
0
don't calculate anything, assign zero cost to these unknown calls
.TP
1
assume "city zone"
.TP
2
assume "regio-50 zone"
.TP
3
assume "regio-200 zone"
.TP
4
assume long distance
.RE

.TP
.B \-fFILE
The file from which to generate the report. This is usually
/var/log/isdn.log, or whatever is configured in /etc/isdn/isdn.conf as
.B LOGFILE = .
The -f option will override the setting in /etc/isdn/isdn.conf.

.TP
.B \-t time span	time="time span"
With this option a specific time span covered by the log file can be
displayed, e.g. all calls in November 1995, or on January 3rd 1996
between 03:00 and 09:45.

The format in which times are given is described below.
The time span has the following syntax:

.RS
.TP 10
time-time
display from begin time up to end time
.TP
time-
display from given time up to "now"
.TP
-time
display from beginning of log file up to given time
.TP
time
display the given month, day, hour, ...
.RE


.TP
.B \-d -time	delete="time"
Delete entries from the log file up to (but not including) the specified
time. The format is the same as for the -t option.
The minus before the time
.B must
be given! It is not possible to define begin and end times; entries are
always deleted from the beginning up to the time given.

.B Warning!
Entries are
.B really
deleted from the file. Careless use can result in all entries being
deleted, e.g. with "isdnrep -d -".

.TP
.B \-v	verbose
Display all connections and connection attempts. Without this option,
only successful connections are displayed.

.TP
.B \-p [n][m]'number'[,[m]'number'...]	phonenumber
Display only selected phone numbers.

"number" is specified in the same format as in configuration files
(see isdn.conf(5)). E.g. wildcards can be used.

If the flag 'm' is given, the corresponding MSN is meant.
E.g.: "m2" means MSN#2. If "m0" is given, all numbers are to be displayed.

If the flag 'n' is given, the given number is
.B not
to be displayed.

.TP
.B \-i	incoming
Only incoming connections are displayed.

.TP
.B \-o	outgoing
Only outgoing connections are displayed.

.TP
.B \-u	unknown caller
At the end of the report, all numbers not aliased in callerid.conf or
~/.isdn are displayed. This option is not available when HTML output
is requested.

.TP
.B \-wX	WWW
isdnrep can give its output in HTML format; this is switched on with
this option. Two modes are possible:

.RS
.TP
0
The HTML header is suppressed. Useful if the output is to be included
into an existing page.
.TP
1
A complete HTML page is generated.
.RE

.TP
.B \-sX	format string
The output generated by isdnrep can be modified by specifying the format
of the line generated for each connection. The syntax is similar to that
used by printf. The following parameters are possible (the \fBx\fR where
given means that a width for the field, also known as the precision, must
be given):

.RS
.TP 4
%X
time without date
.br
e.g. 23:54:06
.TP
%x
the date
.br
e.g. 25/07/97
.TP
%y
date without year
.br
e.g. Sun May 04
.TP
%Y
year, in four digits
.br
e.g. 1997
.TP
%D
duration of connection
.br
e.g. 00:03:34
.TP
%\fBx\fRH
the local MSN; if an alias can be found, that will be displayed instead
.TP
%\fBx\fRh
the local MSN, only as a number; no aliases will be substituted
.TP
%\fBx\fRF
the remote number; if an alias can be found, that will be displayed instead
.TP
%\fBx\fRf
the remote number, only as a number; no aliases will be substituted
.TP
%\fBx\fRL
the town corresponding to the local MSN if known; an empty string otherwise
.TP
%\fBx\fRl
the town corresponding to the remote number if known; an empty string otherwise
.TP
%T
an arrow indicating the direction of the connection
("->" outgoing or "<-" incoming);
the local MSN should be displayed on the left side of this.
.TP
%t
an arrow indicating the direction of the connection, reversed
("<-" outgoing or "->" incoming);
the local MSN should be displayed on the right side of this.
.TP
%\fBx\fRu
the charge units, if known
.br
e.g. 6 EH
.TP
%U
the cost, if known
.br
e.g. 2,28 DM
.TP
%I
amount of INPUT data
.TP
%O
amount of OUTPUT data
.TP
%P
INPUT throughput (bps)
.TP
%p
OUTPUT throughput (bps)
.TP
%S
Service Indicator
.TP
%G
displays a HTTP link to the corresponding fax, when a fax was received
by mgetty. This fax can be displayed by using the link in a HTTP browser.
.br
This option is only valid when used with -wx, see below for more information.
.TP
%C
displays a HTTP link to the corresponding voice file, when a call was
recorded by vbox.
This option is only valid when used with -wx, see below for more information.
.RE

.in +7
The default format string for (non-HTML output) is

.in +4
"  %X %D %15.15H %T %-15.15F %7u %U %I %O"
.in -4

With the following string all the important data is displayed while
keeping the total length to 80:

.in +4
"%X%D %10.10H%T%-14.14F%U%I %O"
.in -4

The above string is put into /etc/isdn/isdn.conf at installation as
.B REPFMTSHORT
and can be used with
.B -Fshort.

.in -7
.TP
.B \-FX	format
format strings can be specified in /etc/isdn/isdn.conf; this option
is used to select one of these. Entries can be defined in the
section [ISDNLOG] with names beginning with "REPFMT". The string after
the -F option is added to REPFMT to find the correct entry. Case is
not sensitive. E.g.:

.nf
REPFMT1        = ... # -> isdnrep -F1
REPFMTMYSTRING = ... # -> isdnrep -Fmystring or
                          isdnrep -F MYSTRING
.fi

.SH "HTML USE"
isdnrep can generate a HTML page containing links to files generated
by vbox and mgetty (faxes), so that the messages and faxes can be heard
or seen from within a browser. However, a couple of things need to be
configured first.

.cu
answering machine messages

The %C can be used in the isdnrep output format to make a link to a voice
recording file.
For this to work, the following entry is needed in the [ISDNLOG] section
in isdn.conf:

.nf
    VBOXPATH= /var/spool/vbox/fred/incoming # incoming directory pathname
.fi

Now isdnrep can find the file correctly. Clicking on this link
will cause the file to be sent. These files are in ZyXEL format; the
browser cannot use these directly. The type is given by isdnrep as
follows:

.nf
    Content-Type: application/x-zyxel4
.fi

The correct application (helper) for this has to be configured in the
browser. Alternatively, a conversion program can be specified to isdnrep
which will convert the ZyXEL format. The pathname of the file to convert
is given as a parameter to the program.

In the [ISDNLOG] section of isdn.conf an entry as follows specifies
which conversion program to use:

.nf
    VBOXCMD1 = /usr/bin/program1

for versions 0.x and 1.x of vbox, and

    VBOXCMD2 = /usr/bin/program2
.fi

for versions 2.x of vbox. Both entries can be given, isdnrep recognizes
which version created the recording.

The program must first output a line with the content-type, followed
by the data itself. To convert the ZyXEL format into a WAV file, the
following script may be used:

.in +4
.nf
#! /bin/sh
##
## script to play voice messages from vbox-2.0
##
## WARNING! If the paths are not set correctly,
## netscape may simply crash!

PATH=$PATH:"path to sox":"path to pvftools":"path to vbox"
FILENAME1=/tmp/voxplay.$$.voc
FILENAME2=/tmp/voxplay.$$.wav
VOLUME=8

vboxtoau <$1             | \\
          autopvf        | \\
          pvfamp $VOLUME | \\
          pvfcut 0.20    | \\
                pvftovoc > $FILENAME1

sox $FILENAME1 $FILENAME2

echo Content-Type: audio/x-wav
echo
cat $FILENAME2

rm -f $FILENAME1 $FILENAME2

.fi
.in -4
The script above needs the packages sox and pvftools.
Additionally, the browser needs to be told how to handle "audio/x-wav".
This is done by adding the following lines to the files listed:

.nf
.RS 4
.TP 4
.B ~/.mime.types
type=audio/x-wav    \\
desc="auWAV Audio"  \\
exts="wav"

.TP
.B ~/.mailcap
audio/x-wav;/usr/bin/auplay %s
.RE
.fi

The package NAS (Network Audio System) may be needed.

Now, when the browser is started, it will recognize WAV files and start
the corresponding program to handle these. The WAV format has been chosen
as this can also be played from a Windows pc.


.cu
faxes received by mgetty

When %G is used in the isdnrep output format, any faxes received by mgetty
will be accessible via a HTML link, in the same manner as the ansering
machine messages.

For the faxes the following entry in the [ISDNLOG] section in isdn.conf
is needed:

.nf
    MGETTYPATH = /var/spool/fax/incoming
.fi

WARNING: if isdnrep doesn't have permission to read the files, they
will not be displayed; there will be no error message.

When isdnrep passes these files back to the browser, they have the
G3 format. The following header is used to notify the browser of this:

.nf
    Content-Type: application/x-faxg3
.fi

As the browser probably doesn't understand this format, the following
changes to the files listed are needed:

.nf
.RS 4
.TP 4
.B ~/.mime.types
type=application/x-faxg3  \\
desc="G3-Fax Format"      \\
exts="fax,g3"

.TP
.B ~/.mailcap
pplication/x-faxg3;/usr/X11/bin/g3view %s
.RE
.fi

The program g3view has to be installed for this to work.

If now the link is clicked on, the browser will automatically start
the external g3view to handle this data.

If you prefer another format (instead of G3) such as JPEG, the format
has to be converted. The following entry in the [ISDNLOG] section of
isdn.conf takes care of this:

.nf
VBOXCMD = /usr/bin/g3tojpeg # example
.fi

The script g3tojpeg can be something like this:

.in +4
.nf
#! /bin/sh
##
## command to display faxes in a browser
##
## WARNING! If the paths are not set correctly,
## netscape may simply crash!

export PATH=$PATH:"path to g3topbm":"path to convert"

echo Content-Type: image/jpeg
echo

g3topbm < $1 | convert pbm:- jpeg:-
.fi
.in -4

The packages ImageMagick and mgetty are needed. Mgetty is probably
already installed if you want to use this feature :-)

The advantage of the JPEG format is that it can also be displayed by
a browser running on a Windows pc.

.cu
summary

A suitable value for REPFMTWWW is

.nf
    REPFMTWWW = "%X %D %17.17H %T %-17.17F %-20.20l SI: %S %9u %U %I %O %G %C"
.fi

Netscape 3.0 Gold and Arena have been tested, and both work fine
with isdnrep's HTML output, although Arena's display is not as
colourful as Netscape's.

A known problem (which is impossible to solve completely) is determining
the relationship between an isdn connection and a fax or vbox recording.
Unfortunately the times for isdnrep, mgetty and vbox differ. Isdnrep tries
to make the best guess, but it's always possible that e.g. a fax is
connected to the wrong isdn connection.

.SH "EXAMPLE OUTPUT"
With the default configuration the following output can be generated
on stdout (whitespace slightly edited for clarity):

.nf
.in -4
$ isdnrep -v -t 6/1/96
I S D N  Connection Report  -  Tue Aug 26 22:21:19 1997


Sat Jan  6 1996
  00:54:19                 UNKNOWN -> UNKNOWN     No user responding      \fB(4)\fR
[...]
  16:33:24  0:03:23        UNKNOWN -> UNKNOWN        7 EH      0,84 DM
  17:33:47                 UNKNOWN -> UNKNOWN     Unallocated (unassigned)\fB(5)\fR
                                                  number
  20:02:28  0:02:37     Phone/HDLC <- UNKNOWN                             \fB(1)\fR
  20:09:53  0:07:01     Modem/X.75 -> T-Online       3 EH      0,36 DM    \fB(2)\fR
  21:27:56                 UNKNOWN -> UNKNOWN     User busy               \fB(3)\fR
  22:09:41  0:29:36        UNKNOWN -> UNKNOWN       43 EH      9,89 DM*
======================================================================
  1 IN= 0:02:37,  13 OUT= 3:40:14,   3 failed      210 EH     25,20 DM
\fB(6)\fR^^^^^^^^^^^^  \fB(7)\fR^^^^^^^^^^^^^  \fB(8)\fR^^^^^^^   \fB(9)\fR^^^^^^ \fB(10)\fR^^^^^^^^


DIALOUT Summary for Sat Jan  6 1996                                      \fB(11)\fR
-----------------------------------------------------------
T-Online         1 call(s)  0:07:01     3 EH    0,36 DM
UNKNOWN         11 call(s)  0:17:00    20 EH    2,40 DM


DIALIN Summary for Sat Jan  6 1996                                       \fB(12)\fR
-----------------------------------------------------------
UNKNOWN          1 call(s)  0:02:37


Zone 1 : City              2 call(s)  2:23:13     50 EH    6,00 DM       \fB(13)\fR
Zone x : UNKNOWN          11 call(s)  0:17:00     20 EH    2,40 DM

.fi
.in +4

.B Notes
.RS 1
.TP 5
 (1)
"xxx <- xxx" was an incoming call, so doesn't cost anything
.TP
 (2)
"xxx -> xxx" was an outgoing call lasting 203 seconds, so for City zone,
off-peak time (Saturday), 3 charge units = DM 0,36
.TP
 (3)
there was no connection, as the called party was busy
.TP
 (4)
there was no connection, as the called party didn't pick up the phone
.TP
 (5)
"the number you have dialled is not connected. Hang up and dial again. ..."
.TP
 (6)
total time for incoming calls
.TP
 (7)
total time for outgoing calls
.TP
 (8)
3 calls failed; busy (3), no answer (4) and error in dialing (5)
.TP
 (9)
total charge units incurred for one day
.TP
(10)
total costs incurred for one day
.TP
(11)
outgoing calls grouped per number
.TP
(12)
incoming calls grouped per number
.TP
(13)
outgoing and incoming calls grouped per tariff zone
.RE

If the charge units are marked with "*", the PTT switch did not give
charge info; these are the number of units guestimated by isdnrep.


.SH "TIME FORMAT"
For the -d and -t options, the time is specified in the following formats:

.TP
[DD/][M]M/[[YY]YY]
specifes the month or day.

Examples:

.RS
.TP 10
7/
July of the current year
.TP
8/1996
August 1996
.TP
29/6/95
June 29th 1995
.TP
6/6/
error, is not June 6th of the current year; it's June 1906
.RE

.TP
[D]D
day of current month

.TP
[MM]DD[hhmm[[CC]YY][.ss]]
specifies an exact time. Unspecified parts are defined as 0 when
interpreted as a begin time, and 23 or 59 when interpreted as an
end time.
.br
If a year is to be specified, the hours and minutes
.B must
also be specified.
.br
The format is copied from the date command.

Examples:

.RS
.TP
0107
January 1st in the current year
.TP
0107173196.25
January 7th 1996 17:31:25
.TP
010717311996
January 7th 1996 17:31:00 (or 17:31:59)
.TP
12141995
error: \fBnot\fR December 12th 1995, but December 12th of the current
year at 19:95, so it's garbage.
.RE

.in +7
Examples of time spans and their meaning:

.RS
.TP
6/95-081214381996.25
all entries between June 1st 1995 00:00:00 and August 12th 14:38:25
.TP
0912030495.20-12/95
all entries between September 12th 1995 03:04:20 and December 31st
1995 23:59:59
.TP
7/95
all entries between July 1st 1995 00:00:00 and July 31st 1995 23:59:59
.TP
0908
all entries between September 8th in the current year 00:00:00 and
September 8th in the current year 23:59:59
.TP
3
third day of the current month
.RE

.SH "FILES"
.TP
\fB/var/log/isdn.log\fR or \fB/var/lib/isdn/calls\fR
isdnlog log file with information about all calls.

.TP
\fB/etc/isdn/isdn.conf\fR
general configuration

.TP
\fB/etc/isdn/callerid.conf\fR
aliases for telephone numbers

.SH SEE ALSO
.B isdnlog(5) isdnlog(8)

.SH AUTHOR
This manual page was adapted from isdnlog/README by
Paul Slootman <paul@wurtel.demon.nl>, for Debian GNU/Linux and isdn4linux.
