/***************************************************************************
**    xLabel.cpp  $Revision: 1.4 $ - $Name: V2-05 $ 
**    QLabel
**
**    Copyright (C) 1996 Joseph Croft <jcroft@unicomp.net>
**
**    This library is free software; you can redistribute it and/or
**    modify it under the terms of the GNU Library General Public
**    License as published by the Free Software Foundation; either
**    version 2 of the License, or (at your option) any later version.
**
**    This library is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
**    Library General Public License for more details.
**
**    You should have received a copy of the GNU Library General Public
**    License along with this library; if not, write to the Free
**    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <ctype.h>
#include <stdio.h>
#include "xDefaults.h"
#include "xLabel.h"
#include <qlined.h>

extern xDefaults Defaults;

static int dbg = 0;

xLabel::xLabel(xWidgetResInfo *pPRes, QWidget *pParent, const char *pName) :
        QLabel(pParent, pName)
{
   if (dbg) fprintf(stdout, "xLabel::xLabel():Enter\n");
   wdtRes = new xWidgetResInfo(pPRes, QString(""), QString(""));
   setDefPallet(this, wdtRes);
   setDefFont(this, wdtRes);
   if (dbg) fprintf(stdout, "xLabel::xLabel():Exit\n");
}

xLabel::xLabel(xWidgetResInfo *pPRes, const char *pText, QWidget *pParent,
               const char *pName) :
        QLabel(pText, pParent, pName)
{
   if (dbg) fprintf(stdout, "xLabel::xLabel():Enter\n");
   wdtRes = new xWidgetResInfo(pPRes, QString(""), QString(""));
   setDefPallet(this, wdtRes);
   setDefFont(this, wdtRes);
   if (dbg) fprintf(stdout, "xLabel::xLabel():Exit\n");
}

void xLabel::mousePressEvent(QMouseEvent *pEvt)
{
   xMouseEvent evt(this, pEvt);
   emit mousePressed(&evt);
}

void xLabel::mouseReleaseEvent(QMouseEvent *pEvt)
{
   xMouseEvent evt(this, pEvt);
   emit mouseReleased(&evt);
}

void xLabel::mouseDoubleClickEvent(QMouseEvent *pEvt)
{
   xMouseEvent evt(this, pEvt);
   emit mouseDoubleClicked(&evt);
}

void xLabel::mouseMoveEvent(QMouseEvent *pEvt)
{
   xMouseEvent evt(this, pEvt);
   emit mouseMoved(&evt);
}

#include "xLabel.moc"
