/***************************************************************************
**    xIrcNickActionQuery.cpp  $Revision: 1.5 $ - $Name: V1-17B $ 
**    Dialog box to ask about Private messages
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <stdio.h>
#include <string.h>
#include <qfont.h>
#include "xIrcNickActionQuery.h"

static int dbg = 0;

xIrcNickActionQuery::xIrcNickActionQuery(xWidgetResInfo *pPRes, 
                                         QWidget *pParent, const char *pName) :
               xDialog(wdtRes = new xWidgetResInfo(pPRes, QString("nickactiondialog"),
                                                   QString("NickActionDialog")),
                       pParent, pName)
{
   if (dbg) fprintf(stdout, "xIrcNickActionQuery::xIrcNickActionQuery():Enter\n");
   if (dbg) fflush(stdout);

   setDefPallet(this, wdtRes);
   setDefFont(this, wdtRes);

   setAcceptFocus(TRUE);   
   pNickEdit = new xLineEdit(wdtRes, this);
   pNickEdit->setLabel("Nick:");
   pNickEdit->setMargins(0, 10);
   pChanEdit = new xLineEdit(wdtRes, this);
   pChanEdit->setLabel("Channel:");
   pChanEdit->setMargins(0, 10);
   pButtons = new xPshBtnTable(wdtRes, this);
   pButtons->setFrameStyle(QFrame::Panel | QFrame::Raised);
   pButtons->addButton("Dcc Chat", DccChat);
   pButtons->addButton("WhoIs", WhoIs);
   pButtons->addButton("Ban", Ban);
   pButtons->addButton("Give Ops", GiveOps);
   pButtons->addButton("Ping", Ping);

   pButtons->addButton("Priv Chat", PrivChat);
   pButtons->addButton("WhoWas", WhoWas);
   pButtons->addButton("Kick", Kick);
   pButtons->addButton("Take Ops", TakeOps);
   pButtons->addButton("Who", Who);

   pButtons->addButton("User Info", UserInfo);
   pButtons->addButton("Finger", Finger);
   pButtons->addButton("Time", Time);
   pButtons->addButton("Version", Version);
   pButtons->addButton("Close", Close);

   pButtons->arrangeButtons();
   addWidget(pNickEdit);
   addWidget(pChanEdit);
   addWidget(pButtons);
   setMargins(10, 10);
   setWidgetSpacing(0);
   initFrame();
   connect(pButtons, SIGNAL(clicked(int)), this, SLOT(buttonPressed(int)));
   if (dbg) fprintf(stdout, "xIrcNickActionQuery::xIrcNickActionQuery():Exit\n");
   if (dbg) fflush(stdout);   
}

xIrcNickActionQuery::~xIrcNickActionQuery()
{
   if (dbg) fprintf(stdout, "xIrcNickActionQuery::~xIrcNickActionQuery():Enter\n");
   if (dbg) fflush(stdout);
   if (pNickEdit)
      delete pNickEdit;
   if (pChanEdit)
      delete pChanEdit;
   if (pButtons)
      delete pButtons;
   if (dbg) fprintf(stdout, "xIrcNickActionQuery::~xIrcNickActionQuery():Exit\n");
   if (dbg) fflush(stdout);
}

void xIrcNickActionQuery::wakeUp(xMultiLineTextSelection text)
{
   txtSel = text;
   if (strlen(txtSel.text) > 0)
      pNickEdit->setText(text.text);
   if (strlen(txtSel.winName) > 0)
      pChanEdit->setText(text.winName);
   show();
}

void xIrcNickActionQuery::buttonPressed(int id)
{
   txtSel.text = pNickEdit->text();
   txtSel.winName = pChanEdit->text();
   txtSel.iData = id;
   emit done(txtSel);
}

#include "xIrcNickActionQuery.moc"

